package net.iyouqu.video.app.request;

import com.android.volley.DefaultRetryPolicy;

public class EsRetryPolicy extends DefaultRetryPolicy{

	/** The default socket timeout in milliseconds */
    public static final int DEFAULT_TIMEOUT_MS = 10000;

    /** The default number of retries */
    public static final int DEFAULT_MAX_RETRIES = 0;

    /** The default backoff multiplier */
    public static final float DEFAULT_BACKOFF_MULT = 1f;
    
    public EsRetryPolicy() {
        super(DEFAULT_TIMEOUT_MS, DEFAULT_MAX_RETRIES, DEFAULT_BACKOFF_MULT);
    }
    
    public EsRetryPolicy(int timeOut) {
        super(timeOut, DEFAULT_MAX_RETRIES, DEFAULT_BACKOFF_MULT);
    }
    
    public EsRetryPolicy(int timeOut, int retry) {
        super(timeOut, retry, DEFAULT_BACKOFF_MULT);
    }
}
