package net.iyouqu.video.app.request;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import net.iyouqu.video.app.input.EsencInputStreamHelper;
import net.iyouqu.video.app.input.InputStreamUtils;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.StringRequest;
/**
 * 
 * @ClassName: EsStringRequest 
 * @Description: TODO(String 返回类型请求对象) 
 * @author flood 
 * @date 2015-1-20 下午5:56:00 
 *
 */
public class EsStringRequest extends StringRequest {

	private Priority priority = Priority.NORMAL;
	private Map<String, String> headers = new HashMap<String, String>();
	private Map<String, String> params;

	public EsStringRequest(int method, String url, Listener<String> listener, ErrorListener errorListener,
			boolean shouldCache, Priority priority, EsencInputStreamHelper.EsEncoding esEncoding) {
		super(method, url, listener, errorListener);

		setShouldCache(shouldCache);
		this.priority = Priority.NORMAL;
		if (esEncoding != null) {
			this.headers.put("Accept-Encoding", esEncoding.encoding);
		}

	}

	public EsStringRequest(String url, Map<String, String> params, Listener<String> listener,
			ErrorListener errorListener) {
		this(params == null ? Method.GET : Method.POST, url, listener, errorListener, true, Priority.NORMAL,
				EsencInputStreamHelper.EsEncoding.ESENCGZIP);
		this.params = params;
		setRetryPolicy(new EsRetryPolicy());
	}

	public EsStringRequest(String url, Map<String, String> params, Listener<String> listener,
			ErrorListener errorListener, int timeOut) {
		this(params == null ? Method.GET : Method.POST, url, listener, errorListener, true, Priority.NORMAL,
				EsencInputStreamHelper.EsEncoding.ESENCGZIP);
		this.params = params;
		EsRetryPolicy esRetryPolicy = new EsRetryPolicy(timeOut);

		setRetryPolicy(esRetryPolicy);
	}

	public EsStringRequest(String url, Map<String, String> params, Listener<String> listener,
			ErrorListener errorListener, int timeOut, int retry, boolean isEZip) {
		this(params == null ? Method.GET : Method.POST, url, listener, errorListener, true, Priority.NORMAL,
				isEZip ? EsencInputStreamHelper.EsEncoding.ESENCGZIP : null);
		this.params = params;
		EsRetryPolicy esRetryPolicy = new EsRetryPolicy(timeOut, retry);

		setRetryPolicy(esRetryPolicy);
	}

	@Override
	public String getUrl() {
		return super.getUrl();
	}
	@Override
	public Map<String, String> getParams() throws AuthFailureError {
		return params;
	}

	@Override
	public com.android.volley.Request.Priority getPriority() {
		return priority;
	}

	@Override
	public Map<String, String> getHeaders() throws AuthFailureError {
		return headers;
	}

	// TODO
	@Override
	public RetryPolicy getRetryPolicy() {
		return super.getRetryPolicy();
	}

	// TODO
	@Override
	public String getCacheKey() {
		return super.getCacheKey();
	}

	@Override
	protected Response<String> parseNetworkResponse(NetworkResponse response) {
		String parsed;
		InputStream input = null;
		try {
			input = new ByteArrayInputStream(response.data);
			input = EsencInputStreamHelper.getInputStream(response.headers, input);
			parsed = InputStreamUtils.getString(input, HttpHeaderParser.parseCharset(response.headers));
			return Response.success(parsed, HttpHeaderParser.parseCacheHeaders(response));
		} catch (UnsupportedEncodingException e) {
			return Response.error(new ParseError(e));
		} catch (Exception e) {
			return Response.error(new ParseError(e));
		} finally {
			try {
				if (input != null) {
					input.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}
}
