package net.iyouqu.video.basecommon.config;

import java.util.List;

public abstract class ESConfig {

	private static ESConfig ourInstance;
	
	public static ESConfig Instance(){
		return ourInstance;
	}
	
	protected ESConfig() {
		ourInstance = this;
	}
	
	public abstract List<String> listGroups();
	public abstract List<String> listNames();
	
	public abstract String getValue(String group, String name, String defaultValue);
	public abstract void setValue(String group, String name, String value);
	public abstract void unsetValue(String group, String name);
	public abstract void removeGroup(String name);
}
