package net.iyouqu.video.basecommon.manager;

import android.app.Application;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
/**
 * File Name: EsBeanApplication.java
 * Create by:Bruce on 2014-12-12 下午4:46:02 
 * @version 1.0.0
 */
public class EsBaseApplication extends Application{
	/** 全局Context */
	private static EsBaseApplication mInstance;
	/** 主线程ID */
	private static int mMainThreadId = -1;

	/** 主线程ID */
	private static Thread mMainThread;
	/** 主线程Handler */
	private static Handler mMainThreadHandler;
	/** 主线程Looper */
	private static Looper mMainLooper;

	private static Resources mResources;

	@Override
	public void onCreate() {
		mMainThreadId = android.os.Process.myTid();
		mMainThread = Thread.currentThread();
		mMainThreadHandler = new Handler();
		mMainLooper = getMainLooper();
		mInstance = this;
		super.onCreate();
//		RequestManager.init(this);
//		CacheHelper.getInstance().init(getApplication());
		
//		NetManager.getInstance().registerReceiver();
	}

	public static EsBaseApplication getApplication() {
		return mInstance;
	}

	public static int getMainThreadId() {
		return mMainThreadId;
	}

	public static Thread getMainThread() {
		return mMainThread;
	}

	public static Handler getMainThreadHandler() {
		return mMainThreadHandler;
	}

	public static Looper getMainThreadLooper() {
		return mMainLooper;
	}
}
