package net.iyouqu.video.basecommon.manager;

import java.io.File;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.Thread.UncaughtExceptionHandler;
import java.util.HashSet;
import java.util.Set;

import net.iyouqu.video.basecommon.utils.DateFormattUtils;
import net.iyouqu.video.basecommon.utils.FileUtils;
import net.iyouqu.video.basecommon.utils.LogUtils;
import net.iyouqu.video.basecommon.utils.SystemUtils;
import net.iyouqu.video.basecommon.utils.appinfo.PackageUtils;


import android.content.Context;

/**
 * File Name: EsUncaughtExceptionHandler.java
 * Create by:Bruce on 2014-12-12 下午4:49:26 
 * @version 1.0.0
 */
public class EsUncaughtExceptionHandler implements UncaughtExceptionHandler{
	//==========================================================================
		// 全局变量
		//==========================================================================
		public final static String ERROR_LOG_FILE_NAME = "log.txt";

		private Context mContext;

		//==========================================================================
		// 构造方法
		//==========================================================================
		public EsUncaughtExceptionHandler() {
		}

		//==========================================================================
		// 方法
		//==========================================================================

		/** 如果注册了该handler，那么未捕获的异常都将由该方法处理 */
		@Override
		public void uncaughtException(Thread thread, Throwable ex) {
			handleException(ex);
		}

		/**
		 * 处理异常
		 * @param ex 异常
		 */
		private void handleException(final Throwable ex) {
			if (ex == null) {
				return;
			}
			ThreadManager.getShortPool().execute(new Runnable() {
				@Override
				public void run() {
					try {
						String path = FileUtils.getAppFilesDir();
						RandomAccessFile file = new RandomAccessFile(path + ERROR_LOG_FILE_NAME, "rw");
						if (isExistsException(ex, file)) {
							return;
						}
						StringWriter sw = new StringWriter();
						PrintWriter pw = new PrintWriter(sw);
						ex.printStackTrace(pw);
						// 存储手机系统版本和运行的app版本，以便对不同版本的系统做不同的处理
						StringBuilder builder = new StringBuilder();
						builder.append(getTime());
						builder.append(",");
						builder.append("versionCode=");
						builder.append(PackageUtils.getVersionCode());
						builder.append(",");
						builder.append("sdk=");
						builder.append(SystemUtils.getOSVersionSDKINT());
						builder.append("\n");

						byte[] hashCode = ("#" + (sw.toString().hashCode()) + "\n").getBytes(); // 异常信息hashCode
						byte[] header = builder.toString().getBytes(); // 头信息
						byte[] errInfos = sw.toString().getBytes(); // 异常信息
						byte[] skipLen = ("*" + (header.length + errInfos.length) + "\n").getBytes(); // 需要跳过的字节数,用于检索

						long fileLen = file.length();
						file.setLength(fileLen + hashCode.length + skipLen.length + header.length + errInfos.length);
						file.seek(fileLen);

						file.write(hashCode); // 第一行存储 hashCode
						file.write(skipLen); // 第二行存储异常信息长度
						file.write(header); // 存储头信息
						file.write(errInfos); // 存储异常信息正文
					} catch (Exception e) {
						LogUtils.e(e);
					} finally {
						android.os.Process.killProcess(android.os.Process.myPid());
					}
				}
			});
		}

		//

		/** 检测文件是否已经存在需要存储的异常信息，避免重复存储 */
		private boolean isExistsException(Throwable ex, RandomAccessFile file) {
			try {
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
				ex.printStackTrace(pw);
				int hashCode = sw.toString().hashCode();
				String value;
				while (null != (value = file.readLine())) {
					if (value.startsWith("*")) {
						value = value.replace("*", "");
						int len = Integer.parseInt(value);
						file.skipBytes(len);
						continue;
					}
					value = value.replace("#", "");
					if (Integer.parseInt(value) == hashCode) {
						return true;
					}
				}
			} catch (Exception e) {
				LogUtils.e(e);
			}
			return false;
		}

		private String getTime() {
			return DateFormattUtils.formatDate("yyyy-MM-dd HH:mm:ss", System.currentTimeMillis());
		}

		/** 获取已经存储的异常信息 */
		public static String getExceptionLog(Context context) {
			StringBuilder builder = new StringBuilder();
			Set<String> set = new HashSet<String>();
			if (FileUtils.isSDcardExist()) {// SD卡上log
				File file = new File(FileUtils.getAppFilesDir() + ERROR_LOG_FILE_NAME);
				if (file.exists()) {
					try {
						RandomAccessFile rf = new RandomAccessFile(file, "r");
						String temp;
						while (null != (temp = rf.readLine())) {
							if (temp.startsWith("#") || temp.startsWith("*")) {
								if (temp.startsWith("#")) {
									set.add(temp.replace("#", ""));
								}
								continue;
							}
							builder.append(temp);
							builder.append("\n");
						}
						rf.close();
					} catch (Exception e) {
						LogUtils.e(e);
					}
				}
			}
			File file = new File(FileUtils.getAppFilesDirByData() + ERROR_LOG_FILE_NAME);
			if (file.exists()) {
				try {
					RandomAccessFile rf = new RandomAccessFile(file, "r");
					String temp;
					boolean isSkip = false;
					while (null != (temp = rf.readLine())) {
						if (temp.startsWith("*")) {
							if (isSkip) {
								isSkip = false;
								rf.skipBytes(Integer.parseInt(temp.replace("*", "")));
								continue;
							}
						}
						if (set.contains(temp.replace("#", ""))) { // 过滤掉重复
							isSkip = true;
							continue;
						}
						if (!temp.startsWith("#") && !temp.startsWith("*")) {
							builder.append(temp);
							builder.append("\n");
						}
					}
					rf.close();
				} catch (Exception e) {
					LogUtils.e(e);
				}
			}
			return builder.toString();
		}

		/** 删除异常文件 */
		public static void deleteExceptionFile(Context context) {
			if (FileUtils.isSDcardExist()) {// SD卡上log
				FileUtils.deleteFile(FileUtils.getAppFilesDir() + ERROR_LOG_FILE_NAME);
			}
			FileUtils.deleteFile(FileUtils.getAppFilesDirByData() + ERROR_LOG_FILE_NAME);
		}
}
