package net.iyouqu.video.basecommon.option;

import net.iyouqu.video.basecommon.config.ESConfig;

public class ESOption {

	public static final String PLATFORM_GROUP = "PlatformOption";

	private final String myGroup;
	private final String myOptionName;
	protected boolean myIsSynchronized;

	protected ESOption(String myGroup, String myOptionName) {
		super();
		this.myGroup = myGroup;
		this.myOptionName = myOptionName;
		this.myIsSynchronized = false;
	}

	protected final String getConfigValue(String defaultValue) {
		ESConfig config = ESConfig.Instance();
		return (config != null) ? config.getValue(myGroup, myOptionName, defaultValue) : defaultValue;
	}
	
	protected final void setConfigValue(String value) {
		ESConfig config = ESConfig.Instance();
		if (config != null) {
			config.setValue(myGroup, myOptionName, value);
		}
	}
	
	protected final void unsetConfigValue() {
		ESConfig config = ESConfig.Instance();
		if (config != null) {
			config.unsetValue(myGroup, myOptionName);
		}
	}
}
