package net.iyouqu.video.basecommon.task;

import net.iyouqu.video.basecommon.manager.ThreadManager;
import net.iyouqu.video.basecommon.utils.ui.UIUtils;


/**
 * File Name: BaseTask.java
 * Create by:Bruce on 2014-12-12 下午4:38:25 
 * @version 1.0.0
 */
public abstract class BaseTask implements Runnable {
	@Override
	public void run() {
		doInAsyncThread();
		UIUtils.post(new Runnable() {
			@Override
			public void run() {
				doInUiThread();
			}
		});
	}

	public void executeLongTask() {
		ThreadManager.getLongPool().execute(this);
	}
	
	public void executeShortTask(){
		ThreadManager.getShortPool().execute(this);
	}
	
	public void executeSingleTask(){
		ThreadManager.getSinglePool().execute(this);
	}
	
	public void executeSingleTask(String threadName){
		ThreadManager.getSinglePoll(threadName).execute(this);
	}

	protected abstract void  doInAsyncThread() ;
		



	protected abstract void doInUiThread() ;

}
