package net.iyouqu.video.basecommon.ui.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AbsListView.OnScrollListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.android.volley.AuthFailureError;
import com.android.volley.RequestQueue;
import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.VolleyError;

import net.iyouqu.R;
import net.iyouqu.video.app.data.VolleyInterface;
import net.iyouqu.video.app.request.EsStringRequest;
import net.iyouqu.video.app.request.RequestManager;
import net.iyouqu.video.basecommon.bean.Entity;
import net.iyouqu.video.basecommon.bean.MessageData;
import net.iyouqu.video.basecommon.bean.PageList;
import net.iyouqu.video.basecommon.common.DataRequestThreadHandler;
import net.iyouqu.video.basecommon.config.Constant;

import java.util.ArrayList;
import java.util.List;

/**
 * 说明 下拉刷新界面的基类
 *
 * @author flood
 */
public abstract class BaseSwipeRefreshFragment<Data extends Entity, Result extends PageList<Data>> extends EsBaseFragment
		implements android.support.v4.widget.SwipeRefreshLayout.OnRefreshListener, OnItemClickListener, OnScrollListener {

	// 没有状态
	public static final int LISTVIEW_ACTION_NONE = -1;
	// 更新状态，不显示toast
	public static final int LISTVIEW_ACTION_UPDATE = 0;
	// 初始化时，加载缓存状态
	public static final int LISTVIEW_ACTION_INIT = 1;
	// 刷新状态，显示toast
	public static final int LISTVIEW_ACTION_REFRESH = 2;
	// 下拉到底部时，获取下一页的状态
	public static final int LISTVIEW_ACTION_SCROLL = 3;

	static final int STATE_NONE = -1;
	static final int STATE_LOADING = 0;
	static final int STATE_LOADED = 1;

	protected RelativeLayout base_swiperefresh_contain;
//	protected SwipeRefreshLayout mSwipeRefreshLayout;
	protected android.support.v4.widget.SwipeRefreshLayout mSwipeRefreshLayout;
	protected ListView mListView;
	public RecyclerView mRecyclerView;
	private View mHeaderView;
	private View mFooterView;
	private BaseAdapter mAdapter;
	private ProgressBar mLoading;
	protected View mEmpty;
	private ImageView mEmptyImage;// 图像
	private TextView mEmptyMessage;// 消息文字

	private View mFooterProgressBar;
	private TextView mFooterTextView;

	private List<Data> mDataList = new ArrayList<Data>();
	// 当前页面已加载的数据总和
	private int mSumData;

	// 当前加载状态
	private int mState = STATE_NONE;
	// UI状态
	private int mListViewAction = LISTVIEW_ACTION_NONE;

	// 当前数据状态，如果是已经全部加载，则不再执行滚动到底部就加载的情况
	private int mMessageState = MessageData.MESSAGE_STATE_MORE;
	private boolean isPauseLife = true;
	private int pageSize = -1;
	private boolean isShowEmptyView;
//	private boolean isShowFootView;
	private boolean onlyLoadLocalData = false;

	private DataRequestThreadHandler mRequestThreadHandler = new DataRequestThreadHandler();
	private VolleyInterface volleyInterface;

	@Override
	public void onAttach(Activity activity) {
		super.onAttach(activity);
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		mAdapter = getAdapter(mDataList);
	}

	@Override
	public void onPause() {
		super.onPause();
		isPauseLife = true;
	}

	@Override
	public void onResume() {
		super.onResume();
		isPauseLife = false;
	}

	@Override
	public void onActivityCreated(Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		mRequestThreadHandler.quit();
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		mHeaderView = getHeaderView(inflater);
		mFooterView = inflater.inflate(R.layout.listview_footer, null);
//		mFooterView.setVisibility(View.GONE);
		mFooterProgressBar = mFooterView.findViewById(R.id.listview_foot_progress);
		mFooterTextView = (TextView) mFooterView.findViewById(R.id.listview_foot_more);

		return inflater.inflate(R.layout.fragment_base_swiperefresh, container, false);
	}

	@Override
	public void onViewCreated(View view, Bundle savedInstanceState) {
		initView(view);
		setupListView();

		// viewpager划动到第三页，会将第一页的界面销毁，这里判断是初始状态，还是划画后再次加载
		if (mState == STATE_LOADED && mAdapter.isEmpty()) {
			setFooterNoMoreState();
		} else if (mState == STATE_LOADED && mAdapter.getCount() < (pageSize == -1 ? Constant.PAGE_SIZE : pageSize)) {
			setFooterFullState();
		}
		// 正在刷新的状态
		if (mListViewAction == LISTVIEW_ACTION_REFRESH) {
			setSwipeRefreshLoadingState();
		}
		loadList(1, LISTVIEW_ACTION_INIT);
		initListener();
		loadData();
	}

	private void initView(View view) {
		base_swiperefresh_contain = (RelativeLayout) view.findViewById(R.id.base_swiperefresh_contain);
		mSwipeRefreshLayout = (android.support.v4.widget.SwipeRefreshLayout) view.findViewById(R.id.fragment_swiperefreshlayout);
		mListView = (ListView) view.findViewById(R.id.fragment_listview);
		mSwipeRefreshLayout.setOnRefreshListener(this);
//		mSwipeRefreshLayout.setColorScheme(R.color.swiperefresh_color1, R.color.swiperefresh_color2,
//				R.color.swiperefresh_color3, R.color.swiperefresh_color4);
		mSwipeRefreshLayout.setColorSchemeResources(R.color.swiperefresh_color1,
                R.color.swiperefresh_color2, R.color.swiperefresh_color3,
                R.color.swiperefresh_color4);
		mLoading = (ProgressBar) view.findViewById(R.id.fragment_swiperefresh_loading);
		mEmpty = view.findViewById(R.id.fragment_swiperefresh_empty);
		mEmptyImage = (ImageView) mEmpty.findViewById(R.id.data_empty_image);
		mEmptyMessage = (TextView) mEmpty.findViewById(R.id.data_empty_message);

//		mRecyclerView = (RecyclerView)view.findViewById(R.id.recycler_view);
		doneInitView(view);
	}

	public void resetLoadList(){
		loadList(1, LISTVIEW_ACTION_INIT);
	}

	protected void showEmptyView(boolean show) {
		isShowEmptyView = show;
	}

	protected void changeFootViewBg(int r) {
		if (mFooterView != null) {
			mFooterView.setBackgroundResource(r);
		}
	}
	/**
	 * @Title: setSwipeRefreshLayoutEnable
	 * @Description: TODO(是否禁止下拉刷新)
	 * @author: Bruce
	 * @param isEnable void
	 */
	public void setSwipeRefreshLayoutEnable(boolean isEnable){
		if(mSwipeRefreshLayout != null){
			mSwipeRefreshLayout.setEnabled(isEnable);
		}

	}

	public void setOnlyLoadLocalData(boolean onlyLoadLocalData) {
		this.onlyLoadLocalData = onlyLoadLocalData;
	}

	public void setShowFootView(boolean isShowFootView) {
//		this.isShowFootView = isShowFootView;
	}

	protected void doneInitView(View view) {

	}

	/** 设置列表空数据时的显示信息 */
	public void setEmptyInfo(int imageResId, int messageResId) {
		mEmptyImage.setBackgroundResource(imageResId);
		mEmptyMessage.setText(messageResId);
	}

	/**
	 * 设置每页的容量，不设置取Constant.PAGE_SIZE默认值
	 *
	 * @param pageSize
	 */
	protected void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	@Override
	public void setUserVisibleHint(boolean isVisibleToUser) {
		super.setUserVisibleHint(isVisibleToUser);
	}

	/** 获取HeaderView */
	protected View getHeaderView(LayoutInflater inflater) {
		return null;
	}

	/** 初始化ListView */
	protected void setupListView() {
		mListView.setOnScrollListener(this);
		mListView.setOnItemClickListener(this);
//		if (isShowFootView) {
			mListView.addFooterView(mFooterView);
//		}


		if (mHeaderView != null) {
			mListView.addHeaderView(mHeaderView);
		}
		mListView.setAdapter(mAdapter);

		mRecyclerView.setOnScrollListener(new RecyclerView.OnScrollListener() {
			@Override
			public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
				super.onScrolled(recyclerView, dx, dy);
				// 判断是否滚动到底部
				boolean scrollEnd = false;
				if(mRecyclerView.getLayoutManager() instanceof LinearLayoutManager){
					int lastVisiblieItem = ((LinearLayoutManager) mRecyclerView.getLayoutManager()).findLastVisibleItemPosition();
					int totalItemCount = mAdapter.getCount();
					if(lastVisiblieItem >= totalItemCount - 1 && dy > 0){
						scrollEnd = true;
					}
				}
				if(scrollEnd){
					onLoadNextPage();
				}
//				if (mAdapter == null || mAdapter.getCount() == 0) {
//					return;
//				}
//				// 数据已经全部加载，或数据为空时，或正在加载，不处理滚动事件
//				if (mMessageState == MessageData.MESSAGE_STATE_FULL || mMessageState == MessageData.MESSAGE_STATE_EMPTY
//						|| mState == STATE_LOADING) {
//					return;
//				}
//				// 判断是否滚动到底部
//				boolean scrollEnd = false;
//				try {
//					if (recyclerView.getPositionForView(mFooterView) == view.getLastVisiblePosition())
//						scrollEnd = true;
//				} catch (Exception e) {
//					scrollEnd = false;
//				}
//
//				if (scrollEnd) {
//					onLoadNextPage();
//				}
			}

			@Override
			public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
				super.onScrollStateChanged(recyclerView, newState);
			}
		});
	}

	/** 获取适配器 */
	public abstract BaseAdapter getAdapter(List<Data> list);

	/** 异步加载数据 */
	protected abstract MessageData<Result> asyncLoadList(int page, boolean reflash);

	@Override
	public void onRefresh() {
		loadList(1, LISTVIEW_ACTION_REFRESH);
	}

	/** 更新数据，不显示toast */
	public void update() {
		loadList(1, LISTVIEW_ACTION_UPDATE);
	}

	/** 返回是否正在加载 */
	public boolean isLoadding() {
		return mState == STATE_LOADING;
	}

	/** 加载下一页 */
	protected void onLoadNextPage() {
		// 当前pageIndex
		int pageIndex = mSumData / (pageSize == -1 ? Constant.PAGE_SIZE : pageSize) + 1;
		loadList(pageIndex, LISTVIEW_ACTION_SCROLL);
	}

	/**
	 * 加载数据
	 *
	 * @param page
	 *            页码
	 * @param action
	 *            加载的触发事件
	 * */
	void loadList(int page, int action) {
		if (onlyLoadLocalData) {
			onPostExecuteEvent(parserResponse(null), page, action);
		}else {
			mListViewAction = action;
//			mRequestThreadHandler.request(page, new AsyncDataHandler(page, action));
			AnsysHttp(page, action);
		}

	}

	/** 设置顶部正在加载的状态 */
	void setSwipeRefreshLoadingState() {
		if (mSwipeRefreshLayout != null) {
			mSwipeRefreshLayout.setRefreshing(true);
			// 防止多次重复刷新
			mSwipeRefreshLayout.setEnabled(false);
		}
		onRefreshLoadingStatus();
	}

	protected void showListView() {
		mSwipeRefreshLayout.setVisibility(View.VISIBLE);
		mLoading.setVisibility(View.GONE);
	}

	/** 设置顶部加载完毕的状态 */
	protected void setSwipeRefreshLoadedState() {
		if (mSwipeRefreshLayout != null) {
			mSwipeRefreshLayout.setRefreshing(false);
			mSwipeRefreshLayout.setEnabled(true);
		}
		onRefreshLoadedStatus();
	}

	/** 设置底部有错误的状态 */
	void setFooterErrorState() {
		if (mFooterView != null) {
			mFooterProgressBar.setVisibility(View.GONE);
			mFooterTextView.setText(R.string.load_error);
		}
	}

	/** 设置底部有更多数据的状态 */
	void setFooterHasMoreState() {
		if (mFooterView != null) {
			mFooterProgressBar.setVisibility(View.GONE);
			mFooterTextView.setText(R.string.load_more);
		}
	}

	/** 设置底部已加载全部的状态 */
	void setFooterFullState() {
		if (mFooterView != null) {
			mFooterProgressBar.setVisibility(View.GONE);
			mFooterTextView.setText(R.string.load_full);
		}
	}

	/** 设置底部无数据的状态 */
	void setFooterNoMoreState() {
		if (mFooterView != null) {
			mFooterProgressBar.setVisibility(View.GONE);
			mFooterTextView.setText(R.string.load_empty);
		}
	}

	/** 设置底部加载中的状态 */
	void setFooterLoadingState() {
		if (mFooterView != null) {
			mFooterProgressBar.setVisibility(View.VISIBLE);
			mFooterTextView.setText(R.string.load_ing);
		}
	}

	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
		// 点击了底部
		if (view == mFooterView) {
			return;
		}
		// 点击了顶部
		if (mHeaderView == view) {
			return;
		}
		if (mHeaderView != null) {
			position = position - 1;
		}
		Data data = getData(position);
		onItemClick(position, data);
	}

	/** 点击了某个item */
	public void onItemClick(int position, Data data) {
	}

	/** 正在加载的状态 */
	public void onRefreshLoadingStatus() {
	}

	/** 加载完毕的状态 */
	public void onRefreshLoadedStatus() {
	}

	/**
	 * 返回某项的数据
	 *
	 * @param position
	 *            数据位置
	 * */
	public Data getData(int position) {
		return mDataList.get(position);
	}

	public void beforeLoading(int action) {
		// 开始加载
		mState = STATE_LOADING;
		if (action == LISTVIEW_ACTION_REFRESH) {
			setSwipeRefreshLoadingState();
		} else if (action == LISTVIEW_ACTION_SCROLL) {
			setFooterLoadingState();
		}
	}

	public void afterLoading() {

	}

	@Override
	public void onScrollStateChanged(AbsListView view, int scrollState) {
		if (mAdapter == null || mAdapter.getCount() == 0) {
			return;
		}
		// 数据已经全部加载，或数据为空时，或正在加载，不处理滚动事件
		if (mMessageState == MessageData.MESSAGE_STATE_FULL || mMessageState == MessageData.MESSAGE_STATE_EMPTY
				|| mState == STATE_LOADING) {
			return;
		}
		// 判断是否滚动到底部
		boolean scrollEnd = false;
		try {
			if (view.getPositionForView(mFooterView) == view.getLastVisiblePosition())
				scrollEnd = true;
		} catch (Exception e) {
			scrollEnd = false;
		}

		if (scrollEnd) {
			onLoadNextPage();
		}
	}

	@Override
	public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
	}

	protected void requestData(final int tag) {
		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				if (volleyInterface != null) {
					volleyInterface.parserResponse(response, tag);

//					setSwipeRefreshLoadedState();
				}
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				if (volleyInterface != null) {
					volleyInterface.parserVolleyError(error, tag);

//					setSwipeRefreshLoadedState();
				}

			}
		};

		EsStringRequest request = null;
		if (volleyInterface != null) {
			request = volleyInterface.getRequest(true, listener, errorListener, tag);
		}

		if (request == null) {
			return;
		}
		try {
			if (request.getParams() == null && request.getUrl() != null) {
				request.setTag(request.getUrl());
				queue.cancelAll(request.getUrl());
			}
		} catch (AuthFailureError e) {
			e.printStackTrace();
		}
		queue.add(request);
	}

	private void AnsysHttp(final int page, final int action) {

		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				onPostExecuteEvent(parserResponse(response), page, action);
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				afterLoading();
				mEmpty.setVisibility(View.GONE);
				// 加载结束
				mState = STATE_LOADED;
				if (action == LISTVIEW_ACTION_INIT) {
					mSwipeRefreshLayout.setVisibility(View.VISIBLE);
					mLoading.setVisibility(View.GONE);
				}
				setFooterErrorState();
				parserVolleyError(error);
			}
		};

		boolean refresh = true;
		if (action == LISTVIEW_ACTION_INIT) {
			refresh = false;
		}
		onPreExecute(action);
		EsStringRequest request = getRequest(page, refresh, listener, errorListener);
		if (request == null) {
			return;
		}
		try {
			if (request.getParams() == null && request.getUrl() != null) {
				request.setTag(request.getUrl());
				queue.cancelAll(request.getUrl());
			}
		} catch (AuthFailureError e) {
			e.printStackTrace();
		}
		queue.add(request);
	}

	/**
	 * 合成Request对象
	 *
	 * @param page
	 * @param reflash
	 * @param listener
	 * @param errorListener
	 * @return
	 */
	protected abstract EsStringRequest getRequest(int page, boolean reflash, Listener<String> listener,
			ErrorListener errorListener);

	/**
	 * 解析并返回想要的数据格式
	 *
	 * @param response
	 * @return
	 */
	protected abstract MessageData<Result> parserResponse(String response);

	/**
	 * 处理网络错误
	 *
	 * @param error
	 */
	protected abstract void parserVolleyError(VolleyError error);

	private void onPreExecute(int mAction) {
		beforeLoading(mAction);
	}

	private void onPostExecuteEvent(MessageData<Result> msg, int mPage, int mAction) {
		afterLoading();
		mEmpty.setVisibility(View.GONE);
		// 加载结束
		mState = STATE_LOADED;
		if (mAction == LISTVIEW_ACTION_INIT) {
			mSwipeRefreshLayout.setVisibility(View.VISIBLE);
			mLoading.setVisibility(View.GONE);
		}

		// 如果动作是下拉刷新，则将刷新中的状态去掉
		if (mAction == LISTVIEW_ACTION_REFRESH) {
			setSwipeRefreshLoadedState();
		}
		// 更新全局的状态
		if (mListViewAction == mAction) {
			mListViewAction = LISTVIEW_ACTION_NONE;
		}
		if (msg == null) {
			if (mPage == 1) {
				clearData();
			}
			return;
		}

		// 无数据的情况下(已经加载全部数据，与一开始没有数据)
		if (msg.state == MessageData.MESSAGE_STATE_EMPTY && mDataList.size() != 0) {
			msg.state = MessageData.MESSAGE_STATE_FULL;
		}
		if (msg.result != null && msg.result.getList().size() == 0) {
			msg.state = MessageData.MESSAGE_STATE_EMPTY;
		}
		// 记录最后的数据状态
		mMessageState = msg.state;

		if (msg.state == MessageData.MESSAGE_STATE_EMPTY) {
			// 底部显示“暂无数据”
			setFooterNoMoreState();
			mListView.removeFooterView(mFooterView);
			if (isShowEmptyView && mDataList.isEmpty()) {
				mEmpty.setVisibility(View.VISIBLE);
			}
			if (mPage == 1) {
				clearData();
			}
			return;
		} else if (msg.state == MessageData.MESSAGE_STATE_ERROR) {
			setFooterErrorState();
			if (mPage == 1) {
				clearData();
			}
			return;
		} else if (msg.state == MessageData.MESSAGE_STATE_FULL) {
			// 当页数少于要求的加载页数的时，可以判断是已经加载完，没有更多的数据
			setFooterFullState();
		} else if (msg.state == MessageData.MESSAGE_STATE_MORE) {
			// 有数据的情况下，底部显示“正在加载...”
			setFooterHasMoreState();
		}

		Result result = msg.result;
		if (mPage == 1) {
			int newdata = 0;
			mSumData = result.getPageSize();
			if (mAction == LISTVIEW_ACTION_REFRESH || mAction == LISTVIEW_ACTION_UPDATE) {
				if (mDataList.size() > 0) {
					// 计算新增数据条数
					for (Data data1 : result.getList()) {
						newdata++;
					}
				} else {
					newdata = result.getPageSize();
				}
				if (mAction == LISTVIEW_ACTION_REFRESH && !isPauseLife) {
					// 提示新添加的数据条数
//					if (newdata > 0) {
//						NewDataToast.makeText(getActivity(), getString(R.string.new_data_toast_message, newdata),
//								Constant.isAppSound).show();
//					} else {
//						NewDataToast.makeText(getActivity(), getString(R.string.new_data_toast_none), false).show();
//					}
				}
			}
			// 先清除原有数据
			mDataList.clear();
			// 加入最新的数据
			mDataList.addAll(result.getList());

		} else {
			mSumData += result.getPageSize();
			if (mDataList.size() > 0) {
				for (Data data1 : result.getList()) {
					mDataList.add(data1);
				}
			} else {
				// 加入新增的数据
				mDataList.addAll(result.getList());
			}
		}
		// 通知listview去刷新界面
		mAdapter.notifyDataSetChanged();
	}

	// 加载数据
	private class AsyncDataHandler implements DataRequestThreadHandler.AsyncDataHandler<MessageData<Result>> {

		private int mPage;
		private int mAction;

		AsyncDataHandler(int page, int action) {
			mAction = action;
			mPage = page;
		}

		@Override
		public void onPreExecute() {
			beforeLoading(mAction);
		}

		@Override
		public MessageData<Result> execute() {
			boolean refresh = true;
			if (mAction == LISTVIEW_ACTION_INIT) {
				refresh = false;
			}
			return asyncLoadList(mPage, refresh);
		}

		@Override
		public void onPostExecute(MessageData<Result> msg) {
			onPostExecuteEvent(msg, mPage, mAction);
		}
	}

	public void setVolleyInterface(VolleyInterface volleyInterface) {
		this.volleyInterface = volleyInterface;
	}

	// 清空数据
	public void clearData() {
		mDataList.clear();
		mAdapter.notifyDataSetChanged();
	}
}