package net.iyouqu.video.basecommon.ui.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

/**
 * File Name: EsBaseFragment.java Create by:Bruce on 2014-12-12 下午5:40:00
 * 
 * @version 1.0.0
 */
public abstract class EsBaseFragment extends Fragment {
	private long mainTid = Looper.getMainLooper().getThread().getId();

	/** handler */
	private Handler mHandler = new Handler(Looper.getMainLooper()) {
		@Override
		public void handleMessage(Message msg) {
			onHandleMessage(msg);
		}
	};

	/** 内置handler处理到某个消息时，该方法被回调。子类实现该方法以定义对消息的处理。 */
	protected void onHandleMessage(Message msg) {

	}

	/**
	 * 向内置handler的消息队列中增加一个任务。该任务会在将来的某一时刻在UI线程执行。
	 * 
	 * @param r
	 *            任务
	 */
	public boolean post(Runnable r) {
		return mHandler.post(r);
	}

	/**
	 * 向内置handler的消息队列中增加一个任务。该任务会在指定延时后的某一时刻在UI线程执行。
	 * 
	 * @param r
	 *            任务
	 * @param delayMillis
	 *            延时的毫秒数
	 */
	public boolean postDelayed(Runnable r, long delayMillis) {
		return mHandler.postDelayed(r, delayMillis);
	}

	/** 向内置handler发送消息。 */
	public void sendMessage(int what) {
		mHandler.sendEmptyMessage(what);
	}

	/** 向内置handler发送消息。 */
	public void sendMessage(int what, Object obj) {
		mHandler.obtainMessage(what, obj).sendToTarget();
	}

	/** 向内置handler发送消息。 */
	public void sendMessage(int what, int arg1, int arg2) {
		mHandler.obtainMessage(what, arg1, arg2).sendToTarget();
	}

	/** 向内置handler发送消息。 */
	public void sendMessage(int what, int arg1, int arg2, Object obj) {
		mHandler.obtainMessage(what, arg1, arg2, obj).sendToTarget();
	}

	/** 从队列中移除回调 */
	public void removeCallback(Runnable r) {
		mHandler.removeCallbacks(r);
	}

	/**
	 * 根据指定的layout索引，创建一个View
	 * 
	 * @param resId
	 *            指定的layout索引
	 * @return 新的View
	 */
	public View inflate(int resId) {
		LayoutInflater inflater = LayoutInflater.from(getActivity());
		return inflater.inflate(resId, null);
	}

	/**
	 * 对toast的简易封装。线程安全，可以在非UI线程调用。
	 * 
	 * @param resId
	 *            Toast内容的资源id
	 * @param duration
	 *            Toast的持续时间
	 */
	public void showToastSafe(final int resId, final int duration) {
		if (Process.myTid() == mainTid) {
			// 调用在UI线程
			Toast.makeText(getActivity(), resId, duration).show();
		} else {
			// 调用在非UI线程
			post(new Runnable() {
				@Override
				public void run() {
					Toast.makeText(getActivity(), resId, duration).show();
				}
			});
		}
	}

	/**
	 * 对toast的简易封装。线程安全，可以在非UI线程调用。
	 * 
	 * @param text
	 *            Toast内容
	 * @param duration
	 *            Toast的持续时间
	 */
	public void showToastSafe(final CharSequence text, final int duration) {
		if (Process.myTid() == mainTid) {
			// 调用在UI线程
			Toast.makeText(getActivity(), text, duration).show();
		} else {
			// 调用在非UI线程
			post(new Runnable() {
				@Override
				public void run() {
					Toast.makeText(getActivity(), text, duration).show();
				}
			});
		}
	}

	/** 线程安全的刷新UI方法，如果没有特殊需求，请使用该方法，而不要使用refreshView */
	public void refreshViewSafe() {
		if (Process.myTid() == mainTid) {
			// 调用在UI线程
			refreshView();
		} else {
			// 调用在非UI线程
			post(new Runnable() {
				@Override
				public void run() {
					refreshView();
				}
			});
		}
	}

	@Override
	public void onAttach(Activity activity) {
		super.onAttach(activity);
		init();
	}

	@Override
	public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
		return initLayout(inflater, container, savedInstanceState);
	}

	@Override
	public void onViewCreated(View view, Bundle savedInstanceState) {
		super.onViewCreated(view, savedInstanceState);
		initListener();
		loadData();
	}

	@Override
	public void onActivityCreated(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	protected void init(){};

	protected View initLayout(LayoutInflater inflater, @Nullable ViewGroup container,
			@Nullable Bundle savedInstanceState){
		return null;
	};

	protected void loadData(){};

	protected void refreshView(){};
	
	protected void initListener(){};
}
