package net.iyouqu.video.basecommon.ui.fragment;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.android.volley.AuthFailureError;
import com.android.volley.RequestQueue;
import com.android.volley.Response.ErrorListener;
import com.android.volley.Response.Listener;
import com.android.volley.VolleyError;

import net.iyouqu.R;
import net.iyouqu.video.app.data.VolleyInterface;
import net.iyouqu.video.app.request.EsStringRequest;
import net.iyouqu.video.app.request.RequestManager;

import java.util.ArrayList;
import java.util.List;

public abstract class EsBaseSwipeOnlyRefreshFragment<Data> extends EsBaseFragment implements
android.support.v4.widget.SwipeRefreshLayout.OnRefreshListener, OnItemClickListener {
//	protected SwipeRefreshLayout mSwipeRefreshLayout;
	protected android.support.v4.widget.SwipeRefreshLayout mSwipeRefreshLayout;
	protected ListView mListView;
//	public RecyclerView mRecyclerView;
	private View mHeaderView;

	private BaseAdapter mAdapter;
	private ProgressBar mLoading;
	private View mEmpty;
	private ImageView mEmptyImage;// 图像
	private TextView mEmptyMessage;// 消息文字
	private VolleyInterface volleyInterface;

	private List<Data> mDataList = new ArrayList<Data>();

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		init();
		mAdapter = getAdapter(mDataList);
	}
	protected abstract void init();
	@Override
	public void onPause() {
		super.onPause();
	}

	@Override
	public void onResume() {
		super.onResume();
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		mHeaderView = getHeaderView(inflater);
		View view = inflater.inflate(R.layout.fragment_base_swiperefresh, null);
		initView(view);
		setupListView();
		Log.e("onCreateView", "onCreateView");
		loadData();
		return view;
	}

	@Override
	public void onViewCreated(View view, Bundle savedInstanceState) {
		
	}
	
	protected abstract void loadData();

	private void initView(View view) {
		mSwipeRefreshLayout = (android.support.v4.widget.SwipeRefreshLayout) view.findViewById(R.id.fragment_swiperefreshlayout);
		mListView = (ListView) view.findViewById(R.id.fragment_listview);

		mSwipeRefreshLayout.setOnRefreshListener(this);
//		mSwipeRefreshLayout.setColorScheme(R.color.swiperefresh_color1, R.color.swiperefresh_color2,
//				R.color.swiperefresh_color3, R.color.swiperefresh_color4);
		
		mSwipeRefreshLayout.setColorSchemeResources(R.color.swiperefresh_color1,
                R.color.swiperefresh_color2, R.color.swiperefresh_color3,
                R.color.swiperefresh_color4);
		
		mLoading = (ProgressBar) view.findViewById(R.id.fragment_swiperefresh_loading);
		mEmpty = view.findViewById(R.id.fragment_swiperefresh_empty);
		mEmptyImage = (ImageView) mEmpty.findViewById(R.id.data_empty_image);
		mEmptyMessage = (TextView) mEmpty.findViewById(R.id.data_empty_message);
		
		mSwipeRefreshLayout.setVisibility(View.VISIBLE);
		mLoading.setVisibility(View.GONE);
		doneInitView(view);
	}
	@Override
	public void onRefresh() {
		loadData();
	}
	protected void doneInitView(View view) {

	}
	
	
	/** 设置顶部正在加载的状态 */
	void setSwipeRefreshLoadingState() {
		if (mSwipeRefreshLayout != null) {
			mSwipeRefreshLayout.setRefreshing(true);
			// 防止多次重复刷新
			mSwipeRefreshLayout.setEnabled(false);
		}
		onRefreshLoadingStatus();
	}

	/** 设置顶部加载完毕的状态 */
	void setSwipeRefreshLoadedState() {
		if (mSwipeRefreshLayout != null) {
			mSwipeRefreshLayout.setRefreshing(false);
			mSwipeRefreshLayout.setEnabled(true);
		}
		onRefreshLoadedStatus();
	}
	
	void initLoading(){
		mSwipeRefreshLayout.setVisibility(View.VISIBLE);
		mLoading.setVisibility(View.GONE);
	}
	
	/** 正在加载的状态 */
	public void onRefreshLoadingStatus() {
	}

	/** 加载完毕的状态 */
	public void onRefreshLoadedStatus() {
	}
	
	public void setEmptyInfo(int imageResId, int messageResId) {
		mEmptyImage.setBackgroundResource(imageResId);
		mEmptyMessage.setText(messageResId);
	}

	@Override
	public void setUserVisibleHint(boolean isVisibleToUser) {
		super.setUserVisibleHint(isVisibleToUser);
	}

	/** 获取HeaderView */
	protected View getHeaderView(LayoutInflater inflater) {
		return null;
	}

	/** 初始化ListView */
	protected void setupListView() {
		mListView.setOnItemClickListener(this);
		mListView.setSelector(R.color.transparent);
		if (mHeaderView != null) {
			mListView.addHeaderView(mHeaderView);
		}
		mListView.setAdapter(mAdapter);
		
	}

	/** 获取适配器 */
	public abstract BaseAdapter getAdapter(List<Data> list);
	
	protected void showData() {
		mSwipeRefreshLayout.setVisibility(View.VISIBLE);
		mLoading.setVisibility(View.GONE);
	}

	
	protected void requestData(final int tag) {
		RequestQueue queue = RequestManager.getRequestQueue();

		Listener<String> listener = new Listener<String>() {

			@Override
			public void onResponse(String response) {
				if (volleyInterface != null) {
					volleyInterface.parserResponse(response, tag);
					
					setSwipeRefreshLoadedState();
				}
			}

		};

		ErrorListener errorListener = new ErrorListener() {

			@Override
			public void onErrorResponse(VolleyError error) {
				if (volleyInterface != null) {
					volleyInterface.parserVolleyError(error, tag);
					
					setSwipeRefreshLoadedState();
				}
				
			}
		};
		
		EsStringRequest request = null;
		if (volleyInterface != null) {
			request = volleyInterface.getRequest(true, listener, errorListener, tag);
		}
		
		if (request == null) {
			return;
		}
		try {
			if (request.getParams() == null && request.getUrl() != null) {
				request.setTag(request.getUrl());
				queue.cancelAll(request.getUrl());
			}
		} catch (AuthFailureError e) {
			e.printStackTrace();
		}
		queue.add(request);
	}

	public void setVolleyInterface(VolleyInterface volleyInterface) {
		this.volleyInterface = volleyInterface;
	}

	// 清空数据
	public void clearData() {
		mDataList.clear();
		mAdapter.notifyDataSetChanged();
	}
}
