package net.iyouqu.video.basecommon.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.format.DateUtils;
import android.text.format.Time;

import net.iyouqu.R;
import net.iyouqu.video.basecommon.utils.ui.UIUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * File Name: FormatUtils.java
 * Create by:Bruce on 2014-12-12 下午5:07:06 
 * @version 1.0.0
 */
public class DateFormattUtils {
	private final static long MINUTE_MILLISECOND = 1000 * 60;
	private final static long HOUR_MILLISECOND = 1000 * 60 * 60;
	private final static long DAY_MILLISECOND = 1000 * 60 * 60 * 24;

	@SuppressLint("SimpleDateFormat")
	private final static SimpleDateFormat mDatePattern = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@SuppressLint("SimpleDateFormat")
	private final static SimpleDateFormat mDatePattern2 = new SimpleDateFormat("yyyy-MM-dd");
    @SuppressLint("SimpleDateFormat")
    private final static SimpleDateFormat mDatePattern3 = new SimpleDateFormat("yy-MM-dd");
    @SuppressLint("SimpleDateFormat")
    private final static SimpleDateFormat mDatePattern4 = new SimpleDateFormat("MM-dd");
	public static final SimpleDateFormat DATE_FORMAT_PART = new SimpleDateFormat(
			"HH:mm");

	public static String currentTimeString() {
		return DATE_FORMAT_PART.format(Calendar.getInstance().getTime());
	}

	//==========================================================================
	// 方法
	//==========================================================================

	public static String getDateString(long time){
		return mDatePattern2.format(time);
	}

    public static String getNumbers(int count){
        String temp_count = String.valueOf(count);
        if(count > 999){
            temp_count = "1千+";
        }else if(count > 9999){
            temp_count = "1万+";
        }else if(count > 99999){
            temp_count = "10万+";
        }
        return temp_count;
    }

	/**
	 * 获取格式化日期和时间
	 * @param datePattern 格式化字符串，例如"yyyy-MM-dd HH:mm:ss"
	 * @return 格式化的日期时间
	 */
	@SuppressLint("SimpleDateFormat")
	public static String formatDate(String datePattern, long time) {
		try {
			SimpleDateFormat format = new SimpleDateFormat(datePattern);
			return format.format(time);
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return "";
	}

	/**
	 * 如果日期格式为yyyy-MM-dd HH:mm:ss，将其拆分为date和time
	 * @return String[0]为date，String[1]为time
	 */
	public static String[] splitDataAndTime(String dateStr) {
		String[] array = null;
		if (!StringUtils.isEmpty(dateStr)) {
			array = dateStr.split(" ");
		}
		return array;
	}

	/**
	 * 将字符串转位日期类型，字符串需要满足"yyyy-MM-dd HH:mm:ss"这样的格式
	 * @param dateStr 日期字符串
	 */
	public static Date string2Date(String dateStr) {
		Date date = null;
		if (!StringUtils.isEmpty(dateStr)) {
			try {
				date = mDatePattern.parse(dateStr);
			} catch (Exception e) {
				LogUtils.e(e);
			}
		}
		return date;
	}
	
	public static String friendlyTime(long time){
		String dateStr = formatDate("yyyy-MM-dd HH:mm:ss", time);
		return friendlyTime(dateStr);
	}
    /**MM-dd*/
    public static String friendlyTime2(long time){
        String dateStr = formatDate("yyyy-MM-dd HH:mm:ss", time);
        return friendlyTime2(dateStr);
    }
	
	public static String showDateTime(long time){
		String dateStr = formatDate("yyyy-MM-dd", time);
		return dateStr;
	}

	public static String showUpdateDateTime(long time){
		String dateStr = formatDate("MM-dd HH:mm:ss", time);
		return dateStr;
	}
	
	public static String showDayAndMonthDateTime(long time){
		String dateStr = "";
		if (DateUtils.isToday(time)) {
			dateStr = "今天";
		}else {
			dateStr = formatDate("dd/MM", time);
		}
		
		return dateStr;
	}

	public static String showDayAndMonthDateTime1(long time){
		String dateStr = "";
		if (DateUtils.isToday(time)) {
			dateStr = "今天";
		}else {
			dateStr = formatDate("MM-dd", time);
		}

		return dateStr;
	}

	public static boolean isSameday(long one, long two) {
        Time time = new Time();
        time.set(one);

        int thenYear = time.year;
        int thenMonth = time.month;
        int thenMonthDay = time.monthDay;

        time.set(two);
        return (thenYear == time.year)
                && (thenMonth == time.month)
                && (thenMonthDay == time.monthDay);
    }
	
	/**
	 * 转换时间显示
	 * 
	 * @param time
	 *            毫秒
	 * @return
	 */
	public static String generateTime(long time) {
		int totalSeconds = (int) (time / 1000);
		int seconds = totalSeconds % 60;
		int minutes = (totalSeconds / 60) % 60;
		int hours = totalSeconds / 3600;

		return hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes,
				seconds) : String.format("%02d:%02d", minutes, seconds);
	}

	public static String generateTime(Double time) {
		int totalSeconds = (int) (time / 1000);
		int seconds = totalSeconds % 60;
		int minutes = (totalSeconds / 60) % 60;
		int hours = totalSeconds / 3600;

		return hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes,
				seconds) : String.format("%02d:%02d", minutes, seconds);
	}

	/** 根据秒速获取时间格式 */
	public static String gennerTime(int totalSeconds) {
		int seconds = totalSeconds % 60;
		int minutes = (totalSeconds / 60) % 60;
		return String.format("%02d:%02d", minutes, seconds);
	}

	/** 以友好的方式显示时间 */
	public static String friendlyTime(String dateStr) {
		Date date = string2Date(dateStr);
		if (date == null) {
			return UIUtils.getString(R.string.format_unknown);
		}
		String ftime = "";
		Calendar cal = Calendar.getInstance();
		//判断是否是同一天
		String curDate = mDatePattern2.format(cal.getTime());
		String paramDate = mDatePattern2.format(date);
		if (curDate.equals(paramDate)) {
			int hour = (int) ((cal.getTimeInMillis() - date.getTime()) / HOUR_MILLISECOND);
			if (hour == 0) {
				ftime = UIUtils.getString(R.string.format_minutes_ago, Math.max((cal.getTimeInMillis() - date.getTime()) / MINUTE_MILLISECOND, 1));
			} else {
				ftime = UIUtils.getString(R.string.format_hours_ago, hour);
			}
			return ftime;
		}
		long lt = date.getTime() / DAY_MILLISECOND;
		long ct = cal.getTimeInMillis() / DAY_MILLISECOND;
		int days = (int) (ct - lt);
		if (days == 0) {
			int hour = (int) ((cal.getTimeInMillis() - date.getTime()) / HOUR_MILLISECOND);
			if (hour == 0) {
				ftime = UIUtils.getString(R.string.format_minutes_ago, Math.max((cal.getTimeInMillis() - date.getTime()) / MINUTE_MILLISECOND, 1));
			} else {
				ftime = UIUtils.getString(R.string.format_hours_ago, hour);
			}
		} else if (days == 1) {
			ftime = UIUtils.getString(R.string.format_yesterday);
		} else if (days == 2) {
			ftime = UIUtils.getString(R.string.format_before_yesterday);
		} else if (days > 2 && days <= 10) {
			ftime = UIUtils.getString(R.string.format_day_ago, days);
		} else if (days > 10) {
			ftime = mDatePattern3.format(date);
		}
		return ftime;
	}

    public static String friendlyTime2(String dateStr) {
        Date date = string2Date(dateStr);
        if (date == null) {
            return UIUtils.getString(R.string.format_unknown);
        }
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        //判断是否是同一天
        String curDate = mDatePattern2.format(cal.getTime());
        String paramDate = mDatePattern2.format(date);
        if (curDate.equals(paramDate)) {
            int hour = (int) ((cal.getTimeInMillis() - date.getTime()) / HOUR_MILLISECOND);
            if (hour == 0) {
                ftime = UIUtils.getString(R.string.format_minutes_ago, Math.max((cal.getTimeInMillis() - date.getTime()) / MINUTE_MILLISECOND, 1));
            } else {
                ftime = UIUtils.getString(R.string.format_hours_ago, hour);
            }
            return ftime;
        }
        long lt = date.getTime() / DAY_MILLISECOND;
        long ct = cal.getTimeInMillis() / DAY_MILLISECOND;
        int days = (int) (ct - lt);
        if (days == 0) {
            int hour = (int) ((cal.getTimeInMillis() - date.getTime()) / HOUR_MILLISECOND);
            if (hour == 0) {
                ftime = UIUtils.getString(R.string.format_minutes_ago, Math.max((cal.getTimeInMillis() - date.getTime()) / MINUTE_MILLISECOND, 1));
            } else {
                ftime = UIUtils.getString(R.string.format_hours_ago, hour);
            }
        } else if (days == 1) {
            ftime = UIUtils.getString(R.string.format_yesterday);
        } else if (days == 2) {
            ftime = UIUtils.getString(R.string.format_before_yesterday);
        } else if (days > 2 && days <= 10) {
            ftime = UIUtils.getString(R.string.format_day_ago, days);
        } else if (days > 10) {
            ftime = mDatePattern4.format(date);
        }
        return ftime;
    }

	/** 根据当前时间，返回一个时间的字符串，今天返回时间，今年的返回日期，再之前的返回年月 */
	@SuppressWarnings("deprecation")
	public static String getCompareDateStr(Context context, long dateTime) {
		int flags = 0;
		String date = "";
		Time then = new Time();
		then.set(dateTime);
		Time now = new Time();
		now.setToNow();
		if (DateUtils.isToday(dateTime)) {
			flags = DateUtils.FORMAT_SHOW_TIME | DateUtils.FORMAT_24HOUR;
			date = DateUtils.formatDateTime(context, dateTime, flags);
		} else if (then.year != now.year) {
			date = mDatePattern2.format(dateTime);
		} else {
			flags = DateUtils.FORMAT_SHOW_DATE;
			date = DateUtils.formatDateTime(context, dateTime, flags);
		}
		return date;
	}
}
