/*
 * File Name: SystemUtils.java 
 */
package net.iyouqu.video.basecommon.utils;

import java.util.List;
import java.util.Locale;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.Context;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.State;
import android.os.Build;
import android.os.Debug.MemoryInfo;

public class SystemUtils {
	
	/** >=2.2 */
	public static boolean hasFroyo() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.FROYO;
	}

	/** >=2.3 */
	public static boolean hasGingerbread() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD;
	}

	/** >=3.0 LEVEL:11 */
	public static boolean hasHoneycomb() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB;
	}

	/** >=3.1 */
	public static boolean hasHoneycombMR1() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR1;
	}

	/** >=4.0 14 */
	public static boolean hasICS() {
		return Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH;
	}
	
	/** 获取android系统版本号 */
	public static String getOSVersion() {
		String release = android.os.Build.VERSION.RELEASE; // android系统版本号
		release = "android" + release;
		return release;
	}

	/** 获得android系统sdk版本号 */
	public static String getOSVersionSDK() {
		return android.os.Build.VERSION.SDK;
	}

	/** 获得android系统sdk版本号 */
	public static int getOSVersionSDKINT() {
		return android.os.Build.VERSION.SDK_INT;
	}

	/** 获取手机型号 */
	public static String getDeviceModel() {
		return android.os.Build.MODEL;
	}

	public static String getPhoneModel() {
		String model = "";
		model = android.os.Build.MODEL;
		return model;
	}
	
	public static String getLanguage(Context context) {
		String language = "";
		Locale locale = context.getResources().getConfiguration().locale;
		if (locale != null) {
			language = locale.getLanguage();
		}
		return language;
	}

//FIXME 
/**
 * ***************************************************************************************************
 * 									关于内存
 * ***************************************************************************************************
 */
	/**
	 * 获取单个应用最大分配内存
	 * @return 单位为byte
	 */
	public static long getOneAppMaxMemory(Context context) {
		ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		return activityManager.getMemoryClass() * 1024 * 1024;
	}

	/**
	 * 获取指定本应用占用的内存
	 * @return 单位为byte
	 */
	public static long getUsedMemory(Context context) {
		return getUsedMemory(context, null);
	}

	/**
	 * 获取指定包名应用占用的内存
	 * @return 单位为byte
	 */
	public static long getUsedMemory(Context context, String packageName) {
		if (context == null) {
			return -1;
		}
		if (StringUtils.isEmpty(packageName)) {
			packageName = context.getPackageName();
		}
		long size = 0;
		ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		List<RunningAppProcessInfo> runapps = activityManager.getRunningAppProcesses();
		for (RunningAppProcessInfo runapp : runapps) { // 遍历运行中的程序
			if (packageName.equals(runapp.processName)) {// 得到程序进程名，进程名一般就是包名，但有些程序的进程名并不对应一个包名
				// 返回指定PID程序的内存信息，可以传递多个PID，返回的也是数组型的信息
				MemoryInfo[] processMemoryInfo = activityManager.getProcessMemoryInfo(new int[]{runapp.pid});
				// 得到内存信息中已使用的内存，单位是K
				size = processMemoryInfo[0].getTotalPrivateDirty() * 1024;
			}
		}
		return size;
	}

	/**
	 * 获取手机剩余内存
	 * @return 单位为byte
	 */
	public static long getAvailableMemory(Context context) {
		ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
		activityManager.getMemoryInfo(info);
		return info.availMem;
	}

	/**
	 * 获取手机总内存
	 * @return 单位为byte
	 */
	public static long getTotalMemory(Context context) {
		long size = 0;
		String path = "/proc/meminfo";// 系统内存信息文件
		try {
			String totalMemory = FileUtils.readProperties(path, "MemTotal", null);// 读出来是带单位kb的，并且单位前有空格，所以去掉最后三位
			if (!StringUtils.isEmpty(totalMemory) && totalMemory.length() > 3) {
				size = Long.valueOf(totalMemory.substring(0, totalMemory.length() - 3)) * 1024;
			}
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return size;
	}

	/**
	 * 手机低内存运行阀值
	 * @return 单位为byte
	 */
	public static long getThresholdMemory(Context context) {
		ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
		activityManager.getMemoryInfo(info);
		return info.threshold;
	}

	/**
	 * 手机是否处于低内存运行
	 */
	public static boolean isLowMemory(Context context) {
		ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
		activityManager.getMemoryInfo(info);
		return info.lowMemory;
	}
//FIXME 
    /**
	 * 返回当前的应用是否处于前台显示状态 不需要android.permission.GET_TASKS权限
	 * http://zengrong.net/post/1680.htm
	 * 
	 * @param packageName
	 * @return
	 */
	public static boolean isTopActivity(Context context, String packageName) {
		ActivityManager am = (ActivityManager) context.getApplicationContext()
				.getSystemService(Context.ACTIVITY_SERVICE);
		List<ActivityManager.RunningAppProcessInfo> list = am
				.getRunningAppProcesses();
		if (list.size() == 0)
			return false;
		for (ActivityManager.RunningAppProcessInfo process : list) {
			if (process.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
					&& process.processName.equals(packageName)) {
				return true;
			}
		}
		return false;
	}
 	
	/**
	 * @Title: isScreenOriatationPortrait
	 * @Description: TODO(返回当前屏幕是否为竖屏。)
	 * @author: Bruce
	 * @param context
	 * @return 当且仅当当前屏幕为竖屏时返回true,否则返回false。
	 */
	public static boolean isScreenOriatationPortrait(Context context) {
		return context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT;
	}

	//==========================================================================
	// 内部类、内部接口
	//==========================================================================
}
