package net.iyouqu.video.basecommon.utils.device;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import net.iyouqu.video.basecommon.utils.AppLog;
import net.iyouqu.video.basecommon.utils.LogUtils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;


public class DeviceUtils {
	
	public static String getRomInfo(){
		String info = "";
		info = android.os.Build.PRODUCT;
//				+ "*" + android.os.Build.MANUFACTURER;
		return info;
	}
	
	public static int getVersionCode(Context mContext) {
		int versionCode = 0;
		PackageManager packageManager = mContext.getPackageManager();
		// getPackageName()是你当前类的包名，0代表是获取版本信息
		PackageInfo packInfo;
		try {
			if (packageManager != null) {
				packInfo = packageManager.getPackageInfo(mContext.getPackageName(), 0);
				if (packInfo != null) {
					versionCode = packInfo.versionCode;
				}
			}
		} catch (NameNotFoundException e) {
			e.printStackTrace();
			AppLog.e("DeviceHelper", "getVersionCode error" + e);
		}
		return versionCode;
	}
	
	public static String getOsVersion() {
		String osv = "";
		osv = android.os.Build.VERSION.RELEASE;
//		osv = android.os.Build.VERSION.SDK_INT+"";
		return osv;
	}
	
	public static String getDeviceBRAND() {
		String brand = "";
		brand = android.os.Build.BRAND;
		return brand;
	}
	
	public static String getPhoneModel() {
		String model = "";
		model = android.os.Build.MODEL;
		return model;
	}

	//FIXME
	/******************************************************************************
	 * 							屏幕分辨率
	 * ****************************************************************************
	 */
	/** 
     * 根据手机的分辨率从 dp 的单位 转成为 px(像素) 
     */  
    public static int dip2px(Context context, float dpValue) {  
        final float scale = context.getResources().getDisplayMetrics().density;  
        return (int) (dpValue * scale + 0.5f);  
    }  
  
    /** 
     * 根据手机的分辨率从 px(像素) 的单位 转成为 dp 
     */  
    public static int px2dip(Context context, float pxValue) {  
        final float scale = context.getResources().getDisplayMetrics().density;  
        return (int) (pxValue / scale + 0.5f);  
    }  
    
	/**
	 * 获取屏幕的分辨率
	 * @param context 上下文
	 */
	@SuppressWarnings("deprecation")
	public static int[] getResolution(Context context) {
		WindowManager windowMgr = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		int[] res = new int[2];
		res[0] = windowMgr.getDefaultDisplay().getWidth();
		res[1] = windowMgr.getDefaultDisplay().getHeight();
		return res;
	}
	
	/**
	 * 获取屏幕的分辨率
	 * @param context 上下文
	 */
	@SuppressWarnings("deprecation")
	public static String getResolutionString(Context context) {
		WindowManager windowMgr = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		int[] res = new int[2];
		res[0] = windowMgr.getDefaultDisplay().getWidth();
		res[1] = windowMgr.getDefaultDisplay().getHeight();
		return res[0]+"*"+res[1];
	}

	/** 获得设备的dpi */
	public static float getDensityDpi(Context context) {
		DisplayMetrics dm = null;
		try {
			if (context != null) {
				dm = new DisplayMetrics();
				dm = context.getApplicationContext().getResources().getDisplayMetrics();
			}

			return dm.densityDpi;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	public static float getWidthPX(Context context) {
		DisplayMetrics dm = new DisplayMetrics();
		dm = context.getApplicationContext().getResources().getDisplayMetrics();
		return dm.widthPixels;
	}

	/** 获得设备的纵向dpi */
	public static float getHeightPX(Context context) {
		DisplayMetrics dm = new DisplayMetrics();
		dm = context.getApplicationContext().getResources().getDisplayMetrics();
		return dm.heightPixels;
	}
	
	public static float getWidthDpi(Context context) {
		DisplayMetrics dm = new DisplayMetrics();
		dm = context.getApplicationContext().getResources().getDisplayMetrics();
		return dm.xdpi;
	}

	/** 获得设备的纵向dpi */
	public static float getHeightDpi(Context context) {
		DisplayMetrics dm = new DisplayMetrics();
		dm = context.getApplicationContext().getResources().getDisplayMetrics();
		return dm.ydpi;
	}
	//FIXME
	/**********************************************************************************
	 * 								SIM卡信息
	 * ********************************************************************************
	 */
	
	/** 检测手机是否已插入SIM卡 */
	public static boolean isCheckSimCardAvailable(Context context) {
		final TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
		return tm.getSimState() == TelephonyManager.SIM_STATE_READY;
	}

	/** sim卡是否可读 */
	public static boolean isCanUseSim(Context context) {
		try {
			TelephonyManager mgr = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
			return TelephonyManager.SIM_STATE_READY == mgr.getSimState();
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return false;
	}

	/**
	 * 取得当前sim手机卡的imsi
	 * @param context 上下文
	 * @return 返回imsi
	 */
	public static String getIMSI(Context context) {
		if (null == context) {
			return null;
		}
		String imsi = null;
		try {
			TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
			imsi = tm.getSubscriberId();
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return imsi;
	}

	/** 返回本地手机号码，这个号码不一定能获取到 */
	public static String getNativePhoneNumber(Context context) {
		TelephonyManager telephonyManager;
		telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
		String NativePhoneNumber = null;
		NativePhoneNumber = telephonyManager.getLine1Number();
		
		if (NativePhoneNumber == null || NativePhoneNumber.length() <= 0) {
			NativePhoneNumber = "未知";
		}
		
		return NativePhoneNumber;
	}
	
	/** 返回手机服务商名字 数字 */
	public static String getProvidersNameNumber(Context context) {
		// 返回唯一的用户ID;就是这张卡的编号神马的
		return getIMSI(context);
	}

	/** 返回手机服务商名字 */
	public static String getProvidersName(Context context) {
		String ProvidersName = "";
		// 返回唯一的用户ID;就是这张卡的编号神马的
		String IMSI = getIMSI(context);
		try {
            if(TextUtils.isEmpty(IMSI)){
                return "未知";
            }
			// IMSI号前面3位460是国家，紧接着后面2位00 02是中国移动，01是中国联通，03是中国电信。
			if (IMSI.startsWith("46000") || IMSI.startsWith("46002")|| IMSI.startsWith("46007")) {
				ProvidersName = "中国移动";
			} else if (IMSI.startsWith("46001")) {
				ProvidersName = "中国联通";
			} else if (IMSI.startsWith("46003")) {
				ProvidersName = "中国电信";
			} else {
				ProvidersName = "其他服务商:" + IMSI;
			}
		} catch (NullPointerException e) {
			e.printStackTrace();
		}
		return ProvidersName;
	}
	//FIXME
	/***********************************************************************************
	 * 								获取设备硬件信息
	 * *********************************************************************************
	 */
	
	/**
	 * 获取设备的IMEI
	 * @param context 上下文
	 * @return 返回imei
	 */
	public static String getIMEI(Context context) {
		if (null == context) {
			return null;
		}
		String imei = null;
		try {
			TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
			imei = tm.getDeviceId();
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return imei;
	}
	
	/**
	 * 获取当前设备的MAC地址
	 * @param context 上下文
	 * @return MAC地址
	 */
//	public static String getMacAddress(Context context) {
//		if (null == context) {
//			return null;
//		}
//		String mac = null;
//		try {
//			WifiManager wm = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
//			WifiInfo info = wm.getConnectionInfo();
//			mac = info.getMacAddress();
//		} catch (Exception e) {
//			LogUtils.e(e);
//		}
//		return mac;
//	}
	
	
	/**
	 * 获取蓝牙地址
	 */
//	public static String getBluetoothAddress() {
//		String address = "";
//		try{
//			BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
//			if(bluetoothAdapter != null && bluetoothAdapter.isEnabled()) {
//				address = bluetoothAdapter.getAddress();
//			}
//		} catch(Exception e) {
//			e.printStackTrace();
//			return address;
//		}
//		return address;
//	}

	/** 获得设备ip地址 */
	public static String getLocalAddress() {
		try {
			Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
			while (en.hasMoreElements()) {
				NetworkInterface intf = en.nextElement();
				Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
				while (enumIpAddr.hasMoreElements()) {
					InetAddress inetAddress = enumIpAddr.nextElement();
					if (!inetAddress.isLoopbackAddress()) {
						return inetAddress.getHostAddress();
					}
				}
			}
		} catch (SocketException e) {
			LogUtils.e(e);
		}
		return null;
	}
	
	/**
	 * 获取当前设备的SN
	 * @param context 上下文
	 * @return 返回SN
	 */
	public static String getSimSN(Context context) {
		if (null == context) {
			return null;
		}
		String simSN = null;
		try {
			TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
			simSN = tm.getSimSerialNumber();
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return simSN;
	}

	/**
	 * 获取设备信息
	 */
	public static String[] getDivceInfo() {
		String str1 = "/proc/cpuinfo";
		String str2 = "";
		String[] cpuInfo = {"", ""};
		String[] arrayOfString;
		try {
			FileReader fr = new FileReader(str1);
			BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
			str2 = localBufferedReader.readLine();
			arrayOfString = str2.split("\\s+");
			for (int i = 2; i < arrayOfString.length; i++) {
				cpuInfo[0] = cpuInfo[0] + arrayOfString[i] + " ";
			}
			str2 = localBufferedReader.readLine();
			arrayOfString = str2.split("\\s+");
			cpuInfo[1] += arrayOfString[2];
			localBufferedReader.close();
		} catch (IOException e) {
			LogUtils.e(e);
		}
		return cpuInfo;
	}

	/**
	 * 判断手机CPU是否支持NEON指令集
	 */
	public static boolean isNEON() {
		boolean isNEON = false;
		String cupinfo = getCPUInfos();
		if (cupinfo != null) {
			cupinfo = cupinfo.toLowerCase();
			isNEON = cupinfo != null && cupinfo.contains("neon");
		}
		return isNEON;
	}

	/**
	 * 读取CPU信息文件，获取CPU信息
	 */
	@SuppressWarnings("resource")
	private static String getCPUInfos() {
		String str1 = "/proc/cpuinfo";
		String str2 = "";
		StringBuilder resusl = new StringBuilder();
		String resualStr = null;
		try {
			FileReader fr = new FileReader(str1);
			BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
			while ((str2 = localBufferedReader.readLine()) != null) {
				resusl.append(str2);
				// String cup = str2;
			}
			if (resusl != null) {
				resualStr = resusl.toString();
				return resualStr;
			}
		} catch (IOException e) {
			LogUtils.e(e);
		}
		return resualStr;
	}

	/**
	 * 获取当前设备cpu的型号
	 * @return 获取CPU的型号
	 */
	public static int getCPUModel() {
		return matchABI(getSystemProperty("ro.product.cpu.abi")) | matchABI(getSystemProperty("ro.product.cpu.abi2"));
	}

	/**
	 * 匹配当前设备的cpu型号
	 * @param abiString 设备的ABI
	 * @return 匹配的型号
	 */
	private static int matchABI(String abiString) {
		if (TextUtils.isEmpty(abiString)) {
			return 0;
		}
		if ("armeabi".equals(abiString)) {
			return 1;
		} else if ("armeabi-v7a".equals(abiString)) {
			return 2;
		} else if ("x86".equals(abiString)) {
			return 4;
		} else if ("mips".equals(abiString)) {
			return 8;
		}
		return 0;
	}

	/**
	 * 获取Rom版本
	 */
	public static String getRomversion() {
		String rom = "";
		try {
			String modversion = getSystemProperty("ro.modversion");
			String displayId = getSystemProperty("ro.build.display.id");
			if (modversion != null && !modversion.equals("")) {
				rom = modversion;
			}
			if (displayId != null && !displayId.equals("")) {
				rom = displayId;
			}
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return rom;
	}
	
	/**
	 * 获取系统配置参数
	 * @param key 参数key
	 * @return 参数值
	 */
	public static String getSystemProperty(String key) {
		String pValue = null;
		try {
			Class<?> c = Class.forName("android.os.SystemProperties");
			Method m = c.getMethod("get", String.class);
			pValue = m.invoke(null, key).toString();
		} catch (ClassNotFoundException e) {
			LogUtils.e(e);
		} catch (SecurityException e) {
			LogUtils.e(e);
		} catch (Exception e) {
			LogUtils.e(e);
		}
		return pValue;
	}
}
