package net.iyouqu.video.basecommon.utils.device;

import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.UUID;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

public class OpenUDID {
    static String TAG = "OpenUDID";
    private static String openUdid;
    private static long time;

    // 用户唯一标志
    public final static String PREF_KEY = "openudid";
    public final static String TIME = "time";
    public static final String COMMON_PREFS = "common_prefs";

    private final static boolean UseBlueToothFailback = false;
    private final static boolean UseImeiFailback = false;

    public static void syncContext(Context mContext) {
        if (openUdid == null) {
            SharedPreferences mPreferences = mContext.getSharedPreferences(COMMON_PREFS, Context.MODE_PRIVATE);
            String keyInPref = mPreferences.getString(PREF_KEY, null);
            long keyTime = mPreferences.getLong(TIME, 0);
            if (keyInPref == null || keyTime == 0) {
                openUdid = getUniqueId(mContext) + new Random().nextInt(10000);
                time = System.currentTimeMillis();
                Editor e = mPreferences.edit();
                e.putString(PREF_KEY, openUdid);
                e.putLong(TIME, time);
                e.commit();
            } else {
                openUdid = keyInPref;
                time = keyTime;
            }
            Log.d(TAG, "openUdid= " + openUdid);
        }
    }

    public static String getCorpUDID(String corpIdentifier) {
        return Md5(String.format("%s.%s", corpIdentifier, openUdid));
    }

    private static String getUniqueId(Context context) {

        final TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
         String tmDevice =null,  androidId,macAd, serialnum= null ;

        WifiManager wifiMan = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);

        if (PackageManager.PERMISSION_GRANTED == context.getPackageManager()
                .checkPermission(Manifest.permission.READ_PHONE_STATE,
                        context.getPackageName())) {

            tmDevice = tm.getDeviceId();//Returns the unique device ID

        }
            androidId =  android.provider.Settings.Secure.getString(context.getContentResolver(),
                    android.provider.Settings.Secure.ANDROID_ID);

            macAd =wifiMan.getConnectionInfo().getMacAddress();

            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class, String.class );
                serialnum = (String) get.invoke(c, "ro.serialno", "unknown" );
            } catch (Exception e) {
                e.printStackTrace();
            }
            if(tmDevice==null|| TextUtils.isEmpty(tmDevice)&&androidId==null|| TextUtils.isEmpty(androidId)
                    &&macAd==null||TextUtils.isEmpty(macAd)&&serialnum==null||TextUtils.isEmpty(serialnum)){
                Log.d(TAG, "uniqueId= " + UUID.randomUUID().toString());
                return UUID.randomUUID().toString();
            }
            tmDevice =  "IEMI:" + tmDevice;
//            AppLog.d(TAG, "tmDevice= " + tmDevice);
            androidId = "ANDROID_ID:" +androidId;
//            AppLog.d(TAG, "androidId= " + androidId);
            macAd= "MAC:"+macAd;
//            AppLog.d(TAG, "macAd= " + macAd);
            serialnum =  "SERIAL:"+serialnum;
//            AppLog.d(TAG, "serialnum= " + serialnum);
            UUID deviceUuid = new UUID(androidId.hashCode(), tmDevice.hashCode()| macAd.hashCode()|serialnum.hashCode());
            String uniqueId = deviceUuid.toString();
            Log.d(TAG, "uniqueId= " + uniqueId);
            return uniqueId;

    }


    private static String Md5(String input) {
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "null";
            // CommonUtil.printELog(LOG_TAG + "-Md5", "", e);
        }
        m.update(input.getBytes(), 0, input.length());
        byte p_md5Data[] = m.digest();

        String mOutput = new String();
        for (int i = 0; i < p_md5Data.length; i++) {
            int b = (0xFF & p_md5Data[i]);
            // if it is a single digit, make sure it have 0 in front (proper
            // padding)
            if (b <= 0xF)
                mOutput += "0";
            // add number to string
            mOutput += Integer.toHexString(b);
        }
        // hex string to uppercase
        return mOutput.toUpperCase();
    }



    /*
         * Generate a new OpenUDID
         */
    private static void generateOpenUDIDInContext(Context mContext) {
        // CommonUtil.printDLog(LOG_TAG + "-generateOpenUDIDInContext", "Generating openUDID");
        // Try to get WIFI MAC
        generateWifiId(mContext);
        if (null != openUdid) {
            return;
        }
        // Try to get the ANDROID_ID
        String _androidId = Settings.Secure.getString(mContext.getContentResolver(), Settings.Secure.ANDROID_ID);
        if (null != _androidId && _androidId.length() > 14 && !_androidId.equals("9774d56d682e549c")/*
                                                                                                     * android
																									 * 2.2
																									 */) {
            openUdid = "ANDROID:" + _androidId;
            time = System.currentTimeMillis();
            return;
        }

        if (UseImeiFailback) {
            openUdid = null;
            generateImeiId(mContext);

            if (openUdid != null) {
                return;
            }
        }

        if (UseBlueToothFailback) {
            openUdid = null;
            generateBlueToothId();
            if (openUdid == null) {
                generateRandomNumber();
            }
        } else {
            generateRandomNumber();
        }

    }

    private static void generateImeiId(Context mContext) {
        try {
            TelephonyManager TelephonyMgr = (TelephonyManager) mContext.getSystemService(Context.TELEPHONY_SERVICE);
            String szImei = TelephonyMgr.getDeviceId(); // Requires READ_PHONE_STATE

            if (null != szImei && !szImei.substring(0, 3).equals("000")) {
                openUdid = "IMEI:" + szImei;
                time = System.currentTimeMillis();
            }
        } catch (Exception e) {
            e.printStackTrace();
            // CommonUtil.printELog(LOG_TAG + "-generateImeiId", "", e);
        }
    }

    private static void generateBlueToothId() {
        try {
            BluetoothAdapter m_BluetoothAdapter = null; // Local Bluetooth
            // adapter
            m_BluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            String m_szBTMAC = m_BluetoothAdapter.getAddress();
            if (null != m_szBTMAC) {
                openUdid = "BTMAC:" + m_szBTMAC;
                time = System.currentTimeMillis();
            }
        } catch (Exception e) {
            e.printStackTrace();
            // CommonUtil.printELog(LOG_TAG + "-generateBlueToothId", "", e);
        }
    }

    private static void generateWifiId(Context mContext) {
        try {
            WifiManager wifiMan = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);
            WifiInfo wifiInf = wifiMan.getConnectionInfo();

            // CommonUtil.printDLog(LOG_TAG + "-generateWifiId", String.format("%s",
            // wifiInf.getMacAddress()));
            String macAddr = wifiInf.getMacAddress();
            if (macAddr != null) {
                openUdid = "WIFIMAC:" + macAddr;
                time = System.currentTimeMillis();
            }
        } catch (Exception e) {
            e.printStackTrace();
            // CommonUtil.printELog(LOG_TAG + "-generateWifiId", "", e);
        }
    }

    private static String generateRandomNumber() {
        time = System.currentTimeMillis();
        return Md5(UUID.randomUUID().toString());
    }
}
