package net.iyouqu.video.basecommon.utils.http;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.State;

public class NetState {

	public static String getNetworkType(Context context) {
		ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
		if (connManager != null) {
			NetworkInfo wifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI); // wifi
			NetworkInfo gprs = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE); // gprs

			if (wifi != null && wifi.getState() == State.CONNECTED) {
				return "wifi";
			} else if (gprs != null && gprs.getState() == State.CONNECTED) {
				return "gprs";
			}
		}

		return "none";
	}
}
