package net.iyouqu.video.basecommon.widget;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
/**
 * 只在竖直方向才能下拉刷新
 */
public class CBSwipeRefreshLayout extends SwipeRefreshLayout {
	private int mTouchSlop;
	private float mPrevX;//上一次触摸时的X坐标
	public CBSwipeRefreshLayout(Context context) {
		super(context);
	}

	public CBSwipeRefreshLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
		// 触发移动事件的最短距离，如果小于这个距离就不触发移动控件
        mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
	}

	@Override
	public boolean onInterceptTouchEvent(MotionEvent ev) {
		switch (ev.getAction()) {
		case MotionEvent.ACTION_DOWN:
			mPrevX = ev.getX();
			break;
		case MotionEvent.ACTION_MOVE:
			final float eventX = ev.getX();
			float xDiff = Math.abs(eventX - mPrevX);
			//增加60的容差，让下拉刷新在竖直滑动时就可以触发
			if(xDiff > mTouchSlop + 60){
				return false;
			}
			break;
		default:
			break;
		}
//		if (!isEnabled()) {
//			return false;
//		}
		return super.onInterceptTouchEvent(ev);
	}

	@Override
	public boolean onTouchEvent(MotionEvent arg0) {
		if (!isEnabled()) {
			return false;
		}
		return super.onTouchEvent(arg0);
	}
}
