package net.iyouqu.video.basecommon.widget;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;

/**
 * 
 * @author flood
 *
 */
public class EsSwipeRefreshLayout extends SwipeRefreshLayout {

	public EsSwipeRefreshLayout(Context context) {
		super(context);
	}
	
	public EsSwipeRefreshLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	@Override
	public boolean onInterceptTouchEvent(MotionEvent ev) {
		if(!isEnabled()) {
			return false;
		}
		switch (ev.getAction()) {
		case MotionEvent.ACTION_MOVE:
			if (scrollState != null) {
				scrollState.startTouch();
			}
			break;

		default:
			break;
		}
		Boolean mIsBeingDragged = super.onInterceptTouchEvent(ev);
		if (mIsBeingDragged) {
			if (scrollState != null) {
				scrollState.isBeginDragged(true);
			}
		}
		return mIsBeingDragged;
	}
	
	@Override
	public boolean onTouchEvent(MotionEvent arg0) {
		if(!isEnabled()) {
			return false;
		}
		
		switch (arg0.getAction()) {
		case MotionEvent.ACTION_CANCEL:
		case MotionEvent.ACTION_UP:
			if (scrollState != null) {
				scrollState.isBeginDragged(false);
			}
			break;

		default:
			break;
		}
		return super.onTouchEvent(arg0);
	}
	
	private OnScrollStateListener scrollState;
	public void setOnScrollState(OnScrollStateListener l){
		this.scrollState = l;
	}
	public interface OnScrollStateListener{
		void isBeginDragged(boolean begin);
		void startTouch();
	}
}