package net.iyouqu.video.basecommon.widget;

import net.iyouqu.R;
import android.graphics.drawable.BitmapDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout.LayoutParams;
import android.widget.PopupWindow;


public class PopupWindowTop implements PopupWindowStrategy {

	private PopupWindow popupWindow;

	@Override
	public View makePopupWind(LayoutInflater inflater, int layout) {
		// // 获取自定义布局文件pop.xml的视图
		View customView = inflater.inflate(layout, null, false);
		popupWindow = new PopupWindow(customView);
		popupWindow.setFocusable(true);
		popupWindow.setOutsideTouchable(true);
		// 这个是为了点击“返回Back”也能使其消失，并且并不会影响你的背景；使用该方法点击窗体之外，才可关闭窗体
		popupWindow.setBackgroundDrawable(new BitmapDrawable());
		// 设置渐入、渐出动画效果
		popupWindow.setWidth(LayoutParams.MATCH_PARENT);
		popupWindow.setHeight(LayoutParams.MATCH_PARENT);

		 popupWindow.setAnimationStyle(R.style.popupwindow);

		return customView;
	}

	@Override
	public PopupWindow getPopupWindow() {
		return popupWindow;
	}
	
}
