package net.iyouqu.video.basecommon.widget;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;

public class PopupWindowUtils {

	private PopupWindowStrategy strategy;
	private PopupWindow popupWindow;
	
	public PopupWindowUtils(PopupWindowStrategy strategy) {
		this.strategy = strategy;
	}
	
	public View initPopupWindowView(LayoutInflater inflater, int layout){
		View view = strategy.makePopupWind(inflater, layout);
		popupWindow = strategy.getPopupWindow();
		return view;
	}
	/**
	 * @Title: isPopupWindowShow
	 * @Description: TODO(popupWindow是否显示)
	 * @author: Bruce
	 * @return boolean
	 */
	public boolean isPopupWindowShow(){
		PopupWindow popupWindow2 = getPopupWindow();
		if(popupWindow2 == null){
			return false;
		}
		if(popupWindow2.isShowing()){
			return true;
		}
		return false; 
	}
	
	public PopupWindow getPopupWindow(){
		return strategy.getPopupWindow();
	}
	
	public void showPouup(View view){
		if(popupWindow != null && !popupWindow.isShowing()){
			popupWindow.showAsDropDown(view);
		}
	}

	public void showPopup(View view, int x, int y){
		if (popupWindow != null && !popupWindow.isShowing()) {
			popupWindow.showAsDropDown(view, x, y);
		}
	}
	
	public void dismissPopup(){
		if (popupWindow != null && popupWindow.isShowing()) {
			popupWindow.dismiss();
		}
	}
	
	public void dismissPopup(View view){
		if (popupWindow != null && popupWindow.isShowing()) {
			popupWindow.dismiss();
		}
	}
	
	public void togglePopup(View view, int x, int y){
		if (popupWindow != null) {
			if (popupWindow.isShowing()) {
				popupWindow.dismiss();
			}else {
				popupWindow.showAsDropDown(view, x, y);
			}
		}
	}
	
	public void togglePopup(View view){
		if (popupWindow != null) {
			if (popupWindow.isShowing()) {
				popupWindow.dismiss();
			}else {
				popupWindow.showAsDropDown(view);
			}
		}
	}
}
