/* Copyright (C) Codebrew Games Inc - All Rights Reserved
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */

var LZString=function(){function o(o,r){if(!t[o]){t[o]={};for(var n=0;n<o.length;n++)t[o][o.charAt(n)]=n}return t[o][r]}var r=String.fromCharCode,n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$",t={},i={compressToBase64:function(o){if(null==o)return"";var r=i._compress(o,6,function(o){return n.charAt(o)});switch(r.length%4){default:case 0:return r;case 1:return r+"===";case 2:return r+"==";case 3:return r+"="}},decompressFromBase64:function(r){return null==r?"":""==r?null:i._decompress(r.length,32,function(e){return o(n,r.charAt(e))})},compressToUTF16:function(o){return null==o?"":i._compress(o,15,function(o){return r(o+32)})+" "},decompressFromUTF16:function(o){return null==o?"":""==o?null:i._decompress(o.length,16384,function(r){return o.charCodeAt(r)-32})},compressToUint8Array:function(o){for(var r=i.compress(o),n=new Uint8Array(2*r.length),e=0,t=r.length;t>e;e++){var s=r.charCodeAt(e);n[2*e]=s>>>8,n[2*e+1]=s%256}return n},decompressFromUint8Array:function(o){if(null===o||void 0===o)return i.decompress(o);for(var n=new Array(o.length/2),e=0,t=n.length;t>e;e++)n[e]=256*o[2*e]+o[2*e+1];var s=[];return n.forEach(function(o){s.push(r(o))}),i.decompress(s.join(""))},compressToEncodedURIComponent:function(o){return null==o?"":i._compress(o,6,function(o){return e.charAt(o)})},decompressFromEncodedURIComponent:function(r){return null==r?"":""==r?null:(r=r.replace(/ /g,"+"),i._decompress(r.length,32,function(n){return o(e,r.charAt(n))}))},compress:function(o){return i._compress(o,16,function(o){return r(o)})},_compress:function(o,r,n){if(null==o)return"";var e,t,i,s={},p={},u="",c="",a="",l=2,f=3,h=2,d=[],m=0,v=0;for(i=0;i<o.length;i+=1)if(u=o.charAt(i),Object.prototype.hasOwnProperty.call(s,u)||(s[u]=f++,p[u]=!0),c=a+u,Object.prototype.hasOwnProperty.call(s,c))a=c;else{if(Object.prototype.hasOwnProperty.call(p,a)){if(a.charCodeAt(0)<256){for(e=0;h>e;e++)m<<=1,v==r-1?(v=0,d.push(n(m)),m=0):v++;for(t=a.charCodeAt(0),e=0;8>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1}else{for(t=1,e=0;h>e;e++)m=m<<1|t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t=0;for(t=a.charCodeAt(0),e=0;16>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1}l--,0==l&&(l=Math.pow(2,h),h++),delete p[a]}else for(t=s[a],e=0;h>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1;l--,0==l&&(l=Math.pow(2,h),h++),s[c]=f++,a=String(u)}if(""!==a){if(Object.prototype.hasOwnProperty.call(p,a)){if(a.charCodeAt(0)<256){for(e=0;h>e;e++)m<<=1,v==r-1?(v=0,d.push(n(m)),m=0):v++;for(t=a.charCodeAt(0),e=0;8>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1}else{for(t=1,e=0;h>e;e++)m=m<<1|t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t=0;for(t=a.charCodeAt(0),e=0;16>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1}l--,0==l&&(l=Math.pow(2,h),h++),delete p[a]}else for(t=s[a],e=0;h>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1;l--,0==l&&(l=Math.pow(2,h),h++)}for(t=2,e=0;h>e;e++)m=m<<1|1&t,v==r-1?(v=0,d.push(n(m)),m=0):v++,t>>=1;for(;;){if(m<<=1,v==r-1){d.push(n(m));break}v++}return d.join("")},decompress:function(o){return null==o?"":""==o?null:i._decompress(o.length,32768,function(r){return o.charCodeAt(r)})},_decompress:function(o,n,e){var t,i,s,p,u,c,a,l,f=[],h=4,d=4,m=3,v="",w=[],A={val:e(0),position:n,index:1};for(i=0;3>i;i+=1)f[i]=i;for(p=0,c=Math.pow(2,2),a=1;a!=c;)u=A.val&A.position,A.position>>=1,0==A.position&&(A.position=n,A.val=e(A.index++)),p|=(u>0?1:0)*a,a<<=1;switch(t=p){case 0:for(p=0,c=Math.pow(2,8),a=1;a!=c;)u=A.val&A.position,A.position>>=1,0==A.position&&(A.position=n,A.val=e(A.index++)),p|=(u>0?1:0)*a,a<<=1;l=r(p);break;case 1:for(p=0,c=Math.pow(2,16),a=1;a!=c;)u=A.val&A.position,A.position>>=1,0==A.position&&(A.position=n,A.val=e(A.index++)),p|=(u>0?1:0)*a,a<<=1;l=r(p);break;case 2:return""}for(f[3]=l,s=l,w.push(l);;){if(A.index>o)return"";for(p=0,c=Math.pow(2,m),a=1;a!=c;)u=A.val&A.position,A.position>>=1,0==A.position&&(A.position=n,A.val=e(A.index++)),p|=(u>0?1:0)*a,a<<=1;switch(l=p){case 0:for(p=0,c=Math.pow(2,8),a=1;a!=c;)u=A.val&A.position,A.position>>=1,0==A.position&&(A.position=n,A.val=e(A.index++)),p|=(u>0?1:0)*a,a<<=1;f[d++]=r(p),l=d-1,h--;break;case 1:for(p=0,c=Math.pow(2,16),a=1;a!=c;)u=A.val&A.position,A.position>>=1,0==A.position&&(A.position=n,A.val=e(A.index++)),p|=(u>0?1:0)*a,a<<=1;f[d++]=r(p),l=d-1,h--;break;case 2:return w.join("")}if(0==h&&(h=Math.pow(2,m),m++),f[l])v=f[l];else{if(l!==d)return null;v=s+s.charAt(0)}w.push(v),f[d++]=s+v.charAt(0),h--,s=v,0==h&&(h=Math.pow(2,m),m++)}}};return i}();"function"==typeof define&&define.amd?define(function(){return LZString}):"undefined"!=typeof module&&null!=module&&(module.exports=LZString);
/*! iScroll v5.2.0-snapshot ~ (c) 2008-2017 Matteo Spinelli ~ http://cubiq.org/license */
(function (window, document, Math) {
    var rAF = window.requestAnimationFrame	||
        window.webkitRequestAnimationFrame	||
        window.mozRequestAnimationFrame		||
        window.oRequestAnimationFrame		||
        window.msRequestAnimationFrame		||
        function (callback) { window.setTimeout(callback, 1000 / 60); };

    var utils = (function () {
        var me = {};

        var _elementStyle = document.createElement('div').style;
        var _vendor = (function () {
            var vendors = ['t', 'webkitT', 'MozT', 'msT', 'OT'],
                transform,
                i = 0,
                l = vendors.length;

            for ( ; i < l; i++ ) {
                transform = vendors[i] + 'ransform';
                if ( transform in _elementStyle ) return vendors[i].substr(0, vendors[i].length-1);
            }

            return false;
        })();

        function _prefixStyle (style) {
            if ( _vendor === false ) return false;
            if ( _vendor === '' ) return style;
            return _vendor + style.charAt(0).toUpperCase() + style.substr(1);
        }

        me.getTime = Date.now || function getTime () { return new Date().getTime(); };

        me.extend = function (target, obj) {
            for ( var i in obj ) {
                target[i] = obj[i];
            }
        };

        me.addEvent = function (el, type, fn, capture) {
            el.addEventListener(type, fn, !!capture);
        };

        me.removeEvent = function (el, type, fn, capture) {
            el.removeEventListener(type, fn, !!capture);
        };

        me.prefixPointerEvent = function (pointerEvent) {
            return window.MSPointerEvent ?
                'MSPointer' + pointerEvent.charAt(7).toUpperCase() + pointerEvent.substr(8):
                pointerEvent;
        };

        me.momentum = function (current, start, time, lowerMargin, wrapperSize, deceleration) {
            var distance = current - start,
                speed = Math.abs(distance) / time,
                destination,
                duration;

            deceleration = deceleration === undefined ? 0.0006 : deceleration;

            destination = current + ( speed * speed ) / ( 2 * deceleration ) * ( distance < 0 ? -1 : 1 );
            duration = speed / deceleration;

            if ( destination < lowerMargin ) {
                destination = wrapperSize ? lowerMargin - ( wrapperSize / 2.5 * ( speed / 8 ) ) : lowerMargin;
                distance = Math.abs(destination - current);
                duration = distance / speed;
            } else if ( destination > 0 ) {
                destination = wrapperSize ? wrapperSize / 2.5 * ( speed / 8 ) : 0;
                distance = Math.abs(current) + destination;
                duration = distance / speed;
            }

            return {
                destination: Math.round(destination),
                duration: duration
            };
        };

        var _transform = _prefixStyle('transform');

        me.extend(me, {
            hasTransform: _transform !== false,
            hasPerspective: _prefixStyle('perspective') in _elementStyle,
            hasTouch: 'ontouchstart' in window,
            hasPointer: !!(window.PointerEvent || window.MSPointerEvent), // IE10 is prefixed
            hasTransition: _prefixStyle('transition') in _elementStyle
        });

        /*
        This should find all Android browsers lower than build 535.19 (both stock browser and webview)
        - galaxy S2 is ok
        - 2.3.6 : `AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1`
        - 4.0.4 : `AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30`
       - galaxy S3 is badAndroid (stock brower, webview)
         `AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30`
       - galaxy S4 is badAndroid (stock brower, webview)
         `AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30`
       - galaxy S5 is OK
         `AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Mobile Safari/537.36 (Chrome/)`
       - galaxy S6 is OK
         `AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Mobile Safari/537.36 (Chrome/)`
      */
        me.isBadAndroid = (function() {
            var appVersion = window.navigator.appVersion;
            // Android browser is not a chrome browser.
            if (/Android/.test(appVersion) && !(/Chrome\/\d/.test(appVersion))) {
                var safariVersion = appVersion.match(/Safari\/(\d+.\d)/);
                if(safariVersion && typeof safariVersion === "object" && safariVersion.length >= 2) {
                    return parseFloat(safariVersion[1]) < 535.19;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        })();

        me.extend(me.style = {}, {
            transform: _transform,
            transitionTimingFunction: _prefixStyle('transitionTimingFunction'),
            transitionDuration: _prefixStyle('transitionDuration'),
            transitionDelay: _prefixStyle('transitionDelay'),
            transformOrigin: _prefixStyle('transformOrigin'),
            touchAction: _prefixStyle('touchAction')
        });

        me.hasClass = function (e, c) {
            var re = new RegExp("(^|\\s)" + c + "(\\s|$)");
            return re.test(e.className);
        };

        me.addClass = function (e, c) {
            if ( me.hasClass(e, c) ) {
                return;
            }

            var newclass = e.className.split(' ');
            newclass.push(c);
            e.className = newclass.join(' ');
        };

        me.removeClass = function (e, c) {
            if ( !me.hasClass(e, c) ) {
                return;
            }

            var re = new RegExp("(^|\\s)" + c + "(\\s|$)", 'g');
            e.className = e.className.replace(re, ' ');
        };

        me.offset = function (el) {
            var left = -el.offsetLeft,
                top = -el.offsetTop;

            // jshint -W084
            while (el = el.offsetParent) {
                left -= el.offsetLeft;
                top -= el.offsetTop;
            }
            // jshint +W084

            return {
                left: left,
                top: top
            };
        };

        me.preventDefaultException = function (el, exceptions) {
            for ( var i in exceptions ) {
                if ( exceptions[i].test(el[i]) ) {
                    return true;
                }
            }

            return false;
        };

        me.extend(me.eventType = {}, {
            touchstart: 1,
            touchmove: 1,
            touchend: 1,

            mousedown: 2,
            mousemove: 2,
            mouseup: 2,

            pointerdown: 3,
            pointermove: 3,
            pointerup: 3,

            MSPointerDown: 3,
            MSPointerMove: 3,
            MSPointerUp: 3
        });

        me.extend(me.ease = {}, {
            quadratic: {
                style: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                fn: function (k) {
                    return k * ( 2 - k );
                }
            },
            circular: {
                style: 'cubic-bezier(0.1, 0.57, 0.1, 1)',	// Not properly "circular" but this looks better, it should be (0.075, 0.82, 0.165, 1)
                fn: function (k) {
                    return Math.sqrt( 1 - ( --k * k ) );
                }
            },
            back: {
                style: 'cubic-bezier(0.175, 0.885, 0.32, 1.275)',
                fn: function (k) {
                    var b = 4;
                    return ( k = k - 1 ) * k * ( ( b + 1 ) * k + b ) + 1;
                }
            },
            bounce: {
                style: '',
                fn: function (k) {
                    if ( ( k /= 1 ) < ( 1 / 2.75 ) ) {
                        return 7.5625 * k * k;
                    } else if ( k < ( 2 / 2.75 ) ) {
                        return 7.5625 * ( k -= ( 1.5 / 2.75 ) ) * k + 0.75;
                    } else if ( k < ( 2.5 / 2.75 ) ) {
                        return 7.5625 * ( k -= ( 2.25 / 2.75 ) ) * k + 0.9375;
                    } else {
                        return 7.5625 * ( k -= ( 2.625 / 2.75 ) ) * k + 0.984375;
                    }
                }
            },
            elastic: {
                style: '',
                fn: function (k) {
                    var f = 0.22,
                        e = 0.4;

                    if ( k === 0 ) { return 0; }
                    if ( k == 1 ) { return 1; }

                    return ( e * Math.pow( 2, - 10 * k ) * Math.sin( ( k - f / 4 ) * ( 2 * Math.PI ) / f ) + 1 );
                }
            }
        });

        me.tap = function (e, eventName) {
            var ev = document.createEvent('Event');
            ev.initEvent(eventName, true, true);
            ev.pageX = e.pageX;
            ev.pageY = e.pageY;
            e.target.dispatchEvent(ev);
        };

        me.click = function (e) {
            var target = e.target,
                ev;

            if ( !(/(SELECT|INPUT|TEXTAREA)/i).test(target.tagName) ) {
                // https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/initMouseEvent
                // initMouseEvent is deprecated.
                ev = document.createEvent(window.MouseEvent ? 'MouseEvents' : 'Event');
                ev.initEvent('click', true, true);
                ev.view = e.view || window;
                ev.detail = 1;
                ev.screenX = target.screenX || 0;
                ev.screenY = target.screenY || 0;
                ev.clientX = target.clientX || 0;
                ev.clientY = target.clientY || 0;
                ev.ctrlKey = !!e.ctrlKey;
                ev.altKey = !!e.altKey;
                ev.shiftKey = !!e.shiftKey;
                ev.metaKey = !!e.metaKey;
                ev.button = 0;
                ev.relatedTarget = null;
                ev._constructed = true;
                target.dispatchEvent(ev);
            }
        };

        me.getTouchAction = function(eventPassthrough, addPinch) {
            var touchAction = 'none';
            if ( eventPassthrough === 'vertical' ) {
                touchAction = 'pan-y';
            } else if (eventPassthrough === 'horizontal' ) {
                touchAction = 'pan-x';
            }
            if (addPinch && touchAction != 'none') {
                // add pinch-zoom support if the browser supports it, but if not (eg. Chrome <55) do nothing
                touchAction += ' pinch-zoom';
            }
            return touchAction;
        };

        me.getRect = function(el) {
            if (el instanceof SVGElement) {
                var rect = el.getBoundingClientRect();
                return {
                    top : rect.top,
                    left : rect.left,
                    width : rect.width,
                    height : rect.height
                };
            } else {
                return {
                    top : el.offsetTop,
                    left : el.offsetLeft,
                    width : el.offsetWidth,
                    height : el.offsetHeight
                };
            }
        };

        return me;
    })();
    function IScroll (el, options) {
        this.wrapper = typeof el == 'string' ? document.querySelector(el) : el;
        this.scroller = this.wrapper.children[0];
        this.scrollerStyle = this.scroller.style;		// cache style for better performance

        this.options = {

// INSERT POINT: OPTIONS
            disablePointer : !utils.hasPointer,
            disableTouch : utils.hasPointer || !utils.hasTouch,
            disableMouse : utils.hasPointer || utils.hasTouch,
            startX: 0,
            startY: 0,
            scrollY: true,
            directionLockThreshold: 5,
            momentum: true,

            bounce: true,
            bounceTime: 600,
            bounceEasing: '',

            preventDefault: true,
            preventDefaultException: { tagName: /^(INPUT|TEXTAREA|BUTTON|SELECT)$/ },

            HWCompositing: true,
            useTransition: true,
            useTransform: true,
            bindToWrapper: typeof window.onmousedown === "undefined"
        };

        for ( var i in options ) {
            this.options[i] = options[i];
        }

        // Normalize options
        this.translateZ = this.options.HWCompositing && utils.hasPerspective ? ' translateZ(0)' : '';

        this.options.useTransition = utils.hasTransition && this.options.useTransition;
        this.options.useTransform = utils.hasTransform && this.options.useTransform;

        this.options.eventPassthrough = this.options.eventPassthrough === true ? 'vertical' : this.options.eventPassthrough;
        this.options.preventDefault = !this.options.eventPassthrough && this.options.preventDefault;

        // If you want eventPassthrough I have to lock one of the axes
        this.options.scrollY = this.options.eventPassthrough == 'vertical' ? false : this.options.scrollY;
        this.options.scrollX = this.options.eventPassthrough == 'horizontal' ? false : this.options.scrollX;

        // With eventPassthrough we also need lockDirection mechanism
        this.options.freeScroll = this.options.freeScroll && !this.options.eventPassthrough;
        this.options.directionLockThreshold = this.options.eventPassthrough ? 0 : this.options.directionLockThreshold;

        this.options.bounceEasing = typeof this.options.bounceEasing == 'string' ? utils.ease[this.options.bounceEasing] || utils.ease.circular : this.options.bounceEasing;

        this.options.resizePolling = this.options.resizePolling === undefined ? 60 : this.options.resizePolling;

        if ( this.options.tap === true ) {
            this.options.tap = 'tap';
        }

        // https://github.com/cubiq/iscroll/issues/1029
        if (!this.options.useTransition && !this.options.useTransform) {
            if(!(/relative|absolute/i).test(this.scrollerStyle.position)) {
                this.scrollerStyle.position = "relative";
            }
        }

// INSERT POINT: NORMALIZATION

        // Some defaults
        this.x = 0;
        this.y = 0;
        this.directionX = 0;
        this.directionY = 0;
        this._events = {};

// INSERT POINT: DEFAULTS

        this._init();
        this.refresh();

        this.scrollTo(this.options.startX, this.options.startY);
        this.enable();
    }

    IScroll.prototype = {
        version: '5.2.0-snapshot',

        _init: function () {
            this._initEvents();

// INSERT POINT: _init

        },

        destroy: function () {
            this._initEvents(true);
            clearTimeout(this.resizeTimeout);
            this.resizeTimeout = null;
            this._execEvent('destroy');
        },

        _transitionEnd: function (e) {
            if ( e.target != this.scroller || !this.isInTransition ) {
                return;
            }

            this._transitionTime();
            if ( !this.resetPosition(this.options.bounceTime) ) {
                this.isInTransition = false;
                this._execEvent('scrollEnd');
            }
        },

        _start: function (e) {
            // React to left mouse button only
            if ( utils.eventType[e.type] != 1 ) {
                // for button property
                // http://unixpapa.com/js/mouse.html
                var button;
                if (!e.which) {
                    /* IE case */
                    button = (e.button < 2) ? 0 :
                        ((e.button == 4) ? 1 : 2);
                } else {
                    /* All others */
                    button = e.button;
                }
                if ( button !== 0 ) {
                    return;
                }
            }

            if ( !this.enabled || (this.initiated && utils.eventType[e.type] !== this.initiated) ) {
                return;
            }

            if ( this.options.preventDefault && !utils.isBadAndroid && !utils.preventDefaultException(e.target, this.options.preventDefaultException) ) {
                e.preventDefault();
            }

            var point = e.touches ? e.touches[0] : e,
                pos;

            this.initiated	= utils.eventType[e.type];
            this.moved		= false;
            this.distX		= 0;
            this.distY		= 0;
            this.directionX = 0;
            this.directionY = 0;
            this.directionLocked = 0;

            this.startTime = utils.getTime();

            if ( this.options.useTransition && this.isInTransition ) {
                this._transitionTime();
                this.isInTransition = false;
                pos = this.getComputedPosition();
                this._translate(Math.round(pos.x), Math.round(pos.y));
                this._execEvent('scrollEnd');
            } else if ( !this.options.useTransition && this.isAnimating ) {
                this.isAnimating = false;
                this._execEvent('scrollEnd');
            }

            this.startX    = this.x;
            this.startY    = this.y;
            this.absStartX = this.x;
            this.absStartY = this.y;
            this.pointX    = point.pageX;
            this.pointY    = point.pageY;

            this._execEvent('beforeScrollStart');
        },

        _move: function (e) {
            if ( !this.enabled || utils.eventType[e.type] !== this.initiated ) {
                return;
            }

            if ( this.options.preventDefault ) {	// increases performance on Android? TODO: check!
                e.preventDefault();
            }

            var point		= e.touches ? e.touches[0] : e,
                deltaX		= point.pageX - this.pointX,
                deltaY		= point.pageY - this.pointY,
                timestamp	= utils.getTime(),
                newX, newY,
                absDistX, absDistY;

            this.pointX		= point.pageX;
            this.pointY		= point.pageY;

            this.distX		+= deltaX;
            this.distY		+= deltaY;
            absDistX		= Math.abs(this.distX);
            absDistY		= Math.abs(this.distY);

            // We need to move at least 10 pixels for the scrolling to initiate
            if ( timestamp - this.endTime > 300 && (absDistX < 10 && absDistY < 10) ) {
                return;
            }

            // If you are scrolling in one direction lock the other
            if ( !this.directionLocked && !this.options.freeScroll ) {
                if ( absDistX > absDistY + this.options.directionLockThreshold ) {
                    this.directionLocked = 'h';		// lock horizontally
                } else if ( absDistY >= absDistX + this.options.directionLockThreshold ) {
                    this.directionLocked = 'v';		// lock vertically
                } else {
                    this.directionLocked = 'n';		// no lock
                }
            }

            if ( this.directionLocked == 'h' ) {
                if ( this.options.eventPassthrough == 'vertical' ) {
                    e.preventDefault();
                } else if ( this.options.eventPassthrough == 'horizontal' ) {
                    this.initiated = false;
                    return;
                }

                deltaY = 0;
            } else if ( this.directionLocked == 'v' ) {
                if ( this.options.eventPassthrough == 'horizontal' ) {
                    e.preventDefault();
                } else if ( this.options.eventPassthrough == 'vertical' ) {
                    this.initiated = false;
                    return;
                }

                deltaX = 0;
            }

            deltaX = this.hasHorizontalScroll ? deltaX : 0;
            deltaY = this.hasVerticalScroll ? deltaY : 0;

            newX = this.x + deltaX;
            newY = this.y + deltaY;

            // Slow down if outside of the boundaries
            if ( newX > 0 || newX < this.maxScrollX ) {
                newX = this.options.bounce ? this.x + deltaX / 3 : newX > 0 ? 0 : this.maxScrollX;
            }
            if ( newY > 0 || newY < this.maxScrollY ) {
                newY = this.options.bounce ? this.y + deltaY / 3 : newY > 0 ? 0 : this.maxScrollY;
            }

            this.directionX = deltaX > 0 ? -1 : deltaX < 0 ? 1 : 0;
            this.directionY = deltaY > 0 ? -1 : deltaY < 0 ? 1 : 0;

            if ( !this.moved ) {
                this._execEvent('scrollStart');
            }

            this.moved = true;

            this._translate(newX, newY);

            /* REPLACE START: _move */

            if ( timestamp - this.startTime > 300 ) {
                this.startTime = timestamp;
                this.startX = this.x;
                this.startY = this.y;
            }

            /* REPLACE END: _move */

        },

        _end: function (e) {
            if ( !this.enabled || utils.eventType[e.type] !== this.initiated ) {
                return;
            }

            if ( this.options.preventDefault && !utils.preventDefaultException(e.target, this.options.preventDefaultException) ) {
                e.preventDefault();
            }

            var point = e.changedTouches ? e.changedTouches[0] : e,
                momentumX,
                momentumY,
                duration = utils.getTime() - this.startTime,
                newX = Math.round(this.x),
                newY = Math.round(this.y),
                distanceX = Math.abs(newX - this.startX),
                distanceY = Math.abs(newY - this.startY),
                time = 0,
                easing = '';

            this.isInTransition = 0;
            this.initiated = 0;
            this.endTime = utils.getTime();

            // reset if we are outside of the boundaries
            if ( this.resetPosition(this.options.bounceTime) ) {
                return;
            }

            this.scrollTo(newX, newY);	// ensures that the last position is rounded

            // we scrolled less than 10 pixels
            if ( !this.moved ) {
                if ( this.options.tap ) {
                    utils.tap(e, this.options.tap);
                }

                if ( this.options.click ) {
                    utils.click(e);
                }

                this._execEvent('scrollCancel');
                return;
            }

            if ( this._events.flick && duration < 200 && distanceX < 100 && distanceY < 100 ) {
                this._execEvent('flick');
                return;
            }

            // start momentum animation if needed
            if ( this.options.momentum && duration < 300 ) {
                momentumX = this.hasHorizontalScroll ? utils.momentum(this.x, this.startX, duration, this.maxScrollX, this.options.bounce ? this.wrapperWidth : 0, this.options.deceleration) : { destination: newX, duration: 0 };
                momentumY = this.hasVerticalScroll ? utils.momentum(this.y, this.startY, duration, this.maxScrollY, this.options.bounce ? this.wrapperHeight : 0, this.options.deceleration) : { destination: newY, duration: 0 };
                newX = momentumX.destination;
                newY = momentumY.destination;
                time = Math.max(momentumX.duration, momentumY.duration);
                this.isInTransition = 1;
            }

// INSERT POINT: _end

            if ( newX != this.x || newY != this.y ) {
                // change easing function when scroller goes out of the boundaries
                if ( newX > 0 || newX < this.maxScrollX || newY > 0 || newY < this.maxScrollY ) {
                    easing = utils.ease.quadratic;
                }

                this.scrollTo(newX, newY, time, easing);
                return;
            }

            this._execEvent('scrollEnd');
        },

        _resize: function () {
            var that = this;

            clearTimeout(this.resizeTimeout);

            this.resizeTimeout = setTimeout(function () {
                that.refresh();
            }, this.options.resizePolling);
        },

        resetPosition: function (time) {
            var x = this.x,
                y = this.y;

            time = time || 0;

            if ( !this.hasHorizontalScroll || this.x > 0 ) {
                x = 0;
            } else if ( this.x < this.maxScrollX ) {
                x = this.maxScrollX;
            }

            if ( !this.hasVerticalScroll || this.y > 0 ) {
                y = 0;
            } else if ( this.y < this.maxScrollY ) {
                y = this.maxScrollY;
            }

            if ( x == this.x && y == this.y ) {
                return false;
            }

            this.scrollTo(x, y, time, this.options.bounceEasing);

            return true;
        },

        disable: function () {
            this.enabled = false;
        },

        enable: function () {
            this.enabled = true;
        },

        refresh: function () {
            utils.getRect(this.wrapper);		// Force reflow

            this.wrapperWidth	= this.wrapper.clientWidth;
            this.wrapperHeight	= this.wrapper.clientHeight;

            var rect = utils.getRect(this.scroller);
            /* REPLACE START: refresh */

            this.scrollerWidth	= rect.width;
            this.scrollerHeight	= rect.height;

            this.maxScrollX		= this.wrapperWidth - this.scrollerWidth;
            this.maxScrollY		= this.wrapperHeight - this.scrollerHeight;

            /* REPLACE END: refresh */

            this.hasHorizontalScroll	= this.options.scrollX && this.maxScrollX < 0;
            this.hasVerticalScroll		= this.options.scrollY && this.maxScrollY < 0;

            if ( !this.hasHorizontalScroll ) {
                this.maxScrollX = 0;
                this.scrollerWidth = this.wrapperWidth;
            }

            if ( !this.hasVerticalScroll ) {
                this.maxScrollY = 0;
                this.scrollerHeight = this.wrapperHeight;
            }

            this.endTime = 0;
            this.directionX = 0;
            this.directionY = 0;

            if(utils.hasPointer && !this.options.disablePointer) {
                // The wrapper should have `touchAction` property for using pointerEvent.
                this.wrapper.style[utils.style.touchAction] = utils.getTouchAction(this.options.eventPassthrough, true);

                // case. not support 'pinch-zoom'
                // https://github.com/cubiq/iscroll/issues/1118#issuecomment-270057583
                if (!this.wrapper.style[utils.style.touchAction]) {
                    this.wrapper.style[utils.style.touchAction] = utils.getTouchAction(this.options.eventPassthrough, false);
                }
            }
            this.wrapperOffset = utils.offset(this.wrapper);

            this._execEvent('refresh');

            this.resetPosition();

// INSERT POINT: _refresh

        },

        on: function (type, fn) {
            if ( !this._events[type] ) {
                this._events[type] = [];
            }

            this._events[type].push(fn);
        },

        off: function (type, fn) {
            if ( !this._events[type] ) {
                return;
            }

            var index = this._events[type].indexOf(fn);

            if ( index > -1 ) {
                this._events[type].splice(index, 1);
            }
        },

        _execEvent: function (type) {
            if ( !this._events[type] ) {
                return;
            }

            var i = 0,
                l = this._events[type].length;

            if ( !l ) {
                return;
            }

            for ( ; i < l; i++ ) {
                this._events[type][i].apply(this, [].slice.call(arguments, 1));
            }
        },

        scrollBy: function (x, y, time, easing) {
            x = this.x + x;
            y = this.y + y;
            time = time || 0;

            this.scrollTo(x, y, time, easing);
        },

        scrollTo: function (x, y, time, easing) {
            easing = easing || utils.ease.circular;

            this.isInTransition = this.options.useTransition && time > 0;
            var transitionType = this.options.useTransition && easing.style;
            if ( !time || transitionType ) {
                if(transitionType) {
                    this._transitionTimingFunction(easing.style);
                    this._transitionTime(time);
                }
                this._translate(x, y);
            } else {
                this._animate(x, y, time, easing.fn);
            }
        },

        scrollToElement: function (el, time, offsetX, offsetY, easing) {
            el = el.nodeType ? el : this.scroller.querySelector(el);

            if ( !el ) {
                return;
            }

            var pos = utils.offset(el);

            pos.left -= this.wrapperOffset.left;
            pos.top  -= this.wrapperOffset.top;

            // if offsetX/Y are true we center the element to the screen
            var elRect = utils.getRect(el);
            var wrapperRect = utils.getRect(this.wrapper);
            if ( offsetX === true ) {
                offsetX = Math.round(elRect.width / 2 - wrapperRect.width / 2);
            }
            if ( offsetY === true ) {
                offsetY = Math.round(elRect.height / 2 - wrapperRect.height / 2);
            }

            pos.left -= offsetX || 0;
            pos.top  -= offsetY || 0;

            pos.left = pos.left > 0 ? 0 : pos.left < this.maxScrollX ? this.maxScrollX : pos.left;
            pos.top  = pos.top  > 0 ? 0 : pos.top  < this.maxScrollY ? this.maxScrollY : pos.top;

            time = time === undefined || time === null || time === 'auto' ? Math.max(Math.abs(this.x-pos.left), Math.abs(this.y-pos.top)) : time;

            this.scrollTo(pos.left, pos.top, time, easing);
        },

        _transitionTime: function (time) {
            if (!this.options.useTransition) {
                return;
            }
            time = time || 0;
            var durationProp = utils.style.transitionDuration;
            if(!durationProp) {
                return;
            }

            this.scrollerStyle[durationProp] = time + 'ms';

            if ( !time && utils.isBadAndroid ) {
                this.scrollerStyle[durationProp] = '0.0001ms';
                // remove 0.0001ms
                var self = this;
                rAF(function() {
                    if(self.scrollerStyle[durationProp] === '0.0001ms') {
                        self.scrollerStyle[durationProp] = '0s';
                    }
                });
            }

// INSERT POINT: _transitionTime

        },

        _transitionTimingFunction: function (easing) {
            this.scrollerStyle[utils.style.transitionTimingFunction] = easing;

// INSERT POINT: _transitionTimingFunction

        },

        _translate: function (x, y) {
            if ( this.options.useTransform ) {

                /* REPLACE START: _translate */

                this.scrollerStyle[utils.style.transform] = 'translate(' + x + 'px,' + y + 'px)' + this.translateZ;

                /* REPLACE END: _translate */

            } else {
                x = Math.round(x);
                y = Math.round(y);
                this.scrollerStyle.left = x + 'px';
                this.scrollerStyle.top = y + 'px';
            }

            this.x = x;
            this.y = y;

// INSERT POINT: _translate

        },

        _initEvents: function (remove) {
            var eventType = remove ? utils.removeEvent : utils.addEvent,
                target = this.options.bindToWrapper ? this.wrapper : window;

            eventType(window, 'orientationchange', this);
            eventType(window, 'resize', this);

            if ( this.options.click ) {
                eventType(this.wrapper, 'click', this, true);
            }

            if ( !this.options.disableMouse ) {
                eventType(this.wrapper, 'mousedown', this);
                eventType(target, 'mousemove', this);
                eventType(target, 'mousecancel', this);
                eventType(target, 'mouseup', this);
            }

            if ( utils.hasPointer && !this.options.disablePointer ) {
                eventType(this.wrapper, utils.prefixPointerEvent('pointerdown'), this);
                eventType(target, utils.prefixPointerEvent('pointermove'), this);
                eventType(target, utils.prefixPointerEvent('pointercancel'), this);
                eventType(target, utils.prefixPointerEvent('pointerup'), this);
            }

            if ( utils.hasTouch && !this.options.disableTouch ) {
                eventType(this.wrapper, 'touchstart', this);
                eventType(target, 'touchmove', this);
                eventType(target, 'touchcancel', this);
                eventType(target, 'touchend', this);
            }

            eventType(this.scroller, 'transitionend', this);
            eventType(this.scroller, 'webkitTransitionEnd', this);
            eventType(this.scroller, 'oTransitionEnd', this);
            eventType(this.scroller, 'MSTransitionEnd', this);
        },

        getComputedPosition: function () {
            var matrix = window.getComputedStyle(this.scroller, null),
                x, y;

            if ( this.options.useTransform ) {
                matrix = matrix[utils.style.transform].split(')')[0].split(', ');
                x = +(matrix[12] || matrix[4]);
                y = +(matrix[13] || matrix[5]);
            } else {
                x = +matrix.left.replace(/[^-\d.]/g, '');
                y = +matrix.top.replace(/[^-\d.]/g, '');
            }

            return { x: x, y: y };
        },
        _animate: function (destX, destY, duration, easingFn) {
            var that = this,
                startX = this.x,
                startY = this.y,
                startTime = utils.getTime(),
                destTime = startTime + duration;

            function step () {
                var now = utils.getTime(),
                    newX, newY,
                    easing;

                if ( now >= destTime ) {
                    that.isAnimating = false;
                    that._translate(destX, destY);

                    if ( !that.resetPosition(that.options.bounceTime) ) {
                        that._execEvent('scrollEnd');
                    }

                    return;
                }

                now = ( now - startTime ) / duration;
                easing = easingFn(now);
                newX = ( destX - startX ) * easing + startX;
                newY = ( destY - startY ) * easing + startY;
                that._translate(newX, newY);

                if ( that.isAnimating ) {
                    rAF(step);
                }
            }

            this.isAnimating = true;
            step();
        },
        handleEvent: function (e) {
            switch ( e.type ) {
                case 'touchstart':
                case 'pointerdown':
                case 'MSPointerDown':
                case 'mousedown':
                    this._start(e);
                    break;
                case 'touchmove':
                case 'pointermove':
                case 'MSPointerMove':
                case 'mousemove':
                    this._move(e);
                    break;
                case 'touchend':
                case 'pointerup':
                case 'MSPointerUp':
                case 'mouseup':
                case 'touchcancel':
                case 'pointercancel':
                case 'MSPointerCancel':
                case 'mousecancel':
                    this._end(e);
                    break;
                case 'orientationchange':
                case 'resize':
                    this._resize();
                    break;
                case 'transitionend':
                case 'webkitTransitionEnd':
                case 'oTransitionEnd':
                case 'MSTransitionEnd':
                    this._transitionEnd(e);
                    break;
                case 'wheel':
                case 'DOMMouseScroll':
                case 'mousewheel':
                    this._wheel(e);
                    break;
                case 'keydown':
                    this._key(e);
                    break;
                case 'click':
                    if ( this.enabled && !e._constructed ) {
                        e.preventDefault();
                        e.stopPropagation();
                    }
                    break;
            }
        }
    };
    IScroll.utils = utils;

    if ( typeof module != 'undefined' && module.exports ) {
        module.exports = IScroll;
    } else if ( typeof define == 'function' && define.amd ) {
        define( function () { return IScroll; } );
    } else {
        window.IScroll = IScroll;
    }

})(window, document, Math);
(function(definition) {
    /* global module, define */
    if (typeof module === 'object' && typeof module.exports === 'object') {
        module.exports = definition();
    } else if (typeof define === 'function' && define.amd) {
        define([], definition);
    } else {
        var exports = definition();
        window.astar = exports.astar;
        window.AstarGraph = exports.AstarGraph;
    }
})(function() {

    function _astarPathTo(node) {
        var curr = node;
        var path = [];
        while (curr.parent) {
            path.unshift(curr);
            curr = curr.parent;
        }
        return path;
    }

    function _astarGetHeap() {
        return new BinaryHeap(function(node) {
            return node.f;
        });
    }

    var astar = {
        /**
         * Perform an A* Search on a graph given a start and end node.
         * @param {AstarGraph} graph
         * @param {GridNode} start
         * @param {GridNode} end
         * @param {Object} [options]
         * @param {bool} [options.closest] Specifies whether to return the
         path to the closest node if the target is unreachable.
         * @param {Function} [options.heuristic] Heuristic function (see
         *          astar.heuristics).
         */
        search: function(graph, start, end, options) {
            graph.cleanDirty();
            options = options || {};
            var heuristic = options.heuristic || astar.heuristics.manhattan;
            var closest = options.closest || false;

            var openHeap = _astarGetHeap();
            var closestNode = start; // set the start node to be the closest if required

            start.h = heuristic(start, end);
            graph.markDirty(start);

            openHeap.push(start);

            while (openHeap.size() > 0) {

                // Grab the lowest f(x) to process next.  Heap keeps this sorted for us.
                var currentNode = openHeap.pop();

                // End case -- result has been found, return the traced path.
                if (currentNode === end) {
                    return _astarPathTo(currentNode);
                }

                // Normal case -- move currentNode from open to closed, process each of its neighbors.
                currentNode.closed = true;

                // Find all neighbors for the current node.
                var neighbors = graph.neighbors(currentNode);

                for (var i = 0, il = neighbors.length; i < il; ++i) {
                    var neighbor = neighbors[i];

                    if (neighbor.closed || neighbor.isWall()) {
                        // Not a valid node to process, skip to next neighbor.
                        continue;
                    }

                    // The g score is the shortest distance from start to current node.
                    // We need to check if the path we have arrived at this neighbor is the shortest one we have seen yet.
                    var gScore = currentNode.g + neighbor.getCost(currentNode);
                    var beenVisited = neighbor.visited;

                    if (!beenVisited || gScore < neighbor.g) {

                        // Found an optimal (so far) path to this node.  Take score for node to see how good it is.
                        neighbor.visited = true;
                        neighbor.parent = currentNode;
                        neighbor.h = neighbor.h || heuristic(neighbor, end);
                        neighbor.g = gScore;
                        neighbor.f = neighbor.g + neighbor.h;
                        graph.markDirty(neighbor);
                        if (closest) {
                            // If the neighbour is closer than the current closestNode or if it's equally close but has
                            // a cheaper path than the current closest node then it becomes the closest node
                            if (neighbor.h < closestNode.h || (neighbor.h === closestNode.h && neighbor.g < closestNode.g)) {
                                closestNode = neighbor;
                            }
                        }

                        if (!beenVisited) {
                            // Pushing to heap will put it in proper place based on the 'f' value.
                            openHeap.push(neighbor);
                        } else {
                            // Already seen the node, but since it has been rescored we need to reorder it in the heap
                            openHeap.rescoreElement(neighbor);
                        }
                    }
                }
            }

            if (closest) {
                return _astarPathTo(closestNode);
            }

            // No result was found - empty array signifies failure to find path.
            return [];
        },
        // See list of heuristics: http://theory.stanford.edu/~amitp/GameProgramming/Heuristics.html
        heuristics: {
            manhattan: function(pos0, pos1) {
                var d1 = Math.abs(pos1.x - pos0.x);
                var d2 = Math.abs(pos1.y - pos0.y);
                return d1 + d2;
            },
            diagonal: function(pos0, pos1) {
                var D = 1;
                var D2 = Math.sqrt(2);
                var d1 = Math.abs(pos1.x - pos0.x);
                var d2 = Math.abs(pos1.y - pos0.y);
                return (D * (d1 + d2)) + ((D2 - (2 * D)) * Math.min(d1, d2));
            }
        },
        cleanNode: function(node) {
            node.f = 0;
            node.g = 0;
            node.h = 0;
            node.visited = false;
            node.closed = false;
            node.parent = null;
        }
    };

    /**
     * A graph memory structure
     * @param {Array} gridIn 2D array of input weights
     * @param {Object} [options]
     * @param {bool} [options.diagonal] Specifies whether diagonal moves are allowed
     */
    function AstarGraph(gridIn, options) {
        options = options || {};
        this.nodes = [];
        this.diagonal = !!options.diagonal;
        this.grid = [];
        for (var x = 0; x < gridIn.length; x++) {
            this.grid[x] = [];

            for (var y = 0, row = gridIn[x]; y < row.length; y++) {
                var node = new GridNode(x, y, row[y]);
                this.grid[x][y] = node;
                this.nodes.push(node);
            }
        }
        this.init();
    }

    AstarGraph.prototype.init = function() {
        this.dirtyNodes = [];
        for (var i = 0; i < this.nodes.length; i++) {
            astar.cleanNode(this.nodes[i]);
        }
    };

    AstarGraph.prototype.cleanDirty = function() {
        for (var i = 0; i < this.dirtyNodes.length; i++) {
            astar.cleanNode(this.dirtyNodes[i]);
        }
        this.dirtyNodes = [];
    };

    AstarGraph.prototype.markDirty = function(node) {
        this.dirtyNodes.push(node);
    };

    AstarGraph.prototype.neighbors = function(node) {
        var ret = [];
        var x = node.x;
        var y = node.y;
        var grid = this.grid;

        // West
        if (grid[x - 1] && grid[x - 1][y]) {
            ret.push(grid[x - 1][y]);
        }

        // East
        if (grid[x + 1] && grid[x + 1][y]) {
            ret.push(grid[x + 1][y]);
        }

        // South
        if (grid[x] && grid[x][y - 1]) {
            ret.push(grid[x][y - 1]);
        }

        // North
        if (grid[x] && grid[x][y + 1]) {
            ret.push(grid[x][y + 1]);
        }

        if (this.diagonal) {
            // Southwest
            if (grid[x - 1] && grid[x - 1][y - 1]) {
                ret.push(grid[x - 1][y - 1]);
            }

            // Southeast
            if (grid[x + 1] && grid[x + 1][y - 1]) {
                ret.push(grid[x + 1][y - 1]);
            }

            // Northwest
            if (grid[x - 1] && grid[x - 1][y + 1]) {
                ret.push(grid[x - 1][y + 1]);
            }

            // Northeast
            if (grid[x + 1] && grid[x + 1][y + 1]) {
                ret.push(grid[x + 1][y + 1]);
            }
        }

        return ret;
    };

    AstarGraph.prototype.toString = function() {
        var graphString = [];
        var nodes = this.grid;
        for (var x = 0; x < nodes.length; x++) {
            var rowDebug = [];
            var row = nodes[x];
            for (var y = 0; y < row.length; y++) {
                rowDebug.push(row[y].weight);
            }
            graphString.push(rowDebug.join(" "));
        }
        return graphString.join("\n");
    };

    function GridNode(x, y, weight) {
        this.x = x;
        this.y = y;
        this.weight = weight;
    }

    GridNode.prototype.toString = function() {
        return "[" + this.x + " " + this.y + "]";
    };

    GridNode.prototype.getCost = function(fromNeighbor) {
        // Take diagonal weight into consideration.
        if (fromNeighbor && fromNeighbor.x != this.x && fromNeighbor.y != this.y) {
            return this.weight * 1.41421;
        }
        return this.weight;
    };

    GridNode.prototype.isWall = function() {
        return this.weight === 0;
    };

    function BinaryHeap(scoreFunction) {
        this.content = [];
        this.scoreFunction = scoreFunction;
    }

    BinaryHeap.prototype = {
        push: function(element) {
            // Add the new element to the end of the array.
            this.content.push(element);

            // Allow it to sink down.
            this.sinkDown(this.content.length - 1);
        },
        pop: function() {
            // Store the first element so we can return it later.
            var result = this.content[0];
            // Get the element at the end of the array.
            var end = this.content.pop();
            // If there are any elements left, put the end element at the
            // start, and let it bubble up.
            if (this.content.length > 0) {
                this.content[0] = end;
                this.bubbleUp(0);
            }
            return result;
        },
        remove: function(node) {
            var i = this.content.indexOf(node);

            // When it is found, the process seen in 'pop' is repeated
            // to fill up the hole.
            var end = this.content.pop();

            if (i !== this.content.length - 1) {
                this.content[i] = end;

                if (this.scoreFunction(end) < this.scoreFunction(node)) {
                    this.sinkDown(i);
                } else {
                    this.bubbleUp(i);
                }
            }
        },
        size: function() {
            return this.content.length;
        },
        rescoreElement: function(node) {
            this.sinkDown(this.content.indexOf(node));
        },
        sinkDown: function(n) {
            // Fetch the element that has to be sunk.
            var element = this.content[n];

            // When at 0, an element can not sink any further.
            while (n > 0) {

                // Compute the parent element's index, and fetch it.
                var parentN = ((n + 1) >> 1) - 1;
                var parent = this.content[parentN];
                // Swap the elements if the parent is greater.
                if (this.scoreFunction(element) < this.scoreFunction(parent)) {
                    this.content[parentN] = element;
                    this.content[n] = parent;
                    // Update 'n' to continue at the new position.
                    n = parentN;
                }
                // Found a parent that is less, no need to sink any further.
                else {
                    break;
                }
            }
        },
        bubbleUp: function(n) {
            // Look up the target element and its score.
            var length = this.content.length;
            var element = this.content[n];
            var elemScore = this.scoreFunction(element);

            while (true) {
                // Compute the indices of the child elements.
                var child2N = (n + 1) << 1;
                var child1N = child2N - 1;
                // This is used to store the new position of the element, if any.
                var swap = null;
                var child1Score;
                // If the first child exists (is inside the array)...
                if (child1N < length) {
                    // Look it up and compute its score.
                    var child1 = this.content[child1N];
                    child1Score = this.scoreFunction(child1);

                    // If the score is less than our element's, we need to swap.
                    if (child1Score < elemScore) {
                        swap = child1N;
                    }
                }

                // Do the same checks for the other child.
                if (child2N < length) {
                    var child2 = this.content[child2N];
                    var child2Score = this.scoreFunction(child2);
                    if (child2Score < (swap === null ? elemScore : child1Score)) {
                        swap = child2N;
                    }
                }

                // If the element needs to be moved, swap it, and continue.
                if (swap !== null) {
                    this.content[n] = this.content[swap];
                    this.content[swap] = element;
                    n = swap;
                }
                // Otherwise, we are done.
                else {
                    break;
                }
            }
        }
    };

    return {
        astar: astar,
        AstarGraph: AstarGraph
    };
});
/*
	Create a fake worker thread of IE and other browsers
	Remember: Only pass in primitives, and there is none of the native security happening
	Only Supports Dedicated Web Workers
*/

if(!Worker)
{
    var Worker = function ( scriptFile )
    {
        var self = this ;
        var __timer = null ;
        var __text = null ;
        var __fileContent = null ;
        var onmessage ;

        self.onerror = null ;
        self.onmessage = null ;

        // child has run itself and called for it's parent to be notified
        var postMessage = function( text )
        {
            if ( "function" == typeof self.onmessage )
            {
                return self.onmessage( { "data" : text } ) ;
            }
            return false ;
        } ;

        // Method that starts the threading
        self.postMessage = function( text )
        {
            __text = text ;
            __iterate() ;
            return true ;
        } ;

        var __iterate = function()
        {
            // Execute on a timer so we dont block (well as good as we can get in a single thread)
            __timer = setTimeout(__onIterate,1);
            return true ;
        } ;

        var __onIterate = function()
        {
            try
            {
                if ( "function" == typeof onmessage )
                {
                    onmessage({ "data" : __text });
                }
                return true ;
            }
            catch( ex )
            {
                if ( "function" == typeof self.onerror )
                {
                    return self.onerror( ex ) ;
                }
            }
            return false ;
        } ;


        self.terminate = function ()
        {
            clearTimeout( __timer ) ;
            return true ;
        } ;


        /* HTTP Request*/
        var getHTTPObject = function ()
        {
            var xmlhttp;
            try
            {
                xmlhttp = new XMLHttpRequest();
            }
            catch (e)
            {
                try
                {
                    xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
                }
                catch (e)
                {
                    xmlhttp = false;
                }
            }
            return xmlhttp;
        }

        var http = getHTTPObject()
        http.open("GET", scriptFile, false)
        http.send(null);

        if (http.readyState == 4)
        {
            var strResponse = http.responseText;
            //var strResponse = http.responseXML;
            switch (http.status)
            {
                case 404: // Page-not-found error
                    alert('Error: Not Found. The requested function could not be found.');
                    break;
                case 500: // Display results in a full window for server-side errors
                    alert(strResponse);
                    break;
                default:
                    __fileContent = strResponse ;
                    // IE functions will become delagates of the instance of Worker
                    eval( __fileContent ) ;
                    /*
                    at this point we now have:
                    a delagate "onmessage(event)"
                    */
                    break;
            }
        }

        self.importScripts = function(src)
        {
            // hack time, this will import the script but not wait for it to load...
            var script = document.createElement("SCRIPT") ;
            script.src = src ;
            script.setAttribute( "type", "text/javascript" ) ;
            document.getElementsByTagName("HEAD")[0].appendChild(script)
            return true ;
        } ;

        return true ;
    } ;
}


// Other polyfills:
// https://stackoverflow.com/questions/610406/javascript-equivalent-to-printf-string-format
String.prototype.formatUnicorn = String.prototype.formatUnicorn || function () {
    var str = this.toString();
    if (arguments.length) {
        var t = typeof arguments[0];
        var key;
        var args = ("string" === t || "number" === t) ?
            Array.prototype.slice.call(arguments)
            : arguments[0];

        for (key in args) {
            str = str.replace(new RegExp("\\{" + key + "\\}", "gi"), args[key]);
        }
    }

    return str;
};

$(document).ready(function () {
    document.addEventListener("deviceready", onDeviceReady, false);
});

function onDeviceReady() {
    console.log("POCKET CITY - ON DEVICE READY");
    if (window.device) {
        try {
            if (window.device.model === 'iPhone11,8') {
                $('body').addClass("with-notch");
            }
        } catch (e) {}
    }

    if (!Global.IS_DELUXE && window.HeyzapAds) {
        HeyzapAds.start("0f416671e9ced5211bc627d6fbfe7173").then(function () {}, function (error) {});
    }

    try {
        navigator.splashscreen.hide();
    } catch (e) {
        console.log("no splashscreen to hide");
    }

    try {
        screen.orientation.lock('portrait');
    } catch (e) {
        console.log("no screen plugin to lock");
    }

    // Status bar on device
    console.log("Disabling status bar");
    try {
        StatusBar.hide();
    } catch (e) {
        console.log("no status bar to hide");
    }

    // Cordova listeners
    document.addEventListener("pause", onPause, false);
    document.addEventListener("resume", onResume, false);
    document.addEventListener("menubutton", onMenuKeyDown, false);
    document.addEventListener("backbutton", function () {
        if (window.pocketCityGame && window.pocketCityGame.activeCity) {
            pocketCityGame.back();
        }
    }, false);

    window['cordovaReady'] = true;
}

function onPause() {
    // Handle the pause event
}

function onResume() {
    // Handle the resume event
}

function onMenuKeyDown() {
    // Handle the menubutton event
}
var _ATLAS_STRUCTURES = { "structures/construction": { "1x1": ["1"], "1x2": ["1"], "2x1": ["1"], "2x2": ["1"] }, "structures/residential": { "1x1": ["a", "b", "c"], "1x2": ["a", "b"], "2x1": ["a", "b"], "2x2": ["a", "b"] }, "structures/industrial": { "1x1": ["a", "b"], "1x2": ["a"], "2x1": ["a"], "2x2": ["a"] }, "structures/commercial": { "1x1": ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j"], "1x2": ["a", "b"], "2x1": ["a"], "2x2": ["a", "b"] }, "structures/residential-u": { "1x1": ["a", "b", "c"], "1x2": ["a"], "2x1": ["a"], "2x2": ["a", "b"] }, "structures/industrial-u": { "1x1": ["a", "b"], "1x2": ["a"], "2x1": ["a"], "2x2": ["a"] }, "structures/commercial-u": { "1x1": ["a", "b", "c", "d", "e"], "1x2": ["a", "b"], "2x1": ["a"], "2x2": ["a"] }, "structures/effects2": { "1x2": ["effect-cover"] } };
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var obstructAllAroundTop = [[-2, -2], [-2, -1], [-1, -2]];
var obstructSingleUp = [[-1, -1]];
var OBSTRUCTION_SETTINGS = {
    "residential-mask/2x2-a-mask.png": [[-2, -2], [-2, -1]],
    "residential-u-mask/2x2-a-mask.png": obstructAllAroundTop,
    "residential-u-mask/2x2-b-mask.png": obstructAllAroundTop,
    "commercial-mask/1x2-b-mask.png": obstructSingleUp,
    "commercial-u-mask/1x1-a-mask.png": obstructSingleUp,
    "commercial-u-mask/1x1-b-mask.png": obstructSingleUp,
    "commercial-u-mask/1x1-c-mask.png": obstructSingleUp,
    "commercial-u-mask/1x1-d-mask.png": obstructSingleUp,
    "commercial-u-mask/1x1-e-mask.png": obstructSingleUp,
    "commercial-u-mask/1x2-a-mask.png": [[-1, -1], [-2, -1]],
    "commercial-u-mask/1x2-b-mask.png": [[-1, -1], [-2, -1]],
    "commercial-u-mask/2x1-a-mask.png": [[-1, -1], [-1, -2]],
    "commercial-u-mask/2x2-a-mask.png": obstructAllAroundTop,
    "industrial-mask/1x2-a-mask.png": [[-1, -1], [-2, -1]],
    "industrial-mask/2x1-a-mask.png": [[-1, -1], [-1, -2]],
    "industrial-u-mask/2x1-a-mask.png": [[-1, -1], [-1, -2]],
    "special-mask/cinema-mask.png": obstructSingleUp,
    "special/policelv2.png": obstructAllAroundTop,
    "special/powerplant.png": obstructAllAroundTop,
    "special2/temple.png": obstructAllAroundTop,
    "special2/castle.png": obstructAllAroundTop,
    "special2/steelmill.png": [[-1, -2]],
    "special3/dronecorp.png": [[-2, -2]],
    "special3/parking.png": obstructAllAroundTop,
    "special3-mask/obelisk-mask.png": obstructSingleUp,
    "special3-mask/banklv3-mask.png": obstructSingleUp
};

// This will be replaced by real crop settings (automated to trim all surrounding white space per sprite)
var CROP_SETTINGS = { "special3-mask/plantchow-mask.png": [0.23, 0.7, 0.27, 0.03], "special3-mask/dj-mask.png": [0.52, 0.44, 0.46, 0.53], "special-mask/powerplantsmall-mask.png": [0.31, 0.25, 0.03, 0.17], "special3-mask/animalpasture-mask.png": [0.48, 0.26, 0.04, 0.49], "special3-mask/duck-mask.png": [0.45, 0.36, 0.24, 0.24], "special3-mask/obelisk-mask.png": [0.08, 0.15, 0.29, 0.29], "residential/1x1-a.png": [0.45, 0, 0, 0], "residential/1x1-b.png": [0.39, 0, 0, 0], "residential/1x1-c.png": [0.4, 0, 0, 0], "residential-mask/1x2-b-mask.png": [0.5, 0.16, 0.28, 0], "commercial/1x1-f.png": [0.32, 0, 0, 0], "commercial/1x1-g.png": [0.31, 0, 0, 0], "industrial-u/1x1-a.png": [0.22, 0, 0, 0], "commercial-mask/1x2-a-mask.png": [0.41, 0.16, 0.33, 0.08], "special-mask/beach-mask.png": [0.37, 0.23, 0.06, 0.08], "industrial-u-mask/1x2-a-mask.png": [0.46, 0.15, 0.28, 0.04], "special-mask/cinema-mask.png": [0.1, 0.32, 0.07, 0.01], "special-mask/park1-mask.png": [0.41, 0.24, 0, 0.34], "special/watertower.png": [0.12, 0, 0, 0], "special-mask/skyrailstation-mask.png": [0.22, 0.31, 0.07, 0], "special2-mask/aquarium-mask.png": [0.48, 0.17, 0.32, 0.05], "special3-mask/banklv3-mask.png": [0.06, 0.13, 0.04, 0], "residential-mask/2x1-b-mask.png": [0.49, 0.16, 0.05, 0.33], "residential-u/1x1-b.png": [0.18, 0, 0, 0], "residential-u/1x1-a.png": [0.17, 0, 0, 0], "residential-u/1x1-c.png": [0.25, 0, 0, 0], "residential-u-mask/2x1-a-mask.png": [0.46, 0.15, 0.06, 0.31], "commercial/1x1-a.png": [0.33, 0, 0, 0], "residential-u-mask/1x2-a-mask.png": [0.49, 0.15, 0.29, 0.01], "commercial/1x1-d.png": [0.28, 0, 0, 0], "commercial/1x1-b.png": [0.31, 0, 0, 0], "commercial/1x1-e.png": [0.12, 0, 0, 0], "commercial/1x1-h.png": [0.3, 0, 0, 0], "commercial/1x1-i.png": [0.22, 0, 0, 0], "commercial/1x1-j.png": [0.19, 0, 0, 0], "commercial-u/1x1-d.png": [0, 0, 0, 0], "industrial/1x1-b.png": [0.24, 0, 0, 0], "industrial-u/1x1-b.png": [0.19, 0, 0, 0], "special3/beach2.png": [0.41, 0.03, 0.07, 0.1], "special2/pyramid.png": [0.36, 0, 0, 0], "special4-mask/mansion-mask.png": [0.35, 0.28, 0.04, 0.04], "residential-mask/1x2-a-mask.png": [0.46, 0.14, 0.3, 0.09], "commercial-u/1x1-b.png": [0.01, 0, 0, 0], "commercial-mask/1x2-b-mask.png": [0.41, 0.14, 0.27, 0.04], "commercial-u/1x1-c.png": [0, 0, 0, 0], "commercial-u-mask/2x1-a-mask.png": [0.32, 0.16, 0.04, 0.3], "industrial-mask/1x2-a-mask.png": [0.35, 0.15, 0.28, 0.04], "special/bank.png": [0.14, 0, 0, 0], "special2-mask/farmnomill-mask.png": [0.42, 0.24, 0.04, 0.04], "special2-mask/farm-mask.png": [0.43, 0.25, 0.03, 0.04], "special3-mask/rocketstation-mask.png": [0.1, 0.3, 0.11, 0.45], "residential-mask/2x1-a-mask.png": [0.52, 0.12, 0.05, 0.33], "commercial/1x1-c.png": [0.29, 0, 0, 0], "commercial-mask/2x1-a-mask.png": [0.4, 0, 0.01, 0.24], "industrial/1x1-a.png": [0.23, 0, 0, 0], "industrial-mask/2x1-a-mask.png": [0.38, 0.15, 0.02, 0.28], "industrial-u-mask/2x1-a-mask.png": [0.3, 0.16, 0.06, 0.32], "special/banklv2.png": [0.04, 0, 0, 0], "special-mask/townhall-mask.png": [0.32, 0.33, 0.36, 0.04], "special/campground.png": [0.5, 0, 0, 0], "special3/manufacturing.png": [0.4, 0, 0, 0], "special4-mask/hovercarfactory-mask.png": [0.02, 0.25, 0.03, 0.04], "commercial-u/1x1-a.png": [0, 0, 0, 0], "commercial-u/1x1-e.png": [0.06, 0, 0, 0], "commercial-u-mask/1x2-b-mask.png": [0.23, 0.14, 0.28, 0], "special/waterstation.png": [0.41, 0, 0, 0], "special2/statuecourage.png": [0.36, 0, 0, 0], "special2/skiresort.png": [0.35, 0, 0, 0], "special4/recycling.png": [0.36, 0, 0, 0], "commercial-u-mask/1x2-a-mask.png": [0.28, 0.13, 0.26, 0.05], "industrial-u/2x2-a.png": [0.29, 0, 0, 0], "special/pntower.png": [0, 0, 0, 0], "special2/artgallery.png": [0.48, 0, 0, 0], "special2/largepark.png": [0.5, 0, 0, 0], "special3/airport.png": [0.22, 0, 0, 0], "special4-mask/headbank-mask.png": [0, 0.15, 0.13, 0.12], "special3/dronecorp.png": [0.13, 0, 0, 0], "residential/2x2-b.png": [0.35, 0, 0, 0], "industrial/2x2-a.png": [0.36, 0, 0, 0], "special/latticetower.png": [0, 0, 0, 0], "special2/busdepot.png": [0.46, 0, 0, 0], "special2/school.png": [0.42, 0, 0, 0], "special3/lab.png": [0.36, 0, 0, 0], "special3/arcade.png": [0.37, 0, 0, 0], "special3-mask/zoo-mask.png": [0.48, 0.07, 0.09, 0.08], "special3/supply.png": [0.4, 0, 0, 0], "residential/2x2-a.png": [0.27, 0, 0, 0], "commercial/2x2-a.png": [0.44, 0, 0, 0], "special/hospital.png": [0.33, 0, 0, 0], "special2/castle.png": [0.18, 0, 0, 0], "special2/stadium.png": [0.33, 0, 0, 0], "special2/sawmill.png": [0.39, 0, 0, 0], "residential-u/2x2-a.png": [0.18, 0, 0, 0], "residential-u/2x2-b.png": [0.17, 0, 0, 0], "commercial/2x2-b.png": [0.3, 0, 0, 0], "special/firestation.png": [0.45, 0, 0, 0], "special/police.png": [0.4, 0, 0, 0], "special/policelv2.png": [0.29, 0, 0, 0], "special/powerplantsolar.png": [0.46, 0, 0, 0], "special2/aztec.png": [0.36, 0, 0, 0], "special2/mine.png": [0.44, 0, 0, 0], "special3/plantchow.png": [0.23, 0.12, 0.27, 0.03], "special3/marina.png": [0.44, 0.01, 0.06, 0.04], "special3/parking.png": [0.24, 0, 0, 0], "special4/nuclear.png": [0.29, 0, 0, 0], "special/powerplantsmall.png": [0.31, 0, 0, 0], "special/dockcargo.png": [0.22, 0, 0, 0], "special-mask/ferriswheel-mask.png": [0.26, 0.18, 0.13, 0.39], "special2/temple.png": [0.17, 0, 0, 0], "special3/university.png": [0.38, 0, 0, 0], "special3/obelisk.png": [0.08, 0, 0, 0], "special3/dj.png": [0.3, 0, 0, 0], "special/beach.png": [0.37, 0.03, 0.06, 0.06], "special/park1.png": [0.41, 0, 0, 0], "special/firestationlv2.png": [0.35, 0, 0, 0], "special2/steelmill.png": [0.34, 0, 0, 0], "commercial-u/2x2-a.png": [0.27, 0, 0, 0], "special/powerplant.png": [0.28, 0, 0, 0], "special3/banklv3.png": [0.06, 0, 0, 0], "industrial-u/1x2-a.png": [0.46, 0, 0.25, 0], "special/skyrailstation.png": [0.22, 0, 0, 0], "special3/duck.png": [0.45, 0.06, 0.24, 0.13], "residential/1x2-b.png": [0.5, 0, 0.25, 0], "special3/animalpasture.png": [0.48, 0, 0, 0], "special2/aquarium.png": [0.48, 0, 0.25, 0.01], "special/cinema.png": [0.1, 0, 0, 0], "residential/1x2-a.png": [0.46, 0, 0.25, 0], "residential-u/2x1-a.png": [0.46, 0, 0.01, 0.25], "residential-u/1x2-a.png": [0.49, 0, 0.25, 0], "industrial/1x2-a.png": [0.35, 0, 0.25, 0], "residential/2x1-b.png": [0.49, 0, 0.01, 0.24], "residential/2x1-a.png": [0.52, 0, 0.01, 0.25], "commercial/1x2-a.png": [0.41, 0, 0.25, 0], "commercial-u/2x1-a.png": [0.32, 0, 0.01, 0.24], "industrial-u/2x1-a.png": [0.3, 0, 0.01, 0.25], "commercial/1x2-b.png": [0.41, 0, 0.25, 0], "industrial/2x1-a.png": [0.38, 0, 0.01, 0.25], "commercial/2x1-a.png": [0.4, 0, 0.01, 0.17], "special4/mansion.png": [0.35, 0, 0, 0], "special/townhall.png": [0.32, 0, 0, 0], "commercial-u/1x2-a.png": [0.28, 0, 0.25, 0], "special4/headbank.png": [0, 0, 0, 0], "commercial-u/1x2-b.png": [0.23, 0, 0.25, 0], "special4/hovercarfactory.png": [0.02, 0, 0, 0], "special2/farmnomill.png": [0.42, 0, 0, 0], "special2/farm.png": [0.43, 0, 0, 0], "special3/zoo.png": [0.48, 0, 0, 0], "special3/rocketstation.png": [0, 0, 0, 0], "special/ferriswheel.png": [0.26, 0, 0.01, 0.23] };

var CROP_SETTINGS_FULL_FRAME = {};
// Auto set base sprites from -masks by setting bottom to 0 and using top
Object.keys(CROP_SETTINGS).forEach(function (k) {
    CROP_SETTINGS_FULL_FRAME["src/www/img-atlas/structures/" + k] = CROP_SETTINGS[k];
});

if ((typeof module === "undefined" ? "undefined" : _typeof(module)) === "object" && module && _typeof(module.exports) === "object") {
    module.exports = CROP_SETTINGS;
}
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * Globally accessible values
 */
var Global;
(function (Global) {
    Global.IS_ENGLISH = true;
    Global.QUIET_LOG = false;
    Global.IGNORE_ALL_ERRORS = false;
    Global.REGISTER_KEYBOARD_INPUT = true;
    // IOS config
    Global.IOS_SCROLL = true;
    // Cloud config
    Global.CLOUD = {
        PUBLIC_KEY: "abc",
        ENDPOINT: "https://aimyckts54.execute-api.us-east-1.amazonaws.com/prod/saves",
        ERROR_ENDPOINT: "https://aimyckts54.execute-api.us-east-1.amazonaws.com/prod/errors"
    };
    Global.IS_DELUXE = false; // to be filled in by free/deluxe deploy script
    // mostly disabled because not ready for alpha
    Global.MAX_SAVE_SNAPSHOTS = 5;
    Global.MAX_CITIES = 40;
    Global.GROUP_AUTOSAVE_IF_WITHIN = 10000; // autosaves within 10s are grouped together
    Global.AUTOSAVE_EVERY = 30 * 1000; // 30 seconds
    Global.SHIFT_EDGE = false; // Shift camera edge or not
    Global.CITY_BG_COLOR = 0x8dad5d; // global ground color
    Global.WATER_BG_COLOR = 0x44abda; // global water color
    // city size
    // must be even and divisible by city_block_divide.
    // CITY_MAX_SIZE changes based on current city
    Global.CITY_MAX_SIZE_DEFAULT = 54;
    Global.CITY_MAX_SIZE = Global.CITY_MAX_SIZE_DEFAULT;
    Global.MAP_SIZES = [Global.CITY_MAX_SIZE_DEFAULT, 78, 108];
    Global.CITY_BLOCK_SIZE = 6; //6;   // must be factor of CITY_MAX_SIZE
    Global.CITY_INITIAL_UNLOCK_OFFSET = 2;
    Global.CITY_INITIAL_BLOCKS_UNLOCKED_DIM = 4; // must be even, will be sqaured
    Global.GAME_MAX_DIM = 4000; // use this to limit resolution on high res displays. no effect when MIN_RATIO = 1
    Global.MIN_RATIO = 1;
    Global.GAME_WIDTH = window.innerWidth; // 500
    Global.GAME_HEIGHT = window.innerHeight;
    // Gameplay
    Global.MAX_LEVEL = 99;
    Global.START_MAX_CASH = 50000;
    Global.CASH_INCREASE_PER_BANK = 50000;
    Global.GENERAL_COST_PER_METRIC_INCREASE = 1000; // should not be too different than price of an expensive zone
    Global.BASE_SPECIAL_COST = 15000;
    Global.COSTS = {
        RESIDENTIAL_TILE: 500,
        COMMERCIAL_TILE: 700,
        INDUSTRIAL_TILE: 500,
        TERRAIN_TILE: 200,
        ROAD_TILE: 200,
        HIGHWAY_TILE: 200,
        SKY_RAIL_TILE: 250,
        BRIDGE_TILE: 500,
        WATER_TOWER: 2000,
        WATER_STATION: 6500,
        POWER_PLANT_SMALL: 2000,
        POWER_PLANT: 8000,
        POWER_PLANT_SOLAR: 16000,
        POWER_PLANT_NUCLEAR: 80000,
        HOSPITAL: Global.BASE_SPECIAL_COST,
        FIRE_STATION: Global.BASE_SPECIAL_COST,
        FIRE_STATION_LV2_UPGRADE: 17000,
        POLICE: Global.BASE_SPECIAL_COST,
        POLICE_LV2_UPGRADE: 17000,
        BUS_DEPOT: Global.BASE_SPECIAL_COST + 10000,
        PARKING_GARAGE: Global.BASE_SPECIAL_COST,
        AIRPORT: 50000,
        SCHOOL: 30000,
        UNIVERSITY: 60000,
        LAB: 80000,
        SUPPLY: 60000,
        RECYCLING: 75000,
        ROCKET_STATION: 1000000,
        TOWN_HALL: 0,
        MANSION: 1000000,
        HOVERCARFACTORY: 1000000,
        HEAD_BANK: 1000000,
        BANK: Global.START_MAX_CASH - 1,
        SKYRAIL_STATION: 5000,
        ROCK: 300,
        DYNAMITE: 1000,
        PLANT_CHOW: 15000,
        NAME_CHANGE: 10000,
        CHEST_UNLOCKS: 20000
    };
    // Mobile effect optimization
    Global.DISABLE_EXTRA_EFFECTS = true;
    Global.HEAVY_COST_MULTIPLIER = 2;
    Global.DEMOLISH_RETURN = 0.5;
    // Default zooms
    Global.GAME_ZOOM_DEFAULT_HEIGHT = 300; // Smaller the number greater the default zoom
    // Optimization configuration
    Global.UPDATE_GRID_TILES_EVERY_X_MILLIS = 100; // call update on priority tiles every x milliseconds
    Global.UPDATE_GRID_NON_PRIORITY_TILES_SKIP_EVERY_X_TICK = 10; // only update non-priority tiles every x updates on priority
    Global.RECALC_GRID_METRICS_EVERY = 1000;
    Global.SKIP_REFRESH_SPAWNS_CALCULATION_MAX = 10; // at low fps, skip spawn calculation this many times
    Global.NO_ANIM_UPDATE_PAST_ZOOM = 0.7;
    Global.HIDE_CYCLE_AT_ZOOM = 0.65;
    Global.HIDE_LOWER_PEDS_AT_ZOOM = 0.6;
    Global.HIDE_UPPER_PEDS_AT_ZOOM = 0.45;
    Global.UNLOCK_TAP_BUFFER = 60;
    Global.TILE_CULLING_BUFFER = 5; // will render more around camera on higher number
    Global.TILE_CULLING_MOVE_DELTA_TRIGGER = 1.5; // will render more often on move on lower
    Global.CAMERA_MOVE_SPAWN_CARS_TRIGGER = 4;
    Global.SORT_PEDESTRIANS_EVERY_X_TICK = 2; // tick only happens once every x anyway
    Global.CHECK_STUCK_PEDESTRIANS_EVERY_X_TICK = 3; // tick only happens once every x anyway
    Global.SORT_PEDESTRIANS_EVERY_MIN_TICK = 1; // sort on every x tick often, but not all the time (only when fewer sprites)
    Global.SORT_PEDESTRIANS_EVERY_MIN_TICK_WHEN_MAX_IS = 50; // Sort on each tick, only at this max count
    Global.ENABLE_ROAD_POP_IN = true;
    Global.CHECK_FIRE_EVERY_X_TICK = 20;
    Global.SYNC_LEFT_NOTIFS_EVERY = 1000;
    Global.SYNC_POWER_UI_EVERY = 1000;
    Global.START_EVENT_AFTER_CLICK_MILLIS = 500;
    Global.ALWAYS_UPDATE_ENTITIES = false;
    // Caching far out zoom
    Global.ZOOM_CACHE_AS_BITMAP = 0.4; // also used to hide far zoomout layers hiddenLayersOutZoom
    Global.CRIME_FOCUS_ZOOM_TILES = 3;
    // Traffic
    Global.UPDATE_TRAFFIC_EVERY = 100; // won't update all traffic + spawn at once
    // Effects
    Global.CAR_SPEED = 5.5; //6
    Global.SKY_RAIL_SPEED = 5;
    Global.CYCLE_SPEED = 3;
    Global.PERSON_SPEED = 0.94;
    Global.PERSON_RUN_SPEED = 4 * Global.PERSON_SPEED;
    Global.SIDEWALK_ANIMAL_SPEED = 1.3;
    Global.ANIMATE_CAR_IN = true;
    // Grid Alpha
    Global.BUILD_ALPHA = 0.8;
    Global.STRUCTURE_DURING_BUILD_ALPHA = 0.2;
    Global.STRUCTURE_DURING_RESOURCE_ALPHA = 0.3;
    // Zoom / Touch
    Global.ZOOM_MIN = 0.1;
    Global.ZOOM_MAX = 3.0;
    Global.ZOOM_MIN_OG = Global.ZOOM_MIN;
    Global.ZOOM_MAX_OG = Global.ZOOM_MAX;
    Global.ZOOM_ALLOWED_EVERY_X_MILLIS = 50;
    Global.ZOOM_MULTIPLIER = 10;
    Global.MIN_TILES_HORIZONTAL_VISIBLE_FOR_ZOOM = 6; // tiles to show for build zoom
    Global.RANDOM_MAP_ZOOM_OUT_DEFAULT = 0.3;
    Global.ZOOM_FOCUS_ADJUST_IF_LT_X_TILES_VISIBLE = 4;
    Global.ZOOM_FOCUS_TO_TILES_VISIBLE = 6;
    Global.MIN_TOUCH_DRAG_TILE_PX_HELP = 30; // when tiles are too small on far away zoom, this will let user touch near it to drag it
    Global.DRAG_TILE_HELPER_MAX_DELTA = 30; // how much buffer to give the user
    Global.MAX_TAP_MOVE_THRESHOLD = 0.15;
    Global.MAX_TAP_HOLD_THRESHOLD = 1000;
    // Build Gameplay configuration
    Global.DELAY_MILLS_CONSEC_BUILD_TOTAL = 300;
    Global.ZONE_BUILD_BASE_DAYS = 0.4; //0.2;//2;        // Speed of building development
    //export const =ONE_BUILD_BASE_DAYS: 0; // instant build
    Global.ZONE_BUILD_BASE_DAYS_SANDBOX = 0.05;
    Global.BUILDING_SPEED_BASE = 0.075; // higher is faster - build per day
    Global.LARGE_BUILDING_EXTRA_TIME = 0.35; // higher is slower larger buildings
    Global.EASE_CAMEAR_LAST_BUIILD_TILE = false;
    Global.UNLOCK_TAXES_LV = 1;
    Global.UNLOCK_LOANS_LV = 22;
    Global.SANDBOX_CASH = 999999;
    Global.TILE_WIDTH = 60; // do not change
    Global.TILE_WIDTH_INVERSE = 1 / 60;
    // Special visual Effects
    Global.SPIN_DESTROY_TIME_MIN = 1000;
    Global.SPIN_DESTROY_TIME_MAX = 1500;
    // minor ui tweaking
    Global.NEW_GAME_CAMERA_ZOOM_DIFF_ANIM = 0.5;
    Global.CAMERA_CENTRE_TILE_Y_OFFSET = 0.55;
    Global.CAMERA_MOVE_TIME_PER_TILE = 120;
    Global.CAMERA_TIME_PER_SCALE_TICK = 110;
    Global.EXTERNAL_DEMAND_BASE = 0.5; // attractiveness demand - only visual, does not affect calc
    // Touch tweaking
    Global.INSPECT_TILE_TOUCH_MOVE_MAX = 0.01; // this is a percentage of total dimension
    Global.INSPECT_TILE_TOUCH_TIME_DELTA_MAX = 300;
    // UI configuration
    Global.SHOW_PROGRESS_BAR = true;
    // Seeds
    Global.TERRAIN_SEED = 510;
    Global.DEFAULT_CHEST_SEED = 250;
    // Optimizations
    Global.WARM_UP_IMAGE_DECODE = true;
    Global.ZOOM_CULL_INTERVAL = 0.01;
    Global.MAX_ON_SCREEN_PEDS = 60;
    Global.MAX_ON_SCREEN_CARS = 60;
    Global.MAX_ON_SCREEN_CYCLES = 30;
    Global.MAX_COMMIT_WITH_ANIM = 50; // if more than this, don't animate workers, etc
    // Debug state
    Global.DEBUG_HIDE_ALL = !true; // headless true
    Global.DEBUG_TEST_RUN = !true; // $ new TestRun(pocketCityGame)
    Global.DEBUG_TEST_FPS = !true; // $ new TestFPSRun(pocketCityGame)
    Global.DEBUG_SKIP_HOME_SCREEN = false;
    Global.DEBUG_PERFORMANCE = !true;
    Global.DEBUG_METRICS = !true;
    Global.DEBUG_FORCE_HIDE_STRUCT_BUILD = !true;
    // for testing
    Global.DISABLE_METRIC_SIDE_EFFECTS = false;
    Global.DISABLE_POWER_SYNC = false;
    // debug touch mechanics
    Global.DEBUG_CLICK_TO_SET_ON_FIRE = false;
    Global.DEBUG_DISABLE_INSPECT = false;
    Global.DEBUG_CONSOLE_LOG_TO_HTML = false; // requires uncommented line in head debug html
    // Convenience debugs for unlocking
    Global.DEBUG_ALL_RESOURCES_FULL = false;
    Global.DEBUG_ALL_UNLOCKED_ZONES = false;
    // Debug mechanics
    Global.DEBUG_RANDOM_CARS = false;
    Global.DEBUG_DISABLE_TRAFFIC = false;
    Global.DEBUG_DISABLE_SKY_RAIL = false;
    Global.DEBUG_SINGLE_GRAPH_ENTITY = false; // just spawn one of each
    Global.DEBUG_ONLY_TRUCKS = false;
    // Visual element debug
    Global.DEBUG_CULLING_GRID = false;
    Global.DEBUG_SHOW_ROAD_PIVOTS = false; // during build
    Global.DEBUG_SHOW_SIDEWALK_GRAPH = !true; // render debug graph lines for traffic too. prints wrong when too many?
    // Print touched tile info
    Global.DEBUG_ALWAYS_FILL = false; // max size all tiles force
    Global.DEBUG_TOUCH = false;
    // Error checking
    Global.DEBUG_CHECK_ANIMATIONS = false;
    Global.DEBUG_EXTRA_CULL_CHECK = true;
    // Debug-only elements in UI
    Global.DEBUG_FPS = true;
    Global.DEBUG_FPS_ADDITIONAL = false;
    Global.DEBUG_PRINT_SAVE_STATE = !true;
    // OPTIMIZATION TESTING (DISABLING CERTAIN SECTIONS)
    Global.DEBUG_DISABLE_CANVAS_UI = false; // 10 fps drop
    Global.DEBUG_DISABLE_TERRAIN = false; // no difference in fps
    Global.DEBUG_SHOW_NUM_LISTENERS_RESIZE = false;
    Global.SHOW_ROAD_BURST = false;
    Global.TEST_MODE = false;
    Global.INTERNAL_VERSION = 1;
    // Money
    Global.TERRAIN_UNLOCK = 50;
    Global.TUTORIAL_ROAD_CASH = Global.COSTS.ROAD_TILE * 8;
    Global.START_CASH = Global.COSTS.RESIDENTIAL_TILE * 6 + Global.COSTS.COMMERCIAL_TILE * 4 + Global.COSTS.INDUSTRIAL_TILE * 4 + Global.TUTORIAL_ROAD_CASH + Global.COSTS.POWER_PLANT_SMALL + Global.COSTS.WATER_TOWER + 15000 // extra start cash
    ;
    Global.RACE_EVENT_REWARD = 50000;
    Global.ROCKET_REWARD_CASH = 100000;
    Global.ROCKET_REWARD_CASH_MAX = 5;
    Global.getTotalCityBlocks = function (city) {
        var maxSize = Global.CITY_MAX_SIZE;
        if (city) {
            maxSize = city.size;
        }
        var _tmpBlockSides = maxSize / Global.CITY_BLOCK_SIZE;
        return _tmpBlockSides * _tmpBlockSides;
    };
})(Global || (Global = {}));
// Debugging
Object.keys(Global).forEach(function (k) {
    if (k.indexOf("DEBUG") !== -1 && Global[k]) {
        console.log("WARN: Debug option turned on: ", k, " - will be disabled for production");
    }
});
// Prod mode
if (window['isProd']) {
    console.log("Running PROD - disabling all debug flags");
    Object.keys(Global).forEach(function (k) {
        if (k.indexOf("DEBUG") !== -1) {
            Global[k] = false;
        }
    });
}
if (Global.DEBUG_CONSOLE_LOG_TO_HTML) {
    setTimeout(function () {
        $('#log').show();
    }, 0);
    console.log = function (message) {
        if ((typeof message === "undefined" ? "undefined" : _typeof(message)) == 'object') {
            $('#log').html($('#log').html() + (JSON && JSON.stringify ? JSON.stringify(message) : message) + '<br />');
        } else {
            $('#log').html($('#log').html() + message + '<br />');
        }
    };
}
if (Global.IGNORE_ALL_ERRORS) {
    console.log("WARN: IGNORE_ALL_ERRORS should only be enabled for browser mode");
}
var MENU_NAMES = {
    EVENTS_BTN: "이벤트",
    REPORT_TAB: "보고",
    OPTIONS_TAB: "옵션",
    POLICIES_TAB: "정책",
    STATS_BTN: "통계",
    GOODS_BTN: "상품"
};
// Balance constants
var Balance;
(function (Balance) {
    // ==================
    // General
    // ==================
    // overall boost
    Balance.EARLY_GAME_SALES_BOOST = 0.2; // + this much mult
    Balance.EARLY_GAME_SALES_BOOST_END_POP = 1500;
    Balance.FIXED_ATTRACTIVENESS_LV_2_MULT_DAMPEN = 0.6; // to encourage building other zone types
    //export const EARLY_GAME_MAX_SPEND_BOOST = 0; // + this much mult
    //export const EARLY_GAME_MAX_SPEND_BOOST_END_POP = 500;
    Balance.EARLY_GAME_UPKEEP_REDUCTION = 0.15;
    Balance.EARLY_GAME_UPKEEP_REDUCTION_END_POP = 2000;
    Balance.STRUCTURE_SIZE_EFFECT_EXP_MULT = 1.25;
    Balance.SPENDING_VARIABLE_ON_HAPPINESS = 0.75;
    // additional weight of lowest happiness metric at start of game
    Balance.HAP_LOWEST_MIN_WEIGHT = 0.2;
    // additional weight of lowest happiness metric at end of game
    Balance.HAP_LOWEST_MAX_WEIGHT = 0.7;
    // Tiles
    Balance.INDUSTRIAL_TILE_MAX_COST_REDUCTION = Global.COSTS.INDUSTRIAL_TILE * 0.5;
    Balance.UPGRADE_COST_MULT = 1.5;
    Balance.UPGRADE_UNLOCK_LV = 30;
    // ==========
    // Early game
    // ==========
    Balance.EARLY_GAME_BOOST_MAX_POP = 150;
    Balance.EARLY_GAME_BOOST_NUM_ATTRACT = 15; // attract extra X per sec, scaled to 0 by EARLY_GAME_BOOST_MAX_POP
    // ============
    // Experience
    // ============
    Balance.EXPERIENCE_PER_TILE_BUILT = 30;
    Balance.EXPERIENCE_PER_TILE_MULTIPLIER = 1.00; // scaling increase of exp per tile - (none rightnow)
    Balance.LEVEL_EXP_BASE = 1500;
    Balance.LEVEL_EXP_DIFF_PER_LEVEL = 150;
    Balance.MAX_COST_INCREASE_ZONE_TILES = 10; // scaling cost at level 99, costs for zones are this much more
    // ==================
    // Population balance
    // ==================
    Balance.MAX_POP_PER_RESIDENTIAL = 10; // base val for # of citizens that can live pre res tile
    Balance.MAX_POP_PER_UPGRADED_RESIDENTIAL = 50; // base val for # of citizens living in upgraded res tile
    // GAINS
    Balance.ATTRACT_POP_PER_INDUSTRIAL = 2;
    Balance.ATTRACT_POP_PER_COMMERCIAL = 2;
    Balance.ATTRACT_POP_PER_RESIDENTIAL = 1;
    Balance.ATTRACT_POP_PER_LANDMARK_UNIT = 5; // e.g. City tower
    // DRAINS
    Balance.POP_LOSS_UNSUFFICIENT_HOUSING = 0.05; // Don't lose all population at once, slowly lose them
    Balance.POP_LOSS_UNSUFFICIENT_HOUSING_MIN = 0;
    Balance.POP_LOSS_UNSUFFICIENT_HOUSING_MAX = 200; // max want to leave
    Balance.POP_LOSS_UNSUFFICIENT_JOBS = 0.5;
    Balance.POP_LOSS_UNSUFFICIENT_JOBS_MIN = 0;
    Balance.POP_LOSS_UNSUFFICIENT_JOBS_MAX = 200; // max want to leave
    // max of the following two will be used to determine max change
    Balance.MAX_POP_CHANGE_PER_TICK = 5;
    Balance.MAX_POP_CHANGE_PERCENT_PER_TICK = 0.1;
    Balance.MAX_POP_CHANGE_LOSS_PERCENT_PER_TICK = 0.01;
    Balance.ATTRACTIVE_LOSS_FROM_POLLUTION_HOUSING = 0.5; // partial # citizens lost * pollution percent
    Balance.LOSS_PERCENT_UNHAPPY = 0.5;
    // ==================
    // Workforce balance
    // ==================
    Balance.WORKING_POP_RATIO = 0.75; // % of citizens that work and need jobs
    Balance.JOBS_PER_INDUSTRIAL = 25; // base val for # of jobs per industrial tile
    Balance.JOBS_PER_INDUSTRIAL_UPGRADED = 50; // base val for # of jobs per upgraded industrial tile
    Balance.PERCENT_COM_JOBS_VS_INDUSTRIAL_EDUCATED = 0.5;
    // ==================
    // Economy balance
    // ==================
    Balance.OVERALL_SALE_TAX_MULTIPLIER = 0.85; // global change for balance
    Balance.TAX_HAPPINES_WEIGHT = 0.4; // global weight of taxes on happiness
    Balance.TAX_HAPPINES_HIGH_EXTRA_WEIGHT = 0.2; // global extra weight of taxes on lower than 0.5 satisfaction
    Balance.DEFAULT_TAX_HAPPINESS = 0.8; // at moderate all
    Balance.LOAN_INTEREST = 0.15;
    Balance.SALES_TAX_SETTING_INCOME_EFFECT_REDUCTION = 0.5; // reduce variance from normal from low/high taxes by this much
    Balance.DRONE_SALARY_BOOST = 1.1;
    //export const MAX_HAPPINESS_POSSIBLE_WITH_ZERO_TAX_SATISFACTION = 1 - TAX_HAPPINES_WEIGHT;
    // otherwise, too effective
    // GAINS
    Balance.SPEND_PER_CITIZEN = 1.5; // sales income population cap - max dollars that per citizens are willing to spend per second. based on population size
    Balance.INCOME_PER_COMMERCIAL = 15; // sales income commercial tile cap - MAX dollars that are generated at each commercial tile - higher = less commecial demand
    // keep this relatively unchanged or early econ quest will be all thrown off
    Balance.INCOME_PER_COMMERCIAL_UPGRADED = 30; // sales income on upgraded tiles
    Balance.INCOME_PER_WORKING_POP_TAX = 0.6; // income per working population
    Balance.PROPERTY_TAX_PER_TILE = 5; // dollars that each income generates from property tax
    // DRANS
    Balance.UPKEEP_PER_TILE = 10; // Cost of upkeep per zone tile, general
    // bank lv2
    Balance.BANK_UPGRADE_EFFECT_MULT = 3;
    Balance.BANK_UPGRADE_EFFECT_MULT_LV3 = 6;
    // Exports
    Balance.ENABLE_EXPORTS_LV = 18;
    // Import / Export
    Balance.FOOD_REQ_PER_POP_PER_SEC = 0.3;
    Balance.FOOD_REQ_SCALING_START_POP = 1500;
    Balance.FOOD_REQ_MAX_SCALE = 1; // + this much mult
    Balance.FOOD_SCALE_MAX_POP = 15000;
    var FOOD_SCALE_DELTA = Balance.FOOD_SCALE_MAX_POP - Balance.FOOD_REQ_SCALING_START_POP;
    Balance.getFoodReqForPop = function (population) {
        if (population <= Balance.FOOD_REQ_SCALING_START_POP) {
            return Balance.FOOD_REQ_PER_POP_PER_SEC;
        }
        return Balance.FOOD_REQ_PER_POP_PER_SEC * (1 + Balance.FOOD_REQ_MAX_SCALE * Math.min(1, (population - Balance.FOOD_REQ_SCALING_START_POP) / FOOD_SCALE_DELTA));
    };
    Balance.FOOD_REQ_MULT_INCREASE_PER_LEVEL = 0.005; // in dollars, extra scaling cost
    // population material
    Balance.MATERIALS_REQ_PER_POP_PER_SEC = 0.025;
    Balance.MATERIALS_REQ_SCALING_START_POP = 2000;
    Balance.MATERIALS_REQ_MAX_SCALE = 1; // + this much mult
    Balance.MATERIALS_SCALE_MAX_POP = 20000;
    var MATERIAL_SCALE_DELTA = Balance.MATERIALS_SCALE_MAX_POP - Balance.MATERIALS_REQ_SCALING_START_POP;
    Balance.getMaterialsReqForPop = function (population) {
        if (population <= Balance.MATERIALS_REQ_SCALING_START_POP) {
            return Balance.MATERIALS_REQ_PER_POP_PER_SEC;
        }
        return Balance.MATERIALS_REQ_PER_POP_PER_SEC * (1 + Balance.MATERIALS_REQ_MAX_SCALE * Math.min(1, (population - Balance.MATERIALS_REQ_SCALING_START_POP) / MATERIAL_SCALE_DELTA));
    };
    // zone material
    Balance.MATERIALS_REQ_PER_ZONE = 2; // in dollars
    Balance.STEEL_MILL_INDUSTRIAL_TILE_PER_REDUCE = Global.COSTS.INDUSTRIAL_TILE * 0.1;
    // - the default export amt per sec, in dollars
    Balance.BASE_EXPORT_PER_BUILDING = 150; // export cap per resource
    Balance.ANIMAL_PASTURE_MULTIPLIER = 2; // animal pasture increases food by this much
    Balance.BASE_EXPORT_FOOD_UNIT = 450;
    Balance.BASE_EXPORT_NATURAL_UNIT = 150;
    Balance.BASE_EXPORT_PER_TREE = 50;
    Balance.BASE_MATERIAL_UNIT = 300;
    // ==================
    // Special services
    // ==================
    Balance.FIRESTATION_REQUIRED_EVERY_X_CITIZENS = 1000;
    Balance.HOSPITALS_REQUIRED_EVERY_X_CITIZENS = 2000;
    Balance.RECREATION_REQUIRED_EVERY_X_CITIZENS = 50;
    // ==================
    // Environment
    // ==================
    Balance.MAX_GLOBAL_ENV_REDUCTION = 0.4; // global effects of trees, other buildings, etc...
    Balance.BASE_POLLUTION = 0.15;
    Balance.POLLUTION_REDUCTION_STRUCT_BASE_MULT = 0.75; // not for the 0 -> 1 range, but for muliplying with base_pollution
    Balance.ENV_REQUIRED_PER_CITIZEN = 0.005; // more citizens = more environment required
    Balance.BUS_ENV_REDUCTION = 0.1;
    Balance.NUM_BUS_STOP_MAX_ENV_REDUCE = 5;
    // ==================
    // Crime
    // ==================
    Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV = 9;
    Balance.CRIME_PERCENT_POPULATION = 0.1;
    Balance.CRIME_PERCENT_NO_JOBS = 0.5;
    Balance.SMALL_CRIME_EFFECT = 0.1;
    Balance.SMALL_DURATION = 30 * 1000;
    Balance.CRIME_MIN_POPULATION = 1; // basically anytime
    Balance.DRONE_CRIME_REDUCE = 0.1;
    // crime grid
    Balance.CRIME_PER_COMMERCIAL = 0.05;
    Balance.CRIME_COMMERCIAL_RANGE = 4;
    Balance.MAX_CRIME_PERCENT = 0.95; // if this amt of tiles have 100% crime, we are at 0% crime safety
    Balance.POLICE_GLOBAL_PERCENT_REDUCE_CRIME = 0.25; // global reduction of crime per police
    Balance.CRIME_MAX_CRIMINAL_POP_INCREASE = 0.5; // % of population that are criminals increases base crime by this much at most
    // ==============
    // Fire
    // ==============
    Balance.FIRE_ENABLE_AND_UNLOCK_FIRE_STATION_LV = 7;
    Balance.FIRE_MIN_POPULATION = 1; // basically anytime
    Balance.FIRE_SPREAD_DELAY = 20000;
    Balance.DEFAULT_DURATION_UNTIL_DESTROY = 25000; // revert
    Balance.NUCLEAR_FIRE_DURATION = 7000;
    Balance.NUCLEAR_FIRE_FAST_DURATION = 1500;
    Balance.MAX_FIRE_SPREAD = 3; // actually spreads 1 less than this number
    // ===========
    // Recreation
    // ===========
    Balance.VARIANCE_BOOST = 1.5;
    // ==================
    // Scaling difficulty
    // ==================
    // higher level and pop scaling
    Balance.POLLUTION_SCALING_MAX = 0.2; // 1.2x pollution at hih level
    Balance.BASELINE_UPKEEP = -50;
    Balance.UPKEEP_INCREASE_PER_LV = 0.006;
    Balance.UPKEEP_MULTIPLIER_INCREASE_PER_1000_POP = 0.03; // useful for scaling out later pops
    Balance.UPKEEP_DIVISOR_FIX = 1.35; // avg building size random is 1.53, higher is less upkeep
    Balance.UPKEEP_REDUCE_TO_HIGH_POP = 0.06;
    Balance.UPKEEP_REDUCE_TO_HIGH_POP_AMT = 25000; // max pop
    Balance.UPKEEP_REDUCE_TO_HIGH_POP_MIN_AMT = 2000; // min pop
    Balance.INCOME_REDUCTION_START_LV = 15;
    Balance.INCOME_REDUCTION_MAX = 0.2; // at level 100, this is how much income is dampened
    // =========
    // Unlocks
    // =========
    Balance.SKYRAIL_UNLOCK = 26;
})(Balance || (Balance = {}));
/** City-specific difficulty settings */
var Difficulty;
(function (Difficulty) {
    //
    // Constants
    //
    // do not change this enum
    var DIFFICULTY;
    (function (DIFFICULTY) {
        DIFFICULTY[DIFFICULTY["NORMAL"] = 0] = "NORMAL";
        DIFFICULTY[DIFFICULTY["HARD"] = 1] = "HARD";
        DIFFICULTY[DIFFICULTY["EXPERT"] = 2] = "EXPERT";
    })(DIFFICULTY = Difficulty.DIFFICULTY || (Difficulty.DIFFICULTY = {}));
    Difficulty.HARD_MODE_FINISH_KEY = "hm_complete";
    Difficulty.EXPERT_MODE_FINISH_KEY = "em_complete";
    // balance
    Difficulty.DIF_MULT = {
        CRIME: (_a = {}, _a[DIFFICULTY.HARD] = 2, _a[DIFFICULTY.EXPERT] = 3, _a),
        FIRE: (_b = {}, _b[DIFFICULTY.HARD] = 2, _b[DIFFICULTY.EXPERT] = 3, _b),
        HEALTH: (_c = {}, _c[DIFFICULTY.HARD] = 1.5, _c[DIFFICULTY.EXPERT] = 2, _c),
        SALES_TAX: (_d = {}, _d[DIFFICULTY.HARD] = 0.8, _d[DIFFICULTY.EXPERT] = 0.65, _d),
        INCOME_TAX: (_e = {}, _e[DIFFICULTY.HARD] = 0.8, _e[DIFFICULTY.EXPERT] = 0.65, _e),
        PROPERTY_TAX: (_f = {}, _f[DIFFICULTY.HARD] = 0.8, _f[DIFFICULTY.EXPERT] = 0.65, _f),
        TRAFFIC_DENSITY: (_g = {}, _g[DIFFICULTY.HARD] = 1.25, _g[DIFFICULTY.EXPERT] = 1.5, _g),
        RECREATION_REQ: (_h = {}, _h[DIFFICULTY.HARD] = 1.5, _h[DIFFICULTY.EXPERT] = 2, _h),
        LAND_PRICE: (_j = {}, _j[DIFFICULTY.HARD] = 1.5, _j[DIFFICULTY.EXPERT] = 2, _j)
    };
    // saving
    Difficulty.DIFFICULTY_GLOBAL_SAVE_KEY = "difficulty";
    //
    // Public functions
    //
    /** Immediately changes and saves difficulty setting */
    function setDifficulty(city, dif) {
        city.citySaveHelper.setGlobalSetting(Difficulty.DIFFICULTY_GLOBAL_SAVE_KEY, dif);
        city.gameplayUI.syncTopLeftDifficulty();
    }
    Difficulty.setDifficulty = setDifficulty;
    /** Returns the difficulty enum for a city*/
    function getDifficulty(city) {
        return city.citySaveHelper.getGlobalSetting(Difficulty.DIFFICULTY_GLOBAL_SAVE_KEY, DIFFICULTY.NORMAL);
    }
    Difficulty.getDifficulty = getDifficulty;
    // todo: test that metrics are all affected on the same city
    function getCrimeMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.CRIME, city);
    }
    Difficulty.getCrimeMult = getCrimeMult;
    function getFireMult(city) {
        if (city.stats.internalVersion >= 1) {
            return 1; // always use multiplier of 1, people don't like upscaled amt
        }
        return _getDifMultFor(Difficulty.DIF_MULT.FIRE, city);
    }
    Difficulty.getFireMult = getFireMult;
    function getHealthMult(city) {
        if (city.stats.internalVersion >= 1) {
            return 1; // always use multiplier of 1, people don't like upscaled amt
        }
        return _getDifMultFor(Difficulty.DIF_MULT.HEALTH, city);
    }
    Difficulty.getHealthMult = getHealthMult;
    function getSalesTaxMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.SALES_TAX, city);
    }
    Difficulty.getSalesTaxMult = getSalesTaxMult;
    function getIncomeTaxMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.INCOME_TAX, city);
    }
    Difficulty.getIncomeTaxMult = getIncomeTaxMult;
    function getPropertyTaxMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.PROPERTY_TAX, city);
    }
    Difficulty.getPropertyTaxMult = getPropertyTaxMult;
    function getTrafficDensityMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.TRAFFIC_DENSITY, city);
    }
    Difficulty.getTrafficDensityMult = getTrafficDensityMult;
    function getRecreationReqMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.RECREATION_REQ, city);
    }
    Difficulty.getRecreationReqMult = getRecreationReqMult;
    function getLandPriceMult(city) {
        return _getDifMultFor(Difficulty.DIF_MULT.LAND_PRICE, city);
    }
    Difficulty.getLandPriceMult = getLandPriceMult;
    function _getDifMultFor(multObj, city) {
        var dif = getDifficulty(city);
        return dif ? multObj[dif] : 1;
    }
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
})(Difficulty || (Difficulty = {}));
/**
 * Additional global variables for the DELUXE EDITION of pocket city
 * Updates global object
 * .txt to avoid globbing
 * */
Global.IS_DELUXE = true;
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * Static helper Class
 */
var Utils;
(function (Utils) {
    var REUSE_CACHE_INDEX = {
        "col": 0,
        "row": 0
    };
    var REUSE_CACHE_POSITION = {
        "x": 0,
        "y": 0
    };
    var REUSE_MATRIX_INT = [];
    var REUSE_MATRIX_BOOLEAN = [];
    var _reuseI, _reuseJ;
    Utils._reuseArr = [];
    Utils._reuseArr2 = [];
    var _delayFunctions = [];
    var _reuseEligigle = [];
    Utils._reuseStringArr = [];
    Utils._reuseFourTileExistObjects = [{ 0: true, 1: "" }, { 0: true, 1: "" }, { 0: true, 1: "" }, { 0: true, 1: "" }];
    Utils.touchOffsets = [[0, -1], [0, 1], [1, 0], [-1, 0]];
    function resetUtils(citySize) {
        REUSE_MATRIX_INT = [];
        for (_reuseI = 0; _reuseI < citySize; _reuseI++) {
            REUSE_MATRIX_INT[_reuseI] = [];
            for (_reuseJ = 0; _reuseJ < citySize; _reuseJ++) {
                REUSE_MATRIX_INT[_reuseI][_reuseJ] = 0;
            }
        }
        REUSE_MATRIX_BOOLEAN = [];
        for (_reuseI = 0; _reuseI < citySize; _reuseI++) {
            REUSE_MATRIX_BOOLEAN[_reuseI] = [];
            for (_reuseJ = 0; _reuseJ < citySize; _reuseJ++) {
                REUSE_MATRIX_BOOLEAN[_reuseI][_reuseJ] = false;
            }
        }
        Utils._reuseArr = [];
        Utils._reuseArr2 = [];
        _delayFunctions = [];
    }
    Utils.resetUtils = resetUtils;
    // Caching
    function getReusableBoolGrid(defaultValue) {
        if (defaultValue === void 0) {
            defaultValue = 0;
        }
        Utils.setAll2D(REUSE_MATRIX_INT, defaultValue);
        return REUSE_MATRIX_INT;
    }
    Utils.getReusableBoolGrid = getReusableBoolGrid;
    function getClearedMatrixIntReuse() {
        var startRow = 0;
        var startCol = 0;
        var endRow = REUSE_MATRIX_INT.length;
        var endCol = REUSE_MATRIX_INT[0].length;
        for (var i = startRow; i < endRow; i++) {
            for (var j = startCol; j < endCol; j++) {
                REUSE_MATRIX_INT[i][j] = 0;
            }
        }
        return REUSE_MATRIX_INT;
    }
    Utils.getClearedMatrixIntReuse = getClearedMatrixIntReuse;
    function getClearedMatrixBooleanReuse() {
        var startRow = 0;
        var startCol = 0;
        var endRow = REUSE_MATRIX_BOOLEAN.length;
        var endCol = REUSE_MATRIX_BOOLEAN[0].length;
        for (var i = startRow; i < endRow; i++) {
            for (var j = startCol; j < endCol; j++) {
                REUSE_MATRIX_BOOLEAN[i][j] = false;
            }
        }
        return REUSE_MATRIX_BOOLEAN;
    }
    Utils.getClearedMatrixBooleanReuse = getClearedMatrixBooleanReuse;
    // serializing indices as keys
    // convert between single value and split row col value
    function toIndexKey(r, c, size) {
        return r * size + c;
    }
    Utils.toIndexKey = toIndexKey;
    function toRowCol(key, size) {
        key = +key;
        var r = Math.floor(key / size);
        var c = key % size;
        return [r, c];
    }
    Utils.toRowCol = toRowCol;
    var _rowColReuse = [0, 0];
    function toRowColReuse(key, size) {
        key = +key;
        _rowColReuse[0] = Math.floor(key / size);
        _rowColReuse[1] = key % size;
        return _rowColReuse;
    }
    Utils.toRowColReuse = toRowColReuse;
    function resetObject(obj) {
        for (var k in obj) {
            if (obj.hasOwnProperty(k)) {
                delete obj[k];
            }
        }
    }
    Utils.resetObject = resetObject;
    function reverseInPlace(array) {
        var i = 0,
            n = array.length,
            middle = Math.floor(n / 2),
            temp = null;
        for (; i < middle; i += 1) {
            temp = array[i];
            array[i] = array[n - 1 - i];
            array[n - 1 - i] = temp;
        }
    }
    Utils.reverseInPlace = reverseInPlace;
    /**************
     * General
     *************/
    /**
     * Returns whether or not a value is defined (not null and not undefined)
     * @param val
     * @returns {boolean}
     */
    function isDefined(val) {
        return val !== null && typeof val !== 'undefined';
    }
    Utils.isDefined = isDefined;
    function deepCompare(x, y) {
        if (x === y) return true;
        if (!(x instanceof Object) || !(y instanceof Object)) return false;
        if (x.constructor !== y.constructor) return false;
        for (var p in x) {
            if (!x.hasOwnProperty(p)) continue;
            if (!y.hasOwnProperty(p)) return false;
            if (x[p] === y[p]) continue;
            if (_typeof(x[p]) !== "object") return false;
            if (!deepCompare(x[p], y[p])) return false;
        }
        for (var p in y) {
            if (y.hasOwnProperty(p) && !x.hasOwnProperty(p)) return false;
        }
        return true;
    }
    Utils.deepCompare = deepCompare;
    /**
     * Applies function across every element in 2D array
     * @param array {Array} - 2D array
     * @param fn {Function} - transformation fn (item, row, col)
     * @param [mutate] {Boolean}
     * @returns {Array}
     */
    function apply2D(array, fn, mutate) {
        if (mutate === void 0) {
            mutate = false;
        }
        var endRow = array.length;
        var endCol = array[0].length;
        for (var i = 0; i < endRow; i++) {
            for (var j = 0; j < endCol; j++) {
                var curI = i;
                var curJ = j;
                var newVal = fn(array[curI][curJ], curI, curJ);
                if (mutate) array[curI][curJ] = newVal;
            }
        }
        return array;
    }
    Utils.apply2D = apply2D;
    /**
     * Returns new 2D array created by mapping over 2D arrray
     * calls callback with (tile, row, col)
     * @param array
     * @param fn
     * @returns {*}
     */
    function map2D(array, fn) {
        var endRow = array.length;
        var endCol = array[0].length;
        var newArr = initialize2DArray(endRow, endCol);
        for (var i = 0; i < endRow; i++) {
            for (var j = 0; j < endCol; j++) {
                newArr[i][j] = fn(array[i][j], i, j);
            }
        }
        return newArr;
    }
    Utils.map2D = map2D;
    /*
    Copy and paste alternative (faster)
    let s = this.city.size;
    for (let i = 0; i < s; i++) {
        for (let j = 0; j < s; j++) {
         }
    }
     */
    function foreach2D(array, fn) {
        var endRow = array.length;
        var endCol = array[0].length;
        for (var i = 0; i < endRow; i++) {
            for (var j = 0; j < endCol; j++) {
                fn(array[i][j], i, j);
            }
        }
    }
    Utils.foreach2D = foreach2D;
    function foreach2DSkip2(array, fn) {
        var endRow = array.length;
        var endCol = array[0].length;
        for (var i = 0; i < endRow; i += 2) {
            for (var j = 0; j < endCol; j += 2) {
                fn(array[i][j], i, j);
            }
        }
    }
    Utils.foreach2DSkip2 = foreach2DSkip2;
    function foreachValInObject(obj, fn) {
        for (var k in obj) {
            if (obj.hasOwnProperty(k) && obj[k]) {
                fn(obj[k]);
            }
        }
    }
    Utils.foreachValInObject = foreachValInObject;
    function setKeysAllNull(obj) {
        for (var k in obj) {
            if (obj.hasOwnProperty(k)) {
                obj[k] = null;
            }
        }
    }
    Utils.setKeysAllNull = setKeysAllNull;
    /* push a value onto an arr if valid */
    function pushIfValid(arr, pushableVals) {
        pushableVals.forEach(function (v) {
            if (v) {
                arr.push(v);
            }
        });
    }
    Utils.pushIfValid = pushIfValid;
    function forRadiusAroundStructure(baseRow, baseCol, dimSize, radius, gridSize, cb) {
        for (var d = 1; d <= radius; d++) {
            Utils.forBorder({
                row: baseRow - (dimSize - 1) - d,
                col: baseCol - (dimSize - 1) - d
            }, {
                row: baseRow + d,
                col: baseCol + d
            }, function (r, c) {
                if (Utils.isValidIndex(r, c, gridSize)) {
                    cb(r, c);
                }
            });
        }
    }
    Utils.forRadiusAroundStructure = forRadiusAroundStructure;
    function forBorderAroundDim(baseIndex, dimSize, withCorner, cb) {
        if (withCorner === void 0) {
            withCorner = false;
        }
        Utils.forBorder({
            row: baseIndex.row - dimSize,
            col: baseIndex.col - dimSize
        }, {
            row: baseIndex.row + 1,
            col: baseIndex.col + 1
        }, cb, withCorner);
    }
    Utils.forBorderAroundDim = forBorderAroundDim;
    function forBorder(startIndex, endIndex, fn, includeCorners) {
        if (includeCorners === void 0) {
            includeCorners = true;
        }
        var tlR = Math.min(startIndex.row, endIndex.row);
        var tlC = Math.min(startIndex.col, endIndex.col);
        var trC = Math.max(startIndex.col, endIndex.col);
        var blR = Math.max(startIndex.row, endIndex.row);
        var col, row;
        // left to right
        for (col = tlC; col <= trC; col++) {
            if (!includeCorners && (col === tlC || col === trC)) {
                continue;
            }
            fn(tlR, col);
            if (tlR !== blR) {
                fn(blR, col);
            }
        }
        // top to bottom
        if (tlR + 1 <= blR - 1) {
            for (row = tlR + 1; row <= blR - 1; row++) {
                fn(row, tlC);
                if (tlC !== trC) {
                    fn(row, trC);
                }
            }
        }
    }
    Utils.forBorder = forBorder;
    /**
     * Apply a function to all indexes for each index in a "layer" around a base tile, like onion peel
     * @param baseRow
     * @param baseCol
     * @param layer
     * @param fn
     */
    function foreachOnionLayer(baseRow, baseCol, layer, gridSize, fn) {
        var tlR = Math.max(baseRow - layer, 0);
        var tlC = Math.max(baseCol - layer, 0);
        var trC = Math.min(gridSize - 1, baseCol + layer);
        var blR = Math.min(gridSize - 1, baseRow + layer);
        var col, row;
        // left to right
        for (col = tlC; col <= trC; col++) {
            fn(tlR, col);
            if (tlR !== blR) {
                fn(blR, col);
            }
        }
        // top to bottom
        if (tlR + 1 <= blR - 1) {
            for (row = tlR + 1; row <= blR - 1; row++) {
                fn(row, tlC);
                if (tlC !== trC) {
                    fn(row, trC);
                }
            }
        }
    }
    Utils.foreachOnionLayer = foreachOnionLayer;
    // Self is regarded as a layer of 1 tile
    function forAllOnionLayers(city, baseRow, baseCol, distance, fn) {
        var _loop_1 = function _loop_1(i) {
            Utils.foreachOnionLayer(baseRow, baseCol, i, city.size, function (r, c) {
                if (Utils.isValidIndex(r, c, city.size)) fn(r, c, i);
            });
        };
        for (var i = 0; i < distance; i++) {
            _loop_1(i);
        }
    }
    Utils.forAllOnionLayers = forAllOnionLayers;
    function setAll2D(array, val) {
        var endRow = array.length;
        var endCol = array[0].length;
        for (var i = 0; i < endRow; i++) {
            for (var j = 0; j < endCol; j++) {
                array[i][j] = val;
            }
        }
        return array;
    }
    Utils.setAll2D = setAll2D;
    /** Returns new null-filled 2D array */
    function initialize2DArray(rows, columns, initialValue) {
        if (columns === void 0) {
            columns = rows;
        }
        if (initialValue === void 0) {
            initialValue = undefined;
        }
        var arr = [];
        var i;
        if (typeof initialValue === 'undefined') {
            for (i = 0; i < rows; i++) {
                arr[i] = [];
                // initialize final element to leave most empty
                arr[i][columns - 1] = null;
            }
        } else {
            for (i = 0; i < rows; i++) {
                arr[i] = [];
                for (var j = 0; j < columns; j++) {
                    arr[i][j] = initialValue;
                }
            }
        }
        return arr;
    }
    Utils.initialize2DArray = initialize2DArray;
    function copyArrVals(arr, targetArr) {
        for (var i = 0; i < arr.length; i++) {
            for (var j = 0; j < arr.length; j++) {
                targetArr[i][j] = arr[i][j];
            }
        }
    }
    Utils.copyArrVals = copyArrVals;
    function copyShallowList(arr) {
        return arr.map(function (a) {
            return a;
        });
    }
    Utils.copyShallowList = copyShallowList;
    function update2DArray(arr, row, col, value) {
        if (row < 0 || row > arr.length - 1 || col < 0 || col > arr.length - 1) {
            return;
        }
        arr[row][col] = value;
    }
    Utils.update2DArray = update2DArray;
    function addTo2DArrayIndex(arr, row, col, value) {
        if (row < 0 || row > arr.length - 1 || col < 0 || col > arr.length - 1) {
            return;
        }
        arr[row][col] = arr[row][col] + value;
    }
    Utils.addTo2DArrayIndex = addTo2DArrayIndex;
    /**
     * Create a boolean 2d grid of all tiles touching any truthy tiles the given tile grid
     */
    function getTouchingTiles(grid) {
        var size = grid.length;
        var touchingTiles = Grid.createEmptyTileSprites(size);
        apply2D(grid, function (tile, row, col) {
            if (tile) {
                var leftCol = Math.max(0, col - 1);
                var rightCol = Math.min(size - 1, col + 1);
                var upperRow = Math.max(0, row - 1);
                var lowerRow = Math.min(size - 1, row + 1);
                touchingTiles[row][col] = 1;
                touchingTiles[row][rightCol] = 1;
                touchingTiles[row][leftCol] = 1;
                touchingTiles[upperRow][col] = 1;
                touchingTiles[lowerRow][col] = 1;
            }
        });
        return touchingTiles;
    }
    Utils.getTouchingTiles = getTouchingTiles;
    function indicesToBoolMap(indices) {
        var output = {};
        indices.forEach(function (i) {
            output[i[0] + "_" + i[1]] = 1;
        });
        return output;
    }
    Utils.indicesToBoolMap = indicesToBoolMap;
    function boolMapToIndices(boolMap) {
        var output = [];
        var keys = Object.keys(boolMap);
        for (var i = 0; i < keys.length; i++) {
            var k = keys[i];
            var s = k.split("_");
            output.push([+s[0], +s[1]]);
        }
        return output;
    }
    Utils.boolMapToIndices = boolMapToIndices;
    /**
     * Actually a foreach - does not return new array
     * Calls fn(touchingRow, touchingCol) except on out of bounds indices
     * @param baseRow
     * @param baseCol
     * @param size - city size
     * @param fn
     * @param allowInvalidIndex
     */
    function mapTouchingTiles(baseRow, baseCol, size, fn, allowInvalidIndex) {
        if (allowInvalidIndex === void 0) {
            allowInvalidIndex = false;
        }
        for (var i = 0; i < Utils.touchOffsets.length; i++) {
            var d = Utils.touchOffsets[i];
            var newRow = baseRow + d[0];
            var newCol = baseCol + d[1];
            if (newRow >= 0 && newRow < size && newCol >= 0 && newCol < size || allowInvalidIndex) {
                fn(newRow, newCol);
            }
        }
    }
    Utils.mapTouchingTiles = mapTouchingTiles;
    function valuesAroundTile(grid, row, col) {
        var values = 0;
        for (var r = row - 1; r < row + 1; r++) {
            for (var c = col - 1; c < col + 1; c++) {
                if (r >= 0 && r < grid.length && c >= 0 && c < grid.length) {
                    if (grid[r][c]) {
                        values += grid[r][c];
                    }
                }
            }
        }
        return values;
    }
    Utils.valuesAroundTile = valuesAroundTile;
    function randomNeighbour(baseRow, baseCol, size) {
        var possibleOffsets = {
            0: [0, -1],
            1: [0, 1],
            2: [1, 0],
            3: [-1, 0]
        };
        if (baseRow === size - 1) {
            delete possibleOffsets[2];
        }
        if (baseCol === size - 1) {
            delete possibleOffsets[1];
        }
        if (baseRow === 0) {
            delete possibleOffsets[3];
        }
        if (baseCol === 0) {
            delete possibleOffsets[0];
        }
        var offset = possibleOffsets[Utils.randomChoice(Object.keys(possibleOffsets))];
        return {
            row: baseRow + offset[0],
            col: baseCol + offset[1]
        };
    }
    Utils.randomNeighbour = randomNeighbour;
    function checkNeighbours(row, col, grid) {
        var result = {
            hasLeft: false,
            hasRight: false,
            hasTop: false,
            hasBottom: false
        };
        Utils.mapTouchingTiles(row, col, grid.length, function (r, c) {
            if (grid[r][c]) {
                if (r === row + 1) {
                    result.hasBottom = true;
                }
                if (r === row - 1) {
                    result.hasTop = true;
                }
                if (c === col + 1) {
                    result.hasRight = true;
                }
                if (c === col - 1) {
                    result.hasLeft = true;
                }
            }
        });
        return result;
    }
    Utils.checkNeighbours = checkNeighbours;
    function mapTouchingIsAnyTrue(row, col, size, fn) {
        var isTrue = false;
        mapTouchingTiles(row, col, size, function (row, col) {
            if (fn(row, col)) {
                isTrue = true;
            }
        });
        return isTrue;
    }
    Utils.mapTouchingIsAnyTrue = mapTouchingIsAnyTrue;
    function isIndexTouchingStructure(row, col, city, sheet) {
        var zoneTiles = city.grids.zoneGrid.tiles;
        var isTouching = false;
        mapTouchingIsAnyTrue(row, col, city.size, function (r, c) {
            var t = zoneTiles[r][c];
            if (!t) return;
            if (t._master) {
                t = t._master;
            }
            if (t && t.building && t.building.sheet === sheet) {
                isTouching = true;
            }
        });
        return isTouching;
    }
    Utils.isIndexTouchingStructure = isIndexTouchingStructure;
    /**
     * Create a boolean 2d grid of tiles that are different between the two grids
     */
    function getGridDiff(grid1, grid2) {
        var gridDiff = Grid.createEmptyTileSprites(grid1.length);
        apply2D(grid1, function (tile, row, col) {
            var tile1 = Boolean(tile);
            var tile2 = Boolean(grid2[row][col]);
            if (tile1 && !tile2 || !tile1 && tile2) {
                gridDiff[row][col] = 1;
            }
        });
        return gridDiff;
    }
    Utils.getGridDiff = getGridDiff;
    /** doesn't have to be bool, can be numeric which takes first positive value */
    function flattenBooleanGrids(grid1, grid2, outputGrid) {
        var output = outputGrid || Grid.createEmptyTileSprites(grid1.length);
        apply2D(grid1, function (b, row, col) {
            output[row][col] = b || grid2[row][col];
        });
        return output;
    }
    Utils.flattenBooleanGrids = flattenBooleanGrids;
    function toBooleanGrid(tiles, existingGrid) {
        var booleanTiles = existingGrid || Grid.createEmptyTileSprites(tiles.length);
        apply2D(tiles, function (tile, row, col) {
            booleanTiles[row][col] = Boolean(tile);
        });
        return booleanTiles;
    }
    Utils.toBooleanGrid = toBooleanGrid;
    /**
     * Check if value falls within the bounds
     * @param bound1 {number}
     * @param bound2 {number}
     * @param value {number}
     * @param inclusive {boolean}
     * @returns {boolean}
     */
    function isBetween(bound1, bound2, value, inclusive) {
        if (inclusive === void 0) {
            inclusive = false;
        }
        var minVal = Math.min(bound1, bound2);
        var maxVal = Math.max(bound1, bound2);
        if (inclusive) {
            return minVal <= value && value <= maxVal;
        } else {
            return minVal < value && value < maxVal;
        }
    }
    Utils.isBetween = isBetween;
    function applyBetween(index1, index2, fn) {
        var startRow = Math.min(index1.row, index2.row);
        var startCol = Math.min(index1.col, index2.col);
        var endRow = Math.max(index1.row, index2.row);
        var endCol = Math.max(index1.col, index2.col);
        var r, c;
        for (r = startRow; r <= endRow; r++) {
            for (c = startCol; c <= endCol; c++) {
                fn(r, c);
            }
        }
    }
    Utils.applyBetween = applyBetween;
    function filterInPlace(a, condition) {
        var i = 0,
            j = 0;
        while (i < a.length) {
            var val = a[i];
            if (condition(val, i, a)) a[j++] = val;
            i++;
        }
        a.length = j;
        return a;
    }
    Utils.filterInPlace = filterInPlace;
    /**
     * Pathfinding
     */
    /***
     * Find AStar path from A to B
     *
     * does not include start index in result list
     * boolean grid, 1 is path, 0 is wall (you can use higher weights as well, e.g. 1 vs 30)
     * @param startIndex
     * @param endIndex
     * @param {number[][]} boolGrid
     * @returns {[number , number][]} - [row, col] tuple list
     */
    function findPath(startIndex, endIndex, boolGrid, includeStart) {
        if (includeStart === void 0) {
            includeStart = false;
        }
        if (!startIndex || !endIndex || !boolGrid) {
            return [];
        }
        var graph = new AstarGraph(flipRowCol2DGrid(boolGrid)); // lib reverses col and row
        var start = graph.grid[startIndex['col']][startIndex['row']]; // node
        var end = graph.grid[endIndex['col']][endIndex['row']]; // node
        var result = astar.search(graph, start, end);
        var tuples = result.map(function (gridNode) {
            return [gridNode.y, gridNode.x];
        }); // return reversed tuples of [row, col]
        if (includeStart) {
            tuples.unshift([startIndex.row, startIndex.col]);
        }
        return tuples;
    }
    Utils.findPath = findPath;
    function flipRowCol2DGrid(boolGrid) {
        if (boolGrid.length !== boolGrid[0].length) {
            throw new Error("needs to be a 2D array of equal col vs row count");
        }
        var reversedGrid = [];
        for (var i = 0; i < boolGrid.length; i++) {
            reversedGrid[i] = [];
        }
        boolGrid.forEach(function (rowArr, r) {
            rowArr.forEach(function (value, c) {
                reversedGrid[c][r] = value;
            });
        });
        return reversedGrid;
    }
    Utils.flipRowCol2DGrid = flipRowCol2DGrid;
    function DFSFind(row, col, booleanGridToFollow, resultConditionFn, trackSearched) {
        if (trackSearched === void 0) {
            trackSearched = [];
        }
        if (!Utils.isValidIndex(row, col, booleanGridToFollow.length)) {
            return null;
        }
        if (resultConditionFn(row, col)) {
            // success
            return { row: row, col: col };
        }
        if (!booleanGridToFollow[row][col]) {
            return null;
        }
        var flatIndex = row * booleanGridToFollow.length + col;
        if (trackSearched[flatIndex]) {
            return null;
        }
        trackSearched[flatIndex] = 1;
        var resultFound = null;
        [[0, 1], [0, -1], [1, 0], [-1, 0]].forEach(function (o) {
            if (resultFound) return;
            resultFound = DFSFind(row + o[0], col + o[1], booleanGridToFollow, resultConditionFn, trackSearched);
        });
        return resultFound;
    }
    Utils.DFSFind = DFSFind;
    /** DFS versin of floodfill */
    Utils.MAX_FLOODFILL = 3000; // to be determined
    var FLOOD_FILL_AJACENT = [[0, 1], [0, -1], [1, 0], [-1, 0]];
    var currentCallCount = 0;
    var deferredExec = [];
    var deferredResults = [];
    function floodFillResults(row, col, booleanGridToFollow, resultConditionFn, start) {
        if (start === void 0) {
            start = null;
        }
        currentCallCount = 0;
        deferredExec = [];
        deferredResults = [];
        var result = _floodFillResults(row, col, booleanGridToFollow, resultConditionFn, start);
        while (deferredExec.length) {
            deferredExec.pop()();
        }
        if (deferredResults.length) {
            result = result.concat(deferredResults.reduce(function (acc, result) {
                return acc.concat(result);
            }, []));
        }
        return result;
    }
    Utils.floodFillResults = floodFillResults;
    function _floodFillResults(row, col, booleanGridToFollow, resultConditionFn, start) {
        if (start === void 0) {
            start = null;
        }
        currentCallCount += 1;
        if (!Utils.isValidIndex(row, col, booleanGridToFollow.length)) {
            return [];
        }
        if (resultConditionFn(row, col) && (!start || row !== start[0] || col !== start[1])) {
            // success
            return [{ row: row, col: col }];
        }
        if (!booleanGridToFollow[row][col]) {
            return [];
        }
        booleanGridToFollow[row][col] = 0;
        var results = [];
        var _loop_2 = function _loop_2(i) {
            var o = FLOOD_FILL_AJACENT[i];
            var r1 = row + o[0];
            var c1 = col + o[1];
            if (currentCallCount < Utils.MAX_FLOODFILL) {
                // exec now as part of current call stack
                results.push(_floodFillResults(r1, c1, booleanGridToFollow, resultConditionFn));
            } else {
                // defer exec to finish off current call stack
                deferredExec.push(function () {
                    deferredResults.push(_floodFillResults(r1, c1, booleanGridToFollow, resultConditionFn));
                });
            }
        };
        for (var i = 0; i < FLOOD_FILL_AJACENT.length; i++) {
            _loop_2(i);
        }
        results = results.reduce(function (acc, result) {
            return acc.concat(result);
        }, []);
        return results;
    }
    Utils._floodFillResults = _floodFillResults;
    function floodFillAllIndices(row, col, booleanGridToFollow, forEachTraversed, traversed) {
        if (!Utils.isValidIndex(row, col, booleanGridToFollow.length) || !booleanGridToFollow[row][col]) {
            return [];
        }
        if (!traversed) {
            traversed = {};
        }
        var indexKey = Utils.toIndexKey(row, col, booleanGridToFollow.length);
        if (traversed[indexKey]) {
            return [];
        }
        if (forEachTraversed) {
            forEachTraversed(row, col);
        }
        traversed[indexKey] = 1;
        var o, res;
        var output = [[row, col]];
        for (var i = 0; i < FLOOD_FILL_AJACENT.length; i++) {
            o = FLOOD_FILL_AJACENT[i];
            res = floodFillAllIndices(row + o[0], col + o[1], booleanGridToFollow, forEachTraversed, traversed);
            for (var j = 0; j < res.length; j++) {
                output.push(res[j]);
            }
        }
        return output;
    }
    Utils.floodFillAllIndices = floodFillAllIndices;
    /** Floodfill to check if tiles exist in a grid */
    function floodFillBFS(row, col, distance, tiles, cb) {
        var queue = [];
        var filled = {};
        queue[queue.length] = { row: row, col: col, depth: 0 };
        var _loop_3 = function _loop_3() {
            var i = queue.pop();
            // call callback if tile exists
            if (!Utils.isValidIndex(i.row, i.col, tiles.length) || !tiles[i.row][i.col]) {
                return "continue";
            }
            if (tiles[i.row][i.col]) {
                if (filled[i.row + "_" + i.col]) {
                    return "continue";
                } else {
                    filled[i.row + "_" + i.col] = true;
                    cb(i.row, i.col);
                }
            }
            if (i.depth < distance) {
                [[0, 1], [0, -1], [1, 0], [-1, 0]].forEach(function (o) {
                    queue[queue.length] = {
                        row: i.row + o[0],
                        col: i.col + o[1],
                        depth: i.depth + 1
                    };
                });
            }
        };
        while (queue.length > 0) {
            _loop_3();
        }
    }
    Utils.floodFillBFS = floodFillBFS;
    /**
     * Return height of screen * percentage
     * @param amount
     */
    function screenHeight(amount) {
        return amount * Global.GAME_HEIGHT;
    }
    Utils.screenHeight = screenHeight;
    /**************
     * Sprite
     *************/
    function spriteLeftX(sprite, centered) {
        return centered ? sprite.x - sprite.width * 0.5 : sprite.x;
    }
    Utils.spriteLeftX = spriteLeftX;
    function spriteRightX(sprite, centered) {
        return centered ? sprite.x + sprite.width * 0.5 : sprite.x + sprite.width;
    }
    Utils.spriteRightX = spriteRightX;
    function spriteTopY(sprite, centered) {
        return centered ? sprite.y - sprite.height * 0.5 : sprite.y;
    }
    Utils.spriteTopY = spriteTopY;
    function spriteBottomY(sprite, centered) {
        return centered ? sprite.y + sprite.height * 0.5 : sprite.y + sprite.height;
    }
    Utils.spriteBottomY = spriteBottomY;
    function setAlpha(sprite, a) {
        if (!sprite.cacheAsBitmap) {
            sprite.alpha = a;
        } else {
            sprite.cacheAsBitmap = false;
            sprite.alpha = a;
            sprite.cacheAsBitmap = true;
        }
    }
    Utils.setAlpha = setAlpha;
    function toFixedWidth(sprite, width) {
        var ratio = sprite.height / sprite.width;
        sprite.width = width;
        sprite.height = width * ratio;
    }
    Utils.toFixedWidth = toFixedWidth;
    /** Set the width + height of a Phaser.TileSprite's texture */
    function setTileSpriteTextureSize(sprite, width, height) {
        if (sprite.tilingTexture) {
            sprite.tilingTexture.width = width;
            sprite.tilingTexture.height = height;
        }
    }
    Utils.setTileSpriteTextureSize = setTileSpriteTextureSize;
    /**
     * Scale a sprite to match a certain width
     * @param sprite {Sprite}
     * @param width {Number} - treated as percentage when < 1
     */
    function scaleToWidth(sprite, width) {
        sprite.scale.setTo(1);
        if (width < 1) {
            scaleToByPercentWidth(sprite, width);
        } else {
            sprite.height = width * (sprite.height / sprite.width);
            sprite.width = width;
        }
    }
    Utils.scaleToWidth = scaleToWidth;
    function scaleToTileWidth(sprite, percent) {
        var width = Tile.TILE_WIDTH * percent;
        sprite.height = width * (sprite.height / sprite.width);
        sprite.width = width;
    }
    Utils.scaleToTileWidth = scaleToTileWidth;
    function scaleToTileAndPosition(sprite, tileWidth, percentX, percentY) {
        Utils.scaleToTileWidth(sprite, tileWidth);
        sprite.x = percentX * Tile.TILE_WIDTH;
        sprite.y = percentY * Tile.TILE_WIDTH;
    }
    Utils.scaleToTileAndPosition = scaleToTileAndPosition;
    /**
     * Scale a sprite to match a certain height
     * @param sprite {Sprite}
     * @param height {Number} - treated as percentage when < 1
     */
    function scaleToHeight(sprite, height) {
        sprite.scale.setTo(1);
        if (height < 1) {
            scaleToByPercentHeight(sprite, height);
        } else {
            sprite.width = height * (sprite.width / sprite.height);
            sprite.height = height;
        }
    }
    Utils.scaleToHeight = scaleToHeight;
    function scaleIn(game, sprite, duration, cb) {
        var w = sprite.width;
        var h = sprite.height;
        sprite.width *= 0.1;
        sprite.height *= 0.1;
        var s = game.add.tween(sprite).to({ "width": w, "height": h }, duration, null, true);
        if (cb) {
            s.onComplete.add(cb);
        }
        return s;
    }
    Utils.scaleIn = scaleIn;
    function fadeIfFX(city, sprite, duration) {
        if (!city.pocketCity.enableSpecialFX) return;
        fadeIn(city.game, sprite, duration);
    }
    Utils.fadeIfFX = fadeIfFX;
    function fadeInDelay(game, sprite, duration, delay) {
        game.time.events.add(delay, function () {
            Utils.fadeIn(game, sprite, duration);
        });
    }
    Utils.fadeInDelay = fadeInDelay;
    function fadeIn(game, sprite, duration, fadeTo) {
        if (fadeTo === void 0) {
            fadeTo = 1;
        }
        duration = duration || 250;
        if (!game || !sprite) {
            throw new MissingArgsError();
        }
        sprite.alpha = 0;
        sprite.visible = true;
        return game.add.tween(sprite).to({ "alpha": fadeTo }, duration, null, true);
    }
    Utils.fadeIn = fadeIn;
    function fadeOut(game, sprite, duration, cb) {
        if (!game || !sprite || !duration) {
            throw new MissingArgsError();
        }
        var s = game.add.tween(sprite).to({ "alpha": 0 }, duration, null, true);
        if (cb) {
            s.onComplete.add(cb);
        }
        return s;
    }
    Utils.fadeOut = fadeOut;
    function shrinkOut(game, sprite, duration, cb) {
        if (!game || !sprite || !duration) {
            throw new MissingArgsError();
        }
        var s = game.add.tween(sprite).to({ "height": 0.2 * sprite.height, alpha: 0.2 }, duration, null, true);
        if (cb) {
            s.onComplete.add(cb);
        }
        return s;
    }
    Utils.shrinkOut = shrinkOut;
    function fadeOutDestroy(game, sprite, afterDestroyCb) {
        if (!sprite) return;
        game.add.tween(sprite).to({
            "alpha": 0
        }, 250, null, true).onComplete.add(function () {
            if (sprite && sprite.destroy) {
                Utils.destroyIfAlive(sprite);
            }
            if (afterDestroyCb) {
                afterDestroyCb();
            }
        });
    }
    Utils.fadeOutDestroy = fadeOutDestroy;
    // larger withinPercent is more lenient and more collide
    function collides(sprite1, sprite2, withinPercent) {
        if (withinPercent === void 0) {
            withinPercent = 1;
        }
        var sprite1Left = sprite1.x - sprite1.anchor.x * sprite1.width;
        var sprite1Right = sprite1Left + sprite1.width;
        var sprite1Top = sprite1.y - sprite1.anchor.y * sprite1.height;
        var sprite1Bottom = sprite1Top + sprite1.height;
        var sprite2Left = sprite2.x - sprite2.anchor.x * sprite2.width;
        var sprite2Right = sprite2Left + sprite2.width;
        var sprite2Top = sprite2.y - sprite2.anchor.y * sprite2.height;
        var sprite2Bottom = sprite2Top + sprite2.height;
        var centerXsprite1 = (sprite1Left + sprite1Right) * 0.5;
        var centerYsprite1 = (sprite1Top + sprite1Bottom) * 0.5;
        var centerXsprite2 = (sprite2Left + sprite2Right) * 0.5;
        var centerYsprite2 = (sprite2Top + sprite2Bottom) * 0.5;
        var maxDistX = (sprite1.width + sprite2.width) * 0.5 * withinPercent;
        var maxDistY = (sprite1.height + sprite2.height) * 0.5 * withinPercent;
        var distX = Math.abs(centerXsprite1 - centerXsprite2);
        var distY = Math.abs(centerYsprite1 - centerYsprite2);
        return distX < maxDistX && distY < maxDistY;
    }
    Utils.collides = collides;
    // Twirl tween and destroy
    function spinDestroy(city, sprite, maxAngle) {
        if (maxAngle === void 0) {
            maxAngle = 780;
        }
        sprite.anchor.setTo(0.5, 0.5);
        var time = randomInRange(Global.SPIN_DESTROY_TIME_MIN, Global.SPIN_DESTROY_TIME_MAX);
        var top = sprite.y - sprite.height * randomInRange(0.5, 0.8);
        var bottom = sprite.y + sprite.height * 0.8;
        var angle = randomInRange(160, maxAngle);
        var spinOpacityTween = city.game.add.tween(sprite).to({
            "angle": -angle
        }, time);
        var alphaTween = city.game.add.tween(sprite).to({
            "alpha": 0.2
        }, time * 0.5, null, false, time * 0.45);
        var tween1 = city.game.add.tween(sprite).to({
            "y": top
        }, time * 0.5 + 1, Phaser.Easing.Sinusoidal.Out);
        var tween2 = city.game.add.tween(sprite).to({
            "y": bottom
        }, time * 0.5, Phaser.Easing.Sinusoidal.In);
        sprite._destroyTweens = {
            tween1: tween1,
            tween2: tween2,
            spinOpacityTween: spinOpacityTween,
            alphaTween: alphaTween
        };
        tween1.chain(tween2);
        tween2.onComplete.add(function () {
            Utils.destroyIfAlive(sprite);
            if (sprite.destroying) {
                sprite.destroying = false;
            }
        });
        tween1.start();
        spinOpacityTween.start();
        alphaTween.start();
        return time;
    }
    Utils.spinDestroy = spinDestroy;
    /**
     * Scale a sprite by percentage according to game screen size
     * @param sprite
     * @param amount
     */
    function scaleToByPercentWidth(sprite, amount) {
        var width = Global.GAME_WIDTH * amount;
        sprite.height = width * (sprite.height / sprite.width);
        sprite.width = width;
    }
    Utils.scaleToByPercentWidth = scaleToByPercentWidth;
    /**
     * Scale a sprite by percentage according to game screen size
     * @param sprite
     * @param amount
     */
    function scaleToByPercentHeight(sprite, amount) {
        var height = Global.GAME_HEIGHT * amount;
        sprite.width = height * (sprite.width / sprite.height);
        sprite.height = height;
    }
    Utils.scaleToByPercentHeight = scaleToByPercentHeight;
    function diamondWidth(leftIndex, rightIndex, tileSize) {
        var left = indexToPosition(leftIndex.col, leftIndex.row, tileSize);
        var right = indexToPosition(rightIndex.col, rightIndex.row, tileSize);
        return right.x - left.x;
    }
    Utils.diamondWidth = diamondWidth;
    function diamondHeight(topIndex, bottomIndex, tileSize) {
        var top = indexToPosition(topIndex.col, topIndex.row, tileSize);
        var bottom = indexToPosition(bottomIndex.col, bottomIndex.row, tileSize);
        return bottom.y - top.y;
    }
    Utils.diamondHeight = diamondHeight;
    function createDiamondMask(city, numCols, numRows, tileSize, color, outlineColor, lineWidth) {
        if (color === void 0) {
            color = 0xffffff;
        }
        if (outlineColor === void 0) {
            outlineColor = null;
        }
        if (lineWidth === void 0) {
            lineWidth = 0;
        }
        var game = city.game;
        var topPos = indexToPosition(0, 0, tileSize);
        topPos.y -= tileSize * 0.5;
        var leftPos = indexToPosition(0, numRows, tileSize);
        leftPos.y -= tileSize * 0.5;
        var rightPos = indexToPosition(numCols, 0, tileSize);
        rightPos.y -= tileSize * 0.5;
        var bottomPos = indexToPosition(numCols, numRows, tileSize);
        bottomPos.y -= tileSize * 0.5;
        topPos = scaledPosition(city, topPos);
        leftPos = scaledPosition(city, leftPos);
        rightPos = scaledPosition(city, rightPos);
        bottomPos = scaledPosition(city, bottomPos);
        // Create new mask
        var mask = game.add.graphics(0, 0);
        if (color) {
            mask.beginFill(color);
        }
        if (outlineColor) {
            mask.lineStyle(lineWidth, outlineColor, 1);
            // TODO?: move into its own diamond shape class, can't do it this way because it affects entire dimensions
        }
        // Here we'll draw a diamond
        var poly = new Phaser.Polygon([new Phaser.Point(topPos.x, topPos.y), new Phaser.Point(rightPos.x, rightPos.y), new Phaser.Point(bottomPos.x, bottomPos.y), new Phaser.Point(leftPos.x, leftPos.y) // left
        ]);
        mask.drawPolygon(poly.points);
        mask.endFill();
        return mask;
    }
    Utils.createDiamondMask = createDiamondMask;
    function tweenTint(game, obj, startColor, endColor, time) {
        // create an object to tween with our step value at 0
        var colorBlend = { step: 0 }; // create the tween on this object and tween its step property to 100
        var colorTween = game.add.tween(colorBlend).to({ step: 100 }, time, Phaser.Easing.Linear.None, true, 0, 1, true);
        // run the interpolateColor function every time the tween updates, feeding it the
        // updated value of our tween each time, and set the result as our tint
        colorTween.onUpdateCallback(function () {
            obj.tint = Phaser.Color.interpolateColor(startColor, endColor, 100, colorBlend.step);
        });
        // set the object to the start color straight away
        obj.tint = startColor;
        // start the tween
        colorTween.start();
        return colorTween;
    }
    Utils.tweenTint = tweenTint;
    function createOverlayRectangle(game, color) {
        if (color === void 0) {
            color = 0x000000;
        }
        var graphicOverlay = game.add.graphics(0, 0);
        var opacity = CityUIGroup.DARK_CANVAS_ALPHA;
        graphicOverlay.beginFill(color, opacity);
        graphicOverlay.drawRect(0, 0, game.width * 1.1, game.height * 1.);
        graphicOverlay.endFill();
        graphicOverlay.fixedToCamera = true;
        graphicOverlay.cameraOffset = {
            x: 0,
            y: 0
        };
        return graphicOverlay;
    }
    Utils.createOverlayRectangle = createOverlayRectangle;
    // Returns a JSON that represends indexes for 4 corners of a grid section
    function toCornerIndexes(startIndex, size, inclusive) {
        inclusive = inclusive || false;
        var offset = inclusive ? 0 : -1;
        return {
            left: {
                "col": startIndex.col,
                "row": startIndex.row + size + offset
            },
            right: {
                "col": startIndex.col + size + offset,
                "row": startIndex.row
            },
            top: {
                "col": startIndex.col,
                "row": startIndex.row
            },
            bottom: {
                "col": startIndex.col + size + offset,
                "row": startIndex.row + size + offset
            }
        };
    }
    Utils.toCornerIndexes = toCornerIndexes;
    /**************
     * Grid-related
     *************/
    /**
     * Update an object's position due to resizing
     * @param positionObj - object with x and y
     * @param prevTileSize
     * @param newTileSize
     * @param [applyOffset]
     */
    function updateIsoPositionByZoom(positionObj, prevTileSize, newTileSize, applyOffset) {
        var zoomAmt = newTileSize / prevTileSize;
        var index = isoToIndex(positionObj.x, positionObj.y, prevTileSize);
        var prevCenterPos = indexToPosition(index.col, index.row, prevTileSize);
        // Calculate how much sprite is off form percent center of a tile
        var xOffsetCenter = positionObj.x - prevCenterPos.x;
        var yOffsetCenter = positionObj.y - prevCenterPos.y;
        // Calculate new offset from center by applying amount of zoom
        var newXOffsetCenter = zoomAmt * xOffsetCenter;
        var newYOffsetCenter = zoomAmt * yOffsetCenter;
        // New position from index and offsets
        Utils.setPositionToIndex(positionObj, index.row, index.col, newTileSize);
        if (applyOffset) {
            positionObj.x += newXOffsetCenter;
            positionObj.y += newYOffsetCenter;
        }
    }
    Utils.updateIsoPositionByZoom = updateIsoPositionByZoom;
    function setPositionToIndex(sprite, row, col, tileWidth) {
        if (tileWidth === void 0) {
            tileWidth = Tile.TILE_WIDTH;
        }
        var pos = indexToPositionReuse(col, row, tileWidth);
        sprite.x = pos.x;
        sprite.y = pos.y;
    }
    Utils.setPositionToIndex = setPositionToIndex;
    function setPositionToPercent(sprite, xPercent, yPercent) {
        sprite.x = xPercent * Tile.TILE_WIDTH;
        sprite.y = yPercent * Tile.TILE_WIDTH;
    }
    Utils.setPositionToPercent = setPositionToPercent;
    function randomPositionInsideTile(row, col, maxOffsetPercent, maxOffsetPercentY) {
        if (maxOffsetPercent === void 0) {
            maxOffsetPercent = 0.75;
        }
        if (maxOffsetPercentY === void 0) {
            maxOffsetPercentY = null;
        }
        if (maxOffsetPercentY === null) {
            maxOffsetPercentY = maxOffsetPercent;
        }
        var pos = indexToPosition(col, row, Tile.TILE_WIDTH);
        return {
            x: pos.x + maxOffsetPercent * (Tile.TILE_WIDTH * (Math.random() - 0.5)),
            y: pos.y + maxOffsetPercentY * 0.5 * (Tile.TILE_WIDTH * (Math.random() - 0.5))
        };
    }
    Utils.randomPositionInsideTile = randomPositionInsideTile;
    function randomPositionBetween(s1, s2, reuse, fullRange) {
        if (fullRange === void 0) {
            fullRange = false;
        }
        var percent = fullRange ? Utils.randomInRangeDecimal(0, 1) : Utils.randomInRangeDecimal(0.3, 0.7);
        return percentPositionBetween(s1, s2, percent, reuse);
    }
    Utils.randomPositionBetween = randomPositionBetween;
    function percentPositionBetween(s1, s2, percent, reuse) {
        var deltaX = s2.x - s1.x;
        var deltaY = s2.y - s1.y;
        if (reuse) {
            return Utils.toPositionReuse(s1.x + deltaX * percent, s1.y + deltaY * percent);
        }
        return {
            x: s1.x + deltaX * percent,
            y: s1.y + deltaY * percent
        };
    }
    Utils.percentPositionBetween = percentPositionBetween;
    /**
     * Translate a column and row into a screen position
     */
    function indexToPosition(col, row, tileWidth) {
        if (tileWidth === void 0) {
            tileWidth = Tile.TILE_WIDTH;
        }
        if (!tileWidth) {
            var e = new Error("tileSize not provided to indexToPosition");
            console.log(e.stack);
            throw e;
        }
        var x = col * tileWidth;
        var y = row * tileWidth;
        return __twoDToIso(x, y);
    }
    Utils.indexToPosition = indexToPosition;
    /** This is like indexToPosition, but with sane row, col arg order and default fixed tile size */
    function rowColToPos(row, col) {
        var x = col * Tile.TILE_WIDTH;
        var y = row * Tile.TILE_WIDTH;
        return __twoDToIso(x, y);
    }
    Utils.rowColToPos = rowColToPos;
    function indexToPositionReuse(col, row, tileWidth) {
        if (tileWidth === void 0) {
            tileWidth = Tile.TILE_WIDTH;
        }
        if (!tileWidth) {
            var e = new Error("tileSize not provided to indexToPosition");
            console.log(e.stack);
            throw e;
        }
        var x = col * tileWidth;
        var y = row * tileWidth;
        return __twoDToIsoReuse(x, y);
    }
    Utils.indexToPositionReuse = indexToPositionReuse;
    // row col ordering
    function indexToPositionReuseSane(row, col) {
        indexToPositionReuse(col, row);
    }
    Utils.indexToPositionReuseSane = indexToPositionReuseSane;
    /**
     * Groups X and Y into a JSON object
     * @param x
     * @param y
     */
    function toPosition(x, y) {
        return {
            "x": x,
            "y": y
        };
    }
    Utils.toPosition = toPosition;
    /**
     * Cacher version
     */
    function toPositionReuse(x, y) {
        REUSE_CACHE_POSITION.x = x;
        REUSE_CACHE_POSITION.y = y;
        return REUSE_CACHE_POSITION;
    }
    Utils.toPositionReuse = toPositionReuse;
    /**
     * Groups col and row into a JSON object
     * @param col
     * @param row
     */
    function toIndex2D(col, row) {
        return {
            "col": col,
            "row": row
        };
    }
    Utils.toIndex2D = toIndex2D;
    function toIndex2DReuse(col, row) {
        REUSE_CACHE_INDEX.col = col;
        REUSE_CACHE_INDEX.row = row;
        return REUSE_CACHE_INDEX;
    }
    Utils.toIndex2DReuse = toIndex2DReuse;
    function setChildToWorldPos(sprite, x, y) {
        var worldX = sprite.parent.x;
        var worldY = sprite.parent.y;
        worldX -= sprite.parent.anchor.x * sprite.parent.width;
        worldY -= sprite.parent.anchor.y * sprite.parent.height;
        sprite.x = x - worldX;
        sprite.y = y - worldY;
    }
    Utils.setChildToWorldPos = setChildToWorldPos;
    function rangeArr(num) {
        var rangeArr = [];
        for (var i = 0; i < num; i++) {
            rangeArr.push(i);
        }
        return rangeArr;
    }
    Utils.rangeArr = rangeArr;
    function randomIndex(gridSize, rng) {
        if (rng) {
            return {
                col: rng.nextRange(0, gridSize - 1),
                row: rng.nextRange(0, gridSize - 1)
            };
        }
        return {
            col: randomInRange(0, gridSize - 1),
            row: randomInRange(0, gridSize - 1)
        };
    }
    Utils.randomIndex = randomIndex;
    /**
     * Isometric position to 2D index
     */
    var tileSizeDivMult = 1 / 60; // hard coded to Tile.TILE_WIDTH
    function isoToIndex(x, y, tileSize) {
        var position2D = __isoTo2D(x, y);
        return toIndex2D(Math.round(position2D.x * tileSizeDivMult), Math.round(position2D.y * tileSizeDivMult));
    }
    Utils.isoToIndex = isoToIndex;
    function isoToIndexReuse(x, y, tileSize) {
        var position2D = __isoTo2DReuse(x, y);
        return toIndex2DReuse(Math.round(position2D.x * tileSizeDivMult), Math.round(position2D.y * tileSizeDivMult));
    }
    Utils.isoToIndexReuse = isoToIndexReuse;
    // Determine sprite index based on x y
    function spriteIndex(sprite) {
        return isoToIndex(sprite.x, sprite.y, Tile.TILE_WIDTH);
    }
    Utils.spriteIndex = spriteIndex;
    function spriteIndexReuse(sprite) {
        return isoToIndexReuse(sprite.x, sprite.y, Tile.TILE_WIDTH);
    }
    Utils.spriteIndexReuse = spriteIndexReuse;
    function isEdge(city, row, col) {
        return row <= 0 || col <= 0 || row >= city.size - 1 || col >= city.size - 1;
    }
    Utils.isEdge = isEdge;
    function isoToIndexPrecise(x, y, tileSize) {
        if (!tileSize) {
            var e = new Error("tileSize not provided to isoToIndex");
            console.log(e.stack);
            throw e;
        }
        var position2D = __isoTo2D(x, y);
        return toIndex2D(position2D.x / tileSize, position2D.y / tileSize);
    }
    Utils.isoToIndexPrecise = isoToIndexPrecise;
    function copyIndex(i) {
        if (!i) {
            return i;
        }
        return {
            "col": i.col,
            "row": i.row
        };
    }
    Utils.copyIndex = copyIndex;
    function copyJSON(jsonObj) {
        return JSON.parse(JSON.stringify(jsonObj));
    }
    Utils.copyJSON = copyJSON;
    /**
     * Translate cartesian position to Isometric position
     */
    function __twoDToIso(x, y) {
        return toPosition(x - y, (x + y) * 0.5);
    }
    Utils.__twoDToIso = __twoDToIso;
    function __twoDToIsoReuse(x, y) {
        return toPositionReuse(x - y, (x + y) * 0.5);
    }
    Utils.__twoDToIsoReuse = __twoDToIsoReuse;
    /**
     * Translate isometric position to 2D position
     */
    function __isoTo2D(x, y) {
        return toPosition((2 * y + x) * 0.5, (2 * y - x) * 0.5);
    }
    Utils.__isoTo2D = __isoTo2D;
    function __isoTo2DReuse(x, y) {
        return toPositionReuse((2 * y + x) * 0.5, (2 * y - x) * 0.5);
    }
    Utils.__isoTo2DReuse = __isoTo2DReuse;
    // generic time to move camera between two points
    function getMoveTime(pos1, pos2) {
        var TIME_PER_TILE = Global.CAMERA_MOVE_TIME_PER_TILE;
        var dist = Math.abs(pos1.x - pos2.x) + Math.abs(pos1.y - pos2.y);
        return dist / Tile.TILE_WIDTH * TIME_PER_TILE;
    }
    Utils.getMoveTime = getMoveTime;
    // generic time to scale camera
    function getScaleTime(scale1, scale2) {
        var TIME_PER_SCALE_TICK = Global.CAMERA_TIME_PER_SCALE_TICK;
        return Math.abs(scale1 - scale2) / 0.1 * TIME_PER_SCALE_TICK;
    }
    Utils.getScaleTime = getScaleTime;
    /**
     * Get the current center tile for a game camera
     */
    function cameraCenterIndexPrecise(city) {
        var nonScaledPos = toPosition(city.game.camera.x + city.game.width * 0.5, city.game.camera.y + city.game.height * Global.CAMERA_CENTRE_TILE_Y_OFFSET);
        var scaledPos = scaledPositionInverse(city, nonScaledPos);
        return isoToIndexPrecise(scaledPos.x, scaledPos.y, city.getTileSize());
    }
    Utils.cameraCenterIndexPrecise = cameraCenterIndexPrecise;
    function getCameraCentrePos(city, reUse) {
        if (reUse === void 0) {
            reUse = false;
        }
        var iScale = city.cityScaler._inverseScale;
        var x = city.game.camera.x * iScale;
        var y = city.game.camera.y * iScale;
        if (reUse) {
            return toPositionReuse(x + city.game.width * 0.5 * iScale, y + city.game.height * 0.5 * iScale);
        }
        return toPosition(x + city.game.width * 0.5 * iScale, y + city.game.height * 0.5 * iScale);
    }
    Utils.getCameraCentrePos = getCameraCentrePos;
    function getScaledCameraPosition(city) {
        return {
            x: city.game.camera.x * city.cityScaler._inverseScale,
            y: city.game.camera.y * city.cityScaler._inverseScale
        };
    }
    Utils.getScaledCameraPosition = getScaledCameraPosition;
    function getScaledCameraHeight(city) {
        return {
            width: city.game.camera.width * city.cityScaler._inverseScale,
            height: city.game.camera.height * city.cityScaler._inverseScale
        };
    }
    Utils.getScaledCameraHeight = getScaledCameraHeight;
    var _reuseCameraBox = {
        xLeft: 0,
        xRight: 0,
        yTop: 0,
        yBottom: 0
    };
    function cameraBox(city, reuse) {
        var size = getScaledCameraHeight(city);
        var cameraX = city.game.camera.x * city.cityScaler._inverseScale;
        var cameraY = city.game.camera.y * city.cityScaler._inverseScale;
        if (reuse) {
            _reuseCameraBox.xLeft = cameraX;
            _reuseCameraBox.xRight = cameraX + size.width;
            _reuseCameraBox.yTop = cameraY;
            _reuseCameraBox.yBottom = cameraY + size.height;
            return _reuseCameraBox;
        } else {
            return {
                xLeft: cameraX,
                xRight: cameraX + size.width,
                yTop: cameraY,
                yBottom: cameraY + size.height
            };
        }
    }
    Utils.cameraBox = cameraBox;
    function scaledPosition(city, spriteWithXY) {
        return {
            x: spriteWithXY.x * city.scale.x,
            y: spriteWithXY.y * city.scale.y
        };
    }
    Utils.scaledPosition = scaledPosition;
    function scaledPositionInverse(city, spriteWithXY) {
        return {
            x: spriteWithXY.x * city.cityScaler._inverseScale,
            y: spriteWithXY.y * city.cityScaler._inverseScale
        };
    }
    Utils.scaledPositionInverse = scaledPositionInverse;
    function getYFromBottom(sprite, percentBottom) {
        return sprite.y + sprite.height * (1 - sprite.anchor.y) - sprite.height * percentBottom;
    }
    Utils.getYFromBottom = getYFromBottom;
    //
    // tile sizing for user interaction related
    //
    function zoomRequiredToShowNumTiles(numTiles, pocketCity) {
        return window.innerWidth / (numTiles * Tile.TILE_WIDTH) * pocketCity.canvasResizer.dimensionRatio;
    }
    Utils.zoomRequiredToShowNumTiles = zoomRequiredToShowNumTiles;
    function loopRectangle(startIndex, endIndex, gridSize, fn) {
        var skipValidation = gridSize === -1;
        var minIndex = {
            row: Math.min(startIndex.row, endIndex.row),
            col: Math.min(startIndex.col, endIndex.col)
        };
        var maxIndex = {
            row: Math.max(startIndex.row, endIndex.row),
            col: Math.max(startIndex.col, endIndex.col)
        };
        for (var r = minIndex.row; r <= maxIndex.row; r++) {
            for (var c = minIndex.col; c <= maxIndex.col; c++) {
                if (this.isValidIndex(r, c, gridSize) || skipValidation) {
                    fn(r, c);
                }
            }
        }
    }
    Utils.loopRectangle = loopRectangle;
    function isOnScreen(city, sprite, buffer, partialVisible) {
        if (buffer === void 0) {
            buffer = 0;
        }
        if (partialVisible === void 0) {
            partialVisible = false;
        }
        var cameraBox = Utils.cameraBox(city, 1);
        // compensate for anchor
        var minY, maxY, minX, maxX;
        if (sprite.anchor) {
            minY = sprite.y - sprite.height * sprite.anchor.y;
            maxY = sprite.y + sprite.height * (1 - sprite.anchor.y);
            minX = sprite.x - sprite.width * sprite.anchor.x;
            maxX = sprite.x + sprite.width * (1 - sprite.anchor.x);
        } else {
            minY = sprite.y;
            maxY = sprite.y + sprite.height;
            minX = sprite.x;
            maxX = sprite.x + sprite.width;
        }
        if (partialVisible) {
            var checkPoints = [[minX, minY], [minX, maxY], [maxX, minY], [maxX, maxY]];
            for (var i = 0; i < checkPoints.length; i++) {
                if (isOnScreenPosition(city, checkPoints[i][0], checkPoints[i][1], 0, 0, 0, cameraBox)) {
                    return true;
                }
            }
            return false;
        } else {
            return cameraBox.xLeft - buffer < minX && cameraBox.yTop - buffer < minY && maxX < cameraBox.xRight + buffer && maxY < cameraBox.yBottom + buffer;
        }
    }
    Utils.isOnScreen = isOnScreen;
    function isOnScreenPosition(city, x, y, width, height, buffer, existingCameraBox) {
        if (width === void 0) {
            width = 0;
        }
        if (height === void 0) {
            height = 0;
        }
        if (buffer === void 0) {
            buffer = 0;
        }
        var cameraBox = existingCameraBox || Utils.cameraBox(city, 1);
        return cameraBox.xLeft - buffer < x && cameraBox.yTop - buffer < y && x + width < cameraBox.xRight + buffer && y + height < cameraBox.yBottom + buffer;
    }
    Utils.isOnScreenPosition = isOnScreenPosition;
    // larger middlePercentNotAllow - include less results
    function isOnScreenPositionExceptMiddle(city, x, y, buffer, middlePercentNotAllow) {
        if (buffer === void 0) {
            buffer = 0;
        }
        if (middlePercentNotAllow === void 0) {
            middlePercentNotAllow = 0.3;
        }
        var cameraBox = Utils.cameraBox(city, 1);
        var isInOuterBox = cameraBox.xLeft - buffer < x && cameraBox.yTop - buffer < y && x < cameraBox.xRight + buffer && y < cameraBox.yBottom + buffer;
        if (!isInOuterBox) {
            return false;
        }
        var mult = 0.5 * (1 - middlePercentNotAllow);
        var xBuff = (cameraBox.xRight - cameraBox.xLeft) * mult;
        var yBuff = (cameraBox.yTop - cameraBox.yBottom) * mult;
        var isInInnerBox = cameraBox.xLeft + xBuff < x && cameraBox.yTop + yBuff < y && x < cameraBox.xRight - xBuff && y < cameraBox.yBottom - yBuff;
        return !isInInnerBox;
    }
    Utils.isOnScreenPositionExceptMiddle = isOnScreenPositionExceptMiddle;
    function isOnScreenWithinPercent(city, x, y, mustBeWithinPercent) {
        if (mustBeWithinPercent === void 0) {
            mustBeWithinPercent = 1;
        }
        var cameraBox = Utils.cameraBox(city, 1);
        var windowWidth = cameraBox.xRight - cameraBox.xLeft;
        var windowHeight = cameraBox.yBottom - cameraBox.yTop;
        var clipped = 1 - mustBeWithinPercent;
        var clipBufferX = windowWidth * clipped * 0.5;
        var clipBufferY = windowHeight * clipped * 0.5;
        return cameraBox.xLeft + clipBufferX < x && cameraBox.yTop + clipBufferY < y && x < cameraBox.xRight - clipBufferX && y < cameraBox.yBottom - clipBufferY;
    }
    Utils.isOnScreenWithinPercent = isOnScreenWithinPercent;
    function isAnyOnScreen(city, spriteArr, allowPartial, mustBeVisible) {
        if (allowPartial === void 0) {
            allowPartial = false;
        }
        if (mustBeVisible === void 0) {
            mustBeVisible = false;
        }
        var sprite;
        for (var i = 0, max = spriteArr.length; i < max; i++) {
            sprite = spriteArr[i];
            if ((!mustBeVisible || sprite.visible) && isOnScreen(city, sprite, 0, allowPartial)) {
                return true;
            }
        }
        return false;
    }
    Utils.isAnyOnScreen = isAnyOnScreen;
    function isEqualIndexes(i1, i2) {
        if (!i1 && !i2) return true;
        if (!i1 || !i2) return false;
        return i1.col == i2.col && i1.row == i2.row;
    }
    Utils.isEqualIndexes = isEqualIndexes;
    function isSpriteAtIndex(sprite, index) {
        return Utils.isEqualIndexes(index, Utils.isoToIndexReuse(sprite.x, sprite.y));
    }
    Utils.isSpriteAtIndex = isSpriteAtIndex;
    function isPositionInSprite(pos, sprite, buffer) {
        if (buffer === void 0) {
            buffer = 0;
        }
        var minX = sprite.x - sprite.width * sprite.anchor.x;
        var maxX = sprite.x + sprite.width * (1 - sprite.anchor.x);
        var minY = sprite.y - sprite.width * sprite.anchor.y;
        var maxY = sprite.y + sprite.width * (1 - sprite.anchor.y);
        return pos.x >= minX - buffer && pos.x <= maxX + buffer && pos.y >= minY - buffer && pos.y <= maxY + buffer;
    }
    Utils.isPositionInSprite = isPositionInSprite;
    function isGroupInSprite(pos, group, buffer) {
        if (buffer === void 0) {
            buffer = 0;
        }
        var sprite = group.children[0];
        var minX = group.x + sprite.x - sprite.width * sprite.anchor.x;
        var maxX = group.x + sprite.x + sprite.width * (1 - sprite.anchor.x);
        var minY = group.y + sprite.y - sprite.width * sprite.anchor.y;
        var maxY = group.y + sprite.y + sprite.width * (1 - sprite.anchor.y);
        return pos.x >= minX - buffer && pos.x <= maxX + buffer && pos.y >= minY - buffer && pos.y <= maxY + buffer;
    }
    Utils.isGroupInSprite = isGroupInSprite;
    function matchPositionAndWidth(sprite, original) {
        Utils.scaleToWidth(sprite, original.width);
        sprite.x = original.x;
        sprite.y = original.y;
        sprite.anchor.setTo(original.anchor.x, original.anchor.y);
    }
    Utils.matchPositionAndWidth = matchPositionAndWidth;
    /**
     * Returns whether user is currently touching the target index. on far zoom out, compensates and adds forgiving error radius
     */
    function isTouchingCloseToIndexOnZoomout(city, targetIndex, exact) {
        if (!targetIndex || !city.game.input.activePointer) {
            return false;
        }
        if (!exact && Global.TILE_WIDTH * city.scale.x < Global.MIN_TOUCH_DRAG_TILE_PX_HELP) {
            // just check that it's within the distance delta
            var targetPos = Utils.indexToPosition(targetIndex.col, targetIndex.row, Global.TILE_WIDTH);
            // get actually touched world position
            var touchedPos = Utils.toPosition(city.game.input.activePointer.worldX * city.cityScaler._inverseScale, city.game.input.activePointer.worldY * city.cityScaler._inverseScale);
            var maxDelta = Global.DRAG_TILE_HELPER_MAX_DELTA;
            var deltaX = Math.abs(touchedPos.x - targetPos.x) * city.scale.x;
            var deltaY = Math.abs(touchedPos.y - targetPos.y) * city.scale.y;
            return deltaX < maxDelta && deltaY < maxDelta;
        } else {
            // must touch exactly
            var tileSize = Global.TILE_WIDTH;
            var pointer = Utils.toPosition(city.game.input.activePointer.worldX * city.cityScaler._inverseScale, city.game.input.activePointer.worldY * city.cityScaler._inverseScale);
            return Utils.isEqualIndexes(Utils.isoToIndex(pointer.x, pointer.y, tileSize), targetIndex);
        }
    }
    Utils.isTouchingCloseToIndexOnZoomout = isTouchingCloseToIndexOnZoomout;
    function indexMaxDiff(i1, i2) {
        return Math.max(Math.abs(i1.col - i2.col), Math.abs(i1.row - i2.row));
    }
    Utils.indexMaxDiff = indexMaxDiff;
    function posDistTotal(i1, i2) {
        return Math.abs(i1.x - i2.x) + Math.abs(i1.y - i2.y);
    }
    Utils.posDistTotal = posDistTotal;
    function indexDistTotal(i1, i2) {
        return Math.abs(i1.col - i2.col) + Math.abs(i1.row - i2.row);
    }
    Utils.indexDistTotal = indexDistTotal;
    function sortGroupY(group, onlyVisible) {
        if (onlyVisible && !group.visible) return;
        group.sort('y', Phaser.Group.SORT_ASCENDING);
    }
    Utils.sortGroupY = sortGroupY;
    function sortGroupYWithAnchor(group, onlyVisible) {
        if (onlyVisible && !group.visible) return;
        group.customSort(_sortGroupYWithAnchorCustomSort, group);
    }
    Utils.sortGroupYWithAnchor = sortGroupYWithAnchor;
    function _sortGroupYWithAnchorCustomSort(child1, child2) {
        var child1Bottom = child1.y + (1 - child1.anchor.y) * child1.height;
        var child2Bottom = child2.y + (1 - child2.anchor.y) * child2.height;
        if (child1Bottom < child2Bottom) {
            return -1;
        } else if (child1Bottom > child2Bottom) {
            return 1;
        } else {
            return 0;
        }
    }
    // This one incorrectly converts the value to a date, but i'm just going to leave it this way
    function sortOnKey(arr, k) {
        arr.sort(function (a, b) {
            var keyA = new Date(a[k]);
            var keyB = new Date(b[k]);
            if (keyA < keyB) return -1;
            if (keyA > keyB) return 1;
            return 0;
        });
        return arr;
    }
    Utils.sortOnKey = sortOnKey;
    function sortOnTupleIndex(arr, i) {
        arr.sort(function (a, b) {
            var keyA = a[i];
            var keyB = b[i];
            if (keyA < keyB) return -1;
            if (keyA > keyB) return 1;
            return 0;
        });
        return arr;
    }
    Utils.sortOnTupleIndex = sortOnTupleIndex;
    // addtogroup with depth
    function addChildIntoCorrectDepth(group, elem) {
        // with anchor support and bottomY() suport
        var newIndex = Utils.findBestInsertion(group.children, elem, WithGroupDepthSortMixin._sortGroupDepthCustomSort);
        group.addChildAt(elem, newIndex);
        group.dirtyZ = true;
    }
    Utils.addChildIntoCorrectDepth = addChildIntoCorrectDepth;
    function addUpperStructureMaskCorrectDepth(upperStructureMask, elem) {
        var newIndex = Utils.findBestUpperMaskInsertion(upperStructureMask, elem);
        upperStructureMask.addChildAt(elem, newIndex);
        upperStructureMask.dirtyZ = true;
    }
    Utils.addUpperStructureMaskCorrectDepth = addUpperStructureMaskCorrectDepth;
    // Simplist, fastest version, pure y comparison
    function addChildIntoCorrectDepthSimple(group, elem) {
        // with anchor support and bottomY() suport
        var newIndex = Utils.findBestSimpleSortInsertion(group, elem);
        group.addChildAt(elem, newIndex);
        group.dirtyZ = true;
    }
    Utils.addChildIntoCorrectDepthSimple = addChildIntoCorrectDepthSimple;
    // Insert by texture name sort
    function addChildIntoTextureSort(group, elem) {
        // with anchor support and bottomY() suport
        var newIndex = Utils.findBestTextureSortInsertion(group, elem);
        group.addChildAt(elem, newIndex);
        group.dirtyZ = true;
    }
    Utils.addChildIntoTextureSort = addChildIntoTextureSort;
    // addtogroup with depth and anchor
    function addChildIntoCorrectDepthWithAnchor(group, elem) {
        var newIndex = Utils.findBestInsertion(group.children, elem, _sortGroupYWithAnchorCustomSort);
        group.addChildAt(elem, newIndex);
        group.dirtyZ = true;
    }
    Utils.addChildIntoCorrectDepthWithAnchor = addChildIntoCorrectDepthWithAnchor;
    function findBestInsertion(ar, el, compare_fn) {
        var m = 0;
        var n = ar.length - 1;
        var isNLast = false;
        while (m <= n) {
            var k = n + m >> 1; // divide by 2
            var cmp = compare_fn(el, ar[k]);
            if (cmp > 0) {
                m = k + 1;
                isNLast = false;
            } else if (cmp < 0) {
                n = k - 1;
                isNLast = true;
            } else {
                return k;
            }
        }
        if (isNLast) {
            return Math.max(0, n);
        } else {
            return Math.max(0, m);
        }
    }
    Utils.findBestInsertion = findBestInsertion;
    function findBestSimpleSortInsertion(group, elem) {
        return findBestInsertion(group.children, elem, WithGroupDepthSortMixin._simpleYDepthSort);
    }
    Utils.findBestSimpleSortInsertion = findBestSimpleSortInsertion;
    function findBestTextureSortInsertion(group, elem) {
        return findBestInsertion(group.children, elem, WithGroupDepthSortMixin._sortGroupTextureCustomSort);
    }
    Utils.findBestTextureSortInsertion = findBestTextureSortInsertion;
    var NUM_CHECK_STRUCT_ADJECENT = 44;
    function findBestUpperMaskInsertion(upperStructureLayer, maskElem) {
        var children = upperStructureLayer.children;
        return findBestInsertion(children, maskElem, WithGroupDepthSortMixin._sortGroupDepthCustomSort);
    }
    Utils.findBestUpperMaskInsertion = findBestUpperMaskInsertion;
    function tweenMove(city, sprite, to, duration, destroyAfter, cb) {
        if (destroyAfter === void 0) {
            destroyAfter = false;
        }
        if (cb === void 0) {
            cb = null;
        }
        var t = city.game.add.tween(sprite).to(to, duration, Phaser.Easing.Quadratic.Out, true);
        if (destroyAfter) {
            t.onComplete.add(function () {
                sprite.destroy();
            });
        }
        if (cb) {
            t.onComplete.add(cb);
        }
        return t;
    }
    Utils.tweenMove = tweenMove;
    function tweenMoveNoEase(city, sprite, to, duration, cb) {
        if (cb === void 0) {
            cb = null;
        }
        var t = city.game.add.tween(sprite).to(to, duration, Phaser.Easing.Linear.None, true);
        if (cb) {
            t.onComplete.add(cb);
        }
        return t;
    }
    Utils.tweenMoveNoEase = tweenMoveNoEase;
    function tweenPressed(game, sprite, yOffset) {
        bounceTween(game, sprite, 0.9, 1000, yOffset);
        return sprite._bounceTween;
    }
    Utils.tweenPressed = tweenPressed;
    function bounceTween(game, sprite, amt, duration, offsetY, autoStart) {
        if (amt === void 0) {
            amt = 0.5;
        }
        if (duration === void 0) {
            duration = 400;
        }
        if (autoStart === void 0) {
            autoStart = true;
        }
        if (!offsetY && offsetY !== 0) {
            offsetY = null;
        }
        if (sprite._bounceTween) {
            sprite._bounceTween.stop(true, true);
        }
        var baseHeight = sprite.height;
        var baseWidth = sprite.width;
        var baseY = sprite.y;
        var baseX = sprite.x;
        sprite.y += sprite.height * (offsetY !== null ? offsetY : 1 - amt);
        sprite.height *= amt;
        sprite._bounceTween = game.add.tween(sprite).to({
            height: baseHeight,
            width: baseWidth,
            y: baseY,
            x: baseX
        }, duration, null, autoStart);
        return sprite._bounceTween;
    }
    Utils.bounceTween = bounceTween;
    function tweenSqeezeDown(game, sprite, amt, duration, yShift) {
        if (amt === void 0) {
            amt = 0.75;
        }
        if (duration === void 0) {
            duration = 1000;
        }
        if (sprite._bounceTween) {
            sprite._bounceTween.stop(true, true);
        }
        var newHeight = sprite.height * amt;
        var newY = sprite.y + (yShift ? yShift : sprite.height * (1 - amt));
        sprite._bounceTween = game.add.tween(sprite).to({
            height: newHeight,
            y: newY
        }, duration, null, true);
        return sprite._bounceTween;
    }
    Utils.tweenSqeezeDown = tweenSqeezeDown;
    function tweenBreathLoop(game, sprite, autoStart) {
        if (autoStart === void 0) {
            autoStart = true;
        }
        game.add.tween(sprite).to({ height: sprite.height * 0.95 }, 1000, Phaser.Easing.Sinusoidal.InOut, autoStart, 0, Infinity, true);
    }
    Utils.tweenBreathLoop = tweenBreathLoop;
    function bounceTweenElastic(game, sprite, amt, duration, offsetY, withPopSound) {
        if (amt === void 0) {
            amt = 0.5;
        }
        if (duration === void 0) {
            duration = 400;
        }
        if (offsetY === void 0) {
            offsetY = 0;
        }
        if (withPopSound === void 0) {
            withPopSound = false;
        }
        var baseHeight = sprite.height;
        sprite.height *= 1.3;
        sprite.visible = true;
        var tween = bounceTween(game, sprite, amt, duration, offsetY, false);
        var tween2 = game.add.tween(sprite).to({
            height: baseHeight
        }, 100);
        tween.chain(tween2);
        tween.start();
        if (withPopSound) {
            AudioPC.playUIPop();
        }
        return tween2;
    }
    Utils.bounceTweenElastic = bounceTweenElastic;
    function bounceInSpritesWithDelay(game, sprites, delayStagger, withInitialDelay, onComplete) {
        var _this = this;
        if (delayStagger === void 0) {
            delayStagger = 200;
        }
        if (withInitialDelay === void 0) {
            withInitialDelay = true;
        }
        sprites.forEach(function (s, i) {
            return s.visible = false;
        });
        staggerEvents(game, sprites, delayStagger, withInitialDelay, function (s, i) {
            s.visible = true;
            var tween = _this.bounceTweenElastic(game, s, 0.3, 300, 0);
            if (i === sprites.length - 1) {
                tween.onComplete.add(function () {
                    return onComplete();
                });
            }
        });
    }
    Utils.bounceInSpritesWithDelay = bounceInSpritesWithDelay;
    function bouncingTweenLoop(game, sprite, duration) {
        if (duration === void 0) {
            duration = 225;
        }
        var tween = game.add.tween(sprite).to({
            height: sprite.height * 1.07
        }, duration, null, true, 0, -1, true);
        tween.loop(true);
        return tween;
    }
    Utils.bouncingTweenLoop = bouncingTweenLoop;
    function staggerEvents(game, items, delayStagger, withInitialDelay, actionFn) {
        if (delayStagger === void 0) {
            delayStagger = 200;
        }
        if (withInitialDelay === void 0) {
            withInitialDelay = true;
        }
        items.forEach(function (s, i) {
            game.time.events.add((i + (withInitialDelay ? 1 : 0)) * delayStagger, function () {
                actionFn(s, i);
            });
        });
    }
    Utils.staggerEvents = staggerEvents;
    /**************
     * Math
     *************/
    /**
     * Bound an integer between bounds
     * @param amt
     * @param min
     * @param max
     */
    function bound(amt, min, max) {
        if (min > max) {
            throw new Error("Min is greater than max!");
        }
        if (amt > max) {
            amt = max;
        }
        if (amt < min) {
            amt = min;
        }
        return amt;
    }
    Utils.bound = bound;
    /**
     * Game related
     */
    function getElapsedTime(game) {
        return game.time.elapsedMS;
    }
    Utils.getElapsedTime = getElapsedTime;
    function toReadableTime(millis) {
        var SECOND = 1000;
        var MINUTE = 60 * SECOND;
        var HOUR = 60 * MINUTE;
        if (millis > HOUR) {
            return (millis / HOUR).toFixed(1) + " 시";
        }
        if (millis > MINUTE) {
            return Math.round(millis / MINUTE) + " 분";
        }
        return Math.round(millis / SECOND) + "초";
    }
    Utils.toReadableTime = toReadableTime;
    function shuffle(array, rng) {
        var currentIndex = array.length,
            temporaryValue,
            randomIndex;
        // While there remain elements to shuffle...
        while (0 !== currentIndex) {
            // Pick a remaining element...
            if (rng) {
                randomIndex = Math.floor(rng.nextRange(0, 100) * 0.01 * currentIndex);
            } else {
                randomIndex = Math.floor(Math.random() * currentIndex);
            }
            currentIndex -= 1;
            // And swap it with the current element.
            temporaryValue = array[currentIndex];
            array[currentIndex] = array[randomIndex];
            array[randomIndex] = temporaryValue;
        }
        return array;
    }
    Utils.shuffle = shuffle;
    function splitUp(arr, n) {
        var rest = arr.length % n,
            // how much to divide
        restUsed = rest,
            // to keep track of the division over the elements
        partLength = Math.floor(arr.length / n),
            result = [];
        for (var i = 0; i < arr.length; i += partLength) {
            var end = partLength + i,
                add = false;
            if (rest !== 0 && restUsed) {
                // should add one element for the division
                end++;
                restUsed--; // we've used one division element now
                add = true;
            }
            result.push(arr.slice(i, end)); // part of the array
            if (add) {
                i++; // also increment i in the case we added an extra element for division
            }
        }
        return result;
    }
    Utils.splitUp = splitUp;
    // move front elem to back
    function popFrontToBack(array) {
        var elem = array.shift();
        array.push(elem);
        return elem;
    }
    Utils.popFrontToBack = popFrontToBack;
    function round(value, decimals) {
        var tenPow = Math.pow(10, decimals);
        return Math.floor(value * tenPow) / tenPow;
    }
    Utils.round = round;
    function roundReal(value, decimals) {
        var tenPow = Math.pow(10, decimals);
        return Math.round(value * tenPow) / tenPow;
    }
    Utils.roundReal = roundReal;
    function countKeys(obj) {
        var count = 0;
        for (var k in obj) {
            if (obj.hasOwnProperty(k)) {
                count += 1;
            }
        }
        return count;
    }
    Utils.countKeys = countKeys;
    // inclusive
    function randomInRange(min, max) {
        return Math.min(min + Math.floor(Math.random() * (max - min + 1)), max);
    }
    Utils.randomInRange = randomInRange;
    function randomVariance(base, variance) {
        return base + Math.min(-variance + Math.floor(Math.random() * (variance - -variance + 1)), variance);
    }
    Utils.randomVariance = randomVariance;
    function randomInRangeDecimal(min, max) {
        return Math.min(min + Math.random() * (max - min), max);
    }
    Utils.randomInRangeDecimal = randomInRangeDecimal;
    function randomInt(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
    Utils.randomInt = randomInt;
    function randomChoice(arr, rng) {
        if (arr.length === 0) {
            return null;
        }
        if (rng) {
            return arr[rng.nextRange(0, arr.length)];
        } else {
            return arr[randomInRange(0, arr.length - 1)];
        }
    }
    Utils.randomChoice = randomChoice;
    /**
     * Chooses random from options that have the fewest counts for usage
     * @param optionCounts - {primitive -> int}
     * @param [onlyKeys] - [primitive]
     * @param [preferredKeys]
     */
    function randomKeyChoiceFavorUnchosen(optionCounts, onlyKeys, preferredKeys) {
        if (onlyKeys === void 0) {
            onlyKeys = null;
        }
        if (preferredKeys === void 0) {
            preferredKeys = null;
        }
        var lowestCount = -1;
        var key, i, max;
        // limit to given
        if (onlyKeys) {
            for (i = 0, max = onlyKeys.length; i < max; i++) {
                key = onlyKeys[i];
                if (optionCounts.hasOwnProperty(key)) {
                    if (lowestCount === -1 || optionCounts[key] < lowestCount) {
                        lowestCount = optionCounts[key];
                    }
                }
            }
        }
        // check all keys
        else {
                for (key in optionCounts) {
                    if (optionCounts.hasOwnProperty(key)) {
                        if (lowestCount === -1 || optionCounts[key] < lowestCount) {
                            lowestCount = optionCounts[key];
                        }
                    }
                }
            }
        if (lowestCount === -1) {
            return null;
        }
        var eligible = _reuseEligigle;
        eligible.length = 0;
        // loop limit given
        if (onlyKeys) {
            for (i = 0, max = onlyKeys.length; i < max; i++) {
                key = onlyKeys[i];
                if (optionCounts.hasOwnProperty(key)) {
                    if (optionCounts[key] === lowestCount) {
                        eligible[eligible.length] = key;
                    }
                }
            }
        }
        // loop all keys
        else {
                for (key in optionCounts) {
                    if (optionCounts.hasOwnProperty(key)) {
                        if (optionCounts[key] === lowestCount) {
                            eligible[eligible.length] = key;
                        }
                    }
                }
            }
        // many eligible, if we have preferredKeys, use those
        if (eligible.length > 1 && preferredKeys && preferredKeys.length) {
            var _prefKeyCheck_1 = {};
            preferredKeys.forEach(function (k) {
                return _prefKeyCheck_1[k] = 1;
            });
            var preferredInEligible = eligible.filter(function (k) {
                return _prefKeyCheck_1[k];
            });
            if (preferredInEligible.length) {
                return randomChoice(preferredInEligible);
            }
        }
        return randomChoice(eligible);
    }
    Utils.randomKeyChoiceFavorUnchosen = randomKeyChoiceFavorUnchosen;
    function randomPosInTile(tile, tileSize) {
        var pos = indexToPosition(tile.col, tile.row, tileSize);
        var varianceX = randomInRange(tileSize * 0.25, tileSize * 0.5);
        var varianceY = randomInRange(tileSize * 0.1, tileSize * 0.1);
        pos.x += randomChoice([-varianceX, varianceX]);
        pos.y += randomChoice([-varianceY, varianceY]) + tileSize * 0.1; //prefer lower
        return pos;
    }
    Utils.randomPosInTile = randomPosInTile;
    function gameMillisSince(game, timestamp) {
        return game.time.totalElapsedMillis() - timestamp;
    }
    Utils.gameMillisSince = gameMillisSince;
    function getGameMillis(game) {
        return game.time.totalElapsedMillis();
    }
    Utils.getGameMillis = getGameMillis;
    function minutesMillis(min) {
        return min * 60 * 1000;
    }
    Utils.minutesMillis = minutesMillis;
    function millisToSec(millis) {
        return Math.round(millis / 1000);
    }
    Utils.millisToSec = millisToSec;
    function millisToMin(millis) {
        return Math.round(this.millisToSec(millis) / 60);
    }
    Utils.millisToMin = millisToMin;
    function delayFunction(delay, game, fn) {
        if (!fn) throw new MissingArgsError();
        _delayFunctions.push({
            time: getGameMillis(game) + delay,
            fn: fn
        });
        _delayFunctions.sort(function (a, b) {
            if (a.time < b.time) return -1;
            if (a.time > b.time) return 1;
            return 0;
        });
    }
    Utils.delayFunction = delayFunction;
    /** update functions that are waiting to be executed */
    function updateDelayFunctions(game) {
        var curTime = getGameMillis(game);
        while (_delayFunctions.length > 0 && _delayFunctions[0].time < curTime) {
            var delayed = _delayFunctions.shift();
            delayed.fn();
        }
    }
    Utils.updateDelayFunctions = updateDelayFunctions;
    function removeFromArray(arr, elem) {
        var index = arr.indexOf(elem);
        if (index !== -1) {
            arr.splice(index, 1);
        }
    }
    Utils.removeFromArray = removeFromArray;
    function debugLog() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (!window['isProd']) {
            console.log.apply(this, arguments);
        }
    }
    Utils.debugLog = debugLog;
    // isinindexrange
    // onlyNearBuffer means index must be close to buffer edge
    function inIndexRange(startIndex, endIndex, index) {
        if (endIndex.col < startIndex.col || endIndex.row < startIndex.row) {
            console.log("WARN: passing endindex with value that is less than start value");
        }
        return index.col >= startIndex.col && index.col <= endIndex.col && index.row >= startIndex.row && index.row <= endIndex.row;
    }
    Utils.inIndexRange = inIndexRange;
    function mapDirections(fn) {
        [[1, 0], [-1, 0], [0, 1], [0, -1]].map(function (i) {
            fn(i[0], i[1]);
        });
    }
    Utils.mapDirections = mapDirections;
    /** return the direction that the given target is from current start */
    function getTargetIndexDirection(startRow, startCol, endRow, endCol) {
        if (endRow > startRow) {
            return DIRECTION.DOWN;
        } else if (endRow < startRow) {
            return DIRECTION.UP;
        } else if (endCol > startCol) {
            return DIRECTION.RIGHT;
        } else if (endCol < startCol) {
            return DIRECTION.LEFT;
        }
    }
    Utils.getTargetIndexDirection = getTargetIndexDirection;
    function _indexInKeys(r, c, size, keys) {
        if (!Utils.isValidIndex(r, c, size)) return false;
        var k = Utils.toIndexKey(r, c, size);
        return keys[k];
    }
    Utils._indexInKeys = _indexInKeys;
    function isValidIndex(row, col, size) {
        return typeof row !== 'undefined' && typeof col !== 'undefined' && row !== null && col !== null && row >= 0 && row < size && col >= 0 && col < size;
    }
    Utils.isValidIndex = isValidIndex;
    function sum(n) {
        return n.reduce(function (acc, v) {
            return acc + v;
        }, 0);
    }
    Utils.sum = sum;
    function avg(n) {
        return n.reduce(function (acc, v) {
            return acc + v;
        }, 0) / n.length;
    }
    Utils.avg = avg;
    //
    // Assets
    //
    function atlasFrame(folder, imgName) {
        return 'src/www/img-atlas/' + folder + '/' + imgName + '.png';
    }
    Utils.atlasFrame = atlasFrame;
    function atlasFrameNoExt(folder, imgName) {
        return 'src/www/img-atlas/' + folder + '/' + imgName;
    }
    Utils.atlasFrameNoExt = atlasFrameNoExt;
    function addAnimation(sprite, name, folder, imgNames, fps, loop) {
        if (fps === void 0) {
            fps = 30;
        }
        if (loop === void 0) {
            loop = true;
        }
        var frames = imgNames.map(function (i) {
            return atlasFrame(folder, i);
        });
        sprite.animations.add(name, frames, fps, loop);
    }
    Utils.addAnimation = addAnimation;
    // Inserts "-mask" before ".png" in a frame name
    // Assumes frame name ends with .png extension
    function frameToMaskFrame(frameName, suffix) {
        if (suffix === void 0) {
            suffix = "mask";
        }
        var splits = frameName.split("/");
        splits[splits.length - 2] = splits[splits.length - 2] + ("-" + suffix);
        frameName = splits.join("/");
        return frameName.slice(0, frameName.length - 4) + ("-" + suffix + ".png");
    }
    Utils.frameToMaskFrame = frameToMaskFrame;
    /**
     * Convenience method for creating sprites
     *  - doesn't work for structures/ because their path is different
     * @param city
     * @param atlas - example "ui-2"
     * @param frame - example "speech-bubble"
     */
    function createSprite(city, atlas, frame) {
        return new Phaser.Sprite(city.game, 0, 0, "atlas-" + atlas, atlasFrame(atlas, frame));
    }
    Utils.createSprite = createSprite;
    function createSpriteAt(city, row, col, offsetX, offsetY, widthPercent, texture, atlasfolder, frame, parent) {
        var pos = Utils.indexToPosition(col, row, Tile.TILE_WIDTH);
        var s = new Phaser.Sprite(city.game, pos.x + Tile.TILE_WIDTH * offsetX, pos.y + Tile.TILE_WIDTH * offsetY, texture, Utils.atlasFrame(atlasfolder, frame));
        if (parent) {
            parent.addChild(s);
        }
        //setTimeout(() => {
        scaleToWidth(s, Tile.TILE_WIDTH * widthPercent);
        //});
        s.anchor.setTo(0.5, 0.9);
        return s;
    }
    Utils.createSpriteAt = createSpriteAt;
    function setVisibleAndAlpha(displayObj) {
        displayObj.visible = true;
        displayObj.alpha = 1;
    }
    Utils.setVisibleAndAlpha = setVisibleAndAlpha;
    function getPercentZoomedIn(city) {
        return (city.scale.x - Global.ZOOM_MIN) / (Global.ZOOM_MAX - Global.ZOOM_MIN);
    }
    Utils.getPercentZoomedIn = getPercentZoomedIn;
    // this fn's max and min don't make a lot of sense
    function capPercentage(originalPercent, percentForMax, minPercent) {
        return Math.min(minPercent, Math.min(1, originalPercent / percentForMax));
    }
    Utils.capPercentage = capPercentage;
    function percentRange(minVal, maxVal, percent) {
        return minVal + (maxVal - minVal) * percent;
    }
    Utils.percentRange = percentRange;
    /** determine how long it takes to get from A to B deltas given speed */
    function getTimeBetweenPositions(xDelta, yDelta, city, speed) {
        var zoomMult = city.cityScaler.zoom;
        zoomMult += (zoomMult - 1) * 0.1; // extra zoom
        return (Math.abs(xDelta) + Math.abs(yDelta)) * speed / zoomMult;
    }
    Utils.getTimeBetweenPositions = getTimeBetweenPositions;
    /** Expects tiles defined to follow the suffix convention */
    function generateBoundTextures(atlas, basePath) {
        return {
            "SPRITESHEET": atlas,
            "DOWN_FRAME": basePath + "-bottom.png",
            "UP_FRAME": basePath + "-top.png",
            "VERTICAL_FRAME": basePath + "-vertical.png",
            "CLOSED_TOP_FRAME": basePath + "-closed-top.png",
            "CLOSED_RIGHT_FRAME": basePath + "-closed-right.png",
            "OPEN_TOP_RIGHT_FRAME": basePath + "-open-top-right.png",
            "RIGHT_FRAME": basePath + "-right.png",
            "OPEN_BOTTOM_RIGHT_FRAME": basePath + "-open-bottom-right.png",
            "LEFT_FRAME": basePath + "-left.png",
            "SINGLE_FRAME": basePath + "-single.png",
            "OPEN_FRAME": basePath + "-open-all.png",
            "HORIZONTAL_FRAME": basePath + "-horizontal.png",
            "CLOSED_BOTTOM_FRAME": basePath + "-closed-bottom.png",
            "CLOSED_LEFT_FRAME": basePath + "-closed-left.png",
            "OPEN_TOP_LEFT_FRAME": basePath + "-open-top-left.png",
            "OPEN_BOTTOM_LEFT_FRAME": basePath + "-open-bottom-left.png"
        };
    }
    Utils.generateBoundTextures = generateBoundTextures;
    function isPlayingAnimation(sprite, animationName) {
        return sprite.animations && sprite.animations.currentAnim && sprite.animations.currentAnim.name === animationName && sprite.animations.currentAnim.isPlaying;
    }
    Utils.isPlayingAnimation = isPlayingAnimation;
    function padZero(num, size) {
        var s = num + "";
        while (s.length < size) {
            s = "0" + s;
        }return s;
    }
    Utils.padZero = padZero;
    // Common
    /****************************
     * JS extended functions
     ***************************/
    /**
     * Used for extending classes with mixins - global function
     * @param destination
     * @param source
     * @param overwrite - don't skip existing fields, overwrite them
     * @returns {*}
     */
    function extend(destination, source, overwrite) {
        if (overwrite === void 0) {
            overwrite = false;
        }
        if (!source) {
            console.error("WARNING: Trying to extend with undefined source. Extended fields need to be concatenated in order?");
        }
        for (var k in source) {
            if (source.hasOwnProperty(k) && (!destination[k] || overwrite)) {
                destination[k] = source[k];
            }
        }
        return destination;
    }
    Utils.extend = extend;
    /** Shallow extend */
    function extendCopyShallow(dest, source) {
        var newObj = {};
        Object.keys(dest).forEach(function (k) {
            newObj[k] = dest[k];
        });
        Object.keys(source).forEach(function (k) {
            newObj[k] = source[k];
        });
        return newObj;
    }
    Utils.extendCopyShallow = extendCopyShallow;
    function roundFixed(number, tensMult) {
        if (tensMult === void 0) {
            tensMult = 1;
        }
        return Math.round(number / tensMult) * tensMult;
    }
    Utils.roundFixed = roundFixed;
    function numberWithCommas(x) {
        if (x === null) {
            x = 0;
        }
        if (isNaN(x)) {
            console.log("WARN: unexpected NaN - please resolve");
        }
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
    Utils.numberWithCommas = numberWithCommas;
    function moneyFormat(x, round) {
        if (round) {
            x = Math.round(x);
        }
        return "$" + numberWithCommas(x);
    }
    Utils.moneyFormat = moneyFormat;
    function decimalToPercentStr(x) {
        return Math.round(x * 100) + "%";
    }
    Utils.decimalToPercentStr = decimalToPercentStr;
    function clamp(val, min, max) {
        return Math.min(Math.max(val, min), max);
    }
    Utils.clamp = clamp;
    function reduceDistFromOne(val, reduction) {
        var v = Math.abs(val);
        var diff = (v - 1) * reduction;
        if (val < 0) diff = -diff;
        return val - diff;
    }
    Utils.reduceDistFromOne = reduceDistFromOne;
    function multiplyWithWeight(val, multiplier, weight) {
        var variableAmt = val * weight;
        var fixedAmt = val - variableAmt;
        return fixedAmt + variableAmt * multiplier;
    }
    Utils.multiplyWithWeight = multiplyWithWeight;
    function numToFixed(num, fractionDigits) {
        return parseFloat(num.toFixed(fractionDigits));
    }
    Utils.numToFixed = numToFixed;
    /** Returns maximum that a finger should move during a tap command */
    function maxTouchTapMove(dimensionPercent) {
        dimensionPercent = dimensionPercent || Global.MAX_TAP_MOVE_THRESHOLD;
        var minDimension = Math.min(window.innerWidth, window.innerHeight);
        return minDimension * dimensionPercent;
    }
    Utils.maxTouchTapMove = maxTouchTapMove;
    /**
     * Deep copy an object
     */
    function copy(obj) {
        if (null == obj || "object" != (typeof obj === "undefined" ? "undefined" : _typeof(obj))) return obj;
        var copy = obj.constructor();
        for (var attr in obj) {
            if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
        }
        return copy;
    }
    Utils.copy = copy;
    // UI
    function addClassMomentarily(elem, cls, delay) {
        if (delay === void 0) {
            delay = 0;
        }
        elem.addClass(cls);
        setTimeout(function () {
            elem.removeClass(cls);
        }, delay);
    }
    Utils.addClassMomentarily = addClassMomentarily;
    // Random number generator
    var RNG = /** @class */function () {
        function RNG(seed) {
            var _this = this;
            this.m = 0x80000000; // 2**31;
            this.a = 1103515245;
            this.c = 12345;
            this.nextInt = function () {
                _this.state = (_this.a * _this.state + _this.c) % _this.m;
                return _this.state;
            };
            this.nextRange = function (start, end) {
                // returns in range [start, end): including start, excluding end
                // can't modulu nextInt because of weak randomness in lower bits
                var rangeSize = end - start;
                var randomUnder1 = _this.nextInt() / _this.m;
                return start + Math.floor(randomUnder1 * rangeSize);
            };
            this.state = seed ? seed : Math.floor(Math.random() * (this.m - 1));
        }
        return RNG;
    }();
    Utils.RNG = RNG;
    function assert(condition, message) {
        if (!condition) {
            throw message || "Assertion failed";
        }
    }
    Utils.assert = assert;
    //
    // Memory
    //
    function destroyIfAlive(sprite) {
        if (sprite && sprite.alive) {
            sprite.destroy();
            return true;
        }
        return false;
    }
    Utils.destroyIfAlive = destroyIfAlive;
    function nukeReferences(obj) {
        if (!obj) return;
        if ((typeof obj === "undefined" ? "undefined" : _typeof(obj)) === 'object') {
            Object.keys(obj).forEach(function (k) {
                var type = _typeof(obj[k]);
                if (type !== 'string' && type !== 'boolean' && type !== 'number') {
                    obj[k] = null;
                }
            });
        }
    }
    Utils.nukeReferences = nukeReferences;
})(Utils || (Utils = {}));
/**
 * State machine state to be used on components that require state
 * e.g. city.state, grid.state, etc..
 *
 * Each state can specify an input handler, which can be implemented inside the class
 * or be handled by an instance of InputHandler
 *
 * @constructor
 */
var State = /** @class */function () {
  function State() {}
  State.prototype.enter = function () {};
  ;
  State.prototype.exit = function () {};
  ;
  return State;
}();
var DIRECTION;
(function (DIRECTION) {
    DIRECTION.UP = "up";
    DIRECTION.LEFT = "left";
    DIRECTION.RIGHT = "right";
    DIRECTION.DOWN = "down";
    DIRECTION.ALL = [DIRECTION.UP, DIRECTION.LEFT, DIRECTION.RIGHT, DIRECTION.DOWN];
    function isValidDirection(dir) {
        return DIRECTION.ALL.indexOf(dir) !== -1;
    }
    DIRECTION.isValidDirection = isValidDirection;
    function getOppositeDirection(dir) {
        if (dir === DIRECTION.LEFT) {
            return DIRECTION.RIGHT;
        } else if (dir === DIRECTION.RIGHT) {
            return DIRECTION.LEFT;
        } else if (dir === DIRECTION.UP) {
            return DIRECTION.DOWN;
        } else if (dir === DIRECTION.DOWN) {
            return DIRECTION.UP;
        }
        throw new Error("invalid direction passed " + dir);
    }
    DIRECTION.getOppositeDirection = getOppositeDirection;
})(DIRECTION || (DIRECTION = {}));
var SaveHelper;
(function (SaveHelper) {
    SaveHelper.REPLACEMENTS = {};
    SaveHelper.REPLACEMENTS._a_ = "saveRow";
    SaveHelper.REPLACEMENTS._b_ = "saveCol";
    SaveHelper.REPLACEMENTS._d_ = "_initTime";
    SaveHelper.REPLACEMENTS._e_ = "_creationTime";
    SaveHelper.REPLACEMENTS._f_ = "_canDevelop";
    SaveHelper.REPLACEMENTS._g_ = "visible";
    SaveHelper.REPLACEMENTS._h_ = "_percent";
    SaveHelper.REPLACEMENTS._i_ = "_refArgName";
    SaveHelper.REPLACEMENTS._j_ = "IndustrialTile";
    SaveHelper.REPLACEMENTS._k_ = "ResidentialTile";
    SaveHelper.REPLACEMENTS._l_ = "CommercialTile";
    SaveHelper.REPLACEMENTS._m_ = "_completed";
    SaveHelper.REPLACEMENTS._n_ = "atlas-folder";
    SaveHelper.REPLACEMENTS._o_ = "structures/commercial";
    SaveHelper.REPLACEMENTS._p_ = "structures/residential";
    SaveHelper.REPLACEMENTS._q_ = "structures/industrial";
    SaveHelper.REPLACEMENTS._r_ = "structures/special";
    SaveHelper.REPLACEMENTS._s_ = "atlas-folder";
    SaveHelper.REPLACEMENTS._t_ = "atlas-industrial";
    SaveHelper.REPLACEMENTS._u_ = "atlas-commercial";
    SaveHelper.REPLACEMENTS._v_ = "atlas-texture";
    SaveHelper.REPLACEMENTS._w_ = "atlas-residential";
    SaveHelper.REPLACEMENTS._x_ = "\"fields\":";
    SaveHelper.REPLACEMENTS._y_ = "\"class\":";
    SaveHelper.REPLACEMENTS._z_ = "\"active\":";
    SaveHelper.REPLACEMENTS._1_ = "StructureSprite";
    SaveHelper.REPLACEMENTS._2_ = "\"extra\":";
    SaveHelper.REPLACEMENTS._3_ = "\"frameName\"";
    SaveHelper.REPLACEMENTS._4_ = "src/www/img-atlas/";
    SaveHelper.REPLACEMENTS._5_ = "\"baseTile\"";
    SaveHelper.REPLACEMENTS._6_ = "\"tilePollutionRange\"";
    SaveHelper.REPLACEMENTS._7_ = "\"building\"";
    SaveHelper.REPLACEMENTS._8_ = "\"sizeCol\"";
    SaveHelper.REPLACEMENTS._9_ = "\"sizeRow\"";
    SaveHelper.REPLACEMENTS._0_ = "StructureTile";
    var REGEX_REPLACES_MINIFY = {};
    SaveHelper.minimizeString = function (str) {
        var regex;
        for (var r in SaveHelper.REPLACEMENTS) {
            if (SaveHelper.REPLACEMENTS.hasOwnProperty(r)) {
                if (!REGEX_REPLACES_MINIFY[r]) {
                    REGEX_REPLACES_MINIFY[r] = new RegExp(SaveHelper.REPLACEMENTS[r], 'g');
                }
                regex = REGEX_REPLACES_MINIFY[r];
                str = str.replace(regex, r);
            }
        }
        return str;
    };
    SaveHelper.unminifyString = function (str) {
        for (var r in SaveHelper.REPLACEMENTS) {
            if (SaveHelper.REPLACEMENTS.hasOwnProperty(r)) {
                str = str.replace(new RegExp(r, 'g'), SaveHelper.REPLACEMENTS[r]);
            }
        }
        return str;
    };
})(SaveHelper || (SaveHelper = {}));
var Screen = function Screen(pocketCity) {
    this.pocketCity = pocketCity;
    this.name = "default";
};
Screen.prototype.phaserState = function () {
    // Return the phaset State obj here
    return {};
};
/**
 * Checks for weird cases that might stall the saving functionality
 *
 * Detects for:
 *   FileStorage.isSavingCity stuck in true
 *   window['compressingCity'] stuck in true
 * */
var StorageCheckerProcess;
(function (StorageCheckerProcess) {
    var lastCompressCityTrue = 0;
    var lastCompressCityFalse = 0;
    var lastIsSavingCityTrue = 0;
    var lastIsSavingCityFalse = 0;
    function setLastCompressCityTrue() {
        lastCompressCityTrue = Date.now();
    }
    StorageCheckerProcess.setLastCompressCityTrue = setLastCompressCityTrue;
    function setLastCompressCityFalse() {
        lastCompressCityFalse = Date.now();
    }
    StorageCheckerProcess.setLastCompressCityFalse = setLastCompressCityFalse;
    function setLastIsSavingCityTrue() {
        lastIsSavingCityTrue = Date.now();
    }
    StorageCheckerProcess.setLastIsSavingCityTrue = setLastIsSavingCityTrue;
    function setLastIsSavingCityFalse() {
        lastIsSavingCityFalse = Date.now();
    }
    StorageCheckerProcess.setLastIsSavingCityFalse = setLastIsSavingCityFalse;
    function checkLongStates() {
        var THRESHOLD = 10000;
        var now = Date.now();
        // check window['compressingCity'] is not set for too long
        if (lastCompressCityTrue > lastCompressCityFalse && now - lastCompressCityTrue >= THRESHOLD) {
            console.error("lastCompressCityTrue has been true for a long time, setting compressingCity to false");
            window['compressingCity'] = false;
        }
        // check FileStorage.isSavingCity is not set for too long
        if (lastIsSavingCityTrue > lastIsSavingCityFalse && now - lastIsSavingCityTrue >= THRESHOLD) {
            console.error("lastIsSavingCityTrue has been true for a long time, setting isSavingCity to false");
            if (window['pocketCityGame'].storage.isSavingCity) {
                window['pocketCityGame'].storage.isSavingCity = false;
            }
        }
    }
    setInterval(checkLongStates, 1000);
})(StorageCheckerProcess || (StorageCheckerProcess = {}));
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var PCStorage = /** @class */function () {
    function PCStorage(readyCb) {
        var _this = this;
        this.initialCityCount = 0;
        this.loadData(function () {
            // sort data into zero indexed cities cache
            //this.ensureCitiesSortedZeroIndexed();
            // load user settings also
            _this.loadUserSettings(readyCb);
        });
    }
    PCStorage.prototype.getUserSetting = function (key, defaultVal) {
        if (this.userSettingsCache.hasOwnProperty(key)) {
            return this.userSettingsCache[key];
        }
        return defaultVal;
    };
    PCStorage.prototype.updateUserSetting = function (key, value, cb, alsoSave) {
        if (alsoSave === void 0) {
            alsoSave = true;
        }
        this.userSettingsCache[key] = value;
        if (alsoSave) {
            this.saveUserSettings(cb);
        }
    };
    PCStorage.prototype.onMoveCityIndex = function (oldIndex, newIndex) {
        // default, no additional action
    };
    // to shift indicies to be consecutive from zero in citiesCache
    PCStorage.prototype.ensureCitiesSortedZeroIndexed = function () {
        console.warn("do nothing, unecessary and causes trouble");
        if (_typeof(this.citiesCache) !== 'object') {
            return;
        }
        var activeCity = window['pocketCityGame'].activeCity;
        var availableKeys = Object.keys(this.citiesCache).map(function (k) {
            return +k;
        });
        availableKeys.sort();
        var newCitiesCache = {};
        for (var newIndex = 0; newIndex < availableKeys.length; newIndex++) {
            var oldKey = availableKeys[newIndex];
            if (activeCity) {
                if (activeCity.cityIndex === oldKey) {
                    activeCity.cityIndex = newIndex;
                }
                if (activeCity.centralCityIndex === oldKey) {
                    activeCity.centralCityIndex = newIndex;
                }
            }
            newCitiesCache[newIndex] = this.citiesCache[oldKey];
            this.onMoveCityIndex(oldKey, newIndex);
        }
        this.citiesCache = newCitiesCache;
    };
    /**
     * Return a free slot (index)
     * Returns null if no free index available due to max cities restriction
     */
    PCStorage.prototype.getFreeIndex = function (allowAny) {
        if (allowAny === void 0) {
            allowAny = false;
        }
        var max = PocketCity.getMaxCities() * 9 + 1;
        Object.keys(this.citiesCache);
        if (allowAny) {
            max = 9999;
        }
        var curKeys = Object.keys(this.citiesCache);
        if (curKeys.length >= max) {
            return null;
        }
        if (curKeys.length === 0) {
            return 0;
        }
        var maxIndex = 0;
        Object.keys(this.citiesCache).forEach(function (i) {
            if (Number(i) > maxIndex) {
                maxIndex = Number(i);
            }
        });
        return maxIndex + 1;
    };
    PCStorage.prototype.hasFreeIndex = function () {
        return this.getFreeIndex() !== null;
    };
    /** Returns the city to load for continuing an existing game */
    PCStorage.prototype.getLatestCitySave = function (cb, isSandbox) {
        var _this = this;
        if (isSandbox === void 0) {
            isSandbox = false;
        }
        var latestCity = null;
        var latestCitySnapshotTime = 0;
        var latestCityIndex = -1;
        var cityObjects = [];
        var numNeedProcess = Object.keys(this.citiesCache).length;
        var _doneCalled = false;
        var numProcessed = 0;
        this.initialCityCount = 0;
        if (Object.keys(this.citiesCache).length) {
            Object.keys(this.citiesCache).forEach(function (i) {
                console.log("getting city at i:" + i);
                _this.getCity(i, function (cityStr) {
                    try {
                        cityObjects[+i] = FileStorage.parseJSONUntilSuccess(cityStr);
                        console.log("set cityObject at " + i);
                    } catch (e) {
                        try {
                            JSON.parse(cityStr);
                        } catch (e) {
                            console.log(e);
                        }
                        // couldn't parse city (corrupted beyond parsing)
                        console.log("could not parse city");
                    }
                    numProcessed += 1;
                    console.log("checking num processed:", numProcessed, "==", numNeedProcess);
                    if (numProcessed == numNeedProcess) {
                        if (!_doneCalled) {
                            _doneCalled = true;
                            _this.initialCityCount = -1;
                            doneLoad();
                        } else {
                            console.warn("cb already called");
                        }
                    }
                });
            });
        } else {
            this.initialCityCount = -1;
            doneLoad();
        }
        function doneLoad() {
            for (var i = 0; i < cityObjects.length; i++) {
                var cityObj = cityObjects[i];
                if (!cityObj) continue; // deleted intermediate
                var latestSnapshot = City.getLatestSnapshot(cityObj);
                if (isSandbox && latestSnapshot.metadata.isSandbox || !isSandbox && !latestSnapshot.metadata.isSandbox) {
                    var snapshotTime = latestSnapshot.timestamp;
                    if (snapshotTime > latestCitySnapshotTime) {
                        latestCity = cityObj;
                        latestCitySnapshotTime = snapshotTime;
                        latestCityIndex = i;
                    }
                }
            }
            return cb([latestCity, latestCityIndex]);
        }
    };
    /**
     * Returns array of cities metadata, latest timestamp first
     * @returns {{index,metadata,stats,lastTimestamp}[]}
     */
    PCStorage.prototype.getCitiesMetadata = function (cb, sandbox, anyType) {
        if (sandbox === void 0) {
            sandbox = false;
        }
        if (anyType === void 0) {
            anyType = false;
        }
        var cities = [];
        var _calledCb = false;
        var numCities = 0;
        var numProcessed = 0;
        for (var i in this.citiesCache) {
            if (this.citiesCache.hasOwnProperty(i)) {
                numCities += 1;
            }
        }
        if (numCities) {
            var _loop_1 = function _loop_1(i) {
                if (this_1.citiesCache.hasOwnProperty(i)) {
                    this_1.getCity(i, function (cityStr) {
                        numProcessed += 1;
                        try {
                            var saveState = FileStorage.parseJSONUntilSuccess(cityStr);
                            var latestSnapshot = City.getLatestSnapshot(saveState);
                            var snapshotIsSandbox = latestSnapshot.metadata.isSandbox;
                            if (anyType || sandbox && snapshotIsSandbox || !sandbox && !snapshotIsSandbox) {
                                cities.push({
                                    "index": +i,
                                    "metadata": latestSnapshot.metadata || {},
                                    "stats": latestSnapshot.stats || {},
                                    "lastTimestamp": latestSnapshot.timestamp
                                });
                            }
                        } catch (e) {
                            // this city is invalid unfortunately
                        }
                        if (numProcessed == numCities) {
                            Utils.sortOnKey(cities, 'lastTimestamp');
                            cities.reverse();
                            if (!_calledCb) {
                                _calledCb = true;
                                cb(cities);
                            } else {
                                console.warn("already called cb");
                            }
                        }
                    });
                }
            };
            var this_1 = this;
            for (var i in this.citiesCache) {
                _loop_1(i);
            }
        } else {
            cb([]);
        }
    };
    PCStorage.getReplacedAllSerial = function (serializedCity, newMoney) {
        var oldSerMoney = new RegExp('"money":\\d+,', "g");
        var newSerMoney = '"money":' + newMoney + ',';
        var serializedNew = serializedCity.replace(oldSerMoney, newSerMoney);
        var oldSerMoneyAlt = new RegExp('"money":\\d+}', "g");
        var newSerMoneyAlt = '"money":' + newMoney + '}';
        serializedNew = serializedNew.replace(oldSerMoneyAlt, newSerMoneyAlt);
        return serializedNew;
    };
    PCStorage.prototype.replaceMoney = function (index, oldMoney, newMoney, cb) {
        if (isNaN(oldMoney) || typeof oldMoney !== 'number') {
            cb("oldMoney is not number:", oldMoney);
            return;
        }
        if (isNaN(newMoney) || typeof newMoney !== 'number') {
            cb("newMoney is not number:", newMoney);
            return;
        }
        var self = this;
        console.log("Replacing money at index", index, "from old money", oldMoney, "to new", newMoney);
        this.getCity(index, function (serializedCity) {
            if (!serializedCity) {
                cb("Could not find city at index:" + index);
                return;
            }
            var serializedNew = PCStorage.getReplacedAllSerial(serializedCity, newMoney);
            // ensure serialized works
            GridSerializer.decompressSaveCityAsync(serializedNew, function (decompressed) {
                var valid = true;
                if (!decompressed) {
                    valid = false;
                }
                try {
                    JSON.parse(decompressed);
                } catch (e) {
                    valid = false;
                }
                if (valid) {
                    // update with existing snapshots replaced money
                    self.saveCity(index, serializedNew, cb);
                } else {
                    cb("New city was invalid JSON, did not update");
                }
            });
        });
    };
    PCStorage.prototype.clearCity = function (index, cb) {
        var _this = this;
        this.citiesCachePreDeleted(index, function () {
            delete _this.citiesCache[index];
            //this.ensureCitiesSortedZeroIndexed();
            _this.citiesCachePostDeleted(index, cb);
        });
    };
    /** Called whenever citiesCache is updated */
    PCStorage.prototype.citiesCachePreDeleted = function (index, cb) {
        if (cb) cb(); // default no op
    };
    PCStorage.prototype.citiesCachePostDeleted = function (index, cb) {
        if (cb) cb(); // default no op
    };
    return PCStorage;
}();
var BackupChecker;
(function (BackupChecker) {
    BackupChecker.recovered = [];
    BackupChecker.alertedUids = {};
    var DONE_ALERT_PREFIX = "recovered_";
    // Return list of
    function checkForUnlinkedBackups(storage) {
        var linkedUids = {};
        Object.keys(storage.citiesCache).forEach(function (k) {
            linkedUids[storage.citiesCache[k]] = 1;
        });
        window['requestFileSystem'](LocalFileSystem.PERSISTENT, 0, function (fs) {
            console.log("got fs");
            fs.root.getDirectory('/', { create: false }, function (entry) {
                console.log("got directory entry", entry);
                var reader = entry.createReader();
                console.log(reader.readEntries(function (entries) {
                    var unlinked = [];
                    console.log(entries);
                    entries.forEach(function (entry) {
                        var name = entry.name;
                        if (name.indexOf(DONE_ALERT_PREFIX) === 0) {
                            var uid = name.split(".save")[0].split(DONE_ALERT_PREFIX + "pocket_city_s_")[1];
                            BackupChecker.alertedUids[uid] = 1;
                        } else if (name.indexOf(FileStorage.FILE_NAME_CITY_PREFIX) !== -1 && name.indexOf(".save") !== -1 && name.indexOf(".backup") === -1 && name.indexOf("pocket_city_s_") === 0) {
                            var uid = name.split(".save")[0].split("pocket_city_s_")[1];
                            if (!linkedUids[uid]) {
                                unlinked.push([name, uid]);
                            }
                        }
                    });
                    keepOnlyCentralCities(unlinked, function (unlinkedOnlycentral) {
                        processUnlinkedBackupsMetadata(unlinkedOnlycentral);
                    });
                }));
            }, function (e) {
                console.log("could not get directory");
                console.log(e);
            });
        });
    }
    BackupChecker.checkForUnlinkedBackups = checkForUnlinkedBackups;
    function keepOnlyCentralCities(unlinkedFileNames, cb) {
        var keep = [];
        var processed = 0;
        if (!unlinkedFileNames.length) {
            cb([]);
            return;
        }
        unlinkedFileNames.forEach(function (tuple) {
            var fileName = tuple[0],
                uid = tuple[1];
            var storage = window['pocketCityGame'].storage;
            storage.getFileEntry(fileName, function (fileEntry) {
                storage._readGenericFile(fileEntry, function (result) {
                    GridSerializer.decompressSaveCityAsync(result, function (decompressed) {
                        var cityState = null;
                        try {
                            cityState = FileStorage.parseJSONUntilSuccess(SaveHelper.unminifyString(decompressed));
                        } catch (e) {
                            cityState = null;
                        }
                        if (cityState && !City.getLatestSnapshot(cityState).stats.isNeighbor) {
                            keep.push([fileName, uid]);
                        }
                        processed += 1;
                        if (processed == unlinkedFileNames.length) {
                            cb(keep);
                        }
                    });
                }, function () {
                    processed += 1;
                    if (processed == unlinkedFileNames.length) {
                        cb(keep);
                    }
                }, FileStorage.noOp); // just signals when everything is done, no op
            });
        });
    }
    BackupChecker.keepOnlyCentralCities = keepOnlyCentralCities;
    function processUnlinkedBackupsMetadata(unlinkedFileNames) {
        var needsAlert = [];
        unlinkedFileNames.forEach(function (tuple) {
            var fileName = tuple[0],
                uid = tuple[1];
            if (!BackupChecker.alertedUids[uid]) {
                needsAlert.push([fileName, uid]);
            } else {
                BackupChecker.recovered.push([fileName, uid]);
            }
        });
        var doneRenamesAndAlert = function doneRenamesAndAlert() {
            if (needsAlert.length) {
                // Show DOM
                showBackups(true);
            }
        };
        var touchedCount = 0;
        needsAlert.forEach(function (tuple) {
            var fileName = tuple[0],
                uid = tuple[1];
            var touchName = DONE_ALERT_PREFIX + fileName;
            // Create blank file to mark as alerted
            touchFile(touchName, function () {
                // moved
                touchedCount += 1;
                BackupChecker.recovered.push([fileName, uid]);
                if (touchedCount === needsAlert.length) {
                    doneRenamesAndAlert();
                }
            });
        });
    }
    BackupChecker.processUnlinkedBackupsMetadata = processUnlinkedBackupsMetadata;
    function showBackups(withMsgAboutSettings) {
        if (withMsgAboutSettings === void 0) {
            withMsgAboutSettings = false;
        }
        // get metadata for each backup
        var dom = '';
        var processed = 0;
        var storage = window['pocketCityGame'].storage;
        var doneDomAppends = function doneDomAppends() {
            var settingsDom = "";
            if (withMsgAboutSettings) {
                settingsDom = "You can access these recovered cities from the settings menu.";
            }
            var backupDom = '<div class="backupModal shadow">' + '<h2>Recovered Cities</h2>' + '<span class="srcwwwimgatlasdomspritesclose_iconpng faded-button recover-close prevent-close"></span>' + "<p>One or more unsaved cities were detected, possibly due to a file error. Tap on the city name to recover it. " + settingsDom + '<br/><br/><strong>Cities recovered:</strong></p>' + '' + dom + '</div>';
            $('body').append(backupDom);
            $(".backup-city-inner").click(function (e) {
                e.preventDefault();
                var elem = $(this).parent();
                recoverUnlinkedBackup(elem.attr("data-file"), elem.attr("data-uid"));
            });
            $(".recover-close").click(function (e) {
                e.preventDefault();
                $(".backupModal").remove();
            });
        };
        var _loop_1 = function _loop_1(i) {
            var recover = BackupChecker.recovered[i];
            var name_1 = recover[0],
                uid = recover[1];
            storage.getFileEntry(name_1, function (fileEntry) {
                storage._readGenericFile(fileEntry, function (result) {
                    GridSerializer.decompressSaveCityAsync(result, function (decompressed) {
                        var cityState = FileStorage.parseJSONUntilSuccess(SaveHelper.unminifyString(decompressed));
                        processed += 1;
                        var snapshot = City.getLatestSnapshot(cityState);
                        var cityName = snapshot.metadata.name;
                        var inner = "레벨 " + snapshot.stats.level;
                        if (snapshot.metadata.isSandbox) {
                            inner = "Sandbox";
                        }
                        dom += "<div class=\"backup-city\" data-file=\"" + name_1 + "\" data-uid=\"" + uid + "\" style=\"width:95%; padding:10px 5px; background:#eee;border-bottom:1px solid #ccc\">" + cityName + " (" + inner + ") <span class=\"btn btn-default btn-sm backup-city-inner\" style=\"float:right;padding:5px 2px; min-width:55px;margin-top:-3px;\">Recover \u2192</span></div>";
                        if (processed === BackupChecker.recovered.length) {
                            doneDomAppends();
                        }
                    });
                }, function () {
                    processed += 1;
                }, FileStorage.noOp); // just signals when everything is done, no op
            });
        };
        for (var i = 0; i < BackupChecker.recovered.length; i++) {
            _loop_1(i);
        }
    }
    BackupChecker.showBackups = showBackups;
    function recoverUnlinkedBackup(filename, uid) {
        var storage = window['pocketCityGame'].storage;
        var gameplayUI = window['pocketCityGame'].gameplayUI;
        gameplayUI.showSettingsConfirmation("Are you sure you want to recover this city?", function () {
            gameplayUI.showMessageModal("Loading City", true);
            setTimeout(function () {
                console.log("recover this city:" + filename + " " + uid);
                var index = storage.getFreeIndex(true);
                storage.citiesCache[index] = uid;
                // Also recover neighbor cities...
                storage.getFileEntry(filename, function (fileEntry) {
                    storage._readGenericFile(fileEntry, function (result) {
                        GridSerializer.decompressSaveCityAsync(result, function (decompressed) {
                            var cityState = null;
                            try {
                                cityState = FileStorage.parseJSONUntilSuccess(SaveHelper.unminifyString(decompressed));
                            } catch (e) {
                                cityState = null;
                            }
                            if (!cityState) return; // something broke
                            var snapshot = City.getLatestSnapshot(cityState);
                            if (snapshot.stats.regions) {
                                snapshot.stats.regions.forEach(function (r) {
                                    if (r) {
                                        storage.citiesCache[storage.getFreeIndex(true)] = r;
                                    }
                                });
                            }
                            // Load city
                            if ($('.hide_home').length) {
                                // load from settings page
                                gameplayUI.pocketCity.loadCity(index);
                            } else {
                                // home screen
                                window['pocketCityGame'].hideHomeScreen();
                                window['pocketCityGame']._beforeLoadCityFromStartScreen();
                                window['pocketCityGame'].loadCity(index);
                            }
                            $(".backupModal").remove();
                            // Remove from in-memory list
                            var iRemove = 0;
                            for (var i = 0; i < BackupChecker.recovered.length; i++) {
                                if (BackupChecker.recovered[i][0] === filename) {
                                    iRemove = i;
                                }
                            }
                            console.log("removing at index", iRemove);
                            BackupChecker.recovered.splice(iRemove, 1);
                            // Save main metadata file
                            storage.writeCitiesCacheMetadataIntoFile(function () {});
                        });
                    }, function () {}, FileStorage.noOp); // just signals when everything is done, no op
                });
            }, 250);
        });
    }
    BackupChecker.recoverUnlinkedBackup = recoverUnlinkedBackup;
    function touchFile(fileName, cb) {
        var cbCalled = false;
        window['requestFileSystem'](LocalFileSystem.PERSISTENT, 0, function (fs) {
            fs.root.getFile(fileName, { create: true, exclusive: false }, function (fileEntry) {
                fileEntry.createWriter(function (fileWriter) {
                    fileWriter.onerror = function (e) {
                        // nothing
                    };
                    fileWriter.onwriteend = function () {
                        if (fileWriter.length === 0) {
                            var dataObj = new Blob(["_"], { type: 'text/plain' });
                            fileWriter.write(dataObj);
                        } else {
                            console.log("Successful touch file write");
                            if (cb && !cbCalled) {
                                cbCalled = true;
                                cb();
                            }
                        }
                    };
                    fileWriter.truncate(0);
                }, function (error) {
                    if (cb && !cbCalled) {
                        cbCalled = true;
                        cb();
                    }
                });
            });
        });
    }
    function move(oldName, newName, cb) {
        // Rename file to mark as alerted
        window['requestFileSystem'](LocalFileSystem.PERSISTENT, 0, function (fs) {
            fs.root.getFile(oldName, { create: false, exclusive: false }, function (fileEntry) {
                fs.root.getDirectory('/', { create: false, exclusive: false }, function (directoryEntry) {
                    fileEntry.moveTo(directoryEntry, newName, function () {
                        if (cb) {
                            cb();
                        }
                    }, function () {
                        alert("An error occurred");
                    });
                });
            });
        });
    }
    BackupChecker.move = move;
})(BackupChecker || (BackupChecker = {}));
var Cloud;
(function (Cloud) {
    var errorCount = 0;
    var MAX_ERROR_UPLOAD = 50;
    /**
     * Upload a save state object to AWS
     */
    function uploadToCloud(city, cb) {
        if (city.stats.regions || city.stats.isNeighbor) {
            window['pocketCityGame'].regionDownload.uploadRegionToCloud(city, cb);
            return;
        }
        postToCloud(city.getOneOffState(), cb);
    }
    Cloud.uploadToCloud = uploadToCloud;
    function postToCloud(text, cb) {
        // post request to API gateway
        $.post(Global.CLOUD.ENDPOINT, text).done(function (msg) {
            return cb(null, msg);
        }).fail(function (xhr, status, error) {
            return cb(error);
        });
    }
    Cloud.postToCloud = postToCloud;
    /**
     * Load save state from AWS
     * @param code - {string}
     * @param cb - returns {object}
     */
    function downloadFromCloud(code, cb) {
        // get request from API gateway
        $.get(Global.CLOUD.ENDPOINT + "?id=" + code).done(function (msg) {
            return cb(null, msg);
        }).fail(function (xhr, status, error) {
            return cb(error);
        });
    }
    Cloud.downloadFromCloud = downloadFromCloud;
    function uploadError(errorStr, cb) {
        if (errorCount > MAX_ERROR_UPLOAD) {
            if (cb) {
                cb("max error count reached, latest err:" + errorStr);
            }
            return;
        }
        errorCount += 1;
        // post request to API gateway
        $.post(Global.CLOUD.ERROR_ENDPOINT, errorStr).done(function (msg) {
            if (cb) {
                cb(null, msg);
            }
        }).fail(function (xhr, status, error) {
            if (cb) {
                cb(error);
            }
        });
    }
    Cloud.uploadError = uploadError;
})(Cloud || (Cloud = {}));
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Loads cities into memory and pushes updates to in memory model
 *
 * At the same time, also write data to file system whenever data changes
 *
 * Files:
 *  - pocket_city.save is main metadata for all cities
 *  - pocket_city_user.save contains user settings applied globally
 *  - pocket_city_s_{UID}.save contains the save file for an individual city, where {UID is a unique timestamp}
 */
var FileStorage = /** @class */function (_super) {
    __extends(FileStorage, _super);
    function FileStorage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isSavingMetadataMain = false;
        _this.isSavingUserSettings = false;
        _this.isSavingCity = false;
        _this._wantSaveUserSettings = false;
        _this._wantSaveCity = [];
        _this._wantCitiesCacheFlush = [];
        _this.cityFileEntries = {}; // cities by UID
        // especially useful for metadata
        _this.cityByUIDCache = {};
        return _this;
    }
    FileStorage.prototype.getFileSystemEnum = function () {
        // this is a function so that if we ever want to test this, we can subclass it with a different type of file system for testing
        return LocalFileSystem.PERSISTENT;
    };
    FileStorage.prototype.loadData = function (cb) {
        console.log("File storage load data");
        if (window['cordovaReady']) {
            console.log("cordova ready");
            this.init(cb);
        } else {
            console.log("cordova not ready yet");
            var self_1 = this;
            $(document).ready(function () {
                console.log("adding listener for device ready");
                document.addEventListener("deviceready", function () {
                    console.log("caught deviceready");
                    self_1.init(cb);
                }, false);
            });
        }
    };
    FileStorage.prototype.init = function (onReady) {
        var _this = this;
        var done = function done() {
            BackupChecker.checkForUnlinkedBackups(_this);
            onReady();
        };
        this.cordovaFileStore = cordova.file.dataDirectory;
        // Attempt to create our file blob
        // LocalFileSystem will be available when cordova is ready
        this.getFileEntry(FileStorage.FILE_NAME, function (fileEntry) {
            _this.fileEntry = fileEntry;
            if (fileEntry.isFile) {
                _this.readCityFileIntoCache(done);
            } else {
                _this.initializeDefaultCityCache();
                done();
            }
        });
        // Forever interval checking if pending saves need to be flushed
        setInterval(function () {
            _this._flushWantToSaveAgain();
        }, 1000);
    };
    FileStorage.prototype.getFileEntry = function (fileName, cb) {
        window['requestFileSystem'](this.getFileSystemEnum(), 0, function (fs) {
            fs.root.getFile(fileName, { create: true, exclusive: false }, cb);
        });
    };
    FileStorage.prototype.getCityUIDByIndex = function (index) {
        return this.citiesCache[index];
    };
    FileStorage.prototype.getCityIndexByUID = function (uid) {
        for (var index in this.citiesCache) {
            if (this.citiesCache.hasOwnProperty(index) && this.citiesCache[index] === uid) {
                return Number(index);
            }
        }
        return -1;
    };
    //
    // Multi city support
    //
    FileStorage.prototype._convertSingleFileToMultiFile = function (rawSave, cb) {
        var _this = this;
        console.log("raw multi file save" + rawSave);
        var saveObj = {};
        try {
            saveObj = FileStorage.parseJSONUntilSuccess(rawSave);
        } catch (e) {
            console.error("Failed to parse raw save file, uploading log");
            console.error(rawSave);
            saveObj = {};
        }
        var numNeedUpdate = 0;
        var numCompleted = 0;
        var needUpdates = [];
        // Look at cities in save file - if any are very long, they are probably legacy files, and need to be converted
        Object.keys(saveObj).forEach(function (k) {
            var saveVal = saveObj[k];
            if (saveVal.length > 70) {
                // most likely is a serialized object, not a uid
                numNeedUpdate += 1;
                var uid = FileStorage._generateCityIDCheckExisting(saveObj);
                saveObj[k] = uid;
                needUpdates.push([uid, saveVal]);
            } else {
                // is already a UID, good to go
            }
        });
        needUpdates.forEach(function (tuple) {
            var uid = tuple[0],
                saveVal = tuple[1];
            _this.saveCompressedCityFile(uid, saveVal, function () {
                saveCityHandler();
            });
        });
        // all good already - return immediately
        if (numNeedUpdate === 0) {
            cb(saveObj);
            return;
        }
        function saveCityHandler() {
            numCompleted += 1;
            if (numNeedUpdate === numCompleted) {
                cb(saveObj);
            }
        }
    };
    FileStorage._generateCityIDCheckExisting = function (existingCitiesCache) {
        var newId = FileStorage._generateCityID();
        while (existingCitiesCache[newId]) {
            newId = FileStorage._generateCityID();
        }
        return newId;
    };
    FileStorage._generateCityID = function () {
        var text = "";
        var possible = FileStorage.RANDOM_CHARS;
        for (var i = 0; i < 15; i++) {
            text += possible.charAt(Math.floor(Math.random() * possible.length));
        }return text;
    };
    FileStorage.getCityFileNameById = function (uid) {
        return FileStorage.FILE_NAME_CITY_PREFIX + uid + '.save';
    };
    // Loop and attempt to parse json from each starting position until it finally works
    FileStorage.parseJSONUntilSuccess = function (jsonStr) {
        var parsed = null;
        while (parsed === null && jsonStr.length > 0) {
            try {
                parsed = JSON.parse(jsonStr);
                if (parsed === null) {
                    throw Error("null parsed");
                }
            } catch (e) {
                jsonStr = jsonStr.substr(1);
                while (jsonStr.length && jsonStr.substr(0, 1) !== "{") {
                    jsonStr = jsonStr.substr(1);
                }
            }
        }
        if (!parsed) {
            throw new Error("could not parse: " + jsonStr);
        }
        return parsed;
    };
    /** Calls back with city file entry, using cache if available */
    FileStorage.prototype.getCityFileEntry = function (uid, cb) {
        var _this = this;
        if (this.cityFileEntries[uid]) {
            // set timeout just to preserve async-ness nature of this function
            setTimeout(function () {
                cb(_this.cityFileEntries[uid]);
            }, 0);
        } else {
            this.getFileEntry(FileStorage.getCityFileNameById(uid), function (fileEntry) {
                _this.cityFileEntries[uid] = fileEntry;
                cb(fileEntry);
            });
        }
    };
    FileStorage.prototype.onMoveCityIndex = function (oldIndex, newIndex) {
        // there might be queued saves, which need their indices updated
        for (var i = 0; i < this._wantSaveCity.length; i++) {
            if (this._wantSaveCity[i][0] === oldIndex) {
                this._wantSaveCity[i][0] = newIndex;
            }
        }
    };
    /** Save override, write city string into city-specific file */
    // returns cb() too early if save hasn't flushed yet...
    FileStorage.prototype.saveCity = function (index, serialized, cb) {
        var _this = this;
        if (this.isSavingCity) {
            var foundExisting = false;
            for (var i = 0; i < this._wantSaveCity.length; i++) {
                if (this._wantSaveCity[i][0] === index) {
                    this._wantSaveCity[i][1] = serialized;
                    if (cb) {
                        this._wantSaveCity[i][2].push(cb);
                    }
                    foundExisting = true;
                }
            }
            if (!foundExisting) {
                // not currently pending to save this city, push it as a new tuple to pending list, including cb
                var cbsArr = [];
                if (cb) {
                    cbsArr.push(cb);
                }
                this._wantSaveCity.push([index, serialized, cbsArr]);
            }
            return;
        }
        StorageCheckerProcess.setLastIsSavingCityTrue();
        this.isSavingCity = true;
        var uid = this.citiesCache[index];
        if (!uid) {
            uid = FileStorage._generateCityIDCheckExisting(this.citiesCache);
            this.citiesCache[index] = uid;
        }
        this.cityByUIDCache[uid] = serialized; // update cache
        GridSerializer.compressSaveCityAsync(serialized, function (compressed) {
            // save the specific city file
            _this.saveCompressedCityFile(uid, compressed, function () {
                StorageCheckerProcess.setLastIsSavingCityFalse();
                _this.isSavingCity = false;
                // save the metadata file uid pointers
                _this.writeCitiesCacheMetadataIntoFile(function () {
                    if (cb) {
                        cb();
                    }
                });
            });
        });
    };
    /** Call back with the decompressed city */
    FileStorage.prototype.getCity = function (index, cb) {
        var _this = this;
        var self = this;
        var uid = this.citiesCache[index];
        if (this.cityByUIDCache[uid]) {
            cb(this.cityByUIDCache[uid]);
            return;
        }
        console.log("getting city");
        var executeFileLoad = function executeFileLoad() {
            _this.getCityFileEntry(uid, function (fileEntry) {
                //
                // helpers
                //
                var loadBackup = function loadBackup() {
                    console.log("loading backup!");
                    _this.getFileEntry(fileEntry.name + ".backup", function (bkFileEntry) {
                        _this._readGenericFile(bkFileEntry, function (result) {
                            // found the backup!
                            console.log("done loading backup");
                            processResult(result);
                        }, function () {
                            console.log("no backup return empty string");
                            processResult(""); // no backup oh no!
                        }, FileStorage.noOp); // just signals when everything is done, no op
                    });
                };
                function processResult(compressedStr) {
                    GridSerializer.decompressSaveCityAsync(compressedStr, function (decompressed) {
                        _processDecompressedResult(decompressed);
                    });
                }
                function _processDecompressedResult(decompressed) {
                    self.cityByUIDCache[uid] = decompressed;
                    cb(decompressed);
                }
                // Begin ASYNC read
                console.log("read generic file get city", fileEntry.name);
                _this._readGenericFile(fileEntry, function (compressed) {
                    if (!compressed) {
                        // empty file
                        loadBackup();
                    } else {
                        // see if compressedStr is valid
                        GridSerializer.decompressSaveCityAsync(compressed, function (decompressed) {
                            if (_this.isValidFileContent(decompressed)) {
                                console.log("decompress result good");
                                _processDecompressedResult(decompressed);
                            } else {
                                console.error("decompress result bad, will load backup instead. compressed:" + compressed);
                                loadBackup();
                            }
                        });
                    }
                }, function () {
                    console.log("no city, check backup");
                    // no city to get! oh no check backup
                    loadBackup();
                }, FileStorage.noOp); // just signals when everything is done, no op
            });
        };
        if (this.initialCityCount == -1) {
            console.log("execute file load");
            executeFileLoad();
        } else {
            if (this.initialCityCount <= FileStorage.MAX_READ_SIMULT) {
                this.initialCityCount += 1;
                console.log("immediate execute index:" + index);
                executeFileLoad();
            } else {
                this.initialCityCount += 1;
                var interval = Math.floor(this.initialCityCount / FileStorage.MAX_READ_SIMULT);
                //console.log("defer execute index:"+index+" by "+(interval * 200));
                setTimeout(executeFileLoad, interval * 200);
            }
        }
    };
    /** Delete the save file at index */
    FileStorage.prototype.citiesCachePreDeleted = function (index, cb) {
        // delete the save file at index, cache indices will be shifted in base class
        var uid = this.citiesCache[index];
        delete this.cityByUIDCache[uid]; // free up memory
        this.getCityFileEntry(uid, function (fileEntry) {
            fileEntry.remove(cb);
        });
    };
    FileStorage.prototype.citiesCachePostDeleted = function (index, cb) {
        // update metadata after deleting
        this.writeCitiesCacheMetadataIntoFile(cb);
        // delete from pending saves
        var pendingSave = -1;
        for (var i = 0; i < this._wantSaveCity.length; i++) {
            if (this._wantSaveCity[i][0] === index) {
                pendingSave = i;
            }
        }
        if (pendingSave !== -1) {
            this._wantSaveCity.splice(pendingSave, 1);
        }
    };
    /** Save the compressed city into a file */
    FileStorage.prototype.saveCompressedCityFile = function (uid, compressed, cb) {
        var _this = this;
        var cbCalled = false;
        function callCb(e) {
            if (!cb || cbCalled) return;
            cbCalled = true;
            cb(e);
        }
        this.getCityFileEntry(uid, function (fileEntry) {
            var disableBackupSave = false;
            if (window['CORRUPT_DUPLICATE_CITY']) {
                compressed = compressed + compressed;
                disableBackupSave = true;
            } else if (window['CORRUPT_HALF_CITY']) {
                compressed = compressed.substr(0, Math.round(compressed.length * 0.5));
                disableBackupSave = true;
            } else if (window['CORRUPT_EMPTY_CITY']) {
                compressed = "";
                disableBackupSave = true;
            } else if (window['TRUNCATE_EMPTY_CITY']) {
                fileEntry.createWriter(function (fileWriter) {
                    fileWriter.onerror = function (e) {
                        console.log("Failed file write: " + e.toString());
                        if (cb) {
                            callCb(e.toString());
                        }
                    };
                    fileWriter.onwriteend = function () {
                        callCb();
                    };
                    fileWriter.truncate(0);
                }, function (error) {
                    callCb("error when creating writer 2");
                });
                return;
            }
            _this._writeStringIntoFile(fileEntry, compressed, cb, disableBackupSave);
        });
    };
    //
    // User settings I/O
    //
    FileStorage.prototype.loadUserSettings = function (cb) {
        var _this = this;
        this.cordovaFileStore = cordova.file.dataDirectory;
        // Attempt to create our file blob
        // LocalFileSystem will be available when cordova is ready
        this.getFileEntry(FileStorage.FILE_NAME_USER_SETTINGS, function (fileEntry) {
            _this.fileEntryUserSettings = fileEntry;
            if (fileEntry.isFile) {
                _this.readUserSettingsFileIntoCache(cb);
            } else {
                _this.initializeDefaultUserSettingscache();
                cb();
            }
        });
    };
    ;
    /** Call save function to flush pending user settings and city file */
    FileStorage.prototype._flushWantToSaveAgain = function () {
        var _this = this;
        if (this._wantSaveUserSettings) {
            this._wantSaveUserSettings = false;
            this.saveUserSettings(function () {
                console.log("flushed pending user settings save");
            });
        }
        if (this._wantCitiesCacheFlush.length) {
            console.log("flush - saving citiescache to file");
            this.writeCitiesCacheMetadataIntoFile(function () {
                _this._wantCitiesCacheFlush.forEach(function (cb) {
                    if (cb) {
                        cb();
                    }
                });
                _this._wantCitiesCacheFlush = [];
            });
        }
        if (this._wantSaveCity.length) {
            var tuple = this._wantSaveCity.pop();
            var index = tuple[0],
                serialized = tuple[1],
                cbs_1 = tuple[2];
            this.saveCity(index, serialized, function () {
                cbs_1.forEach(function (cb) {
                    if (cb) {
                        cb();
                    }
                });
            });
        }
    };
    /** Returns true if conflict */
    FileStorage.prototype.saveUserSettings = function (cb) {
        var _this = this;
        if (this.isSavingUserSettings) {
            this._wantSaveUserSettings = true;
            if (cb) {
                cb();
            }
            return;
        }
        this.isSavingUserSettings = true;
        this.writeUserSettingsCacheIntoFile(function () {
            _this.isSavingUserSettings = false;
        });
    };
    FileStorage.prototype.initializeDefaultUserSettingscache = function () {
        this.userSettingsCache = {};
    };
    FileStorage.prototype.readUserSettingsFileIntoCache = function (cb) {
        var _this = this;
        this._readGenericFile(this.fileEntryUserSettings, function (result) {
            try {
                _this.userSettingsCache = FileStorage.parseJSONUntilSuccess(result);
            } catch (e) {
                console.error("failed to read user settings:" + result);
                _this.initializeDefaultUserSettingscache();
            }
        }, function () {
            _this.initializeDefaultUserSettingscache();
        }, cb);
    };
    FileStorage.prototype.writeUserSettingsCacheIntoFile = function (cb) {
        this._writeCacheIntoFileGeneric(this.fileEntryUserSettings, this.userSettingsCache, cb);
    };
    //
    // Cities metadata Save
    //
    FileStorage.prototype.initializeDefaultCityCache = function () {
        this.citiesCache = {};
    };
    FileStorage.prototype.isValidFileContent = function (fileString) {
        if (!fileString) {
            return false;
        }
        try {
            JSON.parse(fileString);
            return true;
        } catch (e) {
            return false;
        }
    };
    /** Updates citiesCache by reading file */
    FileStorage.prototype.readCityFileIntoCache = function (cb) {
        var _this = this;
        var self = this;
        function processResult(result) {
            self._convertSingleFileToMultiFile(result, function (multiFileCache) {
                console.log("done convert single file if any");
                self.citiesCache = multiFileCache;
                cb();
            });
        }
        function loadMetadataBackup(cbIfNotFound) {
            console.log("load metadata backup");
            // Look for backup
            self.getFileEntry(self.fileEntry.name + ".backup", function (bkFileEntry) {
                console.log("load city backup file into cache");
                self._readGenericFile(bkFileEntry, function (result) {
                    console.log("backup1");
                    // found the backup!
                    processResult(result);
                }, function () {
                    // no backup found
                    console.log("backup2");
                    self.initializeDefaultCityCache();
                    cb();
                }, FileStorage.noOp); // just signals when everything is done, no op
            });
        }
        console.log("load city file into cache");
        this._readGenericFile(this.fileEntry, function (result) {
            if (result) {
                if (_this.isValidFileContent(result)) {
                    // Is valid, use this as the file data
                    processResult(result);
                } else {
                    // empty or partial json
                    loadMetadataBackup();
                }
            } else {
                // empty save file (should never propogate to here actually)
                loadMetadataBackup();
            }
        }, function () {
            loadMetadataBackup();
        }, FileStorage.noOp); // no op, wait for success or no result
    };
    /** Write the citiesCache with UID pointers into file */
    FileStorage.prototype.writeCitiesCacheMetadataIntoFile = function (cb) {
        var _this = this;
        if (this.isSavingMetadataMain) {
            this._wantCitiesCacheFlush.push(cb);
            return; // just return here, this happens enough that it shouldnt be an issue if the main metadata file skips a save?
        }
        this.isSavingMetadataMain = true;
        console.log("writing cities cache into file");
        this._writeCacheIntoFileGeneric(this.fileEntry, this.citiesCache, function () {
            _this.isSavingMetadataMain = false;
            if (cb) {
                cb();
            }
        });
    };
    //
    // Generic IO
    //
    FileStorage.prototype._readGenericFile = function (fileEntry, onReadResult, onNoResultCb, cb) {
        console.log("loading ", fileEntry.name);
        var self = this;
        fileEntry.file(function (file) {
            var reader = new FileReader();
            reader.onloadend = function () {
                //console.log("Read file complete, contents length:",String(this.result).length,fileEntry.name);
                if (this.result) {
                    console.log("existing data found - loading existing JSON");
                    onReadResult(this.result);
                    cb();
                } else {
                    console.log("no existing data - calling onNoresultCb");
                    onNoResultCb();
                    cb();
                }
            };
            reader.onerror = function (e) {
                console.error("Read file failed: " + e);
                console.info("WARN: initializing calling noresult instead");
                onNoResultCb();
                cb();
            };
            reader.readAsText(file);
        }, function (e) {
            console.error(e);
            console.log("WARN: an error occured when reading the file - calling not found cb");
            onNoResultCb();
            cb();
        });
    };
    FileStorage.prototype._writeBackup = function (originalFileEntry, stringData, cb) {
        if (!stringData) {
            console.log("no data to write continuing");
            // No data - not modifying backup
            cb(true);
            return;
        }
        var backupName = originalFileEntry.name + ".backup";
        var self = this;
        var cbCalled = false;
        function callCb(success) {
            if (!cb || cbCalled) return;
            cbCalled = true;
            cb(success);
        }
        this.getFileEntry(backupName, function (fileEntry) {
            fileEntry.createWriter(function (fileWriter) {
                fileWriter.onerror = function (e) {
                    console.log("Failed file write: " + e.toString());
                    console.error("Failed to write backup file:" + backupName);
                    callCb(false);
                };
                fileWriter.onwriteend = function () {
                    if (fileWriter.length === 0) {
                        var dataObj = new Blob([stringData], { type: 'text/plain' });
                        fileWriter.write(dataObj);
                    } else {
                        //file has been overwritten with blob
                        //use callback or resolve promise
                        console.log("Successful backup file write");
                        callCb(true);
                    }
                };
                fileWriter.truncate(0);
            }, function (error) {
                callCb(false);
            });
        });
    };
    FileStorage.prototype._writeCacheIntoFileGeneric = function (fileEntry, obj, cb, attempts) {
        if (attempts === void 0) {
            attempts = 3;
        }
        var self = this;
        var strObj = JSON.stringify(obj);
        var cbCalled = false;
        this._writeBackup(fileEntry, strObj, function (successful) {
            if (!successful) {
                // call cb if backup unsuccessful and return
                if (cb && !cbCalled) {
                    cbCalled = true;
                    console.error("writing backup failed generic - responding with unsuccess value.");
                    cb("failed to write backup");
                }
                return;
            }
            //
            // start executing save
            //
            function callCb(e) {
                if (!cb || cbCalled) return;
                cbCalled = true;
                cb(e);
            }
            // retry if attempts remaining, otherwise cb with error
            function retryOrCallbackErr(e) {
                console.warn("retrying writing");
                if (attempts > 0) {
                    self._writeCacheIntoFileGeneric(fileEntry, obj, cb, attempts - 1);
                    return true;
                } else {
                    console.error("Failed to write city file after repeated attempts: " + fileEntry.name);
                    callCb(e.toString());
                    return false;
                }
            }
            // Create a FileWriter object for our FileEntry (log.txt).
            fileEntry.createWriter(function (fileWriter) {
                fileWriter.onerror = function (e) {
                    console.log("Failed file write: " + e.toString());
                    retryOrCallbackErr(e);
                };
                fileWriter.onwriteend = function () {
                    if (fileWriter.length === 0) {
                        //fileWriter has been reset, write file
                        var str = strObj;
                        if (window['CORRUPT_DUPLICATE_METADATA']) {
                            str = str + str;
                        } else if (window['CORRUPT_HALF_METADATA']) {
                            str = str.substr(0, Math.round(str.length * 0.5));
                        } else if (window['CORRUPT_EMPTY_METADATA']) {
                            str = "";
                        } else if (window['TRUNCATE_EMPTY_METADATA']) {
                            callCb();
                            return; // write nothing
                        }
                        var dataObj = new Blob([str], { type: 'text/plain' });
                        fileWriter.write(dataObj);
                    } else {
                        //file has been overwritten with blob
                        //use callback or resolve promise
                        console.log("Successful file write...");
                        callCb();
                    }
                };
                fileWriter.truncate(0);
            }, function (error) {
                callCb("error when creating writer 3");
            });
        });
    };
    FileStorage.prototype._writeStringIntoFile = function (fileEntry, rawStr, cb, disableBackup) {
        var _this = this;
        var cbCalled = false;
        if (disableBackup) {
            this._writeAfterBackup(fileEntry, rawStr, cb);
        } else {
            this._writeBackup(fileEntry, rawStr, function (successful) {
                if (!successful) {
                    // call cb if backup unsuccessful and return
                    if (!cbCalled) {
                        console.error("writing backup failed - responding with unsuccess value.");
                        cb("Backup failed");
                    }
                    cbCalled = true;
                    return;
                }
                if (!cbCalled) {
                    _this._writeAfterBackup(fileEntry, rawStr, cb);
                }
            });
        }
    };
    FileStorage.prototype._writeAfterBackup = function (fileEntry, rawStr, cb) {
        // Create a FileWriter object for our FileEntry (log.txt).
        var cbCalled = false;
        fileEntry.createWriter(function (fileWriter) {
            fileWriter.onerror = function (e) {
                console.log("Failed post-backup file write: " + e.toString());
                if (cb && !cbCalled) {
                    cbCalled = true;
                    cb(e.toString());
                }
            };
            fileWriter.onwriteend = function () {
                if (fileWriter.length === 0) {
                    //fileWriter has been reset, write file
                    var dataObj = new Blob([rawStr], { type: 'text/plain' });
                    fileWriter.write(dataObj);
                } else {
                    //file has been overwritten with blob
                    //use callback or resolve promise
                    console.log("Successful file write...");
                    if (cb && !cbCalled) {
                        cbCalled = true;
                        cb();
                    }
                }
            };
            fileWriter.truncate(0);
        }, function (error) {
            if (cb && !cbCalled) {
                cbCalled = true;
                cb("error when creating writer 1");
            }
        });
    };
    //
    // Possible corruptions
    //
    // GOOD this is ok
    FileStorage.prototype._saveSimultaneous = function () {
        alert("Saving simultaneously");
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // FIX: doens't stall on next open, uses backup
    // BAD causes stalled loading todo
    // DO NOT TRUNCATE UNTIL A BACKUP FILE HAS BEEN CREATED
    FileStorage.prototype._corruptEmptyCity = function () {
        alert("Saving empty city");
        window['CORRUPT_EMPTY_CITY'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // FIX: doens't stall on next open, uses backup
    // BAD causes stalled loading todo
    // DO NOT TRUNCATE UNTIL A BACKUP FILE HAS BEEN CREATED
    FileStorage.prototype._corruptTruncateCity = function () {
        alert("truncating empty");
        window['TRUNCATE_EMPTY_CITY'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // FIXED BEHAVIOUR - Resets to base city and can't open setting or else parse error
    FileStorage.prototype._corruptHalfCity = function () {
        alert("Saving half city");
        window['CORRUPT_HALF_CITY'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // GOOD this is OK
    FileStorage.prototype._corruptDuplicateCity = function () {
        alert("Saving duplicate city");
        window['CORRUPT_DUPLICATE_CITY'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // FIX clears everything
    FileStorage.prototype._corruptEmptyMetadata = function () {
        alert("Saving empty metadata");
        window['CORRUPT_EMPTY_METADATA'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // FIX clears everything
    FileStorage.prototype._corruptTruncateMetadata = function () {
        alert("Saving empty metadata");
        window['TRUNCATE_EMPTY_METADATA'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // FIX everything
    FileStorage.prototype._corruptHalfMetadata = function () {
        alert("Saving half metadata");
        window['CORRUPT_HALF_METADATA'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    // GOOD this is ok
    FileStorage.prototype._corruptDuplicateMetadata = function () {
        alert("Saving duplicate metadata");
        window['CORRUPT_DUPLICATE_METADATA'] = true;
        window['pocketCityGame'].activeCity.gameplayUI.pocketCity.save();
    };
    FileStorage.FILE_NAME = "pocket_city.save";
    FileStorage.FILE_NAME_USER_SETTINGS = "pocket_city_user.save";
    FileStorage.FILE_NAME_CITY_PREFIX = "pocket_city_s_";
    FileStorage.noOp = function () {};
    FileStorage.RANDOM_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    FileStorage.MAX_READ_SIMULT = 10;
    return FileStorage;
}(PCStorage);
var FileLocalStorage = /** @class */function (_super) {
    __extends(FileLocalStorage, _super);
    function FileLocalStorage() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FileLocalStorage.prototype.getFileSystemEnum = function () {
        // this is a function so that if we ever want to test this, we can subclass it with a different type of file system for testing
        return window['TEMPORARY'];
    };
    return FileLocalStorage;
}(FileStorage);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var MemoryStorage = /** @class */function (_super) {
    __extends(MemoryStorage, _super);
    function MemoryStorage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._originalCitiesCache = {
            // this one is legacy storage type w/o regions, income, etc
            0: '{"AS":[{"timestamp":1573610738578,"metadata":{"name":"Pocket City","creationDate":1510807844702,"elapsedTime":787064,"size":54,"isSandbox":false,"fastTerrain":false,"sandboxWithMoney":false},"stats":{"money":4551000,"population":692,"finishedTutorial":true,"internalVersion":0,"numTiles":164,"regions":[^8~""],"policies":[],"income":352,"regionType":0,"isNeighbor":false,"unlocks":[[null,null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null,null]],"activeQuests":[74,62,67,70,61,77,76,39,12,73,68,45,37,36,52,38,65,51,30,1,59,58,32,14,10,50,34,33,75,7,49,42,13,11],"newQuests":[74,62,67,70,61,77,76,39,12,73,68,45,37,36,52,38,65,51,30,1,59,58,32,14,10,50,34,33,75,7,49,42,13,11],"completedQuests":[],"archivedQuests":[],"unlockedEventsIds":[],"metricModifiers":{},"level":100,"pendingRewardLevels":0,"exp":6612,"globalSettings":{"cus-ter":{"grass":["788","789","842","843"],"mountain":[],"mountain-sm":[],"water":[],"sand":[],"lava":[],"forest":[],"palm":[],"palm_sand":[],"soil":[]},"next_dstr":317145,"taxes":{"sales":1,"income":1.4,"property":1},"thunlocks":{"th-2":1,"th-10":1},"msg-about-zone-upgrade":1,"COOLDOWNS":{},"D_REPORTS":[]}},"grids":[[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^33~"64",^19~""],[^19~"*c1x1-a","R",^11~"R",^20~""],[^18~"*c1x2-a","*c1x1-b","R",^1~"6",^8~"R","R",^20~""],[^15~"r1x1-c","*r1x1-b","*r1x1-a",^2~"R",^1~"*r2x1-a",^8~"R",^21~""],[^12~"3","1","10",^2~"*r2x1-a",^1~"8","R","*r1x1-a",^8~"25","R",^21~""],[^12~"R","R","R","R","R","R","R","R","R","*r1x1-c","*r1x2-a",^8~"R",^21~""],[^13~"*c2x1-a",^1~"*c1x1-c","*c1x1-e","*c1x1-d",^2~"R",^9~"52","R",^21~""],[^12~"*c1x1-a","*c1x1-b","*c1x2-b",^1~"*c2x1-a","*c1x1-c",^1~"17","R",^1~"15",^1~"31",^6~"R",^21~""],[^15~"*c1x1-d","*c1x1-e","*c1x1-a","22","R","R","R","R","R","R",^6~"R",^21~""],[^12~"*c1x2-a",^1~"*c2x2-a","*c1x1-b",^1~"*c2x1-a","9","R","*i1x1-b",^1~"*i1x1-a","*i1x1-b","R",^1~"4",^3~"69","R",^21~""],[^12~"R","R","R","R","R","R","R","R","*i1x1-a","*i1x2-a",^1~"*i2x1-a","R","R","R","R","R","R","R","R",^21~""],[^12~"R",^1~"*r1x1-b",^1~"*r2x1-a",^2~"R","R","R","R","R","R",^28~""],[^12~"R","*r1x2-a","*r1x1-a","*r1x1-c","*r1x1-b",^1~"*r2x2-a",^5~"R",^28~""],[^12~"R","R","R","R","R","R","R",^1~"5",^1~"63","r1x2-b","R",^28~""],[^12~"R","r1x1-c",^1~"r2x1-a","r1x1-b","r1x1-a","r1x1-b",^1~"r1x1-a","r1x1-b","r1x1-c","r1x1-b","R",^28~""],[^12~"R",^1~"r2x1-b","r1x1-a","r1x1-c","r1x1-b","r1x1-a","r1x2-a","r1x1-c","r1x1-a",^1~"r2x1-a","R",^28~""],[^12~"R","R","R","R","R","R","R","R","R","R","R","R","R","R",^1~"2",^25~""],[^53~""],[^15~"42",^1~"45",^2~"68",^1~"34",^1~"41",^1~"49",^26~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""]]}],"MS":[{"timestamp":1573610752975,"metadata":{"name":"Pocket City","creationDate":1510807844702,"elapsedTime":789010,"size":54,"isSandbox":false,"fastTerrain":false,"sandboxWithMoney":false},"stats":{"money":4551000,"population":696,"finishedTutorial":true,"internalVersion":0,"numTiles":164,"regions":[^8~""],"policies":[],"income":359,"regionType":0,"isNeighbor":false,"unlocks":[[null,null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,1,1,1,1,null,null,null],[null,null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null,null],[null,null,null,null,null,null,null,null,null]],"activeQuests":[74,62,67,70,61,77,76,39,12,73,68,45,37,36,52,38,65,51,30,1,59,58,32,14,10,50,34,33,75,7,49,42,13,11],"newQuests":[74,62,67,70,61,77,76,39,12,73,68,45,37,36,52,38,65,51,30,1,59,58,32,14,10,50,34,33,75,7,49,42,13,11],"completedQuests":[],"archivedQuests":[],"unlockedEventsIds":[],"metricModifiers":{},"level":100,"pendingRewardLevels":0,"exp":6612,"globalSettings":{"cus-ter":{"grass":["788","789","842","843"],"mountain":[],"mountain-sm":[],"water":[],"sand":[],"lava":[],"forest":[],"palm":[],"palm_sand":[],"soil":[]},"next_dstr":317145,"taxes":{"sales":1,"income":1.4,"property":1},"thunlocks":{"th-2":1,"th-10":1},"msg-about-zone-upgrade":1,"COOLDOWNS":{},"D_REPORTS":[]}},"grids":[[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^33~"64",^19~""],[^19~"*c1x1-a","R",^11~"R",^20~""],[^18~"*c1x2-a","*c1x1-b","R",^1~"6",^8~"R","R",^20~""],[^15~"r1x1-c","*r1x1-b","*r1x1-a",^2~"R",^1~"*r2x1-a",^8~"R",^21~""],[^12~"3","1","10",^2~"*r2x1-a",^1~"8","R","*r1x1-a",^8~"25","R",^21~""],[^12~"R","R","R","R","R","R","R","R","R","*r1x1-c","*r1x2-a",^8~"R",^21~""],[^13~"*c2x1-a",^1~"*c1x1-c","*c1x1-e","*c1x1-d",^2~"R",^9~"52","R",^21~""],[^12~"*c1x1-a","*c1x1-b","*c1x2-b",^1~"*c2x1-a","*c1x1-c",^1~"17","R",^1~"15",^1~"31",^6~"R",^21~""],[^15~"*c1x1-d","*c1x1-e","*c1x1-a","22","R","R","R","R","R","R",^6~"R",^21~""],[^12~"*c1x2-a",^1~"*c2x2-a","*c1x1-b",^1~"*c2x1-a","9","R","*i1x1-b",^1~"*i1x1-a","*i1x1-b","R",^1~"4",^3~"69","R",^21~""],[^12~"R","R","R","R","R","R","R","R","*i1x1-a","*i1x2-a",^1~"*i2x1-a","R","R","R","R","R","R","R","R",^21~""],[^12~"R",^1~"*r1x1-b",^1~"*r2x1-a",^2~"R","R","R","R","R","R",^28~""],[^12~"R","*r1x2-a","*r1x1-a","*r1x1-c","*r1x1-b",^1~"*r2x2-a",^5~"R",^28~""],[^12~"R","R","R","R","R","R","R",^1~"5",^1~"63","r1x2-b","R",^28~""],[^12~"R","r1x1-c",^1~"r2x1-a","r1x1-b","r1x1-a","r1x1-b",^1~"r1x1-a","r1x1-b","r1x1-c","r1x1-b","R",^28~""],[^12~"R",^1~"r2x1-b","r1x1-a","r1x1-c","r1x1-b","r1x1-a","r1x2-a","r1x1-c","r1x1-a",^1~"r2x1-a","R",^28~""],[^12~"R","R","R","R","R","R","R","R","R","R","R","R","R","R",^1~"2",^25~""],[^53~""],[^15~"42",^1~"45",^2~"68",^1~"34",^1~"41",^1~"49",^26~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""],[^53~""]]}]}'
        };
        return _this;
    }
    MemoryStorage.prototype.loadUserSettings = function (cb) {
        var _this = this;
        // mock load
        setTimeout(function () {
            _this.userSettingsCache = window['mem_user_settings'] || {};
            if (cb) {
                cb();
            }
        }, 0);
    };
    ;
    MemoryStorage.prototype.getCityUIDByIndex = function (index) {
        return "memoryid-local-" + index;
    };
    MemoryStorage.prototype.getCityIndexByUID = function (uid) {
        return Number(uid.split("-local-")[1]);
    };
    MemoryStorage.prototype.saveUserSettings = function (cb) {
        setTimeout(function () {
            if (cb) {
                cb();
            }
        }, 0);
    };
    MemoryStorage.prototype.saveCity = function (index, serialized, cb) {
        var _this = this;
        if (window['testMode']) {
            setTimeout(function () {
                if (cb) {
                    cb();
                }
            }, 200);
            return;
        }
        GridSerializer.compressSaveCityAsync(serialized, function (compressed) {
            _this.citiesCache[index] = compressed;
            if (cb) {
                cb();
            }
        });
    };
    MemoryStorage.prototype.getCity = function (index, cb) {
        GridSerializer.decompressSaveCityAsync(this.citiesCache[index], function (str) {
            // simulate longer time
            if (window['longGetCity']) {
                console.log("long get city:", window['longGetCity']);
                setTimeout(function () {
                    cb(str);
                }, window['longGetCity']);
            } else {
                cb(str);
            }
        });
    };
    MemoryStorage.prototype.loadData = function (cb) {
        var _this = this;
        // Mock load
        setTimeout(function () {
            _this.citiesCache = _this._originalCitiesCache;
            // this clears it to Start Story (fresh game)
            //this.citiesCache = {};
            // for testing:
            if (window['memoryStorageOverride']) {
                _this.citiesCache = window['memoryStorageOverride'];
            }
            cb();
        }, 3);
    };
    MemoryStorage.prototype._setOriginalCitiesCache = function () {
        this.citiesCache = JSON.parse(JSON.stringify(this._originalCitiesCache));
    };
    MemoryStorage.prototype.citiesCachePreDeleted = function (index, cb) {
        setTimeout(cb, 1000);
    };
    return MemoryStorage;
}(PCStorage);
/**
 * Handles logic for when to autosave and such
 */
var CitySaveHelper = /** @class */function () {
    function CitySaveHelper(city) {
        var _this = this;
        this.lastDelayAutoSaveEvent = "none";
        this.lastAutoSaved = 0;
        this.saveTimeout = null;
        this.city = city;
        this.lastAutoSaved = Date.now();
        // Listen for important events and autosave
        // If many notable things happen in same short time, group together
        this.city.eventSignal.add(function (event) {
            if (_this.city.tutorial.tutorialActive) {
                return; // don't save during tutorial
            }
            if (CitySaveHelper.AUTOSAVE_EVENTS.indexOf(event) !== -1) {
                if (CitySaveHelper.DELAY_SAVE[event]) {
                    _this.saveWithDelay(CitySaveHelper.DELAY_SAVE[event]);
                    _this.lastDelayAutoSaveEvent = event;
                } else {
                    if (event === "finished_tutorial") {
                        _this.autoSave(function () {
                            Region.refreshCacheMetadata(-1, function () {});
                        });
                    } else {
                        _this.autoSave();
                    }
                }
            }
        });
    }
    // User settings
    CitySaveHelper.prototype.setUserSetting = function (key, value, alsoSave) {
        this.city.gameplayUI.pocketCity.storage.updateUserSetting(key, value, null, alsoSave);
    };
    CitySaveHelper.prototype.getUserSetting = function (key, defaultVal) {
        return this.city.gameplayUI.pocketCity.storage.getUserSetting(key, defaultVal);
    };
    CitySaveHelper.prototype.canExtendTimeout = function () {
        return CitySaveHelper.FORCE_PERSIST_DELAY_TIMER[this.lastDelayAutoSaveEvent] !== 1;
    };
    CitySaveHelper.prototype.saveWithDelay = function (delay) {
        var _this = this;
        if (delay === void 0) {
            delay = 1000;
        }
        if (this.saveTimeout) {
            if (!this.canExtendTimeout()) {
                // save already scheduled and shouldn't be overridden
                // console.log("AUTOSAVE: NOT replacing timeout");
                return;
            } else {
                // otherwise extend timeout with new timer
                // console.log("AUTOSAVE: replacing timeout with",delay);
                clearTimeout(this.saveTimeout);
            }
        }
        if (!this._bindAutosave) {
            this._bindAutosave = function () {
                if (_this.city && _this.city.game) {
                    if (_this.city.isBuildingState() && _this.city.game.input && _this.city.game.input.activePointer && _this.city.game.input.activePointer.isDown && _this.canExtendTimeout()) {
                        // extend delay since finger is still interacting in build mode
                        // console.log("AUTOSAVE: Extending due to build mode interaction");
                        clearTimeout(_this.saveTimeout);
                        _this.saveTimeout = null;
                        _this.saveWithDelay(3000);
                    } else {
                        // console.log("AUTOSAVE: Executed");
                        _this.autoSave();
                        _this.saveTimeout = null;
                    }
                } else {
                    _this.saveTimeout = null;
                }
            };
        }
        this.saveTimeout = setTimeout(this._bindAutosave, delay);
        this.nextSaveTime = Date.now() + delay;
    };
    // add 1000ms to current autosave delay
    CitySaveHelper.prototype.extendAnyAutosaveTimer = function (delay) {
        if (delay === void 0) {
            delay = 2000;
        }
        var max = 5000; // maximum save delay time with extensions
        if (this.saveTimeout && this.canExtendTimeout()) {
            var timeLeftCurTimer = this.nextSaveTime - Date.now();
            if (timeLeftCurTimer > max) {
                // console.log("AUTOSAVE: Reached max autosave extension");
                return;
            }
            if (timeLeftCurTimer > 0) {
                // still time left on current timer
                delay += this.nextSaveTime - Date.now();
            }
            delay = Math.min(delay, max);
            this.saveWithDelay(delay);
            // console.log("AUTOSAVE: Extended current autosave timer by ",delay);
        }
    };
    CitySaveHelper.prototype.setGlobalSetting = function (key, val, alsoSave) {
        if (alsoSave === void 0) {
            alsoSave = true;
        }
        this.city.stats.globalSettings[key] = val;
        if (alsoSave) {
            this.autoSave();
        }
    };
    CitySaveHelper.prototype.getGlobalSetting = function (key, defaultVal) {
        if (defaultVal === void 0) {
            defaultVal = null;
        }
        if (this.city.stats.globalSettings.hasOwnProperty(key)) {
            return this.city.stats.globalSettings[key];
        } else {
            return defaultVal;
        }
    };
    //
    // chest unlocks
    //
    CitySaveHelper.prototype.getUnlockedChestBuildings = function () {
        return this.getGlobalSetting(CitySaveHelper.UNLOCK_CHEST_KEY, {});
    };
    CitySaveHelper.prototype.isUnlockedChestBuilding = function (sheet) {
        return this.getUnlockedChestBuildings()[sheet];
    };
    CitySaveHelper.prototype.setAndSaveUnlockedChestBuilding = function (sheet) {
        var s = this.getUnlockedChestBuildings();
        s[sheet] = 1;
        this.setGlobalSetting(CitySaveHelper.UNLOCK_CHEST_KEY, s, true);
    };
    // disaster toggle
    CitySaveHelper.prototype.setAndSaveDisasterEnabled = function (enabled) {
        if (enabled === void 0) {
            enabled = true;
        }
        this.setGlobalSetting(CitySaveHelper.DISASTER_ENABLED_KEY, enabled ? 1 : 0, true);
    };
    CitySaveHelper.prototype.isDisastersEnabled = function () {
        return this.getGlobalSetting(CitySaveHelper.DISASTER_ENABLED_KEY, 1) ? true : false;
    };
    CitySaveHelper.prototype.update = function () {
        // check auto save
        if (this.city.tutorial.tutorialActive) {
            return;
        }
        if (Date.now() - this.lastAutoSaved > Global.AUTOSAVE_EVERY) {
            this.autoSave();
        }
    };
    /** Pushes new autosave snapshot and calls save() API */
    CitySaveHelper.prototype.autoSave = function (cb) {
        var _this = this;
        if (!this.city.ready || !this.city.game) {
            return;
        }
        if (this.city.ignoreSave) {
            if (this.city.tempUID) {
                console.log("autosave, has temp uid?", this.city.tempUID);
                var snapshot = this.city.getNewSnapshot();
                var cache = window['pocketCityGame'].regionDownload.cloudRegionCache[this.city.tempUID];
                cache.snapshot = snapshot;
                cache.stats = this.city.stats;
                cache.metadata = this.city.metadata;
                this.lastAutoSaved = Date.now();
            }
            return;
        }
        this.city.addNewAutoSnapshot();
        var autoSnaps = this.city.autoSnapshots;
        if (autoSnaps.length >= 2 && this.autoSaveTimeDiff(autoSnaps[0], autoSnaps[1]) < Global.GROUP_AUTOSAVE_IF_WITHIN) {
            //  group together first two snaps, aka remove index 1
            autoSnaps.splice(1, 1);
        }
        this.city.gameplayUI.pocketCity.save(function (e) {
            if (!_this.city.ready || !_this.city.game) {
                return;
            }
            if (cb) {
                cb();
            }
            if (!e) {
                if (_this.city.gameplayUI) {
                    _this.city.gameplayUI.showSaveNotif();
                }
                if (_this.city.eventSignal) {
                    _this.city.eventSignal.dispatch("autosaved");
                }
            } else {
                console.error("Failed to save");
                console.error(e);
                _this.city.notifications.notify("failed-to-save");
            }
        });
        this.lastAutoSaved = Date.now();
    };
    CitySaveHelper.prototype.autoSaveTimeDiff = function (as1, as2) {
        return Math.abs(as1.timestamp - as2.timestamp);
    };
    // `city.eventSignal.dispatch(EVENT)` events
    CitySaveHelper.AUTOSAVE_EVENTS = ["finished_tutorial", "land_unlocked", "level_up", "level_up_completed", "finish_build",
    // these should not trigger
    "quest_completed", "quest_new", "city_name_updated", "building_upgraded"];
    CitySaveHelper.UNLOCK_CHEST_KEY = "chestunlockbuildings"; // for which buildings have been unlocked by chests
    CitySaveHelper.DISASTER_ENABLED_KEY = "disasters";
    CitySaveHelper.DELAY_SAVE = {
        "finish_build": 1500,
        "quest_completed": 250,
        "quest_new": 250,
        "building_upgraded": 1500,
        "level_up": 1000,
        "level_up_completed": 2000,
        "land_unlocked": 2000
    };
    // do not extend the timeout for these, just save when the current timeout is done
    CitySaveHelper.FORCE_PERSIST_DELAY_TIMER = {
        "quest_completed": 1,
        "quest_new": 1
    };
    return CitySaveHelper;
}();
var Fire = function Fire(city, victim, fireManager, masterFire, offsetXPercent, offsetYPercent, fireSpread) {
    this.fireSpread = !fireSpread && fireSpread !== 0 ? Fire.MAX_FIRE_SPREAD : fireSpread;
    Phaser.Sprite.call(this, city.game, 0, 0, 'atlas-ui', Fire.ATLAS_FRAMES[0]);
    if (!city || !victim || !fireManager) {
        throw new Error("missing args");
    }
    if (!victim.isBurnable) {
        throw new Error("not buranble entity");
    }
    this.city = city;
    this.fireManager = fireManager;
    this._startTime = Utils.getGameMillis(this.game);
    this._victim = victim;
    this._noGlobalTint = 1;

    this.targetForPutOut = null;

    // Determine how long fire lasts
    this.durationUntilDestroy = Balance.DEFAULT_DURATION_UNTIL_DESTROY;
    if (this._victim instanceof Person) {
        this.durationUntilDestroy = Fire.DEFAULT_PEDESTRIAN_LAST;
        this._victim.onSetOnFire();
    } else if (this.isVictimAStructure() && this._victim.Tile && this._victim.Tile.building && this._victim.Tile.building.sheet === STRUCTURE_SHEETS.POWER_PLANT_NUCLEAR) {
        this.durationUntilDestroy = Balance.NUCLEAR_FIRE_DURATION;
    }

    this._master = masterFire || null;
    this._destroying = false;
    this._scalePercent = 1;
    this.childFires = [];
    this.childOffsetX = offsetXPercent || 0;
    this.childOffsetY = offsetYPercent || 0;
    if (this._master) {
        this._master.registerChildFire(this);
    }

    // Scale
    this.syncPosWithVictim();

    var isStructureVictim = victim instanceof StructureSprite;

    // Attach to victim
    victim.isOnFire = true;
    victim.fireSpread = fireSpread;

    victim.onStartFire(this);

    if (isStructureVictim) {
        this.city.upperStructureLayer.ensureZIndexUpdated();
        this.nextFirePixel = Utils.randomInRange(1000, 2000);
        // insert into upper structure at z index + 1 of the base victim
        var zIndex = void 0;
        if (this._master) {
            zIndex = this._master.z + 1;
        } else {
            if (victim.upperMaskSprite) {
                zIndex = victim.upperMaskSprite.z + 1;
            } else {
                zIndex = this.city.upperStructureLayer.children.length; // shouldn't happen, but just put in top in case
            }
        }

        // in case we are on the temp upper structure layer, we may be trying to inject out of bounds fire,
        // in that case just use highest index possible
        var fireLayer = this.city.tempUpperFireLayer.getFireLayer();
        zIndex = Math.min(zIndex, fireLayer.children.length);

        fireLayer.addChildAt(this, zIndex);
        victim.attachFire(this, false);
    } else {
        // attach as actual child
        victim.attachFire(this, true);
    }

    // Create progress bar
    this.progress = null;
    if (!this._master && isStructureVictim) {
        this.progress = new FireProgressBar(this.city.game);
        this.city.constantEffectLayer.add(this.progress);
        this.progress.setStructure(victim);
        this.progress.syncWithStructure();
        this.progress.visible = true;
    }

    // start animating
    this.animations.add('fire', Fire.ATLAS_FRAMES, Utils.randomInRange(Fire.FPS - 2, Fire.FPS + 2), true);
    this.animations.play('fire');

    this.anchor.setTo(0.5, 1);
    this.city.pushForcePrePostUpdateSprite(this);

    // register self
    this.city.fireManager.fireSprites.push(this);
};
Fire.prototype = Object.create(Phaser.Sprite.prototype);
Fire.prototype.constructor = Fire;

Fire.CENTER_OFFSET_PERCENT = 0.25;
Fire.SCALE_PERCENT = 0.3;
Fire.ALPHA = 0.9;
Fire.FPS = 20;

Fire.DEFAULT_PEDESTRIAN_LAST = 8000; // how long fires last on people
Fire.MAX_FIRE_SPREAD = Balance.MAX_FIRE_SPREAD;
Fire.ATLAS_FRAMES = function () {
    var l = [];
    for (var i = 1; i <= 15; i++) {
        l.push(i);
    }
    return l;
}().map(function (i) {
    return 'src/www/img-atlas/ui/fire_' + i + '.png';
});

Fire.prototype.animateIn = function () {
    this.alpha = 0;
    var baseHeight = this.height;
    this.height = this.height * 0.5;
    this.city.game.add.tween(this).to({
        alpha: Fire.ALPHA,
        height: baseHeight
    }, 500, Phaser.Easing.Exponential.Out, true, Math.random() * 250);
};

Fire.prototype.showPixels = function () {
    this.city.cityEffects.showFirePixels(this);
    this.nextFirePixel = Utils.randomVariance(3000, 1000);
};

Fire.prototype.scalePercent = function (p) {
    this._scalePercent = p;
    this.syncPosWithVictim();
    return this;
};

// Child fires do not have any effect except visual
Fire.prototype.registerChildFire = function (fireSprite) {
    if (!fireSprite) {
        throw new MissingArgsError();
    }
    this.childFires.push(fireSprite);
};
Fire.prototype.getBottomY = function () {
    return this._victim.y + this.childOffsetY + this._victim.height * 0.65;
};
Fire.prototype.syncPosWithVictim = function () {
    var base = this._victim.getFireBase();
    var tileSize = this.city.getCachedTileSize();

    Utils.scaleToWidth(this, this._victim.getFireScale() * this._scalePercent * tileSize);

    this.x = base.x + base.width * this._victim.fireXOffset + base.width * this.childOffsetX;
    this.y = base.y + base.height * this._victim.fireYOffset + base.height * this.childOffsetY;

    for (var i = 0; i < this.childFires.length; i++) {
        this.childFires[i].syncPosWithVictim();
    }

    if (this.progress) {
        this.progress.syncWithStructure();
    }
};

//
// Destructions
//

Fire.prototype.destroy = function (victimSafe) {
    if (!this.alive) return;
    this._destroying = true;
    for (var i = 0; i < this.childFires.length; i++) {
        Utils.destroyIfAlive(this.childFires[i]);
    }
    this._victim.isOnFire = false;
    if (!this._master) {
        // usually .alive and .city should be set / unset during the same time
        if (this._victim.alive && this._victim.city) {
            if (victimSafe) {
                this._victim.onFirePutOut();
                // victim can't be put on fire again for a while
                this._victim.setUnburnableUntil(Utils.getGameMillis(this.city.game) + this.durationUntilDestroy);
            } else {
                this._victim.onFireEnd();
            }
        }
        Utils.destroyIfAlive(this.progress);
    }

    // Animate out then destroy
    var targetHeight = this.height * 2;
    var t = this.city.game.add.tween(this).to({
        alpha: 0,
        height: targetHeight
    }, 500, Phaser.Easing.Exponential.Out, true, Math.random() * 250);
    var self = this;
    t.onComplete.add(function () {
        if (!self || !self.city.alive || !self.city.game) return;
        self.city.removeForcePrePostUpdateSprite(self);
        self.city.fireManager.fireSprites.splice(self.city.fireManager.fireSprites.indexOf(self), 1);

        // if building, want to immediately update fire audio
        if (self._victim && self.isVictimAStructure()) {
            AudioPC.checkFireAudio(self.city);
        }

        // Remove all children (pixel sprites) before destroying self
        for (var _i = self.children.length - 1; _i >= 0; _i--) {
            self.removeChild(self.children[_i]);
        }

        Phaser.Sprite.prototype.destroy.call(self);
    });

    // Check if nuclear...
    if (self.progress && self.progress._percent >= 1 && self.childFires.length > 0 && self.isVictimAStructure() && !self._victim.Tile._master && self._victim.Tile && self._victim.Tile.building && self._victim.Tile.building.sheet === STRUCTURE_SHEETS.POWER_PLANT_NUCLEAR && !CityEffects.NUCLEAR_DONE[self._victim.Tile.uid]) {

        CityEffects.NUCLEAR_DONE[self._victim.Tile.uid] = 1;

        // Set nearby on fire
        var _row = self._victim.Tile.row;
        var _col = self._victim.Tile.col;
        var city = self.city;
        var nuclearRadius = 2;
        for (var r = _row - nuclearRadius - 1; r <= _row + nuclearRadius; r++) {
            for (var c = _col - nuclearRadius - 1; c <= _col + nuclearRadius; c++) {
                if (Utils.isValidIndex(_row, _col, self.city.size) && Utils.isValidIndex(r, c, self.city.size)) {
                    var tile = city.grids.zoneGrid.tiles[r][c];
                    if (tile && tile._master) {
                        tile = tile._master;
                    }
                    if (tile && !tile.isOnFire && tile.structureGroup && tile.structureGroup !== self._victim && !tile.structureGroup.isOnFire) {
                        var fireMaster = city.fireManager.setOnFire(tile.structureGroup);
                        fireMaster.durationUntilDestroy = Balance.NUCLEAR_FIRE_FAST_DURATION;
                    }
                    self.city.danger.setDangerAround(_row, _col, 2);
                }
            }
        }
        AudioPC.checkFireAudio(city);

        var __r = self._victim.Tile.row;
        var __c = self._victim.Tile.col;
        Explosion.playExplosionIndex(city, __r, __c);
        city.setRubble(__r, __c, 6);
        self._victim.Tile._children.forEach(function (_child) {
            Explosion.playExplosionIndex(city, _child.row, _child.col);
            city.setRubble(_child.row, _child.col, 6);
        });

        setTimeout(function () {
            if (city.game) {
                Explosion.extraExplodeSmk(city, __r, __c);
            }
        }, 200);
        city.cityEffects.startShakeCamera();
        city.delayEventWithCityCheck(1000, function () {
            city.cityEffects.stopShakeCamera();
        });
    }
};
Fire.prototype.isVictimAStructure = function () {
    return this._victim instanceof StructureSprite;
};
Fire.prototype.getBottomY = function () {
    return Utils.round(this.y + this.height * 0.5 + Tile.TILE_WIDTH * 1.15, 2);
};
Fire.prototype.update = function () {
    Phaser.Sprite.prototype.update.call(this);
    if (this._destroying) {
        return;
    }

    // Spread fire
    if (this.fireSpread > 0) {
        if (!this._master && this._victim.burnAfter > 0) {
            this._victim.burnAfter -= Utils.getElapsedTime(this.city.game);
            if (this._victim.burnAfter <= 0) {
                this._victim.burnNeighbors(this.fireSpread - 1);
            }
        }
    }

    if (!this._master) {
        var percent = Utils.gameMillisSince(this.game, this._startTime) / this.durationUntilDestroy;
        if (this.progress) {
            this.progress.updatePercent(percent);
        }
        if (percent > 1) {
            Utils.destroyIfAlive(this);
        }
    }

    if (this.city.pocketCity.enableSpecialFX) {
        this.nextFirePixel -= Utils.getElapsedTime(this.city.game);
        if (this.nextFirePixel <= 0 && this.city.scale.x > 0.45) {
            this.showPixels();
        }
    }
};
var WithWalkCount = {
    checkWalkLoopCounter: function checkWalkLoopCounter() {
        var shouldGoOpposite = false;
        if (this.walkLoopCounter !== -1) {
            this.walkLoopCounter -= 1;
            if (this.walkLoopCounter === 0 && this.lastDir) {
                shouldGoOpposite = true;
                if (this.walkLoopMaxSteps) {
                    this.walkLoopCounter = this.walkLoopMaxSteps - 1;
                }
            }
        }
        return shouldGoOpposite;
    },
    clearMaxWalkSteps: function clearMaxWalkSteps() {
        this.walkLoopCounter = -1;
        this.walkLoopMaxSteps = 0;
    },
    setMaxWalkSteps: function setMaxWalkSteps(s) {
        this.walkLoopMaxSteps = s;
        this.walkLoopCounter = s;
    }
};
/**
 * Mixin for adding animation to visible / invisible
 */
var WithAnimationMixin = {

    animationSpeed: 250,
    animationMoveOffsetY: Utils.screenHeight(0.075),

    _animationToggleTween: null,
    _animation: "fade",
    _animations: {
        "fade": {
            "in": function _in(self, cb) {
                self.alpha = 0;
                var posObj = self.fixedToCamera ? self.cameraOffset : self;
                self._baseY = posObj.y;
                posObj.y += self.animationMoveOffsetY;

                if (self.fixedToCamera) {
                    self._animationToggleTween = self.game.add.tween(self).to({
                        alpha: 1
                    }, self.animationSpeed, Phaser.Easing.Exponential.Out, true);
                    self._animationToggleTween = self.game.add.tween(self.cameraOffset).to({
                        y: self._baseY
                    }, self.animationSpeed, Phaser.Easing.Exponential.Out, true);
                } else {
                    self._animationToggleTween = self.game.add.tween(self).to({
                        alpha: 1,
                        y: self._baseY
                    }, self.animationSpeed, Phaser.Easing.Exponential.Out, true);
                }
                self._animationToggleTween.onComplete.add(function () {
                    delete self._baseY;
                    if (cb) {
                        cb();
                    }
                }, this);
            },
            "out": function out(self, cb) {
                self.alpha = 1;
                self._animationToggleTween = self.game.add.tween(self).to({
                    alpha: 0
                }, self.animationSpeed, Phaser.Easing.Exponential.Out, true);
                if (cb) {
                    self._animationToggleTween.onComplete.add(cb, this);
                }
            }
        },

        "bounce": {
            // smaller bounce scale means more extreme shrinking
            "in": function _in(self, cb, shrinkScale, keepVisible) {
                var scale = shrinkScale || 0.2;
                self._baseAlpha = 1;
                self._baseY = self.y;
                self._baseWidth = self.width;
                self._baseHeight = self.height;
                self.alpha = keepVisible ? 1 : 0;
                self.y += self._baseHeight * ((1 - scale) * 0.625);
                self.width = self._baseWidth * scale;
                self.height = self._baseHeight * scale;
                self._animationToggleTween = self.game.add.tween(self).to({
                    alpha: 1,
                    width: self._baseWidth,
                    height: self._baseHeight,
                    y: self._baseY
                }, self.animationSpeed, Phaser.Easing.Exponential.Out, true);

                if (cb) {
                    self._animationToggleTween.onComplete.add(function () {
                        delete self._baseY;
                        cb();
                    }, this);
                }
            },
            "out": function out(self, cb) {
                self.alpha = 1;
                self._animationToggleTween = self.game.add.tween(self).to({
                    alpha: 0
                }, self.animationSpeed, Phaser.Easing.Exponential.Out, true);
                if (cb) {
                    self._animationToggleTween.onComplete.add(cb, this);
                }
            }
        }
    },

    // Default animation is a fade
    // Override these animations if desired
    animateIn: function animateIn(cb, extraArg1, extraArg2) {
        this._animations[this._animation].in(this, cb, extraArg1, extraArg2);
    },

    animateOut: function animateOut(cb) {
        this._animations[this._animation].out(this, cb);
    },

    forceFinishAnimation: function forceFinishAnimation() {
        if (this.hasOwnProperty("_baseX")) {
            this.x = this._baseX;
            delete this._baseX;
            this.killTween();
        }
        if (this.hasOwnProperty("_baseY")) {
            this.y = this._baseY;
            delete this._baseY;
            this.killTween();
        }

        if (this.hasOwnProperty("_baseAlpha")) {
            this.alpha = this._baseAlpha;
            delete this._baseAlpha;
            this.killTween();
        }
    },

    killTween: function killTween() {
        if (this._animationToggleTween) {
            this._animationToggleTween.stop();
            this._animationToggleTween = null;
        }
    },

    setAnimation: function setAnimation(a) {
        this._animation = a;
        return this;
    },

    // Show and hide
    show: function show(animate) {
        animate = animate !== false;
        var sprite = this;
        if (sprite.visible) return;
        sprite.visible = true;

        var callback = function callback() {
            // nothing for now
        };

        if (animate) {
            sprite.animateIn(callback);
        } else {
            sprite.alpha = 1;
            callback();
        }

        // Call handler if it exists
        if (sprite.onShow) {
            sprite.onShow();
        }
    },
    hide: function hide(animate, finalCallback) {
        animate = animate !== false;
        var sprite = this;
        if (!sprite.visible) return;

        var callback = function callback() {
            sprite.visible = false;
            if (finalCallback) finalCallback();
        };

        if (animate) {
            sprite.animateOut();
            setTimeout(callback, this.animationSpeed);
        } else {
            callback();
        }

        // Call handler if it exists
        if (sprite.onHide) {
            sprite.onHide();
        }
    }
};
var WithGroupDepthSortMixin = {
    _simpleYDepthSort: function _simpleYDepthSort(child1, child2) {
        var child1Bottom = child1.y;
        var child2Bottom = child2.y;
        // to return child2 as lower y, return -1
        if (child1Bottom < child2Bottom) return -1;else if (child1Bottom > child2Bottom) return 1;else return child1.x > child2.x ? 1 : -1;
    },

    _sortGroupTextureCustomSort: function _sortGroupTextureCustomSort(child1, child2) {
        var child1Tex = child1.Tile.building["atlas-folder"];
        var child2Tex = child2.Tile.building["atlas-folder"];
        if (child1Tex < child2Tex) {
            return -1;
        } else if (child1Tex > child2Tex) {
            return 1;
        } else {
            return 0;
        }
    },

    _sortGroupDepthCustomSort: function _sortGroupDepthCustomSort(child1, child2) {
        // lower one returns 1;
        // Simple y sorting first
        var child1Bottom;
        if (child1.getBottomY) {
            child1Bottom = child1.getBottomY();
        } else {
            child1Bottom = child1.y + child1.height * 0.5;
            child1Bottom = Utils.round(child1Bottom, 2);
        }
        var child2Bottom;
        if (child2.getBottomY) {
            child2Bottom = child2.getBottomY();
        } else {
            child2Bottom = child2.y + child2.height * 0.5;
            child2Bottom = Utils.round(child2Bottom, 2);
        }

        var isVeryClose = Math.abs(child1Bottom - child2Bottom) < 2;
        if (!isVeryClose) {
            // check if horizontal
            isVeryClose = child1.row === child2.row + 1 && child1.col === child2.col - 1 || child2.row === child1.row + 1 && child2.col === child1.col - 1;
        }
        if (isVeryClose && child1.tileDimensions && child2.tileDimensions) {
            // Use sheet tile visual representation to determine z index
            if (child1.isSmaller(child2)) {
                return 1; // return 1
            } else if (child1.isLarger(child2)) {
                return -1; // return 2
            } else {
                if (child1.leansLeft() && child2.leansLeft()) {
                    return child1.x < child2.x ? 1 : -1; // return
                } else if (child1.leansRight() && child2.leansRight()) {
                    return child1.x > child2.x ? 1 : -1;
                } else {
                    // leans different ways, doesnt matter
                    return child1.x > child2.x ? 1 : -1;
                }
            }
        }

        // to return child2 as lower y, return -1
        if (child1Bottom < child2Bottom) return -1;else if (child1Bottom > child2Bottom) return 1;else return child1.x > child2.x ? 1 : -1;
    },
    sortGroupDepth: function sortGroupDepth() {
        this.customSort(WithGroupDepthSortMixin._sortGroupDepthCustomSort, this);
        if (this.resetClusterOnDepthSort) {
            this.setClusterDirty();
        }
    }
};

var WithClusterSortMixin = {
    // use resetClusterOnDepthSort = true to auto set dirt when sorted by above mixin

    // set 'dirtyClusters' to false on class by default
    setClusterDirty: function setClusterDirty(runNow) {
        this.dirtyClusters = true;
        if (runNow) {
            this.checkUpdateClusters();
        }
    },

    checkUpdateClusters: function checkUpdateClusters() {
        // this causes a lot of clipping so just disable it for now.
        // come up with better way of doing this in the future
        // (e.g. clustering groups of zones surrounded by roads)

        // if (ClusterFinder.ENABLE_CLUSTERING &&
        //     this.children.length > ClusterFinder.CLUSTERING_COUNT_CUTOFF &&
        //     this.dirtyClusters && this.visible){
        //     let children = this.culledVisibleChildren || this.children;
        //     let maxY = this.clusterMaxY || ClusterFinder.CLUSTER_BATCH_MAX_Y_DIFF;
        //     let minX = this.clusterMinX || ClusterFinder.CLUSTER_MIN_X_DIFF;
        //     ClusterFinder.sortChildrenByClusters(children, maxY, minX);
        //     //console.log("sorted cluster for ",children.length,"children", (this.culledVisibleChildren)? "culled" : "non-culled","using maxY",maxY, "minX",minX);
        //     this.dirtyClusters = false;
        // }
    }
};
var WithBurnable = {
    isBurnable: true,
    getFireScale: function getFireScale() {
        return 4;
    },
    isOnFire: false,
    fireYOffset: 0.5,
    fireXOffset: 0,
    largeFire: false,
    burnAfter: false,
    onStartFire: function onStartFire() {},
    onFireEnd: function onFireEnd() {},
    onFirePutOut: function onFirePutOut() {},
    setUnburnableUntil: function setUnburnableUntil(gameMillis) {
        this.cantBurnUntil = gameMillis;
    },
    burnableChildren: function burnableChildren() {
        return [];
    },
    attachFire: function attachFire(fireSprite, addAsChild) {
        this._fireSprite = fireSprite;
        if (addAsChild) {
            this.addChild(fireSprite);
        }
    },
    destroyAnyFire: function destroyAnyFire() {
        if (this._fireSprite) {
            this._fireSprite.destroy(true); // passing true so that fire doesnt equally destroy self prematurely
        }
    },
    getFireBase: function getFireBase() {
        return { x: 0, y: 0, width: this.width, height: this.height };
    },
    burnNeighbors: function burnNeighbors() {
        throw new UnimplementedError();
    }
};
/**
 * Mixin for adding animation to visible / invisible
 *
 * // call initWithAnimateToPosition() first
 * // call updateManualTween() in each update
 * // also call destroyWithAnimatetoPosition() if it needs to be reset before freeing
 */
var WithAnimateToPosition = {
    initWithAnimateToPosition: function initWithAnimateToPosition() {
        this._manualTweenTime = 0;
        this._manualTweenMillisTransform = {
            xOffset: 0,
            yOffset: 0
        };
        this._manualTween = { x: 0, y: 0, tileSize: 0 };
        this._manualTweenCb = null;
        this._animatingToPosition = false; // seems to be unreliable indicator, use _manualTweenTime instead
        this.entityPaused = false;
        this._moveLoopIndex = null;
    },
    moveLoop: function moveLoop(baseIndex, startOffset, endOffset, time, delayBetween) {
        this._moveLoopIndex = baseIndex;
        this._moveLoopRepeat(startOffset, endOffset, time, delayBetween);
    },
    _moveLoopRepeat: function _moveLoopRepeat(startOffset, endOffset, time, delayBetween) {
        var _this = this;
        var row = this._moveLoopIndex.row;
        var col = this._moveLoopIndex.col;
        var tileSize = this.city.getCachedTileSize();
        var posCentre = Utils.indexToPosition(col, row, tileSize);
        this.x = posCentre.x;
        this.y = posCentre.y;
        this.x += startOffset[0] * tileSize;
        this.y += startOffset[1] * tileSize;
        var endX = posCentre.x + endOffset[0] * tileSize;
        var endY = posCentre.y + endOffset[1] * tileSize;
        this.animateToPosition(endX, endY, time, function () {
            _this.city.delayEventWithSpriteCheck(delayBetween, _this, function () {
                _this._moveLoopRepeat(endOffset, startOffset, time, delayBetween);
            }, true);
        });
    },
    getTargetDirection: function getTargetDirection(x, y) {
        if (this.x > x) {
            if (this.y < y) {
                return DIRECTION.DOWN;
            } else {
                return DIRECTION.LEFT;
            }
        } else {
            if (this.y < y) {
                return DIRECTION.RIGHT;
            } else {
                return DIRECTION.UP;
            }
        }
    },
    updateDirectionFrame: function updateDirectionFrame(x, y) {
        if (this['autoFlip'] === false) {
            return;
        }
        if (x > this.x && this.scale.x < 0) {
            // moving right
            // change negative to positive
            this.scale.x = -this.scale.x;
        } else if (x < this.x && this.scale.x > 0) {
            // moving left
            // change positive to negative
            this.scale.x = -this.scale.x;
        }
    },
    setAtIndex: function setAtIndex(row, col) {
        Utils.setPositionToIndex(this, row, col, Tile.TILE_WIDTH);
    },
    animateToIndex: function animateToIndex(row, col, speed, cb, offsetY) {
        if (speed === void 0) {
            speed = 1;
        }
        if (offsetY === void 0) {
            offsetY = 0;
        }
        // default speed 1 tile per second
        var pos = Utils.indexToPosition(col, row, Tile.TILE_WIDTH);
        if (offsetY) {
            pos.y += offsetY;
        }
        var time = 1000 * (Utils.posDistTotal(pos, this) / (Tile.TILE_WIDTH * speed));
        if (time === 0) {
            cb();
        } else {
            this.animateToPosition(pos.x, pos.y, time, cb);
        }
    },
    animateToPosition: function animateToPosition(x, y, time, cb) {
        this.updateDirectionFrame(x, y);
        this._animatingToPosition = true;
        this._manualTweenTime = time;
        this._manualTweenMillisTransform.xOffset = (x - this.x) / time;
        this._manualTweenMillisTransform.yOffset = (y - this.y) / time;
        this._manualTweenCb = cb;
        this._manualTween.x = x;
        this._manualTween.y = y;
        this._manualTween.tileSize = Global.TILE_WIDTH;
        this.entityPaused = false;
    },
    stopAnimateToPosition: function stopAnimateToPosition(ignoreCallback) {
        if (ignoreCallback === void 0) {
            ignoreCallback = false;
        }
        this._manualTweenTime = 0;
        this._animatingToPosition = false;
        if (this._manualTweenCb && !ignoreCallback) {
            this._manualTweenCb();
        }
    },
    clearTweenCb: function clearTweenCb() {
        this._manualTweenCb = null;
    },
    // must call this on each update();
    updateManualTween: function updateManualTween(elapsedMillis) {
        if (this.entityPaused || this._manualTweenTime < 0) return;
        elapsedMillis = elapsedMillis || this.city.game.time.elapsedMS;
        this._manualTweenTime -= elapsedMillis;
        this.x += elapsedMillis * this._manualTweenMillisTransform.xOffset;
        this.y += elapsedMillis * this._manualTweenMillisTransform.yOffset;
        if (this._manualTweenTime <= 0) {
            if (this._manualTweenCb) {
                this._manualTweenCb();
            }
            this._animatingToPosition = false;
        }
    },
    // higher is faster
    updateManualTweenSpeed: function updateManualTweenSpeed(multiplier) {
        if (this._manualTweenTime <= 0 || !this._manualTweenMillisTransform) {
            return;
        }
        this._manualTweenTime /= multiplier;
        this._manualTweenMillisTransform.xOffset *= multiplier;
        this._manualTweenMillisTransform.yOffset *= multiplier;
    },
    resizeManualTween: function resizeManualTween(oldTileSize, newTileSize) {
        if (this._manualTweenTime) {
            Utils.updateIsoPositionByZoom(this._manualTween, oldTileSize, newTileSize, true);
            this.animateToPosition(this._manualTween.x, this._manualTween.y, this._manualTweenTime, this._manualTweenCb);
        }
    },
    // may not really be destroy - might just be reset before pool
    destroyWithAnimateToPosition: function destroyWithAnimateToPosition() {
        // stop all tweens
        this._animatingToPosition = false;
        this._manualTweenTime = 0;
        this._manualTweenMillisTransform = {
            xOffset: 0,
            yOffset: 0
        };
        this._manualTween = { x: 0, y: 0 };
        this._manualTweenCb = null;
    }
};
// If the entity belongs to a auto resizing group,
// resizeAndPosition must be implemented. This mixin does that
var WithResizeHandler = {
    resizeAndPosition: function resizeAndPosition(previousTileSize, newTileSize) {
        Utils.updateIsoPositionByZoom(this, previousTileSize, newTileSize, true);
        this.refreshSize();
    },
    refreshSize: function refreshSize() {
        var isFlipped = this.scale.x < 0;
        if (!this._widthRatio) {
            throw new Error("this._widthRatio not defined in " + this);
        }
        this.height = this.getHeight();
        this.width = this._widthRatio * this.height;
        if (isFlipped && this.scale.x > 0) {
            this.scale.x = -this.scale.x;
        }
    },
    getHeight: function getHeight() {
        throw new Error("unimplemented");
    }
};
var WithSpinDestroy = {
    funDestroy: function funDestroy() {
        if (this.destroying || !this.alive) return;
        if (this.preFunDestroy) {
            this.preFunDestroy();
        }
        var duration = Utils.spinDestroy(this.city, this);
        this.destroying = true;
        return duration;
    }
};
var WithSpeechBubble = {
    /** Supply index when convo */
    showSpeechBubble: function showSpeechBubble(key, duration, index, textOverride) {
        if (!SpeechBubble.COPY_CONTENT[key] && !textOverride) {
            console.warn(key + " is not a valid speechBubble.COPY_CONTENT");
            return;
        }
        if (this.city.grids.zoneGrid.children.length > 1600 && this.city.performance.avgFps < 24) {
            // performance - no speech bubbles after cutoff!
            return;
        }
        if (!textOverride && SpeechBubble.COPY_CONTENT[key] instanceof Array && typeof index === 'undefined') {
            throw new Error("Index must be defined when array is the copy");
        }
        duration = duration || CitySpeech.SPEECH_DURATION;

        var self = this;
        self._speechBubble = this.city.citySpeech.speechBubblePool.allocate(key, index, textOverride);
        self._speechBubble.person = this;
        self._speechBubbleLastShown = Utils.getElapsedTime(this.city.game);
        self._speechBubble.alpha = 0;
        self._speechBubble.x = this.x;
        self._speechBubble.y = this.y;
        self._speechBubbleTween = this.city.game.add.tween(self._speechBubble).to({
            "alpha": 1
        }, 250, null, true);
        if (self._sBubbleTimeout) {
            clearTimeout(self._sBubbleTimeout);
        }
        self._sBubbleTimeout = setTimeout(function () {
            if (self.city && self && self._speechBubble) {
                self.stopSpeechBubble(true);
            }
        }, duration);
        if (this instanceof StructureSprite) {
            this.city.pushForcePrePostUpdateSprite(this);
        }
    },

    /** Must not be convo */
    showSpeechBubbleRotateChoice: function showSpeechBubbleRotateChoice(keys, duration) {
        this.showSpeechBubble(this.city.citySpeech.getNextRotateSpeech(keys), duration);
    },

    tooCloseToOtherBubble: function tooCloseToOtherBubble() {
        return this.city.citySpeech.isSpeechBubbleNear(this);
    },

    stopSpeechBubble: function stopSpeechBubble(animate) {
        if (!this || !this._speechBubble || !this.city || !this.city.game) {
            return;
        }
        if (this._speechBubbleTween) {
            this._speechBubbleTween.stop();
            this._speechBubbleTween = null;
        }
        var self = this;
        var speechBubble = this._speechBubble;
        this._speechBubble = null;
        if (animate) {
            var tween = this.city.game.add.tween(speechBubble).to({
                "alpha": 0
            }, 500, null, true);
            tween.onComplete.add(function () {
                speechBubble.resetPerson();
                if (self.city) {
                    self.city.citySpeech.speechBubblePool.free(speechBubble);
                }
            });
        } else {
            speechBubble.resetPerson();
            self.city.citySpeech.speechBubblePool.free(speechBubble);
        }
        if (this instanceof StructureSprite) {
            this.city.removeForcePrePostUpdateSprite(this);
        }
    }
};
/**
 * Used to make a group auto resize its children
 * - children should use mixin 'WithResizeHandler'
 */
var WithAutoResize = {
    resizeAll: function resizeAll(prevZoom, newZoom) {
        var c;
        for (var i = 0, _max = this.children.length; i < _max; i++) {
            c = this.children[i];
            if (c.resizeAndPosition) {
                c.resizeAndPosition(prevZoom, newZoom);
            } else {
                console.log("WARN: Child in autoresize group does not have resizeAndPosition implemented", c);
            }
        }
    }
};
/** Re-orders children's z order such that children using the same atlas
 *  near the same y plane, but sufficiently separate on the x plane
 *  will have a close z-index so that they will be rendered together
 *
 *  Mixin on a Phaser.Group
 *  Use these methods:
 *      - ensureBatchedChildrenEvery() on init
 *      - setBatchChildrenDirty() when children have changed
 *
 */
var WithBatchZOrdering = {
    BATCH_Y_RANGE: Global.TILE_WIDTH * 0.5,
    BATCH_MIN_X_DELTA: Global.TILE_WIDTH,
    _groupTextures: {},
    _dirtyBatchGroup: 0,
    setBatchChildrenDirty: function setBatchChildrenDirty() {
        this._dirtyBatchGroup = 1;
    },
    ensureBatchedChildrenEvery: function ensureBatchedChildrenEvery(interval) {
        var _this = this;
        if (interval === void 0) {
            interval = 1000;
        }
        this.city.registerCallbackUpdateEvery(function () {
            if (!_this.dirtyZ && _this._dirtyBatchGroup) {
                _this.batchChildrenZIndex();
                _this._dirtyBatchGroup = 0;
            }
        }, interval);
    },
    // Reset state for all loop group textures to empty
    _clearGroupTextures: function _clearGroupTextures() {
        var keys = Object.keys(this._groupTextures);
        for (var i = 0; i < keys.length; i++) {
            this._groupTextures[keys[i]].length = 0;
        }
    },
    // Update ordering for all children in _groupTextures, setting same atlas consecutively
    // Expects that there are an equal number of items in _groupTextures that fit into [minIndex -> maxIndex]
    _updateIndicesGroupChildrenBatchedInRange: function _updateIndicesGroupChildrenBatchedInRange(minIndex, maxIndex) {
        if (minIndex === -1 || maxIndex === -1) {
            console.warn("invalid indices passed");
            return;
        }
        var newIndex = minIndex;
        var atlasKeys = Object.keys(this._groupTextures);
        var k, elements;
        for (var i = 0; i < atlasKeys.length; i++) {
            k = atlasKeys[i];
            elements = this._groupTextures[k];
            for (var j = 0; j < elements.length; j++) {
                this.children[newIndex] = elements[j];
                console.log("set child at index", newIndex, "to child of atlas", k, "framename", elements[j].frameName, "with y:", elements[j].y);
                if (k === "atlas-terrain") {
                    console.log("why is terrain apperaing?");
                }
                newIndex += 1;
            }
        }
        if (maxIndex !== newIndex) {
            throw new Error("Expected to fill in children indices with new batch group from index" + minIndex + " to " + maxIndex + ", but ended at index " + newIndex);
        }
    },
    batchChildrenZIndex: function batchChildrenZIndex() {
        var groupY = -Tile.TILE_WIDTH * 1000; // force very low
        var minIndex = -1;
        var maxIndex = -1;
        var c;
        var _max = this.children.length;
        for (var i = 0; i < _max; i++) {
            c = this.children[i];
            if (Math.abs(c.y - groupY) > this.BATCH_Y_RANGE) {
                // flush old group
                if (minIndex !== -1 && maxIndex !== minIndex) {
                    this._updateIndicesGroupChildrenBatchedInRange(minIndex, maxIndex);
                }
                this._clearGroupTextures();
                // start new group
                minIndex = i;
                maxIndex = i;
                groupY = c.y;
                continue;
            }
            // still eligible for Y batch group
            maxIndex = i;
            if (!this._groupTextures[c.key]) {
                this._groupTextures[c.key] = [];
            }
            this._groupTextures[c.key].push(c);
        }
        if (maxIndex !== _max - 1) {
            throw new Error("expected final processed index to be " + (_max - 1) + " but was " + maxIndex);
        }
        this.updateZ();
    }
};
/**
 * Mixin for adding animation to visible / invisible
 */
var WithMoveAnimationMixin = {

    animationMoveSpeed: 200,
    _moveTween: null,
    animateMoveTo: function animateMoveTo(x, y) {
        if (!this.game) {
            throw new Error("this.game not defined!");
        }
        if (this._moveTween) {
            this._moveTween.stop();
            this.x = this._targetX;
            this.y = this._targetY;
        }
        this._targetX = x;
        this._targetY = y;
        this._moveTween = this.game.add.tween(this).to({
            x: x,
            y: y
        }, this.animationMoveSpeed, Phaser.Easing.Exponential.Out, true);
    }
};
var _this = this;
var WithTilePosition = {
    /** Scale sprite by a factor from default size */
    resize: function resize(size, col, row) {
        _this.size = size || _this.size;
        Utils.scaleToWidth(_this, _this.size * _this.sizeMult / Tile.ZONE_TILE_AREA_PERCENT);
        _this.setPositionByIndex(col, row);
    },
    /**
     * Set sprite position according to grid index
     * @param col {Number}
     * @param row {Number}
     */
    setPositionByIndex: function setPositionByIndex(col, row) {
        if (Global.TEST_MODE) return;
        _this.setPosition(Utils.indexToPositionReuse(col, row, _this.size));
    }
};
var WithUpperMaskMixin = {
    /** Should be called on base tile resize
     * Returns whether height is greater than width
     * */
    syncUpperMask: function syncUpperMask(forceRealSpriteResize) {
        if (forceRealSpriteResize === void 0) {
            forceRealSpriteResize = false;
        }
        if (!this || !this.upperMaskSprite) {
            console.warn("tried to sync me - why no upper mask sprite?", this);
            return false;
        }
        var cropKey = this.frameName; // 29 is length of "src/www/img-atlas/structures/"
        var cropSetting = CROP_SETTINGS_FULL_FRAME[cropKey];
        var fullHeight = this.height;
        var fullWidth = this.width;
        if (cropSetting) {
            fullHeight = this.height / (1 - cropSetting[0] - cropSetting[1]);
            fullWidth = this.width / (1 - cropSetting[2] - cropSetting[3]);
        }
        // sync self first (structure group)
        var anchorY = this.hasOwnProperty("baseAnchorY") && this.baseAnchorY !== null ? this.baseAnchorY : this.anchor.y;
        var y = this.hasOwnProperty("baseSpriteY") && this.baseSpriteY !== null ? this.baseSpriteY : this.y;
        WithBuildingTile.applyBuildingCrop(cropKey, anchorY, fullWidth, fullHeight, // before crop, they are equal
        this.x, y, this);
        // sync upper mask, either separate sheet or own sheet
        if (!StructureSpriteMask.maskCropBottoms[this.frameName]) {
            // now sync upper (separate sheet)
            WithBuildingTile.applyBuildingCrop(this.upperMaskSprite.frameName, anchorY, fullWidth, fullHeight, this.x, y, this.upperMaskSprite);
            // apply extra anchor shift, manual values because my math is bad
            if (ANCHOR_STRUCT_OVERRIDE[this.frameName]) {
                this.anchor.setTo(this.anchor.x, ANCHOR_STRUCT_OVERRIDE[this.frameName]);
            }
            if (ANCHOR_STRUCT_OVERRIDE[this.upperMaskSprite.frameName]) {
                this.upperMaskSprite.anchor.setTo(this.upperMaskSprite.anchor.x, ANCHOR_STRUCT_OVERRIDE[this.upperMaskSprite.frameName]);
            }
        } else {
            // sync same sheet
            var sprite = this.upperMaskSprite;
            StructureSpriteMask.applyCroppedBaseSpriteAsMask(this.city, sprite);
            sprite.width = this.width;
            sprite.height = this.width * StructureSpriteMask.heightToWidthRatio[this.upperMaskSprite.frameName];
            sprite.scale.setTo(this.scale.x, this.scale.y);
            sprite.x = this.x;
            var diff = (this.height - sprite.height) * this.anchor.y;
            StructureSpriteMask.shiftedYMask[this.frameName] = diff / this.upperMaskSprite.scale.y;
            sprite.y = this.y - diff;
            sprite.anchor.setTo(this.anchor.x, this.anchor.y);
            sprite.baseSpriteY = this.baseSpriteY;
            sprite.sortHeight = this.sortHeight;
            if (sprite.tileDimensions) {
                var size = sprite.tileDimensions.col * sprite.tileDimensions.row;
                if (isNaN(size)) {
                    size = 1;
                }
                if (size > 1) {
                    sprite.sortHeight = Math.round(sprite.sortHeight * 0.99);
                }
            }
        }
        if (this.alpha === 1) {
            this.upperMaskSprite.alpha = 1;
        }
        return fullHeight > fullWidth + 0.05;
    }
};
var WithTileUpperMaskMixin = {
    // requires `upperMask` to be set
    // destroy should also destroy `upperMask`
    // resize must call syncUpperMask
    initializeUpperMask: function initializeUpperMask() {
        var maskName = this.frameName.split(".png")[0] + "-mask.png";
        this.upperMask = new Phaser.Sprite(this.city.game, 0, 0, "atlas-terrain", maskName);
        this.city.upperStructureLayer.addChild(this.upperMask);
        this.syncUpperMask();
    },
    syncUpperMask: function syncUpperMask() {
        this.upperMask.anchor.setTo(this.anchor.x, this.anchor.y);
        this.upperMask.x = this.x;
        this.upperMask.y = this.y;
        this.upperMask.height = this.height;
        this.upperMask.width = this.width;
        this.city.smartUpdateNext();
    }
};
/**
 * Mixin for sprites to float to edge
 *
 * Can be chained like:
 *  sprite.floatLeft().floatTop()
 */
var FloatMixin = {
    DEFAULT_PADDING: 0,
    center: function center(padding, sprite) {
        sprite = sprite || this;
        var width = sprite.getWidth ? sprite.getWidth() : sprite.width;
        var height = sprite.getHeight ? sprite.getHeight() : sprite.height;
        this._applyPositionChange(sprite, Global.GAME_WIDTH * 0.5 - width * 0.5, Global.GAME_HEIGHT * 0.5 - height * 0.5);
        this._applyFloatAnchorOffset(sprite, 1, 0);
        return sprite;
    },
    floatRight: function floatRight(padding, sprite) {
        sprite = sprite || this;
        var width = sprite.getWidth ? sprite.getWidth() : sprite.width;
        if (typeof padding == 'undefined' || padding == null) {
            padding = this.DEFAULT_PADDING;
        }
        this._applyPositionChange(sprite, Global.GAME_WIDTH - width - padding, 0);
        this._applyFloatAnchorOffset(sprite, 1, 0);
        return sprite;
    },
    floatLeft: function floatLeft(padding, sprite) {
        sprite = sprite || this;
        if (typeof padding == 'undefined' || padding == null) {
            padding = this.DEFAULT_PADDING;
        }
        this._applyPositionChange(sprite, padding, 0);
        this._applyFloatAnchorOffset(sprite, 1, 0);
        return sprite;
    },
    floatTop: function floatTop(padding, sprite) {
        sprite = sprite || this;
        if (typeof padding == 'undefined' || padding == null) {
            padding = this.DEFAULT_PADDING;
        }
        this._applyPositionChange(sprite, 0, padding);
        this._applyFloatAnchorOffset(sprite, 0, 1);
        return sprite;
    },
    floatBottom: function floatBottom(padding, sprite) {
        sprite = sprite || this;
        var height = sprite.getHeight ? sprite.getHeight() : sprite.height;
        if (typeof padding == 'undefined' || padding == null) {
            padding = this.DEFAULT_PADDING;
        }
        this._applyPositionChange(sprite, 0, Global.GAME_HEIGHT - padding - height);
        this._applyFloatAnchorOffset(sprite, 0, 1);
        return sprite;
    },
    /** If the sprite's anchor is centered, apply additional offset */
    _applyFloatAnchorOffset: function _applyFloatAnchorOffset(sprite, xMult, yMult) {
        if (!sprite.anchor) return;
        xMult = xMult || 0;
        yMult = yMult || 0;
        if (sprite.anchor.x == 0.5 && sprite.anchor.y == 0.5) {
            var xOffset = sprite.width / 2 * xMult;
            var yOffset = sprite.height / 2 * yMult;
            this._applyPositionChange(sprite, xOffset, yOffset);
        }
    },
    /** Apply positional change depending with consideration for fixed Camera */
    _applyPositionChange: function _applyPositionChange(sprite, deltaX, deltaY) {
        deltaX = typeof deltaX == 'undefined' ? 0 : deltaX;
        deltaY = typeof deltaY == 'undefined' ? 0 : deltaY;
        if (sprite.fixedToCamera) {
            sprite.cameraOffset.x += deltaX;
            sprite.cameraOffset.y += deltaY;
        } else {
            sprite.x += deltaX;
            sprite.y += deltaY;
        }
    },
    /** Get relative position with consideration for fixed camera */
    _getPosition: function _getPosition(sprite) {
        if (sprite.fixedToCamera) {
            return {
                x: sprite.cameraOffset.x,
                y: sprite.cameraOffset.y
            };
        } else {
            return {
                x: sprite.x,
                y: sprite.y
            };
        }
    },

    /**
     * Relative floats to other sprites
     */
    leftOf: function leftOf(otherSprite, padding, thisSprite) {
        thisSprite = thisSprite || this;
        padding = padding || this.DEFAULT_PADDING;
        var otherPos = this._getPosition(otherSprite);
        this._applyPositionChange(thisSprite, otherPos.x - thisSprite.width - padding, otherPos.y);
        return thisSprite;
    },
    rightOf: function rightOf(otherSprite, padding, thisSprite) {
        thisSprite = thisSprite || this;
        padding = padding || this.DEFAULT_PADDING;
        var otherPos = this._getPosition(otherSprite);
        this._applyPositionChange(thisSprite, otherPos.x + otherSprite.width + padding, otherPos.y);
        return thisSprite;
    },
    topOf: function topOf(otherSprite, padding, thisSprite) {
        thisSprite = thisSprite || this;
        padding = padding || this.DEFAULT_PADDING;
        var otherPos = this._getPosition(otherSprite);
        this._applyPositionChange(thisSprite, otherPos.x, otherPos.y - otherSprite.height, -padding);
        return thisSprite;
    },
    bottomOf: function bottomOf(otherSprite, padding, thisSprite) {
        thisSprite = thisSprite || this;
        padding = padding || this.DEFAULT_PADDING;
        var otherPos = this._getPosition(otherSprite);
        this._applyPositionChange(thisSprite, otherPos.x, otherPos.y + otherSprite.height, +padding);
        console.log(thisSprite);
        console.log(otherSprite);
        return thisSprite;
    }
};
/**
 * Extend a class using extend(Class.prototype, withState)
 */
var WithState = {
    /**
     * Set the state
     * @param state {State}
     */
    setState: function setState(state) {
        if (this.state != null) {
            this.state.exit();
        }
        this.state = state;
        this.state.enter();
    },
    clearState: function clearState() {
        if (this.state != null) {
            this.state.exit();
        }
        this.state = null;
    },
    handleInput: function handleInput(game, inputState) {
        if (this.state) {
            this.state.handleInput(game, inputState);
        }
    }
};
/**
 * Helicopter support
 *  - call initHelicopterManager() first
 *
 *  - Must implement getHelicopterSpawnTiles(), createHelicopter()
 */
var HelicopterManagerMixin = {
    initHelicopterManager: function initHelicopterManager(dispatchNotifyKey) {
        if (!dispatchNotifyKey) throw new MissingArgsError();
        if (!this.getHelicopterSpawnTiles) {
            throw new Error("unimplemented getHelicopterSpawnTiles");
        }
        if (!this.dispatchHelicopter) {
            throw new Error("unimplemented dispatchHelicopter");
        }
        this._helis = [];
        this.onDispatchHeliNotification = dispatchNotifyKey;
    },
    dispatchHelicopters: function dispatchHelicopters() {
        var spawns = this.getHelicopterSpawnTiles();
        for (var i = 0, _max = spawns.length; i < _max; i++) {
            this.dispatchHelicopter(spawns[i]);
        }
        this.city.notifications.notify(this.onDispatchHeliNotification, null, true);
    },
    trackHelicopter: function trackHelicopter(h) {
        if (this._helis.indexOf(h) === -1) {
            this._helis.push(h);
        }
    },
    untrackHelicopter: function untrackHelicopter(h) {
        Utils.removeFromArray(this._helis, h);
    },
    getHeliCount: function getHeliCount() {
        return this._helis.length;
    }
};
var TILE_DIRECTION;
(function (TILE_DIRECTION) {
    TILE_DIRECTION[TILE_DIRECTION["HORIZONTAL"] = 0] = "HORIZONTAL";
    TILE_DIRECTION[TILE_DIRECTION["VERTICAL"] = 1] = "VERTICAL";
})(TILE_DIRECTION || (TILE_DIRECTION = {}));
var TileWithBoundedTexture = {
    // call super with this.boundTextures.SPRITESHEET first!
    // then call setDefaultFrameName
    setDefaultFrameName: function setDefaultFrameName() {
        if (!this.boundTextures) throw Error("prototype.boundTextures must be set");
        this.frameName = this.boundTextures.SINGLE_FRAME;
    },
    /** Returns whether the texture used is exactly a straight path - not intersection, not curve, not end piece */
    isStraightTexture: function isStraightTexture() {
        var frameBase = this['frameBase'] ? this['frameBase'] : this;
        var validFrames = [this.boundTextures.VERTICAL_FRAME, this.boundTextures.HORIZONTAL_FRAME];
        return validFrames.indexOf(frameBase.frameName) !== -1;
    },
    isVerticalStraightTexture: function isVerticalStraightTexture() {
        var frameBase = this['frameBase'] ? this['frameBase'] : this;
        return frameBase.frameName === this.boundTextures.VERTICAL_FRAME || frameBase.frameName === this.boundTextures.HORIZONTAL_FRAME && this.scale.x < 0;
    },
    isHorizontalStraightTexture: function isHorizontalStraightTexture() {
        var frameBase = this['frameBase'] ? this['frameBase'] : this;
        return frameBase.frameName === this.boundTextures.HORIZONTAL_FRAME || frameBase.frameName === this.boundTextures.VERTICAL_FRAME && this.scale.x < 0;
    },
    shouldConnectTextureBetween: function shouldConnectTextureBetween(boolTileState, row, col, size, offset, allowNesting) {
        var checkRow = row + offset[0];
        var checkCol = col + offset[1];
        if (!Utils.isValidIndex(checkRow, checkCol, size)) {
            return false;
        }
        if (!allowNesting && PathGraph.isTooNestedPath(boolTileState, { row: row, col: col }, { row: checkRow, col: checkCol }, size)) {
            return false;
        }
        return Boolean(boolTileState[checkRow][checkCol]);
    },
    isExtraDirectionANeighbor: function isExtraDirectionANeighbor(offsetRow, offsetCol, neighborCount) {
        return false;
    },
    setTextureWithMirrors: function setTextureWithMirrors(textureKey) {
        var frameBase = this['frameBase'] ? this['frameBase'] : this;
        if (this.boundTextures[textureKey]) {
            frameBase.frameName = this.boundTextures[textureKey];
            if (frameBase.scale.x < 0) {
                // no reverse
                frameBase.scale.x *= -1;
            }
        } else if (this.boundTextures.MIRRORS[textureKey]) {
            frameBase.frameName = this.boundTextures.MIRRORS[textureKey];
            if (frameBase.scale.x > 0) {
                // reverse x
                frameBase.scale.x *= -1;
            }
        }
    },
    isFramename: function isFramename(frameName) {
        if (this.scale.x < 0) {
            return this.frameName === this.boundTextures.MIRRORS[frameName];
        } else {
            return this.frameName === this.boundTextures[frameName];
        }
    },
    /**
     * Updates own texture based on neighboring road tiles
     * @param boolTileState {Boolean[][]} Boolean tilemap indicating where all neighboring tiles are.
     * @param allowNesting - allow nesting where inner tiles can connect to all neighbouring tiles
     */
    recalculateTexture: function recalculateTexture(boolTileState, allowNesting) {
        if (allowNesting === void 0) {
            allowNesting = false;
        }
        var frameBase = this['frameBase'] ? this['frameBase'] : this;
        var index = this.getIndex();
        var col = index.col;
        var row = index.row;
        var size = boolTileState.length;
        var hasUpperTile = this.shouldConnectTextureBetween(boolTileState, row, col, size, [-1, 0], allowNesting);
        var hasLowerTile = this.shouldConnectTextureBetween(boolTileState, row, col, size, [1, 0], allowNesting);
        var hasLeftTile = this.shouldConnectTextureBetween(boolTileState, row, col, size, [0, -1], allowNesting);
        var hasRightTile = this.shouldConnectTextureBetween(boolTileState, row, col, size, [0, 1], allowNesting);
        var neighborCount = 0;
        if (hasUpperTile) neighborCount += 1;
        if (hasLowerTile) neighborCount += 1;
        if (hasLeftTile) neighborCount += 1;
        if (hasRightTile) neighborCount += 1;
        if (!hasUpperTile) {
            hasUpperTile = this.isExtraDirectionANeighbor(-1, 0, neighborCount);
            if (hasUpperTile) neighborCount += 1;
        }
        if (!hasLowerTile) {
            hasLowerTile = this.isExtraDirectionANeighbor(1, 0, neighborCount);
            if (hasLowerTile) neighborCount += 1;
        }
        if (!hasLeftTile) {
            hasLeftTile = this.isExtraDirectionANeighbor(0, -1, neighborCount);
            if (hasLeftTile) neighborCount += 1;
        }
        if (!hasRightTile) {
            hasRightTile = this.isExtraDirectionANeighbor(0, 1, neighborCount);
            if (hasRightTile) neighborCount += 1;
        }
        // With textures for end tiles
        var possibleNeighbors = Utils._reuseFourTileExistObjects;
        possibleNeighbors[0][0] = hasUpperTile;
        possibleNeighbors[0][1] = "DOWN_FRAME";
        possibleNeighbors[1][0] = hasLowerTile;
        possibleNeighbors[1][1] = "UP_FRAME";
        possibleNeighbors[2][0] = hasLeftTile;
        possibleNeighbors[2][1] = "RIGHT_FRAME";
        possibleNeighbors[3][0] = hasRightTile;
        possibleNeighbors[3][1] = "LEFT_FRAME";
        var neighbors = Utils._reuseArr2;
        neighbors.length = 0;
        var n;
        for (var i = 0, max = possibleNeighbors.length; i < max; i++) {
            n = possibleNeighbors[i];
            if (n[0]) {
                neighbors.push(n);
            }
        }
        if (neighbors.length === 1) {
            this.setTextureWithMirrors(neighbors[0][1]);
        } else if (neighbors.length === 0) {
            this.setTextureWithMirrors("SINGLE_FRAME");
        } else if (neighbors.length === 2) {
            // Straight
            if (hasUpperTile && hasLowerTile) {
                this.setTextureWithMirrors("VERTICAL_FRAME");
            } else if (hasLeftTile && hasRightTile) {
                this.setTextureWithMirrors("HORIZONTAL_FRAME");
            }
            // Turns
            else if (hasLeftTile && hasUpperTile) {
                    this.setTextureWithMirrors("OPEN_TOP_LEFT_FRAME");
                } else if (hasRightTile && hasUpperTile) {
                    this.setTextureWithMirrors("OPEN_TOP_RIGHT_FRAME");
                } else if (hasLeftTile && hasLowerTile) {
                    this.setTextureWithMirrors("OPEN_BOTTOM_LEFT_FRAME");
                } else if (hasRightTile && hasLowerTile) {
                    this.setTextureWithMirrors("OPEN_BOTTOM_RIGHT_FRAME");
                }
        } else if (neighbors.length === 3) {
            // Three-way
            if (!hasLeftTile) {
                this.setTextureWithMirrors("CLOSED_LEFT_FRAME");
            } else if (!hasUpperTile) {
                this.setTextureWithMirrors("CLOSED_TOP_FRAME");
            } else if (!hasLowerTile) {
                this.setTextureWithMirrors("CLOSED_BOTTOM_FRAME");
            } else if (!hasRightTile) {
                this.setTextureWithMirrors("CLOSED_RIGHT_FRAME");
            }
        } else {
            // All-way
            this.setTextureWithMirrors("OPEN_FRAME");
        }
        if (this.afterRecalculateTexture) {
            this.afterRecalculateTexture();
        }
    }
};
/**
 * UI Namespace
 * @constructor
 */
var UI = function UI() {};
UI.prefabs = function () {};
UI.global = {
    "modals": [] // Reference to all open modal groups
};

//
// Modal management
//

/** Returns whether or not any modals are open */
UI.global.anyBlockingModalOpen = function () {
    return UI.global.modals.filter(function (m) {
        return m.visible && m.blocking;
    }).length > 0;
};

//
// Index attachments
//

/** Move to index */
UI.global.attachToIndex = function (sprite, index, offsetX, offsetY) {
    if (!index || !sprite) {
        throw new Error("missing args");
    }
    if (!index) {
        console.error("trying to position this modal to index, but no index was set");
    }
    Utils.setPositionToIndex(sprite, index.row, index.col);
    sprite.x += offsetX || 0;
    sprite.y += offsetY || 0;
};

/** Destroy global state */
UI.global.destroy = function () {
    UI.global.modals = [];
    UI.global.attachToIndex = [];
};
/**
 * Input Handler
 *
 * Applies various actions to a game instance using data from Phaser's inputs
 */
var InputHandler = function InputHandler() {};

/**
 * Process an input state
 * @param state - a general object that can contain any kind of info
 *              - up to implementer to decide what to pass and how to use
 */
InputHandler.prototype.processInput = function (state) {};
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Contains the city state and city mode.
 *
 * @param game
 * @param gameplayUI
 * @param hammer {Hammer}
 * @param size {integer}
 * @param [saveState] {JSON}
 * @constructor
 */
var City = /** @class */function (_super) {
    __extends(City, _super);
    function City(pocketCity, cityIndex, game, gameplayUI, hammer, size, saveState, onReadyCallback, isRandom, saveSnapshot, isSandbox, internalVersion, regionType, isNeighborCity, headlessMode) {
        if (isRandom === void 0) {
            isRandom = false;
        }
        if (isSandbox === void 0) {
            isSandbox = false;
        }
        if (internalVersion === void 0) {
            internalVersion = 0;
        }
        if (regionType === void 0) {
            regionType = Region.REGION_TYPES.PLAINS;
        }
        if (isNeighborCity === void 0) {
            isNeighborCity = false;
        }
        if (headlessMode === void 0) {
            headlessMode = false;
        }
        var _this = _super.call(this, game) || this;
        _this.autoSnapshots = [];
        _this.manualSnapshots = [];
        _this.ignoreSave = false;
        _this.tempUID = null;
        _this.emergenciesPaused = false;
        _this.headlessMode = false;
        _this.headlessModeCb = null;
        _this.buyLandMode = false;
        _this.buyLandIndices = [];
        _this.deregisterSignalHandlerNextTick = [];
        _this.finalCalculationCompleteDone = false;
        // When set to true, it will broadcast the event once and only once, so multiple signals are combined
        _this.signalOnceKeys = {
            "zones_updated": false
        };
        // Performance
        _this.lastFPS = [];
        _this.lastAvgFPS = 60;
        _this.isZoomedOutFar = false;
        _this.scaleDirtyTransform = 0;
        _this.tileMustForceTransform = {};
        _this._touchStart = 0;
        _this._touchUp = 0;
        _this._lastTouchDur = 0;
        // Zone related
        _this._usageCount = {};
        _this._usageCountUpgraded = {};
        _this._inspectingTile = null;
        _this._cameraTile = { col: 0, row: 0 };
        _this._globalResizing = false;
        // Timing
        _this._updateTickNum = 0;
        _this._trafficUpdateTimer = Global.UPDATE_TRAFFIC_EVERY;
        _this._slowUpdateFns = [];
        _this._trafficSortTimer = Traffic.SORT_CARS_EVERY;
        _this._tweensKillOnResize = [];
        _this.activePolicies = {};
        // Smart updates
        _this._smartUpdateTmpTimer = 0;
        _this._smartUpdate = true;
        _this._fixedSmartUpdate = true;
        _this._preserveSmartUpdateState = false;
        _this._shouldTransform = false;
        _this._forceStructureTransform = false;
        _this._checkNoConstructionTimer = 0;
        _this._animatingCameraKeepUdate = false;
        _this.cleanupOnOOB = [];
        _this._updateChildren = [];
        _this._prePostUpdate = []; // called full pre/update/post/transform on each tick
        _this._prePostUpdateNext = []; // only call full pre/update/post/transform on next tick
        _this._prePostLists = [];
        _this._extraRegisterForDestroy = [];
        // Grids to update visibility
        // only these ones will be culled
        _this.grids = {
            lowerTerrainGridLower: null,
            lowerTerrainGrid: null,
            waterTerrainGrid: null,
            lavaGrid: null,
            terrainGrid: null,
            tallTerrainGrid: null,
            zoneGridWhite: null,
            zoneGrid: null,
            waterGrid: null,
            waterUpperGrid: null,
            powerGrid: null,
            pollutionGrid: null,
            crimeGrid: null,
            trafficDensityGrid: null,
            roadShadowGrid: null,
            roadGrid: null,
            structureGrid: null,
            structureGridBuild: null,
            buildEffectGrid: null,
            buildGrid: null,
            skyRailGrid: null
        };
        _this.generalAutoDestroy = [];
        _this.busStopLayer = new BusStopLayer(_this);
        _this.focusingLayer = null;
        _this.commonTrafficUpdates = [];
        _this._pendingRoadTilesUpdate = null;
        _this.forceTransformTiles = {}; // no tiles update their own transforms unless smart update is set to it
        _this.forceTransformSprites = {}; // no tiles update their own transforms unless smart update is set to it
        _this.regionExtraIncome = 0;
        _this.centralCityIndex = -1;
        _this.centralCityLevel = 0;
        _this.maxNeighborLevel = 0;
        City.STRUCT_BASE_Y_CACHE = {};
        City.STRUCT_BASE_SCALE_CACHE = {};
        var desiredSnapshot = null;
        if (saveSnapshot) {
            desiredSnapshot = saveSnapshot;
        } else if (saveState) {
            desiredSnapshot = City.getLatestSnapshot(saveState);
        }
        var cityRNGSeed = null;
        if (desiredSnapshot && desiredSnapshot.rng) {
            cityRNGSeed = desiredSnapshot.rng;
        } else if (isRandom) {
            if (isNeighborCity) {
                console.log("using seed from central seed:", Region.temporaryNeighborInitData.centralCitySeed, "neighborindex:", Region.temporaryNeighborInitData.neighborRegionIndex);
                cityRNGSeed = Region.temporaryNeighborInitData.centralCitySeed + Region.temporaryNeighborInitData.neighborRegionIndex + 1;
            } else {
                cityRNGSeed = Utils.randomInt(1, 1000);
            }
        }
        if (!window['isProd']) {
            window['startLoadTime'] = performance.now();
        }
        _this.headlessMode = headlessMode;
        _this._loopInPostUpdate = [];
        CityPerformance.setPerformanceTime();
        _this.pocketCity = pocketCity;
        _this.cityIndex = Number(cityIndex);
        _this.isSandbox = isSandbox;
        game.time.events.start();
        _this._prePostLists = [_this._loopInPostUpdate, _this._prePostUpdateNext];
        // Necessary
        Utils.resetUtils(size);
        _this.isRandom = isRandom;
        var self = _this;
        _this.size = size;
        _this.game = game;
        _this.hammer = hammer;
        _this.createWindowInputs();
        _this.inputSignal = new Phaser.Signal();
        _this.refreshSignal = new Phaser.Signal();
        _this.buildSignal = new Phaser.Signal();
        _this.eventSignal = new Phaser.Signal();
        _this.cameraState = new CameraState(_this);
        _this.citySaveHelper = _this.withUpdateChild(new CitySaveHelper(_this));
        _this.cityScaler = _this.withUpdateChild(new CityScaler(_this));
        _this.danger = _this.withUpdateChild(new CityDanger(_this));
        _this.buildHelper = new BuildHelper(_this);
        _this.timedMoney = _this.withUpdateChild(new TimedMoney(_this));
        _this.gameplayUI = gameplayUI;
        _this.dialogue = new Dialogue(_this);
        _this.notifications = new Notifications(_this);
        _this.tutorial = new Tutorial(_this);
        _this.cityLevel = new CityLevels(_this);
        _this.resources = new Resources(_this);
        _this.rng = new Utils.RNG(cityRNGSeed || Global.TERRAIN_SEED);
        _this._rngSeed = cityRNGSeed;
        _this.audio = _this.withUpdateChild(new AudioPC(_this));
        _this.structureCache = new SpecialStructureCache(_this);
        _this.performance = _this.withUpdateChild(new CityPerformance(_this));
        _this.pincher = _this.withUpdateChild(new CityPincher(_this));
        // Metadata
        _this.metadata = City.defaultMetadata(_this.size);
        // Game statistics
        // will be loaded from existing snapshot later in the init. sequence
        _this.stats = City.defaultStats(_this.size, _this);
        _this.stats.internalVersion = internalVersion;
        _this.metrics = new CityMetrics(_this);
        _this.initialMetrics = false;
        // these need to be set right away so that terrain grid has right metadata
        _this.stats.regionType = regionType;
        if (desiredSnapshot && desiredSnapshot.stats.regionType) {
            _this.stats.regionType = desiredSnapshot.stats.regionType;
        }
        _this.stats.isNeighbor = isNeighborCity;
        if (desiredSnapshot && desiredSnapshot.stats.isNeighbor) {
            _this.stats.isNeighbor = desiredSnapshot.stats.isNeighbor;
        }
        // Sandbox attributes
        if (_this.isSandbox) {
            _this.metadata.isSandbox = true;
            _this.stats.level = 100;
            _this.stats.money = Global.SANDBOX_CASH;
            CityBlockUnlock.setUnlockAll(_this);
        }
        CityPerformance.printPerformanceTime("General variable initialization");
        gameplayUI._currentDialogCallback = null; // fix for frozen buy sometimes
        //
        // Layers
        //
        CityPerformance.setPerformanceTime();
        _this.initializeLayersAndGrids(cityRNGSeed, desiredSnapshot);
        CityPerformance.printPerformanceTime("Grid initialization");
        // Grids to update visibility
        // only these ones will be culled
        // note all traffic is culled by traffic managers, not auto cull
        _this.layersNeedVisibilityUpdates = [_this.unlockCashTextGroup, _this.grids.terrainGrid, _this.grids.tallTerrainGrid, _this.grids.roadShadowGrid, _this.grids.roadGrid, _this.grids.zoneGrid, _this.grids.structureGrid, _this.grids.lowerTerrainGridLower, _this.grids.lavaGrid, _this.grids.skyRailGrid, _this.grids.lowerTerrainGrid, _this.grids.waterTerrainGrid, _this.grids.terrainGrid.waterGrid, _this.grids.waterUpperGrid, _this.animalsLayer, _this.upperStructureLayer, _this.upperStructureEffects, _this.roadLowerEffects, _this.roadUpperEffects, _this.resourceNotificationLayer, _this.effectLayer, _this.boatsLayer, _this.busStopLayer];
        // verify
        if (Global.DEBUG_EXTRA_CULL_CHECK) {
            for (var g in _this.grids) {
                if (_this.grids.hasOwnProperty(g)) {
                    var grid = _this.grids[g];
                    if (g !== "zonegrid") {
                        // show some warnings, zonegrid is exempt
                        if (grid.culledVisibleChildren && self.layersNeedVisibilityUpdates.indexOf(grid) === -1) {
                            console.log("WARN: non-prod warn: grid has AUTO CULLING enabled but not registered in layersNeedVisibilityUpdates - culled sprites will remain invisible on move", g);
                        } else if (!grid.culledVisibleChildren && self.layersNeedVisibilityUpdates.indexOf(grid) !== -1) {
                            console.log("WARN: non-prod warn: grid does NOT have AUTO CULLING enabled but is registered in layersNeedVisibilityUpdates - unpredictable behaviour", g);
                        }
                    }
                }
            }
        }
        // Canvas Effects
        _this.cityEffects = _this.withUpdateChild(new CityEffects(_this));
        _this.cityEffects.addEmitterChildren();
        // The UI causes +10fps decrease
        _this.cityUI = new CityUIGroup(_this, _this.inputSignal);
        _this.add(_this.cityUI);
        _this.effectOverDarkLayer = new Phaser.Group(_this.game); // go overtop city ui dark layer
        // hide on zoomout zoom out
        _this.hiddenLayersOutZoom = [_this.upperStructureEffects, _this.grids.lowerTerrainGrid, _this.upperStructureLayer, _this.effectLayer, _this.constantEffectInnerLayer, _this.waterEffectsLayer, _this.constantEffectLayer, _this.grids.roadShadowGrid, _this.animalsLayer, _this.personLikeLayer, _this.resourceNotificationLayer, _this.iconEffectLayer].concat(_this.getTrafficRelatedLayers());
        _this._hiddenLayersOutZoomWhenBuild = [_this.iconEffectLayer];
        // hideforbuild hide during build
        _this.hiddenLayersBuild = [_this.speechLayer, _this.personLikeLayer, _this.animalsLayer, _this.skyLayer, _this.upperStructureLayer, _this.zoomoutMountainLayer, _this.tempUpperFireLayer, _this.constantEffectInnerLayer, _this.waterEffectsLayer, _this.constantEffectLayer, _this.upperStructureEffects];
        _this.cacheableLayersOutZoom = [_this.grids.structureGrid, _this.grids.lowerTerrainGrid, _this.grids.waterTerrainGrid, _this.grids.lavaGrid, _this.grids.terrainGrid, _this.grids.tallTerrainGrid, _this.grids.zoneGrid, _this.grids.roadGrid, _this.grids.terrainGrid.waterGrid, _this.grids.waterUpperGrid, _this.grids.terrainGrid.sandGrid];
        CityPerformance.setPerformanceTime();
        //
        // Child order
        //
        // Inputs
        _this.cameraInputHandler = new CityInputs.CameraInput(_this);
        // State
        _this.setCameraState();
        // Update game size to fit screen
        _this.initScaleScreen();
        CityPerformance.printPerformanceTime("camera components");
        CityPerformance.setPerformanceTime();
        //
        // Object caches
        //
        _this.rubblePool = new RubblePool(_this);
        _this.whiteTilePool = new WhiteTilePool(_this);
        _this.residentialTilePool = new ResidentialTilePool(_this);
        _this.industrialTilePool = new IndustrialTilePool(_this);
        _this.commercialTilePool = new CommercialTilePool(_this);
        _this.roadTilePool = new RoadTilePool(_this);
        _this.rubbleTilePool = new RubbleTilePool(_this);
        _this.demolishTilePool = new DemolishTilePool(_this);
        _this.structureTilePool = new StructureTilePool(_this);
        //
        // Create components
        //
        CityPerformance.printPerformanceTime("sprite pools");
        CityPerformance.setPerformanceTime();
        // Traffic
        _this.roadGraph = new RoadGraph(_this);
        _this.sidewalkGraph = new SidewalkGraph(_this);
        _this.cyclingGraph = new CyclingGraph(_this);
        _this.highwayInnerGraph = new HighwayInnerGraph(_this);
        _this.highwayOuterGraph = new HighwayOuterGraph(_this);
        _this.skyRailGraph = new SkyRailGraph(_this);
        _this.trafficGraphs = [_this.roadGraph, _this.sidewalkGraph, _this.cyclingGraph, _this.highwayInnerGraph, _this.highwayOuterGraph];
        _this.traffic = new CarTraffic(_this);
        _this.pedestrians = new Pedestrians(_this);
        _this.sidewalkAnimals = new SidewalkAnimals(_this);
        _this.cyclingTraffic = new CyclingTraffic(_this);
        _this.skyRailTraffic = new SkyRailTraffic(_this);
        _this.cosmeticPeds = new CosmeticPeds(_this);
        CityPerformance.printPerformanceTime("traffic graphs and managers");
        CityPerformance.setPerformanceTime();
        _this.trafficDensity = _this.withUpdateChild(new TrafficDensity(_this));
        CityPerformance.printPerformanceTime("traffic density");
        CityPerformance.setPerformanceTime();
        // Force refresh for initial grid bitmap caching
        self.refreshSignal.dispatch("refresh_bitmap_cache");
        _this.registerSignalHandler("upper_structure_layer_refresh", function () {
            _this.applyGridVisibility();
        });
        CityPerformance.printPerformanceTime("registering handlers");
        CityPerformance.setPerformanceTime();
        // General managers
        _this.boatManager = _this.withUpdateChild(new BoatManager(_this));
        _this.animalManager = new AnimalManager(_this);
        _this.droneManager = new DroneManager(_this);
        // Disasters
        _this.fireManager = _this.withUpdateChild(new FireManager(_this)); // legacy but still used
        _this.fireEmergencyManager = _this.withUpdateChild(new FireEmergencyManager(_this));
        _this.crime = _this.withUpdateChild(new Crime(_this));
        // Speech
        _this.citySpeech = _this.withUpdateChild(new CitySpeech(_this));
        CityPerformance.printPerformanceTime("Animals and disasters");
        // Load existing city (either saved or seed)
        if (saveState) {
            console.log("loading save state");
            CityPerformance.setPerformanceTime();
            _this.loadSaveState(saveState, desiredSnapshot);
            CityPerformance.printPerformanceTime("Save state loading");
        }
        //
        // Touch inputs
        //
        _this.initTouchInputs();
        _this.initCallbackIntervals();
        // Game mechanics
        _this.quests = new Quests(_this);
        _this.events = _this.withUpdateChild(new Events(_this));
        // additional visibility checks
        _this.constantEffectInnerLayer.additionalHideZoomCondition = function () {
            return !_this.events.isVolcanoSpawning();
        };
        _this.constantEffectLayer.additionalHideZoomCondition = function () {
            return !_this.events.isVolcanoSpawning();
        };
        _this.effectLayer.additionalHideZoomCondition = function () {
            return !_this.events.isVolcanoSpawning();
        };
        // Visibility hide on layer (subset, not all)
        _this.hideDuringFocus = [_this.grids.structureGrid, _this.upperStructureLayer, _this.tempUpperFireLayer, _this.upperStructureEffects, _this.grids.tallTerrainGrid,
        // entities
        _this.busStopLayer, _this.personLikeLayer, _this.animalsLayer,
        // effects
        _this.effectLayer, _this.boatsLayer, _this.waterEffectsLayer, _this.constantEffectLayer, _this.constantEffectInnerLayer, _this.constantEffectNoHide, _this.effectOverDarkLayer, _this.upperStructureEffects, _this.roadLowerEffects, _this.roadInnerPersonlikeLayer, _this.roadUpperEffects,
        // ui indicators
        _this.resourceNotificationLayer];
        // Final next tick initialization
        _this.ready = false;
        CityPerformance.printPerformanceTime("done all before onready");
        _this.smartUpdateNext();
        console.log("registering safe timeout", _this.cityIndex);
        _this.registerSafeTimeout(function () {
            console.log("executing safe timeout", self.cityIndex);
            if (!self.game) return;
            CityPerformance.setPerformanceTime();
            self.metrics.updateVisuals = true;
            self.metrics.syncAllUIStats();
            CityPerformance.printPerformanceTime("UI sync");
            var afterCalcRegionIncome = function afterCalcRegionIncome() {
                // calculate heavy stuff
                CityPerformance.setPerformanceTime();
                self.calculateAllStates();
                CityPerformance.printPerformanceTime("Calculating all states");
                self.pocketCity.canvasResizer.onCityReady();
                // Start new random city
                // initialize random structure if needed
                self.initStructureCameraEase(saveState);
                self.buildGridBg.visible = false;
                self.ready = true;
                self.refreshSignal.dispatch("city_ready");
                // fixes high fps
                self.initFixUpperSpriteGlitch();
                self.smartUpdateNext();
                self.initHighestLvUnlocks();
                if (onReadyCallback) {
                    if (!window['isProd']) {
                        console.log("READY LOAD COMPLETE:", performance.now() - window['startLoadTime']);
                    }
                    onReadyCallback();
                }
                if (!window['isProd']) {
                    Debug(self);
                }
                if (!_this.stats.regions) {
                    console.error("no regions defined");
                }
                if (!_this.stats.policies) {
                    console.error("no policies defined");
                }
                console.log("number of city tiles saved:", _this.stats.numTiles);
            };
            if (_this.headlessMode) {
                afterCalcRegionIncome();
            } else {
                var centralIndexOverride = Region.temporaryNeighborInitData ? Region.temporaryNeighborInitData.centralIndex : null;
                Region.getRegionMetadataAsyncAsync(Number(cityIndex), self, function (income, centralCityLevel, maxNeighborLevel, centralCityIndex) {
                    if (!self.game) {
                        return;
                    }
                    self.centralCityIndex = centralCityIndex;
                    self.regionExtraIncome = Math.ceil(income * Region.INCOME_SHARE_PERCENT);
                    self.centralCityLevel = centralCityLevel;
                    self.maxNeighborLevel = maxNeighborLevel;
                    afterCalcRegionIncome();
                }, centralIndexOverride);
            }
        }, 0);
        return _this;
    }
    // registers entity to be updated each tick
    City.prototype.withUpdateChild = function (component) {
        this._updateChildren.push(component);
        return component;
    };
    City.prototype.withPrePost = function (component, noAnimPastZoom) {
        // always pre/postupdate
        // Sprites to update each time, should add and remove temporarily sprites that need updates
        // Note - these sprites may be double updated, so do not keep sprites in here too much
        this._prePostUpdate.push(component);
        if (noAnimPastZoom) {
            component.noAnimPastZoom = noAnimPastZoom;
        }
        return component;
    };
    City.prototype.destroyOnCityDestroy = function (sprite) {
        this._extraRegisterForDestroy.push(sprite);
    };
    City.prototype.initializeLayersAndGrids = function (cityRNGSeed, savedSnapshot) {
        var _this = this;
        if (cityRNGSeed === void 0) {
            cityRNGSeed = null;
        }
        // CULL note: all traffic is culled by traffic managers, not auto cull - so that pool is reused
        this.drivingLayer = new PerformantUpdateGroup(this, 2, 0, true);
        this.boatsLayer = new TrackCulledChildrenLayer(this);
        this.waterEffectsLayer = new Phaser.Group(this.game);
        this.rubbleLayer = new Phaser.Group(this.game);
        this.quakeLayer = new Phaser.Group(this.game);
        this.quakeLayer.visible = false;
        this.vehicleLikeLayer = new VehicleLikeGroup(this);
        this.drivingUpperLayer = new PerformantUpdateGroup(this, 2, 0, true);
        this.drivingHoverLayer = new PerformantUpdateGroup(this, 2, 0, true);
        this.drivingParkLowerLayer = new Phaser.Group(this.game);
        this.drivingParkUpperLayer = new Phaser.Group(this.game);
        this.pedestriansLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_LOWER_PEDS_AT_ZOOM, true), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.pedestriansUpperLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_UPPER_PEDS_AT_ZOOM, true), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.waterFloodSprites = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_UPPER_PEDS_AT_ZOOM, true), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.sidewalkAnimalsLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_LOWER_PEDS_AT_ZOOM), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.sidewalkAnimalsUpperLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_UPPER_PEDS_AT_ZOOM), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.cyclingLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_CYCLE_AT_ZOOM, true), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.cyclingUpperLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, Global.HIDE_CYCLE_AT_ZOOM, true), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.skyRailUpperLayer = new SmartUpdateLayer(this);
        this.skyRailCarLayer = this.withPrePost(new PerformantUpdateGroup(this, 3, 0, true), Global.NO_ANIM_UPDATE_PAST_ZOOM); // does this need to be updated less?
        this.skyRailCarLayer.name = "skyRailCarLayer";
        this.personLikeLayer = this.withPrePost(new AutoResizeGroup(this), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.animalsLayer = this.withPrePost(new TrackCulledChildrenLayer(this, false, true), Global.NO_ANIM_UPDATE_PAST_ZOOM);
        this.tmpFocusLayer = new Phaser.Group(this.game);
        this.effectLayer = new TrackCulledChildrenLayer(this);
        this.buildEffectLayer = new Phaser.Group(this.game);
        this.buildEffectLayer.visible = false;
        this.iconEffectLayer = new Phaser.Group(this.game);
        this.iconEffectLayer.zoomHideCutoff = 0.2;
        this.constantEffectInnerLayer = new Phaser.Group(this.game);
        this.constantEffectLayer = new Phaser.Group(this.game);
        this.constantEffectNoHide = new Phaser.Group(this.game);
        this.constantEffectMostTop = new Phaser.Group(this.game);
        this.speechLayer = new Phaser.Group(this.game);
        this.resourceNotificationLayer = new ResourceLayer(this); // maybe we can get some fps if we don't tween and set to smart update
        this.smileyLayer = new Phaser.Group(this.game);
        this.buildGridBg = this.createBuildGridBg();
        this.upperStructureLayer = new StructureLayer(this);
        this.upperStructureLayer.name = "upper structure layer";
        this.smallStructureLayer = new SmStructureLayer(this);
        this.zoomoutMountainLayer = new Phaser.Group(this.game);
        this.tempUpperFireLayer = new SmStructFireLayer(this);
        this.cityStructureScaler = new CityStructureScaler(this);
        this.upperStructureEffects = new TrackCulledChildrenLayer(this, false, true);
        this.roadLowerEffects = new TrackCulledChildrenLayer(this, false, true);
        this.roadInnerPersonlikeLayer = new Phaser.Group(this.game);
        this.roadUpperEffects = new TrackCulledChildrenLayer(this, false, true);
        this.busStopLayer = new BusStopLayer(this);
        this.overlayGroup = new SmartUpdateLayer(this);
        this.unlockSignGroup = new Phaser.Group(this.game);
        this.unlockCashTextGroup = new TrackCulledChildrenLayer(this);
        this.skyLayer = this.withPrePost(new AutoResizeGroup(this));
        // Grids - remember to call addChild on them too
        this.grids.lowerTerrainGridLower = new Grid(this, this.size, this.windowInput);
        this.grids.lowerTerrainGrid = new Grid(this, this.size, this.windowInput);
        this.grids.waterTerrainGrid = new GridUpdateChildrenEachTick(this, this.size, this.windowInput);
        this.grids.waterTerrainGrid.name = "water terrain grid";
        this.grids.waterTerrainGrid._autoSmartUpdate = true;
        this.grids.lavaGrid = new Grid(this, this.size, this.windowInput);
        // null seed means default grid
        this.grids.terrainGrid = new TerrainGrid(this, this.size, this.windowInput, cityRNGSeed);
        this.grids.tallTerrainGrid = new TallTerrainGrid(this, this.size, this.windowInput);
        this.grids.zoneGridWhite = new Grid(this, this.size, this.windowInput);
        this.grids.zoneGrid = new ZoneGrid(this, this.size, this.windowInput);
        this.hideZoneGrid();
        this.grids.waterGrid = new WaterGrid(this, this.size, this.windowInput);
        this.grids.powerGrid = new PowerGrid(this, this.size, this.windowInput);
        this.grids.pollutionGrid = new PollutionGrid(this, this.size, this.windowInput);
        this.grids.crimeGrid = new CrimeGrid(this, this.size, this.windowInput);
        this.grids.trafficDensityGrid = new Grid(this, this.size, this.windowInput, null, null, true);
        this.grids.trafficDensityGrid.visible = false;
        this.grids.roadShadowGrid = new Grid(this, this.size, this.windowInput);
        this.grids.roadGrid = new RoadGrid(this, this.size, this.windowInput);
        this.grids.structureGrid = new StructureGrid(this, this.size, this.windowInput);
        this.grids.structureGridBuild = new Grid(this, this.size, this.windowInput, null, null, true);
        this.grids.buildEffectGrid = new Grid(this, this.size, this.windowInput, null, true, true);
        this.grids.buildGrid = new BuildGrid(this, this.size, this.windowInput, this.inputSignal);
        this.grids.skyRailGrid = new SkyRailGrid(this, this.size, this.windowInput);
        this.grids.waterUpperGrid = new Grid(this, this.size, this.windowInput);
        this.grids.structureGrid.name = "structuregrid";
        this.grids.structureGridBuild.name = "structurebuildgrid";
        this.grids.buildEffectGrid.name = "buildeffectgrid";
        this.dayNightCycle = this.withUpdateChild(new CityDayNight(this));
        this.smileyHelper = new SmileyHelper(this);
        // Force update always grids:
        // non - heavy grids that should always update in sync
        this.grids.buildEffectGrid._autoSmartUpdate = false;
        this.grids.buildGrid._autoSmartUpdate = false;
        this.grids.structureGridBuild._autoSmartUpdate = false;
        [this.roadLowerEffects, this.roadUpperEffects, this.upperStructureEffects].forEach(function (layer) {
            layer._autoSmartUpdate = false;
            layer._shouldTransform = true;
            _this.pushForcePrePostUpdateSprite(layer);
        });
        // Transform force only required for sprites with frames
        this.pushForcePrePostUpdateSprite(this.constantEffectLayer);
        this.pushForcePrePostUpdateSprite(this.iconEffectLayer);
        this.pushForcePrePostUpdateSprite(this.constantEffectInnerLayer);
        this.pushForcePrePostUpdateSprite(this.constantEffectNoHide);
        this.pushForcePrePostUpdateSprite(this.roadInnerPersonlikeLayer);
        this.pushForcePrePostUpdateSprite(this.constantEffectMostTop);
        // Add to game scene in right order
        this.addChild(this.grids["lowerTerrainGridLower"]);
        this.addChild(this.rubbleLayer);
        this.addChild(this.grids["lowerTerrainGrid"]);
        this.addChild(this.quakeLayer);
        this.addChild(this.grids["waterTerrainGrid"]);
        this.addChild(this.grids["lavaGrid"]);
        this.addChild(this.grids["zoneGrid"]);
        this.addChild(this.grids["zoneGridWhite"]);
        this.addChild(this.grids["structureGrid"]);
        this.addChild(this.waterEffectsLayer);
        this.addChild(this.boatsLayer);
        this.addChild(this.grids["roadShadowGrid"]);
        this.addChild(this.grids["roadGrid"]);
        this.addChild(this.grids["waterGrid"]);
        this.addChild(this.grids["powerGrid"]);
        this.addChild(this.grids["trafficDensityGrid"]);
        this.addChild(this.grids["crimeGrid"]);
        this.addChild(this.grids["pollutionGrid"]);
        this.addChild(this.buildGridBg);
        this.addChild(this.grids["buildGrid"]);
        this.addChild(this.grids["buildEffectGrid"]);
        this.addChild(this.buildEffectLayer);
        this.addChild(this.grids["terrainGrid"]);
        this.addChild(this.sidewalkAnimalsLayer);
        this.addChild(this.personLikeLayer);
        this.addChild(this.pedestriansLayer);
        this.addChild(this.cyclingLayer);
        this.addChild(this.busStopLayer); // between sidewalk and road
        this.addChild(this.drivingParkLowerLayer);
        this.addChild(this.roadLowerEffects);
        this.addChild(this.roadInnerPersonlikeLayer);
        this.addChild(this.drivingLayer);
        this.addChild(this.vehicleLikeLayer);
        this.addChild(this.drivingUpperLayer);
        this.drivingUpperLayer.name = "upper driving";
        this.addChild(this.drivingParkUpperLayer);
        this.addChild(this.animalsLayer);
        this.addChild(this.cyclingUpperLayer);
        this.addChild(this.drivingHoverLayer);
        this.addChild(this.grids["skyRailGrid"]); // sky rail supports
        this.addChild(this.sidewalkAnimalsUpperLayer);
        this.addChild(this.pedestriansUpperLayer);
        this.pedestriansUpperLayer.visible = false;
        this.pedestriansUpperLayer.name = "upper peds";
        this.pedestriansLayer.name = "lower peds";
        this.addChild(this.grids.tallTerrainGrid);
        this.addChild(this.smallStructureLayer);
        this.addChild(this.roadUpperEffects);
        this.addChild(this.constantEffectInnerLayer); // put effects here that go ontop of own lower builing but doesnt need to go ontop of upper structure (or other layers)
        this.addChild(this.skyRailUpperLayer);
        this.addChild(this.skyRailCarLayer);
        this.addChild(this.waterFloodSprites);
        this.addChild(this.grids["waterUpperGrid"]);
        this.addChild(this.upperStructureLayer); // masks + child FX - put effects onto StructureUpperMaskSprite if they need to overlap adjecent upper buildings (And force update)
        this.addChild(this.upperStructureEffects); // only put effects here if they can overlap ALL buildings
        this.addChild(this.tempUpperFireLayer);
        this.addChild(this.zoomoutMountainLayer);
        this.addChild(this.resourceNotificationLayer);
        this.addChild(this.grids["structureGridBuild"]);
        this.addChild(this.effectLayer);
        this.addChild(this.iconEffectLayer);
        this.addChild(this.constantEffectLayer); //effects that need to be updated each tick
        this.addChild(this.constantEffectNoHide);
        this.addChild(this.tmpFocusLayer);
        // iu-2 atlas
        this.addChild(this.overlayGroup);
        this.addChild(this.unlockSignGroup);
        this.addChild(this.unlockCashTextGroup);
        this.addChild(this.skyLayer); // sky weather (probably not planes)
        this.addChild(this.speechLayer);
        this.addChild(this.constantEffectMostTop);
        this.addChild(this.smileyLayer);
        this.generalAutoDestroy = [this.grids.terrainGrid, this.grids.tallTerrainGrid, this.grids.zoneGrid, this.grids.roadGrid, this.grids.skyRailGrid];
        if (!Global.DEBUG_DISABLE_TERRAIN) {
            CityPerformance.setPerformanceTime();
            this.grids.terrainGrid.initializeTerrain(savedSnapshot);
            CityPerformance.printPerformanceTime("Initialized terrain");
        }
        this.initPostAddChildren();
    };
    City.prototype.calculateAllStates = function () {
        var _this = this;
        CityPerformance.setPerformanceTime();
        Policy.syncActivePolicies(this);
        // special structures
        this.structureCache.sync();
        // load skin if needed
        var thFrame = this.citySaveHelper.getGlobalSetting(TownHallHelper.GLOB_SETTING_TH_FRAME);
        if (thFrame) {
            this.grids.structureGrid.townHallHelper.setCustomSkin(thFrame);
        }
        CityPerformance.printPerformanceTime("structureCache.sync()", true);
        // update resource coverage
        this.grids.waterGrid.updateCommittedBoolTiles();
        this.grids.powerGrid.updateCommittedBoolTiles();
        this.resources.recalculate(true);
        CityPerformance.printPerformanceTime("resource calculation", true);
        // prepare traffic
        var roadTiles = this.grids.roadGrid.getBooleanGrid(0);
        this.grids.roadGrid.recalculateRoadTilesExact(roadTiles);
        CityPerformance.printPerformanceTime("road tiles calc", true);
        this.trafficGraphs.forEach(function (g) {
            return g.updateGraph(roadTiles);
        });
        CityPerformance.printPerformanceTime("road graph calc", true);
        [this.pedestrians, this.traffic, this.cyclingTraffic].forEach(function (l) {
            return l.refreshValidSpawns();
        });
        this.skyRailTraffic.onInitCalc(); // also sorts road grid y initially
        CityPerformance.printPerformanceTime("initialize random traffic", true);
        this.grids.pollutionGrid.sync();
        CityPerformance.printPerformanceTime("pollution sync", true);
        this.grids.crimeGrid.sync();
        CityPerformance.printPerformanceTime("initial crime sync", true);
        // Initial metric
        this.metrics.updateMetrics();
        this.initialMetrics = true;
        CityPerformance.printPerformanceTime("update metrics", true);
        // re-calculate metric
        // force density calculations to happen fast
        this.skyRailTraffic._recalculateSpawnLinksExec();
        this.trafficDensity.forceNoCalculationDelay();
        CityPerformance.printPerformanceTime("traffic pt 2");
        this.busStopLayer.updateCoverageGrid();
        this.trafficDensity.updateParkingGarageCoverage();
        this.trafficDensity.updateHighwayConnectedToRoadCoverage();
        this.trafficDensity.updateTrafficDensityByZonesSlow(function () {
            if (!_this.game) return;
            CityPerformance.setPerformanceTime();
            _this.trafficDensity.ensureTrafficDensityGridTilesUpdated();
            CityPerformance.printPerformanceTime("initialize animals", true);
            _this.trafficDensity.setDefaultCalculationDelay();
            _this.refreshSignal.dispatch("refresh_traffic_desired_updated");
            _this.metrics.updateMetrics();
            CityPerformance.printPerformanceTime("refreshed and update metrics", true);
            // calculate desiredness now that traffic density is ready
            _this.traffic.refreshCachedDesiredSpawn(true);
            CityPerformance.printPerformanceTime("traffic desired spawn calc", true);
            _this.pedestrians.refreshCachedDesiredSpawn(true);
            CityPerformance.printPerformanceTime("pedestrians desired spawn calc", true);
            // post update metrics
            _this.crime.initEventTime();
            _this.fireEmergencyManager.initEventTime();
            CityPerformance.printPerformanceTime("subsequent crime sync");
            // ensure sky rail up to date
            if (!_this.headlessMode) {
                _this.delayEventWithCityCheck(1000, function () {
                    _this.skyRailTraffic.refreshUpperStationEffects();
                });
            }
            _this.grids.zoneGrid.initialRefreshDone = false;
            _this.refreshResourceNotifications();
            _this.grids.crimeGrid.sync();
            if (_this.headlessMode) {
                _this.metrics.updateMetrics(); // intentional to call updateMetrics twice
                if (_this.headlessModeCb) {
                    _this.headlessModeCb();
                    _this.headlessModeCb = null;
                } else {
                    setTimeout(function () {
                        if (_this.headlessModeCb) {
                            _this.headlessModeCb();
                            _this.headlessModeCb = null;
                        }
                    }, 0);
                }
                return;
            } else {
                // update just police part of metrics
                _this.metrics.updateSafetyCrime();
                _this.metrics.happinessRefresh();
                if (_this.metrics.happiness < 0) {
                    _this.metrics.happiness = 0;
                }
            }
            // ensure busses up to date
            _this.busStopLayer._onRoadsOrBusStopChange();
            // Fix initial sorting issue
            _this.sortAllStructures();
            _this.applyGridVisibility();
            _this.smartUpdateNext();
            if (_this.finalCalculationComplete) {
                // because this isn't guaranteed to be async
                setTimeout(function () {
                    _this.finalCalculationComplete();
                }, 0);
            }
            _this.finalCalculationCompleteDone = true;
            _this.smileyHelper.restartAnim();
            _this.resourceNotificationLayer.restartAnim();
        });
        this.commonTrafficUpdates = [this.traffic, this.pedestrians, this.cyclingTraffic, this.skyRailTraffic, this.sidewalkAnimals];
        this.initSyncVariousGroups();
    };
    City.prototype.onFinalCalculationComplete = function (cb) {
        if (this.finalCalculationCompleteDone) {
            cb();
        } else {
            this.finalCalculationComplete = cb;
        }
    };
    City.prototype.replaceAllSnapshotMoney = function (newAmount) {
        this.stats.money = newAmount;
        this._replaceAllMoneyInSnapshots(this.autoSnapshots, newAmount);
        this._replaceAllMoneyInSnapshots(this.manualSnapshots, newAmount);
    };
    City.prototype._replaceAllMoneyInSnapshots = function (snapshotArr, newAmount) {
        snapshotArr.forEach(function (snapshot) {
            snapshot.stats.money = newAmount;
        });
    };
    City.prototype.createWindowInputs = function () {
        this.windowInput = new WindowInputSprite(this, 0);
        this.windowDisabledInput = new WindowInputSprite(this, 1);
    };
    City.prototype.initScaleScreen = function () {
        this.pocketCity.canvasResizer.refreshDimensionRatio();
        this.cityScaler.scaleScreenToCity();
        this.cityScaler.zoomTo(this.cityScaler.getDefaultZoom(), true, false);
    };
    City.prototype.initTouchInputs = function () {
        var _this = this;
        var self = this;
        CityPerformance.setPerformanceTime();
        this.windowInput.inputSprite.events.onInputDown.add(function () {
            //console.log("window input down:",self.metadata.name);
            if (!self.ready) return;
            self._touchStart = Utils.getGameMillis(self.game);
            self._isInputDown = true;
            //
            // Inspect check
            // attempt to touch direct tile, then tiles near slight offsets if direct not found
            //
            self.cameraState._inspectTileIfNoCameraMove = null;
            self.cameraInputHandler.movedCameraPastTouchThreshold = false;
            var tile = null;
            var testOffsets = [0, -0.6, 0.2];
            var touchIndex;
            var length = self.grids.zoneGrid.tiles.length;
            for (var i = 0; i < testOffsets.length; i++) {
                touchIndex = Grid.currentTouchedIndex(self, self.getTileSize(), testOffsets[i]);
                if (!touchIndex || touchIndex.row < 0 || touchIndex.row >= length || touchIndex.col < 0 || touchIndex.col >= length || !self.grids.zoneGrid.tiles[touchIndex.row]) {
                    continue;
                }
                tile = self.grids.zoneGrid.tiles[touchIndex.row][touchIndex.col];
                if (tile) {
                    break;
                }
            }
            self.cameraState._inspectTileIfNoCameraMove = tile || null;
            _this.touchedUnlock = self.getTouchedUnlock();
            _this.touchedChest = self.getTouchedChest();
            _this.smileyHelper.touchedSmiley = self.smileyHelper.getTouchedSmiley();
            self.cameraState.zoomOnTouchDown = _this.scale.x;
            // hide inspection check
            self.gameplayUI.handleTouchDownWindow();
            self.smartUpdateNext();
        });
        this.windowInput.inputSprite.events.onInputUp.add(function () {
            if (!self.ready) return;
            if (self.game.input.totalActivePointers >= 1) {
                // partially fixes the jump
                self.cameraInputHandler.lastDrag = null;
                self.cameraInputHandler.clearDeltas();
                self.game.input.activePointer = null;
                return;
            }
            self._touchUp = Utils.getGameMillis(self.game);
            self._lastTouchDur = self._touchUp - self._touchStart;
            self._isInputDown = false;
            // Check if we are touching chest or smiley icon
            var foundChest = false;
            var acquiredSmileyRewards = false;
            if (!_this.isBuildingState() && self._lastTouchDur < 1000 && !self.cameraInputHandler.movedCameraPastTouchThreshold && !_this.tutorial.tutorialActive) {
                if (_this.touchedUnlock) {
                    var touchedUnlock = self.getTouchedUnlock();
                    if (_this.touchedUnlock === touchedUnlock) {
                        CityBlockUnlock.triggerUnlockAreaPressed(_this, touchedUnlock);
                    }
                } else if (_this.touchedChest) {
                    var touchedChest_1 = self.getTouchedChest(); // touched chest on liftup
                    if (touchedChest_1 && !touchedChest_1._opened && _this.touchedChest === touchedChest_1) {
                        Utils.tweenPressed(self.game, touchedChest_1, 0);
                        // If not locked, show speech instead
                        if (_this.isUnlockedTile(touchedChest_1.row, touchedChest_1.col)) {
                            touchedChest_1._opened = true;
                            // let the button press animation play for a second
                            _this.registerSafeTimeout(function () {
                                AudioPC.playUISuccessChime();
                                touchedChest_1.openAndGetReward();
                            }, 450);
                            foundChest = true;
                        } else {
                            _this.notifications.notify("locked-chest");
                        }
                    }
                } else if (_this.smileyHelper.touchedSmiley) {
                    var smiley = self.smileyHelper.getTouchedSmiley(true);
                    if (smiley) {
                        self.smileyHelper.acquireSprite(smiley);
                        acquiredSmileyRewards = true;
                    }
                }
            }
            // check if we are clicking smiley bubble
            // Check if we need to inspect
            if (!Global.DEBUG_DISABLE_INSPECT && self.cameraState._inspectTileIfNoCameraMove && self.isCameraState() && self._lastTouchDur < Global.INSPECT_TILE_TOUCH_TIME_DELTA_MAX && !foundChest && !MainUI.Move.isMoveMode && !acquiredSmileyRewards) {
                var tile = self.cameraState._inspectTileIfNoCameraMove;
                if (tile && tile._master) {
                    tile = tile._master;
                }
                // Inspect tile if we can
                if (tile && tile.structureGroup && tile._completed && self.game.input.totalActivePointers < 2 && (!_this.focusingLayer || _this._inspectingTile === tile)) {
                    self.toggleInspectTile(tile);
                } else if (self.gameplayUI.inspectingTile()) {
                    self.gameplayUI.showDefaultView();
                }
                self.cameraState._inspectTileIfNoCameraMove = null;
            } else if (self.gameplayUI.inspectingTile() && !self.cameraInputHandler.movedCameraPastTouchThreshold && self.cameraState.zoomOnTouchDown == _this.scale.x) {
                // this uninspects. we don't want to uninspect always because we may want to preserve inspect when viewing pollution grid or other view when dragging
                self.gameplayUI.showDefaultView();
            }
            self.smartUpdateNext();
        });
        CityPerformance.printPerformanceTime("registered ontouch handlers", true);
    };
    City.prototype.initCallbackIntervals = function () {
        var _this = this;
        var self = this;
        // update non-phaser components, autoupdate auto-update updates
        this._updateChildren.push(this.gameplayUI.streamingDialog);
        this._updateChildren.push(this.structureCache);
        this._updateChildren.push(this.buildHelper);
        // Timers
        this.registerCallbackUpdateEvery(function () {
            _this.refreshSignal.dispatch("refresh_traffic_desired_updated");
        }, Traffic.REFRESH_SPAWN_DESIRED_EVERY);
        // hack to fix weird offset notification issue, remove or make longer if causing performance issues
        this.registerCallbackUpdateEvery(function () {
            if (_this.resourceNotificationLayer.visible) {
                _this.refreshResourceNotifications();
            }
            _this.smileyHelper.checkUpdate();
        }, 1000);
        this.busStopLayer.initListeners();
        // spawn plane once in a while
        Plane.spawnPlanesEveryOnceInAWhile(this);
        // spawn drone every once in a while
        this.registerCallbackUpdateEvery(function () {
            _this.droneManager.checkDroneSpawn();
        }, 5000);
        // handle flood
        this.registerCallbackUpdateEvery(function () {
            _this.grids.waterUpperGrid.forEachTile(function (t) {
                t.floodEntitiesInIndex();
            });
        }, 1000);
        // dispatch btn visibility
        this.registerCallbackUpdateEvery(function () {
            self.pruneResizeKillTweens();
        }, GameplayUI.AUTO_CHECK_DISPATCH_BTNS_EVERY);
        // notifications speech
        this.registerCallbackUpdateEvery(function () {
            self.notifications.checkNotificationsSlow();
        }, Notifications.SLOW_CHECK_EVERY);
        // speech bubbles
        this.registerCallbackUpdateEvery(function () {
            self.updateSpeechVisibility();
        }, 1000);
        // General non-precise functions
        this.registerCallbackUpdateEvery(function () {
            Utils.sortGroupYWithAnchor(self.animalsLayer, true);
        }, 2000);
        this.registerCallbackUpdateEvery(function () {
            Utils.sortGroupY(self.skyRailCarLayer, true);
        }, 1500);
        // small batch of pedestrians
        this.registerCallbackUpdateEvery(function () {
            Utils.sortGroupYWithAnchor(_this.roadInnerPersonlikeLayer);
        }, 1000);
        // quests
        this.registerCallbackUpdateEvery(function () {
            self.quests.checkAndSyncQuests();
        }, Quests.CHECK_COMPLETED_QUESTS_EVERY);
        // metric grid calculation
        this.registerCallbackUpdateEvery(function () {
            if (self.performance.checkLargeMapShouldSkipPollution()) {
                return;
            }
            // update metrics
            self.grids.pollutionGrid.sync();
            // also update current view if open
            if (self.grids.pollutionGrid.visible) {
                self.grids.pollutionGrid.showTiles();
            }
        }, Global.RECALC_GRID_METRICS_EVERY);
        // effects like tornados
        this.registerCallbackUpdateEvery(function () {
            _this.constantEffectNoHide.sort('y', Phaser.Group.SORT_ASCENDING);
        }, 1500);
        this.registerSafeTimeout(function () {
            _this.registerCallbackUpdateEvery(function () {
                // update metrics
                self.grids.crimeGrid.sync();
                // also update current view if open
                if (self.grids.crimeGrid.visible) {
                    self.grids.crimeGrid.showTiles();
                }
            }, Global.RECALC_GRID_METRICS_EVERY);
            _this.registerCallbackUpdateEvery(function () {
                _this.crime.updateHideout();
            }, Global.RECALC_GRID_METRICS_EVERY + 1500);
        }, Global.RECALC_GRID_METRICS_EVERY * 0.5);
        this.registerCallbackUpdateEvery(function () {
            if (self.performance.checkLargeMapShouldSkipMetrics()) {
                return;
            }
            self.metrics.updateMetrics(true);
            self.stats.numTiles = self.grids.zoneGrid.getTileCountAnyTypeWithCache();
            self.stats.income = self.metrics.income;
        }, CityMetrics.APPLY_EFFECT_INTERVAL);
        this.registerCallbackUpdateEvery(function () {
            self.gameplayUI.syncEventsCooldownIfOpen();
        }, 1000);
        // left side notifs
        this.registerCallbackUpdateEvery(function () {
            self.gameplayUI.syncLeftNotifs();
        }, Global.SYNC_LEFT_NOTIFS_EVERY);
        CityPerformance.printPerformanceTime("registered intervals", true);
        // Additional handlers
        this.windowInput.registerResize();
        this.windowDisabledInput.registerResize();
    };
    City.prototype.initStructureCameraEase = function (saveState) {
        var _this = this;
        var self = this;
        if (this.stats.isNeighbor && !saveState) {
            this.gameplayUI.forceHideQuestsNotif();
            var createdTownHall = self.createRandomTownHallStart();
            self.initializeDefaultZoneUnlockStat();
            this.cityUI.initializePostCityInitSprites();
            CityBlockUnlock.refreshUnlockUI(this);
            if (!createdTownHall) {
                // nowhere to build! oh wel.
            }
        } else if (this.isRandom && !saveState) {
            CityPerformance.setPerformanceTime();
            this.gameplayUI.forceHideQuestsNotif();
            var createdTownHall_1 = self.createRandomTownHallStart();
            self.initializeDefaultZoneUnlockStat();
            this.cityUI.initializePostCityInitSprites();
            CityBlockUnlock.refreshUnlockUI(this);
            self.gameplayUI.hideUIForFunMsg();
            self.gameplayUI.showNewCityCreatedFunMsg(function () {
                if (!createdTownHall_1) {
                    // extreme edge case
                    console.log("Failed to find valid starting posiiton! Regenerating city.");
                    _this.gameplayUI.pocketCity.regenerateCurrentCity();
                    return;
                }
                // (check is only really necessary when testing)
                if (self.gameplayUI) self.gameplayUI.showRandomConfirmation();
            });
            CityPerformance.printPerformanceTime("Initialized on ready random section");
        } else {
            CityPerformance.setPerformanceTime();
            this.cityUI.initializePostCityInitSprites();
            CityPerformance.printPerformanceTime("Initializing unlock sprites");
        }
        // camera start
        this.easeCameraToDefaultTownHall(false);
        if (this.isRandom) {
            this.cityScaler.zoomTo(Global.RANDOM_MAP_ZOOM_OUT_DEFAULT, true, false);
            AudioPC.playOnce('bg_general');
        }
    };
    // return whichever is higher: self level or central level
    City.prototype.getLevelWithCentral = function () {
        var cityLevel = this.stats.level;
        if (this.centralCityLevel > cityLevel) {
            cityLevel = this.centralCityLevel;
        }
        return cityLevel;
    };
    City.prototype.initHighestLvUnlocks = function () {
        var self = this;
        self.pocketCity._loadCitiesHighestLevelDiffReached(function () {
            if (self.game) {
                self.cityLevel.init();
            }
        }); // for helping with lv 100 unlock structures
    };
    City.prototype.initFixUpperSpriteGlitch = function () {
        var self = this;
        self.game.raf.stop();
        setTimeout(function () {
            if (self.game) {
                self.game.raf.start();
                // some other stuff
                self.upperStructureLayer.forceTransform(true);
                // attempt to fix large upper sprite glitch
                self.tempSmartUpdate(3001);
            }
        }, 10);
    };
    City.prototype.initPostAddChildren = function () {};
    City.prototype.initSyncVariousGroups = function () {
        var _this = this;
        // Caching
        this.applyGridVisibility();
        CityPerformance.setPerformanceTime();
        this.grids.zoneGrid.recalcAllInProgressSlow();
        CityPerformance.printPerformanceTime("recalculate progress slow", true);
        // Visual
        this.refreshResourceNotifications();
        CityPerformance.printPerformanceTime("recalculate resource notifs", true);
        this.gameplayUI.syncUILevelNumber();
        CityPerformance.printPerformanceTime("sync UI level", true);
        this.skyRailTraffic.refreshStationConnectorEffects();
        CityPerformance.printPerformanceTime("refresh station connector", true);
        this.gameplayUI.initReset();
        CityPerformance.printPerformanceTime("init reset gameplay UI");
        // Safe for next tick, spread out performance
        this.delayEventWithCityCheck(50, function () {
            CityPerformance.setPerformanceTime();
            _this.updateSpeechVisibility();
            CityPerformance.printPerformanceTime("init reset gameplay UI", true);
            _this.quests.checkAndSyncQuests();
            CityPerformance.printPerformanceTime("sync quests", true);
            _this.skyRailTraffic.forceRespawnSkyRailCars();
            CityPerformance.printPerformanceTime("respawn sky rail cars", true);
            _this.sortAllStructures();
            CityPerformance.printPerformanceTime("sort structures", true);
            _this.animalManager.initializeAnimals();
            _this.sidewalkAnimals.refreshCachedDesiredSpawn(true);
            _this.sidewalkAnimals.refreshValidSpawns();
            CityPerformance.printPerformanceTime("initialize animals");
            _this.droneManager.checkDroneSpawn();
            _this.boatManager.onCityPostLoad();
            _this.updateHiddenLayersOutZoom();
        });
    };
    City.prototype.initGameplayReset = function () {
        this.gameplayUI.hideAllBottomElem();
        if (!window['disableAutoDefault']) {
            this.gameplayUI.hideAll();
        }
        this.gameplayUI.initReset();
    };
    City.prototype.getDifficultyMultiplier = function (maxMultiplier) {
        return 1 + maxMultiplier * (this.stats.level / Global.MAX_LEVEL);
    };
    City.prototype.sortAllStructures = function () {
        this.grids.structureGrid.sortGroupDepth();
        this.upperStructureLayer.sortGroupDepth();
        this.smallStructureLayer.sortGroupDepth();
    };
    City.prototype.sortLargeStructuresStaggered = function () {
        var _this = this;
        this.grids.structureGrid.sortGroupDepth();
        this.registerSafeTimeout(function () {
            _this.upperStructureLayer.sortGroupDepth();
        }, 0);
    };
    City.prototype.createRandomTownHallStart = function () {
        var buildIndex = this.grids.terrainGrid.findRandomBuildableAreaForTownHall();
        if (buildIndex) {
            this.grids.zoneGrid.initializeStructureAtTile(buildIndex.row, buildIndex.col, STRUCTURE_BY_SHEET[STRUCTURE_SHEETS.TOWN_HALL], true);
        } else {
            return false;
        }
        this.structureCache.sync();
        return true;
    };
    // Unlock blocks around town hall
    City.prototype.initializeDefaultZoneUnlockStat = function () {
        var townHalls = this.structureCache.getTownHalls();
        if (townHalls.length > 0) {
            var townHallIndex = {
                row: townHalls[0].row,
                col: townHalls[0].col
            };
            var cityBlockSize = Global.CITY_BLOCK_SIZE;
            var cityInitialBlocks = Global.CITY_INITIAL_BLOCKS_UNLOCKED_DIM;
            if (this.size < Global.CITY_BLOCK_SIZE || this.size % Global.CITY_BLOCK_SIZE !== 0) {
                console.log("WARN: City block divisor does not divide evenly into grid size or city size is too small - defaulting to block divisor = 1");
                cityBlockSize = this.size;
                cityInitialBlocks = 1;
            }
            var offsetRow = Math.floor((townHallIndex.row - 3) / cityBlockSize);
            var offsetCol = Math.floor((townHallIndex.col - 3) / cityBlockSize);
            this.stats.unlocks = City.createCityBlockUnlockSetting(this, cityBlockSize, cityInitialBlocks, offsetRow, offsetCol);
        }
        if (this.isSandbox) {
            CityBlockUnlock.setUnlockAll(this);
        }
    };
    City.prototype.isInfiniteMoney = function () {
        return this.metadata.isSandbox && !this.metadata.sandboxWithMoney;
    };
    /** Set as sandbox but not infinite money */
    City.prototype.setSandboxFiniteMoney = function () {
        this.isSandbox = true;
        this.metadata.isSandbox = true;
        this.metadata.sandboxWithMoney = true;
        this.stats.money = Global.START_CASH * 20;
        this.metrics.addCash(0);
    };
    //
    // Saving/loading
    //
    City.loadSaveStateIntoCity = function (city, cityState, desiredSnapshot) {
        // Use latest snapshot
        var snapshot = desiredSnapshot;
        city.autoSnapshots = Utils.copyJSON(cityState.AS);
        city.manualSnapshots = Utils.copyJSON(cityState.MS);
        // Load metadata and stats
        Utils.extend(city.metadata, Utils.copyJSON(snapshot.metadata), true);
        Utils.extend(city.stats, Utils.copyJSON(snapshot.stats), true);
        // backwards compat
        if (!snapshot.metadata.fastTerrain) {
            city.metadata.fastTerrain = false;
        }
        // Load grids
        GridSerializer.loadSaveGrid(snapshot.grids, city);
        city.grids['structureGrid'].alpha = 1;
        city.grids.terrainGrid.setSoilFromSaved();
        // Load other
        city.busStopLayer.loadSavedBusStops();
        city.applyGridVisibility();
        city.buildHelper.syncUsageCounts();
    };
    City.getLatestSnapshot = function (cityState) {
        var latestSnapshot = cityState.AS[0] || null;
        if (cityState.MS.length > 0 && (!latestSnapshot || latestSnapshot.timestamp < cityState.MS[0].timestamp)) {
            latestSnapshot = cityState.MS[0];
        }
        return latestSnapshot;
    };
    /**
     * Load a City save state JSON and set the city state
     * Main deserialization logic
     */
    City.prototype.loadSaveState = function (cityState, saveSnapshot) {
        City.loadSaveStateIntoCity(this, cityState, saveSnapshot);
    };
    City.createSaveSnapshot = function (metadata, stats, grids) {
        var snapshot = {
            "timestamp": Date.now(),
            "metadata": metadata,
            "stats": stats,
            "grids": GridSerializer.generateSaveGrid(grids)
        };
        if (grids.terrainGrid.isRandom && grids.terrainGrid.seed) {
            snapshot['rng'] = grids.terrainGrid.seed;
        }
        return JSON.parse(JSON.stringify(snapshot));
    };
    // Create a save state with just one autosave (the current city state)
    City.prototype.getOneOffState = function () {
        return SaveHelper.minimizeString(JSON.stringify({
            AS: [City.createSaveSnapshot(this.metadata, this.stats, this.grids)],
            MS: []
        }));
    };
    City.prototype.hasRegions = function () {
        for (var i = 0; i < this.stats.regions.length; i++) {
            if (Boolean(this.stats.regions[i])) {
                return true;
            }
        }
        return false;
    };
    /**
     * Returns a City save state JSON for the current city state with current snapshots
     */
    City.prototype.getSaveStateSerialized = function () {
        return City.createSaveStateSerialized(this.autoSnapshots, this.manualSnapshots);
    };
    City.createSaveStateSerialized = function (autoSnapshots, manualSnapshots) {
        var saveState = {
            AS: autoSnapshots,
            MS: manualSnapshots
        };
        return SaveHelper.minimizeString(JSON.stringify(saveState));
    };
    City.prototype.getOrderedSnapshots = function () {
        var i = -1;
        var snapshotsAuto = this.autoSnapshots.map(function (a) {
            i += 1;
            return Utils.extend({
                automated: true,
                index: i
            }, a);
        });
        i = -1;
        var snapshotsManual = this.manualSnapshots.map(function (a) {
            i += 1;
            return Utils.extend({
                automated: false,
                index: i
            }, a);
        });
        var snapshots = snapshotsAuto.concat(snapshotsManual);
        Utils.sortOnKey(snapshots, 'timestamp');
        snapshots.reverse();
        return snapshots;
    };
    City.prototype.addNewAutoSnapshot = function () {
        this.pushSnapshot(this.autoSnapshots);
    };
    City.prototype.addNewManualSnapshot = function () {
        this.pushSnapshot(this.manualSnapshots);
    };
    City.prototype.deleteManualSnapshot = function (index) {
        this.deleteSnapshot(this.manualSnapshots, index);
    };
    City.prototype.pushSnapshot = function (snapshotsArr) {
        // things that only need to be updated on snapshot push
        this.stats.income = this.metrics.income;
        if (this.events.cooldowns) {
            this.stats.globalSettings[Events.COOLDOWN_SAVE_KEY] = this.events.cooldowns;
        }
        if (this.events.disasterReports) {
            this.stats.globalSettings[Events.DISASTER_REPORTS_SAVE_KEY] = this.events.disasterReports;
        }
        // put new snapshot at front
        this.quests.syncCityStatsWithQuestsModule();
        snapshotsArr.unshift(City.createSaveSnapshot(this.metadata, this.stats, this.grids));
        while (snapshotsArr.length > Global.MAX_SAVE_SNAPSHOTS) {
            snapshotsArr.pop();
        }
    };
    City.prototype.getNewSnapshot = function () {
        return City.createSaveSnapshot(this.metadata, this.stats, this.grids);
    };
    City.prototype.deleteSnapshot = function (snapshotsArr, index) {
        snapshotsArr.splice(index, 1);
    };
    //
    // Pause/Resume
    //
    City.prototype.pauseGame = function () {
        if (this.game.paused) {
            return;
        }
        // careful consideration: sounds need to be updated
        this.game.paused = true;
        this.game.raf.stop();
        this.gameplayUI.initPausedUpdateLoop();
    };
    City.prototype.resumeGame = function () {
        if (!this.game.paused) {
            return;
        }
        this.game.paused = false;
        this.game.raf.start();
        this.gameplayUI.stopPauseUpdateLoop();
    };
    City.prototype.getWorldWidth = function () {
        return this.getTileSize() * this.size * 2 * 1.2;
    };
    /**
     * Terrain diamond mask
     */
    City.prototype.createBuildGridBg = function () {
        // Here we add a Sprite to the display list
        var sprite = this.game.add.tileSprite(0, 0, this.getTileSize(), this.getTileSize(), 'atlas-tiles', "src/www/img-atlas/tiles/grid-pattern.png");
        sprite.tilePosition.x = 0;
        sprite.tilePosition.y = 0;
        sprite.visible = false;
        return sprite;
    };
    // i think this is more for build grid than grass
    City.prototype.resizeGrassBackgroundMask = function () {
        var tileSize = this.getTileSize();
        var topPos = Utils.indexToPosition(0, 0, tileSize);
        topPos.y -= tileSize * 0.5;
        var leftPos = Utils.indexToPosition(0, this.size, tileSize);
        leftPos.y -= tileSize * 0.5;
        var rightPos = Utils.indexToPosition(this.size, 0, tileSize);
        rightPos.y -= tileSize * 0.5;
        var bottomPos = Utils.indexToPosition(this.size, this.size, tileSize);
        bottomPos.y -= tileSize * 0.5;
        // Resize area sprite and build grid sprite
        var _width = rightPos.x - leftPos.x;
        var _height = bottomPos.y - topPos.y;
        var _x = leftPos.x;
        var _y = topPos.y;
        this.buildGridBg.width = _width;
        this.buildGridBg.height = _height;
        this.buildGridBg.y = _y;
        this.buildGridBg.x = _x;
        Utils.setTileSpriteTextureSize(this.buildGridBg, tileSize, tileSize);
        // Apply tile scale
        var tileScale = this.cityScaler.zoom * 0.8;
        this.buildGridBg.tileScale.set(1);
        this.buildGridBg.tileScale.set(tileScale, tileScale);
        // Create new mask
        var mask = Utils.createDiamondMask(this, this.size, this.size, tileSize);
        // And apply it to the Sprite
        Utils.destroyIfAlive(this.buildGridBg.mask);
        this.addChild(mask);
        this.buildGridBg.mask = mask;
    };
    /**
     * Grids
     */
    City.prototype.getTouchedUnlock = function () {
        var self = this;
        var touchedUnlock = null;
        if (!self.game.input.activePointer) {
            return null;
        }
        var pointer = Utils.toPosition(self.game.input.activePointer.worldX * (1 / self.scale.x), self.game.input.activePointer.worldY * (1 / self.scale.y));
        Utils.foreach2D(self.cityUI.unlockSpriteGroupBlocks, function (btn) {
            if (btn && btn.alpha && btn.alive && Utils.isPositionInSprite(pointer, btn, Global.UNLOCK_TAP_BUFFER)) {
                touchedUnlock = btn;
            }
        });
        return touchedUnlock;
    };
    City.prototype.getTouchedChest = function () {
        var touchedChest = null;
        if (!this.game.input.activePointer) {
            return null;
        }
        var pointer = Utils.toPosition(this.game.input.activePointer.worldX * (1 / this.scale.x), this.game.input.activePointer.worldY * (1 / this.scale.y));
        for (var i = 0; i < this.cityUI.chests.length; i++) {
            var chest = this.cityUI.chests[i];
            if (chest && chest.alpha && chest.alive && Utils.isPositionInSprite(pointer, chest, 15)) {
                touchedChest = chest;
            }
        }
        return touchedChest;
    };
    City.prototype.resizeGrids = function () {
        this.applyGridVisibility();
    };
    City.prototype.refreshForZoomOut = function (timeout) {
        var _this = this;
        if (timeout === void 0) {
            timeout = false;
        }
        if (!this.scale || this.scale.x > Global.ZOOM_CACHE_AS_BITMAP) {
            return; // nothing to do
        }
        if (timeout) {
            this._refreshForZoomOutTimeoutCache = this._refreshForZoomOutTimeoutCache || function () {
                _this.refreshForZoomOut(false);
            };
            this.registerSafeTimeout(this._refreshForZoomOutTimeoutCache);
            return;
        }
        this.updateHiddenLayersOutZoom();
    };
    City.prototype.updateSpeechVisibility = function () {
        var self = this;
        var zoom = this.scale.x;
        var speechLayer = this.speechLayer;
        if (speechLayer.noAutoAdjust) {
            return;
        }
        // Update speech layer zoom
        if (zoom >= CitySpeech.VISIBLE_AT_ZOOM) {
            // tween in
            if ((!this.speechLayer.visible || this.speechLayer.alpha < 1) && !speechLayer._tweeningIn) {
                this.speechLayer.visible = true;
                speechLayer._tweeningIn = true;
                if (this._speechTween) this._speechTween.stop(true);
                this.speechLayer.alpha = 0;
                this._speechTween = this.game.add.tween(this.speechLayer).to({
                    alpha: 1
                }, 500, null, true);
                this._speechTween.onComplete.add(function () {
                    speechLayer._tweeningIn = false;
                    if (!speechLayer.noAutoAdjust) {
                        self.speechLayer.visible = true;
                    }
                    self._speechTween = null;
                });
            }
        } else if (zoom < CitySpeech.VISIBLE_AT_ZOOM && this.speechLayer.visible && !speechLayer._tweeningOut) {
            speechLayer._tweeningOut = true;
            if (this._speechTween) this._speechTween.stop(true);
            this._speechTween = this.game.add.tween(speechLayer).to({
                alpha: 0
            }, 500, null, true);
            this._speechTween.onComplete.add(function () {
                if (!speechLayer.noAutoAdjust) {
                    speechLayer.visible = false;
                }
                speechLayer._tweeningOut = false;
                self._speechTween = null;
            });
        }
    };
    /** Show/hide registered layers based on current zoom level */
    City.prototype.updateHiddenLayersOutZoom = function () {
        if (this.focusingLayer) {
            return;
        }
        if (this.isBuildingState()) {
            this._applyHiddenZoom(this._hiddenLayersOutZoomWhenBuild);
            return;
        }
        var zoom = this.scale.x;
        this._applyHiddenZoom(this.hiddenLayersOutZoom);
        var roadIsInFront = this.grids.roadGrid.z > this.grids.structureGrid.z;
        if (zoom >= Global.ZOOM_CACHE_AS_BITMAP && !roadIsInFront || zoom < Global.ZOOM_CACHE_AS_BITMAP && roadIsInFront) {
            this.swap(this.grids.structureGrid, this.grids.roadGrid);
        }
    };
    City.prototype._applyHiddenZoom = function (updates) {
        var zoom = this.scale.x;
        var i;
        var layer;
        var max = updates.length;
        var structureVisibleBefore = this.grids.structureGrid.visible;
        var cutoff;
        for (i = 0; i < max; i++) {
            layer = updates[i];
            cutoff = layer.zoomHideCutoff ? layer.zoomHideCutoff : Global.ZOOM_CACHE_AS_BITMAP;
            var additionalCondition = true;
            if (layer.additionalHideZoomCondition) {
                additionalCondition = layer.additionalHideZoomCondition();
                var targetVisible = zoom > cutoff;
                if (!targetVisible && !additionalCondition) {
                    targetVisible = true; // don't hide if condition failed
                }
                layer.visible = targetVisible;
            } else {
                layer.visible = zoom > cutoff;
            }
        }
        if (this.grids.structureGrid.visible && this.grids.structureGrid.visible !== structureVisibleBefore) {
            this.grids.structureGrid.applyZoominVisibilityRefresh();
        }
    };
    City.prototype.isUnlockedTile = function (row, col) {
        if (Global.DEBUG_ALL_UNLOCKED_ZONES) {
            return true;
        }
        // Add sprites
        var blockSize = this.size / this.stats.unlocks.length;
        var blockRow = Math.floor(row / blockSize);
        var blockCol = Math.floor(col / blockSize);
        if (!this.isValidUnlockTile(blockRow, blockCol)) {
            console.log("WARN: returning due to invalid unlock tile");
            return false;
        }
        return this.stats.unlocks[blockRow][blockCol];
    };
    City.prototype.isValidUnlockTile = function (row, col) {
        return row >= 0 && row < this.stats.unlocks.length && col >= 0 && col < this.stats.unlocks.length;
    };
    City.createCityBlockUnlockSetting = function (city, blockSize, initialUnlocked, offsetRow, offsetCol) {
        if (offsetRow === void 0) {
            offsetRow = Global.CITY_INITIAL_UNLOCK_OFFSET;
        }
        if (offsetCol === void 0) {
            offsetCol = Global.CITY_INITIAL_UNLOCK_OFFSET;
        }
        var maxSize = city.size;
        var divisions = maxSize / blockSize;
        var arr = Utils.initialize2DArray(divisions, divisions);
        for (var i = 0; i < initialUnlocked; i++) {
            for (var j = 0; j < initialUnlocked; j++) {
                if (i + offsetRow < arr.length && j + offsetCol < arr.length) {
                    arr[i + offsetRow][j + offsetCol] = 1;
                }
            }
        }
        return arr;
    };
    /**
     * Camera related
     */
    /** Update the culling rendering for grids that need to be re-rendered */
    // Will also ensure z-index is reflected accurately
    City.prototype.applyGridVisibility = function () {
        var self = this;
        if (!this.alive) {
            return; //a bit hacky safeguard
        }
        // debug: draw visibility rectangle
        if (Global.DEBUG_CULLING_GRID) {
            var tileWidth = this.getTileSize();
            var extraZoomBuffer = 2 - Math.min(1, this.scale.x / Global.ZOOM_MAX);
            var buffer = tileWidth * Global.TILE_CULLING_BUFFER * extraZoomBuffer;
            Utils.destroyIfAlive(self._debug_culling_box);
            var box = self.game.add.graphics(0, 0);
            var cameraBox = Utils.cameraBox(this);
            box.beginFill(0xaaaaaa);
            box.alpha = 0.5;
            box.drawRect(cameraBox.xLeft - buffer * 0.5, cameraBox.yTop - buffer * 0.5, cameraBox.xRight - cameraBox.xLeft + buffer, cameraBox.yBottom - cameraBox.yTop + buffer);
            box.fixedToCamera = false;
            box.visible = true;
            box.endFill();
            self.addChild(box);
            self._debug_culling_box = box;
        }
        // result cull children for GRIDS and Layers
        for (var i = 0; i < self.layersNeedVisibilityUpdates.length; i++) {
            if (self.layersNeedVisibilityUpdates[i].visible) {
                self.layersNeedVisibilityUpdates[i].applyCullChildren();
            }
        }
        if (!this.grids.structureGrid.visible) {
            this.grids.structureGrid.needsForceApplyGridVisibilityOnZoomIn = true;
        }
        // cull force pre-post updates
        this.refreshVisibleForcePrePostUpdate();
    };
    City.prototype.applyCullAgainCheck = function () {
        for (var i = 0; i < this.layersNeedVisibilityUpdates.length; i++) {
            if (this.layersNeedVisibilityUpdates[i].visible) {
                this.layersNeedVisibilityUpdates[i].checkCullAgain();
            }
        }
    };
    /**
     * Tiles and visibility
     */
    City.prototype.getTileSize = function () {
        return Tile.TILE_WIDTH;
    };
    City.prototype.getCachedTileSize = function () {
        return Tile.TILE_WIDTH;
    };
    // Hide zone tiles that have a building on top
    City.prototype.hideZoneGrid = function () {
        this.grids.zoneGrid.visible = false;
    };
    City.prototype.showZoneGrid = function () {
        this.grids.zoneGrid.visible = true;
        this.grids.zoneGrid.applyCullChildren();
    };
    City.prototype.isRoadTile = function (row, col, variant) {
        if (!Utils.isValidIndex(row, col, this.size)) {
            return false;
        }
        if (!this.grids.roadGrid.tiles || !this.grids.roadGrid.tiles[row]) {
            return false;
        }
        var t = this.grids.roadGrid.tiles[row][col];
        if (variant) {
            return Boolean(t && t.type === Tile.Type.Road && t.variantType === variant);
        } else {
            return Boolean(t && t.type === Tile.Type.Road);
        }
    };
    City.prototype.isRoadTileNoVariant = function (row, col) {
        if (!Utils.isValidIndex(row, col, this.size)) {
            return false;
        }
        if (!this.grids.roadGrid.tiles || !this.grids.roadGrid.tiles[row]) {
            return false;
        }
        var t = this.grids.roadGrid.tiles[row][col];
        return Boolean(t && t.type === Tile.Type.Road && !t.variantType);
    };
    City.prototype.isRoadTileConductingResource = function (row, col) {
        if (!Utils.isValidIndex(row, col, this.size)) {
            return false;
        }
        if (!this.grids.roadGrid.tiles || !this.grids.roadGrid.tiles[row]) {
            return false;
        }
        var t = this.grids.roadGrid.tiles[row][col];
        return Boolean(t && t.type === Tile.Type.Road && t.conductsResources());
    };
    City.prototype.beforeFocusLayer = function (hideTraffic, label, showZoneWhite, buildingShowType, buildingShowSheet) {
        var _this = this;
        if (hideTraffic === void 0) {
            hideTraffic = true;
        }
        if (label === void 0) {
            label = "default";
        }
        if (showZoneWhite === void 0) {
            showZoneWhite = true;
        }
        this.clearFocusAnyGrid();
        Utils.setAlpha(this.personLikeLayer, Global.STRUCTURE_DURING_RESOURCE_ALPHA);
        Utils.setAlpha(this.skyRailUpperLayer, Global.STRUCTURE_DURING_RESOURCE_ALPHA);
        Utils.setAlpha(this.grids.skyRailGrid, Global.STRUCTURE_DURING_RESOURCE_ALPHA);
        this.grids.roadGrid.alpha = 0.5;
        this.speechLayer.noAutoAdjust = true;
        this.speechLayer.visible = false;
        this.focusingLayer = label;
        if (hideTraffic) {
            this.setTrafficTransparent();
        }
        for (var i = 0; i < this.hideDuringFocus.length; i++) {
            this.hideDuringFocus[i].visible = false;
        }
        if (showZoneWhite) {
            this.grids.zoneGridWhite.copyWhiteTilesOtherGrid(this.grids.zoneGrid);
            this.grids.zoneGridWhite.visible = true;
            this.grids.zoneGridWhite.alpha = 0.5;
            this.hideZoneGrid();
        } else {
            this.showZoneGrid();
        }
        this._timeoutEaseZoom = this._timeoutEaseZoom || function () {
            // Past threshold to zoom out
            if (_this.scale.x > Utils.zoomRequiredToShowNumTiles(Global.ZOOM_FOCUS_ADJUST_IF_LT_X_TILES_VISIBLE, _this.pocketCity)) {
                _this.cityScaler.easeZoomForVisibleNumTiles(Global.ZOOM_FOCUS_TO_TILES_VISIBLE);
            }
        };
        this.registerSafeTimeout(this._timeoutEaseZoom, 0);
        // copy relevant structures to structure effect layer temporarily
        if (buildingShowType) {
            this._showBuildingsToTmpFocusLayer(this.structureCache.getBuildingsOfType(buildingShowType));
        } else if (buildingShowSheet) {
            if (buildingShowSheet === "busstop") {
                this._showSpritesOnTmpFocusLayer(this.structureCache.getImagesForBusStops());
            } else {
                this._showBuildingsToTmpFocusLayer(this.structureCache.getBuildingsofSheet(buildingShowSheet));
            }
        } else {
            this.tmpFocusLayer.visible = false;
        }
    };
    City.prototype._showBuildingsToTmpFocusLayer = function (buildings) {
        this._showSpritesOnTmpFocusLayer(buildings.map(function (tile) {
            return tile.structureGroup;
        }));
    };
    City.prototype._showSpritesOnTmpFocusLayer = function (sprites) {
        var _this = this;
        sprites.forEach(function (s) {
            if (!s) {
                return;
            }
            var copy = new Phaser.Image(_this.game, s.x, s.y, s.key, s.frameName);
            copy.width = s.width;
            copy.height = s.height;
            copy.anchor.setTo(s.anchor.x, s.anchor.y);
            _this.tmpFocusLayer.addChild(copy);
            _this.tmpFocusLayer.alpha = 1;
        });
        this.tmpFocusLayer.sort('y', Phaser.Group.SORT_ASCENDING);
        this.tmpFocusLayer.visible = true;
    };
    City.prototype.afterFocusLayer = function () {
        this.refreshForZoomOut(true);
        this.smartUpdateNext();
    };
    City.prototype.focusWithGrid = function () {
        this.buildGridBg.alpha = 0.4;
        this.buildGridBg.visible = true;
    };
    City.prototype.focusZoneGrid = function () {
        this.gameplayUI.globalPauseOn();
        var c = this.grids.zoneGrid.children;
        for (var i = 0; i < c.length; i++) {
            c[i].alpha = 0.75;
        }
        this.beforeFocusLayer(true, "zone", false);
        this.grids.structureGrid.visible = false;
        this.grids.structureGrid.shouldBeInvisible = true;
        this.gameplayUI.showLayerViewMsg("구역 표시");
        this.afterFocusLayer();
        this.showZoneGrid();
        this.cityEffects.showCurrentUpgradedTileIcons();
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.focusWaterGrid = function (hideStructures) {
        if (hideStructures === void 0) {
            hideStructures = false;
        }
        this.gameplayUI.globalPauseOn();
        this.beforeFocusLayer(true, "water", true, "water");
        //if (hideStructures){
        this.grids.structureGrid.visible = false;
        this.grids.structureGrid.shouldBeInvisible = true;
        //}
        this.resourceNotificationLayer.visible = true;
        this.grids.waterGrid.showCurrent(0.75 * ResourceOnRoadGrid.SHOW_ALPHA);
        this.gameplayUI.showLayerViewMsg("용수 공급 표시");
        this.afterFocusLayer();
        this.focusWithGrid();
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.focusPowerGrid = function (hideStructures) {
        if (hideStructures === void 0) {
            hideStructures = false;
        }
        this.gameplayUI.globalPauseOn();
        this.beforeFocusLayer(true, "power", true, "power");
        //if (hideStructures){
        this.grids.structureGrid.visible = false;
        this.grids.structureGrid.shouldBeInvisible = true;
        //}
        this.resourceNotificationLayer.visible = true;
        this.grids.powerGrid.showCurrent(0.75 * ResourceOnRoadGrid.SHOW_ALPHA);
        this.gameplayUI.showLayerViewMsg("전력 공급 표시");
        this.afterFocusLayer();
        this.gameplayUI.syncPower();
        this.focusWithGrid();
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.focusPollutionGrid = function () {
        this.gameplayUI.globalPauseOn();
        this.beforeFocusLayer(true, "pollution", true);
        this.grids.pollutionGrid.showTiles();
        this.gameplayUI.showLayerViewMsg("환경 표시");
        this.afterFocusLayer();
        this.focusWithGrid();
        this.grids.structureGrid.shouldBeInvisible = true;
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.focusCrimeGrid = function () {
        this.gameplayUI.globalPauseOn();
        this.beforeFocusLayer(true, "crime", true, "police");
        this.grids.crimeGrid.showTiles();
        this.gameplayUI.showLayerViewMsg("범죄 표시");
        this.afterFocusLayer();
        this.focusWithGrid();
        this.pedestriansLayer.visible = true;
        this.pedestriansLayer.alpha = 1;
        this.pedestriansUpperLayer.visible = true;
        this.pedestriansUpperLayer.alpha = 1;
        this.grids.structureGrid.shouldBeInvisible = true;
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.focusTrafficGrid = function () {
        this.gameplayUI.globalPauseOn();
        this.clearFocusAnyGrid();
        this.beforeFocusLayer(false, City.TRAFFIC_LABEL, true, "transit");
        this.trafficDensity.updateNow();
        this.grids.trafficDensityGrid.alpha = HeatmapGrid.ALPHA;
        this.grids.trafficDensityGrid.visible = true;
        Utils.setVisibleAndAlpha(this.constantEffectInnerLayer);
        Utils.setVisibleAndAlpha(this.personLikeLayer);
        this.busStopLayer.visible = true;
        this.gameplayUI.showLayerViewMsg("교통 상황 표시");
        this.afterFocusLayer();
        this.focusWithGrid();
        this.grids.structureGrid.shouldBeInvisible = true;
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.focusStructure = function (sheet) {
        this.gameplayUI.globalPauseOn();
        this.clearFocusAnyGrid();
        this.beforeFocusLayer(true, "structure", true, null, sheet);
        this.grids.structureGrid.visible = false;
        this.grids.structureGrid.shouldBeInvisible = true;
        this.gameplayUI.showLayerViewMsg("Showing " + STRUCTURE_BY_SHEET[sheet].name);
        this.afterFocusLayer();
        this.focusWithGrid();
        this.smallStructureLayer.visible = false;
        this.gameplayUI.globalPauseOff();
    };
    City.prototype.clearFocusAnyGrid = function () {
        if (!this.focusingLayer) {
            return;
        }
        [this.roadLowerEffects, this.roadUpperEffects, this.grids.zoneGrid, this.personLikeLayer, this.skyRailUpperLayer, this.grids.skyRailGrid].forEach(function (l) {
            return Utils.setAlpha(l, 1);
        });
        this.grids.structureGrid.visible = true;
        this.grids.structureGrid.shouldBeInvisible = false;
        this.grids.roadGrid.alpha = 1;
        this.grids.waterGrid.hide();
        this.grids.powerGrid.hide();
        this.grids.trafficDensityGrid.visible = false;
        this.grids.zoneGridWhite.visible = false;
        if (this.cityScaler.zoom >= Global.ZOOM_CACHE_AS_BITMAP) {
            this.setTrafficVisible();
        }
        this.grids.pollutionGrid.hideTiles();
        this.grids.crimeGrid.hideTiles();
        this.speechLayer.noAutoAdjust = false;
        this.updateSpeechVisibility();
        this.smartUpdateNext();
        this.gameplayUI.hideLayerViewMsg();
        this.gameplayUI.hidePopovers();
        this.refreshForZoomOut();
        this.focusingLayer = null;
        this.hideZoneGrid();
        this.hideDuringFocus.forEach(function (l) {
            l.visible = true;
        });
        this.buildGridBg.alpha = 1;
        this.buildGridBg.visible = false;
        this.tmpFocusLayer.removeAll(true);
        this.tmpFocusLayer.visible = false;
        this.gameplayUI.syncPower();
        this.cityEffects.hideCurrentUpgradedTileIcons();
        this.cityStructureScaler.updateTextureScale();
    };
    City.prototype.clearIfCurrentlyFocusing = function (label) {
        if (this.focusingLayer === label) {
            this.clearFocusAnyGrid();
            return true;
        }
        return false;
    };
    /** Return grids that have to do with traffic */
    City.prototype.getTrafficRelatedLayers = function () {
        return [this.drivingLayer, this.drivingParkUpperLayer, this.drivingUpperLayer, this.drivingParkLowerLayer, this.drivingHoverLayer, this.vehicleLikeLayer, this.pedestriansLayer, this.pedestriansUpperLayer, this.sidewalkAnimalsLayer, this.sidewalkAnimalsUpperLayer, this.cyclingLayer, this.cyclingUpperLayer, this.skyRailCarLayer];
    };
    City.prototype.setTrafficTransparent = function () {
        this._setLayersVisible(this.getTrafficRelatedLayers(), 0, false);
    };
    City.prototype.setTrafficVisible = function () {
        this._setLayersVisible(this.getTrafficRelatedLayers(), 1, true);
    };
    City.prototype._setLayersVisible = function (layers, alpha, visible) {
        for (var i = 0; i < layers.length; i++) {
            Utils.setAlpha(layers[i], alpha);
            layers[i].visible = visible;
        }
    };
    /**
     * Final tile sprite width (not just tile width)
     * @returns {number}
     */
    City.prototype.getTileSpriteWidth = function () {
        return this.getTileSize() / Tile.ZONE_TILE_AREA_PERCENT;
    };
    //
    // Build mode related
    //
    City.prototype.allowConfirmBuild = function () {
        this.gameplayUI.setBuildConfirmButtonEnabled();
    };
    City.prototype.setBuildCancel = function (cb) {
        this.buildHelper.buildCancelCb = cb;
    };
    City.prototype.setBuildConfirm = function (cb) {
        this.buildHelper.buildConfirmCb = cb;
    };
    /** @param clearBuildPendingEffect default true */
    City.prototype.setBuildInteracting = function (clearBuildPendingEffect) {
        if (clearBuildPendingEffect === void 0) {
            clearBuildPendingEffect = true;
        }
        if (clearBuildPendingEffect) {
            this.cityEffects.clearCurrentBuildPendingEffect();
        }
        this.smartUpdateNext();
    };
    City.prototype.setBuildStoppedInteracting = function () {
        this.buildHelper.showBuildConfirmationModal();
        if (this.buildHelper._isValidBuild) {
            this.cityEffects.animatePendingBuildBitmap();
        }
        // Fix caching flash
        this.refreshCacheBitmapsNextTick();
    };
    City.prototype.clearBuildState = function () {
        this.cityEffects.clearAffectedBuildTiles();
        this.cityEffects.clearCurrentBuildPendingEffect();
        if (this.state.gridState) {
            this.state.gridState.input.unregisterHandler();
        }
    };
    City.prototype.cancelBuild = function () {
        this.clearBuildState();
        if (this.buildHelper.buildCancelCb) {
            this.buildHelper.buildCancelCb();
            this.buildHelper.buildCancelCb = null;
        }
        this.exitBuildState();
        // build commit might bring back grids that shouldn't be visible at this zoom level
        this.refreshForZoomOut(true);
        MainUI.Move.revertMoveMode();
    };
    City.prototype.confirmBuild = function () {
        if (!this.buildHelper._isValidBuild || !this.state.gridState) {
            // this might be triggered by enter key or multiple clicks
            return;
        }
        this.cityEffects.clearAffectedBuildTiles();
        this.state.gridState.input.unregisterHandler();
        // If current state is a build state, confirm it
        // confirm build happens here usually
        if (this.buildHelper.buildConfirmCb) {
            this.buildHelper.buildConfirmCb();
            this.buildHelper.buildConfirmCb = null;
        }
        this.exitBuildState();
        AudioPC.playBuildConfirm();
        this.buildSignal.dispatch('confirm-build');
        this.smartUpdateNext();
        this.refreshForZoomOut(true);
    };
    City.prototype.refreshCacheBitmapsNextTick = function () {
        var city = this;
        if (!this._cachedRefreshBitmap) {
            this._cachedRefreshBitmap = function () {
                city.refreshSignal.dispatch("refresh_bitmap_cache", city.getCachedTileSize());
            };
        }
        this.registerSafeTimeout(this._cachedRefreshBitmap);
    };
    /** Dispatch signal at key, supports passing a single argument */
    City.prototype.signalOncePostUpdate = function (k, arg) {
        if (arg === void 0) {
            arg = true;
        }
        this.signalOnceKeys[k] = arg;
    };
    /** Convenient way to register handler on refreshSignal. Returns handler, which can be deregistered */
    City.prototype.registerSignalHandler = function (eventName, cb) {
        var _this = this;
        var handler = function handler(event, arg1, arg2) {
            if (event === eventName && _this && _this.game) {
                cb(event, arg1, arg2);
            }
        };
        this.refreshSignal.add(handler);
        return handler;
    };
    City.prototype.deregisterSignalHandler = function (handler, nextTick) {
        if (nextTick === void 0) {
            nextTick = true;
        }
        if (nextTick) {
            this.deregisterSignalHandlerNextTick.push(handler);
        } else {
            this.refreshSignal.remove(handler);
        }
    };
    /**
     * Commit tiles to city grid and activate
     */
    City.prototype.commitBuildTiles = function () {
        // Flash animation - needs to happen before removing tiles
        this.cityEffects.animateBuildBitmapFadeOut();
        var structureBuildAboutToCommit = this.buildHelper.getCurrentBuildStructureDef();
        if (structureBuildAboutToCommit && structureBuildAboutToCommit.onCommit) {
            structureBuildAboutToCommit.onCommit(this.grids.buildGrid);
            this.buildHelper.postCommit(1);
        } else {
            this.buildHelper.genericCommitBuildTiles();
        }
        // build commit might bring back grids that shouldn't be visible at this zoom level
        this.refreshForZoomOut(true);
        if (this.cityStructureScaler.shouldUseSmallStructure()) {
            this.grids.structureGrid.needSortDueToZoomeoutBuild = true;
        }
    };
    //
    // State related
    //
    City.prototype.isBuildingState = function () {
        return this.state && this.state.buildStateName === "buildstate";
    };
    City.prototype.isRectangleInput = function () {
        return this.isBuildingState() && this.state.gridState instanceof GridBuildArea;
    };
    City.prototype.isStructureInput = function () {
        return this.isBuildingState() && this.state.gridState instanceof GridBuildStructure;
    };
    City.prototype.isLineInput = function () {
        return this.isBuildingState() && this.state.gridState instanceof GridBuildLine;
    };
    City.prototype.getBuildingState = function () {
        if (this.state && this.state.gridState) {
            return this.state.gridState;
        } else {
            return null;
        }
    };
    City.prototype.setCameraState = function () {
        var self = this;
        if (!(self.state instanceof CityState.Camera)) {
            self.setState(new CityState.Camera(self));
            this.smartUpdateNext();
        }
    };
    City.prototype.isCameraState = function () {
        return this.state instanceof CityState.Camera;
    };
    /**
     * Set build state if current build state is different
     * @param tileType {Tile.Type} or {building}
     * @param input {BuildGridState}
     */
    City.prototype.setBuildState = function (tileType, input, tileVariance) {
        if (tileVariance === void 0) {
            tileVariance = null;
        }
        if (!tileType && tileType !== 0 || !input) {
            throw new MissingArgsError();
        }
        if (this.buildHelper.currentBuildTile === tileType && (!tileVariance && !this.buildHelper.currentBuildTileVariance || this.buildHelper.currentBuildTileVariance === tileVariance)) {
            return false;
        }
        if (this.buildHelper.buildCancelCb) {
            this.buildHelper.buildCancelCb();
        }
        this.buildHelper.currentBuildTile = (typeof tileType === "undefined" ? "undefined" : _typeof(tileType)) === 'object' && tileType.sheet ? tileType.sheet : tileType;
        this.buildHelper.currentBuildTileVariance = tileVariance;
        this.setState(new CityState.Build(this, input, tileType));
        this.buildSignal.dispatch('enter-build-state');
        this.grids.buildGrid.clearCurrentBuild();
        this.smartUpdateNext();
        if (!this.tutorial.tutorialActive) {
            this.easeCameraZoomForbuild();
        }
        // show structures on top of roads without upperstructurelayer
        this.upperStructureLayer.visible = false;
        var roadIsInFront = this.grids.roadGrid.z > this.grids.structureGrid.z;
        if (roadIsInFront) this.swap(this.grids.structureGrid, this.grids.roadGrid);
        return true;
    };
    City.prototype.easeCameraZoomForbuild = function () {
        this.cityScaler.easeZoomForVisibleNumTiles(Global.MIN_TILES_HORIZONTAL_VISIBLE_FOR_ZOOM);
    };
    City.prototype.easeCameraToTile = function (index, time, disableCamera) {
        if (time === void 0) {
            time = 1500;
        }
        if (disableCamera === void 0) {
            disableCamera = false;
        }
        this.game.camera.easeToTile(index, this, time, disableCamera);
    };
    City.prototype.easeCameraToSprite = function (s) {
        var isoIndex = Utils.isoToIndex(s.x, s.y, Tile.TILE_WIDTH);
        this.easeCameraToTile(isoIndex);
    };
    City.prototype.easeCameraAndZoomToTile = function (index, desiredZoom, cb) {
        var _this = this;
        if (cb === void 0) {
            cb = null;
        }
        desiredZoom = Utils.clamp(desiredZoom, Global.ZOOM_MIN, Global.ZOOM_MAX);
        var cameraMoveTime = Utils.getMoveTime(Utils.getCameraCentrePos(this), Utils.indexToPositionReuse(index.col, index.row));
        cameraMoveTime = Utils.clamp(cameraMoveTime, 500, 1250);
        var cameraScaleTime = Utils.getScaleTime(this.scale.x, desiredZoom);
        if (this.scale.x === desiredZoom) {
            // just ease to tile
            this.game.camera.easeToTile(index, this, cameraMoveTime, true, function () {
                if (cb) cb();
            });
        } else {
            // move then zoom if zooming in
            if (desiredZoom > this.scale.x) {
                this.game.camera.easeToTile(index, this, cameraMoveTime, true, function () {
                    _this.cityScaler.easeZoomToWithEasingIn(desiredZoom, cameraScaleTime, cb, index);
                });
            }
            // zoom out them move if zooming out
            else {
                    this.cityScaler.easeZoomToWithEasingIn(desiredZoom, cameraScaleTime, function () {
                        _this.game.camera.easeToTile(index, _this, cameraMoveTime, true, cb);
                    });
                }
        }
    };
    /** ease or jump camera to game start town hall */
    City.prototype.easeCameraToDefaultTownHall = function (animate, zoomAfter) {
        var _this = this;
        if (animate === void 0) {
            animate = true;
        }
        if (zoomAfter === void 0) {
            zoomAfter = false;
        }
        var initialFocus = Tutorial.START_FOCUS;
        var townHalls = this.structureCache.getTownHalls();
        if (townHalls.length > 0) {
            initialFocus = {
                row: townHalls[0].row,
                col: townHalls[0].col
            };
        }
        if (animate) {
            this._animatingCameraKeepUdate = true;
            this.easeCameraToTile(initialFocus, 1000, true);
            if (zoomAfter) {
                this.game.time.events.add(1101, function () {
                    _this.smartUpdateNext();
                    _this.cityScaler.easeZoomToWithEasingIn(_this.cityScaler.getDefaultZoom(), 1000, function () {
                        _this._animatingCameraKeepUdate = false;
                    }, initialFocus);
                });
            }
        } else {
            this.game.camera.centerAtIndex(this, initialFocus);
        }
    };
    City.prototype.slightZoomInTownHallAnim = function (numTilesShow) {
        var _this = this;
        var initialFocus = Tutorial.START_FOCUS;
        var townHalls = this.structureCache.getTownHalls();
        if (townHalls.length > 0) {
            initialFocus = {
                row: townHalls[0].row,
                col: townHalls[0].col
            };
        }
        this.game.camera.centerAtIndex(this, initialFocus);
        this.game.time.events.add(5, function () {
            _this.smartUpdateNext();
            _this.cityScaler.easeZoomToWithEasingIn(_this.cityScaler.getDefaultZoom(numTilesShow), 1000, function () {
                _this._animatingCameraKeepUdate = false;
                // show welcome region if it's first region city
                if (!_this.isSandbox) {
                    if (Region.getRegionMetadataForCityIndex(_this.cityIndex).length === 2) {
                        RegionUI.showRegionWelcome(_this);
                    }
                }
            }, initialFocus);
        });
    };
    City.prototype.exitBuildState = function () {
        // clear input resize handler
        this.buildHelper.currentBuildTile = null;
        this.buildHelper.exitBuildUI();
        this.buildSignal.dispatch('exit-build-state');
        this.updateSpeechVisibility();
        this.smartUpdateNext();
        this.cityEffects.hideCurrentUpgradedTileIcons();
        // Build grid should be clear - handles wierd floating tile issue
        for (var i = 0; i < this.grids.buildGrid.children.length; i++) {
            var t = this.grids.buildGrid.children[i];
            if (Utils.isValidIndex(t['row'], t['col'], this.size)) {
                this.grids.buildGrid.unsetTile(t['row'], t['col']);
            }
            Utils.destroyIfAlive(t);
        }
        // show structures on top of roads without upperstructurelayer,
        // will be hidden by updateHiddenLayersOutZoom() if needed
        this.upperStructureLayer.visible = true;
        var roadIsInFront = this.grids.roadGrid.z > this.grids.structureGrid.z;
        if (!roadIsInFront) this.swap(this.grids.structureGrid, this.grids.roadGrid);
        this.updateHiddenLayersOutZoom();
    };
    // Returns build state, if any
    City.prototype.getBuildGridState = function () {
        if (this.state instanceof CityState.Build) {
            return this.state.gridState;
        }
        return null;
    };
    // handled by cityScaler.zoomByDeltfaa
    City.prototype._killTweenOnResize = function (tween) {
        // Prune
        this.pruneResizeKillTweens();
        if (this._tweensKillOnResize.indexOf(tween) === -1) {
            this._tweensKillOnResize.push(tween);
        }
    };
    City.prototype.pruneResizeKillTweens = function () {
        if (this._tweensKillOnResize.length === 0) {
            return;
        }
        var t;
        var time = Utils.getGameMillis(this.game);
        for (var i = this._tweensKillOnResize.length - 1; i >= 0; i--) {
            t = this._tweensKillOnResize[i];
            if (t._isComplete || t._timestamp > time + 10000) {
                this._tweensKillOnResize.splice(i, 1);
            }
        }
    };
    City.prototype.tweenAndKillOnResize = function (sprite, to, time, ease, autostart, delay) {
        var t = this.game.add.tween(sprite).to(to, time, ease, autostart, delay);
        var millis = Utils.getGameMillis(this.game);
        t._killOnResizeCb = function () {
            for (var k in to) {
                if (to.hasOwnProperty(k)) {
                    sprite[k] = to[k];
                }
            }
            t._isComplete = true;
            t._timestamp = millis;
        };
        this._killTweenOnResize(t);
        return t;
    };
    /** Create fading rubble effect */
    City.prototype.setRubble = function (row, col, fadeTimeoutMultiplier) {
        if (fadeTimeoutMultiplier === void 0) {
            fadeTimeoutMultiplier = 1;
        }
        // Ignore if water
        if (this.grids.terrainGrid.isWaterAtIndex(row, col)) {
            return;
        }
        // only play if we aren't destroying terrain element
        var pos = Utils.indexToPositionReuse(col, row, Tile.TILE_WIDTH);
        if (Utils.isOnScreenPosition(this, pos.x, pos.y, 0, 0, Tile.TILE_WIDTH * 0.5)) {
            AudioPC.playBuildingCollapse(this.game); // rubble should always be from some kind of collapse
        }
        var rubble = this.rubblePool.allocate(fadeTimeoutMultiplier);
        rubble.resize(Tile.TILE_WIDTH, col, row);
        this.rubbleLayer.addChild(rubble);
    };
    City.prototype.destroyAllEntitiesAtTileFun = function (row, col) {
        this.animalManager.destroyAnimalFunIfExists(row, col);
        // graph entities
        this.roadGraph.destroyParkedCarsAtTile(row, col);
        [this.roadGraph, this.sidewalkGraph].forEach(function (g) {
            g.nodesAtIndex(row, col).forEach(function (n) {
                if (n.occupant) {
                    if (n.occupant.manager) {
                        n.occupant.manager.funDestroyEntity(n.occupant);
                    } else {
                        Utils.destroyIfAlive(n.occupant);
                    }
                }
            });
        });
        this.signalOncePostUpdate("destroyEntitiesAtIndex", { row: row, col: col });
    };
    City.prototype.safeGeneralDestroyTile = function (row, col, withDestroyPuff, withExtraDestruction, allowDestroyOnWater) {
        if (withDestroyPuff === void 0) {
            withDestroyPuff = false;
        }
        if (withExtraDestruction === void 0) {
            withExtraDestruction = false;
        }
        if (allowDestroyOnWater === void 0) {
            allowDestroyOnWater = false;
        }
        var g;
        for (var i = 0; i < this.generalAutoDestroy.length; i++) {
            g = this.generalAutoDestroy[i];
            if (g === this.grids.terrainGrid && this.grids.terrainGrid.isUsuallyIndestructible(row, col, allowDestroyOnWater)) return;
            this.safeDestroyTile(g, row, col, withDestroyPuff, withExtraDestruction);
        }
    };
    // Destroy tile with same effect as demolish build option
    City.prototype.safeDestroyTile = function (grid, row, col, withDestroyPuff, withExtraDestruction) {
        if (withDestroyPuff === void 0) {
            withDestroyPuff = false;
        }
        if (withExtraDestruction === void 0) {
            withExtraDestruction = false;
        }
        if (!grid) {
            return;
        }
        var group;
        var tile = grid.tiles[row][col];
        if (!tile) {
            return;
        }
        var tileType = tile.type;
        if (tile._master) {
            group = [tile._master].concat(tile._master._children);
        } else {
            group = [tile].concat(tile._children);
        }
        var t;
        for (var i = 0; i < group.length; i++) {
            t = group[i];
            if (this.ready && this.pocketCity.enableSpecialFX && this.performance.enableTerrainAnim) {
                if (t.type === Tile.Type.Terrain) {
                    this.cityEffects.burstSprite(t.row, t.col, true, 0.8);
                } else {
                    this.setRubble(t.row, t.col, 10);
                    var pos = Utils.indexToPositionReuse(t.col, t.row, Tile.TILE_WIDTH);
                    this.cityEffects.smokePuff(pos, 2.2, 3000);
                }
            }
            if (withDestroyPuff && this.performance.enableTerrainAnim && (grid === this.grids.zoneGrid || grid === this.grids.skyRailGrid || this.grids.roadGrid.hasTile(t.row, t.col))) {
                this.cityEffects.destroyBlockPuff(t.row, t.col);
            }
            if (withExtraDestruction && this.performance.enableTerrainAnim && grid === this.grids.zoneGrid) {
                if (t.type === Tile.Type.Industrial || t.type === Tile.Type.Structure) {
                    new Explosion(this, t.row, t.col);
                }
            }
        }
        grid.destroyTileIfExists(col, row, true);
        // prepare additional cleanup
        var removedRoadTiles = [];
        if (tileType === Tile.Type.Road) {
            removedRoadTiles.push([row, col]);
        }
        var touchingTiles = [];
        Utils.mapTouchingTiles(row, col, this.size, function (r, c) {
            touchingTiles.push([r, c]);
        });
        this.safeGridUpdateSideEffectsOnce(tileType, removedRoadTiles, touchingTiles);
    };
    City.prototype.safeGridUpdateSideEffectsOnce = function (tileType, removedRoadTiles, touchingTiles) {
        this._pendingRoadTilesUpdate = this._pendingRoadTilesUpdate || {
            tileTypes: {}, removedRoadTiles: [], touchingTiles: []
        };
        var i;
        this._pendingRoadTilesUpdate.tileTypes[tileType] = 1;
        for (i = 0; i < removedRoadTiles.length; i++) {
            this._pendingRoadTilesUpdate.removedRoadTiles.push(removedRoadTiles[i]);
        }
        for (i = 0; i < touchingTiles.length; i++) {
            this._pendingRoadTilesUpdate.touchingTiles.push(touchingTiles[i]);
        }
    };
    City.prototype.applyPendingSafeGridUpdateOnce = function () {
        if (!this._pendingRoadTilesUpdate) return;
        var tileTypes = [];
        Object.keys(this._pendingRoadTilesUpdate.tileTypes).forEach(function (t) {
            tileTypes.push(+t);
        });
        if (!this._cachedRemovedRoadTiles) {
            this._cachedRemovedRoadTiles = Utils.initialize2DArray(this.size, this.size, 0);
        } else {
            Utils.setAll2D(this._cachedRemovedRoadTiles, 0);
        }
        var removedRoadTiles = this._cachedRemovedRoadTiles;
        var _i;
        for (_i = 0; _i < this._pendingRoadTilesUpdate.removedRoadTiles.length; _i++) {
            var i = this._pendingRoadTilesUpdate.removedRoadTiles[_i];
            removedRoadTiles[i[0]][i[1]] = 1;
        }
        if (!this._cachedTouchingTiles) {
            this._cachedTouchingTiles = Utils.initialize2DArray(this.size, this.size, 0);
        } else {
            Utils.setAll2D(this._cachedTouchingTiles, 0);
        }
        var touchingTiles = this._cachedTouchingTiles;
        for (_i = 0; _i < this._pendingRoadTilesUpdate.touchingTiles.length; _i++) {
            var i = this._pendingRoadTilesUpdate.touchingTiles[_i];
            touchingTiles[i[0]][i[1]] = 1;
        }
        this._pendingRoadTilesUpdate = null;
        this.safeGridUpdateSideEffects(tileTypes, removedRoadTiles, touchingTiles);
    };
    City.prototype.safeGridUpdateSideEffects = function (tileTypes, removedRoadTiles, touchingTiles) {
        if (tileTypes.indexOf(Tile.Type.Road) !== -1) {
            this.grids.roadGrid.recalculateRoadTiles(removedRoadTiles, false);
            this.trafficGraphs.forEach(function (g) {
                return g.updateGraph(touchingTiles);
            });
            this.signalOncePostUpdate("roads_updated", this.grids.roadGrid.tiles);
            this.grids.skyRailGrid.ensureEndTilesValid();
        }
        if (tileTypes.indexOf(Tile.Type.SkyRail) !== -1) {
            this.refreshSignal.dispatch("sky_rail_refresh", touchingTiles);
            this.grids.skyRailGrid.ensureEndTilesValid(touchingTiles);
        }
        if (tileTypes.indexOf(Tile.Type.Structure) !== -1) {
            this.refreshSignal.dispatch("structures_updated");
        }
    };
    //
    // Resource related
    //
    /** Recalculate true value of resources (not just visual notifications)*/
    City.prototype.refreshResourceNotifications = function () {
        this.grids.zoneGrid.refreshNotifications();
    };
    //
    // Time related
    //
    /**
     * Returns an in-game day's length in a number of seconds.
     * Can change depending on game speed.
     * @returns {number}
     */
    // this should probably never change
    City.prototype.getSecondsPerDay = function () {
        return 1;
    };
    // this should probably never change either
    City.prototype.getMillisPerDay = function () {
        return this.getSecondsPerDay() * 1000;
    };
    /** Return total play time (persisted) */
    City.prototype.getTime = function () {
        return this.metadata.elapsedTime;
    };
    /** Destroy and remove from list any regsitered OOB cleanup sprites that are OOB */
    City.prototype.cleanupRegisteredOOB = function () {
        for (var i = this.cleanupOnOOB.length - 1; i >= 0; i--) {
            if (!Utils.isOnScreen(this, this.cleanupOnOOB[i])) {
                Utils.destroyIfAlive(this.cleanupOnOOB[i]);
                this.cleanupOnOOB.splice(i, 1);
            }
        }
    };
    /** Call this whenever the update() function needs to be forcefully called
     * (for non interactive re-draw, for example)
     */
    City.prototype.smartUpdateNext = function () {
        this._smartUpdate = true;
        this._fixedSmartUpdate = true;
        this._preserveSmartUpdateState = true;
    };
    City.prototype.dirtyTransformScaleNext = function () {
        this.scaleDirtyTransform = 2;
    };
    City.prototype.addTileMustForceTransform = function (tile) {
        this.tileMustForceTransform[tile.uid] = tile;
    };
    City.prototype.removeTileMustForceTransform = function (tile) {
        delete this.tileMustForceTransform[tile.uid];
    };
    City.prototype.updateAllTilesMustTransform = function () {
        for (var k in this.tileMustForceTransform) {
            if (this.tileMustForceTransform.hasOwnProperty(k)) {
                this.tileMustForceTransform[k].forceTransform();
            }
        }
    };
    // Forces smart update on each frame for the next duration while
    City.prototype.tempSmartUpdate = function (duration) {
        if (this._smartUpdateTmpTimer && this._smartUpdateTmpTimer > duration) {
            return;
        }
        this._smartUpdateTmpTimer = duration;
    };
    /** Should all smart update tasks be applied? */
    City.prototype.isForceSmartUpdate = function () {
        return this._fixedSmartUpdate || this._animatingCameraKeepUdate || this.game.camera._easeToTween || this._smartUpdateTmpTimer > 0 || this.tutorial.tutorialActive || this.isBuildingState() && this.cityEffects._animatingBuildEffect;
    };
    /** force transform structure grid and mask layer until detected that there is no construction */
    City.prototype.forceTransformStructures = function () {
        this._forceStructureTransform = true;
    };
    City.prototype.pushForcePrePostUpdateSprite = function (sprite, alsoUpdate) {
        if (alsoUpdate === void 0) {
            alsoUpdate = false;
        }
        if (alsoUpdate) {
            sprite._forceUpdateInLoop = true;
        } else {
            delete sprite._forceUpdateInLoop;
        }
        if (this._prePostUpdate.indexOf(sprite) === -1) {
            this._prePostUpdate.push(sprite);
        }
    };
    City.prototype.removeForcePrePostUpdateSprite = function (sprite) {
        var index = this._prePostUpdate.indexOf(sprite);
        if (index !== -1) {
            this._prePostUpdate.splice(index, 1);
        }
    };
    City.prototype.preUpdate = function () {
        if (!this.alive) {
            return; //a bit hacky safeguard
        }
        this.isZoomedOutFar = this.scale.x < Global.ZOOM_CACHE_AS_BITMAP;
        var forceSmartUpdate = this.isForceSmartUpdate();
        if (!forceSmartUpdate) {
            // Check if camera position has moved and update state var
            // If moved enough, set flag to update smart children
            // otherwise, set flag to ignore smart child  updates
            if (this.game.input.activePointer) {
                var activePosition = this.game.input.activePointer.position;
                if (this._isInputDown && (this.cameraState.lastY !== activePosition.y || this.cameraState.lastX !== activePosition.x)) {
                    this._smartUpdate = true;
                    this.cameraState.lastY = activePosition.y;
                    this.cameraState.lastX = activePosition.x;
                } else {
                    this._smartUpdate = false;
                }
            } else {
                this._smartUpdate = false;
            }
        }
        // Update self if needed by manual call or conscious decision
        if (forceSmartUpdate || this._smartUpdate) {
            _super.prototype.preUpdate.call(this);
            this._shouldTransform = true;
            this.cleanupRegisteredOOB();
        } else {
            this._shouldTransform = false;
        }
        this._forEachMustUpdate(function (component) {
            return component.preUpdate();
        });
        // Check if we should force structure grid / mask to update transform
        this._checkNoConstructionTimer -= this.game.time.elapsedMS;
        if (this._checkNoConstructionTimer <= 0) {
            if (this._forceStructureTransform && !this.grids.zoneGrid.hasVisibleTileInProgress()) {
                this._forceStructureTransform = false;
            }
            this._checkNoConstructionTimer = 1000;
        }
        this._preserveSmartUpdateState = false;
    };
    // Update the actual list of in-camera sprites that should be in the pre-post loop
    // only pre post update the ones whose parents are visible
    City.prototype.refreshVisibleForcePrePostUpdate = function () {
        this._loopInPostUpdate.length = 0;
        var mustPreUpdate = this._prePostUpdate;
        var a;
        for (var i = mustPreUpdate.length - 1; i >= 0; i--) {
            a = mustPreUpdate[i];
            if (a.alive) {
                if (!a.parent || a.parent.visible && (!a.parent.parent || a.parent.parent.visible)) {
                    this._loopInPostUpdate.push(a);
                }
            } else {
                // remove dead elements from this._prePostUpdate
                mustPreUpdate.splice(i, 1);
            }
        }
    };
    /**
     * Updates
     */
    City.prototype.update = function () {
        var _this = this;
        if (!this.ready || !this.alive) {
            // alive check is hacky safeguard
            return;
        }
        window['_worldIsSmall'] = this.scale.x < 0.3;
        var elapsedTime = this.game.time.elapsedMS;
        if (this._smartUpdateTmpTimer > 0) {
            this._smartUpdateTmpTimer -= elapsedTime;
        }
        // Handle inputs
        this.handleInput();
        // Update grid tile visibility if camera has moved
        var currentCameraIndex = Utils.cameraCenterIndexPrecise(this);
        if (Utils.indexMaxDiff(this.cameraState.lastCenterIndex, currentCameraIndex) > Global.TILE_CULLING_MOVE_DELTA_TRIGGER) {
            this.applyGridVisibility();
            this.cameraState.lastCenterIndex.row = currentCameraIndex.row;
            this.cameraState.lastCenterIndex.col = currentCameraIndex.col;
        } else {
            this.applyCullAgainCheck();
        }
        // force recalc when moving around map so cars appear faster and less time is empty space
        if (Utils.indexMaxDiff(this.cameraState.lastCenterIndexLg, currentCameraIndex) > Global.CAMERA_MOVE_SPAWN_CARS_TRIGGER) {
            this.performance.callOnce("spawnCarsMoveTriggered", 600, function () {
                _this.traffic.spawnCarsInContainer();
                _this.cameraState.lastCenterIndexLg.row = currentCameraIndex.row;
                _this.cameraState.lastCenterIndexLg.col = currentCameraIndex.col;
            });
        }
        // Update millis
        this.metadata.elapsedTime += elapsedTime;
        // Update non-phaser children who need to call update()
        var i;
        var max;
        for (i = 0, max = this._updateChildren.length; i < max; i++) {
            this._updateChildren[i].update(elapsedTime);
        }
        // Update traffic (timer)
        // break up timer to update only one component at a time
        this._trafficUpdateTimer -= elapsedTime;
        if (this._trafficUpdateTimer <= 0) {
            this._trafficUpdateTimer = Global.UPDATE_TRAFFIC_EVERY;
            this.commonTrafficUpdates[this._updateTickNum].update();
            this._updateTickNum += 1;
            if (this._updateTickNum === this.commonTrafficUpdates.length) {
                this._updateTickNum = 0;
            }
        }
        // Update traffic (camera move)
        else {
                if (this.traffic) {
                    this.updateIfCameraMovedBlock(this.traffic, Traffic.CONTAINER_BUFFER);
                }
            }
        // Update traffic sort timer
        this._trafficSortTimer -= elapsedTime;
        if (this._trafficSortTimer <= 0) {
            this._trafficSortTimer = Traffic.SORT_CARS_EVERY;
            this.traffic.sortCarsY();
        }
        // Updates sprites added to force update
        var s;
        for (i = 0; i < this._prePostUpdate.length; i++) {
            s = this._prePostUpdate[i];
            if (s._forceUpdateInLoop) {
                s.update();
            }
        }
        this.smileyHelper.update();
        // Update pending functions
        Utils.updateDelayFunctions(this.game);
        // Update non-crucial interval callbacks
        this.updateCallbacksUpdate(this.game.time.elapsedMS);
        // sync special layer above city
        this.effectOverDarkLayer.scale.y = this.scale.y;
        this.effectOverDarkLayer.scale.x = this.scale.x;
        this.effectOverDarkLayer.x = this.x;
        this.effectOverDarkLayer.y = this.y;
        try {
            _super.prototype.update.call(this);
        } catch (e) {
            // console.log(e);
            // console.log("Phaser group proto:");
            // console.log(Phaser.Group.prototype);
            // console.log("this:");
            // console.log(this);
            // console.log("WARN: failed update call for some reason:");
        }
        if (Global.DEBUG_FPS) {
            this.printVisibilityDebug();
        }
        if (Global.DEBUG_SHOW_SIDEWALK_GRAPH) {
            this.trafficGraphs.forEach(function (g) {
                return g.refreshDebugLines();
            });
            this.skyRailGraph.refreshDebugLines();
        }
        if (window['_crashTest']) {
            throw new Error("CRASH ERROR TEST");
        }
        // Update performance metrics
        this.lastFPS.push(this.game.time.fps);
        if (this.lastFPS) {
            this.lastAvgFPS = this.lastFPS.reduce(function (acc, v) {
                return acc + v;
            }, 0) / this.lastFPS.length;
        }
    };
    City.prototype.postUpdate = function () {
        var _this = this;
        if (!this.alive) {
            return; //a bit hacky safeguard
        }
        var forceSmartUpdate = this.isForceSmartUpdate();
        // Process combined signals
        for (var k in this.signalOnceKeys) {
            if (this.signalOnceKeys.hasOwnProperty(k)) {
                this.refreshSignal.dispatch(k, this.signalOnceKeys[k]);
                delete this.signalOnceKeys[k];
            }
        }
        // a bit hacky, but one-time execution of road recalc
        if (this._pendingRoadTilesUpdate) {
            this.applyPendingSafeGridUpdateOnce();
        }
        // clear handlers from last tick
        for (var i = 0; i < this.deregisterSignalHandlerNextTick.length; i++) {
            this.refreshSignal.remove(this.deregisterSignalHandlerNextTick[i]);
        }
        this.deregisterSignalHandlerNextTick.length = 0;
        // reset
        if (!this._preserveSmartUpdateState) {
            this._fixedSmartUpdate = false;
        }
        // Update self if needed
        if (forceSmartUpdate || this._smartUpdate) {
            _super.prototype.postUpdate.call(this);
        } else {
            // update structure layers forcefully
            if (this._forceStructureTransform) {
                this.grids.structureGrid.postUpdate();
            }
            // upper needs to always run post update due to z index insertions
            this.upperStructureLayer.postUpdate();
        }
        this._forEachMustUpdate(function (component) {
            return _this._applyPrePostUpdateComponent(component);
        });
        this.updateAllTilesMustTransform();
        this._prePostUpdateNext.length = 0;
        if (this.citySpeech) this.citySpeech.entityDieExclaimed = 0;
        // extra forces
        for (var k in this.forceTransformTiles) {
            if (this.forceTransformTiles.hasOwnProperty(k)) {
                if (!this.forceTransformTiles[k].alive) {
                    delete this.forceTransformTiles[k];
                } else {
                    this.forceTransformTiles[k].forceTransform();
                }
            }
        }
        for (var k in this.forceTransformSprites) {
            if (this.forceTransformSprites.hasOwnProperty(k)) {
                if (!this.forceTransformSprites[k].alive) {
                    delete this.forceTransformSprites[k];
                } else {
                    this.forceTransformSprites[k].updateTransform();
                }
            }
        }
        if (this.scaleDirtyTransform) {
            this.scaleDirtyTransform -= 1;
        }
    };
    // will call forceTransform()
    City.prototype.addForceTransformSprite = function (t) {
        this.forceTransformTiles[t.uid] = t;
    };
    // will call updateTransform()
    City.prototype.addTransformSprite = function (t) {
        this.forceTransformSprites[t.uid] = t;
    };
    City.prototype._forEachMustUpdate = function (cb) {
        // Normally, only call preupdate consistently on certain groups
        // _prePostUpdateNext gets reset to [] at end of update loop
        for (var i = 0; i < 2; i++) {
            var mustPreUpdate = this._prePostLists[i];
            var component = void 0;
            for (var i_1 = mustPreUpdate.length - 1; i_1 >= 0; i_1--) {
                component = mustPreUpdate[i_1];
                // the only way component is not alive is in _prePostUpdateNext
                if (component.alive && (!component.noAnimPastZoom || this.scale.x > component.noAnimPastZoom)) {
                    try {
                        cb(component);
                    } catch (e) {
                        // have no idea. maybe sometimes because we forget to deregister. eh, patch by removing this sprite from array
                        // also mark as dead so that it is cleaned during _loopInPostUpdate creation
                        component.alive = false;
                    }
                }
            }
        }
    };
    City.prototype._applyPrePostUpdateComponent = function (component) {
        component.preUpdate();
        component.postUpdate();
        component.updateTransform();
    };
    //
    // Timing
    //
    City.prototype.registerCallbackUpdateEvery = function (fn, millis) {
        this._slowUpdateFns.push({
            fn: fn,
            every: millis,
            timer: 0
        });
    };
    // does not fire if city is destroyed
    City.prototype.registerSafeTimeout = function (cb, delay) {
        var _this = this;
        if (delay === void 0) {
            delay = 0;
        }
        setTimeout(function () {
            if (!_this.game) return;
            cb();
        }, delay);
    };
    /** Only fires callback if sprite still exists and is visible and sprite must be alive*/
    City.prototype.delayEventWithSpriteCheck = function (delay, sprite, callback, callbackWhenInvisible) {
        var _this = this;
        if (callbackWhenInvisible === void 0) {
            callbackWhenInvisible = false;
        }
        if (isNaN(delay)) {
            console.warn("NaN delay passed, returning");
            return;
        }
        this.game.time.events.add(delay, function () {
            if (_this.game && sprite && (sprite.visible || callbackWhenInvisible) && sprite.alive) {
                callback();
            }
        });
    };
    City.prototype.delayEventWithCityCheck = function (delay, callback) {
        var _this = this;
        if (isNaN(delay)) {
            console.warn("NaN delay passed, returning");
            return;
        }
        this.game.time.events.add(delay, function () {
            if (_this.alive) {
                callback();
            }
        });
    };
    City.prototype.loopWithSpriteCheck = function (interval, spriteAlive, cb) {
        var _this = this;
        var l = this.game.time.events.loop(interval, function () {
            if (_this.game && spriteAlive.alive) {
                cb();
            } else {
                if (_this.game) {
                    _this.game.time.events.remove(l);
                }
            }
        });
    };
    /** run any slow updates that need to be run */
    City.prototype.updateCallbacksUpdate = function (elapsed) {
        if (!this) {
            return;
        }
        var o;
        for (var i = 0, max = this._slowUpdateFns.length; i < max; i++) {
            o = this._slowUpdateFns[i];
            o.timer -= elapsed;
            if (o.timer <= 0) {
                o.fn();
                o.timer = o.every;
            }
        }
    };
    // not necessarily centre
    City.prototype.updateCurrentCameraTile = function () {
        var cameraPos = Utils.getScaledCameraPosition(this);
        var tmp = Utils.isoToIndexReuse(cameraPos.x, cameraPos.y, this.getTileSize());
        this._cameraTile.col = tmp.col;
        this._cameraTile.row = tmp.row;
    };
    /** Update if the camera has moved a block of grid enough to trigger it */
    City.prototype.updateIfCameraMovedBlock = function (component, amt) {
        this.updateCurrentCameraTile();
        var cameraIndex = this._cameraTile;
        if (!component._lastCameraUpdatePos) {
            component._lastCameraUpdatePos = { col: cameraIndex.col, row: cameraIndex.row };
            component.update();
        } else if (Utils.indexDistTotal(cameraIndex, component._lastCameraUpdatePos) > amt) {
            // moved enough for update
            component._lastCameraUpdatePos.row = cameraIndex.row;
            component._lastCameraUpdatePos.col = cameraIndex.col;
            component.update();
        }
    };
    City.prototype.toggleInspectTile = function (tile) {
        if (this._inspectingTile === tile) {
            this.gameplayUI.showDefaultView();
        } else {
            this.inspectTile(tile);
        }
    };
    City.prototype.inspectTile = function (tile) {
        var _this = this;
        if (!this._prePostUpdate) {
            return;
        }
        if (Global.DEBUG_DISABLE_CANVAS_UI) {
            return;
        }
        if (this.tutorial.tutorialActive || this.gameplayUI._unlockDialogueStarted || this.buyLandMode) {
            return;
        }
        Utils.debugLog("Debug: inspecting", tile.row, tile.col);
        // update UI
        this.gameplayUI.inspectTile(tile);
        var structureGroup = tile.structureGroup;
        var dimensions = structureGroup.tileDimensions;
        // Moving special structures
        MainUI.Move.checkShowMoveTopRight(tile);
        if (this.pocketCity.enableSpecialFX) {
            setTimeout(function () {
                _this.pushForcePrePostUpdateSprite(structureGroup);
                _this.pushForcePrePostUpdateSprite(structureGroup.upperMaskSprite);
                structureGroup.bounceEffect(-0.4, 1000, function () {
                    _this.removeForcePrePostUpdateSprite(structureGroup);
                    _this.removeForcePrePostUpdateSprite(structureGroup.upperMaskSprite);
                });
                _this.tempSmartUpdate(1001);
            }, 0);
        }
        this.cityUI.highlightSelect.visible = true;
        var xOffset = 0;
        var yOffset = 0;
        var leanOffset = 0.25;
        if (dimensions.col == 1 && dimensions.row == 1) {
            yOffset = -0.1;
        }
        if (dimensions.col == 1 && dimensions.row == 2) {
            xOffset = leanOffset;
            yOffset = -leanOffset;
        }
        if (dimensions.col == 2 && dimensions.row == 1) {
            xOffset = -leanOffset;
            yOffset = -leanOffset;
        }
        if (dimensions.col == 2 && dimensions.row == 2) {
            yOffset = -leanOffset;
        }
        this.cityUI.moveHighlightSelect(tile.col, tile.row, xOffset, yOffset);
        this._inspectingTile = tile;
        AudioPC.playUIClick();
        // Special side effects
        if (tile.building) {
            switch (tile.building.type) {
                case "water":
                    this.focusWaterGrid();
                    break;
                case "power":
                    this.focusPowerGrid();
                    break;
            }
        }
        this.smartUpdateNext();
    };
    /** THIS SOULD ONLY BE CALLED BY gampelayUI's showDefaultView */
    City.prototype.uninspectTile = function () {
        if (Global.DEBUG_DISABLE_CANVAS_UI || !this._inspectingTile) {
            return;
        }
        this._inspectingTile = null;
        this.cityUI.highlightSelect.visible = false;
        this.clearFocusAnyGrid();
    };
    City.prototype.createTilePreferPool = function (tileType, x, y) {
        if (x === void 0) {
            x = 0;
        }
        if (y === void 0) {
            y = 0;
        }
        var pool = this.getTileClassPool(tileType);
        if (pool) {
            var s = pool.allocate();
            s.x = x;
            s.y = y;
            return s;
        } else {
            return Tile.createTileSprite(this, tileType, x, y);
        }
    };
    City.prototype.getTileClassPool = function (tileType) {
        switch (tileType) {
            case Tile.Type.Residential:
                return this.residentialTilePool;
            case Tile.Type.Commercial:
                return this.commercialTilePool;
            case Tile.Type.Industrial:
                return this.industrialTilePool;
            case Tile.Type.Road:
                return this.roadTilePool;
            case Tile.Type.Rubble:
                return this.rubbleTilePool;
            case Tile.Type.Structure:
                return this.structureTilePool;
            case Tile.Type.White:
                return this.whiteTilePool;
            case Tile.Type.Demolish:
                return this.demolishTilePool;
            default:
                return null;
        }
    };
    City.prototype.isPolicyActive = function (policyCode) {
        return Policy.isPolicyActive(this, policyCode);
    };
    //
    // Extra input
    //
    // Overlay window input sprite with disabled sprite to stop all input registration
    City.prototype.disableInput = function () {
        this.windowDisabledInput.inputSprite.visible = true;
    };
    City.prototype.enableInput = function () {
        this.windowDisabledInput.inputSprite.visible = false;
    };
    /**
     * Destroy
     */
    City.prototype.destroy = function () {
        var _this = this;
        if (!this.game) {
            return; // already destroyed
        }
        this.alive = false;
        if (this.tutorial.tutorialActive) {
            this.tutorial.resetTutorialUIBeforeEnd();
        }
        this.clearFocusAnyGrid();
        this.gameplayUI.clearSubBuildSelects();
        // destroy grids
        for (var k in this.grids) {
            if (this.grids.hasOwnProperty(k)) {
                Utils.destroyIfAlive(this.grids[k]);
            }
        }
        if (this.windowInput.inputSprite) {
            this.windowInput.inputSprite.events.onInputDown.removeAll();
            this.windowInput.inputSprite.events.onInputUp.removeAll();
        }
        Utils.destroyIfAlive(this.windowInput.inputSprite);
        Utils.destroyIfAlive(this.buildGridBg.mask);
        Utils.destroyIfAlive(this.cityEffects.whiteBuildRectangle.mask);
        if (this.game) {
            this.game.time.events.stop(true);
            this.game.tweens.removeAll();
        }
        AudioPC.stopAll();
        this.commonTrafficUpdates.forEach(function (t) {
            return t.destroy();
        });
        this.initGameplayReset();
        this._extraRegisterForDestroy.forEach(function (c) {
            return Utils.destroyIfAlive(c);
        });
        // Detach outdated bindings
        ['onPause', 'onResume'].forEach(function (k) {
            _this.game[k]._bindings = _this.game[k]._bindings.filter(function (a) {
                return !(a.context instanceof Phaser.Animation);
            });
        });
        if (this.windowInput.inputSprite) {
            this.windowInput.cleanUp();
        }
        this.refreshSignal.removeAll();
        this.inputSignal.removeAll();
        this.buildSignal.removeAll();
        this.eventSignal.removeAll();
        _super.prototype.destroy.call(this);
        // try to free memory
        var c;
        for (var i = 0; i < this.children.length; i++) {
            c = this.children[i];
            if (c['city']) {
                c['city'] = null;
            }
        }
        Utils.nukeReferences(this.grids); // at least get rid of grid's child references, even if city somehow gets leaked
        Utils.nukeReferences(this);
        this.game = null;
    };
    //
    // DEBUG
    //
    City.prototype.handleDebugDown = function () {
        var index = Grid.currentTouchedIndex(this, this.getTileSize());
        if (index) {
            var tile = this.grids.zoneGrid.tiles[index.row][index.col];
        }
    };
    City.prototype.handleDebugFireClickDown = function () {
        var index = Grid.currentTouchedIndex(this, this.getTileSize());
        if (!index) {
            return;
        }
        var tile = this.grids.structureGrid.tiles[index.row][index.col];
        if (tile) {
            this.fireManager.setOnFire(tile);
            return;
        }
    };
    City.prototype.logFPS = function () {
        var msg = "Average fps is " + this.fpsTotal / this.fpsCountTotal + " after " + this.game.time.totalElapsedSeconds() + " seconds";
        console.log(msg);
        return msg;
    };
    City.prototype.printVisibilityDebug = function () {
        var PRINT_EVERY_X_TICKS = 60;
        this._debugTicks = this._debugTicks || 1;
        this._debugTicks += 1;
        if (this._debugTicks < PRINT_EVERY_X_TICKS) {
            return;
        }
        this._debugTicks = 1;
        if (Global.DEBUG_FPS) {
            var threshold = 20;
            var fps = this.game.time.fps;
            this.game.debug.text(fps || '--', 40, 165, "#ffffff");
            //console.log(fps);
            if (Global.DEBUG_FPS_ADDITIONAL) {
                if (!this.startedFpsCount && fps > threshold) {
                    this.startedFpsCount = true;
                }
                if (this.startedFpsCount) {
                    if (typeof this.fpsCountTotal === "undefined") {
                        this.fpsCountTotal = 0;
                    }
                    if (typeof this.fpsTotal === "undefined") {
                        this.fpsTotal = 0;
                    }
                    this.fpsCountTotal += 1;
                    this.fpsTotal += fps;
                    // avg
                    this.game.debug.text("FPS av: " + Math.round(this.fpsTotal / this.fpsCountTotal) || '--', 20, 184, "#ffffff");
                    this.game.debug.text("res: " + this.pocketCity.canvasResizer.dimensionRatio || '--', 20, 205, "#ffffff");
                    //console.log("avg fps: "+(this.fpsTotal / this.fpsCountTotal));
                }
                // version
                this.game.debug.text("version 0.4.2", 20, 194, "#ffffff");
            }
        }
    };
    City.DEFAULT_NAME = "Pocket City";
    City.TRAFFIC_LABEL = "traffic";
    City.STRUCT_BASE_Y_CACHE = {};
    City.STRUCT_BASE_SCALE_CACHE = {};
    return City;
}(Phaser.Group);
Utils.extend(City.prototype, WithState);
(function (City) {
    // fill in missing default states
    City.defaultMetadata = function (citySize) {
        return {
            "name": City.DEFAULT_NAME,
            "creationDate": Date.now(),
            "elapsedTime": 0,
            "size": citySize,
            "isSandbox": false,
            "fastTerrain": true,
            "sandboxWithMoney": false
        };
    };
    // fill in missing default states
    City.defaultStats = function (citySize, city) {
        var cityBlockSize = Global.CITY_BLOCK_SIZE;
        var cityInitialBlocks = Global.CITY_INITIAL_BLOCKS_UNLOCKED_DIM;
        if (citySize < Global.CITY_BLOCK_SIZE || citySize % Global.CITY_BLOCK_SIZE !== 0) {
            console.log("WARN: City block divisor does not divide evenly into grid size or city size is too small - defaulting to block divisor = 1");
            cityBlockSize = citySize;
            cityInitialBlocks = 1;
        }
        return {
            // Persisted stats
            "money": Global.START_CASH,
            "population": 1,
            "finishedTutorial": true,
            "internalVersion": 0,
            "numTiles": 4,
            "regions": Region.DEFAULT_REGION_LIST,
            "policies": [],
            "income": 0,
            "regionType": Region.REGION_TYPES.PLAINS,
            "isNeighbor": false,
            // Zone unlocks
            "unlocks": City.createCityBlockUnlockSetting(city, cityBlockSize, cityInitialBlocks),
            // Quest completion
            "activeQuests": [],
            "newQuests": [],
            "completedQuests": [],
            "archivedQuests": [],
            // Events unlocked & activated
            "unlockedEventsIds": [],
            "metricModifiers": {},
            // Levelups
            "level": 1,
            "pendingRewardLevels": 0,
            "exp": 0,
            // config, not really stats, but nice to save random data here
            "globalSettings": {}
        };
    };
})(City || (City = {}));
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 *  Used in conjunction with Phaser render edit
 *  don't loop children that are invisible from culling
 */
var TrackCulledChildrenLayer = /** @class */function (_super) {
    __extends(TrackCulledChildrenLayer, _super);
    function TrackCulledChildrenLayer(city, disableCullTrack, autoResize) {
        if (disableCullTrack === void 0) {
            disableCullTrack = false;
        }
        if (autoResize === void 0) {
            autoResize = false;
        }
        var _this = _super.call(this, city.game) || this;
        _this.trackedHash = {};
        _this.cullPtr = 0;
        _this.cullAgain = false;
        _this.resetClusterOnDepthSort = false;
        _this.clusterMaxY = ClusterFinder.CLUSTER_BATCH_MAX_Y_DIFF;
        _this.clusterMinX = ClusterFinder.CLUSTER_MIN_X_DIFF;
        _this.city = city;
        //this.culledInvisibleChildren = [];
        _this.disableCullTrack = disableCullTrack;
        if (!disableCullTrack) {
            _this.culledVisibleChildren = [];
            _this._swapCulledVisibleChildren = [];
        }
        if (autoResize) {
            _this.city.registerSignalHandler("zoom_updated", function (event, prevZoom, newZoom) {
                _this.resizeAll(prevZoom, newZoom);
            });
        }
        return _this;
    }
    ;
    TrackCulledChildrenLayer.prototype.preUpdate = function () {
        // prune dead children
        for (var i = this.culledVisibleChildren.length - 1; i >= 0; i--) {
            if (!this.culledVisibleChildren[i].alive || this.culledVisibleChildren[i]._freeInPool) {
                this.culledVisibleChildren[i].parent = undefined;
                this.culledVisibleChildren.splice(i, 1);
            }
        }
        _super.prototype.preUpdate.call(this);
    };
    TrackCulledChildrenLayer.prototype.checkCullAgain = function () {
        if (this.cullAgain) {
            this.applyCullChildren();
        }
    };
    TrackCulledChildrenLayer.prototype.add = function (sprite) {
        _super.prototype.add.call(this, sprite);
        if (this.disableCullTrack) {
            return;
        }
        if (sprite.visible) {
            this.setVisible(sprite);
        }
        return sprite;
    };
    ;
    TrackCulledChildrenLayer.prototype.addChild = function (sprite) {
        _super.prototype.addChild.call(this, sprite);
        if (this.disableCullTrack) {
            return;
        }
        if (sprite.visible) {
            this.setVisible(sprite);
        }
        return sprite;
    };
    ;
    TrackCulledChildrenLayer.prototype.resetCullChildren = function () {
        this._swapCulledVisibleChildren.length = 0;
    };
    TrackCulledChildrenLayer.prototype.flushSwapCull = function () {
        this.culledVisibleChildren.length = 0;
        var i;
        for (i = 0; i < this._swapCulledVisibleChildren.length; i++) {
            this.culledVisibleChildren.push(this._swapCulledVisibleChildren[i]);
        }
        this._swapCulledVisibleChildren.length = 0;
        // reset hash
        for (var key in this.trackedHash) {
            if (this.trackedHash.hasOwnProperty(key)) {
                this.trackedHash[key] = 0;
            }
        }
        // reset visibility
        for (i = 0; i < this.children.length; i++) {
            this.children[i].visible = false;
        }
        for (i = 0; i < this.culledVisibleChildren.length; i++) {
            this.culledVisibleChildren[i].visible = true;
            this.pushLiveHashChild(this.culledVisibleChildren[i]);
        }
        this.onCullDone();
    };
    TrackCulledChildrenLayer.prototype.onCullDone = function () {
        // apply sorted cluster render
        if (this.resetClusterOnDepthSort) {
            this.setClusterDirty(true);
        }
    };
    TrackCulledChildrenLayer.prototype.pushPendingCullChild = function (s) {
        this._swapCulledVisibleChildren.push(s);
    };
    TrackCulledChildrenLayer.prototype.pushLiveHashChild = function (s) {
        if (s.uid) {
            if (this.trackedHash[s.uid]) {
                return;
            }
            this.trackedHash[s.uid] = 1;
        }
    };
    // getBufferSize():number{
    //     return TrackCulledChildrenLayer._getBufferSize(this.city);
    // }
    // static _getBufferSize(city):number{
    //     return Global.TILE_WIDTH * Global.TILE_CULLING_BUFFER;
    //     if (city.performance.avgFps < 15){
    //         return Global.TILE_WIDTH
    //     } else if (city.performance.avgFps < 22){
    //         return Global.TILE_WIDTH * 2;
    //     } else {
    //         return Global.TILE_WIDTH * Global.TILE_CULLING_BUFFER; // default
    //     }
    // }
    TrackCulledChildrenLayer.prototype.applyCullChildren = function () {
        if (!this.culledVisibleChildren) {
            console.log("WARN: this group does has culling disabled - this should probably not be called since it won't get autoupdted");
            if (this instanceof Grid) {
                console.log("WARN: since this is a grid, the argument to disable culling was probably passed");
            }
        }
        var extraZoomBuffer = 2 - Math.min(1, this.city.scale.x);
        var buffer = TrackCulledChildrenLayer.CULL_BUFFER_BASE * extraZoomBuffer;
        var disableCullTrack = this.disableCullTrack;
        //this.culledInvisibleChildren.length = 0;
        if (!disableCullTrack && !this.cullAgain) {
            this.resetCullChildren();
        }
        var cameraBox = Utils.cameraBox(this.city, 1);
        var startIndex = this.cullPtr;
        var endIndex = startIndex + TrackCulledChildrenLayer.CULL_BATCH_SIZE;
        var numProcessed = 0;
        var _visible;
        for (var i = 0, max = this.children.length; i < max; i++) {
            var child = this.children[i];
            if (i >= startIndex && i < endIndex) {
                numProcessed += 1;
                if (!child['noCull']) {
                    _visible = child.x >= cameraBox.xLeft - buffer && child.x <= cameraBox.xRight + buffer && child.y >= cameraBox.yTop - buffer && child.y <= cameraBox.yBottom + buffer;
                } else {
                    _visible = child.visible;
                }
                if (!disableCullTrack && _visible) {
                    this.pushPendingCullChild(child);
                }
            }
        }
        this.cullPtr = startIndex + numProcessed;
        if (this.cullPtr >= this.children.length) {
            this.cullPtr = 0;
        }
        this.cullAgain = this.cullPtr !== 0;
        if (!this.cullAgain) {
            this.flushSwapCull();
        }
    };
    ;
    TrackCulledChildrenLayer.prototype.resetCull = function () {
        this.cullAgain = false;
        this.cullPtr = 0;
        this._swapCulledVisibleChildren = [];
    };
    // Remove from live cull, and pending cull
    TrackCulledChildrenLayer.prototype.setInvisible = function (s) {
        if (s.uid) {
            this.trackedHash[s.uid] = 0;
        }
        this.removeFromBuffer(this._swapCulledVisibleChildren, s);
        this.removeFromBuffer(this.culledVisibleChildren, s);
    };
    ;
    // Set visible in live and pending
    TrackCulledChildrenLayer.prototype.setVisible = function (child) {
        if (child.uid) {
            if (this.trackedHash[child.uid]) {
                // already visible
                return;
            }
            this.pushLiveHashChild(child);
        }
        // slower way
        this.insertIntoBuffer(this._swapCulledVisibleChildren, child);
        this.insertIntoBuffer(this.culledVisibleChildren, child);
    };
    ;
    TrackCulledChildrenLayer.prototype.removeFromBuffer = function (buffer, s) {
        var index = buffer.indexOf(s);
        if (index !== -1) {
            buffer.splice(index, 1);
        }
    };
    TrackCulledChildrenLayer.prototype.insertIntoBuffer = function (buffer, s) {
        if (buffer.indexOf(s) === -1) {
            buffer.push(s);
        }
    };
    // IF child is already up to date, ensure this track layer is tracing the child correctly
    TrackCulledChildrenLayer.prototype.ensureTrackedUpdated = function (child) {
        if (child.visible) {
            this.setVisible(child);
        } else {
            this.setInvisible(child);
        }
    };
    ;
    TrackCulledChildrenLayer.checkVisibility = function (child, city) {
        var buffer = TrackCulledChildrenLayer.CULL_BUFFER_BASE;
        var cameraPos = Utils.getScaledCameraPosition(city);
        var cameraDim = Utils.getScaledCameraHeight(city);
        return child.x >= cameraPos.x - buffer && child.x <= cameraPos.x + cameraDim.width + buffer && child.y >= cameraPos.y - buffer && child.y <= cameraPos.y + cameraDim.height + buffer;
    };
    TrackCulledChildrenLayer.CULL_BATCH_SIZE = 1500;
    TrackCulledChildrenLayer.CULL_BUFFER_BASE = Global.TILE_WIDTH * Global.TILE_CULLING_BUFFER;
    return TrackCulledChildrenLayer;
}(Phaser.Group);
Utils.extend(TrackCulledChildrenLayer.prototype, WithAutoResize);
Utils.extend(TrackCulledChildrenLayer.prototype, WithClusterSortMixin);
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Grid
 * Main grid object, manages tile sprites inside a grid.
 *
 * Input processor depends on grid state.
 *
 * @param city {City}
 * @param windowInput {WindowInputSprite} - Shared sprite used as event listener
 * @param size {int} - Size of grid
 * @param [defaultTileType] {Tile.Type} - Optional default tile type to fill grid
 * @param [trackTiles] {Boolean} - Optional, track tiles in hash, optimal for grids with small amount of tiles
 * @param [disableCullTrack]
 * @constructor
 */
var Grid = /** @class */function (_super) {
    __extends(Grid, _super);
    function Grid(city, size, windowInput, defaultTileType, trackTiles, disableCullTrack) {
        var _this = _super.call(this, city, disableCullTrack) || this;
        _this._gridsUpdateTimer = Global.UPDATE_GRID_TILES_EVERY_X_MILLIS;
        _this._autoSmartUpdate = true;
        _this._updateTick = 0;
        _this._shouldTransform = false;
        _this._boolGridCached = null;
        _this._trackedTiles = null;
        _this._trackedTilesCount = -1;
        _this._cachedTileCount = null; // unset whenever set or unset is called
        _this.tileCount = {};
        _this.sortOverrideFn = null;
        var self = _this;
        _this.city = city;
        _this.game = city.game;
        _this.size = size;
        _this.inputSprite = windowInput; // to prevent same touch from affecting multiple components
        // Array of all tiles
        _this.tiles = Grid.createEmptyTileSprites(size);
        if (defaultTileType) {
            _this.createTileSprites(size, defaultTileType);
        }
        // Add tiles to grid sprite group
        Utils.apply2D(_this.tiles, function (tileSprite) {
            if (tileSprite) {
                self.add(tileSprite);
            }
        });
        // Hash to cache tile positions
        if (trackTiles) {
            _this._trackedTiles = {};
        }
        _this.city.add(_this);
        return _this;
    }
    Grid.prototype.getBooleanGridCached = function (emptyVal) {
        if (emptyVal === void 0) {
            emptyVal = 0;
        }
        if (!this._boolGridCached) {
            this._boolGridCached = this.getBooleanGrid(emptyVal);
        }
        return this._boolGridCached;
    };
    Grid.prototype.clearCachedBool = function () {
        this._boolGridCached = null;
    };
    Grid.prototype.getBooleanGrid = function (emptyVal, reuse) {
        if (emptyVal === void 0) {
            emptyVal = null;
        }
        if (reuse === void 0) {
            reuse = false;
        }
        var tempBoolTiles = reuse ? Utils.getReusableBoolGrid() : Utils.initialize2DArray(this.size);
        var tile;
        for (var i = 0; i < this.size; i++) {
            for (var j = 0; j < this.size; j++) {
                tile = this.tiles[i][j];
                if (tile) {
                    tempBoolTiles[i][j] = 1;
                } else {
                    tempBoolTiles[i][j] = emptyVal;
                }
            }
        }
        return tempBoolTiles;
    };
    /** Set this grid to match another grid using white tiles */
    Grid.prototype.copyWhiteTilesOtherGrid = function (otherGrid) {
        this.syncWhiteTilesToBooleanGrid(otherGrid.getBooleanGrid());
    };
    Grid.prototype.syncWhiteTilesToBooleanGrid = function (booleanGrid) {
        var _this = this;
        this.clearTiles(this.city.whiteTilePool);
        Utils.foreach2D(booleanGrid, function (shouldShow, row, col) {
            if (shouldShow) {
                _this.setLargeTileAsPossible(booleanGrid, row, col);
            }
        });
    };
    /** sets multi-size tile and update buildBoolean to not build on top again */
    Grid.prototype.setLargeTileAsPossible = function (buildBoolean, baseRow, baseCol) {
        var dist = 0; // just 1 tile to start
        var size = buildBoolean.length;
        while (true) {
            var needsBreak = false;
            var horizontalRow = baseRow + dist + 1;
            var verticalCol = baseCol + dist + 1;
            // horizontal iteration
            for (var c = baseCol; c <= baseCol + dist + 1; c++) {
                if (!Utils.isValidIndex(horizontalRow, c, size) || !buildBoolean[horizontalRow][c]) {
                    needsBreak = true;
                    break;
                }
            }
            for (var r = baseRow; r <= baseRow + dist + 1; r++) {
                if (!Utils.isValidIndex(r, verticalCol, size) || !buildBoolean[r][verticalCol]) {
                    needsBreak = true;
                    break;
                }
            }
            if (needsBreak) break; // this is just to make IDE happy i think
            dist += 1;
            if (dist === ResourceOnRoadGrid.MAX_DIST) {
                break; // otherwise too low quality
            }
        }
        // now actually create the tile
        var newTile = this.city.whiteTilePool.allocate();
        // choose right frame for size
        if (dist > 2) {
            newTile.setAsExtraLargeSize();
        } else if (dist > 0) {
            newTile.setAsLargeSize();
        }
        this.applyTint(newTile);
        this.setTile(baseRow, baseCol, newTile);
        // Scale micro-adjustment based on size
        if (dist > 0) {
            newTile.width *= dist + 1;
            newTile.height *= dist + 1;
        }
        // Y offset micro adjustment based on size
        var percentAdjust = dist / ResourceOnRoadGrid.MAX_DIST;
        var offsetY = percentAdjust * ResourceOnRoadGrid.MAX_Y_ADJUST;
        newTile.y += Tile.TILE_WIDTH * 0.5 * dist + offsetY;
        var scale = 1 - (ResourceOnRoadGrid.MIN_SCALE_REDUCE + percentAdjust * ResourceOnRoadGrid._MIN_MAX_SCALE_REDUCE_DELTA);
        newTile.width *= scale;
        newTile.height *= scale;
        // now update buildBoolean to not build again in this round
        Utils.loopRectangle({
            row: baseRow, col: baseCol
        }, {
            row: baseRow + dist,
            col: baseCol + dist
        }, size, function (r, c) {
            buildBoolean[r][c] = false;
        });
    };
    Grid.prototype.applyTint = function (tile) {
        tile.tint = this.TINT_COLOR;
    };
    Grid.prototype.tileSize = function () {
        return this.city.getTileSize();
    };
    Grid.prototype.isTileType = function (row, col, tileType, variantType) {
        return Utils.isValidIndex(row, col, this.size) && this.tiles[row][col] && this.tiles[row][col].type === tileType && (!variantType || this.tiles[row][col].variantType === variantType);
    };
    //
    // Update related
    //
    Grid.prototype.updateTransform = function (forceRun) {
        if (this._autoSmartUpdate && !this.city._shouldTransform && !this.cacheAsBitmap && !forceRun && !this._shouldTransform) {
            return;
        }
        if (!this.visible) {
            return;
        }
        _super.prototype.updateTransform.call(this);
    };
    Grid.prototype.update = function (forceUpdate) {
        if (!this.visible) {
            return;
        }
        if (!forceUpdate && this._autoSmartUpdate && !this.city._smartUpdate && !this.cacheAsBitmap) {
            return;
        }
        // Call handleInput on current state using input window sprite
        this.handleInput();
        var children = this.disableCullTrack ? this.children : this.culledVisibleChildren;
        this._gridsUpdateTimer -= this.game.time.elapsedMS;
        if (this._gridsUpdateTimer <= 0) {
            this._gridsUpdateTimer = Global.UPDATE_GRID_TILES_EVERY_X_MILLIS;
            this._updateTick = (this._updateTick + 1) % Global.UPDATE_GRID_NON_PRIORITY_TILES_SKIP_EVERY_X_TICK;
            //  Goes in reverse, because it's highly likely the child will destroy itself in `update`
            var i = children.length;
            while (i--) {
                if (this._updateTick === 0 || children[i]['_priorityUpdate']) {
                    children[i].update();
                }
            }
        }
    };
    Grid.prototype.preUpdate = function () {
        // Totally de-activated
    };
    Grid.prototype.postUpdate = function () {
        // Totally de-activated
        this.ensureZIndexUpdated();
    };
    Grid.forClosestNeighborTile = function (grid, index, person, tileSize, fn, alsoConsiderSelf) {
        var centerPosition = Utils.indexToPositionReuse(index.col, index.row, tileSize);
        var t2;
        if (alsoConsiderSelf) {
            t2 = grid.getTile(index.col, index.row);
            if (t2) {
                fn(t2);
                return;
            }
        }
        if (person.x >= centerPosition.x && person.y >= centerPosition.y) {
            // bottom right
            t2 = grid.getTile(index.col + 1, index.row);
            if (t2) fn(t2);
        } else if (person.x <= centerPosition.x && person.y >= centerPosition.y) {
            // bottom left
            t2 = grid.getTile(index.col, index.row + 1);
            if (t2) fn(t2);
        } else if (person.x >= centerPosition.x && person.y <= centerPosition.y) {
            // top right
            t2 = grid.getTile(index.col, index.row - 1);
            if (t2) fn(t2);
        } else if (person.x <= centerPosition.x && person.y <= centerPosition.y) {
            // top left
            t2 = grid.getTile(index.col - 1, index.row);
            if (t2) fn(t2);
        }
    };
    /**
     * Get the tile at index. May return null;
     * @param arg1 {JSON | number} - Index object or column
     * @param [row] {number}
     * @returns {Tile | Null}
     */
    Grid.prototype.getTile = function (arg1, row) {
        if (arg1 && (typeof arg1 === 'undefined' ? 'undefined' : _typeof(arg1)) === 'object') {
            var row_1 = arg1.row,
                col = arg1.col;
            if (!Utils.isValidIndex(row_1, col, this.size)) {
                return null;
            }
            return this.tiles[row_1][col];
        } else {
            if (!Utils.isValidIndex(row, arg1, this.size)) {
                return null;
            }
            return this.tiles[row][arg1];
        }
    };
    Grid.prototype.hasTile = function (row, col) {
        if (row < 0 || row >= this.size || col < 0 || col >= this.size) {
            return false;
        }
        return Boolean(this.tiles[row][col]);
    };
    Grid.prototype.loopAreaAround = function (row, col, dist, fn) {
        for (var r = row - dist; r <= row + dist; r++) {
            for (var c = col - dist; c <= col + dist; c++) {
                if (Utils.isValidIndex(r, c, this.tiles.length)) {
                    fn(this.tiles[r][c], r, c);
                }
            }
        }
    };
    // count of completed zones
    Grid.prototype.getZoneCountNear = function (row, col, dist) {
        if (dist === void 0) {
            dist = 1;
        }
        var totalCount = 0;
        this.loopAreaAround(row, col, dist, function (v) {
            if (v && v._completed) {
                totalCount += 1;
            }
        });
        return totalCount;
    };
    Grid.prototype.getTileCountAnyTypeWithCache = function () {
        if (this._cachedTileCount !== null) {
            return this._cachedTileCount;
        } else {
            var count = this.getTileCount();
            this._cachedTileCount = count;
            return count;
        }
    };
    /** Return number of non-null tiles */
    Grid.prototype.getTileCount = function (type, mustBeCompleted) {
        if (mustBeCompleted === void 0) {
            mustBeCompleted = false;
        }
        var count = 0;
        this.forEachTile(function (t) {
            if (!type && type !== 0 || t.type === type) {
                if (mustBeCompleted && t._completed || !mustBeCompleted) {
                    count += 1;
                }
            }
        });
        return count;
    };
    Grid.prototype.getUpgradedTileCount = function () {
        var count = 0;
        var _tracked = this.city.grids.zoneGrid.getTrackedTilesOrError();
        var t;
        var _keys = Object.keys(_tracked);
        for (var _k = 0; _k < _keys.length; _k++) {
            t = _tracked[_keys[_k]];
            if (t._completed && t.isUpgraded && t.isUpgraded()) {
                count += 1;
            }
        }
        return count;
    };
    /**
     * Set the reference to a tile in the grid and add to sprite group
     * withSort = true takes log(n) time to insert into correct z index, but alleviates later sorting
     */
    Grid.prototype.setTile = function (row, col, tile, withSort) {
        if (withSort === void 0) {
            withSort = false;
        }
        if (!tile) {
            throw new MissingArgsError();
        }
        if (row < 0 || row >= this.tiles.length || col < 0 || col >= this.tiles.length) {
            return;
        }
        this.destroyTileIfExists(col, row, true);
        this.tiles[row][col] = tile;
        tile.cacheIndex(col, row);
        tile.resize(this.tileSize(), col, row);
        if (withSort) {
            if (this.sortOverrideFn) {
                this.sortOverrideFn(this, tile);
            } else {
                Utils.addChildIntoCorrectDepthSimple(this, tile);
            }
        } else {
            this.add(tile);
        }
        if (this._trackedTiles) {
            this._trackedTiles[Utils.toIndexKey(row, col, this.city.size)] = tile;
        }
        this.tileCount[tile.type] += 1;
        this._cachedTileCount = null;
        this._trackedTilesCount = -1;
    };
    Grid.prototype.getRandomTileIndex = function () {
        if (!this._trackedTiles) {
            throw new Error("random tile index can only be used if trackedTiles is enabled");
        }
        var t = Utils.randomChoice(Object.keys(this._trackedTiles));
        return Utils.toRowCol(t, this.city.size);
    };
    Grid.prototype.getRandomTileSlow = function () {
        var allTiles = [];
        var _tracked = this.city.grids.zoneGrid.getTrackedTilesOrError();
        var t;
        var _keys = Object.keys(_tracked);
        for (var _k = 0; _k < _keys.length; _k++) {
            t = _tracked[_keys[_k]];
            if (t) allTiles.push(t);
        }
        return Utils.randomChoice(allTiles);
    };
    Grid.prototype.setTileIfNotExists = function (row, col, tile) {
        if (this.tiles[row][col]) {
            return false;
        } else {
            this.setTile(row, col, tile);
        }
        return true;
    };
    Grid.prototype.countTiles = function () {
        if (!this._trackedTiles) {
            throw new Error("Can't count tiles on untracked, too slow!");
        } else {
            if (this._trackedTilesCount === -1) {
                this._trackedTilesCount = Utils.countKeys(this._trackedTiles);
            }
            return this._trackedTilesCount;
        }
    };
    /** Remove tile from grid and cached track tiles hash */
    Grid.prototype.unsetTile = function (row, col) {
        this.tiles[row][col] = null;
        if (this._trackedTiles) {
            delete this._trackedTiles[Utils.toIndexKey(row, col, this.city.size)];
        }
        this._cachedTileCount = null;
        this._trackedTilesCount = -1;
    };
    Grid.prototype.getTrackedTilesOrError = function () {
        if (!this._trackedTiles) {
            throw new Error("requires _trackedTiles");
        }
        return this._trackedTiles;
    };
    /** Apply function to each non-null tile */
    /*
    Copy and paste performant alternative:
     let _tracked = this.city.grids.zoneGrid.getTrackedTilesOrError();
    let t;
    let _keys = Object.keys(_tracked);
    for (let _k = 0; _k < _keys.length; _k++){
        t = _tracked[_keys[_k]];
        if (!t) continue;
    }
     */
    Grid.prototype.forEachTile = function (fn) {
        var s = this.city.size;
        if (this._trackedTiles) {
            var rowCol = void 0;
            var t = void 0;
            for (var k in this._trackedTiles) {
                if (this._trackedTiles.hasOwnProperty(k)) {
                    t = this._trackedTiles[k];
                    if (!t) continue;
                    rowCol = Utils.toRowColReuse(k, s);
                    fn(t, rowCol[0], rowCol[1]);
                }
            }
        } else {
            return Utils.foreach2D(this.tiles, function (t, r, c) {
                if (t) {
                    fn(t, r, c);
                }
            });
        }
    };
    Grid.prototype.getRandomTileLoop = function () {
        if (!this._trackedTiles) {
            throw new Error("must be _trackedTiles");
        }
        var _tracked = this.getTrackedTilesOrError();
        var _keys = Object.keys(_tracked);
        var start = Utils.randomInRange(0, _keys.length - 1);
        var end = _keys.length + start;
        return [_tracked, _keys, start, end];
    };
    Grid.prototype.forEachTileRandom = function (fn) {
        if (!this._trackedTiles) {
            throw new Error("must be _trackedTiles");
        }
        var _tracked = this.getTrackedTilesOrError();
        var t;
        var _keys = Object.keys(_tracked);
        var start = Utils.randomInRange(0, _keys.length - 1);
        var tmp;
        var end = _keys.length + start;
        for (var _k = start; _k < end; _k++) {
            tmp = _k;
            if (tmp >= _keys.length) {
                tmp = _k - _keys.length;
            }
            t = _tracked[_keys[tmp]];
            if (t) {
                fn(t, t.row, t.col);
            }
        }
    };
    Grid.prototype.generateIndexTuples = function () {
        var ret = [];
        var _tracked = this.city.grids.zoneGrid.getTrackedTilesOrError();
        var t;
        var _keys = Object.keys(_tracked);
        for (var _k = 0; _k < _keys.length; _k++) {
            t = _tracked[_keys[_k]];
            if (!t) continue;
            ret.push([t.row, t.col]);
        }
        return ret;
    };
    Grid.prototype.loopTilesReverse = function (fn) {
        for (var i = this.tiles.length - 1; i >= 0; i--) {
            for (var j = this.tiles.length - 1; j >= 0; j--) {
                fn(this.tiles[i][j], i, j);
            }
        }
    };
    Grid.prototype.getTilesArray = function () {
        var arr = [];
        this.forEachTile(function (t) {
            arr.push(t);
        });
        return arr;
    };
    /**
     * Destroy and set to null
     * @param col
     * @param row
     * @param [includeMaster] - always true if need to cascade destructon to children/master
     */
    Grid.prototype.destroyTileIfExists = function (col, row, includeMaster) {
        if (includeMaster === void 0) {
            includeMaster = false;
        }
        var tiles = this.tiles;
        if (row < 0 || row >= tiles.length || col < 0 || col >= tiles.length) {
            return false;
        }
        if (tiles[row][col]) {
            var tile = tiles[row][col];
            this.tileCount[tile.type] -= 1;
            var master = void 0,
                children = void 0;
            if (includeMaster && tiles[row][col]._master) {
                master = tiles[row][col]._master;
                children = master._children;
                for (var i = 0, _max = children.length; i < _max; i++) {
                    if (children[i]) {
                        this.destroyAndUnsetIfAlive(children[i], children[i].row, children[i].col);
                    }
                }
                this.destroyAndUnsetIfAlive(master, master.row, master.col);
            } else if (includeMaster && tiles[row][col]._children) {
                master = tiles[row][col];
                children = master._children;
                for (var i = 0, _max = children.length; i < _max; i++) {
                    if (children[i]) {
                        this.destroyAndUnsetIfAlive(children[i], children[i].row, children[i].col);
                    }
                }
                this.destroyAndUnsetIfAlive(master, master.row, master.col);
            } else {
                this.destroyAndUnsetIfAlive(tiles[row][col], row, col);
            }
            return true;
        }
        return false;
    };
    Grid.prototype.destroyAndUnsetIfAlive = function (sprite, row, col) {
        if (sprite && sprite.alive) {
            if (sprite instanceof ResidentialTile) {
                this.city.residentialTilePool.free(sprite);
            } else if (sprite instanceof CommercialTile) {
                this.city.commercialTilePool.free(sprite);
            } else if (sprite instanceof IndustrialTile) {
                this.city.industrialTilePool.free(sprite);
            } else {
                sprite.destroy();
            }
        }
        this.unsetTile(row, col);
    };
    /**
     * Set the tiles over an area
     * @param startIndex
     * @param endIndex
     * @param tileType
     */
    Grid.prototype.setTilesSame = function (startIndex, endIndex, tileType) {
        for (var row = startIndex.row; row <= endIndex.row; row++) {
            for (var col = startIndex.col; col <= endIndex.col; col++) {
                var position = Utils.indexToPosition(col, row, this.tileSize());
                var tile = this.city.createTilePreferPool(tileType, position.x, position.y);
                this.setTile(row, col, tile);
            }
        }
    };
    Grid.prototype.withinBounds = function (col, row) {
        return col >= 0 && col < this.size && row >= 0 && row < this.size;
    };
    /** Destroys all sprites in the this.tileSprites array */
    Grid.prototype.clearTiles = function (freeToPool) {
        if (freeToPool === void 0) {
            freeToPool = null;
        }
        var tiles = this.tiles;
        for (var i = 0; i < tiles.length; i++) {
            for (var j = 0; j < tiles.length; j++) {
                var sprite = tiles[i][j];
                if (sprite) {
                    if (freeToPool) {
                        freeToPool.free(sprite);
                    } else {
                        Utils.destroyIfAlive(sprite);
                    }
                }
            }
        }
        // clear cached data
        if (this._trackedTiles) {
            for (var k in this._trackedTiles) {
                if (this._trackedTiles.hasOwnProperty(k)) {
                    delete this._trackedTiles[k];
                }
            }
        }
        this._cachedTileCount = null;
        this._trackedTilesCount = -1;
        // Reset tiles to a new sparse matrix
        var size = this.size;
        for (var i = 0; i < tiles.length; i++) {
            // @ts-ignore
            tiles[i].length = 0;
            tiles[i][size - 1] = null;
        }
    };
    Grid.prototype.clearTile = function (tile) {
        var _this = this;
        this._untrackInd(tile.row, tile.col);
        tile._children.forEach(function (c) {
            _this._untrackInd(c.row, c.col);
            Utils.destroyIfAlive(c);
        });
        Utils.destroyIfAlive(tile);
    };
    Grid.prototype._untrackInd = function (row, col) {
        var k = Utils.toIndexKey(row, col, this.city.size);
        if (this._trackedTiles) {
            if (this._trackedTiles.hasOwnProperty(k)) {
                delete this._trackedTiles[k];
                this._cachedTileCount -= 1;
                this._trackedTilesCount = -1;
            }
        }
        this.tiles[row][col] = null;
    };
    /**
     * Creates a 2D array of TileSprites
     * @param size {int} - Dimension of 2D array
     * @param tileType {Tile.Type} - Tile type constant
     * @returns {Array}
     */
    Grid.prototype.createTileSprites = function (size, tileType) {
        var tiles = [];
        for (var row = 0; row < size; row++) {
            tiles[row] = [];
            for (var col = 0; col < size; col++) {
                if (Utils.isDefined(tileType)) {
                    var position = Utils.indexToPosition(col, row, this.tileSize());
                    this.setTile(row, col, Tile.createTileSprite(this.city, tileType, position.x, position.y));
                } else {
                    this.unsetTile(row, col);
                }
            }
        }
        return tiles;
    };
    Grid.prototype.mapTiles = function (fn) {
        return Utils.map2D(this.tiles, function (t, row, col) {
            if (t) fn(t, row, col);
        });
    };
    Grid.prototype.destroy = function () {
        Utils.destroyIfAlive(this.inputSprite);
        _super.prototype.destroy.call(this);
        this.city = null;
    };
    ///////////////////////
    // Static methods
    ///////////////////////
    Grid.currentTouchedIndex = function (city, tileSize, offsetYTilesize) {
        if (tileSize === void 0) {
            tileSize = Tile.TILE_WIDTH;
        }
        if (offsetYTilesize === void 0) {
            offsetYTilesize = 0;
        }
        if (!city.game.input.activePointer) {
            return null;
        }
        var pointer = Utils.toPosition(city.game.input.activePointer.worldX * (1 / city.scale.x), city.game.input.activePointer.worldY * (1 / city.scale.y) - offsetYTilesize * tileSize);
        return Utils.isoToIndex(pointer.x, pointer.y, tileSize);
    };
    /**
     * Creates a 2D array of null values (null TileSprites)
     * @param size {int} - Dimension of 2D Array
     * @param [initialValue]
     * @returns {Array}
     */
    Grid.createEmptyTileSprites = function (size, initialValue) {
        if (initialValue === void 0) {
            initialValue = undefined;
        }
        return Utils.initialize2DArray(size, size, initialValue);
    };
    /**
     * Flattens multiple grids into a single 2D matrix of booleans - true indicating that the
     * type exists in one of the grids
     * @param grids {Grid[]}
     * @param type {Tile.Type}
     * @returns {Boolean[][]}
     */
    Grid.flattenToTileExistsTiles = function (grids, type) {
        if (!grids || grids.length == 0) {
            throw Error("No grids to flatten!");
        }
        var boolGrid = Grid.createEmptyTileSprites(grids[0].size);
        for (var i = 0; i < grids.length; i++) {
            var grid = grids[i];
            var s = grid.tiles.length;
            for (var i_1 = 0; i_1 < s; i_1++) {
                for (var j = 0; j < s; j++) {
                    var tile = grid.tiles[i_1][j];
                    boolGrid[i_1][j] = boolGrid[i_1][j] || Boolean(tile && tile.type == type);
                }
            }
        }
        return boolGrid;
    };
    /**
     * Recalculate all tiles in changedTiles and touched tiles
     *
     * Static so that this can even be used on non-grid groups (elevated trains?)
     *
     * @param changedTiles - Boolean 2d array
     * @param tiles - see below
     * @param sourceGrids - see below
     * @param tileType - see below
     */
    Grid.recalculateChangedTiles = function (changedTiles, tiles, sourceGrids, tileType) {
        if (!changedTiles) throw Error("missing argument");
        Grid.recalculateBoundingTextures(tiles, sourceGrids, tileType, Utils.getTouchingTiles(changedTiles));
    };
    Grid.recalculateAllBoundingTextures = function (grid, tileType, allowNesting) {
        if (allowNesting === void 0) {
            allowNesting = false;
        }
        Grid.recalculateBoundingTextures(grid.tiles, [grid], tileType, null, allowNesting);
    };
    /**
     * Recalculate TileWithBoundingTextures Tiles
     * @param tiles - tiles to call recalculateTexture on. must have TileWithBoundedTexture Mixin
     * @param [sourceGrids] - single grid or multiple grids - Grid instsances, boolean/truthy vales - to determine current state of tile relations
     * @param [tileType] - Tile.Type.Road for example
     * @param [onlyUpdateBool] - which to update bool grid
     * @param [allowNesting] - allowing nesting connections
     * */
    Grid.recalculateBoundingTextures = function (tiles, sourceGrids, tileType, onlyUpdateBool, allowNesting) {
        if (onlyUpdateBool === void 0) {
            onlyUpdateBool = null;
        }
        if (allowNesting === void 0) {
            allowNesting = false;
        }
        if (window['isHeadless']) {
            return;
        }
        if (!tiles || !sourceGrids || !tileType) throw new MissingArgsError();
        if (sourceGrids.length > 10 || !sourceGrids[0].tiles) throw new Error("Probably not passing array of grids");
        var boolGrid = Grid.flattenToTileExistsTiles(sourceGrids, tileType);
        // git checkout b2c08b83a794c2a9b0b117c8ae916424e90fa832 src/www/img-atlas/tiles/highway-open-top-left.png
        // Update road tiles in both all grids with roads
        for (var i = 0; i < sourceGrids.length; i++) {
            var grid = sourceGrids[i];
            var needsCaching = grid.cacheAsBitmap;
            if (needsCaching) {
                grid.cacheAsBitmap = false;
            }
            var tiles_1 = grid.tiles;
            var s = tiles_1.length;
            var _arr = onlyUpdateBool || tiles_1;
            for (var _i = 0; _i < s; _i++) {
                for (var _j = 0; _j < s; _j++) {
                    var shouldUpdate = _arr[_i][_j];
                    var tile = tiles_1[_i][_j];
                    if (shouldUpdate && tile && tile.type === tileType) {
                        tile.recalculateTexture(boolGrid, allowNesting);
                    }
                }
            }
            if (needsCaching) {
                grid.cacheAsBitmap = true;
            }
        }
    };
    Grid.randomPathE2E = function (city, acrossMap, varianceFromCentre, mustGoThrough, indexOverride) {
        if (acrossMap === void 0) {
            acrossMap = false;
        }
        if (varianceFromCentre === void 0) {
            varianceFromCentre = 1;
        }
        var rng = city.rng;
        // Generate random weights and use astar to find water path
        var weightGrid = Utils.initialize2DArray(city.size, city.size, 0);
        Utils.foreach2D(weightGrid, function (val, row, col) {
            weightGrid[row][col] = rng.nextRange(1, 6);
        });
        // let river path:
        var randomIndex = function randomIndex() {
            var rowVar = rng.nextRange(0, Math.round(varianceFromCentre * 0.5 * city.size));
            var colVar = rng.nextRange(0, Math.round(varianceFromCentre * 0.5 * city.size));
            if (rng.nextRange(0, 10) < 5) {
                rowVar *= -1;
            }
            if (rng.nextRange(0, 10) < 5) {
                colVar *= -1;
            }
            var centreNum = Math.round(city.size * 0.5);
            var s = {
                row: centreNum + rowVar,
                col: centreNum + colVar
            };
            s.row = Utils.clamp(s.row, 0, city.size - 1);
            s.col = Utils.clamp(s.col, 0, city.size - 1);
            return s;
        };
        // randomize start/end
        var startIndex = randomIndex();
        var endIndex = randomIndex();
        if (acrossMap || rng.nextRange(0, 10) < 5) {
            // across
            startIndex.row = 0;
            endIndex.row = city.size - 1;
        } else {
            // diagonal
            startIndex.row = 0;
            endIndex.col = city.size - 1;
        }
        // Check if we should flip
        if (rng.nextRange(0, 10) < 5) {
            var _a = [startIndex.row, startIndex.col],
                r = _a[0],
                c = _a[1];
            startIndex.row = c;
            startIndex.col = r;
            _b = [endIndex.row, endIndex.col], r = _b[0], c = _b[1];
            endIndex.row = c;
            endIndex.col = r;
        }
        if (indexOverride) {
            startIndex = indexOverride[0];
            endIndex = indexOverride[1];
        }
        if (mustGoThrough) {
            var path1 = Utils.findPath(startIndex, mustGoThrough, weightGrid, true);
            var path2 = Utils.findPath(mustGoThrough, endIndex, weightGrid);
            return path1.concat(path2);
        } else {
            return Utils.findPath(startIndex, endIndex, weightGrid, true);
        }
        var _b;
    };
    Grid.randomBoolRegionReuse = function (city, startIndex, regionSize, rng) {
        return Grid.randomBoolRegion(city, startIndex, regionSize, rng, Utils.getReusableBoolGrid());
    };
    /** recursively create random region blob */
    Grid.randomBoolRegion = function (city, startIndex, regionSize, rng, boolGrid, boolGridTraversed) {
        var MIN_SIZE_BEFORE_PRUNING = 10;
        var adjacentPoint = {};
        var remainingAmt = regionSize;
        rng = rng || new Utils.RNG();
        boolGrid = boolGrid || Utils.initialize2DArray(city.size, city.size, 0);
        var numAdded = 0;
        addIndex(startIndex.row, startIndex.col);
        while (Object.keys(adjacentPoint).length && remainingAmt) {
            remainingAmt -= 1;
            var k = Utils.randomChoice(Object.keys(adjacentPoint), rng);
            var _a = Utils.toRowCol(adjacentPoint[k], city.size),
                r = _a[0],
                c = _a[1];
            addIndex(r, c);
        }
        // clean up any singles
        Object.keys(adjacentPoint).forEach(function (k) {
            var _a = Utils.toRowCol(adjacentPoint[k], city.size),
                r = _a[0],
                c = _a[1];
            var touchingSides = 0;
            Utils.mapTouchingTiles(r, c, city.size, function (row, col) {
                if (boolGrid[row][col]) {
                    touchingSides += 1;
                }
            });
            if (touchingSides === 4) {
                boolGrid[r][c] = 1;
            }
        });
        function addIndex(r, c) {
            // Don't add if there is only one neighbor, who only has 1 edge neighbour
            delete adjacentPoint[r + "x" + c];
            if (numAdded > MIN_SIZE_BEFORE_PRUNING && numNeighbours(r, c) === 1) {
                var n = getFirstNeighbour(r, c);
                if (numNeighbours(n.row, n.col) === 1) {
                    return;
                }
            }
            numAdded += 1;
            boolGrid[r][c] = 1;
            Utils.mapTouchingTiles(r, c, city.size, function (row, col) {
                if (!boolGrid[row][col]) {
                    adjacentPoint[row + "x" + col] = Utils.toIndexKey(row, col, city.size);
                }
            });
        }
        function numNeighbours(r, c) {
            var count = 0;
            Utils.mapTouchingTiles(r, c, city.size, function (nRow, nCol) {
                if (boolGrid[nRow][nCol]) {
                    count += 1;
                }
            });
            return count;
        }
        function getFirstNeighbour(r, c) {
            var n = null;
            Utils.mapTouchingTiles(r, c, city.size, function (nRow, nCol) {
                if (boolGrid[nRow][nCol]) {
                    n = { col: nCol, row: nRow };
                }
            });
            return n;
        }
        return boolGrid;
    };
    return Grid;
}(TrackCulledChildrenLayer);
Utils.extend(Grid.prototype, WithState);
Utils.extend(Grid.prototype, WithGroupDepthSortMixin);
Grid.prototype.TINT_COLOR = 0xffffff;
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * A group that only calls update on its children if the camera has movied
 * @param city
 * @constructor
 */
var SmartUpdateLayer = /** @class */function (_super) {
    __extends(SmartUpdateLayer, _super);
    function SmartUpdateLayer(city) {
        var _this = _super.call(this, city) || this;
        _this._forceUpdate = false;
        _this.city = city;
        return _this;
    }
    SmartUpdateLayer.prototype.startForceRunUpdate = function () {
        this._forceUpdate = true;
    };
    SmartUpdateLayer.prototype.endForceRunUpdate = function () {
        this._forceUpdate = false;
    };
    SmartUpdateLayer.prototype.update = function (forceUpdate) {
        if (forceUpdate === void 0) {
            forceUpdate = false;
        }
        if (this._forceUpdate || this.city._smartUpdate || forceUpdate || this.cacheAsBitmap) {
            Phaser.Group.prototype.update.call(this);
        }
    };
    SmartUpdateLayer.prototype.updateTransform = function (forceTransform) {
        if (this._forceUpdate || this.city._shouldTransform || forceTransform || this.cacheAsBitmap) {
            Phaser.Group.prototype.updateTransform.call(this);
        }
    };
    // deactivated
    SmartUpdateLayer.prototype.preUpdate = function () {};
    SmartUpdateLayer.prototype.postUpdate = function () {
        this.ensureZIndexUpdated();
    };
    return SmartUpdateLayer;
}(Phaser.Group);
/**
 * Hacky copy for multiple inheritence
 * @param city
 * @constructor
 */
var SmartUpdateLayerWithTrackCull = /** @class */function (_super) {
    __extends(SmartUpdateLayerWithTrackCull, _super);
    function SmartUpdateLayerWithTrackCull(city, disableCull) {
        var _this = _super.call(this, city, disableCull) || this;
        _this._forceUpdate = false;
        _this.city = city;
        _this.visible = false;
        return _this;
    }
    SmartUpdateLayerWithTrackCull.prototype.update = function (forceUpdate) {
        if (this._forceUpdate || this.city._smartUpdate || forceUpdate || this.cacheAsBitmap) {
            _super.prototype.update.call(this);
        }
    };
    SmartUpdateLayerWithTrackCull.prototype.updateTransform = function (forceTransform) {
        if (this._forceUpdate || this.city._shouldTransform || forceTransform || this.cacheAsBitmap) {
            _super.prototype.updateTransform.call(this, this);
        }
    };
    // deactivated
    SmartUpdateLayerWithTrackCull.prototype.preUpdate = function () {};
    SmartUpdateLayerWithTrackCull.prototype.postUpdate = function () {
        this.ensureZIndexUpdated();
    };
    return SmartUpdateLayerWithTrackCull;
}(TrackCulledChildrenLayer);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Grid input base class
 * @param buildGrid {BuildGrid}
 * @param tileType {Tile.Type}
 * @constructor
 */
var GridInput = /** @class */function (_super) {
    __extends(GridInput, _super);
    function GridInput(buildGrid, tileType) {
        var _this = _super.call(this) || this;
        _this.startIndex = null;
        _this.lastIndex = null;
        _this._indexArr = [];
        // Track out of bounds touch separately, because they have different actions
        _this.OOBStartIndex = null;
        _this._cameraDrag = false;
        _this.buildGrid = buildGrid;
        _this.city = buildGrid.city;
        _this.game = buildGrid.game;
        _this.tileType = tileType;
        _this.city.buildHelper._isValidBuild = true;
        _this.setUIConfirmationHandlers();
        return _this;
    }
    GridInput.prototype.unregisterHandler = function () {
        this.city.refreshSignal.remove(this.handleResizeTiles);
    };
    GridInput.prototype.getBuildState = function () {
        return this.city.state.gridState;
    };
    GridInput.prototype.processInput = function () {
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        var isDown = this.isDown();
        if (isDown) {
            var isNewTouch = !this.startIndex;
            var index = Grid.currentTouchedIndex(this.city, this.buildGrid.city.getTileSize());
            if (index) {
                // Build tiles if within bounds
                var withinBounds = this.buildGrid.withinBounds(index.col, index.row);
                if (withinBounds) {
                    if (isNewTouch) {
                        this.startIndex = index;
                        this.onTouchDown();
                    }
                    if (isNewTouch || !Utils.deepCompare(this.lastIndex, index)) {
                        this.lastIndex = Utils.copy(index);
                        this.onDragTile();
                    }
                } else {
                    this.onOutOfBoundTouch();
                    var isNewOOBTouch = !this.OOBStartIndex;
                    if (isNewOOBTouch) {
                        this.OOBStartIndex = index;
                        this.onOutOfBoundTouch();
                    }
                }
            }
        } else {
            // Signal on touchup
            if (this.startIndex != null) {
                this.onTouchUp();
            }
            this.startIndex = null;
            this.lastIndex = null;
            this.OOBStartIndex = null;
        }
    };
    GridInput.prototype.postProcessInput = function () {
        // todo: show red here, demolish tile, etc
    };
    /**
     * Event handler for first touch down
     */
    GridInput.prototype.onTouchDown = function (index) {
        this.city.setBuildInteracting(Boolean(index));
    };
    GridInput.prototype.onOutOfBoundTouch = function () {};
    GridInput.prototype.setUIConfirmationHandlers = function () {
        var city = this.city;
        var self = this;
        city.setBuildConfirm(function () {
            self.onConfirm();
            self.city.commitBuildTiles();
            self.city.setCameraState();
        });
        city.setBuildCancel(function () {
            self.onCancel();
            self.buildGrid.clearTiles();
            self.city.setCameraState();
        });
    };
    /**
     * Event handler for when touch is up
     * Disables further input and shows confirmation modal
     */
    GridInput.prototype.onTouchUp = function () {
        var city = this.city;
        city.setBuildStoppedInteracting();
        city.allowConfirmBuild();
    };
    GridInput.prototype.getConfirmationIndex = function () {
        return this.lastIndex;
    };
    /**
     * Event handler for when touch position enters a new tile
     */
    GridInput.prototype.onDragTile = function () {};
    /**
     * Checks all build tiles, for each one invalid, create red tile and mark as invalid, also creates black tiles to mark for destruction
     */
    GridInput.prototype.updateAffectedTilesValidRange = function () {
        var buildGridTiles = this.city.grids.buildGrid.tiles;
        var tile;
        var city = this.city;
        var buildGridState = city.getBuildingState();
        city.buildHelper._isValidBuild = true;
        city.cityEffects.clearAffectedBuildTiles();
        this._indexArr.length = 0;
        for (var i = 0, maxI = buildGridTiles.length; i < maxI; i++) {
            for (var j = 0, maxJ = buildGridTiles.length; j < maxJ; j++) {
                tile = buildGridTiles[i][j];
                if (!tile) continue;
                this._indexArr.push([tile.row, tile.col]);
                //this.updateAffectedTileAtIndex(city, buildGridState, tile.row, tile.col);
            }
        }
        this.showInvalidOrDemolish(city, buildGridState, this._indexArr);
        city.refreshCacheBitmapsNextTick();
    };
    GridInput.prototype.updateAffectedTilesValidBuildInRange = function (startIndex, lastIndex) {
        if (!startIndex || !lastIndex) throw new MissingArgsError();
        var city = this.city;
        city.buildHelper._isValidBuild = true;
        city.cityEffects.clearAffectedBuildTiles();
        var buildGridState = city.getBuildGridState();
        this._indexArr.length = 0;
        for (var i = Math.min(startIndex.row, lastIndex.row), maxI = Math.max(startIndex.row, lastIndex.row); i <= maxI; i++) {
            for (var j = Math.min(startIndex.col, lastIndex.col), maxJ = Math.max(startIndex.col, lastIndex.col); j <= maxJ; j++) {
                this._indexArr.push([i, j]);
                //this.updateAffectedTileAtIndex(city, buildGridState, i, j);
            }
        }
        this.showInvalidOrDemolish(city, buildGridState, this._indexArr);
    };
    // apply invalid tile or bulldozer icon over current selected area
    // also updates _isValidBuild on city
    GridInput.prototype.showInvalidOrDemolish = function (city, buildingState, indexArr) {
        var keysToDemolish = {};
        for (var i = 0; i < indexArr.length; i++) {
            var _a = indexArr[i],
                row = _a[0],
                col = _a[1];
            var isBuildable = buildingState.isBuildable(row, col) && this.isBuildableOverrideCheck(city, row, col);
            // buildable overrides
            if (!isBuildable) {
                city.buildHelper._isValidBuild = false;
                city.buildHelper._invalidBuildReason = buildingState.invalidBuildReason(row, col);
                city.cityEffects.showBuildInvalidTile(row, col);
            } else if (buildingState.requiresDemolishNonTerrainOnBuild(row, col)) {
                keysToDemolish[Utils.toIndexKey(row, col, city.size)] = 1;
            }
        }
        // Remove keys involved in move start
        if (MainUI.Move.inspecingTile) {
            delete keysToDemolish[Utils.toIndexKey(MainUI.Move.inspecingTile.row, MainUI.Move.inspecingTile.col, city.size)];
            MainUI.Move.inspecingTile._children.forEach(function (c) {
                delete keysToDemolish[Utils.toIndexKey(c.row, c.col, city.size)];
            });
        }
        city.cityEffects.bulldozerGroupEntity.showSprites(keysToDemolish);
        city.applyGridVisibility();
    };
    GridInput.prototype.isBuildableOverrideCheck = function (city, row, col) {
        if (city.cityUI.chestsByIndex[row + "_" + col]) {
            // can't build on top of chest
            return false;
        }
        return true;
    };
    /**
     * On cancel, called before clearing working tiles
     */
    GridInput.prototype.onCancel = function () {};
    GridInput.prototype.onConfirm = function () {};
    /**
     * Returns whether or not touch is active
     */
    GridInput.prototype.isDown = function () {
        return this.buildGrid.inputSprite.isActive();
    };
    return GridInput;
}(InputHandler);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/** This is actually used as the upper structure layer */
var StructureLayer = /** @class */function (_super) {
    __extends(StructureLayer, _super);
    function StructureLayer(city) {
        var _this = _super.call(this, city) || this;
        _this.zoomHideCutoff = CityStructureScaler.ENABLE_SMALL_BUILDINGS_ZOOM;
        _this.resetClusterOnDepthSort = true;
        return _this;
    }
    StructureLayer.prototype.additionalHideZoomCondition = function () {
        return !this.city.performance.forceUpperMaskLayerStayVisible;
    };
    StructureLayer.prototype.update = function () {
        _super.prototype.update.call(this, this.city._forceStructureTransform);
        this.checkUpdateClusters();
    };
    StructureLayer.prototype.updateTransform = function () {
        // don't update transform if camera or zoom hasn't moved
        _super.prototype.updateTransform.call(this, this.city._forceStructureTransform);
    };
    StructureLayer.prototype.forceTransform = function () {
        _super.prototype.updateTransform.call(this, true);
    };
    return StructureLayer;
}(SmartUpdateLayerWithTrackCull);
Utils.extend(StructureLayer.prototype, WithGroupDepthSortMixin);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
* Input where the user creates a rectangular area for a tile
* @param buildGrid
* @param building {Class} Structure derived class
*/
var StructureInput = /** @class */function (_super) {
    __extends(StructureInput, _super);
    function StructureInput(buildGrid, building) {
        var _this = _super.call(this, buildGrid, Tile.Type.Structure) || this;
        _this.structureGroup = null;
        _this.startDrag = null;
        _this.baseIndex = null; // Index of master tile, max col and max row
        _this._awaitingCommit = false;
        _this._lastTouchedIndexCache = null;
        _this.handleResizeTiles = null;
        _this.disableBounce = false;
        _this.touchDownPos = { x: 0, y: 0 };
        _this.touchUpPos = { x: 0, y: 0 };
        _this.buildGrid = buildGrid;
        _this.game = buildGrid.game;
        _this.building = building;
        _this.spriteCols = building.sizeCol;
        _this.spriteRows = building.sizeRow;
        _this._awaitingCommit = false;
        _this._lastTouchedIndexCache = null;
        _this.handleResizeTiles = function (event) {
            switch (event) {
                case "resize_tiles":
                    _this.showCost();
                    break;
                // keep money up do date even when idle
                case "money_updated":
                    _this.showCost();
                    _this.city.buildHelper.checkBuildConfirmationUpdate();
                    break;
            }
        };
        _this.city.refreshSignal.add(_this.handleResizeTiles);
        return _this;
    }
    StructureInput.prototype._isIndexWithinBounds = function (row, col) {
        // Ensure index not out of bounds considering build size
        var minRow = 0;
        var minCol = 0;
        if (this.building) {
            minRow += this.building.sizeCol - 1;
            minCol += this.building.sizeCol - 1;
        }
        return row >= minRow && row <= this.city.size - 1 && col >= minCol && col <= this.city.size - 1;
    };
    StructureInput.prototype.onDragTile = function () {
        this._cameraDrag = false;
        if (!this.game.input.activePointer) {
            return;
        }
        // If touching sprite:
        var touchedIndex = Grid.currentTouchedIndex(this.city, this.city.getTileSize());
        // Start dragging
        if (!this.startDrag && this.isTouchingStructure()) {
            this.startDrag = touchedIndex;
        }
        // Move drag
        else if (this.startDrag) {
                // must be in world bounds for building size
                if (this._isIndexWithinBounds(touchedIndex.row, touchedIndex.col)) {
                    // Check if we've moved since last index
                    if (this.startDrag.col != touchedIndex.col || this.startDrag.row != touchedIndex.row) {
                        // Shift deltas
                        this.moveStructure(touchedIndex.col - this.startDrag.col, touchedIndex.row - this.startDrag.row);
                        this.startDrag.col = touchedIndex.col;
                        this.startDrag.row = touchedIndex.row;
                        // Need to refresh confirmation modal on up
                        this._awaitingCommit = false;
                        AudioPC.playBuildDrag(this.game);
                    }
                }
            }
            // Move camera
            else {
                    this.city.cameraInputHandler.processInput();
                    this._cameraDrag = true;
                }
        if (!this._awaitingCommit) {
            this.city.cityUI.highlightDrag.visible = false;
            this._lastTouchedIndexCache = touchedIndex;
            this.city.buildHelper.checkBuildConfirmationUpdate();
            this.showCost();
        }
    };
    StructureInput.prototype.showCost = function () {
        if (!this._lastTouchedIndexCache) {
            return;
        }
        if (!this.baseIndex) {
            return;
        }
        var cost = this.building.cost;
        if (MainUI.Move.isMoveMode) {
            cost = Math.round(cost * BuildCash.BUILD_MOVE_MULT);
        }
        if (this.city.isInfiniteMoney()) {
            cost = 0;
        }
        this.city.buildHelper.buildCash.showBuildCostFixed(this._lastTouchedIndexCache.row, this._lastTouchedIndexCache.col, cost, StructureInput.BUILD_Y_OFFSET);
    };
    StructureInput.prototype.onTouchUp = function () {
        this.touchUpPos.x = this.city.game.input.activePointer.x;
        this.touchUpPos.y = this.city.game.input.activePointer.y;
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers >= 1) {
            return;
        }
        this.city.cameraInputHandler.clearLast();
        // Handle repeat build mode (which allows dragging + tap)
        var MAX_MOVE_TOUCHUP_BUILD_REPEAT_CAM_MOVE = Tile.TILE_WIDTH * 0.2;
        var delta = Utils.posDistTotal(this.touchUpPos, this.touchDownPos);
        if (this.city.buildHelper.isBuildRepeatMode && !this.city.buildHelper.disableRepeatBuild && delta < MAX_MOVE_TOUCHUP_BUILD_REPEAT_CAM_MOVE) {
            this.initStructureAtStartIndexIfValid();
            this.updateAffectedTilesValidRange();
            this.city.buildHelper.isBuildRepeatMode = false;
        }
        if (this.baseIndex) {
            _super.prototype.onTouchUp.call(this);
            this._awaitingCommit = true;
            this.updateHighlightPos();
            this.city.cityUI.highlightDrag.visible = true;
            if (Global.EASE_CAMEAR_LAST_BUIILD_TILE) {
                this.city.easeCameraToTile(this.baseIndex);
            }
        }
        this.city.buildSignal.dispatch('touchUpStructureInput');
    };
    StructureInput.prototype.initStructureAtStartIndexIfValid = function () {
        if (!this.structureGroup && this._isIndexWithinBounds(this.startIndex.row, this.startIndex.col)) {
            this.initializeStructure(this.startIndex.col, this.startIndex.row);
            AudioPC.playBuildDrag(this.game);
        }
    };
    StructureInput.prototype._rebuildExactTile = function (index) {
        this.startIndex = index;
        this.onTouchDown();
    };
    StructureInput.prototype.onTouchDown = function () {
        _super.prototype.onTouchDown.call(this);
        this.touchDownPos.x = this.city.game.input.activePointer.x;
        this.touchDownPos.y = this.city.game.input.activePointer.y;
        this.city.cityEffects.clearCurrentBuildPendingEffect();
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        if (!this.city.buildHelper.isBuildRepeatMode) {
            this.buildBuildingAtStartIndex();
        }
    };
    StructureInput.prototype.buildBuildingAtStartIndex = function () {
        this.initStructureAtStartIndexIfValid();
        this.city.buildSignal.dispatch('touchDownStructureInput'); // just for tutorial usage
        this.updateAffectedTilesValidRange();
    };
    StructureInput.prototype.processInput = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        _super.prototype.processInput.call(this);
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        if (this.game.input.activePointer.isDown) {
            this.onDragTile();
        } else {
            this.startDrag = null;
            if (this._cameraDrag) {
                // fix camer jumpyness when out of bounds drag
                this._cameraDrag = false;
                this.city.cameraInputHandler.clearLast();
            }
        }
    };
    StructureInput.prototype.animateBounce = function (structure, moveBounce) {
        if (!structure) throw new MissingArgsError();
        // Animate it
        if (moveBounce) {
            // less extreme animation when moving existing structure
            structure.setAnimation("bounce").animateIn(null, 0.85, true);
        } else {
            structure.setAnimation("bounce").animateIn();
            structure.upperMaskSprite.alpha = 0;
        }
        this.city.tempSmartUpdate(500);
        setTimeout(function () {
            if (structure.upperMaskSprite) {
                structure.upperMaskSprite.alpha = 1;
            }
        }, 250);
    };
    /**
     * Initialize group of tiles and structure sprite
     * @returns {boolean} - whether or not we were able to create the sprite at the touch index
     */
    StructureInput.prototype.initializeStructure = function (touchCol, touchRow) {
        // Create area of structure tiles at touchCol, touchRow
        if (touchCol - this.spriteCols < -1 || touchRow - this.spriteRows < -1) {
            return false;
        }
        this.baseIndex = Utils.toIndex2D(touchCol, touchRow);
        this.rebuildTiles();
        // Create (transparent) sprite to cover area
        var structure = this.createUnlinkedStructureOnBaseTile(touchCol, touchRow);
        if (!this.disableBounce) {
            this.animateBounce(structure, false);
        } else {
            structure.alpha = 1;
            structure.upperMaskSprite.alpha = 1;
        }
        // Make tiles transparent initially as animation is happening
        structure.Tile._children.concat([structure.Tile]).map(_animateTileInAlpha);
        function _animateTileInAlpha(t) {
            t.alpha = 0;
            setTimeout(function () {
                t.alpha = 1;
            }, WithAnimationMixin.animationSpeed);
        }
        return true;
    };
    StructureInput.prototype.createUnlinkedStructureOnBaseTile = function (col, row) {
        if (this.structureGroup) {
            Utils.destroyIfAlive(this.structureGroup);
            this.structureGroup = null;
        }
        var self = this;
        var baseTile = this.buildGrid.tiles[row][col];
        // Create Structure Sprite
        this.structureGroup = baseTile.createStructureSprites(this.city.grids.structureGridBuild);
        // Unlink structure sprite
        baseTile.structureGroup = null;
        self.updateHighlightPos();
        // Set to complete sprite frame
        this.structureGroup.setTextureOverride(this.building["atlas-texture"], Utils.atlasFrame(this.building["atlas-folder"], this.building.sheet));
        this.structureGroup.alpha = Global.STRUCTURE_DURING_BUILD_ALPHA;
        this.structureGroup.visible = true;
        this.moveStructureToBase();
        return this.structureGroup;
    };
    // Move the structure to the position for the base tile, and then unlink it
    // Purely visual for moving unlinked temporary structure
    StructureInput.prototype.moveStructureToBase = function (timeout) {
        if (timeout === void 0) {
            timeout = false;
        }
        var self = this;
        function moveAndResize() {
            // Temporarily attach structure group to tile so that it gets moved along when position is updated
            var baseTile = self.getBaseTile();
            baseTile.structureGroup = self.structureGroup;
            baseTile.building = self.building;
            baseTile.scaleAndPositionStructure(true);
            baseTile.structureGroup = null;
            baseTile.building = null;
            if (!Global.DISABLE_EXTRA_EFFECTS) {
                self.animateBounce(self.structureGroup, true);
            }
        }
        this.structureGroup.forceFinishAnimation();
        if (timeout) {
            setTimeout(moveAndResize, 0);
        } else {
            moveAndResize();
        }
    };
    StructureInput.prototype.updateHighlightPos = function () {
        this.city.cityUI.moveHighlightDrag(this.baseIndex.col, this.baseIndex.row);
    };
    /**
     * Move group of tiles and structure to index
     */
    StructureInput.prototype.moveStructure = function (deltaCol, deltaRow) {
        var targetCol = this.baseIndex.col + deltaCol;
        var targetRow = this.baseIndex.row + deltaRow;
        if (Utils.isBetween(0, this.buildGrid.tiles.length - 1, targetCol, true) && Utils.isBetween(0, this.buildGrid.tiles.length - 1, targetRow, true)) {
            this.baseIndex.col = targetCol;
            this.baseIndex.row = targetRow;
            this.rebuildTiles();
        }
    };
    StructureInput.prototype.getBaseTile = function () {
        return this.buildGrid.tiles[this.baseIndex.row][this.baseIndex.col];
    };
    /**
     * Rebuild tiles from baseIndex
     */
    StructureInput.prototype.rebuildTiles = function () {
        var col = this.baseIndex.col;
        var row = this.baseIndex.row;
        this.buildGrid.clearTiles();
        this.buildGrid.setTilesSame(Utils.toIndex2D(col - this.spriteCols + 1, row - this.spriteRows + 1), Utils.toIndex2D(col, row), Tile.Type.Structure);
        this.buildGrid.tiles[row][col].addChildNeighbours(this.spriteCols - 1, this.spriteRows - 1, this.buildGrid.tiles);
        this.buildGrid.tiles[row][col].building = this.building;
        if (this.structureGroup) {
            this.structureGroup.Tile = this.buildGrid.tiles[row][col];
            this.moveStructureToBase();
        }
        this.updateAffectedTilesValidRange();
    };
    StructureInput.prototype.updateAffectedTilesValidRange = function () {
        _super.prototype.updateAffectedTilesValidRange.call(this);
        if (this.structureGroup) {
            if (!this.city.buildHelper._isValidBuild) {
                this.city.grids.structureGridBuild.alpha = 0.3;
            } else {
                this.city.grids.structureGridBuild.alpha = 1;
            }
        }
    };
    /**
     * Returns whether or not current touched index is part of structure
     * @returns {boolean}
     */
    StructureInput.prototype.isTouchingStructure = function () {
        if (!this.baseIndex) {
            return false;
        }
        var isTouchingSelf = Utils.isTouchingCloseToIndexOnZoomout(this.city, this.baseIndex);
        if (isTouchingSelf) {
            return true;
        }
        var leftIndex = {
            row: this.baseIndex.row,
            col: this.baseIndex.col - 1
        };
        var rightIndex = {
            row: this.baseIndex.row - 1,
            col: this.baseIndex.col
        };
        var topIndex = {
            row: this.baseIndex.row - 1,
            col: this.baseIndex.col - 1
        };
        if (this.spriteCols >= 2 && Utils.isValidIndex(leftIndex.row, leftIndex.col, this.city.size) && Utils.isTouchingCloseToIndexOnZoomout(this.city, leftIndex)) {
            return true;
        }
        if (this.spriteRows >= 2 && Utils.isValidIndex(rightIndex.row, rightIndex.col, this.city.size) && Utils.isTouchingCloseToIndexOnZoomout(this.city, rightIndex)) {
            return true;
        }
        if (this.spriteCols >= 2 && this.spriteRows >= 2 && Utils.isValidIndex(topIndex.row, topIndex.col, this.city.size) && Utils.isTouchingCloseToIndexOnZoomout(this.city, topIndex)) {
            return true;
        }
        return false;
    };
    StructureInput.prototype.getConfirmationIndex = function () {
        return this.baseIndex;
    };
    StructureInput.prototype.onConfirm = function () {
        var city = this.city;
        if (!this.baseIndex) {
            return; // may happen from pressing enter without tapping down structure yet
        }
        city.cityUI.highlightDrag.visible = false;
        var baseTile = this.getBaseTile();
        if (!baseTile) return;
        baseTile.building = this.building;
        this.clearTempStructure();
    };
    StructureInput.prototype.onCancel = function () {
        this.city.cityUI.highlightDrag.visible = false;
        this.clearTempStructure();
    };
    StructureInput.prototype.clearTempStructure = function () {
        Utils.destroyIfAlive(this.structureGroup);
    };
    StructureInput.BUILD_Y_OFFSET = 1.5 * Global.TILE_WIDTH;
    return StructureInput;
}(GridInput);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Input where the user creates a rectangular area for a tile
 * @param buildGrid
 * @param tileType
 */
var RectangleInput = /** @class */function (_super) {
    __extends(RectangleInput, _super);
    function RectangleInput(buildGrid, tileType, textureBuildOverride, textureBuildFrameOverride) {
        var _this = _super.call(this, buildGrid, tileType) || this;
        _this.lastArea = 0;
        _this._startIndexCache = null;
        _this._lastIndexCache = null;
        _this._awaitingCommit = false;
        _this._mask = null;
        _this.tween = null;
        _this.tweenLast = null;
        _this.rectangleSprite = null;
        _this.lastRectangleSprite = null;
        var CLASS = Tile.getTileClass(tileType);
        var textureBuild = textureBuildOverride || CLASS.TEXTURE_BUILD;
        var textureBuildFrame = textureBuildFrameOverride || CLASS.TEXTURE_BUILD_FRAME;
        if (!textureBuild) {
            throw new Error("No static TEXTURE_BUILD field defined in tile type");
        }
        if (buildGrid == undefined || tileType == undefined) throw new MissingArgsError();
        _this.buildGrid = buildGrid;
        _this.buildGrid.children.forEach(function (c) {
            return Utils.destroyIfAlive(c);
        });
        _this.game = buildGrid.game;
        _this.tileType = tileType;
        _this.startIndex = null;
        _this.lastIndex = null;
        _this.textureBuild = textureBuild;
        _this.textureBuildFrame = textureBuildFrame;
        // Create rectangle tile sprite that uses that texture and add to build grid
        _this.initializeRectangleSprites();
        _this.buildGrid.alpha = RectangleInput.ALPHA;
        var self = _this;
        _this.handleResizeTiles = function (event) {
            switch (event) {
                case "new_scale_city":
                    self.resizeRectangleAndMask(false);
                    self.showCost();
                    break;
                // keep money up do date even when idle
                case "money_updated":
                    self.showCost();
                    self.city.buildHelper.checkBuildConfirmationUpdate();
                    break;
            }
        };
        _this.city.refreshSignal.add(_this.handleResizeTiles);
        return _this;
    }
    RectangleInput.prototype.preCommitOptimizeBefore = function (allCommitLength) {
        this.city.grids.terrainGrid.ignoreDestroyAutoSave = true;
        this.city.performance.enableTerrainAnim = allCommitLength < RectangleTerrainInput.FX_COUNT_CUTOFF;
    };
    RectangleInput.prototype.preCommitOptimizeAfter = function () {
        this.city.performance.enableTerrainAnim = true;
        this.city.grids.terrainGrid.ignoreDestroyAutoSave = false;
        this.city.grids.terrainGrid._updateCustomGlobalSettings();
    };
    // for testing
    RectangleInput.prototype._rebuildExactTiles = function (startIndex, endIndex) {
        this.startIndex = startIndex;
        this._startIndexCache = startIndex;
        this.lastIndex = endIndex;
        this._lastIndexCache = endIndex;
        this.onDragTile();
        this.onTouchUp();
    };
    RectangleInput.prototype.onDragTile = function () {
        // for tutorial:
        if (this.isInvalidForTutorial()) return;
        // Update single rectangle sprite
        if (!this._awaitingCommit) {
            this._startIndexCache = this._startIndexCache || this.startIndex;
            this._lastIndexCache = this.lastIndex;
            this.refreshRectangleAndMask();
            // Update build text
            this.showCost();
            this.city.buildHelper.checkBuildConfirmationUpdate();
            AudioPC.playBuildDrag(this.game);
        }
    };
    RectangleInput.prototype.isInvalidForTutorial = function () {
        return this.city.gameplayUI._restrictAreaType && this.city.gameplayUI._restrictAreaType !== this.tileType;
    };
    RectangleInput.prototype.showCost = function () {
        // Update build text
        if (this._lastIndexCache) {
            this.city.buildHelper.buildCash.showBuildCost(this._lastIndexCache.row, this._lastIndexCache.col, this._startIndexCache, this._lastIndexCache, this.tileType);
        }
    };
    /** Create actual tile elements on build grid now right before committing it*/
    RectangleInput.prototype.createPreCommitTiles = function () {
        var self = this;
        this.buildGrid.clearTiles();
        var tile;
        var allCommit = this.getCommittableTileIndexes();
        for (var _i = 0; _i < allCommit.length; _i++) {
            var i = allCommit[_i];
            tile = self.city.createTilePreferPool(self.tileType);
            tile.visible = true;
            tile.alpha = 0.75;
            self.buildGrid.setTile(i[0], i[1], tile);
        }
    };
    // Returns list of tuples of all indexes that should be committed to
    RectangleInput.prototype.getCommittableTileIndexes = function () {
        var startIndex = this._startIndexCache;
        var lastIndex = this._lastIndexCache;
        if (!startIndex || !lastIndex) {
            return [];
        }
        var buildGridState = this.getBuildState();
        if (!buildGridState) {
            return [];
        }
        var indexes = [];
        for (var row = Math.min(startIndex.row, lastIndex.row); row <= Math.max(startIndex.row, lastIndex.row); row++) {
            for (var col = Math.min(startIndex.col, lastIndex.col); col <= Math.max(startIndex.col, lastIndex.col); col++) {
                if (Utils.isValidIndex(row, col, this.city.size) && !buildGridState.shouldSkipCommitAt(row, col)) {
                    indexes.push([row, col]);
                }
            }
        }
        return indexes;
    };
    RectangleInput.prototype.initializeRectangleSprites = function () {
        Utils.destroyIfAlive(this.rectangleSprite);
        Utils.destroyIfAlive(this.lastRectangleSprite);
        this.rectangleSprite = this.createRectangleSprite(this.textureBuild, this.textureBuildFrame);
        this.lastRectangleSprite = this.createRectangleSprite(this.textureBuild, this.textureBuildFrame);
        this.buildGrid.add(this.rectangleSprite);
        this.buildGrid.add(this.lastRectangleSprite);
    };
    RectangleInput.prototype.createRectangleSprite = function (texture, frame) {
        var rectangle = this.game.add.sprite(0, 0, texture, frame);
        // Set global height;
        rectangle.width = this.buildGrid.city.buildGridBg.width;
        rectangle.height = this.buildGrid.city.buildGridBg.height;
        rectangle.x = this.buildGrid.city.buildGridBg.x;
        rectangle.y = this.buildGrid.city.buildGridBg.y;
        rectangle.visible = true;
        rectangle.alpha = 0;
        return rectangle;
    };
    RectangleInput.prototype.resizeRectangleAndMask = function (withAreaChange) {
        if (withAreaChange === void 0) {
            withAreaChange = true;
        }
        // possible optimization - re-use rectangle instead of creating a new one
        // unforunately i can't figure out how to get that to work
        this.initializeRectangleSprites();
        this.refreshRectangleAndMask(withAreaChange);
        if (withAreaChange) {
            var startIndex = this._startIndexCache;
            var lastIndex = this._lastIndexCache;
            if (startIndex && lastIndex) {
                this.updateAffectedTilesValidBuildInRange(startIndex, lastIndex);
            }
        }
    };
    RectangleInput.createDiamondMask = function (city, startIndex, lastIndex) {
        var deltaCol = Math.abs(startIndex.col - lastIndex.col) + 1;
        var deltaRow = Math.abs(startIndex.row - lastIndex.row) + 1;
        var startDrawIndex = {
            "col": Math.min(startIndex.col, lastIndex.col),
            "row": Math.min(startIndex.row, lastIndex.row)
        };
        var mask = Utils.createDiamondMask(city, deltaCol, deltaRow, Tile.TILE_WIDTH);
        Utils.setPositionToIndex(mask, startDrawIndex.row, startDrawIndex.col, Tile.TILE_WIDTH);
        var newPos = Utils.scaledPosition(city, mask);
        mask.x = newPos.x;
        mask.y = newPos.y;
        return mask;
    };
    /** Match rectangle mask to current drag state and zoom */
    RectangleInput.prototype.refreshRectangleAndMask = function (withAreaChange) {
        if (withAreaChange === void 0) {
            withAreaChange = true;
        }
        if (!this._startIndexCache) {
            return;
        }
        if (withAreaChange) {
            this.buildGrid.city.cityEffects.clearCurrentBuildPendingEffect();
        }
        this.rectangleSprite.visible = true;
        this.lastRectangleSprite.visible = true;
        var startIndex = this._startIndexCache;
        var lastIndex = this._lastIndexCache;
        // Update Mask
        var mask = RectangleInput.createDiamondMask(this.city, startIndex, lastIndex);
        mask.alpha = 0;
        this._mask = mask;
        if (this.tween) {
            this.tween.stop(true);
        }
        if (this.tweenLast) {
            this.tweenLast.stop(true);
        }
        var area = (Math.abs(startIndex.col - lastIndex.col) + 1) * (Math.abs(startIndex.row - lastIndex.row) + 1);
        // If this area is larger than the last, fade in the new area
        if (area > this.lastArea) {
            // Sync previous mask to before animation
            Utils.destroyIfAlive(this.lastRectangleSprite.mask);
            this.lastRectangleSprite.mask = this.rectangleSprite.mask;
            this.lastRectangleSprite.alpha = 1;
            // Apply larger mask to sprite and fade it in
            this.rectangleSprite.mask = mask;
            this.rectangleSprite.alpha = 0;
            this.lastRectangleSprite.alpha = this.lastArea > 0 ? 1 : 0;
            this.tween = this.game.add.tween(this.rectangleSprite).to({ alpha: 1 }, RectangleInput.FADE_TIME, Phaser.Easing.Quadratic.Out, true);
            this.tweenLast = this.game.add.tween(this.lastRectangleSprite).to({ alpha: 0 }, RectangleInput.FADE_TIME, Phaser.Easing.Quadratic.Out, true);
        }
        // If this area is smaller or same, just apply change instantly
        else if (area <= this.lastArea) {
                // Hide previous
                this.lastRectangleSprite.alpha = 0;
                // Set smaller mask and show
                Utils.destroyIfAlive(this.rectangleSprite.mask);
                this.rectangleSprite.mask = mask;
                this.rectangleSprite.alpha = 1;
            }
        this.lastArea = area;
        if (withAreaChange) {
            this.updateAffectedTilesValidBuildInRange(startIndex, lastIndex);
        }
        this.refreshCornerArrows();
    };
    RectangleInput.prototype.onTouchUp = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers >= 1) {
            return;
        }
        if (this._awaitingCommit) return;
        if (this.isInvalidForTutorial()) return;
        var city = this.city;
        _super.prototype.onTouchUp.call(this);
        this._awaitingCommit = true;
        city.buildSignal.dispatch('touchUpRectangleInput');
        if (Global.EASE_CAMEAR_LAST_BUIILD_TILE) {
            this.city.easeCameraToTile(this._lastIndexCache);
        }
    };
    RectangleInput.prototype.onTouchDown = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        if (this.isInvalidForTutorial()) return;
        if (this._lastIndexCache && this._startIndexCache) {
            var toucheableCorners = CityUIGroup.getCornderIndices(this._lastIndexCache, this._startIndexCache);
            for (var i = 0; i < toucheableCorners.length; i++) {
                var cornerIndex = toucheableCorners[i];
                if (Utils.isTouchingCloseToIndexOnZoomout(this.city, cornerIndex)) {
                    // Clear current awaiting commit
                    this._awaitingCommit = false;
                    // set new start and end
                    var oppositeCorner = CityUIGroup.getOppositeCorner(this._startIndexCache, this._lastIndexCache, cornerIndex);
                    this._startIndexCache = {
                        row: oppositeCorner.row, col: oppositeCorner.col
                    };
                    this._lastIndexCache = {
                        row: cornerIndex.row, col: cornerIndex.col
                    };
                    break;
                }
            }
        }
        // Hide drag highlight
        _super.prototype.onTouchDown.call(this);
        this.city.buildSignal.dispatch('touchDownRectangleInput');
    };
    RectangleInput.prototype.refreshCornerArrows = function () {
        // Show drag highlights
        this.city.cityUI.setAreaArrowsVisibility(true);
        var corners = CityUIGroup.getCornderIndices(this._lastIndexCache, this._startIndexCache);
        this.city.cityUI.setLeftArrow(CityUIGroup.getLeftMostCorner(corners));
        this.city.cityUI.setRightArrow(CityUIGroup.getRightMostCorner(corners));
        this.city.cityUI.setDownArrow(CityUIGroup.getBottomMostCorner(corners));
        this.city.cityUI.setUpArrow(CityUIGroup.getTopMostCorner(corners));
        return;
    };
    RectangleInput.prototype.processInput = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        if (this.isInvalidForTutorial()) return;
        _super.prototype.processInput.call(this);
        // Let the user move camera around while committing
        if (this._awaitingCommit) {
            this.city.cameraInputHandler.processInput();
            this._cameraDrag = true;
        } else {
            this._cameraDrag = false;
        }
    };
    RectangleInput.prototype.onCancel = function () {
        Utils.destroyIfAlive(this.rectangleSprite);
        Utils.destroyIfAlive(this.lastRectangleSprite);
        this.buildGrid.alpha = Global.BUILD_ALPHA;
        this.city.cityUI.setAreaArrowsVisibility(false);
        Utils.destroyIfAlive(this._mask);
    };
    RectangleInput.prototype.onConfirm = function () {
        this.createPreCommitTiles();
        Utils.destroyIfAlive(this.rectangleSprite);
        Utils.destroyIfAlive(this.lastRectangleSprite);
        this.buildGrid.alpha = Global.BUILD_ALPHA;
        this.city.cityUI.setAreaArrowsVisibility(false);
        Utils.destroyIfAlive(this._mask);
    };
    RectangleInput.FADE_TIME = 200;
    RectangleInput.ALPHA = 0.5;
    return RectangleInput;
}(GridInput);
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Straight line input (roads)
 * Allow user to change direction from pivot point if on pivot or one tile off from pivot
 * Otherwise, restrict movement along current direction until they stop
 *
 * When touched tile is off from straight, draw the connection and treat it like the start from a second pivot
 * once the velocity direction has changed and the user has started swiping in new direction
 */
var LineTileStraightInput = /** @class */function (_super) {
    __extends(LineTileStraightInput, _super);
    function LineTileStraightInput(buildGrid, tileType) {
        var _this = _super.call(this, buildGrid, tileType) || this;
        _this.finalVertex = null;
        _this.touchedIndex = null;
        _this.vertices = []; // Array of indexes representing vertices of road
        // Drag direction
        _this.prevPosition = null;
        _this.curPosition = null;
        _this.movedDirection = null;
        _this.restrictDirection = null;
        _this._showingConfirmation = false;
        // Index tracking
        _this._prevIndex = null;
        _this._lastAnimatedIn = null;
        _this.totalTiles = 0;
        _this.prevTotalTiles = 0;
        var self = _this;
        _this.tileType = tileType;
        _this.targetGrid = _this.city.grids.roadGrid;
        // Drag direction
        _this.prevPosition = null;
        _this.curPosition = null;
        _this.movedDirection = null;
        _this.restrictDirection = null;
        _this._showingConfirmation = false;
        // Index tracking
        _this._prevIndex = null;
        _this._lastAnimatedIn = null;
        _this.totalTiles = 0;
        _this.prevTotalTiles = 0;
        // Helpers
        _this._booleanGrid = Grid.createEmptyTileSprites(_this.buildGrid.size);
        // Debug
        if (Global.DEBUG_SHOW_ROAD_PIVOTS) {
            _this._pivotsGroup = new Phaser.Group(_this.game);
            _this.city.cityUI.add(_this._pivotsGroup);
        }
        _this.directionTimeout = 0;
        _this.handleResizeTiles = function (event) {
            switch (event) {
                case "new_scale_city":
                case "resize_tiles":
                    if (self.finalVertex) {
                        self.city.buildHelper.buildCash.showBuildCost(self.finalVertex.row, self.finalVertex.col);
                    }
                    break;
                // keep money up do date even when idle
                case "money_updated":
                    if (self.finalVertex) {
                        self.city.buildHelper.buildCash.showBuildCost(self.finalVertex.row, self.finalVertex.col);
                        self.city.buildHelper.checkBuildConfirmationUpdate();
                    }
                    break;
            }
        };
        _this.city.refreshSignal.add(_this.handleResizeTiles);
        return _this;
    }
    LineTileStraightInput.prototype.commitHandler = function () {
        var indexes = this.city.grids.buildGrid.generateIndexTuples();
        this.city.commitBuildTiles();
        if (this.tileType === Tile.Type.Bridge) {
            this.city.grids.roadGrid._bridgeDirtySort = true;
        }
        this.city.grids.roadGrid.calculateRoadAccessForChangedRoads(indexes);
    };
    LineTileStraightInput.prototype.setUIConfirmationHandlers = function () {
        var _this = this;
        // Handlers
        var city = this.city;
        city.setBuildConfirm(function () {
            _this.commitHandler();
            city.setCameraState();
            city.cityUI.highlight.visible = false;
            city.cityUI.highlightDrag.visible = false;
            _this.hideAllHighlights();
        });
        city.setBuildCancel(function () {
            _this.onCancel();
            _this._showingConfirmation = false;
            city.setCameraState();
            _this.hideAllHighlights();
        });
    };
    //
    // Touch events
    //
    // Override touch down
    // TODO: POSSIBLE OPTIMIZATION - performance shows game freezes on touch down
    LineTileStraightInput.prototype.onTouchDown = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        if (!this.city.game.input.activePointer) {
            return;
        }
        this.city.setBuildInteracting(Boolean(this.city.buildHelper._isValidBuild));
        var touchedIndex = Grid.currentTouchedIndex(this.city, this.city.getTileSize());
        if (!touchedIndex) {
            return;
        }
        if (Utils.isTouchingCloseToIndexOnZoomout(this.city, this.finalVertex)) {
            // small touch area helper:
            // override touched index to final vertex to compensate for small touch screens
            touchedIndex = this.finalVertex;
        }
        // Determine if we should extend line or use camera dragging
        this._cameraDrag = this._showingConfirmation && (!touchedIndex || !Utils.isEqualIndexes(touchedIndex, this.finalVertex));
        if (!this._cameraDrag) {
            this.pushPivotVertex(touchedIndex);
            this.finalVertex = touchedIndex;
            // Immediately place tile
            var newTile = this.city.createTilePreferPool(this.tileType);
            this.buildGrid.setTile(touchedIndex.row, touchedIndex.col, newTile);
            this.animateNewFinalVertex();
            // Recalculate existing road tiles
            this.repaintNearbyRoads(this.updateAndGetBooleanGrid(), true);
            this.updateAffectedTilesValidRange();
            this.directionTimeout = 0;
        }
        this.city.buildSignal.dispatch('touchDownLineInput');
    };
    // Main process input - called as long as touch is active
    LineTileStraightInput.prototype.processInput = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers > 1) {
            return;
        }
        if (!this.game.input.activePointer) {
            return;
        }
        GridInput.prototype.processInput.call(this);
        var touchedIndex = Grid.currentTouchedIndex(this.city, this.city.getTileSize());
        var withinBounds = this.buildGrid.withinBounds(touchedIndex.col, touchedIndex.row);
        if (this._cameraDrag) {
            this.city.cameraInputHandler.processInput();
        } else if (this.isDown() && withinBounds) {
            this.directionTimeout += Utils.getElapsedTime(this.game);
            if (this.directionTimeout > LineTileStraightInput.SAME_INDEX_DIRECTION_TIMEOUT) {
                // Clear direction
                this.restrictDirection = null;
                this.directionTimeout = 0;
                // Force update if touched index is not final vertex
                if (!Utils.isEqualIndexes(touchedIndex, this.finalVertex)) {
                    this.onDragTile();
                }
            }
        }
    };
    // Override touch up
    LineTileStraightInput.prototype.onTouchUp = function () {
        if (this.city.windowDisabledInput.inputSprite.visible) {
            return;
        }
        if (this.city.game.input.totalActivePointers >= 1) {
            return;
        }
        var city = this.city;
        city.setBuildStoppedInteracting();
        if (this._cameraDrag) return;
        this._cameraDrag = true;
        // Show confirmation if we've pushed tile(s)
        if (this.finalVertex) {
            this.showConfirmation();
            this.showDrag(this.finalVertex.col, this.finalVertex.row);
            city.buildHelper.buildCash.showBuildCost(this.finalVertex.row, this.finalVertex.col);
            this.city.buildHelper.checkBuildConfirmationUpdate();
            city.buildSignal.dispatch('touchUpLineInput');
        }
    };
    // Called only when tile touched changes
    LineTileStraightInput.prototype.onDragTile = function () {
        var self = this;
        if (this._cameraDrag) return;
        if (!this.game.input.activePointer) {
            return;
        }
        var lastPivot = this.vertices[this.vertices.length - 1];
        var touchedIndex = Grid.currentTouchedIndex(this.city, this.city.getTileSize());
        var prevBuiltIndexDirection = this.indexDirection(lastPivot, this._prevIndex);
        var newTouchedIndexDirection = null;
        if (this._prevIndex && !Utils.isEqualIndexes(touchedIndex, this._prevIndex)) {
            // Determine new direction
            newTouchedIndexDirection = this.indexDirection(this._prevIndex, touchedIndex);
        }
        // Determine direction allowed restriction
        var newPosition = Utils.toPosition(this.game.input.activePointer.worldX, this.game.input.activePointer.worldY);
        var touchDirection = this.getDirection(this.prevPosition, newPosition);
        var previousFinalVertex = Utils.copyIndex(this.finalVertex);
        //
        // Comparison functions
        //
        function isTouchingLastPivot() {
            return self.vertices.length > 0 && Utils.isEqualIndexes(touchedIndex, lastPivot);
        }
        function isCurrentSectionOppositeDirectionOfPrevious() {
            if (self.vertices.length < 2) return false;
            var finalSectionDirection = self.indexDirection(lastPivot, self.finalVertex);
            var secondLastSectionDirection = self.indexDirection(self.vertices[self.vertices.length - 2], lastPivot);
            return self.isOppositeDirection(finalSectionDirection, secondLastSectionDirection);
        }
        function isBetweenFinalVertexAndLastPivot() {
            var lastPivot = self.vertices[self.vertices.length - 1];
            return self.vertices.length > 0 && self.isBetweenVertices(touchedIndex, lastPivot, self.finalVertex, true);
        }
        function isOppositeOfLastMovedDirection() {
            self.isOppositeDirection(self.movedDirection, self.indexDirection(self.lastPivotVertex(), touchedIndex));
        }
        function changedTouchDirection() {
            return (
                // Touch direction is different
                self.movedDirection !== touchDirection && !self.allowedInDirection(touchedIndex, self.movedDirection) ||
                // or no restriction and index direction has changed
                !self.restrictDirection && self.movedDirection !== newTouchedIndexDirection
            );
        }
        function touchDirectionIsMovedDirection(touchDirection) {
            return self.movedDirection === touchDirection;
        }
        function isTouchingNewIndex() {
            return !Utils.isEqualIndexes(touchedIndex, self.finalVertex);
        }
        function nearestIsBetweenLastPivotAndFinalVertex() {
            return self.isBetweenVertices(self.nearestAllowedIndex(touchedIndex, touchDirection), self.finalVertex, self.lastPivotVertex());
        }
        function isTouchedBetweenLastTwoPivots() {
            if (self.vertices.length < 2) {
                return false;
            }
            return self.isBetweenVertices(touchedIndex, self.vertices[self.vertices.length - 2], self.vertices[self.vertices.length - 1]);
        }
        function isTouchingLoopedTileAndShouldBacktrack() {
            if (self.vertices.length > 2 && self.buildGrid.tiles[touchedIndex.row][touchedIndex.col]) {
                var compareTile = self.vertices[self.vertices.length - 1];
                // backtrack until we find where we touched it previously
                var backtrackCount = 0;
                var verticesI = self.vertices.length - 2;
                var _debugcnt = 0;
                while (verticesI >= 0) {
                    var targetVertex = self.vertices[verticesI];
                    var _loop_1 = function _loop_1() {
                        backtrackCount += 1;
                        // Check if this is the touched tile
                        if (compareTile.row === touchedIndex.row && compareTile.col === touchedIndex.col) {
                            return { value: backtrackCount < LineTileStraightInput.MAX_NUM_TILES_BACKTRACK_LOOP };
                        }
                        var delta = [targetVertex.row - compareTile.row, targetVertex.col - compareTile.col];
                        [0, 1].forEach(function (i) {
                            if (delta[i] < 0) {
                                delta[i] = -1;
                            } else if (delta[i] > 0) {
                                delta[i] = 1;
                            }
                        });
                        if (delta[0] === 0 && delta[1] === 0) {
                            return "break";
                        }
                        compareTile = { row: compareTile.row + delta[0], col: compareTile.col + delta[1] };
                        _debugcnt += 1;
                        if (_debugcnt > 200) {
                            throw new Error();
                        }
                    };
                    // backtrack within vertex distance
                    while (true) {
                        var state_1 = _loop_1();
                        if ((typeof state_1 === "undefined" ? "undefined" : _typeof(state_1)) === "object") return state_1.value;
                        if (state_1 === "break") break;
                    }
                    verticesI -= 1;
                    compareTile = targetVertex;
                }
            }
            return false;
        }
        //
        // Backtracking
        //
        var _ignoreOppositeDirectionCheck = false;
        // If on previous vertex, then pop it
        if (isTouchingLastPivot()) {
            if (this.vertices.length > 1) {
                this.vertices.pop();
            }
            this.setFinalVertex(touchedIndex);
            this.movedDirection = this.getLastPushedDirection();
            this.restrictDirection = null;
        }
        // Backtrack if current index is between final vertex touched and last pivot
        // or if touch is between last two pivots
        // or if nearest is between last two pivots and opposite direction
        else if (isBetweenFinalVertexAndLastPivot() || isTouchedBetweenLastTwoPivots()) {
                this.setFinalVertex(touchedIndex);
                this.movedDirection = this.getLastPushedDirection();
                this.restrictDirection = null;
            }
            // Handle unexpected case - direction is not between and is opposite of last moved direction
            else if (isOppositeOfLastMovedDirection()) {
                    // Don't pivot
                    this.setFinalVertex(touchedIndex);
                    this.movedDirection = newTouchedIndexDirection;
                    this.restrictDirection = newTouchedIndexDirection;
                }
                // backtrack if touching a tile that we already touched
                else if (isTouchingLoopedTileAndShouldBacktrack()) {
                        (function () {
                            var cnt = 1;
                            // backtrack until we find where we touched it previously
                            while (self.vertices.length > 1) {
                                var compareTile = self.vertices.pop();
                                var vertex = self.vertices[self.vertices.length - 1];
                                var _loop_2 = function _loop_2() {
                                    cnt += 1;
                                    if (cnt > 200) {
                                        throw Error();
                                    }
                                    // Check if this is the touched tile
                                    if (compareTile.row === touchedIndex.row && compareTile.col === touchedIndex.col) {
                                        return { value: void 0 };
                                    }
                                    var delta = [vertex.row - compareTile.row, vertex.col - compareTile.col];
                                    [0, 1].forEach(function (i) {
                                        if (delta[i] < 0) {
                                            delta[i] = -1;
                                        } else if (delta[i] > 0) {
                                            delta[i] = 1;
                                        }
                                    });
                                    if (delta[0] === 0 && delta[1] === 0) {
                                        return "break";
                                    }
                                    compareTile = { row: compareTile.row + delta[0], col: compareTile.col + delta[1] };
                                };
                                // backtrack within vertex distance
                                while (true) {
                                    var state_2 = _loop_2();
                                    if ((typeof state_2 === "undefined" ? "undefined" : _typeof(state_2)) === "object") return state_2.value;
                                    if (state_2 === "break") break;
                                }
                            }
                        })();
                        var redoDirection = self.indexDirection(this.vertices[this.vertices.length - 1], this.finalVertex);
                        this.setFinalVertex(touchedIndex);
                        this.movedDirection = redoDirection;
                        this.restrictDirection = redoDirection;
                        _ignoreOppositeDirectionCheck = true;
                    }
                    //
                    // Pivoting
                    //
                    // Push new pivot if direction has changed by velocity
                    // and direction of new index is not opposite (between touched index and pivot)
                    // or if there is no restriction and current index direction changed
                    else if (isTouchingNewIndex() && (changedTouchDirection() || !touchDirectionIsMovedDirection(touchDirection)) && !nearestIsBetweenLastPivotAndFinalVertex()) {
                            this.pushPivotVertex(this.finalVertex);
                            this.movedDirection = touchDirection;
                            this.restrictDirection = touchDirection;
                            this.setNearestFinalVertex(touchedIndex);
                            var oldDirection = prevBuiltIndexDirection;
                            var newDirection = newTouchedIndexDirection;
                            // Hacky solution
                            // Remove pivot if oldDirection is same or opposite of new direction
                            if (
                            // Direction check if touch direction
                            oldDirection && newDirection && (oldDirection === newDirection || this.isOppositeDirection(oldDirection, newDirection))) {
                                if (this.vertices.length > 1) {
                                    this.vertices.pop();
                                }
                                var redoDirection = self.indexDirection(this.vertices[this.vertices.length - 1], this.finalVertex);
                                this.setFinalVertex(touchedIndex);
                                this.movedDirection = redoDirection;
                                this.restrictDirection = redoDirection;
                            }
                        }
                        //
                        // Same direction
                        //
                        else {
                                // Push tile to nearest available
                                this.setNearestFinalVertex(touchedIndex);
                            }
        var _errorCorrected = false;
        if (this.finalVertex) {
            // Clear last pivot if somehow directly opposite direction section
            if (!_ignoreOppositeDirectionCheck && isCurrentSectionOppositeDirectionOfPrevious()) {
                this.vertices.pop();
                _errorCorrected = true;
            }
            this.showTouchHighlight(this.finalVertex.col, this.finalVertex.row);
        }
        if (!Utils.isEqualIndexes(this.finalVertex, previousFinalVertex) || _errorCorrected) {
            this.rebuildTiles();
        }
        if (this.finalVertex) {
            // Update build text
            this.city.buildHelper.buildCash.showBuildCost(this.finalVertex.row, this.finalVertex.col);
            this.city.buildHelper.checkBuildConfirmationUpdate();
        }
        // Update latest pos
        this.prevPosition = newPosition;
        // DEBUG: Draw pivots
        if (Global.DEBUG_SHOW_ROAD_PIVOTS) {
            Utils.destroyIfAlive(this._pivotsGroup);
            this._pivotsGroup = new Phaser.Group(this.game);
            this.city.cityUI.add(this._pivotsGroup);
            var v = void 0;
            var i = void 0;
            var max = void 0;
            for (i = 0, max = this.vertices.length; i < max; i++) {
                v = this.vertices[i];
                var pos = Utils.indexToPosition(v.col, v.row, self.city.getTileSize());
                pos.x -= 25;
                pos.y -= 25;
                var icon = new Phaser.Sprite(self.game, pos.x, pos.y, "highlight", 0);
                icon.width = 50;
                icon.height = 50;
                self._pivotsGroup.add(icon);
            }
        }
        // play sound
        if (!this._prevIndex || this._prevIndex.col !== this.finalVertex.col || this._prevIndex.row !== this.finalVertex.row) {
            AudioPC.playBuildDrag(this.game);
        }
        //
        // Update Stack
        //
        this._prevIndex = this.finalVertex;
    };
    // Check if index resides between two other indices, non inclusively
    LineTileStraightInput.prototype.isBetweenVertices = function (vertex, v1, v2, inclusive) {
        if (inclusive === void 0) {
            inclusive = false;
        }
        var minRow = Math.min(v1.row, v2.row);
        var maxRow = Math.max(v1.row, v2.row);
        var minCol = Math.min(v1.col, v2.col);
        var maxCol = Math.max(v1.col, v2.col);
        if (!inclusive) {
            if (vertex.row === v1.row && v1.row === v2.row) {
                return vertex.col > minCol && vertex.col < maxCol;
            } else if (vertex.col === v1.col && v1.col === v2.col) {
                return vertex.row > minRow && vertex.row < maxRow;
            }
        } else {
            if (vertex.row === v1.row && v1.row === v2.row) {
                return vertex.col >= minCol && vertex.col <= maxCol;
            } else if (vertex.col === v1.col && v1.col === v2.col) {
                return vertex.row >= minRow && vertex.row <= maxRow;
            }
        }
        return false;
    };
    //
    // Directions
    //
    // Check the last two vertices for the last segment direction
    LineTileStraightInput.prototype.getLastPushedDirection = function () {
        if (this.vertices.length > 0) {
            return this.indexDirection(this.lastPivotVertex(), this.finalVertex);
        } else {
            return null;
        }
    };
    LineTileStraightInput.prototype.indexDirection = function (startIndex, endIndex) {
        if (!startIndex || !endIndex) {
            return null;
        }
        if (startIndex.row === endIndex.row) {
            return startIndex.col < endIndex.col ? LineTileStraightInput.DIRECTIONS.RIGHT : LineTileStraightInput.DIRECTIONS.LEFT;
        } else {
            return startIndex.row < endIndex.row ? LineTileStraightInput.DIRECTIONS.DOWN : LineTileStraightInput.DIRECTIONS.UP;
        }
    };
    LineTileStraightInput.prototype.allowedInDirection = function (index, dir) {
        if (!this.lastPivotVertex()) {
            return true;
        }
        if (this.isHorizontal(dir)) {
            return this.lastPivotVertex().row === index.row;
        } else {
            return this.lastPivotVertex().col === index.col;
        }
    };
    // Return direction between two points
    LineTileStraightInput.prototype.getDirection = function (prevPos, curPos) {
        if (!prevPos || !curPos) {
            return;
        }
        var deltaY = prevPos.y - curPos.y;
        var deltaX = prevPos.x - curPos.x;
        var angle = Math.atan2(deltaY, deltaX) * 180 / Math.PI;
        if (angle < 0) {
            angle = angle + 360;
        }
        return this.toDirection(angle);
    };
    LineTileStraightInput.prototype.isOppositeDirection = function (prevDir, newDir) {
        if (prevDir === newDir) {
            return false;
        }
        function isDirs(d1, d2, staticDir1, staticDir2) {
            var isDir = false;
            [[d1, d2], [d2, d1]].map(function (dirs) {
                if (dirs[0] === staticDir1 && dirs[1] === staticDir2) {
                    isDir = true;
                }
            });
            return isDir;
        }
        return isDirs(prevDir, newDir, LineTileStraightInput.DIRECTIONS.LEFT, LineTileStraightInput.DIRECTIONS.RIGHT) || isDirs(prevDir, newDir, LineTileStraightInput.DIRECTIONS.UP, LineTileStraightInput.DIRECTIONS.DOWN);
    };
    LineTileStraightInput.prototype.isHorizontal = function (dir) {
        return dir === LineTileStraightInput.DIRECTIONS.LEFT || dir == LineTileStraightInput.DIRECTIONS.RIGHT;
    };
    LineTileStraightInput.prototype.toDirection = function (angle) {
        //[y,x]
        var dirs = [LineTileStraightInput.DIRECTIONS.LEFT, LineTileStraightInput.DIRECTIONS.UP, LineTileStraightInput.DIRECTIONS.RIGHT, LineTileStraightInput.DIRECTIONS.DOWN];
        for (var i = 0, _max = dirs.length; i < _max; i++) {
            var min = i * 90;
            var max = (i + 1) * 90;
            if (min <= angle && angle <= max) {
                return dirs[i];
            }
        }
        throw new Error("could not determine direction from angle: " + angle);
    };
    //
    // Vertices
    //
    LineTileStraightInput.prototype.setNearestFinalVertex = function (index) {
        this.setFinalVertex(this.nearestAllowedIndex(index, this.restrictDirection));
    };
    LineTileStraightInput.prototype.nearestAllowedIndex = function (index, restrictionDirection) {
        if (!restrictionDirection) {
            return index;
        }
        var lastVertex = this.lastPivotVertex();
        return this.isHorizontal(this.restrictDirection) ? Utils.toIndex2D(index.col, lastVertex.row) : Utils.toIndex2D(lastVertex.col, index.row);
    };
    LineTileStraightInput.prototype.setFinalVertex = function (index) {
        var lastPivot = this.vertices[this.vertices.length - 1];
        // Push another pivot if index is neither in same row or column as previous finalVertex
        if (index.col !== lastPivot.col && index.row !== lastPivot.row) {
            // Continue moving final vertex along existing axis until reaching new index
            var tmpIndex = Utils.copyIndex(lastPivot);
            var adder = void 0;
            var currentDirection = this.indexDirection(lastPivot, this.finalVertex);
            var adjustCol = currentDirection === LineTileStraightInput.DIRECTIONS.LEFT || currentDirection === LineTileStraightInput.DIRECTIONS.RIGHT;
            if (adjustCol) {
                adder = index.col - tmpIndex.col > 0 ? 1 : -1;
                while (index.col !== tmpIndex.col) {
                    tmpIndex.col += adder;
                }
            } else {
                adder = index.row - tmpIndex.row > 0 ? 1 : -1;
                while (index.row !== tmpIndex.row) {
                    tmpIndex.row += adder;
                }
            }
            this.pushPivotVertex(tmpIndex);
        }
        this.finalVertex = index;
    };
    LineTileStraightInput.prototype.pushPivotVertex = function (index) {
        if (!index) {
            throw new Error("tried to push null index");
        }
        if (!Utils.isEqualIndexes(this.lastPivotVertex(), index)) {
            this.vertices.push(index);
        }
    };
    LineTileStraightInput.prototype.lastPivotVertex = function () {
        return this.vertices.length > 0 ? this.vertices[this.vertices.length - 1] : null;
    };
    // for testing
    LineTileStraightInput.prototype._rebuildExactTiles = function (indexArr) {
        var _this = this;
        var oldGrid = this._booleanGrid;
        Utils.foreach2D(this.buildGrid.tiles, function (tile, row, col) {
            if (tile) {
                _this.buildGrid.destroyTileIfExists(col, row);
            }
        });
        indexArr.forEach(function (i) {
            var newTile = _this.city.createTilePreferPool(_this.tileType);
            _this.buildGrid.setTile(i.row, i.col, newTile);
        });
        this.finalVertex = {
            row: indexArr[indexArr.length - 1].row,
            col: indexArr[indexArr.length - 1].col
        };
        this.postRebuild(oldGrid);
        this.onTouchUp();
    };
    //
    // Repaint
    //
    // Ensure only create/remove tiles that aren't in the pivots array
    LineTileStraightInput.prototype.rebuildTiles = function () {
        var self = this;
        // Put indices from vertice array into memory hashset
        var hasTile = {};
        var oldGrid = this._booleanGrid;
        self.prevTotalTiles = self.totalTiles;
        self.totalTiles = 0;
        // hacky, but temporarily push final vertex then take it away again
        this.vertices.push(this.finalVertex);
        var prev, vertex;
        for (var i = 1; i < this.vertices.length; i++) {
            prev = this.vertices[i - 1];
            vertex = this.vertices[i];
            Utils.applyBetween(prev, vertex, function (row, col) {
                hasTile[Utils.toIndexKey(row, col, self.city.size)] = 1;
                self.totalTiles += 1;
            });
        }
        // revert the hack
        this.vertices.pop();
        // Not optimized starts
        // Map over tiles and ensure they are up to date
        var tileType = this.tileType;
        var city = this.city;
        Utils.foreach2D(this.buildGrid.tiles, function (tile, row, col) {
            var shouldExist = hasTile[Utils.toIndexKey(row, col, self.city.size)];
            if (shouldExist && !tile) {
                var newTile = city.createTilePreferPool(tileType);
                self.buildGrid.setTile(row, col, newTile);
            } else if (!shouldExist && tile) {
                self.buildGrid.destroyTileIfExists(col, row);
            }
        });
        // Not optimized ends
        this.postRebuild(oldGrid);
    };
    LineTileStraightInput.prototype.postRebuild = function (oldGrid) {
        var _this = this;
        // ensures disconnected roads are updated
        this.repaintNearbyRoads(oldGrid);
        // ensures all build tiles are updated (fixes weird intermittent recalc bug)
        var newGrid = this.updateAndGetBooleanGrid();
        setTimeout(function () {
            _this.repaintNearbyRoads(newGrid, true);
        }, 0);
        Utils.sortGroupY(this.buildGrid);
        // eh just stick this here
        this.animateNewFinalVertex();
        setTimeout(function () {
            _this.updateAffectedTilesValidRange();
        }, 0);
    };
    LineTileStraightInput.prototype.repaintNearbyRoads = function (oldTiles, withoutDiff) {
        if (withoutDiff === void 0) {
            withoutDiff = false;
        }
        if (withoutDiff === true) {
            // Dispatch with given tiles
            this.city.signalOncePostUpdate("rebuilt_grid_tiles", oldTiles);
        } else {
            var touchingTiles = Utils.getTouchingTiles(Utils.getGridDiff(oldTiles, this.buildGrid.tiles));
            // Dispatch with changed tiles;
            this.city.signalOncePostUpdate("rebuilt_grid_tiles", touchingTiles);
        }
    };
    LineTileStraightInput.prototype.updateAndGetBooleanGrid = function () {
        var self = this;
        Utils.apply2D(self.buildGrid.tiles, function (tile, row, col) {
            self._booleanGrid[row][col] = tile ? 1 : 0;
        });
        return self._booleanGrid;
    };
    //
    // Highlighter
    //
    LineTileStraightInput.prototype.showDrag = function (col, row) {
        if (Global.EASE_CAMEAR_LAST_BUIILD_TILE) {
            this.city.easeCameraToTile({ col: col, row: row });
        }
        this.city.cityUI.moveHighlightDrag(col, row);
        this.city.cityUI.highlightDrag.visible = true;
        this.city.cityUI.highlight.visible = false;
    };
    LineTileStraightInput.prototype.hideAllHighlights = function () {
        this.city.cityUI.highlightDrag.visible = false;
        this.city.cityUI.highlight.visible = false;
    };
    LineTileStraightInput.prototype.showTouchHighlight = function (col, row) {
        // Place highlight on last touched tile
        this.city.cityUI.highlight.visible = true;
        this.city.cityUI.moveHighlight(col, row);
        this.city.cityUI.highlightDrag.visible = false;
    };
    LineTileStraightInput.prototype.popInFinalVertexTile = function () {
        var sprite = this.buildGrid.tiles[this.finalVertex.row][this.finalVertex.col];
        if (sprite) {
            if (sprite['_popInTween']) {
                sprite['_popInTween'].stop(true);
            }
            var w_1 = sprite.width;
            var h_1 = sprite.height;
            sprite.width *= LineTileStraightInput.POP_AMT;
            sprite.height *= LineTileStraightInput.POP_AMT;
            sprite['_popInTween'] = this.game.add.tween(sprite).to({
                width: w_1,
                height: h_1
            }, LineTileStraightInput.FADE_TIME, Phaser.Easing.Quadratic.Out, true);
            sprite['_popInTween'].onComplete.add(function () {
                sprite.width = w_1;
                sprite.height = h_1;
            });
        }
    };
    LineTileStraightInput.prototype.animateNewFinalVertex = function () {
        if (!Utils.isEqualIndexes(this._lastAnimatedIn, this.finalVertex)) {
            if (Global.ENABLE_ROAD_POP_IN && (this.totalTiles === 0 || this.totalTiles > this.prevTotalTiles)) {
                this.slideInFinalVertexTile();
            }
            // count total tiles
            if (Global.SHOW_ROAD_BURST && (this.totalTiles === 0 || this.totalTiles > this.prevTotalTiles)) {
                this.city.cityEffects.animateBuildBurst(this.finalVertex.row, this.finalVertex.col, 1.25);
            }
        }
    };
    LineTileStraightInput.prototype.slideInFinalVertexTile = function () {
        var sprite = this.buildGrid.tiles[this.finalVertex.row][this.finalVertex.col];
        if (sprite) {
            if (sprite['_popInTween']) {
                sprite['_popInTween'].stop(true);
            }
            var y = sprite.y;
            //sprite.y = y + LineTileStraightInput.POP_Y_SHIFT;
            sprite.alpha = 0.5;
            sprite['_popInTween'] = this.game.add.tween(sprite).to({
                //y: y,
                alpha: 1
            }, LineTileStraightInput.FADE_TIME, Phaser.Easing.Quadratic.Out, true);
            sprite['_popInTween'].onComplete.add(function () {
                //sprite.y = y;
                sprite.alpha = 1;
            });
            this._lastAnimatedIn = Utils.copyIndex(this.finalVertex);
        }
    };
    //
    // Confirmation
    //
    LineTileStraightInput.prototype.showConfirmation = function () {
        var city = this.city;
        this._showingConfirmation = true;
        city.allowConfirmBuild();
    };
    LineTileStraightInput.prototype.onCancel = function () {
        var tilesBeforeClear = this.updateAndGetBooleanGrid();
        this.buildGrid.clearTiles();
        var needsCaching = this.targetGrid.cacheAsBitmap;
        if (needsCaching) {
            this.targetGrid.cacheAsBitmap = false;
        }
        this.city.signalOncePostUpdate("rebuilt_grid_tiles", tilesBeforeClear);
        if (needsCaching) {
            this.targetGrid.cacheAsBitmap = true;
        }
    };
    LineTileStraightInput.DIRECTIONS = {
        "UP": "up",
        "LEFT": "left",
        "DOWN": "down",
        "RIGHT": "right"
    };
    LineTileStraightInput.FADE_TIME = 200;
    LineTileStraightInput.POP_AMT = 1.5;
    LineTileStraightInput.POP_Y_SHIFT = 10;
    LineTileStraightInput.SAME_INDEX_DIRECTION_TIMEOUT = 250;
    LineTileStraightInput.MAX_NUM_TILES_BACKTRACK_LOOP = 9;
    return LineTileStraightInput;
}(GridInput);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var LineTileSkyRailInput = /** @class */function (_super) {
    __extends(LineTileSkyRailInput, _super);
    function LineTileSkyRailInput(buildGrid, tileType) {
        var _this = _super.call(this, buildGrid, tileType) || this;
        _this.targetGrid = _this.city.grids.roadGrid;
        return _this;
    }
    LineTileSkyRailInput.prototype.repaintNearbyRoads = function (oldTiles, withoutDiff) {
        if (withoutDiff === void 0) {
            withoutDiff = false;
        }
        if (withoutDiff === true) {
            // Dispatch with given tiles
            this.city.signalOncePostUpdate("sky_rail_related_updated_during_build", oldTiles);
        } else {
            var tileDiff = Utils.getGridDiff(oldTiles, this.buildGrid.tiles);
            // Dispatch with changed tiles;
            this.city.signalOncePostUpdate("sky_rail_related_updated_during_build", tileDiff);
        }
    };
    // Override so that alpha is not affected on vertex tile animation
    LineTileSkyRailInput.prototype.popInFinalVertexTile = function () {};
    LineTileSkyRailInput.prototype.animateNewFinalVertex = function () {};
    LineTileSkyRailInput.prototype.slideInFinalVertexTile = function () {};
    LineTileSkyRailInput.prototype.commitHandler = function () {
        var touchingTiles = this.city.buildHelper.genericCommitBuildTiles();
        // update texture
        this.city.refreshSignal.dispatch("sky_rail_refresh", touchingTiles);
        this.city.skyRailTraffic.refreshValidSpawns();
        this.city.cityEffects.animateBuildBitmapFadeOut();
    };
    return LineTileSkyRailInput;
}(LineTileStraightInput);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/** Upgrade existing zone tiles */
var RectangleTerrainInput = /** @class */function (_super) {
    __extends(RectangleTerrainInput, _super);
    function RectangleTerrainInput(buildGrid, t, tex, texFrame) {
        return _super.call(this, buildGrid, t, tex, texFrame) || this;
    }
    RectangleTerrainInput.prototype.createPreCommitTiles = function () {
        // override by children, then call this after:
        this.buildGrid.clearTiles();
        this.city.structureCache.syncSoon();
        this.city.grids.terrainGrid._updateCustomGlobalSettings();
    };
    RectangleTerrainInput.destroyToFlatLand = function (city, row, col, destroyWater, destroySand, destroyMountain, destroyLava) {
        if (destroyWater === void 0) {
            destroyWater = true;
        }
        if (destroySand === void 0) {
            destroySand = true;
        }
        if (destroyMountain === void 0) {
            destroyMountain = true;
        }
        if (destroyLava === void 0) {
            destroyLava = true;
        }
        city.safeGeneralDestroyTile(row, col);
        city.destroyAllEntitiesAtTileFun(row, col);
        city.grids.terrainGrid.clearCustomTreeTerrain(row, col);
        if (destroyWater) {
            city.grids.terrainGrid.destroyWaterAtIndex(row, col);
        }
        if (destroySand) {
            // also destroys soil
            city.grids.terrainGrid.destroySandAtIndex(row, col);
            city.grids.terrainGrid.clearCustomSoilTerrain(row, col);
        }
        if (destroyLava) {
            city.grids.terrainGrid.destroyLavaAtIndex(row, col, true);
        }
        if (destroyMountain) {
            var t = city.grids.terrainGrid.mountainGrid.tiles[row][col];
            if (t instanceof Mountain) {
                city.grids.terrainGrid.destroyMountain(t.row, t.col);
                if (city.grids.terrainGrid._enableAnimationsCustom && city.performance.enableTerrainAnim) {
                    if (city.pocketCity.enableSpecialFX) {
                        new Explosion(city, t.row, t.col);
                        city.cityEffects.destroyBlockPuff(t.row, t.col, 2);
                    }
                }
            }
        }
    };
    RectangleTerrainInput.FX_COUNT_CUTOFF = 80;
    return RectangleTerrainInput;
}(RectangleInput);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * A grid for structure sprites, not really tiles
 */
var StructureGrid = /** @class */function (_super) {
    __extends(StructureGrid, _super);
    function StructureGrid(city, size, windowInput) {
        var _this = _super.call(this, city, size, windowInput, null, true) || this;
        _this.shouldBeInvisible = false;
        _this.needsForceApplyGridVisibilityOnZoomIn = false;
        _this.needSortDueToZoomeoutBuild = false;
        _this.lastVisible = -1;
        _this.name = "structuregrid";
        _this.townHallHelper = new TownHallHelper(city);
        _this.city.refreshSignal.add(function (event) {
            if (!_this.city.game) {
                return;
            }
            switch (event) {
                case "zones_updated":
                    _this.needsForceApplyGridVisibilityOnZoomIn = true; // no break intentional
                case "roads_updated":
                    _this.refreshAllSawmillsEffects();
                    break;
                case "trees_planted":
                    _this.refreshAllSawmillsEffects();
                    break;
            }
        });
        _this.resetClusterOnDepthSort = true;
        _this.clusterMaxY = ClusterFinder.CLUSTER_BATCH_MAX_Y_DIFF_STRUCT_LOWER;
        _this.clusterMinX = ClusterFinder.CLUSTER_MIN_X_DIFF_STRUCT_LOWER;
        _this.checkUpdateClusters = function () {
            // DOES NOTHING ACTUALLY since sortGroupDepth handles everything...
        };
        _this.sortOverrideFn = Utils.addChildIntoTextureSort;
        _this.sortGroupDepth = function () {
            // override
            _this.customSort(WithGroupDepthSortMixin._sortGroupTextureCustomSort, _this);
        };
        return _this;
    }
    StructureGrid.prototype.update = function () {
        var currentVisible = this.visible ? 1 : 0;
        if (this.lastVisible !== -1 && this.lastVisible !== currentVisible && this.needsForceApplyGridVisibilityOnZoomIn) {
            this.applyZoominVisibilityRefresh();
        }
        _super.prototype.update.call(this, this.city._forceStructureTransform);
        this.checkUpdateClusters();
        this.lastVisible = currentVisible;
    };
    StructureGrid.prototype.applyZoominVisibilityRefresh = function () {
        this.resetCull();
        this.applyCullChildren();
        this.city.upperStructureLayer.applyCullChildren();
        this.city.smartUpdateNext();
        this.needsForceApplyGridVisibilityOnZoomIn = false;
    };
    StructureGrid.prototype.onCullDone = function () {
        // nothing, don't update clusters on each cull
    };
    StructureGrid.prototype.updateTransform = function () {
        _super.prototype.updateTransform.call(this, this.city._forceStructureTransform);
    };
    StructureGrid.prototype.refreshAllStructureEffectsChildren = function () {
        var child;
        for (var i = 0; i < this.children.length; i++) {
            child = this.children[i];
            if (child.refreshUpperStructureEffects) {
                child.refreshUpperStructureEffects();
            }
        }
        this.city.smartUpdateNext();
    };
    StructureGrid.prototype.refreshAllSawmillsEffects = function () {
        this.city.structureCache.getSawMills().forEach(function (s) {
            if (s.structureGroup) {
                s.structureGroup.refreshSawmillEffects();
            }
        });
    };
    StructureGrid.prototype.setTile = function (row, col, structureGroup) {
        // ensure upper structure mask inserted into mask layer
        if (structureGroup && !this.city.headlessMode) {
            //structureGroup.Tile.scaleAndPositionStructure();
            structureGroup.upperMaskSprite.row = row;
            structureGroup.upperMaskSprite.col = col;
        }
        // SUPER override - don't insert by z index, insert by texture name
        _super.prototype.setTile.call(this, row, col, structureGroup, true);
    };
    return StructureGrid;
}(Grid);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * A grid for resources with spawns that flood resource to road tiles
 */
var ResourceOnRoadGrid = /** @class */function (_super) {
    __extends(ResourceOnRoadGrid, _super);
    function ResourceOnRoadGrid(city, size, windowInput, disableCull) {
        if (disableCull === void 0) {
            disableCull = true;
        }
        var _this = _super.call(this, city, size, windowInput, null, null, disableCull) || this;
        //Grid.call(this, city, size, windowInput, undefined, undefined, true);
        // reusable buildBooleanTiles
        _this.buildBooleanTiles = Grid.createEmptyTileSprites(city.size);
        _this.committedBooleanTiles = Grid.createEmptyTileSprites(city.size);
        _this._booleanFromSpawnTiles = Grid.createEmptyTileSprites(size, 0);
        _this._booleanFromRoadTiles = Grid.createEmptyTileSprites(size, 0);
        _this._outputFlattenGrid = Grid.createEmptyTileSprites(size, false);
        _this.hide();
        return _this;
    }
    /**
     * Updates current committed boolean tiles reference
     */
    ResourceOnRoadGrid.prototype.updateCommittedBoolTiles = function () {
        var booleanResourceOnRoadGrid = this.getBooleanResourceOnRoadGrid();
        var committedTiles = this.committedBooleanTiles;
        var s = this.city.size;
        for (var i = 0; i < s; i++) {
            for (var j = 0; j < s; j++) {
                committedTiles[i][j] = Boolean(booleanResourceOnRoadGrid[i][j]);
            }
        }
    };
    /**
     * show this grid
     * if building state: show current buid + uncommitted + committed + incomplete
     * if camera state: show committed + completed
     */
    ResourceOnRoadGrid.prototype.showCurrent = function (alpha) {
        var _this = this;
        if (alpha === void 0) {
            alpha = ResourceOnRoadGrid.SHOW_ALPHA;
        }
        // Also add tiles for self and build grid
        var buildBoolean = this.buildBooleanTiles;
        // also include current structure build and incomplete
        var baseIndex;
        var buildStructureState = this.city.buildHelper.getBuildingStateStructure();
        if (buildStructureState && (buildStructureState.input.baseIndex || buildStructureState.input instanceof StructureInputMulti && buildStructureState.input.hasAnyPendingBuilding())) {
            if (buildStructureState.input.baseIndex) {
                //
                // Apply single input
                //
                baseIndex = buildStructureState.input.baseIndex;
                baseIndex.isSmall = buildStructureState.input.building.sizeCol === 1 && buildStructureState.input.building.sizeRow === 1;
                baseIndex.building = buildStructureState.input.building;
                // is moving?
                var booleanGridWithCurrentBuild = void 0;
                if (MainUI.Move.isMoveMode && MainUI.Move.inspecingTile && !(baseIndex.row === MainUI.Move.inspecingTile.row && baseIndex.col === MainUI.Move.inspecingTile.col)) {
                    booleanGridWithCurrentBuild = this.getBooleanResourceOnRoadGrid(baseIndex, false, MainUI.Move.inspecingTile);
                } else {
                    booleanGridWithCurrentBuild = this.getBooleanResourceOnRoadGrid(baseIndex);
                }
                Utils.setAll2D(this._outputFlattenGrid, false);
                buildBoolean = Utils.flattenBooleanGrids(buildBoolean, booleanGridWithCurrentBuild, this._outputFlattenGrid);
            } else {
                //
                // Apply multi inputs
                //
                var booleanGridWithCurrentBuild_1;
                buildStructureState.input.foreachDesiredIndex(function (row, col) {
                    var _index = {
                        row: row, col: col,
                        isSmall: buildStructureState.input.building.sizeCol === 1 && buildStructureState.input.building.sizeRow === 1,
                        building: buildStructureState.input.building
                    };
                    var withResource = _this.getBooleanResourceOnRoadGrid(_index);
                    if (!booleanGridWithCurrentBuild_1) {
                        booleanGridWithCurrentBuild_1 = withResource;
                    } else {
                        booleanGridWithCurrentBuild_1 = Utils.flattenBooleanGrids(booleanGridWithCurrentBuild_1, withResource, booleanGridWithCurrentBuild_1);
                    }
                });
                // in case of 0 (which shouldn't happen)
                if (!booleanGridWithCurrentBuild_1) {
                    console.warn("this shouldn't happen");
                    booleanGridWithCurrentBuild_1 = Grid.createEmptyTileSprites(buildBoolean.length, false);
                }
                Utils.setAll2D(this._outputFlattenGrid, false);
                buildBoolean = Utils.flattenBooleanGrids(buildBoolean, booleanGridWithCurrentBuild_1, this._outputFlattenGrid);
            }
        }
        // only include committed and completed
        else {
                buildBoolean = this.getBooleanResourceOnRoadGrid(null, true);
            }
        this.syncWhiteTilesToBooleanGrid(buildBoolean);
        this.alpha = alpha;
        this.visible = true;
        this.update(true);
        this.updateTransform(true);
    };
    ResourceOnRoadGrid.prototype.hide = function () {
        if (this.visible) {
            this.clearTiles(this.city.whiteTilePool);
            this.alpha = 0;
            this.visible = false;
        }
    };
    ResourceOnRoadGrid.prototype.getSpawns = function (mustBeComplete) {
        // Find spawn structures
        return this.city.structureCache.getBuildingsOfType(this.SPAWN_BUILDING_TYPE, !mustBeComplete);
    };
    /**
     * Get the current boolean grid for this resource
     * @index - additional spawn index to add, even if its not been committed,
     *  should contain .isSmall for small resource inputs for structure input
     *  can contain .building to be passed down
     * @mustBeComplete - only count spawns buildings that are complete
     * @additionalExclude - don't consider this index, even if it is build
     * */
    ResourceOnRoadGrid.prototype.getBooleanResourceOnRoadGrid = function (additionalSpawn, mustBeComplete, additionalExclude) {
        if (additionalSpawn === void 0) {
            additionalSpawn = null;
        }
        if (mustBeComplete === void 0) {
            mustBeComplete = false;
        }
        if (additionalExclude === void 0) {
            additionalExclude = null;
        }
        var SPAWN_BUILDING_TYPE = this.SPAWN_BUILDING_TYPE;
        if (!SPAWN_BUILDING_TYPE) {
            throw new Error("child class must set spawn building type");
        }
        if (additionalSpawn) {
            additionalSpawn.isMainSpawnOverride = true;
        }
        var booleanTiles = this._booleanFromRoadTiles;
        Utils.setAll2D(booleanTiles, 0);
        // Find spawn structures
        var spawns = this.getSpawns(mustBeComplete);
        // Also add additional index if given
        if (additionalSpawn) {
            spawns.push(additionalSpawn);
        }
        // Remove spawn if it is excluded
        if (additionalExclude) {
            for (var s = spawns.length - 1; s >= 0; s--) {
                if (spawns[s].row === additionalExclude.row && spawns[s].col === additionalExclude.col) {
                    spawns.splice(s, 1);
                    break;
                }
            }
        }
        // Update boolean tiles
        // 1. near spawns
        var spawn;
        if (spawns.length > 0) {
            for (var i = 0, _max = spawns.length; i < _max; i++) {
                spawn = spawns[i];
                booleanTiles[spawn.row][spawn.col] = true;
            }
        }
        // 2. get floodfill affected
        if (spawns.length > 0) {
            var floodfillBoolTiles = this.getBooleanGridFromSpawnFloodfill(spawns, additionalSpawn);
            booleanTiles = Utils.flattenBooleanGrids(booleanTiles, floodfillBoolTiles);
        }
        return booleanTiles;
    };
    ResourceOnRoadGrid.prototype.getBooleanGridFromSpawnFloodfill = function (spawns, extraForceSpawn) {
        throw new Error("to be implemented by child");
    };
    ResourceOnRoadGrid.prototype.isSameTypeStructureTile = function (row, col, spawn) {
        // hacky way of creating larger radius of spawn effect for larger spawn structures
        var isSmall = spawn.isSmall;
        if (this.city.grids.powerGrid.smallCheckOverrideAccuracy) {
            if (typeof spawn.isSmall === 'undefined') {
                isSmall = spawn.building && spawn.building.sizeRow == 1 && spawn.building.sizeCol === 1;
            }
        }
        if (!isSmall && (row == spawn.row - 1 && col == spawn.col || row == spawn.row && col == spawn.col - 1 || row == spawn.row - 1 && col == spawn.col - 1)) {
            return true;
        }
        var structureTile = this.city.grids.zoneGrid.tiles[row][col];
        if (!structureTile) {
            return false;
        }
        if (structureTile._master) {
            structureTile = structureTile._master;
        }
        if (structureTile && structureTile.building) {
            return structureTile.building.type == this.SPAWN_BUILDING_TYPE;
        } else {
            return false;
        }
    };
    ResourceOnRoadGrid.SHOW_ALPHA = 0.5;
    ResourceOnRoadGrid.OFF_ROAD_RADIUS = 2;
    ResourceOnRoadGrid.MAX_Y_ADJUST = -0.038 * 60; // 60 comes directly from Tile.TILE_WIDTH, but this is defined before that
    ResourceOnRoadGrid.MIN_SCALE_REDUCE = 0.037;
    ResourceOnRoadGrid._MIN_MAX_SCALE_REDUCE_DELTA = -0.003; // more negative means bigger large tiles
    ResourceOnRoadGrid.MAX_DIST = 5;
    return ResourceOnRoadGrid;
}(Grid);
ResourceOnRoadGrid.prototype.SPAWN_BUILDING_TYPE = "";
ResourceOnRoadGrid.prototype.TINT_COLOR = 0xaaaaaa;
var SupplyUpkeepHelper = /** @class */function () {
    function SupplyUpkeepHelper(city) {
        this.lastActiveSupplyCoLocations = {};
        this.city = city;
        this.reductionMult = 1 - SupplyUpkeepHelper.REDUCTION_AMT;
        this.coverage = Utils.initialize2DArray(city.size, city.size, 0);
    }
    SupplyUpkeepHelper.prototype.checkRecalculate = function () {
        if (this.hasSupplyCoLocationsChangd()) {
            this.recalculateCoverage();
        }
    };
    SupplyUpkeepHelper.prototype.hasSupplyCoLocationsChangd = function () {
        var _this = this;
        var newSupplyCoLocations = {};
        var isSameAsOld = true;
        this.city.structureCache.getSupplyCos().forEach(function (building) {
            var k = Utils.toIndexKey(building.row, building.col, _this.city.size);
            if (!_this.lastActiveSupplyCoLocations[k]) {
                isSameAsOld = false;
            }
            newSupplyCoLocations[k] = 1;
        });
        return !(isSameAsOld && Object.keys(newSupplyCoLocations).length === Object.keys(this.lastActiveSupplyCoLocations).length);
    };
    SupplyUpkeepHelper.prototype.isCovered = function (row, col) {
        return this.coverage[row][col] === 1;
    };
    SupplyUpkeepHelper.prototype.recalculateCoverage = function () {
        var _this = this;
        console.log("recalculating supply co coverage");
        Utils.setAll2D(this.coverage, 0);
        Utils.resetObject(this.lastActiveSupplyCoLocations);
        var rad = SupplyUpkeepHelper.RADIUS;
        this.city.structureCache.getSupplyCos().forEach(function (building) {
            var k = Utils.toIndexKey(building.row, building.col, _this.city.size);
            _this.lastActiveSupplyCoLocations[k] = 1;
            for (var r = building.row - rad; r <= building.row + rad; r++) {
                for (var c = building.col - rad; c <= building.col + rad; c++) {
                    if (Utils.isValidIndex(r, c, _this.city.size)) {
                        _this.coverage[r][c] = 1;
                    }
                }
            }
        });
    };
    SupplyUpkeepHelper.RADIUS = 10;
    SupplyUpkeepHelper.REDUCTION_AMT = 0.25;
    return SupplyUpkeepHelper;
}();
var RecyclingHelper = /** @class */function () {
    function RecyclingHelper(city) {
        this.lastActiveRecyclingLocations = {};
        this.city = city;
        this.reductionMult = 1 - RecyclingHelper.REDUCTION_AMT;
        this.coverage = Utils.initialize2DArray(city.size, city.size, 0);
    }
    RecyclingHelper.prototype.checkRecalculate = function () {
        if (this.hasRecyclingLocationsChanged()) {
            this.recalculateCoverage();
        }
    };
    RecyclingHelper.prototype.hasRecyclingLocationsChanged = function () {
        var _this = this;
        var newRecyclingLocations = {};
        var isSameAsOld = true;
        this.city.structureCache.getRecycling().forEach(function (building) {
            var k = Utils.toIndexKey(building.row, building.col, _this.city.size);
            if (!_this.lastActiveRecyclingLocations[k]) {
                isSameAsOld = false;
            }
            newRecyclingLocations[k] = 1;
        });
        return !(isSameAsOld && Object.keys(newRecyclingLocations).length === Object.keys(this.lastActiveRecyclingLocations).length);
    };
    RecyclingHelper.prototype.isCovered = function (row, col) {
        return this.coverage[row][col] === 1;
    };
    RecyclingHelper.prototype.recalculateCoverage = function () {
        var _this = this;
        console.log("recalculating recycling coverage");
        Utils.setAll2D(this.coverage, 0);
        Utils.resetObject(this.lastActiveRecyclingLocations);
        var rad = RecyclingHelper.RADIUS;
        this.city.structureCache.getRecycling().forEach(function (building) {
            var k = Utils.toIndexKey(building.row, building.col, _this.city.size);
            _this.lastActiveRecyclingLocations[k] = 1;
            for (var r = building.row - rad; r <= building.row + rad; r++) {
                for (var c = building.col - rad; c <= building.col + rad; c++) {
                    if (Utils.isValidIndex(r, c, _this.city.size)) {
                        _this.coverage[r][c] = 1;
                    }
                }
            }
        });
    };
    RecyclingHelper.RADIUS = 15;
    RecyclingHelper.REDUCTION_AMT = 0.25; // amt to reduce if is zone
    return RecyclingHelper;
}();
/**
 * This metrics should be used to affect city.stats
 * most metric should be a range from 0 - 1
 * AKA STATS
 * These are calculated on-demand based on city, no previous saved values necessary
 * @param city
 * @constructor
 */
var CityMetrics = /** @class */function () {
    function CityMetrics(city) {
        this._commercialSupply = 0;
        this._commercialDemand = 0;
        // MAIN METRICS
        this.income = 100; // can be positive or negative income - amt per second
        // population is actually a saved stat
        this.happiness = 0.5; // improve population retainment
        // SUB METRICS
        // income
        this.commerce = 100; // sales tax
        this.taxes = 100; // property tax
        this.incomeTax = 0; // income tax
        this.importExportTotal = 0;
        this.scenery = 0;
        this.upkeep = 0;
        this.regionBoostIncome = 0; // not income from neighbor cities, but from terrain boost
        this.importsFood = 0;
        this.importsMaterial = 0;
        this.exportsFood = 0;
        this.exportsMaterial = 0;
        this.exportsNatural = 0;
        this.maxExportPerSec = 0; // increase by transit.js facilities
        this.numLeisureBuildings = 0;
        // population
        this.housingMult = 1;
        this.housing = 1500;
        this.jobs = 0.5; // - Percentage of working population has jobs
        this.attractiveness = 0.5; // - percent of total population moving in
        this.loss = 0.5; // - percent of total population leaving
        // happiness
        this.safetyCrime = 1; // - crime safety, higher is more safe
        this.safetyFire = 1; // - fire safety
        this.health = 1; // - affects happiness and attractiveness
        this.environment = 1; // - the longer high, the more happiness increases,
        this.recreation = 0; // - boosts happiness with each building, especially at first,
        this.trafficAvg = 0; // boosts happiness (and maybe productivity)
        this.demandResidential = 0;
        this.demandCommercial = 0;
        this.demandIndustrial = 0;
        this.totalPoliceSafety = 0;
        this.percentOutOfPower = 0; // also out of other resource, technically
        // Helpers for other components
        this.maxCash = 999999999;
        this.numCriminals = 0;
        this.globalEnvironment = 1; // global environment rating, impacts individual pollution tiles
        // STATE
        this.updateVisuals = false;
        this._missingResourceLastCheck = [];
        this._comTileIncomeCache = {};
        this.city = city;
        this.supplyUpkeepHelper = new SupplyUpkeepHelper(city);
        this.recyclingHelper = new RecyclingHelper(city);
    }
    // Temporary metric modifiers
    CityMetrics.prototype.applyMetricModifiers = function (calculate) {
        var _this = this;
        var keyToValueEffect = (_a = {}, _a[METRIC_MODIFIER_TYPES.CRIME] = "totalPoliceSafety", _a[METRIC_MODIFIER_TYPES.ENVIRONMENT] = "totalEnvironment", _a[METRIC_MODIFIER_TYPES.FIRE] = "totalFireSafety", _a[METRIC_MODIFIER_TYPES.HEALTH] = "totalHealthSafety", _a[METRIC_MODIFIER_TYPES.TRAFFIC] = "baseTraffic", _a);
        Object.keys(this.city.stats.metricModifiers).forEach(function (k) {
            _this.city.stats.metricModifiers[k].forEach(function (modifier) {
                calculate[keyToValueEffect[k]] += modifier.percent;
            });
        });
        var _a;
    };
    CityMetrics.prototype.clearOldMetricModifiers = function () {
        var _this = this;
        var elapsed = Utils.getElapsedTime(this.city.game);
        Object.keys(this.city.stats.metricModifiers).forEach(function (k) {
            var modifiers = _this.city.stats.metricModifiers[k];
            for (var i = modifiers.length - 1; i >= 0; i--) {
                modifiers[i].duration -= elapsed;
                if (modifiers[i].duration <= 0) {
                    modifiers.splice(i, 1);
                }
            }
        });
    };
    //
    // Updates
    //
    CityMetrics.multiplyStructureSize = function (baseVal, size, extraSizeMult) {
        if (extraSizeMult === void 0) {
            extraSizeMult = 0;
        }
        if (!baseVal || !size) {
            throw new MissingArgsError();
        }
        var value = baseVal;
        for (var i = 1; i < size; i++) {
            value *= Balance.STRUCTURE_SIZE_EFFECT_EXP_MULT + extraSizeMult;
        }
        return Math.round(value) * size;
    };
    CityMetrics.prototype.getCommercialTileJobsIncomeWithCache = function (size) {
        if (!this._comTileIncomeCache.hasOwnProperty(size)) {
            this._comTileIncomeCache[size] = CityMetrics.getCommercialTileJobsIncome(size, this.city);
        }
        return this._comTileIncomeCache[size];
    };
    CityMetrics.prototype.clearCommercialTileJobsIncomeWithCache = function () {
        this._comTileIncomeCache = {};
    };
    CityMetrics.getCommercialTileIncome = function (size) {
        // income per second
        return CityMetrics.multiplyStructureSize(Balance.INCOME_PER_COMMERCIAL, size);
    };
    CityMetrics.getCommercialTileIncomeUpgraded = function (size) {
        // income per second
        return Balance.INCOME_PER_COMMERCIAL_UPGRADED * size;
    };
    CityMetrics.getCommercialTileJobsIncome = function (size, city) {
        if (city.structureCache.getUniversities().length > 0) {
            return CityMetrics.getIndustrialTileJobs(size) * Balance.PERCENT_COM_JOBS_VS_INDUSTRIAL_EDUCATED;
        }
        return 0;
    };
    CityMetrics.getResidentialTileMaxPop = function (size, city) {
        if (city) {
            return Math.round(CityMetrics.multiplyStructureSize(Balance.MAX_POP_PER_RESIDENTIAL, size, 0.4) * city.metrics.housingMult);
        }
        // residential increases very much when its a multi zone building
        return CityMetrics.multiplyStructureSize(Balance.MAX_POP_PER_RESIDENTIAL, size, 0.4);
    };
    CityMetrics.getResidentialTileMaxPopUpgraded = function (size, city) {
        if (city) {
            return Math.round(Balance.MAX_POP_PER_UPGRADED_RESIDENTIAL * size * city.metrics.housingMult);
        }
        // residential increases very much when its a multi zone building
        return Balance.MAX_POP_PER_UPGRADED_RESIDENTIAL * size;
    };
    CityMetrics.getIndustrialTileJobs = function (size, city) {
        var base = CityMetrics.multiplyStructureSize(Balance.JOBS_PER_INDUSTRIAL, size);
        if (city && city.isPolicyActive(Policy.CODES.REMOTE_WORK)) {
            return Math.round(base + base * Policy.CONSTS.REMOTE_WORK_INCREASE_JOBS_PERCENT);
        }
        return base;
    };
    CityMetrics.getIndustrialTileJobsUpgraded = function (size, city) {
        var base = Balance.JOBS_PER_INDUSTRIAL_UPGRADED * size;
        if (city && city.isPolicyActive(Policy.CODES.REMOTE_WORK)) {
            return Math.round(base + base * Policy.CONSTS.REMOTE_WORK_INCREASE_JOBS_PERCENT);
        }
        return base;
    };
    CityMetrics.prototype.getFiniteSandboxLevel = function () {
        var SANDBOX_MONEY_MODE_LV_SCALE = 14;
        var percentBuildZoneFull = Math.min(1, this.city.grids.zoneGrid.getTileCountAnyTypeWithCache() / 1626);
        var delta = 100 - SANDBOX_MONEY_MODE_LV_SCALE;
        return SANDBOX_MONEY_MODE_LV_SCALE + Math.round(delta * percentBuildZoneFull);
    };
    /**
     * Apply potentially positive or negative side effects of the current metrics
     * Interval is 1 second, shoud be called every second
     */
    CityMetrics.prototype.updateMetrics = function (applySideEffects) {
        if (applySideEffects === void 0) {
            applySideEffects = false;
        }
        if (!this.city.trafficDensity.connectedness) {
            return; // cannot update metrics when traffic is not ready
        }
        if (Global.DISABLE_METRIC_SIDE_EFFECTS) {
            applySideEffects = false;
        }
        PolicyEffects.preUpdateEffects(this.city);
        this.supplyUpkeepHelper.checkRecalculate();
        this.recyclingHelper.checkRecalculate();
        //
        // Calculations
        //
        var calculate = {
            currentPopulation: this.city.stats.population || 1,
            commerceTiles: 0,
            totalPoliceSafety: 0,
            totalFireSafety: 0,
            totalHealthSafety: 0,
            totalRecreation: 0,
            totalEnvironment: 0,
            baseTraffic: 0,
            maxPopulation: 1,
            maxCash: Global.START_MAX_CASH,
            commerce: 0,
            taxes: 0,
            incomeTax: 0,
            upkeep: Balance.BASELINE_UPKEEP,
            importsFood: 0,
            importsMaterial: 0,
            exportsFood: 0,
            exportsMaterial: 0,
            exportsNatural: 0,
            maxExportPerSec: 0,
            totalJobs: 0,
            jobsSupplied: 0,
            loss: 0,
            attractiveness: 0
        };
        var taxes = EconomyHelper.getTaxLevels(this.city);
        // current imports, can be reduced by special buildings
        var _lv = this.cityLevelForMetrics();
        var _pop = calculate.currentPopulation;
        calculate.importsFood = _pop * Balance.getFoodReqForPop(_pop);
        // scaling food mult w/ level
        calculate.importsFood *= 1 + Balance.FOOD_REQ_MULT_INCREASE_PER_LEVEL * _lv;
        calculate.importsMaterial = _pop * Balance.getMaterialsReqForPop(_pop);
        var attractiveHousingLoss = 0;
        var _hasTownHall = false;
        var specialBuildings = [];
        this._missingResourceLastCheck.length = 0;
        var hasDrones = this.city.structureCache.hasDroneDepot();
        var upkeepMult = 1 + _pop * 0.001 * Balance.UPKEEP_MULTIPLIER_INCREASE_PER_1000_POP;
        var upkeepLvMult = Math.min(100, _lv) * Balance.UPKEEP_INCREASE_PER_LV;
        var upkeepEarlyGameReduce = Balance.EARLY_GAME_UPKEEP_REDUCTION * (1 - Math.min(1, _pop / Balance.EARLY_GAME_UPKEEP_REDUCTION_END_POP));
        var upkeepPerTile = Balance.UPKEEP_PER_TILE * (upkeepMult + upkeepLvMult);
        upkeepPerTile -= upkeepPerTile * upkeepEarlyGameReduce;
        // Upkeep fix (pt1)
        if (this.city.stats.internalVersion >= 1) {
            // decrease upkeep per tile since we are counting zone children now overall
            upkeepPerTile = upkeepPerTile / Balance.UPKEEP_DIVISOR_FIX;
            // additional reduction for post-late game
            var usePopForReduce = Math.max(0, _pop - Balance.UPKEEP_REDUCE_TO_HIGH_POP_MIN_AMT);
            var amtReduce = Balance.UPKEEP_REDUCE_TO_HIGH_POP * Math.min(1, usePopForReduce / Balance.UPKEEP_REDUCE_TO_HIGH_POP_AMT);
            upkeepPerTile = upkeepPerTile * (1 - amtReduce);
        }
        var salesMultiplier = 1 - Math.min(1, _pop / Balance.EARLY_GAME_SALES_BOOST_END_POP);
        var salesBoost = 1 + Balance.EARLY_GAME_SALES_BOOST * salesMultiplier;
        var pollutionGrid = this.city.grids.pollutionGrid;
        var hasResourceSuppliedAny = false;
        var isOpenTopStructure = false;
        var totalZoneTiles = 0;
        var unpoweredZoneTiles = 0;
        this.clearCommercialTileJobsIncomeWithCache();
        //
        // For each tile in zone grid
        //
        // avoid slower forEachTile and do manually here instead
        var _tracked = this.city.grids.zoneGrid.getTrackedTilesOrError();
        var tile;
        var _keys = Object.keys(_tracked);
        for (var _k = 0; _k < _keys.length; _k++) {
            tile = _tracked[_keys[_k]];
            if (!tile) continue;
            var isTownHall = tile.isWithBuildingTile && tile.building && tile.building.sheet === "townhall";
            _hasTownHall = isTownHall || _hasTownHall;
            var effectType = null;
            if (tile.building) {
                effectType = STRUCTURE_EFFECT_TYPES[tile.building.sheet];
            }
            var isResourceSuplied = tile.isWithBuildingTile && (tile._master || tile._cacheResourceStatus.hasAll);
            var isZoneTile = tile.type === Tile.Type.Commercial || tile.type === Tile.Type.Industrial || tile.type === Tile.Type.Residential;
            if (isZoneTile) {
                totalZoneTiles += 1;
                if (!isResourceSuplied) {
                    unpoweredZoneTiles += 1;
                }
            }
            if (!isResourceSuplied) {
                this._missingResourceLastCheck.push([tile.row, tile.col]);
            }
            //
            // Side effects from structures
            // - only consider masters
            // - only consider completed
            // - do not consider "resource" generators
            //
            if (tile.isWithBuildingTile && tile._completed && !tile._master && !isTownHall && effectType !== CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE && isResourceSuplied) {
                var size = tile.getGroupSize();
                if (isZoneTile) {
                    calculate.taxes += Balance.PROPERTY_TAX_PER_TILE;
                }
                hasResourceSuppliedAny = true;
                isOpenTopStructure = tile.building && STRUCTURES_ONLY_BULLDOZE_BY_SHEET[tile.building.sheet];
                // Apply supply co coverage reduction
                var tileUpkeep = upkeepPerTile;
                if (this.supplyUpkeepHelper.isCovered(tile.row, tile.col)) {
                    tileUpkeep = tileUpkeep * this.supplyUpkeepHelper.reductionMult;
                }
                if (tile.building && tile.building.sheet === STRUCTURE_SHEETS.SUPPLY) {
                    tileUpkeep = 0;
                }
                if (!isOpenTopStructure) {
                    // open top structures don't incur upkeep fees
                    calculate.upkeep += tileUpkeep;
                    // upkeep fix (pt2)
                    if (this.city.stats.internalVersion >= 1) {
                        if ((tile instanceof ResidentialTile || tile instanceof CommercialTile || tile instanceof IndustrialTile) && tile._children && tile._children.length) {
                            calculate.upkeep += tileUpkeep * tile._children.length;
                        }
                    }
                    calculate.importsMaterial += Balance.MATERIALS_REQ_PER_ZONE;
                }
                var isUpgraded = tile.zoneLevel === 2;
                if (tile instanceof ResidentialTile) {
                    if (isUpgraded) {
                        calculate.maxPopulation += CityMetrics.getResidentialTileMaxPopUpgraded(size, this.city);
                    } else {
                        calculate.maxPopulation += CityMetrics.getResidentialTileMaxPop(size, this.city);
                    }
                    var pollution = pollutionGrid.getPollutionAt(tile.row, tile.col);
                    Utils.assert(pollution <= 1 && pollution >= 0);
                    attractiveHousingLoss += Balance.ATTRACTIVE_LOSS_FROM_POLLUTION_HOUSING * pollution;
                    this.addAttractivenessChildren(calculate, tile, Balance.ATTRACT_POP_PER_RESIDENTIAL);
                } else if (tile instanceof CommercialTile) {
                    if (isUpgraded) {
                        calculate.commerce += CityMetrics.getCommercialTileIncomeUpgraded(size);
                    } else {
                        calculate.commerce += CityMetrics.getCommercialTileIncome(size);
                    }
                    // educated jobs
                    calculate.totalJobs += this.getCommercialTileJobsIncomeWithCache(size);
                    calculate.commerceTiles += 1;
                    this.addAttractivenessChildren(calculate, tile, Balance.ATTRACT_POP_PER_COMMERCIAL);
                } else if (tile instanceof IndustrialTile) {
                    if (isUpgraded) {
                        calculate.totalJobs += CityMetrics.getIndustrialTileJobsUpgraded(size, this.city);
                    } else {
                        calculate.totalJobs += CityMetrics.getIndustrialTileJobs(size, this.city);
                    }
                    this.addAttractivenessChildren(calculate, tile, Balance.ATTRACT_POP_PER_INDUSTRIAL);
                } else if (tile instanceof StructureTile && tile.building) {
                    specialBuildings.push(tile);
                }
            }
        }
        PolicyEffects.preCalculate(this.city, calculate);
        var percentUnpowered = 0;
        if (unpoweredZoneTiles && totalZoneTiles) {
            percentUnpowered = Utils.clamp(unpoweredZoneTiles / totalZoneTiles, 0, 1);
        }
        calculate.commerce *= salesBoost;
        var desiredJobs = (_pop - 1) * Balance.WORKING_POP_RATIO;
        if (desiredJobs === 0) {
            calculate.jobsSupplied = 1;
        } else {
            calculate.jobsSupplied = _pop ? Math.min(1, calculate.totalJobs / desiredJobs) : 1;
        }
        // additional economy
        calculate.incomeTax = calculate.jobsSupplied * _pop * Balance.INCOME_PER_WORKING_POP_TAX;
        calculate.incomeTax = CityEducation.applyEducationIncomeTaxBoost(calculate.incomeTax, _pop, this.city.structureCache.getSchools().length, this.city.structureCache.getUniversities().length);
        if (hasDrones) {
            calculate.incomeTax *= Balance.DRONE_SALARY_BOOST;
        }
        calculate.incomeTax *= Difficulty.getIncomeTaxMult(this.city);
        // reduce attractiveness due to pollution
        var originalAttractiveness = calculate.attractiveness;
        calculate.attractiveness -= attractiveHousingLoss;
        // Attractiveness
        //
        // Apply global modifiers by temporary state
        this.applyMetricModifiers(calculate);
        this.clearOldMetricModifiers();
        //
        // Post processing
        //
        // Loss
        // contributed to by housing, employment, and happiness
        var lossFromInsufficientHousing;
        if (calculate.maxPopulation < _pop) {
            lossFromInsufficientHousing = Utils.clamp(Balance.POP_LOSS_UNSUFFICIENT_HOUSING * _pop, Balance.POP_LOSS_UNSUFFICIENT_HOUSING_MIN, Balance.POP_LOSS_UNSUFFICIENT_HOUSING_MAX);
            calculate.loss += lossFromInsufficientHousing;
        }
        var missingJobsPop = 0;
        var lossFromInsufficientJobs;
        if (calculate.jobsSupplied < 1) {
            missingJobsPop = (1 - calculate.jobsSupplied) * _pop;
            lossFromInsufficientJobs = Utils.clamp(Balance.POP_LOSS_UNSUFFICIENT_JOBS * missingJobsPop, Balance.POP_LOSS_UNSUFFICIENT_JOBS_MIN, Balance.POP_LOSS_UNSUFFICIENT_JOBS_MAX);
            calculate.loss += lossFromInsufficientJobs;
        }
        // Crime
        var numCriminals = _pop * Balance.CRIME_PERCENT_POPULATION + missingJobsPop * Balance.CRIME_PERCENT_NO_JOBS;
        this.numCriminals = numCriminals;
        Utils.assert(!isNaN(numCriminals));
        // These are individual values that special buildings have to try and fill out
        var fireRequiredPerCitizen = Balance.FIRESTATION_REQUIRED_EVERY_X_CITIZENS;
        if (this.city.isPolicyActive(Policy.CODES.FIRE_SAFETY)) {
            fireRequiredPerCitizen *= Policy.CONSTS.FIRE_IMPROVEMENT_PER_CITIZEN;
        }
        var _desiredFireSafety = Difficulty.getFireMult(this.city) * (_pop / fireRequiredPerCitizen) || 1;
        var _desiredHealthSafety = Difficulty.getHealthMult(this.city) * (_pop / Balance.HOSPITALS_REQUIRED_EVERY_X_CITIZENS) || 1;
        var _desiredRecreation = Difficulty.getRecreationReqMult(this.city) * (_pop / Balance.RECREATION_REQUIRED_EVERY_X_CITIZENS) || 1;
        var varianceRecTracker = {};
        this.numLeisureBuildings = 0;
        var landmarkPolicyActive = this.city.isPolicyActive(Policy.CODES.LANDMARK_TOURS);
        var outdoorsPolicyActive = this.city.isPolicyActive(Policy.CODES.GREAT_OUTDOORS);
        // Apply special building effects
        for (var _i = 0; _i < specialBuildings.length; _i++) {
            var t = specialBuildings[_i];
            var structureDef = STRUCTURE_BY_SHEET[t.building.sheet];
            var multiplier = 1;
            if (STRUCTURE_EFFECT_TYPES[t.building.sheet] === CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION && !varianceRecTracker[t.building.sheet]) {
                multiplier = Balance.VARIANCE_BOOST; // variance boost
            }
            structureDef.metricEffect.applyFn(calculate, t, multiplier);
            varianceRecTracker[t.building.sheet] = 1;
            if (structureDef.type === "landmark" && landmarkPolicyActive) {
                calculate.attractiveness += Policy.CONSTS.LANDMARK_ATTR;
            } else if (structureDef.tab === STRUCTURE_TAB_IDS.RECREATION && outdoorsPolicyActive) {
                calculate.totalRecreation += Policy.CONSTS.OUTDOOR_REC_INCREASE;
            }
            if (STRUCTURE_BY_ID[t.building.id].tab === STRUCTURE_TAB_IDS.ENTERTAINMENT || STRUCTURE_BY_ID[t.building.id].tab === STRUCTURE_TAB_IDS.RECREATION || STRUCTURE_BY_ID[t.building.id].tab === STRUCTURE_TAB_IDS.COSMETIC) {
                this.numLeisureBuildings += 1;
            }
        }
        //
        // Update values
        //
        this.housing = calculate.maxPopulation;
        this.jobs = calculate.jobsSupplied;
        this.totalPoliceSafety = calculate.totalPoliceSafety;
        // HAPPINESS BY SPECIAL BUILDINGS
        this.updateSafetyCrime();
        this.safetyFire = roundFinalVal(calculate.totalFireSafety, _desiredFireSafety); // - fire safety
        if (!this.city.fireEmergencyManager.hasUnlockedFire()) {
            this.safetyFire = 1;
        } else {
            this.safetyFire += CityMetrics.getDefaultMetricLevelDampenToZero(Balance.FIRE_ENABLE_AND_UNLOCK_FIRE_STATION_LV, _lv);
            this.safetyFire = Math.min(1, this.safetyFire);
        }
        this.health = roundFinalVal(calculate.totalHealthSafety, _desiredHealthSafety); // - affects happiness and attractiveness
        if (this.city.stats.level < UNLOCK_HOSPITAL_LV) {
            this.health = 1;
        } else {
            this.health += CityMetrics.getDefaultMetricLevelDampenToZero(UNLOCK_HOSPITAL_LV, _lv);
            this.health = Math.min(1, this.health);
        }
        this.recreation = roundFinalVal(calculate.totalRecreation, _desiredRecreation); // - boosts happiness with each building, especially at first,
        // Environment from pollution
        var totalRequiredEnvironment = Balance.ENV_REQUIRED_PER_CITIZEN * _pop;
        this.globalEnvironment = roundFinalVal(calculate.totalEnvironment / totalRequiredEnvironment, 1); // - the longer high, the more happiness increases,
        if (this.city.structureCache && this.city.structureCache.getBusDepots().length > 0) {
            var percentReduce = this.city.busStopLayer.numBusStops() / Balance.NUM_BUS_STOP_MAX_ENV_REDUCE;
            this.globalEnvironment += percentReduce * Balance.BUS_ENV_REDUCTION;
        }
        this.globalEnvironment = Utils.clamp(this.globalEnvironment, 0, 1);
        // catch up if needed, since pollution grid is one step behind because it relies on totalEnvironment (from trees, etc)
        if (pollutionGrid._lastUsedGlobalEnvironment !== this.globalEnvironment) {
            pollutionGrid.sync();
        }
        this.environment = 1 - pollutionGrid.getAveragePollution();
        if (this.city.isPolicyActive(Policy.CODES.CYCLING_INCENTIVE)) {
            this.environment = Utils.clamp(this.environment + Policy.CONSTS.CYCLING_ENVIRONMENT_IMPROVE, 0, 1);
        }
        // extra protection
        if (isNaN(this.environment)) {
            this.environment = 1;
        }
        // Traffic avg of density and connectedness (access), plus base
        var traffic = this.city.trafficDensity;
        var trafficMetricAvg = Utils.avg([1 - traffic.averageDensity, traffic.avgAccess()]) + calculate.baseTraffic;
        trafficMetricAvg = Utils.clamp(trafficMetricAvg, 0, 1);
        // store here so that it's visible on UI
        this.trafficAvg = trafficMetricAvg;
        // - Final happiness
        this.happinessRefresh();
        // Loss from happiness
        var unhappyPop = (1 - this.happiness) * _pop * Balance.LOSS_PERCENT_UNHAPPY;
        if (_pop < Balance.EARLY_GAME_BOOST_MAX_POP) {
            // Early game boost - reduce unhappy loss
            unhappyPop *= _pop / Balance.EARLY_GAME_BOOST_MAX_POP;
        }
        calculate.loss += unhappyPop;
        calculate.attractiveness *= RegionBoosts.getRegionAttractivenessBoost(this.city);
        // POPULATION change
        var numHomeless = Math.max(0, this.city.stats.population - calculate.maxPopulation);
        var wantToAttract = calculate.attractiveness;
        var wantToLeave = calculate.loss;
        if (numHomeless > 0) {
            wantToLeave = Math.max(wantToLeave + numHomeless, wantToAttract + numHomeless);
        }
        var totalWantActionPop = Math.max(wantToAttract + wantToLeave, 1);
        var ratioAttract = wantToAttract / (totalWantActionPop || 1);
        // Dampen speed of change
        var maxPopChange = Math.max(Balance.MAX_POP_CHANGE_PER_TICK, Balance.MAX_POP_CHANGE_PERCENT_PER_TICK * _pop);
        if (ratioAttract < 0.05) {
            // losing population, change is much slower
            maxPopChange = Math.max(Balance.MAX_POP_CHANGE_PER_TICK, Balance.MAX_POP_CHANGE_LOSS_PERCENT_PER_TICK);
        }
        var numPopChange = Math.min(totalWantActionPop, maxPopChange);
        if (ratioAttract >= 0.5) {
            // Don't use 0.25 at first, because otherwise pop of 1 never goes up
            if (_pop < 20) {
                numPopChange = Math.min(_pop * 2, numPopChange);
            } else if (_pop < 50) {
                numPopChange = Math.min(_pop * 0.5, numPopChange);
            } else {
                // grow by 25% at most per tick
                numPopChange = Math.min(_pop * Balance.MAX_POP_CHANGE_PERCENT_PER_TICK, numPopChange);
            }
        } else {
            if (_pop <= 30) {
                // only decrease by 1 if under 10
                numPopChange = Math.min(1, numPopChange);
            } else {
                // if changing 10%, remember that sometimes rounding cases number to freeze
                // lose at most 10% or 50 per tick
                numPopChange = Math.min(_pop * 0.10, numPopChange);
            }
        }
        var numAttract = Math.round(ratioAttract * numPopChange);
        var numLeave = Math.round((1 - ratioAttract) * numPopChange);
        // tie breaker, helps with early game
        if (_pop <= Balance.EARLY_GAME_BOOST_MAX_POP) {
            var attractBoost = Balance.EARLY_GAME_BOOST_NUM_ATTRACT * (1 - _pop / Balance.EARLY_GAME_BOOST_MAX_POP);
            numAttract += Math.round(attractBoost);
        }
        // Prevent flapping from early game boost
        if (numLeave > numAttract && numLeave - numAttract <= 2 && _pop - Balance.EARLY_GAME_BOOST_MAX_POP < 2 && _pop - Balance.EARLY_GAME_BOOST_MAX_POP > 0) {
            numLeave = numAttract;
        }
        this.attractiveness = numAttract; // - # of citizens being attraced per second
        this.loss = numLeave; // - # of citizens leaving per second
        // special case for intro city level 2
        // Reduce amount that wants to enter
        if (_lv === 2) {
            this.attractiveness *= Balance.FIXED_ATTRACTIVENESS_LV_2_MULT_DAMPEN;
            this.attractiveness = Math.round(this.attractiveness);
        }
        //
        // for debugging
        // override some stats here to see effect on city
        //
        if (window['statsOverride']) {
            Utils.extend(this, window['statsOverride'], true);
        }
        // INCOME
        this.taxes = Math.round(calculate.taxes * Balance.OVERALL_SALE_TAX_MULTIPLIER * taxes.property * Difficulty.getPropertyTaxMult(this.city));
        if (!Global.IS_DELUXE && this.city.stats.level >= TimedMoney.TAKE_MONEY_AT_LV) {
            var freePendingPropertyTaxAmt = this.taxes * TimedMoney.MONEY_TAKE_PERCENT;
            this.taxes -= freePendingPropertyTaxAmt;
            this.city.timedMoney.addPendingCash(freePendingPropertyTaxAmt);
            this.taxes = Math.round(this.taxes);
        }
        this.incomeTax = Math.round(calculate.incomeTax * taxes.income);
        this.upkeep = Math.round(Math.max(0, calculate.upkeep));
        if (!Global.IS_DELUXE && this.city.stats.level >= TimedMoney.TAKE_MONEY_AT_LV) {
            var freePendingIncomeTaxAmt = this.incomeTax * TimedMoney.MONEY_TAKE_PERCENT;
            this.incomeTax -= freePendingIncomeTaxAmt;
            this.city.timedMoney.addPendingCash(freePendingIncomeTaxAmt);
            this.incomeTax = Math.round(this.incomeTax);
        }
        if (this.city.isPolicyActive(Policy.CODES.SHIPPING_INCREASE_1)) {
            calculate.maxExportPerSec = Math.round(calculate.maxExportPerSec * (1 + Policy.CONSTS.SHIPPING_1_INCREASE));
        }
        if (this.city.isPolicyActive(Policy.CODES.SHIPPING_INCREASE_2)) {
            calculate.maxExportPerSec = Math.round(calculate.maxExportPerSec * (1 + Policy.CONSTS.SHIPPING_2_INCREASE));
        }
        // exports - reduce export cap on each type
        this.maxExportPerSec = calculate.maxExportPerSec;
        var exportCapacity = calculate.maxExportPerSec;
        // food exports region boost
        if (this.city.stats.isNeighbor && this.city.stats.regionType === Region.REGION_TYPES.FARMLAND) {
            calculate.exportsFood *= RegionBoosts.FARM_FOOD_MULTIPLIER;
            calculate.exportsFood = Math.round(calculate.exportsFood);
        }
        var exportFoodAfterSelfConsume = Math.max(0, calculate.exportsFood - calculate.importsFood);
        var importAfterSelfConsume = Math.max(0, calculate.importsFood - calculate.exportsFood);
        if (importAfterSelfConsume) {
            // dampen effect of large unpowered city
            importAfterSelfConsume *= 1 - percentUnpowered;
        }
        this.exportsFood = Math.round(Math.min(exportCapacity, exportFoodAfterSelfConsume));
        this.importsFood = Math.round(importAfterSelfConsume);
        var exportMaterialAfterSelfConsume = Math.max(0, calculate.exportsMaterial - calculate.importsMaterial);
        var importMaterialSelfConsume = Math.max(0, calculate.importsMaterial - calculate.exportsMaterial);
        if (importMaterialSelfConsume) {
            importMaterialSelfConsume *= 1 - percentUnpowered;
        }
        this.exportsMaterial = Math.round(Math.min(exportCapacity, Math.round(exportMaterialAfterSelfConsume)));
        this.importsMaterial = Math.round(importMaterialSelfConsume);
        this.exportsNatural = Math.min(exportCapacity, Math.round(calculate.exportsNatural));
        // additional factors on income, mostly due to population
        var maxSpendFromCitizens = (_pop - 1) * Balance.SPEND_PER_CITIZEN; // * maxSpendBoost;
        // max spending loss from happiness
        var guaranteedMaxSpend = maxSpendFromCitizens * (1 - Balance.SPENDING_VARIABLE_ON_HAPPINESS);
        var variableMaxSpend = maxSpendFromCitizens * Balance.SPENDING_VARIABLE_ON_HAPPINESS * this.happiness;
        maxSpendFromCitizens = guaranteedMaxSpend + variableMaxSpend;
        // clamp income based on current calculation
        var maxAvailableSales = calculate.commerce;
        this._commercialSupply = maxAvailableSales;
        this._commercialDemand = maxSpendFromCitizens;
        this.commerce = Math.round(Math.min(maxSpendFromCitizens, maxAvailableSales) * Utils.reduceDistFromOne(taxes.sales, Balance.SALES_TAX_SETTING_INCOME_EFFECT_REDUCTION));
        // SPECIAL CASE: also apply for statue
        if (this.city.structureCache.getStatueCourage().length) {
            this.commerce *= _COURAGE_STATUE_INCOME_BOOST;
        }
        this.commerce *= Difficulty.getSalesTaxMult(this.city);
        if (!Global.IS_DELUXE && this.city.stats.level >= TimedMoney.TAKE_MONEY_AT_LV) {
            var freePendingAmt = this.commerce * TimedMoney.MONEY_TAKE_PERCENT;
            this.commerce -= freePendingAmt;
            this.city.timedMoney.addPendingCash(freePendingAmt);
        }
        this.commerce = Math.round(this.commerce);
        // Dampen income for higher levels
        if (this.city.stats.level >= Balance.INCOME_REDUCTION_START_LV) {
            var percentDampenedOfFull = (_lv + 1 - Balance.INCOME_REDUCTION_START_LV) / (Global.MAX_LEVEL - Balance.INCOME_REDUCTION_START_LV);
            var dampeningIncome = percentDampenedOfFull * Balance.INCOME_REDUCTION_MAX;
            var incomeMultiplier = Utils.clamp(1 - dampeningIncome, 0, 1);
            this.commerce = Math.round(this.commerce * incomeMultiplier);
            this.taxes = Math.round(this.taxes * incomeMultiplier);
            this.incomeTax = Math.round(this.incomeTax * incomeMultiplier);
        }
        // total population desired
        var desiredPopulation = Math.round(_pop + (this.attractiveness - this.loss));
        // - Final Income:
        // INCORRECT income - keep for backwards compat
        var totalImportExport = Math.round(this.exportsMaterial - this.importsFood + this.exportsMaterial - this.importsMaterial + this.exportsNatural);
        // CORRECT income - use going forward
        if (this.city.stats.internalVersion >= 1) {
            totalImportExport = Math.round(this.exportsFood - this.importsFood + this.exportsMaterial - this.importsMaterial + this.exportsNatural);
        }
        this.regionBoostIncome = RegionBoosts.getRegionIncomeBoost(this.city);
        RegionBoosts.genericApplyRegionBoost(this.city);
        if (this.city.isPolicyActive(Policy.CODES.SCENIC_CITY)) {
            this.scenery = (this.city.grids.waterTerrainGrid.children.length + this.city.grids.tallTerrainGrid.children.length + this.city.structureCache.getTrees().length) * Policy.CONSTS.SCENIC_CITY_PER_TILE;
        } else {
            this.scenery = 0;
        }
        this.income = Math.round(this.commerce + this.taxes + this.incomeTax - this.upkeep + totalImportExport + this.regionBoostIncome + this.scenery);
        this.importExportTotal = totalImportExport;
        // Other
        this.maxCash = calculate.maxCash;
        if (this.city.isInfiniteMoney()) {
            this.maxCash = Global.SANDBOX_CASH + 1;
        }
        // Update demand
        // (shows 100% fill at double current value)
        var popDivisor = Math.max(calculate.maxPopulation, 1);
        // weird old way of calculating demand pop - using 50 threshold from pop change above
        if (_pop <= 50) {
            this.demandResidential = Utils.clamp(desiredPopulation / popDivisor - 1, 0, 1);
        } else {
            // better way
            var dampen = 0.9; // just so it's not 100%
            var desiredChange = (desiredPopulation - popDivisor) * dampen;
            var changeOutOfMaxChange = desiredChange / Math.max(1, maxPopChange);
            this.demandResidential = Utils.clamp(changeOutOfMaxChange, 0, 1);
        }
        // Show more residential demand when we are maxed
        this.demandResidential *= Utils.clamp(_pop / calculate.maxPopulation, 0, 1);
        var spendDemandRatio = maxSpendFromCitizens / Math.max(1, maxAvailableSales);
        var internalDemandCommercial = Math.max(spendDemandRatio - 1, 0);
        this.demandCommercial = Utils.clamp(internalDemandCommercial, 0, 1);
        var demandForJobs = desiredJobs;
        var demandDivisor = calculate.totalJobs;
        if (!demandDivisor) {
            demandForJobs += 1;
            demandDivisor += 1;
        }
        var jobsDemandRatio = demandForJobs / demandDivisor;
        var internalDemandIndustrial = Math.max(jobsDemandRatio - 1, 0);
        this.demandIndustrial = Utils.clamp(internalDemandIndustrial, 0, 1);
        // Only apply external demand at very low levels, to help player decide what to build
        if (_lv <= CityMetrics.ARTIFICIAL_DEMAND_MAX_LV) {
            // If no internal demand, use external demand instead of internal
            if (!this.demandResidential && !this.demandCommercial && !this.demandIndustrial) {
                var externalMaxPopDivisor = Balance.ATTRACT_POP_PER_INDUSTRIAL; // the larger of com vs ind external motivator
                var externalDemandCommercial = Balance.ATTRACT_POP_PER_COMMERCIAL / externalMaxPopDivisor * Global.EXTERNAL_DEMAND_BASE;
                var externalDemandIndustrial = Balance.ATTRACT_POP_PER_INDUSTRIAL / externalMaxPopDivisor * Global.EXTERNAL_DEMAND_BASE;
                var totalComIndDemand = spendDemandRatio + jobsDemandRatio;
                var weightCom = spendDemandRatio / totalComIndDemand;
                var weightInd = jobsDemandRatio / totalComIndDemand;
                this.demandCommercial = Utils.clamp(weightCom * externalDemandCommercial, 0, 0.2);
                this.demandIndustrial = Utils.clamp(weightInd * externalDemandIndustrial, 0, 0.2);
            }
            // set min residential at 0.1 if all else is 0 and we are capped by capacity
            if (this.demandResidential < 0.03 && this.demandResidential > 0 && this.demandCommercial <= 0 && this.demandIndustrial <= 0 && desiredPopulation >= calculate.maxPopulation) {
                this.demandResidential = 0.03;
            }
        }
        // Force all to be 0 if nothing is powered (start of game)
        if (!hasResourceSuppliedAny) {
            this.demandResidential = 0;
            this.demandCommercial = 0;
            this.demandIndustrial = 0;
        }
        this.percentOutOfPower = percentUnpowered;
        // Special case - happiness is less if town hall doesn't exist
        if (!_hasTownHall) {
            this.happiness -= CityMetrics.NO_TOWNHALL_HAPP_REDUCE;
        }
        //
        // Final catch-alls
        //
        if (isNaN(this.city.stats.population)) {
            this.city.stats.population = 1;
        }
        if (this.happiness < 0) {
            this.happiness = 0;
        }
        PolicyEffects.postUpdateEffects(this.city);
        //
        // SYNC UI
        //
        if (this.updateVisuals) {
            this.syncAllUIStats(true);
        }
        //
        // APPLY EFFECTS
        //
        if (applySideEffects) {
            // Apply Income
            this.addCash(this.income + this.city.regionExtraIncome);
            var maxPopulation = Math.max(this.city.stats.population, calculate.maxPopulation);
            this.city.stats.population = Utils.clamp(desiredPopulation, 1, maxPopulation);
            // again, catch-all
            if (isNaN(this.city.stats.population)) {
                this.city.stats.population = 1;
            }
            // check unlocks and show msg right away
            if (this.city.cityLevel.specialUnlocks) {
                this.city.cityLevel.specialUnlocks.checkUnlocksAndMsgs();
            }
            this.city.gameplayUI.checkShowSpecialUnlockMsg();
        }
        this._lastCalculation = calculate;
        // debug log
        if (Global.DEBUG_METRICS) {
            console.log("======METRIC CALULCATION\"======");
            console.log("upkeepMult", upkeepMult);
            console.log("upkeepLvMult", upkeepLvMult);
            console.log("upkeepPerTile", upkeepPerTile);
            console.log("early game boosts:::::");
            console.log("upkeepEarlyGameReduce, higher means upkeep costs less", upkeepEarlyGameReduce);
            //console.log("maxSpendBoost",maxSpendBoost);
            console.log("salesBoost", salesBoost);
            console.log("this.attractiveness", this.attractiveness);
            console.log("attractiveness", calculate.attractiveness);
            console.log("Attractiveness before subtraction", originalAttractiveness);
            console.log("Attractiveness housing loss", attractiveHousingLoss);
            console.log("Loss", calculate.loss);
            console.log("lossFromInsufficientHousing", lossFromInsufficientHousing);
            console.log("lossFromInsufficientJobs", lossFromInsufficientJobs);
        }
        function roundFinalVal(val, divisor) {
            return Math.min(1, Utils.numToFixed(Math.max(0, val) / divisor, 2));
        }
    };
    CityMetrics.prototype.happinessRefresh = function () {
        this.happiness = CityMetrics._getHappinessAverageMetrics(this.city.stats.level, [this.trafficAvg, this.safetyCrime, this.safetyFire, this.health, this.environment, this.recreation]);
        this.happiness = CityMetrics._getHappinessAfterTax(this.happiness, EconomyHelper.getTaxSatisfaction(this.city));
        this.happiness = CityMetrics._getHappinessAfterMansion(this.happiness, this.city);
        if (this.city.stats.isNeighbor && this.city.stats.regionType == Region.REGION_TYPES.ISLAND) {
            this.happiness += RegionBoosts.ISLAND_HAPPINESS_BOOST;
            this.happiness = Math.min(1, this.happiness);
        }
    };
    CityMetrics.prototype.getIncome = function () {
        return this.income + this.city.regionExtraIncome;
    };
    CityMetrics.prototype.cityLevelForMetrics = function () {
        var _lv = this.city.stats.level;
        if (this.city.isSandbox && !this.city.isInfiniteMoney()) {
            _lv = this.getFiniteSandboxLevel();
        }
        return _lv;
    };
    CityMetrics.prototype.updateSafetyCrime = function () {
        var _lv = this.cityLevelForMetrics();
        this.safetyCrime = 1 - this.city.grids.crimeGrid.getTotalCrimeRatio(); // - crime safety
        if (!this.city.crime.hasUnlockedCrime()) {
            this.safetyCrime = 1;
        } else {
            this.safetyCrime += CityMetrics.getDefaultMetricLevelDampenToZero(Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV, _lv);
            this.safetyCrime = Math.min(1, this.safetyCrime);
        }
    };
    CityMetrics._getHappinessAverageMetrics = function (cityLevel, happinesMetrics) {
        var happinessAvg = Utils.avg(happinesMetrics);
        var minHappiness = Math.min.apply(0, happinesMetrics);
        var lowestValueWeight = Balance.HAP_LOWEST_MIN_WEIGHT + (Balance.HAP_LOWEST_MAX_WEIGHT - Balance.HAP_LOWEST_MIN_WEIGHT) * cityLevel / Global.MAX_LEVEL;
        return (1 - lowestValueWeight) * happinessAvg + lowestValueWeight * minHappiness;
    };
    /**
     * Returns new happiness with tax affecting happiness
     * @param {number} happiness 0 - 1
     * @param {number} taxSatisfaction 0 - 1
     * @private
     */
    CityMetrics._getHappinessAfterTax = function (happiness, taxSatisfaction) {
        var happinessWeight = Balance.TAX_HAPPINES_WEIGHT;
        if (taxSatisfaction < 0.5) {
            var extraWeight = Balance.TAX_HAPPINES_HIGH_EXTRA_WEIGHT * (1 - taxSatisfaction / 0.5);
            happinessWeight += extraWeight;
        }
        // when tax is high, even more weight is applied
        var happinessNonTax = happiness * (1 - happinessWeight);
        var happinessTax = happinessWeight * taxSatisfaction;
        happiness = happinessNonTax + happinessTax;
        return happiness;
    };
    CityMetrics._getHappinessAfterMansion = function (happiness, city) {
        var mansion = city.structureCache.getMansion();
        if (!mansion) return happiness;
        var housingCapAroundMansion = 0;
        Utils.forRadiusAroundStructure(mansion.row, mansion.col, 2, 10, city.size, function (r, c) {
            var t = city.grids.zoneGrid.tiles[r][c];
            if (t && t instanceof ResidentialTile && !t._master) {
                if (t.isUpgraded()) {
                    housingCapAroundMansion += CityMetrics.getResidentialTileMaxPopUpgraded(t.getGroupSize());
                } else {
                    housingCapAroundMansion += CityMetrics.getResidentialTileMaxPop(t.getGroupSize());
                }
            }
        });
        var totalHousingCap = city.metrics.housing;
        var percentLivingAroundMansion = housingCapAroundMansion / totalHousingCap;
        var currentPop = city.stats.population;
        var avgHappinessPerCitizen = city.metrics.happiness;
        var totalHapp = avgHappinessPerCitizen * currentPop * (1 - percentLivingAroundMansion) + currentPop * percentLivingAroundMansion;
        var newHappiness = totalHapp / currentPop;
        return newHappiness;
    };
    CityMetrics._getMaxHappinessWithLowestTaxSatis = function (city) {
        if (city === void 0) {
            city = null;
        }
        var lowestTaxSatisfaction = {
            sales: EconomyHelper.TAX_LEVEL.VERY_HIGH,
            income: EconomyHelper.TAX_LEVEL.VERY_HIGH,
            property: EconomyHelper.TAX_LEVEL.VERY_HIGH
        };
        var taxSatis = EconomyHelper.getTaxSatisfactionForTaxLevels(lowestTaxSatisfaction, city);
        return CityMetrics._getHappinessAfterTax(1, taxSatis);
    };
    //
    // Apply Effects
    //
    CityMetrics.prototype.addCash = function (amt, allowExceedMax) {
        if (allowExceedMax === void 0) {
            allowExceedMax = false;
        }
        var oldCash = this.city.stats.money;
        if (this.city.isInfiniteMoney() || isNaN(amt) || typeof amt !== 'number') {
            return;
        }
        if (amt > 0 && this.city.stats.money + amt > this.maxCash) {
            if (allowExceedMax) {
                this.city.stats.money = this.city.stats.money + amt;
            } else {
                // dont force lose money from max cap reached, just ensure it doesn't go higher
                this.city.stats.money = Math.max(this.city.stats.money, this.maxCash);
            }
        } else {
            this.city.stats.money = Math.max(0, this.city.stats.money + amt);
        }
        if (this.city.stats.money === 0 && this.city.stats.money !== oldCash) {
            this.city.notifications.notify("no-cash");
        }
        this.city.refreshSignal.dispatch("money_updated");
        this.city.gameplayUI.checkSyncLandBuyUI();
    };
    CityMetrics.prototype.getImportExportFood = function () {
        return this.exportsFood - this.importsFood;
    };
    CityMetrics.prototype.getImportExportMaterials = function () {
        return this.exportsMaterial - this.importsMaterial;
    };
    CityMetrics.prototype.getImportExportNaturalResources = function () {
        return this.exportsNatural;
    };
    CityMetrics.prototype.getMaxExportCapacityPerResource = function () {
        return this.maxExportPerSec;
    };
    CityMetrics.prototype.getTotalExportCurrent = function () {
        return this.exportsFood + this.exportsMaterial + this.exportsNatural;
    };
    CityMetrics.prototype.addAttractivenessChildren = function (calculate, tile, baseAmt) {
        calculate.attractiveness += baseAmt;
        if (this.city.stats.internalVersion >= 1 && tile._children && tile._children.length) {
            calculate.attractiveness += baseAmt * tile._children.length;
        }
    };
    //
    // Helpers to apply side effects
    //
    // Power will affect how much money demolishes return
    CityMetrics.prototype.demolishReturnMutiplier = function () {
        // todo: add power support
        return Global.DEMOLISH_RETURN;
    };
    CityMetrics.prototype.getCurrentTotalDemand = function () {
        return this.demandResidential + this.demandCommercial + this.demandIndustrial;
    };
    //
    // Visual
    //
    CityMetrics.prototype.syncAllUIStats = function (spreadExec) {
        var _this = this;
        if (spreadExec === void 0) {
            spreadExec = false;
        }
        if (this.city.headlessMode) {
            return;
        }
        if (!this.city.game) return;
        this.city.gameplayUI.refreshLevelUI();
        this.city.gameplayUI.refreshExpBar();
        this.city.gameplayUI.refreshCash();
        this.city.gameplayUI.refreshArrows();
        if (spreadExec) {
            setTimeout(function () {
                if (!_this.city.game) return;
                _this._syncRestOfUIStats();
            }, 0);
        } else {
            this._syncRestOfUIStats();
        }
    };
    CityMetrics.prototype._syncRestOfUIStats = function () {
        this.city.gameplayUI.refreshTitle();
        this.city.gameplayUI.refreshPopulation();
        this.city.gameplayUI.syncStatsModalIfVisible();
        this.city.gameplayUI.syncDemandGraph();
    };
    CityMetrics.getDefaultMetricLevelDampenToZero = function (unlockMetricLevel, currentLevel, dampenOver) {
        if (dampenOver === void 0) {
            dampenOver = 2;
        }
        var increments = 1 / dampenOver;
        var delta = currentLevel - unlockMetricLevel;
        return Utils.clamp(1 - increments * (1 + delta), 0, 1);
    };
    // TODO: income tax and import/export
    // Performance
    CityMetrics.APPLY_EFFECT_INTERVAL = 1000; // SHOULD STAY 1 SECOND
    CityMetrics.STRUCTURE_EFFECT_TYPE = {
        RESOURCE: 0,
        POLICE: 1,
        FIRE: 2,
        HOSPITAL: 3,
        ENVIRONMENT: 4,
        RECREATION: 5,
        NONE: 6,
        ENVIRONMENT_REC: 7
    };
    CityMetrics.NO_TOWNHALL_HAPP_REDUCE = 0.1;
    CityMetrics.ARTIFICIAL_DEMAND_MAX_LV = 8;
    return CityMetrics;
}();
var METRIC_MODIFIER_TYPES;
(function (METRIC_MODIFIER_TYPES) {
    METRIC_MODIFIER_TYPES["CRIME"] = "crime";
    METRIC_MODIFIER_TYPES["FIRE"] = "fire";
    METRIC_MODIFIER_TYPES["HEALTH"] = "health";
    METRIC_MODIFIER_TYPES["ENVIRONMENT"] = "environment";
    METRIC_MODIFIER_TYPES["TRAFFIC"] = "traffic";
})(METRIC_MODIFIER_TYPES || (METRIC_MODIFIER_TYPES = {}));
var CityEducation;
(function (CityEducation) {
    CityEducation.SCHOOL_EDUCATES_NUM_CITIZENS = 4000;
    CityEducation.UNI_EDUCATES_NUM_CITIZENS = 8000;
    CityEducation.SCHOOL_SALARY_BOOST = 0.15;
    CityEducation.UNI_SALARY_BOOST = 0.2;
    function applyEducationIncomeTaxBoost(baseIncomeTax, population, numSchools, numUniversities) {
        var val = baseIncomeTax;
        var maxSchoolBoost = val * CityEducation.SCHOOL_SALARY_BOOST;
        var percentageBoosted = _percentPrimarySecondaryEducated(population, numSchools);
        maxSchoolBoost *= percentageBoosted;
        val += maxSchoolBoost;
        var percentageUniBoosted = _percentPostSecondaryEducated(population, numUniversities, percentageBoosted);
        var maxUniBoost = val * CityEducation.UNI_SALARY_BOOST;
        maxUniBoost *= percentageUniBoosted;
        val += maxUniBoost;
        return Math.round(val);
    }
    CityEducation.applyEducationIncomeTaxBoost = applyEducationIncomeTaxBoost;
    function percentPrimarySecondaryEducated(city) {
        var primarySecondary = _percentPrimarySecondaryEducated(city.stats.population, city.structureCache.getSchools().length);
        var postSecondary = _percentPostSecondaryEducated(city.stats.population, city.structureCache.getUniversities().length, primarySecondary);
        return [primarySecondary, postSecondary];
    }
    CityEducation.percentPrimarySecondaryEducated = percentPrimarySecondaryEducated;
    function _percentPrimarySecondaryEducated(population, numSchools) {
        return Math.min(1, numSchools * CityEducation.SCHOOL_EDUCATES_NUM_CITIZENS / population);
    }
    function _percentPostSecondaryEducated(population, numUniversities, numSecondaryEducationPercent) {
        var numSecondaryEducationPop = population * numSecondaryEducationPercent;
        return Math.min(1, Math.min(numSecondaryEducationPop, numUniversities * CityEducation.UNI_EDUCATES_NUM_CITIZENS) / population);
    }
})(CityEducation || (CityEducation = {}));
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var HeatmapGrid = /** @class */function (_super) {
    __extends(HeatmapGrid, _super);
    function HeatmapGrid(city, size, windowInput) {
        var _this = _super.call(this, city, size, windowInput, null, null, true) || this;
        _this.tints = [0x98d75a, 0xcad368, 0xe3b681, 0xe18e68, 0xda6148];
        _this.valueGrid = Grid.createEmptyTileSprites(_this.city.size, 0);
        Utils.setAll2D(_this.valueGrid, 0);
        _this.alpha = HeatmapGrid.ALPHA;
        _this.visible = false;
        return _this;
    }
    /** Uses white tiles with tints to show value for each heatmap value */
    HeatmapGrid.prototype.showTiles = function () {
        this.cacheAsBitmap = false;
        var city = this.city;
        var self = this;
        var selfTiles = this.tiles;
        var tintMaxIndex = this.tints.length - 1;
        var alphaTintMult = 1 / tintMaxIndex;
        var tint = this.tints[this.tints.length - 1];
        var s = this.city.size;
        for (var row = 0; row < s; row++) {
            for (var col = 0; col < s; col++) {
                var value = this.valueGrid[row][col];
                var tintIndex = Math.min(tintMaxIndex, Math.floor(this.tints.length * value));
                var alpha = tintIndex * alphaTintMult;
                // set tile
                if (!selfTiles[row][col]) {
                    var tintTile = city.whiteTilePool.allocate();
                    tintTile.tint = tint;
                    tintTile.alpha = alpha;
                    if (alpha > 0) {
                        self.setTile(row, col, tintTile);
                    }
                } else {
                    selfTiles[row][col].tint = tint;
                    selfTiles[row][col].alpha = alpha;
                }
            }
        }
        this.visible = true;
    };
    /** Frees white tiles and tints */
    HeatmapGrid.prototype.hideTiles = function () {
        if (!this.visible) return;
        var city = this.city;
        var tiles = this.tiles;
        var s = this.city.size;
        var t, row, col;
        for (row = 0; row < s; row++) {
            for (col = 0; col < s; col++) {
                t = tiles[row][col];
                if (t) {
                    t.tint = 0xffffff;
                    city.whiteTilePool.free(t);
                    tiles[row][col] = null;
                }
            }
        }
        this.visible = false;
    };
    HeatmapGrid.ALPHA = 0.5;
    // Lightest to heaviest// Lightest to heaviest
    // actually just uses the last value + alpha, otherwise too cpu intensive to fill all tiles
    HeatmapGrid.IDE_TINTS = ['#98d75a', '#cad368', '#e3b681', '#e18e68', '#da6148'];
    return HeatmapGrid;
}(Grid);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/** Apply flat binary value to 2d grid based on coverage */
var AOEBuildingEffectGrid = /** @class */function (_super) {
    __extends(AOEBuildingEffectGrid, _super);
    function AOEBuildingEffectGrid(city, size, windowInput) {
        var _this = _super.call(this, city, size, windowInput) || this;
        _this.coverageGrid = Grid.createEmptyTileSprites(_this.city.size, 0);
        return _this;
    }
    /** How far special building can suppress value */
    AOEBuildingEffectGrid.prototype.getEffectRadius = function (tile) {
        return 10;
    };
    AOEBuildingEffectGrid.prototype.sync = function () {
        var _this = this;
        Utils.setAll2D(this.coverageGrid, 0);
        Utils.setAll2D(this.valueGrid, 0);
        var gridSize = this.city.size;
        var structureTiles = this.getRelevantMasterStructureTiles();
        structureTiles.forEach(function (t) {
            var radius = _this.getEffectRadius(t);
            var startRow = t.row - Math.floor(radius * 0.5);
            var endRow = t.row + Math.floor(radius * 0.5);
            var startCol = t.col - Math.floor(radius * 0.5);
            var endCol = t.col + Math.floor(radius * 0.5);
            for (var i = startRow; i < endRow; i++) {
                for (var j = startCol; j < endCol; j++) {
                    if (Utils.isValidIndex(i, j, gridSize)) {
                        _this.coverageGrid[i][j] = 1;
                    }
                }
            }
        });
        this.syncAfterCoverage();
        return this.valueGrid;
    };
    /** Can be used for global calculation */
    AOEBuildingEffectGrid.prototype.getAverageVal = function () {
        var _this = this;
        var sum = 0;
        var totalCount = 0;
        Utils.foreach2D(this.valueGrid, function (v, r, c) {
            if (_this.isAffectedTile(r, c)) {
                sum += v;
                totalCount += 1;
            }
        });
        return sum / totalCount;
    };
    AOEBuildingEffectGrid.prototype.isAffectedTile = function (r, c) {
        // Default: zones and roads (non variant)
        var road = this.city.grids.roadGrid.tiles[r][c];
        return this.city.grids.zoneGrid.tiles[r][c] || road && !road.variantType;
    };
    return AOEBuildingEffectGrid;
}(HeatmapGrid);
/**
 * Spawns emergencies and dispatches responders
 */
var EmergencyEventManager = /** @class */function () {
    function EmergencyEventManager(city, helicopterManagerName, maxFrequency, minFrequency, minLevelForEvent, minPopForEvent) {
        var _this = this;
        this.timeSinceLastEvent = 0; // Force event to happen as soon as it can
        this.dispatched = [];
        this.dispatchAttempts = 0;
        this.emergencyVoices = [];
        this.city = city;
        this.initHelicopterManager(helicopterManagerName);
        this.maxFrequency = maxFrequency;
        this.minFrequency = minFrequency;
        this.minLevelForEvent = minLevelForEvent;
        this.minPopForEvent = minPopForEvent;
        this.timer = city.game.time.events.loop(2000, function () {
            _this.dipatchIntervalCheck();
        });
    }
    // Called on save state load
    EmergencyEventManager.prototype.initEventTime = function () {
        // If this saved game already reaches emergency requirement,
        // set next event to random time
        if (this.city.stats.level >= this.minLevelForEvent && this.city.stats.population >= this.minPopForEvent) {
            var nextTime = this.getIntervalTime();
            this.timeSinceLastEvent = nextTime * 0.5 + Math.random() * (nextTime * 0.5);
        }
    };
    EmergencyEventManager.prototype.isDispatching = function () {
        return this.dispatched.filter(function (c) {
            return !c.goingHome;
        }).length > 0;
    };
    EmergencyEventManager.prototype.untrackHelicopter = function (h) {
        Utils.removeFromArray(this.dispatched, h);
    };
    //
    // Loop and checks
    //
    EmergencyEventManager.prototype.update = function (elapsed) {
        //
        // Random event check
        //
        // Update crime timer and apply crime
        // e.g. safety percentage
        if (this.city.stats.level < this.minLevelForEvent || this.city.stats.population < this.minPopForEvent) {
            // nothing, no random event
        } else {
            // eligible - so increase timer
            var nextTime = this.getIntervalTime();
            this.timeSinceLastEvent += elapsed;
            if (this.timeSinceLastEvent > nextTime) {
                // start emergency only if camera is in default view
                if (this.city.gameplayUI.isDefaultView() && !this.city.events.areAnyEventsActive()) {
                    this.startEmergency();
                    this.timeSinceLastEvent = 0;
                }
            }
        }
        if (!this.city.vehicleLikeLayer.visible) {
            this.updateDispatchedInvisibleVehicles();
        }
    };
    EmergencyEventManager.prototype.getIntervalTime = function () {
        // on higher metric, frequency diff is higher so overall diff is higher
        var intervalTime = this.getMetricPercent() * (this.maxFrequency - this.minFrequency) + this.minFrequency;
        if (this.city.stats.level === this.minLevelForEvent) {
            // Add some buffer time for the first time that the emergency is unlocked so the player isn't hit too fast
            // grace period
            intervalTime += 60000; // 1 min
        }
        return intervalTime;
    };
    /**
     * Attempt to respond event at given index
     * - will stop at the closest road tile next to target
     * - returns whether responder can reach target
     * */
    EmergencyEventManager.prototype.attemptToDispatch = function () {
        var _this = this;
        this.dispatchAttempts += 1;
        var dispatchedGroundResponders = [];
        var dispatchedHelicopters = [];
        var successful = false;
        this.getSpawns().forEach(function (spawnTile) {
            if (!spawnTile.city) {
                return;
            }
            // Attempt to spawn ground vehicle
            var spawnsNearBuilding = spawnTile.getDisjointedSpawns();
            for (var i = 0; i < spawnsNearBuilding.length; i++) {
                var dispatchedGroundResponder = _this.dispatchGroundResponder(spawnsNearBuilding[i]);
                if (dispatchedGroundResponder) {
                    successful = true;
                    dispatchedGroundResponders.push(dispatchedGroundResponder);
                    break;
                }
            }
            // Spawn helicopter always
            // todo: only if level 2
            if (_this.isLevel2(spawnTile)) {
                dispatchedHelicopters.push(_this.dispatchHelicopter(spawnTile));
                successful = true;
            }
        });
        // Destroy all except the closest ground responder and helicopter
        if (!this.city.events.areAnyDisastersActive()) {
            var closestGroundResponder_1 = null;
            var closestGroundResponderPath_1 = -1;
            dispatchedGroundResponders.forEach(function (v) {
                if (v.path && v.path.length < closestGroundResponderPath_1 || closestGroundResponderPath_1 === -1) {
                    closestGroundResponderPath_1 = v.path.length;
                    closestGroundResponder_1 = v;
                }
            });
            if (closestGroundResponder_1) {
                dispatchedGroundResponders.forEach(function (v) {
                    if (v !== closestGroundResponder_1) Utils.destroyIfAlive(v);
                });
            }
            var closestHelicopter_1 = null;
            var closestHelicopterDist_1 = -1;
            dispatchedHelicopters.forEach(function (v) {
                var nearestEvent = _this.getNearestEvent(v);
                if (!nearestEvent) return;
                var dist = Utils.posDistTotal(v, nearestEvent);
                if (dist < closestHelicopterDist_1 || closestHelicopterDist_1 === -1) {
                    closestHelicopterDist_1 = dist;
                    closestHelicopter_1 = v;
                }
            });
            if (closestHelicopter_1) {
                dispatchedHelicopters.forEach(function (v) {
                    if (v !== closestHelicopter_1) Utils.destroyIfAlive(v);
                });
            }
        }
        return successful;
    };
    // use this to check if more can be dispatched, (e.g. player builds more roads for access after initial dispatch
    EmergencyEventManager.prototype.dipatchIntervalCheck = function () {
        // nothing
    };
    EmergencyEventManager.prototype.updateDispatchedInvisibleVehicles = function () {
        for (var i = 0; i < this.dispatched.length; i++) {
            if (this.dispatched[i] && this.dispatched[i].parent && !this.dispatched[i].parent.visible) {
                this.dispatched[i].update();
            }
        }
    };
    /** attempt to start emergency event */
    EmergencyEventManager.prototype.startEmergency = function () {
        if (this.city.emergenciesPaused) {
            return;
        }
        var eventIndex = this.spawnEvent();
        if (eventIndex) {
            this.attemptToDispatch();
            AudioPC.playOnce("radio_static");
        }
        this.city.gameplayUI.syncLeftNotifs();
    };
    EmergencyEventManager.prototype.playEmergencyVoiceAudio = function () {
        var voice = this.getEmergencyVoiceAudio();
        if (voice) {
            this.city.delayEventWithCityCheck(500, function () {
                AudioPC.playOnce(voice);
            });
        }
    };
    EmergencyEventManager.prototype.getEmergencyVoiceAudio = function () {
        if (!this.emergencyVoices.length) return null;
        return Utils.popFrontToBack(this.emergencyVoices);
    };
    // Satisfies helicopter mixin
    EmergencyEventManager.prototype.getHelicopterSpawnTiles = function () {
        return this.getSpawns();
    };
    ;
    return EmergencyEventManager;
}();
Utils.extend(EmergencyEventManager.prototype, HelicopterManagerMixin);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Manages crime spawning and responders
 */
var Crime = /** @class */function (_super) {
    __extends(Crime, _super);
    function Crime(city) {
        var _this = _super.call(this, city, 'dispatch-crime', Crime.MAX_CRIME_FREQUENCY, Crime.MIN_CRIME_FREQUENCY, Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV, Balance.CRIME_MIN_POPULATION) || this;
        _this.crimeInstances = [];
        _this.numCrimesStarted = 0;
        _this.emergencyVoices = ["police_emerg_1", "police_emerg_2"];
        _this.lastHideoutBust = 0;
        _this.hideoutIndex = null;
        _this._hideoutThugs = [];
        _this._hideoutSpawnedThugs = [];
        city.registerCallbackUpdateEvery(function () {
            _this.spawnWalkingThugsNearHideout();
        }, 1000);
        _this.city.refreshSignal.add(function (event) {
            if (event === "mugging_stopped" || event === "vandalism_stopped" || event === "gta_stopped") {
                _this.incrementNumCrimesStopped();
            }
        });
        _this.lastHideoutBust = _this.city.citySaveHelper.getGlobalSetting(Crime.LAST_HIDEOUT_BUST_TIME, 0);
        return _this;
    }
    Crime.prototype.incrementNumCrimesStopped = function () {
        this.city.citySaveHelper.setGlobalSetting(Crime.CRIME_STOP_COUNT_KEY, this.getNumCrimesStopped() + 1);
    };
    Crime.prototype.getNumCrimesStopped = function () {
        return this.city.citySaveHelper.getGlobalSetting(Crime.CRIME_STOP_COUNT_KEY, 0);
    };
    Crime.prototype.isCrimeTwiceAsFast = function () {
        if (this.city.isSandbox) {
            return false;
        } else {
            return this.city.quests.isArchived(Quests.JIGGY_QUEST_VANDALISM_ID) && this.city.stats.level >= Crime.MANY_CRIMES_STOPPED_MIN_LEVEL;
        }
    };
    Crime.prototype.hasUnlockedGTA = function () {
        return this.city.isSandbox || this.city.stats.level >= Crime.GTA_CRIME_MIN_LEVEL && this.city.quests.isArchived(Quests.JIGGY_QUEST_ID);
    };
    Crime.prototype.hasUnlockedVandalism = function () {
        return this.city.isSandbox || this.city.stats.level >= Crime.VANDAL_CRIME_MIN_LEVEL && this.city.quests.isArchived(Quests.JIGGY_QUEST_GTA_ID);
    };
    Crime.prototype.hasUnlockedCrime = function () {
        return this.city.stats.level >= Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV && this.city.stats.population >= Balance.CRIME_MIN_POPULATION;
    };
    Crime.prototype.dipatchIntervalCheck = function () {
        // this works because we only every have 1 crime at a time
        if (this.crimeInstances.length && !this.isDispatching()) {
            this.attemptToDispatch();
        }
        if (this.crimeInstances.length && this.isDispatchingToHideout() && !this.hideoutIndex) {
            this.crimeInstances.length = 0;
            this.city.gameplayUI.showSmallDialog(Dialogue.AVATARS.POLICE, "The hideout is gone! Calling off the dispatch.");
        }
    };
    //
    // Emergency Implementation
    //
    Crime.prototype.focusCameraNearestEvent = function () {
        this.city.gameplayUI.showDefaultView();
        this.city.clearFocusAnyGrid();
        var cam = Utils.getCameraCentrePos(this.city);
        var crime = this.getNearestCrime(cam.x, cam.y);
        if (crime) {
            if (crime.notif === "hideout-dispatched") {
                // don't zoom as close for hideout
                this.city.easeCameraAndZoomToTile(crime.index, Utils.zoomRequiredToShowNumTiles(Global.CRIME_FOCUS_ZOOM_TILES * 2.2, this.city.pocketCity));
            } else {
                this.city.easeCameraAndZoomToTile(crime.index, Utils.zoomRequiredToShowNumTiles(Global.CRIME_FOCUS_ZOOM_TILES, this.city.pocketCity));
            }
        }
        AudioPC.playOnce("radio_static");
        if (this.getSpawns().length === 0) {
            this.city.notifications.notify("crime-no-responders");
        } else if (this.isDispatching()) {
            if (this.crimeInstances[0] && this.crimeInstances[0].notif) {
                this.city.notifications.notify(this.crimeInstances[0].notif);
            } else {
                this.city.notifications.notify("crime-dispatched");
            }
            this.playEmergencyVoiceAudio();
        } else {
            this.city.notifications.notify("crime-no-dispatch");
        }
    };
    Crime.prototype.isLevel2 = function (spawnTile) {
        return spawnTile.building && spawnTile.building.sheet === STRUCTURE_SHEETS.POLICE_LV2;
    };
    Crime.prototype.getSpawns = function () {
        return this.city.structureCache.getPolice();
    };
    Crime.prototype.getMetricPercent = function () {
        return this.city.metrics.safetyCrime;
    };
    Crime.prototype.updateHideout = function () {
        if (this.city.metadata.elapsedTime <= this.lastHideoutBust + Crime.HIDEOUT_ONCE_EVERY_X_MILLIS) {
            return;
        }
        this.refreshHideoutLocation();
        this.checkSpawnHideout();
    };
    // thugperson
    Crime.prototype.checkSpawnHideout = function () {
        // clear outdated non-alive thugs
        for (var i = this._hideoutThugs.length - 1; i >= 0; i--) {
            if (!this._hideoutThugs[i].alive) {
                this._hideoutThugs.splice(i, 1);
            }
        }
        if (this.hideoutIndex === null) {
            return;
        }
        this.ensureSpawnAnchorHideoutthugs();
    };
    Crime.prototype.ensureSpawnAnchorHideoutthugs = function () {
        var _this = this;
        var edgeNodes = this.city.traffic.getEdgeNodesNearIndex(this.hideoutIndex.row, this.hideoutIndex.col, true);
        if (!edgeNodes || edgeNodes.length < 2) return;
        var extra = 3;
        if (this._hideoutThugs.length >= edgeNodes.length + extra) {
            return;
        }
        // re-spawn to full capacity
        this._hideoutThugs.forEach(function (t) {
            return t.destroy();
        });
        this._hideoutThugs.length = 0;
        edgeNodes.forEach(function (n) {
            var t = _this.city.pedestrians.spawnThug(n.row, n.col, n.nodeEnum, false);
            t.loiterFixedPosition();
            _this._hideoutThugs.push(t);
        });
        while (this._hideoutThugs.length < edgeNodes.length + extra) {
            var pos = Utils.randomPositionBetween(this._hideoutThugs[0], this._hideoutThugs[1]);
            // add one extra between
            var t = this.city.pedestrians.spawnThug(edgeNodes[0].row, edgeNodes[0].col, edgeNodes[0].nodeEnum, false);
            t.x = pos.x;
            t.y = pos.y;
            this._hideoutThugs.push(t);
        }
        this._hideoutThugs.forEach(function (t) {
            t.y -= t.height * 0.1;
        });
    };
    Crime.prototype.spawnWalkingThugsNearHideout = function () {
        if (this._hideoutSpawnedThugs.length >= Crime.MAX_HIDEOUT_WALK_THUGS || !this.hideoutIndex) {
            return;
        }
        for (var i = this._hideoutSpawnedThugs.length - 1; i >= 0; i--) {
            if (!this._hideoutSpawnedThugs[i].alive) {
                this._hideoutSpawnedThugs.splice(i, 1);
            }
        }
        this._hideoutSpawnedThugs = this._hideoutSpawnedThugs.filter(function (t) {
            return t.alive;
        });
        var n = Utils.randomChoice(this.city.traffic.getNodesNearSpawn(this.hideoutIndex.row, this.hideoutIndex.col));
        if (!n) return;
        var t = this.city.pedestrians.spawnThug(n.row, n.col, n.nodeEnum, true);
        t.setMaxWalkSteps(2);
        this._hideoutSpawnedThugs.push(t);
    };
    Crime.prototype.isHideout = function (row, col) {
        if (!this.hideoutIndex) return false;
        var isHideout = this.hideoutIndex.row === row && this.hideoutIndex.col === col;
        if (isHideout) {
            return true;
        }
        var t = this.city.grids.zoneGrid.tiles[row][col];
        if (t && t._children) {
            for (var i = 0; i < t._children.length; i++) {
                var c = t._children[i];
                if (c && this.hideoutIndex.row === c.row && this.hideoutIndex.col === c.col) {
                    return true;
                }
            }
        }
        return false;
    };
    Crime.prototype.isNearHideout = function (row, col) {
        if (!this.hideoutIndex) return false;
        return Math.abs(this.hideoutIndex.row - row) < Crime.NEAR_HIDEOUT_DIST && Math.abs(this.hideoutIndex.col - col) < Crime.NEAR_HIDEOUT_DIST;
    };
    Crime.prototype.clearHideout = function () {
        if (!this.hideoutIndex) return;
        console.log("clearing hideout");
        this.hideoutIndex = null;
        this.clearHideoutThugs();
        if (this.isDispatchingToHideout()) {
            this.crimeInstances.length = 0;
        }
    };
    Crime.prototype.clearHideoutThugs = function () {
        var _this = this;
        this._hideoutThugs.forEach(function (t) {
            return Utils.fadeOutDestroy(_this.city.game, t);
        });
        this._hideoutThugs.length = 0;
        this._hideoutSpawnedThugs.forEach(function (t) {
            return Utils.fadeOutDestroy(_this.city.game, t);
        });
        this._hideoutSpawnedThugs.length = 0;
    };
    Crime.prototype.refreshHideoutLocation = function () {
        // clear existing hideout if invalid
        var isStillValidIndex = false;
        if (this.hideoutIndex) {
            var zoneTile = this.city.grids.zoneGrid.tiles[this.hideoutIndex.row][this.hideoutIndex.col];
            if (this.city.grids.crimeGrid.valueGrid[this.hideoutIndex.row][this.hideoutIndex.col] && this.city.grids.crimeGrid.isCompleteResidentialTouchingRoad(zoneTile)) {
                isStillValidIndex = true;
            }
        }
        if (!isStillValidIndex) {
            this.clearHideout();
        }
        if (this.city.stats.level < Crime.UNLOCK_HIDEOUTS || this.city.stats.population < Crime.HIDEOUTS_MIN_POP) {
            return;
        }
        if (this.hideoutIndex) {
            var zoneTile = this.city.grids.zoneGrid.tiles[this.hideoutIndex.row][this.hideoutIndex.col];
            if (this.city.grids.crimeGrid.valueGrid[this.hideoutIndex.row][this.hideoutIndex.col] && this.city.grids.crimeGrid.isCompleteResidentialTouchingRoad(zoneTile)) {
                // still has crime at res, keep there
                return;
            }
        }
        //console.log("finding new crime hideout location");
        this.clearHideout();
        // no hideout or no more crime at hidedout, try to find elsewhere
        var targetCrimeTileTuple = Utils.randomChoice(this.city.grids.crimeGrid.getHighestCrimeResidentialTilesTouchingRoad());
        if (!targetCrimeTileTuple) {
            //console.log("no suitable hideout index found");
            return;
        }
        this.hideoutIndex = {
            row: targetCrimeTileTuple[0],
            col: targetCrimeTileTuple[1]
        };
        //console.log("found new hideout index:",this.hideoutIndex.row,this.hideoutIndex.col);
    };
    Crime.prototype.policeArriveHideout = function () {
        var _this = this;
        AudioPC.playUISuccessChime();
        // make thugs run away (but not destroy)
        this._hideoutSpawnedThugs.forEach(function (t) {
            t.clearMaxWalkSteps();
            t.run(15);
        });
        this._hideoutThugs.forEach(function (t) {
            t.stopFixedLoiterAndrun();
        });
        if (this._hideoutThugs[0]) {
            this._hideoutThugs[0].showSpeechBubble(SpeechBubble.COPY.HIDEOUT_BUSTED, CitySpeech.SPEECH_DURATION);
        }
        // destroy after delay
        this.city.delayEventWithCityCheck(5000, function () {
            _this.clearHideoutThugs();
        });
        // reward and side effects
        this.city.cityLevel.addPercentExp(Crime.HIDEOUT_BUSTED_EXP_REWARD);
        this.city.registerSafeTimeout(function () {
            _this.city.gameplayUI.showSmallDialog(Dialogue.AVATARS.POLICE, "That hideout is busted! Look at them run, haha! The neighborhood is safe again, for now.");
        }, 2500);
        this.hideoutIndex = null;
        this.city.quests.checks._bustedHideout = true;
        // update last bust time
        this.city.citySaveHelper.setGlobalSetting(Crime.LAST_HIDEOUT_BUST_TIME, this.city.metadata.elapsedTime, true);
        this.lastHideoutBust = this.city.metadata.elapsedTime;
    };
    // Spawn crime
    Crime.prototype.spawnEvent = function (forceIndex) {
        // let's keep it simple - just one crime at a time
        if (this.crimeInstances.length) {
            return null;
        }
        // find appropriate spot
        var targetCrimeTile = null;
        if (forceIndex) {
            targetCrimeTile = forceIndex;
        } else {
            var targetCrimeTileTuple = Utils.randomChoice(this.city.grids.crimeGrid.getHighestCrimeRoadTiles());
            if (!targetCrimeTileTuple) {
                targetCrimeTileTuple = this.city.grids.crimeGrid.getAnyRoadTileForCrime();
                if (!targetCrimeTileTuple) {
                    return;
                }
            }
            targetCrimeTile = {
                row: targetCrimeTileTuple[0],
                col: targetCrimeTileTuple[1]
            };
        }
        if (!targetCrimeTile) return;
        var crimeStarted;
        if (!this.hasUnlockedGTA()) {
            // just mugging
            crimeStarted = this.spawnMugging(targetCrimeTile);
        } else {
            if (!this.hasUnlockedVandalism()) {
                // just mugging or gta
                switch (this.numCrimesStarted % 2) {
                    case 0:
                        crimeStarted = this.spawnMugging(targetCrimeTile);
                        break;
                    case 1:
                        crimeStarted = this.spawnCarSteal(targetCrimeTile);
                        break;
                }
            } else {
                // mugging, gta, or vandal
                switch (this.numCrimesStarted % 3) {
                    case 0:
                        crimeStarted = this.spawnMugging(targetCrimeTile);
                        break;
                    case 1:
                        // this will be the third
                        crimeStarted = this.spawnCarSteal(targetCrimeTile);
                        break;
                    case 2:
                        crimeStarted = this.spawnVandalism(targetCrimeTile);
                        break;
                }
            }
        }
        this.numCrimesStarted += 1;
        if (crimeStarted) {
            this.crimeInstances.push(crimeStarted);
            var markerX = crimeStarted.thug.x - Math.abs(crimeStarted.thug.width) * 4.1;
            var markerY = crimeStarted.thug.y + Math.abs(crimeStarted.thug.height) * 1.25;
            // hacky special case
            if (crimeStarted.thug.isStealingCar) {
                markerY += crimeStarted.thug.height * 1.2;
                if (crimeStarted.thug._stealingCarIsOnLeft) {
                    markerX -= crimeStarted.thug.height * 0.5;
                }
            }
            var marker = this.city.cityUI.createLabelMarker("ui-2", "marker-crime", true, markerX, markerY);
            this.city.constantEffectNoHide.addChild(marker);
            crimeStarted.marker = marker;
            this.city.grids.zoneGrid.checkAndSetTransparentAroundPedTile(crimeStarted.index);
            return crimeStarted.index;
        } else {
            console.log("didn't start crime");
            return null;
        }
    };
    //
    // Responder units
    //
    Crime.prototype.isDispatchingToHideout = function () {
        return this.crimeInstances[0] && this.crimeInstances[0].notif === "hideout-dispatched";
    };
    Crime.prototype.dispatchToHideout = function () {
        if (!this.hideoutIndex) return;
        if (this.crimeInstances.length) {
            this.city.gameplayUI.showSmallDialog(Dialogue.AVATARS.POLICE, "Our police force is busy with another emergency!");
            return;
        }
        var crimeInstance = {
            index: {
                col: this.hideoutIndex.col,
                row: this.hideoutIndex.row
            },
            thug: null,
            victim: null,
            notif: "hideout-dispatched",
            stopCb: function stopCb(city) {
                city.crime.policeArriveHideout();
            }
        };
        this.crimeInstances.push(crimeInstance);
        var dispatched = this.attemptToDispatch();
        if (dispatched) {
            AudioPC.playOnce("radio_static");
            this.city.notifications.notify(crimeInstance.notif);
        } else {
            this.crimeInstances.pop();
            this.city.gameplayUI.showSmallDialog(Dialogue.AVATARS.POLICE, "Our police force can't reach the hideout!");
        }
    };
    Crime.prototype.dispatchGroundResponder = function (index) {
        var r = new PoliceCar(this.city, this, index);
        r.positionAt(index.row, index.col);
        this.dispatched.push(r);
        if (r.handleNearestCrime()) {
            return r;
        } else {
            return null;
        }
    };
    Crime.prototype.dispatchHelicopter = function (spawnTile) {
        var pos = Utils.indexToPosition(spawnTile.col, spawnTile.row, Tile.TILE_WIDTH);
        var crimeInstance = this.getNearestCrime(pos.x, pos.y);
        if (!crimeInstance) return;
        var h = new HelicopterPolice(this.city, spawnTile, this, function () {
            h.respondToNearestCrime();
        }, crimeInstance);
        this.dispatched.push(h);
        return h;
    };
    ;
    Crime.prototype.getNearestEvent = function (nearPos) {
        var c = this.getNearestCrime(nearPos.x, nearPos.y);
        if (!c) {
            return null;
        }
        return Utils.indexToPositionReuse(c.index.col, c.index.row, Tile.TILE_WIDTH);
    };
    Crime.prototype.getNearestCrime = function (x, y) {
        var nearestCrime = null;
        var nearestDist = null;
        this.crimeInstances.forEach(function (c) {
            var pos = Utils.indexToPositionReuse(c.index.col, c.index.row, Tile.TILE_WIDTH);
            var dist = Math.abs(pos.x - x) + Math.abs(pos.y - y);
            if (nearestDist === null || dist < nearestDist) {
                nearestDist = dist;
                nearestCrime = c;
            }
        });
        // console.log("determined nearest crime to be ",nearestCrime); // gets printed a lot
        return nearestCrime;
    };
    //
    // Details
    //
    Crime.prototype.spawnMugging = function (index) {
        var _this = this;
        // person
        var pedToBeMugged;
        var pedsInIndex = this.city.sidewalkGraph.nodesAtIndex(index.row, index.col).reduce(function (acc, n) {
            return acc.concat(n.getIgnoredOccupants() || []);
        }, []);
        pedsInIndex = pedsInIndex.filter(function (p) {
            return p instanceof Person && !(p instanceof ThugPerson) && !_this.city.citySpeech.isSpeechBubbleObstructed(p);
        });
        if (pedsInIndex.length === 0) {
            pedToBeMugged = this.city.pedestrians.spawnPerson(this.city.sidewalkGraph.getNode(index.row, index.col, TileNode.NODE_ENUM.UP), false);
        } else {
            pedToBeMugged = Utils.randomChoice(pedsInIndex);
        }
        // thug
        var t = this.city.pedestrians.spawnThug(pedToBeMugged.node.row, pedToBeMugged.node.col, pedToBeMugged.node.nodeEnum, false);
        t.x = pedToBeMugged.x - pedToBeMugged.width;
        t.y = pedToBeMugged.y;
        return t.mug(pedToBeMugged);
    };
    Crime.prototype.spawnVandalism = function (index) {
        // spawn a few thugs in index
        var nodes = this.city.sidewalkGraph.nodesAtIndex(index.row, index.col);
        Utils.shuffle(nodes);
        if (!nodes.length) return null;
        var throwingThugs = [];
        for (var i = 0; i < nodes.length - 1; i++) {
            var t = this.city.pedestrians.spawnThug(index.row, index.col, nodes[i].nodeEnum, false);
            throwingThugs.push(t);
            t.startRandomThrowing();
            if (i !== 0) {
                throwingThugs[0].crimePartners.push(t);
            }
        }
        if (!throwingThugs.length) {
            return null;
        }
        // spawn some additional pedestrians around as targets
        this.city.pedestrians.disableThug = true;
        var peds = this.city.pedestrians.forceSpawnNear(index.row, index.col);
        for (var j = 0; j < peds.length; j++) {
            peds[j].stopAction();
            peds[j].standAround();
        }
        this.city.pedestrians.disableThug = false;
        var leaderThug = throwingThugs[0];
        return leaderThug.startThrowingCrimeLead();
    };
    Crime.prototype.spawnCarSteal = function (index) {
        var _this = this;
        // find nearest parked car
        var allCars = this.city.roadGraph.getParkedCarsSlow();
        var closestCar = null;
        var closestDist = null;
        var skyRailGrid = this.city.grids.skyRailGrid;
        var iPos = Utils.indexToPosition(index.col, index.row, Tile.TILE_WIDTH);
        allCars.forEach(function (c) {
            if (c.isTruck) return; // don't want trucks
            var n = c.parkingNode;
            var dist;
            if (n && !skyRailGrid.hasTile(n.row, n.col)) {
                if (_this.getCrimeAtIndex({ row: n.row, col: n.col })) {
                    return;
                }
                dist = Utils.posDistTotal(Utils.indexToPositionReuse(n.col, n.row), iPos);
                if (dist < closestDist || closestDist === null) {
                    closestDist = dist;
                    closestCar = c;
                }
            }
        });
        if (closestCar) {
            var t = this.city.pedestrians.spawnThug(closestCar.node.row, closestCar.node.col, closestCar.node.nodeEnum, false);
            return t.stealParkedCar(closestCar);
        }
        return null;
    };
    Crime.prototype.removeCrimeInstance = function (crimeIndex) {
        var _this = this;
        for (var i = this.crimeInstances.length - 1; i >= 0; i--) {
            var crimeInstance = this.crimeInstances[i];
            if (Utils.isEqualIndexes(crimeInstance.index, crimeIndex)) {
                Utils.destroyIfAlive(crimeInstance.marker);
                this.crimeInstances.splice(i, 1);
            }
        }
        if (this.crimeInstances.length === 0) {
            this.city.registerSafeTimeout(function () {
                _this.city.grids.zoneGrid.clearTempTransparent();
            }, 2000);
        }
    };
    Crime.prototype.getCrimeAtIndex = function (crimeIndex) {
        return this.crimeInstances.filter(function (c) {
            return Utils.isEqualIndexes(c.index, crimeIndex);
        })[0];
    };
    Crime.prototype.stopCrimeInstance = function (crimeInstance) {
        if (!crimeInstance) return;
        console.log("should stop crime instance, police made it on time");
        // thug should stop run away and exclaim
        if (crimeInstance.thug) {
            crimeInstance.thug.crimeFinishSuccess = false;
            crimeInstance.thug.stopCrime();
        }
        if (crimeInstance.stopCb) {
            crimeInstance.stopCb(this.city);
        }
        // earn reward for preventing crime?
        this.city.cityLevel.addPercentExp(Crime.CRIME_STOP_EXP_REWARD);
    };
    /** Stop crime due to police */
    Crime.prototype.stopCrimeAtIndex = function (crimeIndex) {
        var _this = this;
        // edge case handled - possibly multiple crimes in one index
        var crimeInstances = this.crimeInstances.filter(function (c) {
            return Utils.isEqualIndexes(c.index, crimeIndex);
        });
        // if there actually was no crime there, do nothing
        if (crimeInstances.length === 0) {
            return;
        }
        crimeInstances.forEach(function (c) {
            return _this.stopCrimeInstance(c);
        });
        this.removeCrimeInstance(crimeIndex);
        this.crimeInstances = this.crimeInstances.filter(function (c) {
            return !Utils.isEqualIndexes(c.index, crimeIndex);
        });
    };
    // Helpers
    Crime.prototype.crimeNear = function (sprite) {
        var crimePosition = null;
        if (this.crimeInstances.length > 0) {
            for (var i = 0; i < this.crimeInstances.length; i++) {
                var crimeInstance = this.crimeInstances[i];
                var crimePos = Utils.indexToPosition(crimeInstance.index.col, crimeInstance.index.row, Tile.TILE_WIDTH);
                if (Math.abs(crimePos.x - sprite.x) < Tile.TILE_WIDTH && Math.abs(crimePos.y - sprite.y) < Tile.TILE_WIDTH) {
                    crimePosition = crimePos;
                }
            }
        }
        return crimePosition;
    };
    Crime.MAX_CRIME_FREQUENCY = 5.2 * 1000 * 60; // low crime, once per 5.2 minute
    Crime.MIN_CRIME_FREQUENCY = 1.2 * 1000 * 60; // high crime, once per 1.2 minute
    Crime.UNLOCK_HIDEOUTS = 30;
    Crime.HIDEOUTS_MIN_POP = 1000;
    Crime.CRIME_STOP_EXP_REWARD = 0.15;
    Crime.HIDEOUT_BUSTED_EXP_REWARD = 0.25;
    Crime.CRIME_STOP_COUNT_KEY = "stoppedcrimes";
    Crime.VANDAL_DURATION = 19000;
    Crime.CRIME_FAST_SPEED_MULT = 0.6;
    Crime.LAST_HIDEOUT_BUST_TIME = "hide-bust";
    Crime.HIDEOUT_ONCE_EVERY_X_MILLIS = 5 * 60 * 1000;
    Crime.MUGGING_CRIME_MIN_LEVEL = Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV + 1;
    Crime.GTA_CRIME_MIN_LEVEL = Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV + 2;
    Crime.VANDAL_CRIME_MIN_LEVEL = Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV + 22;
    Crime.MANY_CRIMES_STOPPED_MIN_LEVEL = 32;
    Crime.MANY_CRIMES_STOPPED_REQUIRED_NUM = 25;
    Crime.MAX_HIDEOUT_WALK_THUGS = 15;
    //
    // Hideout
    //
    Crime.NEAR_HIDEOUT_DIST = 2;
    return Crime;
}(EmergencyEventManager);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Tile Object, extends Sprite
 * @param city
 * @param [x]
 * @param [y]
 * @param texture
 * @param [size] {Number} - nobody use this
 * @param [frame] {String}
 * @constructor
 */
var Tile = /** @class */function (_super) {
    __extends(Tile, _super);
    function Tile(city, x, y, texture, size, frame) {
        if (size === void 0) {
            size = Tile.TILE_WIDTH;
        }
        var _this = _super.call(this, city.game, x, y, texture, frame) || this;
        _this.col = -1;
        _this.row = -1;
        _this.noCull = false; // used for culling
        _this.building = null;
        _this.structureGroup = null; // regular structure group
        _this._master = null;
        _this._children = [];
        _this.type = null;
        _this.variantType = null;
        _this.dependencies = []; // like children, but not attached. should be destroyed along with self
        _this.city = city;
        _this.size = size;
        // Resize to double tile width (because of padding)
        //Utils.scaleToWidth(this, this.size / Tile.ZONE_TILE_AREA_PERCENT);
        _this.anchor.setTo(0.5);
        return _this;
    }
    /** Scale sprite by a factor from default size */
    Tile.prototype.resize = function (size, col, row) {
        this.size = size || this.size;
        Utils.scaleToWidth(this, this.size * this.sizeMult / Tile.ZONE_TILE_AREA_PERCENT);
        this.setPositionByIndex(col, row);
    };
    /**
     * Set sprite position according to grid index
     * @param col {Number}
     * @param row {Number}
     */
    Tile.prototype.setPositionByIndex = function (col, row) {
        this.setPosition(Utils.indexToPositionReuse(col, row, this.size));
    };
    Tile.prototype.getCost = function () {
        return 0;
    };
    Tile.prototype.getScaledCost = function () {
        return Tile._getScaledCost(this.getCost(), this.city.stats.level);
    };
    Tile._getScaledCost = function (baseCost, level, city, type) {
        if (type === void 0) {
            type = -1;
        }
        var maxCost = baseCost * Balance.MAX_COST_INCREASE_ZONE_TILES;
        var costDiff = maxCost - baseCost;
        var scaledCost = baseCost + costDiff * ((level - 1) / Global.MAX_LEVEL);
        // Round, then cut to nearest 10s
        var cost = Math.round(Math.round(scaledCost) * 0.1) * 10;
        if (city && type != -1) {
            if (type === Tile.Type.Residential) {
                if (Policy.isPolicyActive(city, Policy.CODES.CONTRACTOR_RES_DISCOUNT_2)) {
                    var discount1 = cost * (1 - Policy.CONSTS.HOUSING_DISCOUNT_1);
                    return Math.round(discount1 * (1 - Policy.CONSTS.HOUSING_DISCOUNT_2));
                } else if (Policy.isPolicyActive(city, Policy.CODES.CONTRACTOR_RES_DISCOUNT)) {
                    return Math.round(cost * (1 - Policy.CONSTS.HOUSING_DISCOUNT_1));
                }
            }
        }
        return cost;
    };
    /** size of self with child tiles */
    Tile.prototype.getGroupSize = function () {
        return this._children.length + 1;
    };
    // Cache index here instead of recalculating each time
    //
    // Methods
    //
    /** Activate the tile behaviour */
    Tile.prototype.start = function () {};
    //
    // Visibility
    //
    Tile.prototype.setVisible = function (visibility) {
        this.visible = visibility;
    };
    //
    // Positioning
    //
    Tile.prototype.cacheIndex = function (col, row) {
        this.col = col;
        this.row = row;
    };
    /**
     * Set sprite position
     * @param position {JSON} - X Y coordinates
     */
    Tile.prototype.setPosition = function (position) {
        this.x = position.x;
        this.y = position.y;
    };
    /**
     * Returns the current tile position based on grid
     */
    Tile.prototype.getIndex = function () {
        if (this.col !== null && this.row !== null) {
            return Utils.toIndex2D(this.col, this.row);
        } else {
            return Utils.isoToIndex(this.x, this.y, this.size);
        }
    };
    /** Add a dependency of this, can be used for effects */
    Tile.prototype.addDependency = function (entity) {
        this.dependencies.push(entity);
    };
    Tile.prototype.removeAllFromDependencies = function (entities) {
        var _this = this;
        entities.forEach(function (e) {
            var index = _this.dependencies.indexOf(e);
            if (index !== -1) {
                _this.dependencies.splice(index, 1);
            }
        });
    };
    Tile.prototype.destroyDependencies = function () {
        var _this = this;
        this.dependencies.forEach(function (d) {
            _this.city.removeForcePrePostUpdateSprite(d);
            Utils.destroyIfAlive(d);
        });
    };
    /**
     * Destroy tile, NOT auto-destroy children
     * Conscious decision because during build, children can surivive + restart even if parent tile dies
     * Do not add auto child destruction to this method
     */
    Tile.prototype.destroy = function () {
        this.onDestroy();
        this.preDestroy();
        _super.prototype.destroy.call(this);
    };
    Tile.prototype.preDestroy = function () {
        if (this.structureGroup) {
            Utils.destroyIfAlive(this.structureGroup);
            this.structureGroup = null;
            // remove structure from structuregrid
            this.city.grids.structureGrid.unsetTile(this.row, this.col);
        }
        // Clear resize fn
        if (this.city._inspectingTile === this) {
            this.city.gameplayUI.showDefaultView();
        }
        this.destroyDependencies();
    };
    Tile.prototype.onDestroy = function () {
        // nothing by default
    };
    Tile.prototype.destroyGroup = function () {
        var self = this;
        this.getGroup().map(function (t) {
            if (t != self) {
                if (t.alive) {
                    t.pendingDestroy = true;
                    Utils.destroyIfAlive(t);
                }
            }
        });
    };
    /**
     * Tell neighboring zone tiles that they belong to this tile as a group
     * Iterates in reverse from max row, col, decrementing
     * @param colOffset {Number} - integer for index offset to enslave (col)
     * @param rowOffset {Number} - integer for index offset to enslave (row)
     * @param [tiles] {Tile[]} - defaults to zoneGrid tiles
     */
    Tile.prototype.addChildNeighbours = function (colOffset, rowOffset, tiles) {
        if (tiles === void 0) {
            tiles = this.city.grids.zoneGrid.tiles;
        }
        var col = this.col;
        var row = this.row;
        for (var r = row; r >= row - rowOffset; r--) {
            if (r < 0 || r >= tiles.length) {
                continue;
            }
            for (var c = col; c >= col - colOffset; c--) {
                if (c < 0 || c >= tiles.length) {
                    continue;
                }
                if (r !== this.row || c !== this.col) {
                    tiles[r][c]._master = this;
                    if (this._children.indexOf(tiles[r][c]) === -1) {
                        this._children.push(tiles[r][c]);
                    }
                }
            }
        }
        return true;
    };
    /**
     * Clear children and child tile master setting
     */
    Tile.prototype.disassociateChildren = function () {
        this._children.map(function (t) {
            t._master = null;
        });
        this._children = [];
    };
    /**
     * Returns master if exists, otherwise null
     * @returns {Tile | Null}
     */
    Tile.prototype.getMaster = function () {
        return this._master || null;
    };
    Tile.prototype.clearMaster = function () {
        this._master = null;
    };
    Tile.prototype.getChildren = function () {
        return this._children || [];
    };
    /** Get group of master + children as array */
    Tile.prototype.getGroup = function () {
        var group = [];
        var master = this.getMaster();
        if (master) {
            group.push(master);
            master._children.map(function (c) {
                if (c != this) {
                    group.push(c);
                }
            });
        } else {
            group.push(this);
            this._children.map(function (c) {
                group.push(c);
            });
        }
        return group;
    };
    Tile.prototype.createStructureSprites = function (building, gridOverride) {
        if (!this.col && !this.row && this.col !== 0 && this.row !== 0) {
            throw new Error("this tile needs row and col defined first");
        }
        if (!building) {
            console.warn("building was not supplied to (createStructureSprites)");
            return;
        }
        // Create higher layer structure group
        //this.resize(Tile.TILE_WIDTH, this.col, this.row);
        this.structureGroup = new StructureSprite(this.city, this.x, this.y, building.sizeRow, building.sizeCol, this);
        var grid = gridOverride || this.city.grids.structureGrid;
        grid.setTile(this.row, this.col, this.structureGroup);
        this.city.forceTransformStructures();
        // At this point, structuregroup and mask is resized to work for inserting into structure layer properly
        this.structureGroup.addToStructureLayer();
        // Reference to self
        return this.structureGroup;
    };
    /**
     * Move this tile's structure sprite to proper position, based on this base
     */
    Tile.prototype.scaleAndPositionStructure = function (forceRealSpriteResize) {
        if (forceRealSpriteResize === void 0) {
            forceRealSpriteResize = false;
        }
        if (!this.structureGroup) return;
        var width = Tile.BUILDING_WIDTH;
        if (this.building.sizeRow == 2 || this.building.sizeCol == 2) {
            width *= Tile.BUILDING_LARGE_MULT;
        }
        Utils.toFixedWidth(this.structureGroup, width);
        this.structureGroup.anchor.set(0.5);
        this.structureGroup.baseAnchorY = 0.5;
        var toX = this.x;
        var toY = this.y - this.height * Tile.BUILDING_Y_OFFSET_MULT;
        // Shift building based on size
        if (this.building.sizeRow == 2 || this.building.sizeCol == 2) {
            toY = this.y - this.height * 0.5;
            if (this.building.sizeRow == 2 && this.building.sizeCol == 2) {
                //
            } else {
                if (this.building.sizeCol == 2) {
                    // Double Col
                    toX -= Tile.BUILDING_LARGE_OFFSET_X;
                } else if (this.building.sizeRow == 2) {
                    // Double Row
                    toX += Tile.BUILDING_LARGE_OFFSET_X;
                }
            }
            toY -= this.height * Tile.BUILDING_Y_OFFSET_LARGE_MULT_ADDITIONAL;
        }
        this.structureGroup.x = toX;
        this.structureGroup.y = toY;
        this.structureGroup.baseSpriteY = toY;
        this.structureGroup.scale.x = this.scale.x * Tile.BUILDING_SCALE;
        this.structureGroup.scale.y = this.scale.y * Tile.BUILDING_SCALE;
        if (POST_STRUCTURE_RESIZE[this.building.sheet]) {
            POST_STRUCTURE_RESIZE[this.building.sheet](this);
        }
        if (this.city.headlessMode) {
            return;
        }
        var isHigh = this.structureGroup.syncUpperMask(forceRealSpriteResize);
        if (isHigh) {
            this.structureGroup.syncUpperMask(forceRealSpriteResize);
        }
    };
    Tile.prototype.createCentreChildSprite = function (atlas, frame) {
        var s = new Phaser.Sprite(this.city.game, 0, 0, atlas, frame);
        s.anchor.setTo(0.5);
        this.addChild(s);
        return s;
    };
    Tile.prototype._isNeighbourRoadTile = function (offset, variant) {
        if (variant === void 0) {
            variant = null;
        }
        var r = this.row + offset[0];
        var c = this.col + offset[1];
        if (Utils.isValidIndex(r, c, this.city.size)) {
            var offsetTile = this.city.grids.roadGrid.tiles[r][c];
            var isBridgeTile = offsetTile && offsetTile.variantType === variant;
            if (!isBridgeTile && this.city.isBuildingState()) {
                // secondary check during build state
                isBridgeTile = this.city.grids.buildGrid.tiles[r][c] && this.city.grids.buildGrid.tiles[r][c].variantType === variant;
            }
            return isBridgeTile;
        }
        return false;
    };
    Tile.prototype._isNeighbourBuildHighwayTile = function (offset) {
        var r = this.row + offset[0];
        var c = this.col + offset[1];
        if (Utils.isValidIndex(r, c, this.city.size)) {
            var t = this.city.grids.buildGrid.tiles[r][c];
            if (t instanceof RoadTile && t.variantType === Tile.Type.Highway) {
                return true;
            }
        }
        return false;
    };
    // tile usually dont move, so only actually update transform if city is dirty
    Tile.prototype.updateTransform = function () {
        if (this.city && this.city._shouldTransform && this.visible) {
            // decide whether to do full transform or just position
            if (this.city.scaleDirtyTransform) {
                // The only time a tile needs to be scaled is during bounce tweens
                _super.prototype.updateTransform.call(this);
            } else {
                this.updateTransformPosition();
            }
        }
    };
    Tile.prototype.forceTransform = function () {
        _super.prototype.updateTransform.call(this);
    };
    /**
     * Create a tile sprite
     * @param city {Phaser.Game}
     * @param tileType {Tile.Type}
     * @param [x] {Number} - Position
     * @param [y] {Number} - Position
     */
    Tile.createTileSprite = function (city, tileType, x, y) {
        if (x === void 0) {
            x = 0;
        }
        if (y === void 0) {
            y = 0;
        }
        var TileClass = Tile.getTileClass(tileType);
        if (TileClass) {
            return new TileClass(city, x, y);
        } else {
            console.error("No Tile Class to instantiate!");
            return null;
        }
    };
    /**
     * Returns the Class definition of a tile type constant
     * @param tileType {Tile.Type}
     */
    Tile.getTileClass = function (tileType) {
        switch (tileType) {
            case Tile.Type.Residential:
                return ResidentialTile;
            case Tile.Type.Commercial:
                return CommercialTile;
            case Tile.Type.Industrial:
                return IndustrialTile;
            case Tile.Type.Road:
                return RoadTile;
            case Tile.Type.Rubble:
                return RubbleTile;
            case Tile.Type.Structure:
                return StructureTile;
            case Tile.Type.Terrain:
                return TerrainTile;
            case Tile.Type.TerrainLower:
                return TerrainTileLower;
            case Tile.Type.White:
                return WhiteTile;
            case Tile.Type.Demolish:
                return DemolishTile;
            case Tile.Type.SkyRail:
                return SkyRailTile;
            case Tile.Type.Highway:
                return HighwayTile;
            case Tile.Type.Bridge:
                return BridgeTile;
            case Tile.Type.Water:
                return WhiteTile;
            case Tile.Type.Sand:
                return WhiteTile;
            case Tile.Type.Mountain:
                return WhiteTile;
            default:
                console.error("Didn't match any type of tiles");
                return null;
        }
    };
    Tile.getBuildingSheetName = function (t) {
        if (t && t.building && t.building.sheet) {
            return t.building.sheet;
        } else {
            return null;
        }
    };
    Tile.TEXTURE_BUILD = "none! should not be using this";
    Tile.TILE_WIDTH = Global.TILE_WIDTH;
    Tile.TILE_WIDTH_HALF = Global.TILE_WIDTH * 0.5;
    Tile.TILE_WIDTH_QUART = Global.TILE_WIDTH * 0.25;
    Tile.ZONE_TILE_AREA_PERCENT = 0.5 - 0.018; // Sizing for tiles
    Tile.BUILDING_WIDTH = 60 * 0.54;
    Tile.BUILDING_LARGE_MULT = 1.98;
    Tile.BUILDING_LARGE_OFFSET_X = 0.4;
    Tile.BUILDING_Y_OFFSET_MULT = 0.24;
    Tile.BUILDING_Y_OFFSET_LARGE_MULT_ADDITIONAL = 0.23;
    Tile.BUILDING_SCALE = 0.655;
    return Tile;
}(Phaser.Image);
(function (Tile) {
    var Type;
    (function (Type) {
        Type[Type["None"] = -1] = "None";
        Type[Type["Residential"] = 0] = "Residential";
        Type[Type["Commercial"] = 1] = "Commercial";
        Type[Type["Industrial"] = 2] = "Industrial";
        Type[Type["Road"] = 3] = "Road";
        Type[Type["Rubble"] = 4] = "Rubble";
        Type[Type["Ruler"] = 5] = "Ruler";
        Type[Type["Agricultural"] = 6] = "Agricultural";
        Type[Type["Structure"] = 7] = "Structure";
        Type[Type["StructureSprite"] = 8] = "StructureSprite";
        Type[Type["Terrain"] = 9] = "Terrain";
        Type[Type["White"] = 10] = "White";
        Type[Type["Demolish"] = 11] = "Demolish";
        Type[Type["Water"] = 12] = "Water";
        Type[Type["Sand"] = 13] = "Sand";
        Type[Type["SkyRail"] = 14] = "SkyRail";
        Type[Type["TerrainLower"] = 15] = "TerrainLower";
        Type[Type["Highway"] = 16] = "Highway";
        Type[Type["Shadow"] = 17] = "Shadow";
        Type[Type["Bridge"] = 18] = "Bridge";
        Type[Type["Lava"] = 19] = "Lava";
        Type[Type["Soil"] = 20] = "Soil";
        Type[Type["Upgrade"] = 21] = "Upgrade";
        Type[Type["Mountain"] = 22] = "Mountain";
        Type[Type["Grass"] = 23] = "Grass";
    })(Type = Tile.Type || (Tile.Type = {}));
    Tile.tileTypeUnlocks = (_a = {}, _a[Type.SkyRail] = Balance.SKYRAIL_UNLOCK, _a[Type.Upgrade] = Balance.UPGRADE_UNLOCK_LV, _a);
    Tile.isTileTypeUnlocked = function (city, tileType) {
        return !Tile.tileTypeUnlocks[tileType] || city.getLevelWithCentral() >= Tile.tileTypeUnlocks[tileType];
    };
    var _a;
})(Tile || (Tile = {}));
Tile.prototype.sizeMult = 1;
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * A tile that can have a structure sprite attached to it. Texture is a grey block.
 * @param city
 * @param x
 * @param y
 * @param tiletexture
 * @param frame
 * @constructor
 */
var WithBuildingTile = /** @class */function (_super) {
    __extends(WithBuildingTile, _super);
    function WithBuildingTile(city, x, y, tiletexture, frame, noSmoke) {
        var _this = _super.call(this, city, x, y, tiletexture, null, frame) || this;
        _this.zoneLevel = 1;
        // state
        _this.powerOverloaded = false;
        _this.notificationSprites = {
            overloaded: null,
            water: null,
            power: null,
            road: null,
            waterPower: null,
            all: null
        };
        _this._completed = false;
        _this._canDevelop = false;
        _this._priorityUpdate = false;
        _this._initTime = null; // Timestamp for building development start
        _this._nextSmokePuff = 0; // in seconds // -1 signals NO EFFECTS
        _this._cacheResourceStatus = {
            hasWater: null,
            hasPower: null,
            hasRoad: null,
            hasAll: null
        };
        _this._cachedDimensions = {
            sizeCol: 0,
            sizeRow: 0
        };
        _this.active = false;
        // construction sprites
        _this._constructionWorkers = [];
        // Small version sprites
        _this.structureGroupSm = null; // sm version, for zoom out
        _this._randomSpeed = Utils.randomInRange(0.9, 1.1);
        // Reset initial vars
        _this.resetState();
        if (!noSmoke) {
            _this.setSmokePuffRandomTime();
        }
        return _this;
    }
    WithBuildingTile.prototype.ensureSmallGroupExists = function () {
        // assumes texture has been loaded, called after texture has been loaded
        // creates structureGroupSm
        if (this.structureGroupSm || !this.structureGroup || !this.building) {
            return;
        }
        // this is just the default res frame:
        var frame = Utils.atlasFrame("structures/sm", "res-1x1-a");
        var smSprite = new Phaser.Sprite(this.city.game, this.structureGroup.x, this.structureGroup.y, "atlas-sm", frame);
        this.city.smallStructureLayer.add(smSprite);
        this.structureGroupSm = smSprite;
        this.syncSmStructure();
    };
    WithBuildingTile.prototype.syncSmStructure = function () {
        if (!this.structureGroupSm) return;
        var smSprite = this.structureGroupSm;
        var targetWidth = this.structureGroup.width;
        var crop = CROP_SETTINGS_FULL_FRAME[this.structureGroup.frameName];
        if (crop) {
            var percentMissing = crop[2] + crop[3];
            targetWidth = targetWidth / (1 - percentMissing);
        }
        Utils.scaleToWidth(smSprite, targetWidth);
        smSprite.x = this.structureGroup.x;
        smSprite.y = this.structureGroup.y;
        smSprite.anchor.setTo(0.5, 0.5);
        if (ANCHOR_STRUCT_OVERRIDE[this.structureGroup.frameName]) {
            smSprite.anchor.setTo(0.5, ANCHOR_STRUCT_OVERRIDE[this.structureGroup.frameName]);
        }
        var sheetPrefix = WithBuildingTile.SM_SHEET_PREFIX[this.structureGroup.key] || "";
        var sheet;
        if (sheetPrefix === "con-") {
            sheet = this.structureGroup.frameName.substr(this.structureGroup.frameName.length - 9, 5);
        } else {
            sheet = this.building.sheet;
        }
        sheet = StructureDefHelpers.resolveTrueSheet(sheet);
        this.structureGroupSm.frameName = Utils.atlasFrame("structures/sm", sheetPrefix + sheet);
    };
    WithBuildingTile.prototype.hasNightSprite = function () {
        return this.structureGroup.upperMaskSprite && this.structureGroup.upperMaskSprite && this.structureGroup.upperMaskSprite.nightSprite;
    };
    WithBuildingTile.prototype.isUpgraded = function () {
        return this.zoneLevel === 2;
    };
    WithBuildingTile.prototype.upgrade = function () {
        throw new Error("unimplemented");
    };
    /** Committed into play or is it just temporary? */
    WithBuildingTile.prototype.isComitted = function () {
        return this._canDevelop || this._completed;
    };
    //
    // Metadata
    //
    WithBuildingTile.prototype.getTitle = function () {
        var suffix = "";
        var scale = this.getStructureScale();
        return this.getTitleName() + (suffix ? suffix : "");
    };
    WithBuildingTile.prototype.getTitleName = function () {
        return "Structure";
    };
    WithBuildingTile.prototype.getDescription = function () {
        return "The description goes here";
    };
    WithBuildingTile.prototype.createsTraffic = function () {
        return true;
    };
    // Go transparent so that building does not obstruct pedestrian behind
    WithBuildingTile.prototype.shouldGoTransparentForPedTile = function (pedIndex) {
        var master = this._master ? this._master : this;
        if (!master.structureGroup || !master.structureGroup.upperMaskSprite) return false;
        var offsets = OBSTRUCTION_SETTINGS[master.structureGroup.upperMaskSprite.frameName.slice(29)];
        if (!offsets) return false;
        for (var i = 0; i < offsets.length; i++) {
            var affectedRow = offsets[i][0] + master.row;
            var affectedCol = offsets[i][1] + master.col;
            if (pedIndex.row === affectedRow && pedIndex.col === affectedCol) {
                return true;
            }
        }
        return false;
    };
    //
    // Resource detection
    //
    /** Updates resource missing icon + animate tint if a change was detected */
    WithBuildingTile.prototype.updateResourceSprites = function () {
        if (!this._completed) {
            return;
        }
        if (this._master) {
            return;
        }
        var hasWater = this.hasWater();
        var hasPower = this.hasPower();
        var hasRoad = this.hasRoad();
        var animtedTween = false;
        // 1. Check if we can create combo sprites (optimized)
        if (!hasWater && !hasPower && hasRoad) {
            // clear singles
            this._clearWater();
            this._clearPower();
            // clear all
            this._clearAll();
            // add combo sprite
            if (!this.notificationSprites.waterPower) {
                this.notificationSprites.waterPower = this.setNotificationSprite(this.city.cityUI.missingWaterPowerPool.allocate());
            }
        } else if (!hasWater && !hasPower && !hasRoad) {
            // clear singles
            this._clearWater();
            this._clearPower();
            this._clearRoad();
            // clear waterpower combo
            this._clearWaterPower();
            if (!this.notificationSprites.all) {
                this.notificationSprites.all = this.setNotificationSprite(this.city.cityUI.missingAllPool.allocate());
            }
        } else {
            // clear combination sprites
            this._clearWaterPower();
            this._clearAll();
            // Non-optimized single notifs
            if (hasWater) {
                if (this.notificationSprites.water) {
                    this._clearWater();
                    if (this.structureGroup && this.city.pocketCity.enableSpecialFX) {
                        this.city.cityEffects.blinkOnStructureTile(this, true);
                        animtedTween = true;
                    }
                }
            } else if (!this.notificationSprites.water) {
                this.notificationSprites.water = this.setNotificationSprite(this.city.cityUI.missingWaterPool.allocate());
            }
            if (hasPower) {
                if (this.notificationSprites.power) {
                    this._clearPower();
                    if (!animtedTween && this.structureGroup && this.city.pocketCity.enableSpecialFX) {
                        this.city.cityEffects.blinkOnStructureTile(this);
                    }
                }
            } else if (!this.notificationSprites.power) {
                this.notificationSprites.power = this.setNotificationSprite(this.city.cityUI.missingPowerPool.allocate());
            }
            if (hasRoad) {
                this._clearRoad();
            } else if (!this.notificationSprites.road) {
                this.notificationSprites.road = this.setNotificationSprite(this.city.cityUI.missingRoadPool.allocate());
            }
        }
        this._cacheResourceStatus.hasWater = hasWater;
        this._cacheResourceStatus.hasPower = hasPower;
        this._cacheResourceStatus.hasRoad = hasRoad;
        this._cacheResourceStatus.hasAll = hasWater && hasPower && hasRoad;
        this.updateResourceStatusSpritePositions();
        this.updateStructureGraphicSideEffects();
    };
    WithBuildingTile.prototype._clearWaterPower = function () {
        if (this.notificationSprites.waterPower) {
            this.notificationSprites.waterPower.free();
            this.notificationSprites.waterPower = null;
        }
    };
    WithBuildingTile.prototype._clearAll = function () {
        if (this.notificationSprites.all) {
            this.notificationSprites.all.free();
            this.notificationSprites.all = null;
        }
    };
    WithBuildingTile.prototype._clearWater = function () {
        if (this.notificationSprites.water) {
            this.notificationSprites.water.free();
            this.notificationSprites.water = null;
        }
    };
    WithBuildingTile.prototype._clearPower = function () {
        if (this.notificationSprites.power) {
            this.notificationSprites.power.free();
            this.notificationSprites.power = null;
        }
    };
    WithBuildingTile.prototype._clearRoad = function () {
        if (this.notificationSprites.road) {
            this.notificationSprites.road.free();
            this.notificationSprites.road = null;
        }
    };
    WithBuildingTile.prototype.updateStructureGraphicSideEffects = function () {
        if (!this.structureGroup) {
            return;
        }
        var resourceMissing = !this.hasWater() || !this.hasPower() || !this.hasRoad();
        if (resourceMissing || this.structureGroup.isOnFire) {
            this.setStructureTint(WithBuildingTile.DARK_TINT);
            this.structureGroup.hideEffects();
        } else {
            this.setStructureTint(0xffffff);
            this.structureGroup.showEffects();
        }
    };
    WithBuildingTile.prototype.spinRadialEffect = function () {
        var pos = {
            x: this.x,
            y: this.y
        };
        if (this._cachedDimensions.sizeRow > 1 || this._cachedDimensions.sizeCol > 1) {
            pos.y -= Tile.TILE_WIDTH * 0.75;
        } else if (this._cachedDimensions.sizeRow === 1 && this._cachedDimensions.sizeCol === 1) {
            pos.y -= Tile.TILE_WIDTH * 0.2;
        }
        this.city.cityEffects.spinRadial(pos, Tile.TILE_WIDTH * 4);
    };
    WithBuildingTile.prototype._resizeResourceSprite = function (s) {
        var spriteSize = WithBuildingTile.NOTIFICATION_SIZE;
        var width = WithBuildingTile.cachedFrameRatios[s.frameName];
        if (!width) {
            console.log("setting initial cached ratio for resource sprite");
            WithBuildingTile.cachedFrameRatios[s.frameName] = spriteSize * (s.width / s.height);
            width = WithBuildingTile.cachedFrameRatios[s.frameName];
        }
        s.width = width;
        s.height = spriteSize;
        s.anchor.setTo(0.5);
    };
    WithBuildingTile.prototype.updateResourceStatusSpritePositions = function () {
        var _this = this;
        if (!this.city) return;
        var structureXOffset = 0;
        var structureYOffset = -this.height * 0.15;
        if (this.structureGroup && this.structureGroup.leansLeft()) {
            structureXOffset = -this.width * 0.3;
            structureYOffset = -this.height * 0.4;
        } else if (this.structureGroup && this.structureGroup.leansRight()) {
            structureXOffset = this.width * 0.3;
            structureYOffset = -this.height * 0.4;
        } else if (this.structureGroup && this.structureGroup.isLargeStructure()) {
            structureYOffset = -this.height * 0.4;
        }
        var numNotifications = 0;
        var yOffset = 0.1 * this.city.getCachedTileSize();
        var sprites = this.notificationSprites;
        for (var k in sprites) {
            if (sprites.hasOwnProperty(k) && sprites[k]) {
                numNotifications += 1;
                this._resizeResourceSprite(sprites[k]);
            }
        }
        if (numNotifications === 0) {
            return;
        }
        var padding;
        var startX = null;
        var count = 0;
        Utils.foreachValInObject(this.notificationSprites, function (sprite) {
            sprite.y = _this.y + yOffset + structureYOffset;
            if (!padding) {
                padding = sprite.width * 0.2;
            }
            if (!startX) {
                startX = _this.x - (sprite.width * 0.5 + padding * 0.5) * numNotifications + sprite.width * 0.6;
            }
            sprite.x = startX + count * (sprite.width + padding) + structureXOffset;
            count += 1;
        });
    };
    WithBuildingTile.prototype.setNotificationSprite = function (sprite) {
        this._resizeResourceSprite(sprite);
        sprite.anchoredTile = this;
        this.city.resourceNotificationLayer.addChild(sprite);
        return sprite;
    };
    WithBuildingTile.prototype.requiresPower = function () {
        return true;
    };
    WithBuildingTile.prototype.requiresWater = function () {
        return true;
    };
    WithBuildingTile.prototype.hasWater = function () {
        var self = this;
        return !this.requiresWater() || this.isTrueForSelfOrChildren(function (r, c) {
            return self.city.resources.hasWater(r, c);
        });
    };
    WithBuildingTile.prototype.hasPower = function () {
        var self = this;
        return !this.requiresPower() || this.isTrueForSelfOrChildren(function (r, c) {
            return self.city.resources.hasPower(r, c);
        });
    };
    WithBuildingTile.prototype.hasRoad = function () {
        var _this = this;
        var sheet = this.getStructureSheet();
        if (sheet && STRUCTURES_DO_NOT_NEED_ROAD[sheet]) {
            return true;
        }
        return this.isTrueForSelfOrChildren(function (r, c) {
            return _this.city.resources.hasRoad(r, c);
        });
    };
    WithBuildingTile.prototype.getPowerLevel = function () {
        return this.city.grids.powerGrid.powerLevels[this.row][this.col];
    };
    WithBuildingTile.prototype.isOverloaded = function () {
        return this.powerOverloaded;
    };
    WithBuildingTile.prototype.isResourceSupplied = function () {
        return this.hasPower() && this.hasWater() && this.hasRoad();
    };
    WithBuildingTile.prototype.isTrueForSelfOrChildren = function (fn) {
        if (fn(this.row, this.col)) {
            return true;
        }
        var result = false;
        if (this._children && this._children.length > 0) {
            for (var i = 0; i < this._children.length; i++) {
                if (fn(this._children[i].row, this._children[i].col)) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    };
    WithBuildingTile.prototype.destroyNotificationSprites = function () {
        for (var k in this.notificationSprites) {
            if (this.notificationSprites.hasOwnProperty(k) && this.notificationSprites[k]) {
                this.notificationSprites[k].free();
                this.notificationSprites[k] = null;
            }
        }
    };
    WithBuildingTile.prototype.setStructureTint = function (t) {
        if (this.structureGroup) {
            this.structureGroup.tint = t;
            if (this.structureGroup.upperMaskSprite && this.structureGroup.upperMaskSprite.tint !== t) {
                this.structureGroup.upperMaskSprite.tint = t;
            }
        }
        if (this.structureGroupSm && this.structureGroupSm.tint !== t) {
            this.structureGroupSm.tint = t;
        }
    };
    WithBuildingTile.prototype.preDestroy = function () {
        this.destroyNotificationSprites();
        for (var i = 0; i < this._children.length; i++) {
            this._children[i].stopAnimateConstructionWorkers();
        }
        if (!this._completed && this._canDevelop) {
            this.city.grids.zoneGrid.dropInProgressTile(this);
        }
        var needsPowerRecalc = !this._master && this._completed && this.getPowerLevel() > 0;
        this.stopAnimateConstructionWorkers();
        this.stopAnimateBulldozer();
        if (needsPowerRecalc) {
            this.city.resources.recalculatePowerSoon(true);
        }
        this.city.smartUpdateNext();
        if (this.structureGroupSm) {
            this.structureGroupSm.destroy();
            this.structureGroupSm = null;
        }
        _super.prototype.preDestroy.call(this);
    };
    WithBuildingTile.prototype.destroy = function () {
        this.preDestroy();
        _super.prototype.destroy.call(this);
    };
    WithBuildingTile.prototype.resize = function (size, col, row) {
        _super.prototype.resize.call(this, size, col, row);
        this.updateResourceStatusSpritePositions();
    };
    /**
     * Set initial member values
     */
    WithBuildingTile.prototype.resetState = function () {
        this._completed = false;
        this._canDevelop = false;
        this._initTime = null; // Timestamp for building development start
        this.active = false; // Active flag, basically always active
        // Reset structure
        this.building = null;
        Utils.destroyIfAlive(this.structureGroup);
        // Set actual zone visible
        this.setVisible(true);
        this.zoneLevel = 1;
    };
    WithBuildingTile.prototype.preFree = function () {
        // used by pool
        this.resetState();
        this.setVisible(false);
        Utils.setKeysAllNull(this._cacheResourceStatus);
        // Similar to destroy
        this.preDestroy();
    };
    WithBuildingTile.prototype.getStructureSprite = function () {
        return this.structureGroup;
    };
    /**
     * Activate tile in game world (non build mode)
     */
    WithBuildingTile.prototype.start = function (scheduleDelay, ignoreEffects) {
        var _this = this;
        _super.prototype.start.call(this);
        if (this.row === -1 || this.col === -1) {
            throw new Error("start() called before tile was set / had its 2d index set!");
        }
        this.active = true;
        if (ignoreEffects) {
            this._nextSmokePuff = -1; // this is overloading yes, but saves memory
        }
        if (this._master) {
            // If this is a slave of another tile, just finish development
            this.finishDevelopment();
        } else {
            this.initAsMaster(scheduleDelay);
        }
        if (this.building && this.building.type === "waterstructure") {
            this.city.delayEventWithCityCheck(0, function () {
                _this.city.grids.terrainGrid.refreshDriveableWaterGrid();
            });
        }
        if (this.city.cityStructureScaler.shouldUseSmallStructure()) {
            this.ensureSmallGroupExists();
        }
    };
    WithBuildingTile.prototype.initAsMaster = function (scheduleDelay) {
        this.createStructureSprites();
        this.structureGroup._visibleAccessor(false);
        this.scheduleBuilding(scheduleDelay);
    };
    /** Get the current structures x by x dimensions, if any */
    WithBuildingTile.prototype.getStructureDimensions = function () {
        if (!this.building) {
            return null;
        }
        // cached so that a new object is not created each time
        this._cachedDimensions.sizeCol = this.building.sizeCol;
        this._cachedDimensions.sizeRow = this.building.sizeRow;
        return this._cachedDimensions;
    };
    /** Returns x by x multiplied */
    WithBuildingTile.prototype.getStructureScale = function () {
        var dim = this.getStructureDimensions();
        if (dim) {
            return dim.sizeCol * dim.sizeRow;
        } else {
            console.log("WARN: no dimensions for this tile!", this);
            return 0;
        }
    };
    WithBuildingTile.prototype.getStructureSheet = function () {
        if (!this.building) {
            return null;
        }
        return this.building.sheet;
    };
    /** Re-initialize a tile with building to start development again */
    WithBuildingTile.prototype.restart = function () {
        if (!this.city) return;
        this.resetState();
        // Disconnect current children
        this.disassociateChildren();
        // Restart everything and get new children
        this.start();
    };
    /**
     * Creates sprites for building
     * @param [gridOverride] {Grid}
     */
    WithBuildingTile.prototype.createStructureSprites = function (gridOverride) {
        return _super.prototype.createStructureSprites.call(this, this.building, gridOverride);
    };
    /**
     * Begin constructing building
     */
    WithBuildingTile.prototype.scheduleBuilding = function (scheduleDelay) {
        if (scheduleDelay === void 0) {
            scheduleDelay = 0;
        }
        // Start production after X millis - Very slight delay (hacky)
        var self = this;
        this.city.registerSafeTimeout(function () {
            // It's possible that the tile is immediately destroyed, so check here
            if (self.alive && self.structureGroup) {
                self.startDevelopment();
            }
        }, scheduleDelay);
    };
    /**
     * Returns the development speed of the tile between 0 and 1
     *  - Larger number is slower
     *  - Based on city factors
     * @returns {number}
     */
    WithBuildingTile.prototype.getDevelopmentSpeed = function () {
        var dimensions = this.getStructureDimensions();
        if (!dimensions) {
            return 0;
        }
        var divisor = dimensions.sizeRow * dimensions.sizeCol;
        var diff = divisor - 1;
        divisor = 1 + Global.LARGE_BUILDING_EXTRA_TIME * diff;
        return Global.BUILDING_SPEED_BASE / divisor * this._randomSpeed;
    };
    WithBuildingTile.maxTwoTileBuildTime = function (isSandBox) {
        var divisor = 1 + Global.LARGE_BUILDING_EXTRA_TIME * 2;
        var devSpeed = Global.BUILDING_SPEED_BASE / divisor * 1.1;
        var mult = isSandBox ? Global.ZONE_BUILD_BASE_DAYS_SANDBOX : Global.ZONE_BUILD_BASE_DAYS;
        return mult * 1000 / devSpeed;
    };
    /**
     * Start the development process
     * - Show building sprite
     * - Start building
     * - Set building state
     */
    WithBuildingTile.prototype.startDevelopment = function () {
        var city = this.city;
        var structureSprite = this.structureGroup;
        City.STRUCT_BASE_Y_CACHE[structureSprite.uid] = structureSprite.y;
        City.STRUCT_BASE_SCALE_CACHE[structureSprite.uid] = structureSprite.scale.x;
        this.showStructureSprite();
        structureSprite.initializeProgressBar();
        this._initTime = city.getTime();
        this._canDevelop = true;
        structureSprite.bounceEffect(-0.7, 800); // this can NOT be disabled for fx, otherwise buildings are offset!
        if (this._nextSmokePuff !== -1 && city.performance.shouldShowBuildEffects()) {
            this.largeSmokePuff();
        }
        this._priorityUpdate = true;
        // force construction sound to play if this is visible
        city.grids.zoneGrid.pushInProgressTile(this);
        structureSprite.visible = true;
        structureSprite.upperMaskSprite.visible = true;
        this.city.pushForcePrePostUpdateSprite(structureSprite);
        this.city.pushForcePrePostUpdateSprite(structureSprite.upperMaskSprite);
        // Special effects
        if (!this.city.pocketCity.enableSpecialFX || this._nextSmokePuff === -1) return;
        if (!this._children.length) {
            this.animateBulldozer();
        }
        this.animateConstructionWorkers();
    };
    //
    // Construction animation
    //
    WithBuildingTile.prototype.animateBulldozer = function () {
        this._bulldozer = new Bulldozer(this.city, { col: this.col, row: this.row });
        Utils.scaleIn(this.city.game, this._bulldozer, 300);
    };
    WithBuildingTile.prototype.stopAnimateBulldozer = function () {
        Utils.destroyIfAlive(this._bulldozer);
    };
    WithBuildingTile.prototype.animateConstructionWorkers = function () {
        var _this = this;
        // 1x1
        if (this._children.length === 0) {
            this._addConstructionWorker(this, 1, false);
        }
        if (this._children.length === 1) {
            // 1x2
            if (this._children[0].row === this.row - 1) {
                this._addConstructionWorker(this, 1, false, true);
            } else {
                this._addConstructionWorker(this, 1, false);
            }
        }
        // 2x2
        else if (this._children.length === 3) {
                this._children.forEach(function (c) {
                    if (c.row === _this.row && c.col !== _this.col) {
                        for (var i = 1; i <= 2; i++) {
                            _this._addConstructionWorker(c, i, true, i % 2 === 0);
                        }
                    } else if (c.row !== _this.row && c.col === _this.col) {
                        for (var i = 1; i <= 2; i++) {
                            _this._addConstructionWorker(c, i, false, i % 2 === 0);
                        }
                    }
                });
            }
    };
    ;
    WithBuildingTile.prototype._addConstructionWorker = function (base, zLayer, onLeft, flipStart) {
        if (zLayer === void 0) {
            zLayer = 1;
        }
        if (onLeft === void 0) {
            onLeft = true;
        }
        if (flipStart === void 0) {
            flipStart = false;
        }
        var c = new ConstructionMan(this.city, base);
        c.walkAroundTile(zLayer, onLeft, flipStart);
        this._constructionWorkers.push(c);
        return c;
    };
    WithBuildingTile.prototype.stopAnimateConstructionWorkers = function () {
        this._constructionWorkers.forEach(function (c) {
            return Utils.destroyIfAlive(c);
        });
    };
    ;
    WithBuildingTile.prototype.showStructureSprite = function () {
        if (this.city.headlessMode) {
            return;
        }
        var structureSprite = this.structureGroup;
        if (!structureSprite || this.city.headlessMode) {
            // not sure how this can happen, but maybe
            console.warn("tried to show structure sprite, but it does not exist. Building: " + this.building);
            return;
        }
        structureSprite.alpha = 1;
        structureSprite.upperMaskSprite.alpha = 1;
        structureSprite._visibleAccessor(true);
    };
    /**
     * Returns the current amount of development in tile between 0 and 1
     */
    WithBuildingTile.prototype.getDevelopmentPercent = function () {
        var mult = this.city.isSandbox ? Global.ZONE_BUILD_BASE_DAYS_SANDBOX : Global.ZONE_BUILD_BASE_DAYS;
        if (this.city.structureCache.getManufacturingLabs().length) {
            mult /= 2.5;
        }
        var millisTotal = mult * this.city.getMillisPerDay();
        return Math.min((this.city.getTime() - this._initTime) / millisTotal * this.getDevelopmentSpeed(), 1);
    };
    /**
     * Mark development as complete
     */
    WithBuildingTile.prototype.finishDevelopment = function () {
        var _this = this;
        this._completed = true;
        var structureGroup = this.structureGroup;
        if (structureGroup && !this.city.headlessMode) {
            if (this._nextSmokePuff !== -1 && this.city.pocketCity.enableSpecialFX) {
                // todo: test with enableSpecialFX on and off
                this.city.tempSmartUpdate(600);
                structureGroup.syncUpperMask();
                structureGroup.bounceEffect(-0.5, 600, null, false);
                if (this.city.performance.shouldShowBuildEffects()) {
                    this.largeSmokePuff();
                    this.city.cityEffects.blinkOnStructureTile(this);
                }
            } else {
                structureGroup.stopBounceEffect();
                if (structureGroup.upperMaskSprite) {
                    structureGroup.upperMaskSprite.scale.setTo(structureGroup.upperMaskSprite.scale.x);
                }
                structureGroup.scale.setTo(structureGroup.scale.x);
                // set base Y
                if (City.STRUCT_BASE_Y_CACHE.hasOwnProperty(structureGroup.uid)) {
                    structureGroup.y = City.STRUCT_BASE_Y_CACHE[structureGroup.uid];
                }
                if (City.STRUCT_BASE_SCALE_CACHE.hasOwnProperty(structureGroup.uid)) {
                    structureGroup.scale.setTo(City.STRUCT_BASE_SCALE_CACHE[structureGroup.uid]);
                }
                structureGroup.syncUpperMask();
            }
            this._priorityUpdate = false;
        }
        if (structureGroup) {
            delete City.STRUCT_BASE_Y_CACHE[structureGroup.uid];
            delete City.STRUCT_BASE_SCALE_CACHE[structureGroup.uid];
        }
        // only do this if this is a master
        if (!this._master) {
            this.updateResourceSprites();
            this.stopAnimateConstructionWorkers();
            this.stopAnimateBulldozer();
            // Resource related, only for Water and Power structures
            if (this.building && (this.building.type === "water" || this.building.type === "power")) {
                // recalculate both immediately - a power plant or water plant just finished
                if (this.building.type === "water") {
                    this.city.resources.recalculateWater(true);
                } else {
                    this.city.resources.recalculatePowerSoon(true);
                }
            } else {
                // just recalculate power, because regular buildings only drain power
                // water stays constant
                this.city.resources.recalculatePowerSoon(true);
            }
        }
        this.city.grids.zoneGrid.ensureTrackedUpdated(this);
        // only do this if this is a master
        if (!this._master) {
            if (!this._master && Utils.isOnScreen(this.city, this)) {
                AudioPC.playBuildingBounce();
            }
            if (this.structureGroup && !this.city.headlessMode) {
                this.city.delayEventWithCityCheck(1000, function () {
                    if (_this.structureGroup && _this.city.alive) {
                        _this.city.removeForcePrePostUpdateSprite(_this.structureGroup);
                        _this.city.removeForcePrePostUpdateSprite(_this.structureGroup.upperMaskSprite);
                    }
                });
            }
            this.city.eventSignal.dispatch("finish_development", this);
        }
        // clear force-disable FX
        if (this._nextSmokePuff === -1) {
            this._nextSmokePuff = 0;
        }
    };
    WithBuildingTile.prototype.isFinishedDevelopment = function () {
        return this._completed;
    };
    /**
     * Updates the building sprite based on percentage
     * @param percent {number} - between 0 to 1
     */
    WithBuildingTile.prototype.updateBuildingSprite = function (percent) {
        var structureSprite = this.structureGroup;
        var _prevFrame = structureSprite.frameName;
        structureSprite.setCompletionPercent(percent);
        var _newFrame = structureSprite.frameName;
        if (_prevFrame !== _newFrame && percent < 1) {
            if (this.city.pocketCity.enableSpecialFX) {
                structureSprite.bounceEffect(-0.6, 1500);
            } else {
                structureSprite.stopBounceEffect();
            }
            this.stopAnimateBulldozer();
            // First change, refresh construction crew
            if (percent < 0.4 && this._constructionWorkers.length > 0) {
                // destroy first construction guy
                var c = this._constructionWorkers.shift();
                Utils.destroyIfAlive(c);
                if (this.city.pocketCity.enableSpecialFX) {
                    // Shift construction man
                    // first change 1x1
                    if (this._children.length === 0) {
                        if (Math.random() < 0.5) {
                            this._addConstructionWorker(this, 2, true, true);
                        } else {
                            this._addConstructionWorker(this, 2, false);
                        }
                    }
                    // 1x2
                    else if (this._children.length === 1) {
                            if (this._children[0].row === this.row - 1) {
                                if (Math.random() < 0.5) {
                                    this._addConstructionWorker(this, 2, false);
                                } else {
                                    // one on left
                                    this._addConstructionWorker(this, 2, true);
                                }
                            } else {
                                if (Math.random() < 0.5) {
                                    // left and right inside
                                    this._addConstructionWorker(this, 2, false, true);
                                } else {
                                    // one on left
                                    this._addConstructionWorker(this, 2, true);
                                }
                            }
                        }
                }
            }
        }
        this.city.smartUpdateNext();
    };
    WithBuildingTile.prototype.setSmokePuffRandomTime = function () {
        if (Global.TEST_MODE) return;
        var nextDelta = 0.001 * Utils.randomInRange(WithBuildingTile.SMOKE_EVERY_X_MIN, WithBuildingTile.SMOKE_EVERY_X_MAX);
        var numTiles = this._children ? this._children.length + 1 : 1;
        nextDelta = nextDelta / numTiles;
        this._nextSmokePuff = this.game.time.totalElapsedSeconds() + nextDelta;
    };
    WithBuildingTile.prototype.updateBurst = function (percent) {
        if (Global.TEST_MODE || !this.city.pocketCity.enableSpecialFX || percent > 0.9) {
            // so that effect doesn't bleed into final completed sprite
            return;
        }
        if (this.structureGroup && this.structureGroup.visible && !this.city.isBuildingState() && !this.isFinishedDevelopment()) {
            // Show smoke puff anim
            this.updateRandomSmokePuff();
        }
    };
    WithBuildingTile.prototype.updateRandomSmokePuff = function () {
        if (this._nextSmokePuff === -1) return;
        // Show smoke puff anim
        if (this._nextSmokePuff < this.game.time.totalElapsedSeconds()) {
            var tiles = [this];
            if (this._children) {
                tiles = tiles.concat(this._children);
            }
            var tile = Utils.randomChoice(tiles);
            var pos = Utils.randomPosInTile(tile, this.city.cityScaler._cachedTileSize);
            if (this.city.performance.shouldShowBuildEffects()) {
                var s = this.city.cityEffects.smokePuff(pos, 1.2, null, 0.7, 0.8, 0.2);
                if (s && this.structureGroup && this.structureGroup.isOnFire) {
                    s.tint = WithBuildingTile.FIRE_SMOKE_TINT;
                }
            }
            this.setSmokePuffRandomTime();
        }
    };
    WithBuildingTile.prototype.largeSmokePuff = function () {
        var tiles = [this];
        if (this._children) {
            tiles = tiles.concat(this._children);
        }
        var tileSize = this.city.cityScaler._cachedTileSize;
        var pos;
        var tile;
        var offset;
        var puffs = WithBuildingTile.PUFF_OFFSETS.length;
        for (var i = 0, iMax = tiles.length; i < iMax; i++) {
            tile = tiles[i];
            pos = Utils.indexToPosition(tile.col, tile.row, tileSize);
            for (var j = 0; j < puffs; j++) {
                offset = WithBuildingTile.PUFF_OFFSETS[j];
                this.city.cityEffects.smokePuff(Utils.toPosition(pos.x + tileSize * offset[0], pos.y + tileSize * offset[1]), Utils.randomInRange(1.25, 1.5), 1500, 0.7, 0.25);
            }
        }
    };
    // Get spawns that aren't connected to each other
    WithBuildingTile.prototype.getDisjointedSpawns = function () {
        if (!this.city) {
            return [];
        }
        var roadIndexes = this.getTouchingRoadIndexes();
        var disjointedSpawns = [];
        var touched = {};
        for (var _i = 0; _i < roadIndexes.length; _i++) {
            var i = roadIndexes[_i];
            var isAlreadyTouched = touched[i.row + "x" + i.col];
            Utils.mapTouchingTiles(i.row, i.col, this.city.size, function (r, c) {
                touched[r + "x" + c] = true;
            });
            if (isAlreadyTouched) {
                continue;
            } else {
                disjointedSpawns.push(i);
            }
        }
        return disjointedSpawns;
    };
    // Get indexes where a vehicle can be spawned
    WithBuildingTile.prototype.getTouchingRoadIndexes = function () {
        if (!this.city) {
            return [];
        }
        if (this._master) {
            return this._master.getTouchingRoadIndexes();
        }
        var roadTiles = this.city.grids.roadGrid.tiles;
        var indices = {};
        var checkTiles = this._children.concat([this]);
        for (var i = 0; i < checkTiles.length; i++) {
            var tile = checkTiles[i];
            Utils.mapTouchingTiles(tile.row, tile.col, this.city.size, function (r, c) {
                if (roadTiles[r][c] && roadTiles[r][c].type === Tile.Type.Road) {
                    indices[r + "x" + c] = true;
                }
            });
        }
        return Object.keys(indices).map(function (i) {
            var s = i.split("x");
            return {
                row: +s[0],
                col: +s[1]
            };
        });
    };
    WithBuildingTile.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.active) {
            // Update development (already in progress)
            if (!this._completed && this._canDevelop) {
                var percent = this.getDevelopmentPercent();
                this.updateBuildingSprite(percent);
                if (percent >= 1) {
                    this.finishDevelopment();
                    // pushto latest built
                    if (this.type !== null) {
                        this.city.buildHelper.pushLatestBuilt(this.type, this);
                    }
                } else {
                    this.updateBurst(percent);
                }
            } else if (this.structureGroup && this.structureGroup.isOnFire) {
                // Show smoke puff when on fire
                this.updateRandomSmokePuff();
            }
        }
    };
    WithBuildingTile.applyBuildingCrop = function (cropKey, baseAnchorY, baseWidth, baseHeight, baseX, baseY, sprite) {
        var heightMult = 1;
        var widthMult = 1;
        var cropSetting = CROP_SETTINGS_FULL_FRAME[cropKey];
        if (cropSetting) {
            heightMult = 1 - cropSetting[1] - cropSetting[0];
            widthMult = 1 - cropSetting[3] - cropSetting[2];
        }
        sprite.width = baseWidth;
        var maskHeight = 0;
        var maskWidth = 0;
        if (baseHeight !== null && baseHeight !== undefined) {
            maskHeight = baseHeight * heightMult;
            sprite.height = maskHeight;
            if (sprite.hasOwnProperty("sortHeight")) {
                sprite.sortHeight = baseHeight;
            }
        }
        if (baseWidth !== null && baseWidth !== undefined) {
            maskWidth = baseWidth * widthMult;
            sprite.width = maskWidth;
        }
        if (sprite.hasOwnProperty("baseSpriteY")) {
            sprite.baseSpriteY = baseY;
        }
        if (sprite.hasOwnProperty("baseAnchorY")) {
            sprite.baseAnchorY = baseAnchorY;
        }
        sprite.x = baseX;
        sprite.y = baseY;
        if (cropSetting) {
            // adjust for crop
            var targetY = baseAnchorY * baseHeight;
            var maskStartY = baseHeight * cropSetting[0];
            var maskOffsetY = targetY - maskStartY;
            var finalAnchorY = maskOffsetY / maskHeight;
            var targetX = 0.5 * baseWidth;
            var maskStartX = baseWidth * cropSetting[2];
            var maskOffsetX = targetX - maskStartX;
            var finalAnchorX = maskOffsetX / maskWidth;
            sprite.anchor.setTo(finalAnchorX, finalAnchorY);
        } else {
            sprite.anchor.setTo(0.5, 0.5);
        }
    };
    WithBuildingTile.ATLAS_STRUCTURES = _ATLAS_STRUCTURES;
    WithBuildingTile.BURST_EVERY_X_MIN = 1000; // in millis
    WithBuildingTile.BURST_EVERY_X_MAX = 1500;
    WithBuildingTile.SMOKE_EVERY_X_MIN = 1000; // in millis
    WithBuildingTile.SMOKE_EVERY_X_MAX = 1500;
    WithBuildingTile.BURST_SIZE = 0.6;
    WithBuildingTile.BUILD_SIZE_SCALE_ADDITIONAL = 0.03;
    WithBuildingTile.BUILD_SIZE_OFFSET = 0.15;
    WithBuildingTile.DARK_TINT = 0x999999;
    WithBuildingTile.NOTIFICATION_SIZE = 0.3 * Tile.TILE_WIDTH;
    WithBuildingTile.FIRE_SMOKE_TINT = 0x555555;
    /** A smoke puff that covers the whole buildtile for a second */
    WithBuildingTile.PUFF_OFFSETS = [[0.35, 0.25], [-0.35, 0.25]];
    WithBuildingTile.SM_SHEET_PREFIX = {
        "atlas-residential": "res-",
        "atlas-commercial": "com-",
        "atlas-industrial": "ind-",
        "atlas-residential-u": "res-u-",
        "atlas-commercial-u": "com-u-",
        "atlas-industrial-u": "ind-u-",
        "atlas-construction": "con-"
    };
    WithBuildingTile.cachedFrameRatios = {};
    return WithBuildingTile;
}(Tile);
WithBuildingTile.prototype.isWithBuildingTile = true;
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * ZoneTile
 * @param city
 * @param x
 * @param y
 * @param zoneTexture {String} - Zone texture
 * @constructor
 */
var ZoneTile = /** @class */function (_super) {
    __extends(ZoneTile, _super);
    function ZoneTile() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ZoneTile.createStructureSizeCounts = function () {
        return {
            "1_1": 0, "1_2": 0, "2_1": 0, "2_2": 0
        };
    };
    ZoneTile.prototype.getCost = function () {
        return Global.HEAVY_COST_MULTIPLIER * this.baseCost;
    };
    ZoneTile.prototype.updateStructureCount = function (key, amount) {
        var countObj = this.getSizeInitCounts();
        if (countObj.hasOwnProperty(key)) {
            countObj[key] += amount;
        } else {
            countObj[key] = amount;
        }
    };
    ZoneTile.prototype.upgrade = function () {
        if (this.zoneLevel === 2) {
            console.warn("tried to upgrade an already upgraded zone");
            return;
        }
        if (this._master) {
            console.warn("upgrading a non-master");
        }
        // reset and start, without diassociating children
        this.resetState();
        this.zoneLevel = 2;
        var size = "1_1";
        if (this._children.length == 3) {
            size = "2_2";
        } else if (this._children.length == 1) {
            if (this._children[0].row == this.row - 1) {
                size = "2_1";
            } else {
                size = "1_2";
            }
        }
        this.active = true;
        this.initAsMaster(0, size, false);
        this.structureGroup.clearUpperStructureEffects();
        this.structureGroup.refreshUpperStructureEffects();
        this.syncSmStructure();
    };
    ZoneTile.prototype.initAsMaster = function (scheduleDelay, forceOptionSizeStr, startChildren) {
        if (startChildren === void 0) {
            startChildren = true;
        }
        var maxRows = 1;
        var maxCols = 1;
        // Determine random size of this building based on constraints
        var options = ["1_1"];
        if (this.canBeDoubleSized()) {
            maxRows = 2;
            maxCols = 2;
            options = ["1_1", "1_2", "2_1", "2_2"];
        } else if (this.canBeDoubleRow()) {
            maxRows = 2;
            options = ["1_1", "2_1"];
        } else if (this.canBeDoubleCol()) {
            maxCols = 2;
            options = ["1_1", "1_2"];
        }
        var possibleOptions = {};
        var structureSizeCounts = this.getSizeInitCounts();
        if (forceOptionSizeStr) {
            options = [forceOptionSizeStr];
        }
        options.forEach(function (key) {
            possibleOptions[key] = structureSizeCounts[key];
        });
        var sizeChoice = Utils.randomKeyChoiceFavorUnchosen(possibleOptions);
        var spl = sizeChoice.split("_");
        var sizeCol = +spl[1];
        var sizeRow = +spl[0];
        // This part controls frequency of different sizes being used
        var updateAmt = 1;
        if (sizeChoice === "2_1" || sizeChoice === "1_2") {
            updateAmt = 4;
        } else if (sizeChoice === "2_2") {
            updateAmt = 8;
        }
        this.updateStructureCount(sizeChoice, updateAmt);
        if (Global.DEBUG_ALWAYS_FILL) {
            sizeCol = maxCols;
            sizeRow = maxRows;
        }
        this.building = this.getBuildingToInitialize(sizeRow, sizeCol);
        if (!this.building) {
            throw Error("Could not instantiate tile structure! Correct size not found: col = " + sizeCol + ", row = " + sizeRow);
        }
        if (startChildren) {
            // Make neighbours child of this one if large building
            this.addNeighboursBasedOnBuilding();
            // start all children
            this._children.map(function (c) {
                c.start();
            });
        }
        this.createStructureSprites();
        this.scheduleBuilding(scheduleDelay);
        this.structureGroup._visibleAccessor(false);
    };
    ZoneTile.prototype.incrementUsage = function (sheet, upgraded, type) {
        var key = type + "-" + sheet;
        var counter = upgraded ? this.city._usageCountUpgraded : this.city._usageCount;
        counter[key] = counter[key] ? counter[key] + 1 : 1;
    };
    // Sheet usage
    ZoneTile.prototype.getUsageCount = function (upgraded) {
        if (upgraded === void 0) {
            upgraded = false;
        }
        if (upgraded) {
            return this.city._usageCountUpgraded || {};
        } else {
            return this.city._usageCount || {};
        }
    };
    // Get structure to initialize based on least used order
    // Returns sheet string (e.g. "1x1-a", "1x1-b")
    ZoneTile.prototype.getBuildingToInitialize = function (sizeRow, sizeCol) {
        var _this = this;
        if (!sizeRow || !sizeCol) {
            throw new Error("invalid sizeRow " + sizeRow + " or sizeCol " + sizeCol + " received");
        }
        var folder = this.ATLAS_FOLDER;
        var texture = this.ATLAS_TEXTURE;
        if (this.zoneLevel === 2) {
            folder = this.UPGRADE_ATLAS_FOLDER;
            texture = this.UPGRADE_ATLAS_TEXTURE;
        }
        var sizeStr = sizeCol + "x" + sizeRow;
        var prefix = sizeStr + "-";
        var possibleBuildingSheets = Utils.copyShallowList(WithBuildingTile.ATLAS_STRUCTURES[folder][sizeStr]); // creates a copy
        var _max = possibleBuildingSheets.length;
        for (var i = 0; i < _max; i++) {
            possibleBuildingSheets[i] = prefix + possibleBuildingSheets[i];
        }
        // Try to avoid using building of nearby neighbors
        var nearbyBuildings = this.getNearbyBuildings(this.type);
        var nonNearbyPossibilities = possibleBuildingSheets.filter(function (sheet) {
            return nearbyBuildings.indexOf(sheet) === -1;
        });
        possibleBuildingSheets = nonNearbyPossibilities.length > 0 ? nonNearbyPossibilities : possibleBuildingSheets;
        var usage = this.getUsageCount(this.isUpgraded());
        var min = -1;
        possibleBuildingSheets.map(function (sheet) {
            var usageKey = _this.type + "-" + sheet;
            if (usage.hasOwnProperty(usageKey)) {
                var thisCount = usage[usageKey];
                min = min === -1 ? thisCount : Math.min(min, thisCount);
            } else {
                min = 0;
            }
        });
        possibleBuildingSheets = possibleBuildingSheets.filter(function (sheet) {
            var key = _this.type + "-" + sheet;
            return min === 0 ? !usage.hasOwnProperty(key) : usage[key] === min;
        });
        var sheet = possibleBuildingSheets.sort()[0];
        if ((sheet.match(/-/g) || []).length > 1) {
            console.log("more than one sheet - found");
        }
        this.incrementUsage(sheet, this.isUpgraded(), this.type);
        // prefer alphanumeric when usage is 0
        return {
            "atlas-folder": folder,
            "atlas-texture": texture,
            "sheet": sheet,
            "sizeCol": sizeCol,
            "sizeRow": sizeRow,
            "cost": 0,
            "type": "default"
        };
    };
    /** Make neighbours child of this one if large building */
    ZoneTile.prototype.addNeighboursBasedOnBuilding = function () {
        if (!this.building) return;
        if (this.building.sizeCol == 2 && this.building.sizeRow == 2) {
            this.addChildNeighbours(1, 1);
        } else if (this.building.sizeCol == 2) {
            this.addChildNeighbours(1, 0);
        } else if (this.building.sizeRow == 2) {
            this.addChildNeighbours(0, 1);
        }
    };
    ZoneTile.prototype.getNearbyBuildings = function (type, excludeTiles) {
        var _this = this;
        if (excludeTiles === void 0) {
            excludeTiles = [];
        }
        var buildings = [];
        var myZoneLevel = this.zoneLevel;
        // Loop over touching tiles
        Utils.mapDirections(function (row, col) {
            var isExcluded = false;
            excludeTiles.map(function (tile) {
                if (tile.row == row && tile.col == row || tile.zoneLevel != myZoneLevel) {
                    isExcluded = true;
                }
            });
            if (isExcluded) {
                return;
            }
            var tileRow = _this.row + row;
            var tileCol = _this.col + col;
            if (!Utils.isValidIndex(tileRow, tileCol, _this.city.size)) {
                return;
            }
            var t = _this.city.grids.zoneGrid.tiles[tileRow][tileCol];
            if (!t) {
                return;
            }
            // is another master
            if (!t._master && t.building && t.type === type) {
                buildings.push(t.building.sheet);
            }
            // is other master's child
            else if (t._master && t._master !== _this && t.type === type && t._master.building) {
                    // Get master of child
                    buildings.push(t._master.building.sheet);
                }
                // is
                else if (t._master === _this) {
                        // Get child neighbors
                        buildings = buildings.concat(t.getNearbyBuildings(type, excludeTiles));
                    }
        });
        return buildings;
    };
    /**
     * Returns whether or not this tile can be started as a double sized structure, according to neighbours
     * @returns {boolean}
     */
    ZoneTile.prototype.canBeDoubleSized = function () {
        var tiles = this.city.grids.zoneGrid.tiles;
        var col = this.col;
        var row = this.row;
        for (var r = row; r >= row - 1; r--) {
            for (var c = col; c >= col - 1; c--) {
                if (r < 0 || c < 0) {
                    return false;
                }
                if (c != col || r != row) {
                    if (c >= tiles.length || r >= tiles.length) {
                        return false;
                    }
                    var neighbor = tiles[r][c];
                    if (!neighbor || neighbor.type != this.type || neighbor.active) {
                        return false;
                    }
                }
            }
        }
        return true;
    };
    ZoneTile.prototype.canBeDoubleCol = function () {
        var tiles = this.city.grids.zoneGrid.tiles;
        if (this.col == 0) console.log("cannot be doubler col, col == 0");
        if (this.col == 0) return false;
        var tile = tiles[this.row][this.col - 1];
        return tile && tile.type == this.type && !tile.active;
    };
    ZoneTile.prototype.canBeDoubleRow = function () {
        var tiles = this.city.grids.zoneGrid.tiles;
        if (this.row == 0) return false;
        var tile = tiles[this.row - 1][this.col];
        return tile && tile.type == this.type && !tile.active;
    };
    ZoneTile.prototype.destroy = function () {
        if (this.structureGroup) {
            Utils.destroyIfAlive(this.structureGroup);
            this.structureGroup = null;
        }
        if (this.city) {
            this.city.signalOncePostUpdate("zones_updated");
            _super.prototype.destroy.call(this);
        }
    };
    ZoneTile.STRUCTURE_SIZE_INIT_COUNTS = {};
    return ZoneTile;
}(WithBuildingTile);
ZoneTile.prototype.ATLAS_FOLDER = "structures/residential"; // default
ZoneTile.prototype.ATLAS_TEXTURE = "atlas-residential"; // default
ZoneTile.prototype.UPGRADE_ATLAS_FOLDER = "structures/residential-u"; // default
ZoneTile.prototype.UPGRADE_ATLAS_TEXTURE = "atlas-residential-u"; // default
ZoneTile.prototype.baseCost = 0; // child should override
ZoneTile.prototype.isZoneTile = true;
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Road tile
 */
var RoadTile = /** @class */function (_super) {
    __extends(RoadTile, _super);
    function RoadTile(city, x, y, sheet) {
        if (sheet === void 0) {
            sheet = RoadTile.BOUND_TEXTURES.SPRITESHEET;
        }
        var _this = _super.call(this, city, x, y, sheet) || this;
        _this.boundTextures = RoadTile.BOUND_TEXTURES;
        _this.frameName = "src/www/img-atlas/tiles/road-loading.png";
        _this.type = Tile.Type.Road;
        return _this;
    }
    /** Reduction specifically at this tile */
    RoadTile.prototype.congestionReduction = function () {
        var reduction = 0;
        if (this.city.busStopLayer.coverageGrid[this.row][this.col]) {
            reduction += BusStopLayer.TRAFFIC_REDUCTION_BUS;
        }
        if (this.city.trafficDensity.parkingGarageCoverageBool[this.row][this.col]) {
            reduction += TrafficDensity.PARKING_GARAGE_REDUCE_PER_TILE;
        }
        if (this.city.trafficDensity.highwayConnectedBool[this.row][this.col]) {
            reduction += TrafficDensity.HIGHWAY_INTERSECTION_REDUCE;
        }
        return reduction;
    };
    RoadTile.prototype.conductsResources = function () {
        return true;
    };
    RoadTile.prototype.destroy = function (forceDestroy) {
        this.visible = false;
        this.noCull = true;
        this.destroyDependencies();
        if (this.parent) {
            this.parent.removeChild(this);
        }
        // clear any parked cars
        this.city.roadGraph.destroyParkedCarsAtTile(this.row, this.col);
        if (forceDestroy) {
            _super.prototype.destroy.call(this);
            return;
        }
        // danger when overwriting road tile destroy to auto free - ensure we keep var to track if it truly has been freed
        // return self to pool
        this.city.roadTilePool.free(this);
    };
    RoadTile.prototype.getCost = function () {
        return Global.COSTS.ROAD_TILE;
    };
    RoadTile.BOUND_TEXTURES = function (atlas, basePath) {
        return {
            "SPRITESHEET": atlas,
            "DOWN_FRAME": basePath + "-bottom.png",
            // don't change this one - shifts too much
            "OPEN_BOTTOM_RIGHT_FRAME": basePath + "-open-bottom-right.png",
            "LEFT_FRAME": basePath + "-left.png",
            "SINGLE_FRAME": basePath + "-single.png",
            "OPEN_FRAME": basePath + "-open-all.png",
            "HORIZONTAL_FRAME": basePath + "-horizontal.png",
            "CLOSED_BOTTOM_FRAME": basePath + "-closed-bottom.png",
            "CLOSED_LEFT_FRAME": basePath + "-closed-left.png",
            "OPEN_TOP_LEFT_FRAME": basePath + "-open-top-left.png",
            "OPEN_BOTTOM_LEFT_FRAME": basePath + "-open-bottom-left.png",
            "MIRRORS": {
                "VERTICAL_FRAME": basePath + "-horizontal.png",
                "RIGHT_FRAME": basePath + "-bottom.png",
                "CLOSED_RIGHT_FRAME": basePath + "-closed-bottom.png",
                "UP_FRAME": basePath + "-left.png",
                "OPEN_TOP_RIGHT_FRAME": basePath + "-open-bottom-left.png",
                "CLOSED_TOP_FRAME": basePath + "-closed-left.png"
            }
        };
    }("atlas-tiles", "src/www/img-atlas/tiles/road");
    return RoadTile;
}(Tile);
Utils.extend(RoadTile.prototype, TileWithBoundedTexture);
/**
 * Structure sprite for structure tiles
 * @param city {City}
 * @param x {Number}
 * @param y {Number}
 * @param texture {String}
 * @constructor
 */
var Structure = function Structure(city, x, y, texture) {
    /*
    if (!city instanceof City) throw new Error("city is not a City instance!");
    Phaser.Sprite.call(this, city.game, x, y, texture);
    this.texture = texture;
    this.city = city;
    this.resizeFn = null;
    this.anchor.setTo(0.5);
    */
};
Structure.prototype = Object.create(Phaser.Sprite.prototype);
Structure.prototype.constructor = Structure;
Structure.sheet = "";
Structure.sizeRow = 2; // Default ROWS
Structure.sizeCol = 2; // Default COLS
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var TileWithMask = /** @class */function (_super) {
    __extends(TileWithMask, _super);
    function TileWithMask() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TileWithMask.prototype.destroy = function () {
        Utils.destroyIfAlive(this.upperMask);
        _super.prototype.destroy.call(this);
    };
    return TileWithMask;
}(Tile);
Utils.extend(TileWithMask.prototype, WithTileUpperMaskMixin);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
/**
 * Terrain tile / Water Tile
 *
 * Constants defined after class
 */
var TerrainTile = /** @class */function (_super) {
    __extends(TerrainTile, _super);
    function TerrainTile(city, x, y, fixedFrame) {
        var _this = _super.call(this, city, x, y, "atlas-terrain", null, fixedFrame || Utils.atlasFrame("structures/terrain", TerrainTile.randomTerrainNum(city.rng))) || this;
        _this.type = Tile.Type.Terrain;
        var randomPercent2 = city.rng.nextRange(1, 100) * 0.01;
        var randomPercent3 = city.rng.nextRange(1, 100) * 0.01;
        _this.oX = randomPercent2 * TerrainTile.POS_OFFSET_RAND * (randomPercent3 > 0.5 ? -1 : 1);
        _this.oY = randomPercent2 * TerrainTile.POS_OFFSET_RAND * (randomPercent3 > 0.5 ? -1 : 1);
        return _this;
    }
    TerrainTile.randomTerrainNum = function (rng) {
        // Initialize random frame
        var randomPercent = rng.nextRange(1, 100) * 0.01;
        var frameNum = 1 + Math.floor(randomPercent * (TerrainTile.FRAMES - 0.01));
        if (frameNum === 0) {
            frameNum = 1; // somehow this ends up 0 sometimes (wtf)
        }
        return frameNum;
    };
    TerrainTile.prototype.setDesertType = function () {
        this.frameName = Utils.randomChoice(['src/www/img-atlas/structures/terrain/desert-cactus.png', 'src/www/img-atlas/structures/terrain/desert-palm-tree.png', 'src/www/img-atlas/structures/terrain/3.png', 'src/www/img-atlas/structures/terrain/4.png'], this.city.grids.terrainGrid.rng);
    };
    // Custom terrains
    TerrainTile.prototype.setPalmTree = function () {
        this.frameName = 'src/www/img-atlas/structures/terrain/desert-palm-tree.png';
        this.oX = 0;
        this.oY = 0;
    };
    // forest use terrainGrid.setForestTile();
    TerrainTile.prototype.forceNotRock = function () {
        var frameNum = Utils.randomChoice([1, 2, 5, 6]);
        this.frameName = Utils.atlasFrame("structures/terrain", frameNum);
    };
    TerrainTile.prototype.resize = function (size, col, row) {
        _super.prototype.resize.call(this, size, col, row);
        // Override because we want to apply additional offset
        this.x += this.oX * this.width;
        this.y += this.oY * this.height;
    };
    TerrainTile.FRAMES = 5; // range 1 - 4 used in rand to determine random frame
    TerrainTile.POS_OFFSET_RAND = 0.04;
    return TerrainTile;
}(Tile);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var TerrainWithMask = /** @class */function (_super) {
    __extends(TerrainWithMask, _super);
    function TerrainWithMask() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TerrainWithMask.prototype.destroy = function () {
        Utils.destroyIfAlive(this.upperMask);
        _super.prototype.destroy.call(this);
    };
    return TerrainWithMask;
}(TerrainTile);
Utils.extend(TerrainWithMask.prototype, WithTileUpperMaskMixin);
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var Mountain = /** @class */function (_super) {
    __extends(Mountain, _super);
    function Mountain() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.size = Tile.TILE_WIDTH;
        _this.canBeDestroyed = true;
        _this.type = Tile.Type.Mountain;
        return _this;
    }
    Mountain.prototype.resize = function (size, col, row) {
        // scale and position
        Utils.scaleToWidth(this, this.fullWidth);
        this.setPositionByIndex(col, row);
        this.y -= this.yOffset;
        this.x += this.xOffset;
        this.syncUpperMask();
    };
    Mountain.prototype.destroy = function () {
        if (this.canBeDestroyed) {
            if (this.city) {
                this.city.signalOncePostUpdate("mountain_destroyed");
            }
            _super.prototype.destroy.call(this);
        }
    };
    return Mountain;
}(TerrainWithMask);
//
// Mountain implementations
//
// Is actually a 3x3 sprite
// is up to terrainGrid to determine which tiles are covered by mountain
var Volcano = /** @class */function (_super) {
    __extends(Volcano, _super);
    function Volcano(city, x, y) {
        var _this = _super.call(this, city, x, y, Utils.atlasFrame("structures/terrain", "volcano-3x3")) || this;
        _this.dimensionSize = Volcano.DIM;
        _this.fullWidth = Tile.TILE_WIDTH * 6.25; // IDE says this isn't used, but it IS used in parent class
        _this.yOffset = Tile.TILE_WIDTH * 2.6;
        _this.xOffset = Tile.TILE_WIDTH * 0.2;
        _this.initializeUpperMask();
        _this.canBeDestroyed = false;
        return _this;
    }
    Volcano.DIM = 3;
    return Volcano;
}(Mountain);
// Is actually a 3x3 sprite
// is up to terrainGrid to determine which tiles are covered by mountain
var MountainExtraLarge = /** @class */function (_super) {
    __extends(MountainExtraLarge, _super);
    function MountainExtraLarge(city, x, y) {
        var _this = _super.call(this, city, x, y, Utils.atlasFrame("structures/terrain", "mountain-3x3")) || this;
        _this.dimensionSize = MountainExtraLarge.DIM;
        _this.fullWidth = Tile.TILE_WIDTH * 6.25;
        _this.yOffset = Tile.TILE_WIDTH * 2.6;
        _this.xOffset = Tile.TILE_WIDTH * 0.2;
        _this.initializeUpperMask();
        return _this;
    }
    MountainExtraLarge.DIM = 3;
    return MountainExtraLarge;
}(Mountain);
var MountainLarge = /** @class */function (_super) {
    __extends(MountainLarge, _super);
    function MountainLarge(city, x, y) {
        var _this = _super.call(this, city, x, y, Utils.atlasFrame("structures/terrain", "mountain-2x2")) || this;
        _this.dimensionSize = MountainLarge.DIM;
        _this.fullWidth = Tile.TILE_WIDTH * 4.25;
        _this.yOffset = Tile.TILE_WIDTH * 1.6;
        _this.xOffset = Tile.TILE_WIDTH * 0.1;
        _this.initializeUpperMask();
        return _this;
    }
    MountainLarge.DIM = 2;
    return MountainLarge;
}(Mountain);
var MountainSmall = /** @class */function (_super) {
    __extends(MountainSmall, _super);
    function MountainSmall(city, x, y) {
        var _this = _super.call(this, city, x, y, Utils.atlasFrame("structures/terrain", "mountain-1x1")) || this;
        _this.dimensionSize = MountainSmall.DIM;
        _this.fullWidth = Tile.TILE_WIDTH * 1.7;
        _this.yOffset = Tile.TILE_WIDTH * 0.22;
        _this.xOffset = Tile.TILE_WIDTH * 0.1;
        _this.initializeUpperMask();
        return _this;
    }
    MountainSmall.DIM = 1;
    return MountainSmall;
}(Mountain);
(function (Mountain) {
    var SIZES;
    (function (SIZES) {
        SIZES[SIZES["SMALL"] = 0] = "SMALL";
        SIZES[SIZES["MED"] = 1] = "MED";
        SIZES[SIZES["LG"] = 2] = "LG";
        SIZES[SIZES["VOLCANO"] = 3] = "VOLCANO";
    })(SIZES = Mountain.SIZES || (Mountain.SIZES = {}));
    /**
     *  Call on set small, and when small exists + mountain is created
     */
    function ensureAllMountainsMovedToSmLayer(city) {
        var moved = 0;
        var children = city.grids.terrainGrid.children;
        var t;
        for (var i = children.length - 1; i >= 0; i--) {
            t = children[i];
            if (t instanceof Mountain) {
                if (t.upperMask && t.upperMask.parent !== city.zoomoutMountainLayer) {
                    city.zoomoutMountainLayer.addChild(t.upperMask);
                    moved += 1;
                }
            }
        }
        if (moved > 0) {
            city.zoomoutMountainLayer.customSort(WithGroupDepthSortMixin._sortGroupDepthCustomSort, city.zoomoutMountainLayer);
        }
    }
    Mountain.ensureAllMountainsMovedToSmLayer = ensureAllMountainsMovedToSmLayer;
    function ensureAllMountainsMovedToBaseLayer(city) {
        var children = city.zoomoutMountainLayer.children;
        var needsRefresh = children.length > 0;
        for (var i = children.length - 1; i >= 0; i--) {
            city.upperStructureLayer.addChild(children[i]);
        }
        if (needsRefresh) {
            city.upperStructureLayer.sortGroupDepth();
        }
    }
    Mountain.ensureAllMountainsMovedToBaseLayer = ensureAllMountainsMovedToBaseLayer;
    function checkShouldMoveMountainToSm(city) {
        if (city.cityStructureScaler.shouldUseSmallStructure()) {
            ensureAllMountainsMovedToSmLayer(city);
        }
    }
    Mountain.checkShouldMoveMountainToSm = checkShouldMoveMountainToSm;
})(Mountain || (Mountain = {}));
var Region;
(function (Region) {
    var REGION_TYPES;
    (function (REGION_TYPES) {
        REGION_TYPES[REGION_TYPES["PLAINS"] = 0] = "PLAINS";
        REGION_TYPES[REGION_TYPES["MOUNTAINOUS"] = 1] = "MOUNTAINOUS";
        REGION_TYPES[REGION_TYPES["FOREST"] = 2] = "FOREST";
        REGION_TYPES[REGION_TYPES["DESERT"] = 3] = "DESERT";
        REGION_TYPES[REGION_TYPES["BEACH"] = 4] = "BEACH";
        REGION_TYPES[REGION_TYPES["FARMLAND"] = 5] = "FARMLAND";
        REGION_TYPES[REGION_TYPES["ISLAND"] = 6] = "ISLAND";
    })(REGION_TYPES = Region.REGION_TYPES || (Region.REGION_TYPES = {}));
    Region.REGION_LEVEL_UNLOCKS = [40, 60, 80, 100, 120, 140, 160, 180];
    var DEFAULT_REGION_CONFIG = [2, 1, 5, 3, 0, 2, 4, 6, 6];
    Region.DEFAULT_REGION_LIST = ["", "", "", "", "", "", "", "", ""];
    Region.INCOME_SHARE_PERCENT = 0.25;
    function getRegionConfig(citySeed) {
        if (citySeed == Global.TERRAIN_SEED) {
            return DEFAULT_REGION_CONFIG;
        }
        var rng = new Utils.RNG(citySeed);
        var terrainChoices = [REGION_TYPES.PLAINS, REGION_TYPES.PLAINS, REGION_TYPES.PLAINS, REGION_TYPES.MOUNTAINOUS, REGION_TYPES.MOUNTAINOUS, REGION_TYPES.FOREST, REGION_TYPES.FOREST, REGION_TYPES.FOREST, REGION_TYPES.DESERT, REGION_TYPES.DESERT, REGION_TYPES.DESERT, REGION_TYPES.BEACH, REGION_TYPES.BEACH, REGION_TYPES.BEACH, REGION_TYPES.FARMLAND, REGION_TYPES.FARMLAND, REGION_TYPES.ISLAND, REGION_TYPES.ISLAND, REGION_TYPES.ISLAND];
        var typeList = [];
        for (var i = 0; i < 9; i++) {
            // center is always central city
            if (i == 4) {
                typeList[i] = REGION_TYPES.PLAINS;
            } else {
                var terrainIndex = rng.nextRange(0, terrainChoices.length - 1);
                typeList[i] = terrainChoices[terrainIndex];
                terrainChoices.splice(terrainIndex, 1);
            }
        }
        return typeList;
    }
    Region.getRegionConfig = getRegionConfig;
    function getNumRegionPurchasesRemaining(cityMetadata) {
        var regionLevel = 0;
        if (cityMetadata.index > -1) {
            regionLevel = getTotalLevelRegion(cityMetadata.index);
        } else if (cityMetadata.tempUID && window['pocketCityGame'].regionDownload.cloudRegionCache[cityMetadata.tempUID]) {
            regionLevel = getCloudRegionLevel();
        }
        var regions = cityMetadata.stats.regions || Region.DEFAULT_REGION_LIST;
        var numUnlocked = regions.filter(function (a) {
            return a != "";
        }).length;
        var availableForLevel = Region.REGION_LEVEL_UNLOCKS.filter(function (lv) {
            return regionLevel >= lv;
        }).length;
        if (cityMetadata.metadata.isSandbox) {
            availableForLevel = 8;
        }
        var numRemaining = availableForLevel - numUnlocked;
        return numRemaining;
    }
    Region.getNumRegionPurchasesRemaining = getNumRegionPurchasesRemaining;
    Region.temporaryNeighborInitData = null;
    /** Create new city and set it as active */
    function initNewNeighborCity(neighborSettings, cb) {
        Region.temporaryNeighborInitData = neighborSettings;
        window['disableAutoDefault'] = true;
        var pcGame = window['pocketCityGame'];
        pcGame.destroyCurrentCityState();
        // keep neighbor city the same size as central city - not sure about safety of background processes for two cities with
        // different sizes
        var city = pcGame.createCity(Region.temporaryNeighborInitData.centralCitySize, true, null, Region.temporaryNeighborInitData.centralCityIsSandbox, Region.temporaryNeighborInitData.regionType, true);
        pcGame.setAsActive(city, true);
        //create random name
        city.metadata.name = CityNames.getRandomName();
        if (Region.temporaryNeighborInitData.centralCityIsSandbox && Region.temporaryNeighborInitData.centralCityIsSandboxFiniteMoney) {
            city.setSandboxFiniteMoney();
        }
        pcGame.gameplayUI.refreshTitle();
        city.onFinalCalculationComplete(function () {
            var diff = getCurrentRegionDifficulty(Region.temporaryNeighborInitData.centralIndex);
            if (diff !== Difficulty.DIFFICULTY.NORMAL) {
                Difficulty.setDifficulty(pcGame.activeCity, diff);
            }
            // finish and save
            pcGame.activeCity.citySaveHelper.autoSave(function () {
                Region.finishInitNewNeighbor(pcGame.activeCity, function () {
                    // reload game
                    pcGame.gameplayUI.pocketCity.loadCity(city.cityIndex);
                    // -1 just ensures that no income metadata updates occur, shouldn't be necessary here
                    Region.refreshCacheMetadata(-1, function () {});
                    setTimeout(function () {
                        delete window['disableAutoDefault'];
                        cb();
                    }, 50);
                });
            });
        });
    }
    Region.initNewNeighborCity = initNewNeighborCity;
    /** Call this function after initializing new Neighbor to perform final cleanup / metadata updates */
    function finishInitNewNeighbor(city, cb) {
        console.log("completing init neighbor city, with cityIndex " + city.cityIndex);
        // call by neighbor city as soon as it's initialized and saved
        if (!Region.temporaryNeighborInitData) {
            console.error("problem! no temporaryNeighborInitData set");
            return;
        }
        // update central city with neighbor region uid in regions list
        window['pocketCityGame'].pushSnapshotNewRegion(Region.temporaryNeighborInitData.centralIndex, {
            index: Region.temporaryNeighborInitData.neighborRegionIndex,
            uid: window['pocketCityGame'].storage.getCityUIDByIndex(city.cityIndex)
        }, cb);
        Region.temporaryNeighborInitData = null;
    }
    Region.finishInitNewNeighbor = finishInitNewNeighbor;
    //
    // Calculate / cache
    //
    var cachedCitiesMetadata = null; // cached cities for current region
    function getCachedCitiesMetadata() {
        return cachedCitiesMetadata;
    }
    Region.getCachedCitiesMetadata = getCachedCitiesMetadata;
    function getCityMetadata(cityIndex) {
        for (var i = 0; i < cachedCitiesMetadata.length; i++) {
            if (cachedCitiesMetadata[i].index === cityIndex) {
                return cachedCitiesMetadata[i];
            }
        }
        return null;
    }
    Region.getCityMetadata = getCityMetadata;
    function getRegionMetadataForCityIndex(currentCityIndex) {
        return _getRegionMetadataForCityIndex(currentCityIndex, cachedCitiesMetadata);
    }
    Region.getRegionMetadataForCityIndex = getRegionMetadataForCityIndex;
    /** Get city metadata for cities in given city's region. Can pass central or neighbor city. */
    function _getRegionMetadataForCityIndex(currentCityIndex, processedCities, centralCityOverride) {
        if (centralCityOverride === void 0) {
            centralCityOverride = null;
        }
        var selfCity = null;
        var centralCity = null;
        var oldLen = cachedCitiesMetadata.length;
        if (centralCityOverride !== null) {
            // known central city id
            for (var j = 0; j < processedCities.length; j++) {
                if (processedCities[j].index === centralCityOverride) {
                    centralCity = processedCities[j];
                }
            }
        } else {
            // filter out any cities that don't belong to the region
            for (var i = 0; i < processedCities.length; i++) {
                if (processedCities[i].index === currentCityIndex) {
                    selfCity = processedCities[i];
                }
            }
            if (!selfCity) {
                // This is a new city
                return [];
            }
            if (!selfCity.stats.isNeighbor) {
                centralCity = selfCity;
            } else {
                var selfUID = window['pocketCityGame'].storage.getCityUIDByIndex(currentCityIndex);
                for (var j = 0; j < processedCities.length; j++) {
                    if (processedCities[j].stats.regions && // won't have if it's legacy city
                    processedCities[j].stats.regions.indexOf(selfUID) !== -1) {
                        centralCity = processedCities[j];
                    }
                }
            }
        }
        if (!centralCity) {
            console.warn("could not find central city for", currentCityIndex, " in cities list");
        }
        processedCities = processedCities.filter(function (city) {
            return (
                // is central city
                city === centralCity ||
                // or is child of central city
                centralCity && centralCity.stats && centralCity.stats.regions && city.stats.isNeighbor && centralCity.stats.regions.indexOf(window['pocketCityGame'].storage.getCityUIDByIndex(city.index)) !== -1
            );
        });
        if (oldLen !== cachedCitiesMetadata.length) {
            throw new Error("Unexpected array length change");
        }
        return processedCities;
    }
    Region._getRegionMetadataForCityIndex = _getRegionMetadataForCityIndex;
    /**
     * load and cache and return cities metadata for all cities
     * cache it here too for calculations in other functions.
     * also updates and saves stats.income for any city metadata that is missing it.
     */
    function refreshCacheMetadata(onlyRecalculateIncomeFor, cb) {
        window['pocketCityGame'].storage.getCitiesMetadata(function (cities) {
            if (!cities.length) {
                cachedCitiesMetadata = [];
                cb(cities);
                return;
            }
            var processedCities = [];
            cities.forEach(function (city) {
                var afterCheckIncome = function afterCheckIncome(processedCity) {
                    processedCities.push(processedCity);
                    if (processedCities.length === cities.length) {
                        cachedCitiesMetadata = processedCities;
                        cb(cachedCitiesMetadata);
                    }
                };
                if (onlyRecalculateIncomeFor !== null && Number(onlyRecalculateIncomeFor) === Number(city.index)) {
                    ensureCityHasIncomeStat(city, function (processedCity) {
                        afterCheckIncome(processedCity);
                    });
                } else {
                    afterCheckIncome(city);
                }
            });
        }, false, true);
    }
    Region.refreshCacheMetadata = refreshCacheMetadata;
    function getParentCityIndex(city, cb) {
        if (!city.stats.isNeighbor) {
            return city.cityIndex;
        }
        var neighborUid = window['pocketCityGame'].storage.getCityUIDByIndex(city.cityIndex);
        var returnIndex = -1;
        window['pocketCityGame'].storage.getCitiesMetadata(function (cities) {
            for (var i = 0; i < cities.length; i++) {
                var regions = cities[i].stats.regions;
                if (!regions) {
                    regions = Region.DEFAULT_REGION_LIST;
                }
                for (var j = 0; j < regions.length; j++) {
                    if (regions[j] === neighborUid) {
                        returnIndex = cities[i].index;
                        break;
                    }
                }
                if (returnIndex !== -1) break;
            }
            if (returnIndex === -1) {
                console.warn("problem: city not found to be neighbor of any central city, returning own city id");
                cb(city.cityIndex);
            } else {
                cb(returnIndex);
            }
        }, false, true);
    }
    Region.getParentCityIndex = getParentCityIndex;
    // calls back with parent city index, or self if there is no parent
    function getParentCityIndexIfExists(cityIndex, cb) {
        var neighborUid = window['pocketCityGame'].storage.getCityUIDByIndex(cityIndex);
        var returnIndex = -1;
        window['pocketCityGame'].storage.getCitiesMetadata(function (cities) {
            for (var i = 0; i < cities.length; i++) {
                var regions = cities[i].stats.regions;
                if (!regions) {
                    regions = Region.DEFAULT_REGION_LIST;
                }
                for (var j = 0; j < regions.length; j++) {
                    if (regions[j] === neighborUid) {
                        returnIndex = cities[i].index;
                        break;
                    }
                }
                if (returnIndex !== -1) break;
            }
            if (returnIndex === -1) {
                cb(cityIndex);
            } else {
                cb(returnIndex);
            }
        }, false, true);
    }
    Region.getParentCityIndexIfExists = getParentCityIndexIfExists;
    function ensureCityHasIncomeStat(cityMetadata, cb) {
        if (cityMetadata.stats.hasOwnProperty('income')) {
            cb(cityMetadata);
            return;
        }
        // update cache and save it
        console.log("SLOW: city has no income stat saved - updating now for index:" + cityMetadata.index);
        calculateAndSaveCityFirstIncomeStat(cityMetadata.index, function (income) {
            cityMetadata.stats.income = income;
            cb(cityMetadata);
        });
    }
    /** calculate a city's metrics by loading it in the background and updating it */
    function calculateAndSaveCityFirstIncomeStat(index, cb) {
        window['pocketCityGame'].getCityMetricsAndPushSnapshotOnly(index, function (calculations) {
            console.log("calculated metrics ans saved new data..");
            cb(calculations.income, calculations.otherCalculations);
        });
    }
    function _calculateAndSaveCityFirstIncomeStat(index, cb) {
        return calculateAndSaveCityFirstIncomeStat(index, cb);
    }
    Region._calculateAndSaveCityFirstIncomeStat = _calculateAndSaveCityFirstIncomeStat;
    function getCurrentRegionDifficulty(cityIndex) {
        // all should have same difficulty
        var thisRegionMetadata = getRegionMetadataForCityIndex(cityIndex);
        if (!thisRegionMetadata || !thisRegionMetadata.length) {
            throw new Error("region metadata must be loaded first");
        }
        if (thisRegionMetadata[0].stats.globalSettings.hasOwnProperty(Difficulty.DIFFICULTY_GLOBAL_SAVE_KEY)) {
            return thisRegionMetadata[0].stats.globalSettings[Difficulty.DIFFICULTY_GLOBAL_SAVE_KEY];
        } else {
            return Difficulty.DIFFICULTY.NORMAL;
        }
    }
    Region.getCurrentRegionDifficulty = getCurrentRegionDifficulty;
    function getTotalPopRegion(cityIndex) {
        var pop = 0;
        var thisRegionMetadata = getRegionMetadataForCityIndex(cityIndex);
        thisRegionMetadata.forEach(function (m) {
            pop += m.stats.population;
        });
        return pop;
    }
    Region.getTotalPopRegion = getTotalPopRegion;
    function getTotalLevelRegion(cityIndex) {
        var level = 0;
        var thisRegionMetadata = getRegionMetadataForCityIndex(cityIndex);
        thisRegionMetadata.forEach(function (m) {
            level += m.stats.level;
        });
        return level;
    }
    Region.getTotalLevelRegion = getTotalLevelRegion;
    function getCloudRegionLevel() {
        var level = 0;
        Object.keys(window['pocketCityGame'].regionDownload.cloudRegionCache).forEach(function (uid) {
            if (window['pocketCityGame'].regionDownload.cloudRegionCache.hasOwnProperty(uid)) {
                var c = window['pocketCityGame'].regionDownload.cloudRegionCache[uid];
                level += c.stats.level;
            }
        });
        return level;
    }
    Region.getCloudRegionLevel = getCloudRegionLevel;
    function getTotalIncomeRegion(cityIndex) {
        // Only works if cachedCitiesMetadata already loaded
        var income = 0;
        var thisRegionMetadata = getRegionMetadataForCityIndex(cityIndex);
        thisRegionMetadata.forEach(function (m) {
            if (m.stats.income > 0) {
                income += m.stats.income;
            }
        });
        return income;
    }
    Region.getTotalIncomeRegion = getTotalIncomeRegion;
    // Get current region income, doesn't use cache since we are likely loading a new city and need up-to-date info
    function getRegionMetadataAsyncAsync(currentCityIndex, curCity, cb, centralCityOverride) {
        if (centralCityOverride === void 0) {
            centralCityOverride = null;
        }
        refreshCacheMetadata(currentCityIndex, function (cachedCitiesMetadata) {
            var income = 0;
            var centralCityLevel = 1;
            var centralCityIndex = -1;
            var maxNeighborLevel = 0;
            var regionMetadata;
            if (curCity.tempUID && curCity.ignoreSave) {
                var selfUID_1 = curCity.tempUID;
                regionMetadata = [];
                Object.keys(window['pocketCityGame'].regionDownload.cloudRegionCache).forEach(function (uid) {
                    regionMetadata.push(window['pocketCityGame'].regionDownload.cloudRegionCache[uid]);
                });
                regionMetadata.forEach(function (m) {
                    if (!m.stats.isNeighbor) {
                        centralCityLevel = m.stats.level;
                    }
                    if (m.tempUID !== selfUID_1 && m.stats.income > 0) {
                        income += m.stats.income; // is other city
                    }
                    if (m.stats.isNeighbor) {
                        maxNeighborLevel = Math.max(m.stats.level, maxNeighborLevel);
                    }
                });
            } else {
                var selfUID_2 = window['pocketCityGame'].storage.getCityUIDByIndex(currentCityIndex);
                regionMetadata = _getRegionMetadataForCityIndex(currentCityIndex, cachedCitiesMetadata, centralCityOverride);
                regionMetadata.forEach(function (m) {
                    if (currentCityIndex === m.index && !m.stats.isNeighbor) {
                        centralCityLevel = m.stats.level;
                    }
                    if (m.index !== currentCityIndex && m.stats.income > 0) {
                        // is other city
                        income += m.stats.income;
                    }
                    if (m.stats.regions && m.stats.regions.indexOf(selfUID_2) !== -1 && !m.stats.isNeighbor) {
                        centralCityLevel = m.stats.level;
                        centralCityIndex = m.index;
                    }
                    if (m.stats.isNeighbor) {
                        maxNeighborLevel = Math.max(m.stats.level, maxNeighborLevel);
                    }
                });
            }
            cb(income, centralCityLevel, maxNeighborLevel, centralCityIndex);
        });
    }
    Region.getRegionMetadataAsyncAsync = getRegionMetadataAsyncAsync;
    function getCitiesMetadataInRegionLatestCache(currentCityIndex) {
        return _getRegionMetadataForCityIndex(currentCityIndex, cachedCitiesMetadata);
    }
    Region.getCitiesMetadataInRegionLatestCache = getCitiesMetadataInRegionLatestCache;
    function executeMoneyTransfer(indexA, indexB, indexAOldAmount, indexBOldAmount, amount, cb) {
        var newTargetAmount = indexBOldAmount + amount;
        var newSourceAmount = indexAOldAmount - amount;
        window['pocketCityGame'].storage.replaceMoney(indexB, indexBOldAmount, newTargetAmount, function (error) {
            if (error) {
                cb(error);
            } else {
                window['pocketCityGame'].storage.replaceMoney(indexA, indexAOldAmount, newSourceAmount, function (error) {
                    if (error) {
                        cb(error);
                    } else {
                        var activeCity = _getActiveCity();
                        var isOnCurCity = false;
                        if (activeCity) {
                            if (activeCity.cityIndex === indexB) {
                                activeCity.replaceAllSnapshotMoney(newTargetAmount);
                                isOnCurCity = true;
                            } else if (activeCity.cityIndex === indexA) {
                                activeCity.replaceAllSnapshotMoney(newSourceAmount);
                                isOnCurCity = true;
                            }
                        }
                        if (isOnCurCity) {
                            // push new snapshot
                            activeCity.citySaveHelper.autoSave(function () {
                                cb();
                            });
                        } else {
                            cb();
                        }
                    }
                });
            }
        });
    }
    Region.executeMoneyTransfer = executeMoneyTransfer;
})(Region || (Region = {}));
var TerrainRegion;
(function (TerrainRegion) {
    var FIXTURES = {
        CRESCENT_POND: [[0, 0, 0, 1, 1, 1, 0, 0, 0], [0, 0, 1, 1, 1, 1, 1, 0, 0], [0, 1, 1, 1, 1, 1, 1, 1, 0], [1, 1, 1, 1, 1, 1, 0, 0, 0], [1, 1, 1, 1, 1, 0, 0, 0, 0], [1, 1, 1, 1, 1, 0, 0, 0, 0], [1, 1, 1, 1, 1, 0, 0, 0, 0], [0, 1, 1, 1, 1, 1, 1, 0, 0], [0, 0, 1, 1, 1, 1, 0, 0, 0]],
        SOIL_LARGE: [[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0], [0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0], [0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0], [0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0], [0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0], [0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0], [0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0], [0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0], [0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0], [0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], [0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0], [0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0], [0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0], [0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0], [0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]]
    };
    TerrainRegion.initRegionTerrain = function (city) {
        var type = city.stats.regionType;
        if (!type && type !== 0) {
            type = Region.REGION_TYPES.PLAINS;
        }
        if (type === Region.REGION_TYPES.PLAINS) {
            return;
        }
        TerrainRegion.typeToSeedFn[type](city);
    };
    var applyRandomFeature = function applyRandomFeature(city, fixture, cb) {
        // prefer left side
        var startRow = city.rng.nextRange(Math.floor(city.size * 0.2), Math.floor(city.size * 0.8));
        var startCol = city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.6));
        for (var i = startRow; i < startRow + fixture.length; i++) {
            for (var j = startCol; j < startCol + fixture[0].length; j++) {
                if (Utils.isValidIndex(i, j, city.size) && fixture[i - startRow][j - startCol]) {
                    cb(i, j);
                }
            }
        }
    };
    TerrainRegion.setTerrainMountainous = function (city) {
        for (var i = 0; i < 5; i++) {
            city.grids.terrainGrid.createMountainRange({
                row: city.rng.nextRange(Math.floor(city.size * 0.2), Math.floor(city.size * 0.8)),
                col: city.rng.nextRange(Math.floor(city.size * 0.2), Math.floor(city.size * 0.8), 5, 200, 60, [MountainExtraLarge.DIM, MountainLarge.DIM, MountainLarge.DIM])
            });
        }
    };
    TerrainRegion.setTerrainDesert = function (city) {
        // crescent oasis
        applyRandomFeature(city, FIXTURES.CRESCENT_POND, function (r, c) {
            city.safeGeneralDestroyTile(r, c);
            city.grids.terrainGrid.setWaterAtIndex(r, c);
        });
        // second random oasis
        var oasis = Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.3), Math.floor(city.size * 0.7)),
            col: city.rng.nextRange(Math.floor(city.size * 0.5), Math.floor(city.size * 0.9))
        }, 120, city.rng);
        // set desert and water
        for (var i = 0; i < city.size; i++) {
            for (var j = 0; j < city.size; j++) {
                if (!oasis[i][j]) {
                    city.grids.terrainGrid.setSandAtIndex(i, j);
                } else {
                    city.safeGeneralDestroyTile(i, j);
                    city.grids.terrainGrid.setWaterAtIndex(i, j);
                }
            }
        }
        // add palm trees around water
        for (var i = 0; i < city.size; i++) {
            for (var j = 0; j < city.size; j++) {
                if (city.grids.terrainGrid.isWaterAtIndex(i, j)) {
                    surroundWithPalmTrees(city, i, j, 2);
                }
            }
        }
        // add large palm tree region
        Utils.setAll2D(oasis, 0);
        var palmTrees = Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.2), Math.floor(city.size * 0.8)),
            col: city.rng.nextRange(Math.floor(city.size * 0.2), Math.floor(city.size * 0.8))
        }, 120, city.rng, oasis);
        for (var i = 0; i < city.size; i++) {
            for (var j = 0; j < city.size; j++) {
                if (palmTrees[i][j] && !city.grids.terrainGrid.isWaterAtIndex(i, j)) {
                    TerrainRegion.setPalmTree(city, i, j);
                }
            }
        }
        TerrainRegion.setSandEdgeMap(city);
    };
    TerrainRegion.setSandEdgeMap = function (city) {
        // remove sand around edge of map for aesthetics
        function destroyWaterSetSand(r, c) {
            if (city.grids.terrainGrid.isWaterAtIndex(r, c)) {
                city.grids.terrainGrid.destroyWaterAtIndex(r, c);
                city.grids.terrainGrid.setSandAtIndex(r, c);
            }
        }
        var r = 0;
        for (r = 0; r < city.size; r++) {
            destroyWaterSetSand(r, 0);
        }
        for (r = 0; r < city.size; r++) {
            destroyWaterSetSand(r, city.size - 1);
        }
        var c = 0;
        for (c = 0; c < city.size; c++) {
            destroyWaterSetSand(0, c);
        }
        for (c = 0; c < city.size; c++) {
            destroyWaterSetSand(city.size - 1, c);
        }
    };
    TerrainRegion.setTerrainIsland = function (city) {
        // large centre island
        var land = Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.4), Math.floor(city.size * 0.6)),
            col: city.rng.nextRange(Math.floor(city.size * 0.4), Math.floor(city.size * 0.6))
        }, 350, city.rng);
        // smaller islands
        Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.9)),
            //left side
            col: city.rng.nextRange(Math.floor(city.size * 0.05), Math.floor(city.size * 0.4))
        }, 120, city.rng, land);
        Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.9)),
            // right side
            col: city.rng.nextRange(Math.floor(city.size * 0.6), Math.floor(city.size * 0.95))
        }, 120, city.rng, land);
        Grid.randomBoolRegion(city, {
            // bottom
            row: city.rng.nextRange(Math.floor(city.size * 0.7), Math.floor(city.size * 0.95)),
            col: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.9))
        }, 120, city.rng, land);
        Grid.randomBoolRegion(city, {
            // top
            row: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.3)),
            col: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.9))
        }, 120, city.rng, land);
        Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.2)),
            col: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.2))
        }, 90, city.rng, land);
        Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.8), Math.floor(city.size * 0.9)),
            col: city.rng.nextRange(Math.floor(city.size * 0.8), Math.floor(city.size * 0.9))
        }, 90, city.rng, land);
        Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.2)),
            col: city.rng.nextRange(Math.floor(city.size * 0.8), Math.floor(city.size * 0.9))
        }, 90, city.rng, land);
        Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.8), Math.floor(city.size * 0.9)),
            col: city.rng.nextRange(Math.floor(city.size * 0.1), Math.floor(city.size * 0.2))
        }, 90, city.rng, land);
        // set water
        for (var row = 0; row < city.size; row++) {
            for (var col = 0; col < city.size; col++) {
                if (!land[row][col]) {
                    city.safeGeneralDestroyTile(row, col);
                    city.grids.terrainGrid.setWaterAtIndex(row, col);
                    // set sand underneath for aesthetics
                    for (var i = -1; i <= 1; i++) {
                        for (var j = -1; j <= 1; j++) {
                            var r = row + i;
                            var c = col + j;
                            if (Utils.isValidIndex(r, c, city.size) && land[r][c]) {
                                city.grids.terrainGrid.setSandAtIndex(row, col);
                                city.safeGeneralDestroyTile(r, c);
                                city.grids.terrainGrid.setSandAtIndex(r, c);
                            }
                        }
                    }
                }
            }
        }
    };
    // todo: test terrain does not override things built on top, e.g. marina, zones
    TerrainRegion.setTerrainForest = function (city) {
        // fill with ponds
        var pondMax = Math.floor(city.size * 0.15);
        for (var i = 0; i < pondMax; i++) {
            var r = city.rng.nextRange(0, city.size - 1);
            var c = city.rng.nextRange(0, city.size - 1);
            city.grids.terrainGrid.createPond({ row: r, col: c
            }, city.rng.nextRange(20, 25), true);
            // surround ponds with forest
            city.grids.terrainGrid.createForest({ row: r, col: c
            }, city.rng.nextRange(12, 15), 0.3, false);
        }
        // fill with more forests
        var forestMax = Math.floor(city.size * 0.2);
        for (var i = 0; i < forestMax; i++) {
            city.grids.terrainGrid.createForestFastCached({
                row: city.rng.nextRange(0, city.size - 1),
                col: city.rng.nextRange(0, city.size - 1)
            }, city.rng.nextRange(10, 12), 0.2, false);
        }
    };
    var surroundWithPalmTrees = function surroundWithPalmTrees(city, row, col, percentOut10) {
        for (var i = -1; i <= 1; i++) {
            for (var j = -1; j <= 1; j++) {
                var r = row + i;
                var c = col + j;
                if (Utils.isValidIndex(r, c, city.size) && !city.grids.terrainGrid.isWaterAtIndex(r, c)) {
                    city.grids.terrainGrid.setSandAtIndex(r, c);
                    if (city.rng.nextRange(0, 10) <= percentOut10) {
                        TerrainRegion.setPalmTree(city, r, c);
                    }
                }
            }
        }
    };
    TerrainRegion.setTerrainBeach = function (city) {
        // build a random sand island
        var islandBool = Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.4), Math.floor(city.size * 0.6)),
            col: city.rng.nextRange(Math.floor(city.size * 0.7), Math.floor(city.size * 0.95))
        }, 120, city.rng);
        var sandBool = Utils.initialize2DArray(city.size, city.size, 0);
        var startI = { row: 0, col: city.rng.nextRange(Math.floor(city.size * 0.35), Math.floor(city.size * 0.65)) };
        var endI = { row: city.size - 1, col: city.rng.nextRange(Math.floor(city.size * 0.35), Math.floor(city.size * 0.65)) };
        var path1 = Grid.randomPathE2E(city, false, 3, null, [startI, endI]);
        var counter = 0;
        var didExtraTile = false;
        var findWaterSetSand = function findWaterSetSand(row, col) {
            if (!islandBool[row][col]) {
                surroundWithPalmTrees(city, row, col, 2);
            }
        };
        path1.forEach(function (ind) {
            var p = ind;
            if (didExtraTile) {
                p[1] += 1;
                didExtraTile = false;
            } else if (city.rng.nextRange(0, 10) > 5) {
                p[1] += 1;
                didExtraTile = true;
            }
            for (var c = p[1] - 1; c >= 0; c--) {
                if (Utils.isValidIndex(p[0], c, city.size)) {
                    sandBool[p[0]][c] = 1;
                }
            }
            for (var c = p[1]; c < city.size; c++) {
                if (Utils.isValidIndex(p[0], c, city.size)) {
                    city.safeGeneralDestroyTile(p[0], c);
                    if (!islandBool[p[0]][c]) {
                        city.grids.terrainGrid.setWaterAtIndex(p[0], c);
                    } else {
                        Utils.mapTouchingTiles(p[0], c, city.size, findWaterSetSand);
                    }
                }
            }
            // trees around water
            if (city.rng.nextRange(0, 10) <= 3) {
                if (city.rng.nextRange(0, 10) <= 5) {
                    p[1] -= 1;
                }
                Utils.mapTouchingTiles(p[0], p[1], city.size, function (r, c) {
                    if (!city.grids.terrainGrid.isWaterAtIndex(r, c)) {
                        TerrainRegion.setPalmTree(city, r, c);
                    }
                });
            }
            counter += 1;
        });
        // set desert for sand bool
        for (var i = 0; i < city.size; i++) {
            for (var j = 0; j < city.size; j++) {
                if (!islandBool[i][j] && sandBool[i][j]) {
                    city.grids.terrainGrid.setSandAtIndex(i, j);
                }
            }
        }
        TerrainRegion.removeSandEdgeMap(city);
    };
    TerrainRegion.setPalmTree = function (city, r, c) {
        var t = Tile.createTileSprite(city, Tile.Type.Terrain);
        t.frameName = 'src/www/img-atlas/structures/terrain/desert-palm-tree.png';
        city.grids.terrainGrid.setTile(r, c, t);
    };
    TerrainRegion.removeSandEdgeMap = function (city) {
        // remove sand around edge of map for aesthetics
        var r = 0;
        for (r = 0; r < city.size; r++) {
            if (city.grids.terrainGrid.isWaterAtIndex(r, 0)) {
                city.grids.terrainGrid.destroySandAtIndex(r, 0);
            }
        }
        for (r = 0; r < city.size; r++) {
            if (city.grids.terrainGrid.isWaterAtIndex(r, city.size - 1)) {
                city.grids.terrainGrid.destroySandAtIndex(r, city.size - 1);
            }
        }
        var c = 0;
        for (c = 0; c < city.size; c++) {
            if (city.grids.terrainGrid.isWaterAtIndex(0, c)) {
                city.grids.terrainGrid.destroySandAtIndex(0, c);
            }
        }
        for (c = 0; c < city.size; c++) {
            if (city.grids.terrainGrid.isWaterAtIndex(city.size - 1, c)) {
                city.grids.terrainGrid.destroySandAtIndex(city.size - 1, c);
            }
        }
    };
    TerrainRegion.setTerrainFarmland = function (city) {
        var soilBool = Grid.randomBoolRegion(city, {
            row: city.rng.nextRange(Math.floor(city.size * 0.4), Math.floor(city.size * 0.6)),
            col: city.rng.nextRange(Math.floor(city.size * 0.7), Math.floor(city.size * 0.95))
        }, 180, city.rng);
        for (var i = 0; i < city.size; i++) {
            for (var j = 0; j < city.size; j++) {
                if (soilBool[i][j] && !city.grids.terrainGrid.isWaterAtIndex(i, j)) {
                    city.grids.terrainGrid.setSoilAtIndex(i, j);
                }
            }
        }
        applyRandomFeature(city, FIXTURES.SOIL_LARGE, function (r, c) {
            if (!city.grids.terrainGrid.isWaterAtIndex(r, c)) {
                city.grids.terrainGrid.setSoilAtIndex(r, c);
            }
        });
    };
    // this must be at bottom
    TerrainRegion.typeToSeedFn = (_a = {}, _a[Region.REGION_TYPES.PLAINS] = function (city) {}, _a[Region.REGION_TYPES.MOUNTAINOUS] = TerrainRegion.setTerrainMountainous, _a[Region.REGION_TYPES.DESERT] = TerrainRegion.setTerrainDesert, _a[Region.REGION_TYPES.ISLAND] = TerrainRegion.setTerrainIsland, _a[Region.REGION_TYPES.FOREST] = TerrainRegion.setTerrainForest, _a[Region.REGION_TYPES.BEACH] = TerrainRegion.setTerrainBeach, _a[Region.REGION_TYPES.FARMLAND] = TerrainRegion.setTerrainFarmland, _a);
    var _a;
    /*
     * == Generate json for fixtures:
        sr = 27;
        sc = 0;
        boolGrid = Utils.initialize2DArray(25, 25);
        fn = (r,c) => pocketCityGame.activeCity.grids.terrainGrid.isWaterAtIndex(r,c);
        for (let r = sr; r < sr + 9; r++){
            for (let c = sc; c < sc + 9; c++){
        console.log("setting:",r-sr,c-sc);
                boolGrid[r-sr][c-sc] = fn(r,c)? 1 : 0;
            }
        }
        console.log(JSON.stringify(boolGrid));
     */
})(TerrainRegion || (TerrainRegion = {}));
/**
 * Group for UI elements
 * @param game
 * @constructor
 */
var UIGroup = function UIGroup(game) {
  Phaser.Group.call(this, game);
};
UIGroup.prototype = Object.create(Phaser.Group.prototype);
UIGroup.prototype.constructor = UIGroup;
/**
 * Modal group.
 *
 * Usually only one on screen at once.
 *
 * @param city
 * @param [index] - Optional grid index to attach to
 * @param [offsetX] - Only used if index is given
 * @param [offsetY] - Only used if index is given
 * @param [blocking] {Boolean} - Stop city input
 * @constructor
 */
var Modal = function Modal(city, index, offsetX, offsetY, blocking) {
    Phaser.Group.call(this, city.game);
    this.city = city;
    this.game = city.game;
    this.index = index;
    this.blocking = Boolean(blocking);

    // Push self onto global modals array
    UI.global.modals.push(this);
    if (this.index) {
        UI.global.attachToIndex(this, this.index, offsetX, offsetY);
    }
};
Modal.prototype = Object.create(Phaser.Group.prototype);
Modal.prototype.constructor = Modal;
Modal.EXIT_BTN_SIZE_PERCENT = 0.1;
Utils.extend(Modal.prototype, WithAnimationMixin);

/** Called on destroy() signal */
Modal.prototype.destroy = function () {
    // Remove self from global modals array
    var ownIndex = UI.global.modals.indexOf(this);
    UI.global.modals.splice(ownIndex, 1);
    Phaser.Group.prototype.destroy.call(this);
};
/**
 * Generic fixed button that scales to a certain width
 * @param game
 * @param x
 * @param y
 * @param key
 * @param height
 * @param callback
 * @param [disableEffects]
 * @param [loose]
 * param [frame]
 * @constructor
 */
var Button = function Button(game, x, y, key, height, callback, disableEffects, loose, frame) {
    Phaser.Button.call(this, game, x, y, key);
    this.callback = callback;
    var self = this;
    this.callbackFn = callback;
    this.fixedToCamera = !Boolean(loose);
    this.input.priorityID = 1;
    Utils.scaleToHeight(this, height || Button.BUTTON_HEIGHT_PERCENT.MEDIUM);

    this.resizeOnClick = true;
    this.tintOnClick = true;
    this._inputOut = false;
    this._down = false;
    this._resized = true;
    this._ignoreCallback = false;

    this.cacheRealSize();

    if (frame) {
        this.setFrames(frame, frame, frame, frame);
    }

    // Hook in on down and on up
    this.events.onInputDown.add(function () {
        this._down = true;
        this._inputOut = false;
        if (!disableEffects) this.onDownEffect();
    }, this);
    this.events.onInputUp.add(function () {
        this._down = false;
        if (!self._inputOut && !disableEffects) this.onUpEffect();
        if (!self._inputOut && self.callbackFn && !this._ignoreCallback) {
            self.callback();
        }
        this._ignoreCallback = false;
    }, this);

    this.onInputOut.add(function () {
        if (this._down) {
            self._inputOut = true;
            if (!disableEffects) self.onUpEffect();
        }
    }, this);
    this.onInputOver.add(function () {
        if (this._down) {
            self._inputOut = false;
            if (!!disableEffects) self.onDownEffect();
        }
    }, this);
};

Button.prototype = Object.create(Phaser.Button.prototype);
Button.prototype.constructor = Button;
Utils.extend(Button.prototype, FloatMixin);
Utils.extend(Button.prototype, WithAnimationMixin);

Button.BUTTON_HEIGHT_PERCENT = {
    "SMALL": 0.10,
    "MEDIUM": 0.125,
    "LARGE": 0.15
};
Button.CLICK_RESIZE = 0.9;

Button.prototype.cacheRealSize = function () {
    this._realHeight = this.height;
    this._realWidth = this.width;
};
Button.prototype.onDownEffect = function () {
    // Set the tint and make small
    if (this.resizeOnClick) {
        this.cacheRealSize();
        var newWidth = this.width * Button.CLICK_RESIZE;
        var newHeight = this.height * Button.CLICK_RESIZE;
        this._xOffsetTmp = (this.width - newWidth) * 0.5;
        this._yOffsetTmp = (this.height - newHeight) * 0.5;

        if (this.anchor.x == 0.5) {
            this._xOffsetTmp = 0;
        }
        if (this.anchor.y == 0.5) {
            this._yOffsetTmp = 0;
        }
        this.width = newWidth;
        this.height = newHeight;

        if (this.fixedToCamera) {
            this.cameraOffset.x += this._xOffsetTmp;
            this.cameraOffset.y += this._yOffsetTmp;
        } else {
            this.x += this._xOffsetTmp;
            this.y += this._yOffsetTmp;
        }
        this._resized = true;
    }
    if (this.tintOnClick) {
        this.tint = 0xeeeeee;
    }
};

Button.prototype.onUpEffect = function () {
    // Clear the tint and revert sizing
    if (this.resizeOnClick && this._resized) {
        this.height = this._realHeight;
        this.width = this._realWidth;

        if (this.fixedToCamera) {
            this.cameraOffset.x -= this._xOffsetTmp;
            this.cameraOffset.y -= this._yOffsetTmp;
        } else {
            this.x -= this._xOffsetTmp;
            this.y -= this._yOffsetTmp;
        }
        this._resized = false;
    }
    if (this.tintOnClick) {
        this.tint = 0xffffff;
    }
};

Button.prototype.onClickedEffect = function () {};

Button.prototype.ignoreTemporarily = function () {
    this._ignoreCallback = true;
};
Button.prototype.stopIgnoreTemporarily = function () {
    this._ignoreCallback = false;
};
/**
 * Button with content as an image, and background as a separate image
 * @constructor
 */
var ImageOverlayButton = function ImageOverlayButton(game, x, y, contentKey, key, height, callback, frame, canCallback, backgroundFrame) {
    Button.call(this, game, x, y, key, height, callback, null, null, canCallback);

    if (backgroundFrame) {
        this.setFrames(backgroundFrame, backgroundFrame, backgroundFrame, backgroundFrame);
    }

    // Create centered image using contentKey on top of this image
    this.overlayImage = new Phaser.Image(game, 0, 0, contentKey, frame);
    this.addChild(this.overlayImage);

    // Hacky way of getting overlay to work
    this.setOverlayPercentSize(0.85);
    this.setXOffset(43);
    this.setYOffset(21);
};
ImageOverlayButton.prototype = Object.create(Button.prototype);
ImageOverlayButton.prototype.constructor = ImageOverlayButton;
ImageOverlayButton.prototype.setOverlayPercentSize = function (scale) {
    this.overlayImage.scale.set(scale);
};
/**
 * Give a FIXED number - no need to scale
 * @param amt
 */
ImageOverlayButton.prototype.setXOffset = function (amt) {
    this.overlayImage.x = amt;
};
/**
 * Give a FIXED number - no need to scale
 * @param amt
 */
ImageOverlayButton.prototype.setYOffset = function (amt) {
    this.overlayImage.y = amt;
};

//
// Pre-defined sizes
//

var ImageOverlayButtonMed = function ImageOverlayButtonMed(game, contentKey, height, callback, frame) {
    ImageOverlayButton.call(this, game, 0, 0, contentKey, 'atlas-ui', height, callback, frame, null, 'src/www/img-atlas/ui/white-shadow.png');
};
ImageOverlayButtonMed.prototype = Object.create(ImageOverlayButton.prototype);
ImageOverlayButtonMed.prototype.constructor = ImageOverlayButtonMed;

var ImageOverlayButtonCircle = function ImageOverlayButtonCircle(game, contentKey, height, callback, frame) {
    ImageOverlayButton.call(this, game, 0, 0, contentKey, 'atlas-ui', height, callback, frame, null, 'src/www/img-atlas/ui/white-circle-shadow.png');
};
ImageOverlayButtonCircle.prototype = Object.create(ImageOverlayButton.prototype);
ImageOverlayButtonCircle.prototype.constructor = ImageOverlayButtonCircle;
var ResizingBounceSprite = function ResizingBounceSprite(game, x, y, key, bounce, frame, scale) {
    this.bounce = bounce !== false;
    Phaser.Sprite.call(this, game, x, y, key, frame);
    this._timer = 0;
    this._realWidth = this.width;
    this._realHeight = this.height;
    this._scaleExtra = scale;
};
ResizingBounceSprite.RESIZE_AMT = 0.1;
ResizingBounceSprite.RESIZE_SPEED = 0.008;
ResizingBounceSprite.prototype = Object.create(Phaser.Sprite.prototype);
ResizingBounceSprite.prototype.constructor = ResizingBounceSprite;
ResizingBounceSprite.prototype.resize = function (w, h) {
    h = h || w;
    h = h * this._scaleExtra;
    w = w * this._scaleExtra;
    this.width = w;
    this.height = h;
    this._realWidth = this.width;
    this._realHeight = this.height;
};

ResizingBounceSprite.prototype.update = function () {
    if (this.visible && this.bounce) {
        this._timer += Utils.getElapsedTime(this.game) * ResizingBounceSprite.RESIZE_SPEED;
        var magnitude = Math.sin(this._timer) / 2 + 0.5; // magnitude will be between 0 and 1

        this.width = this._realWidth * (1 + ResizingBounceSprite.RESIZE_AMT * magnitude);
        this.height = this._realHeight * (1 + ResizingBounceSprite.RESIZE_AMT * magnitude);
    }
};
/** structure is really a TILE or pedestrian sprite */
var ProgressBar = function ProgressBar(game, width, frontTexture) {
    Phaser.Group.call(this, game);
    frontTexture = frontTexture || "src/www/img-atlas/ui/progress-bar-front.png";
    this._percent = 0;
    this.x = 0;
    this.y = 0;
    this._noGlobalTint = 1;
    this._backBorder = new Phaser.Sprite(game, 0, 0, "atlas-ui", "src/www/img-atlas/ui/progress-bar-border.png");
    this._backSprite = new Phaser.Sprite(game, 0, 0, "atlas-ui", "src/www/img-atlas/ui/progress-bar-back.png");
    this._frontSprite = new Phaser.Sprite(game, 0, 0, "atlas-ui", frontTexture);
    this.addChild(this._backBorder);
    this.addChild(this._backSprite);
    this.addChild(this._frontSprite);

    // initialize invisible
    this.visible = false;
};
ProgressBar.prototype = Object.create(Phaser.Group.prototype);
ProgressBar.prototype.constructor = ProgressBar;
ProgressBar.STRUCTURE_WIDTH_RATIO = 0.25;
ProgressBar.STRUCTURE_HEIGHT_RATIO = 0.15;
ProgressBar.BORDER_PERCENT = 0.5;

ProgressBar.prototype.reset = function () {
    this.visible = false;
};

ProgressBar.prototype.initWithSize = function () {
    var width = this.getFullWidth();
    var height = 5;
    this._backSprite.width = width;
    this._backSprite.height = height;
    this._frontSprite.width = width;
    this._frontSprite.height = height;

    Utils.scaleToWidth(this._backSprite, width);
    this._backSprite.height = height;
    this._frontSprite.height = height;
    this._frontSprite.width = 0;

    var borderSpriteWidth = this.getBorderSpriteWidth();
    var borderSpriteHeight = this.getBorderSpriteHeight();
    var backBorderDiff = (borderSpriteHeight - this._backSprite.height) * 0.5;
    var backBorderDiffWidth = (borderSpriteWidth - this._backSprite.width) * 0.5;
    this._backBorder.x = -backBorderDiffWidth;
    this._backBorder.y = -backBorderDiff;
    this._backBorder.width = borderSpriteWidth;
    this._backBorder.height = this.getBorderSpriteHeight();
};

ProgressBar.prototype.getFullWidth = function () {
    return this.structure.width * ProgressBar.STRUCTURE_WIDTH_RATIO;
};
ProgressBar.prototype.updatePercent = function (percent) {
    this._frontSprite.width = this._backSprite.width * percent;
    this._percent = percent;
};
ProgressBar.prototype.getBorderSize = function () {
    return 2;
};
ProgressBar.prototype.getBorderSpriteWidth = function () {
    var w = this.getBorderSize() + this._backSprite.width;
    var percent = 0.96;
    if (this.structure.leansLeft()) {
        w *= percent;
    } else if (this.structure.leansRight()) {
        w *= percent;
    } else if (this.structure.tileDimensions.col >= 2) {
        w *= percent;
    }
    return w;
};
ProgressBar.prototype.getBorderSpriteHeight = function () {
    return this.getBorderSize() + this._backSprite.height;
};
ProgressBar.prototype.setStructure = function (structure) {
    if (!structure) {
        console.warn("no structure, returning");
        return;
    }
    this.structure = structure;
    this.initWithSize();
};
ProgressBar.prototype.syncWithStructure = function () {
    //this._backSprite.width = this.structure.width * 0.8;
    var width = this.getFullWidth();
    this.width = width;

    this.x = this.structure.x - this._backSprite.width * 0.5;
    this.y = this.structure.y + this.structure.height * 0.3;
    if (this.structure.leansLeft()) {
        this.x -= width * 0.45;
    } else if (this.structure.leansRight()) {
        this.x += width * 0.45;
    }

    if (this.additionalProgresHeightOffset) {
        this.y -= this.height * this.additionalProgresHeightOffset;
    }

    this.initWithSize();
};
/**
 * Entity pool for re-usable objects
 */
var EntityPool = /** @class */function () {
    function EntityPool() {
        this._freeEntities = [];
        this.autoVisibilityToggle = true;
        this.maxPoolSize = 50; // If positive, will destroy any excess entities that exceed the max size
    }
    /**
     * Initialize a number of instances of the entity
     */
    EntityPool.prototype.preAllocate = function (num, additionalArg) {
        if (!num) {
            throw new MissingArgsError();
        }
        var i;
        var len;
        for (i = 0; i < num; i++) {
            this._freeEntities.push(this.createEntity(additionalArg));
        }
        if (this.autoVisibilityToggle) {
            for (i = 0, len = this._freeEntities.length; i < len; i++) {
                this._freeEntities[i].visible = false;
                this._freeEntities[i].alpha = 9;
            }
        }
    };
    /** Return a free entity from the pool. Creates new instance if pool is empty */
    EntityPool.prototype.allocate = function () {
        var s = this._freeEntities.length > 0 ? this._freeEntities.shift() : this.createEntity();
        if (this.autoVisibilityToggle) {
            s.alpha = 1;
            s.visible = true;
        }
        s._freeInPool = false;
        return s;
    };
    /** Add entity to entity pool */
    EntityPool.prototype.free = function (entity) {
        if (!entity) {
            throw new MissingArgsError();
        }
        if (entity._freeInPool) {
            return; // already freed
        }
        if (entity.reset) {
            entity.reset();
        }
        if (entity.preFree) {
            entity.preFree();
        }
        if (entity.parent) {
            entity.parent.removeChild(entity); // causing some crashes!
        }
        if (this.maxPoolSize > 0 && this._freeEntities.length >= this.maxPoolSize) {
            // If we've reached max pool size, destroy entity instead of saving
            if (entity.alive) {
                entity.destroy(true);
            }
            return;
        }
        entity._freeInPool = true;
        this._freeEntities.push(entity);
        if (this.autoVisibilityToggle) {
            entity.visible = false;
            entity.alpha = 0;
        }
        // if (!window['isProd'] && this._freeEntities.length > 200) {
        //     console.log("WARN: there are a lot of free entities!", this);
        // }
    };
    return EntityPool;
}();
var __extends = this && this.__extends || function () {
    var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function (d, b) {
        d.__proto__ = b;
    } || function (d, b) {
        for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
        }
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
var Group = Phaser.Group;
/**
 * Traffic algorithm:
 *
 * 1. Group zone tiles of same type together into groups [G1, G2...] each Gn is a group
 * 2. Determine connected groups G1.connected = [G2,..]
 *      Only connect groups that we want, and stop when we've reached the zone tile count we need (1 residence only needs 1 commercial)
 *      // Res -> Commercial (stop when res is satisfied)
        // Res -> Industrial (stop when res is satisfied)
        // Commercial -> Industrial (stop when commercial is satisfied)
 * 3. Determine desirability of each connected group, based on right group
 *     - suppossing R1 = 4 and C1 = 1, {R1_C1 : 1, ...} because C1 only offser 1 commercial tile
 * 4. Determine most paths and 2nd most optimal path between connected groups
 *     - {G1xG2: {start: {road tile touching G1 index}, end: {{road tile touching G2 index}} (note: they can be same road tile)
 * 5. Set value for each road tile:
 *     - Apply min( {{desireability}} / SOME_DEVISOR, MAX_DESIRABILITY) as the density value in each road tile in most optimal path (high 0.x for high density)
 *     - if sub optimal exists, calculate ratio, e.g. 5:3, and only apply 5/8 of value in optimal road
 *     - Apply same 0.x value times reduction amount of len(optimial)/len(2nd optimal)
 *
 * Notes:
 * Busses take effect in RoadTile.congestionReduction()
 *
 *
 */
var TRAFFIC_INC = 1;
var TrafficDensity = /** @class */function () {
    function TrafficDensity(city) {
        var _this = this;
        this.nextTrafficDensityCalculation = 0;
        this.requiresTrafficGridUpdate = true;
        this._currentlyCalculating = 0;
        this.calculationDelay = 0;
        this.averageDensity = 0; // 0 to 1
        this.transitDensityImprovement = 0;
        this.connectedness = null;
        this.lastUpdatePop = -1;
        this.highwayConnectedBool = null; // intersections where highways meet roads
        this._highwayConnectedFloodTracked = null; // for floodfill
        this.parkingGarageCoverageBool = null; // 2d of coverage reduction due to parking garages
        // somewhat specific
        this._commercialToIndustrialSkyrailAccess = false;
        this.city = city;
        this.setDefaultCalculationDelay();
        this.withoutTransitDensity = Utils.initialize2DArray(city.size);
        this.trafficDensity = Utils.initialize2DArray(city.size);
        this.roadCoverage = Utils.initialize2DArray(city.size);
        this.parkingGarageCoverageBool = Utils.initialize2DArray(city.size, city.size, 0);
        this.highwayConnectedBool = Utils.initialize2DArray(city.size, city.size, 0);
        this._highwayConnectedFloodTracked = Utils.initialize2DArray(city.size, city.size, 0);
        this.indexToGroup = Utils.initialize2DArray(city.size, city.size, null);
        this.groupPool = new TrafficGroupPool(city);
        this.city.refreshSignal.add(function (event) {
            switch (event) {
                case "roads_updated":
                    _this.updateRoadCoverageGraph();
                    _this.updateHighwayConnectedToRoadCoverage();
                case "zones_updated":
                    _this.updateParkingGarageCoverage();
                case "recalcuated_sky_rail_spawn_connections":
                    _this.updateTrafficDensitySoon();
                    break;
            }
        });
    }
    TrafficDensity.prototype.forceNoCalculationDelay = function () {
        this.calculationDelay = 0;
    };
    TrafficDensity.prototype.setDefaultCalculationDelay = function () {
        this.calculationDelay = TrafficDensity.STAGGER_CALCULATION_DELAY;
    };
    TrafficDensity.prototype.updateNow = function () {
        var _this = this;
        this.updateTrafficDensityByZonesSlow(function () {
            _this.ensureTrafficDensityGridTilesUpdated();
        });
    };
    TrafficDensity.prototype.update = function (elapsed) {
        var _this = this;
        if (this.nextTrafficDensityCalculation > 0) {
            this.nextTrafficDensityCalculation = Math.max(0, this.nextTrafficDensityCalculation - elapsed);
            if (this.nextTrafficDensityCalculation === 0) {
                this.updateTrafficDensityByZonesSlow(function () {
                    if (_this.city.grids.trafficDensityGrid.visible) {
                        _this.ensureTrafficDensityGridTilesUpdated();
                    }
                });
            }
        }
        if (this.lastUpdatePop !== -1 && Math.abs(this.city.stats.population - this.lastUpdatePop) > 500) {
            console.log("population changed by at least 500 since last calc, starting slow update");
            this.updateTrafficDensityByZonesSlow(function () {
                if (_this.city.grids.trafficDensityGrid.visible) {
                    _this.ensureTrafficDensityGridTilesUpdated();
                }
            });
        }
    };
    /** Slightly defer calculation of traffic density. can be used after updating road grid */
    TrafficDensity.prototype.updateTrafficDensitySoon = function () {
        this.nextTrafficDensityCalculation = 500;
    };
    TrafficDensity.prototype.updateRoadCoverageGraph = function () {
        var _this = this;
        Utils.setAll2D(this.roadCoverage, 0);
        var roadCoverageRange = 5;
        this.city.grids.roadGrid.forEachTile(function (t, row, col) {
            if (t) {
                for (var i = 0; i < roadCoverageRange; i++) {
                    Utils.foreachOnionLayer(row, col, i, _this.city.size, function (r, c) {
                        if (Utils.isValidIndex(r, c, _this.city.size)) {
                            _this.roadCoverage[r][c] += 1;
                        }
                    });
                }
            }
        });
        // normalize to percentages
        Utils.foreach2D(this.city.grids.roadGrid.tiles, function (t, r, c) {
            if (t) {
                _this.roadCoverage[r][c] = Math.min(1, _this.roadCoverage[r][c] / TrafficDensity.MAX_ROAD_REQUIRED_NEARBY_FOR_FULL_COVERAGE);
            } else {
                _this.roadCoverage[r][c] = 0;
            }
        });
    };
    //
    // Parking reduction
    //
    TrafficDensity.prototype.updateParkingGarageCoverage = function () {
        Utils.setAll2D(this.parkingGarageCoverageBool, 0);
        var garages = this.city.structureCache.getParkingGarages();
        for (var i = 0; i < garages.length; i++) {
            var g = garages[i];
            // loop rectangle
            var minIndex = {
                row: g.row - TrafficDensity.PARKING_GARAGE_RANGE,
                col: g.col - TrafficDensity.PARKING_GARAGE_RANGE
            };
            var maxIndex = {
                row: g.row + TrafficDensity.PARKING_GARAGE_RANGE,
                col: g.col + TrafficDensity.PARKING_GARAGE_RANGE
            };
            for (var r = minIndex.row; r <= maxIndex.row; r++) {
                for (var c = minIndex.col; c <= maxIndex.col; c++) {
                    if (this.city.grids.zoneGrid.isTouchingZone(r, c)) {
                        this.parkingGarageCoverageBool[r][c] = 1;
                    }
                }
            }
        }
    };
    //
    // Highway reduction
    //
    TrafficDensity.prototype.updateHighwayConnectedToRoadCoverage = function () {
        Utils.setAll2D(this.highwayConnectedBool, 0);
        Utils.setAll2D(this._highwayConnectedFloodTracked, 0);
        var _tracked = this.city.grids.roadGrid.getTrackedTilesOrError();
        var tile;
        var _keys = Object.keys(_tracked);
        var intersectionsToFloodfill = [];
        for (var _k = 0; _k < _keys.length; _k++) {
            tile = _tracked[_keys[_k]];
            if (!tile) continue;
            if (tile.variantType === Tile.Type.Highway && this.city.grids.roadGrid.isTouchingRoad(tile.row, tile.col, true)) {
                intersectionsToFloodfill.push(tile);
            }
        }
        for (var i = 0; i < intersectionsToFloodfill.length; i++) {
            this._floodFillConnectedHighway(intersectionsToFloodfill[i]);
        }
    };
    TrafficDensity.prototype._setNearbyRoadHasHighwayConnection = function (tile) {
        var _this = this;
        Utils.loopRectangle({ row: tile.row - TrafficDensity.HIGHWAY_INTERSECTION_REDUCE_RANGE, col: tile.col - TrafficDensity.HIGHWAY_INTERSECTION_REDUCE_RANGE }, { row: tile.row + TrafficDensity.HIGHWAY_INTERSECTION_REDUCE_RANGE, col: tile.col + TrafficDensity.HIGHWAY_INTERSECTION_REDUCE_RANGE }, this.city.size, function (r, c) {
            _this.highwayConnectedBool[r][c] = 1;
        });
    };
    TrafficDensity.prototype._floodFillConnectedHighway = function (tile) {
        var queue = [];
        queue[queue.length] = tile;
        var offsets = [[0, 1], [0, -1], [1, 0], [-1, 0]];
        var foundConnection = false;
        var rNext, cNext;
        var size = this.city.size;
        while (queue.length > 0) {
            var t = queue.pop();
            if (this._highwayConnectedFloodTracked[t.row][t.col]) {
                continue;
            }
            if (t !== tile && this.city.grids.roadGrid.isTouchingRoad(t.row, t.col, true)) {
                this._setNearbyRoadHasHighwayConnection(t);
                foundConnection = true;
            }
            this._highwayConnectedFloodTracked[t.row][t.col] = 1;
            for (var i = 0; i < offsets.length; i++) {
                var o = offsets[i];
                rNext = t.row + o[0];
                cNext = t.col + o[1];
                if (!Utils.isValidIndex(rNext, cNext, size)) continue;
                var nextTile = this.city.grids.roadGrid.tiles[rNext][cNext];
                if (nextTile && nextTile.variantType === Tile.Type.Highway) {
                    queue.push(nextTile);
                }
            }
        }
        if (foundConnection) {
            this._setNearbyRoadHasHighwayConnection(tile);
        }
    };
    TrafficDensity.prototype._checkCommercialToIndustrialConnectedness = function (group, numTilesStartNeedTarget) {
        // Group paths should only contain paths that are relevant to wants - e.g. residential -> commercial
        Object.keys(numTilesStartNeedTarget).forEach(function (k) {
            numTilesStartNeedTarget[k] = group.tiles.length;
        });
    };
    TrafficDensity.prototype.clearCurrentlyCalculating = function () {
        this._currentlyCalculating = 0;
        TRAFFIC_INC += 1;
    };
    /**
     * Main calculation
     * SLOW: update traffic density based on current zones (grouped)
     * If we need to apply additional metrics, we can maybe use a separate, faster applyTrafficDensitySideEffects() method
     */
    TrafficDensity.prototype.updateTrafficDensityByZonesSlow = function (cb) {
        var _this = this;
        if (this._currentlyCalculating) {
            console.log("already calculating density, returning");
            return false;
        }
        console.log("PERFORMING SLOW TRAFFIC DENSITY CALCULATION");
        this.updateRoadCoverageGraph();
        Utils.foreach2D(this.trafficDensity, function (v, r, c) {
            if (v > 0) {
                _this.trafficDensity[r][c] = 0;
            }
            _this.withoutTransitDensity[r][c] = 0;
        });
        this._currentlyCalculating = TRAFFIC_INC;
        var thisRunCalculateInc = TRAFFIC_INC;
        TRAFFIC_INC += 1;
        // Determine groups and paths
        // e.g. residential: {commercial: [2, 1]} //means the residential group -> commercial is not fully met
        var connectedness = (_a = {}, _a[Tile.Type.Residential] = (_b = {}, _b[Tile.Type.Commercial] = [], _b[Tile.Type.Industrial] = [], _b), _a[Tile.Type.Commercial] = (_c = {}, _c[Tile.Type.Industrial] = [], _c), _a); // tileType -> {targetGroupType -> [startGroupNum, endGroupTypeNum]}
        this.determineGroups(function (groups, indexToGroup) {
            if (thisRunCalculateInc != _this._currentlyCalculating) {
                // this run was canceled
                return;
            }
            // Update vertex densities for optimal paths
            groups.forEach(function (group) {
                var numTilesStartNeedTarget = (_a = {}, _a[Tile.Type.Commercial] = 0, _a[Tile.Type.Industrial] = 0, _a);
                if (Utils.countKeys(group.groupToPaths) === 0) {
                    if (connectedness.hasOwnProperty(group.tileType)) {
                        // no connected groups for this type that needs access to other groups
                        // - return 0 for connectedness for each target
                        Object.keys(connectedness[group.tileType]).forEach(function (target) {
                            connectedness[group.tileType][target].push([group.tiles.length, 0]);
                        });
                    }
                    // I no longer understand why this needs to be here, but it do
                    _this._checkCommercialToIndustrialConnectedness(group, numTilesStartNeedTarget);
                    return;
                }
                // Split paths into type
                var connectedGroupsByType = (_b = {}, _b[Tile.Type.Commercial] = [], _b[Tile.Type.Industrial] = [], _b[Tile.Type.Residential] = [], _b);
                // total path dist of each connected group type (based on distance)
                var totalDistance = (_c = {}, _c[Tile.Type.Commercial] = 0, _c[Tile.Type.Industrial] = 0, _c[Tile.Type.Residential] = 0, _c);
                // total number of tiles in connected group types
                var totalGroupTiles = (_d = {}, _d[Tile.Type.Commercial] = 0, _d[Tile.Type.Industrial] = 0, _d[Tile.Type.Residential] = 0, _d);
                Object.keys(group.groupToPaths).forEach(function (groupId) {
                    if (group.groupToPaths[groupId] && group.groupToPaths[groupId][0]) {
                        var endGroup = group.groupToPaths[groupId][0].rightGroup;
                        var endGroupType = endGroup.tileType;
                        connectedGroupsByType[endGroupType].push(groupId);
                        totalDistance[endGroupType] += group.groupToPaths[groupId][0].trafficTiles.length;
                        totalGroupTiles[endGroupType] += endGroup.tiles.length;
                    }
                });
                // Determine desirability of each group based on type (closer groups are more desirable, based on optimal road)
                // groupId -> number
                var desirability = {};
                // total tiles to group;
                // groupId -> number
                var totalPathTilesToGroup = {};
                var thisGroupConnectedTypesTrack = {};
                // calculate distance desirability for specific path
                // desirability based on closesness (using most optimal road shortest)
                Object.keys(group.groupToPaths).forEach(function (groupId) {
                    if (group.groupToPaths[groupId] && group.groupToPaths[groupId][0]) {
                        var endGroup = group.groupToPaths[groupId][0].rightGroup;
                        thisGroupConnectedTypesTrack[endGroup.tileType] = true;
                        desirability[groupId] = 1 - group.groupToPaths[groupId][0].trafficTiles.length / totalDistance[endGroup.tileType];
                        if (desirability[groupId] === 0) {
                            // can only happen if single path available
                            desirability[groupId] = 1;
                        }
                        // calculate total path tiles to specific group
                        totalPathTilesToGroup[groupId] = totalPathTilesToGroup[groupId] || 0;
                        totalPathTilesToGroup[groupId] += group.groupToPaths[groupId].reduce(function (acc, path) {
                            return acc + path.trafficTiles.length;
                        }, 0);
                    }
                });
                // also calculate desirability based on group size (larger end groups are more desirable)
                Object.keys(group.groupToPaths).forEach(function (groupId) {
                    if (group.groupToPaths[groupId] && group.groupToPaths[groupId][0]) {
                        var endGroup = group.groupToPaths[groupId][0].rightGroup;
                        var sizeDesirability = endGroup.tiles.length / totalGroupTiles[endGroup.tileType];
                        desirability[groupId] = desirability[groupId] || 0;
                        desirability[groupId] = (desirability[groupId] * TrafficDensity.DENSITY_GROUP_SIZE_WEIGHT + sizeDesirability * TrafficDensity.DENSITY_GROUP_SIZE_WEIGHT) * 0.5;
                    }
                });
                // Group paths should only contain paths that are relevant to wants - e.g. residential -> commercial
                _this._checkCommercialToIndustrialConnectedness(group, numTilesStartNeedTarget);
                // combine all group desirability of each type so that we know how to split traffic between similar groups
                var totalGroupTypeDesirability = (_e = {}, _e[Tile.Type.Commercial] = 0, _e[Tile.Type.Industrial] = 0, _e[Tile.Type.Residential] = 0, _e);
                Object.keys(desirability).forEach(function (groupId) {
                    if (group.groupToPaths[groupId] && group.groupToPaths[groupId][0]) {
                        var endType = group.groupToPaths[groupId][0].rightGroup.tileType;
                        totalGroupTypeDesirability[endType] += desirability[groupId];
                    }
                });
                //console.log("aggregate desirability to groups types:",totalGroupTypeDesirability);
                Object.keys(group.groupToPaths).forEach(function (groupId) {
                    var paths = group.groupToPaths[groupId];
                    if (!paths) return;
                    var groupDesirability = desirability[groupId]; // desirability by group distance + group size
                    var endType = paths[0].rightGroup.tileType;
                    var groupTypeTrafficShare = groupDesirability / totalGroupTypeDesirability[endType];
                    //console.log("group traffic share (same type should equal 1:)", groupTypeTrafficShare);
                    // e.g. 2 residential tiles want to drive to end group, numTilesStart is 2, split traffic into different paths
                    // rail and other non-car transport reduces this though
                    var totalPathsTiles = totalPathTilesToGroup[groupId];
                    if (totalPathsTiles == 0) {
                        return;
                    }
                    // determine desirability of each path in group based on distance from start
                    var pathDesirabilityInGroup = [];
                    for (var i = 0; i < Math.min(paths.length, TrafficDensity.MAX_PATHS_TRAVERSE); i++) {
                        var pathDesirability = 1 - paths[i].trafficTiles.length / totalPathsTiles;
                        if (pathDesirability === 0) {
                            // can only happen if single path available
                            pathDesirability = 1;
                        }
                        pathDesirabilityInGroup[i] = pathDesirability;
                    }
                    var totalDesirability = pathDesirabilityInGroup.reduce(function (a, v) {
                        return a + v;
                    }, 0);
                    for (var i = 0; i < Math.min(paths.length, TrafficDensity.MAX_PATHS_TRAVERSE); i++) {
                        if (paths[i].leftGroup !== group) {
                            throw new Error("left group is supposed to be start of path!");
                        }
                        var endTileType = paths[i].rightGroup.tileType;
                        var percentShareOfTraffic = pathDesirabilityInGroup[i] / totalDesirability;
                        //console.log("percentage share of traffic in this path to this group");
                        // Average the group desirability with path distance desirability
                        var numTilesStartAllocatedToGroup = numTilesStartNeedTarget[endTileType];
                        //console.log("num tiles start:", numTilesStartAllocatedToGroup);
                        //console.log("this particular path's share of traffic:",percentShareOfTraffic);
                        var dampen = paths[0].trafficTiles.length / paths[i].trafficTiles.length; // longer paths should dissolve traffic slightly so that final total is still the same
                        var increase = numTilesStartAllocatedToGroup * groupTypeTrafficShare * percentShareOfTraffic * dampen;
                        //console.log("final increase:", increase);
                        _this.addTrafficDensity(group.groupToPaths[groupId][i], _this.trafficDensity, increase);
                    }
                });
                // calculate connectedness as well
                var targetTileTypeCount = {};
                Object.keys(group.groupToPaths).forEach(function (groupId) {
                    if (group.groupToPaths[groupId] && group.groupToPaths[groupId][0]) {
                        var endGroup = group.groupToPaths[groupId][0].rightGroup;
                        targetTileTypeCount[endGroup.tileType] = targetTileTypeCount[endGroup.tileType] || 0;
                        targetTileTypeCount[endGroup.tileType] += endGroup.tiles.length;
                    }
                });
                Object.keys(targetTileTypeCount).forEach(function (targetGroupType) {
                    connectedness[group.tileType][targetGroupType].push([group.tiles.length, targetTileTypeCount[targetGroupType]]);
                });
                // also count 0 connectedness for group types we did not process
                var trackedTypes = Object.keys(thisGroupConnectedTypesTrack);
                if (connectedness.hasOwnProperty(group.tileType)) {
                    Object.keys(connectedness[group.tileType]).forEach(function (targetType) {
                        if (trackedTypes.indexOf(targetType) === -1) {
                            connectedness[group.tileType][targetType].push([group.tiles.length, 0]);
                        }
                    });
                }
                var _a, _b, _c, _d, _e;
            });
            // Add default BASE_TRAFFIC_ROAD_DENSITY
            _this.applyTrafficDensitySideEffects();
            _this.requiresTrafficGridUpdate = true;
            _this._currentlyCalculating = 0;
            var _total = 0;
            Utils.foreach2D(_this.trafficDensity, function (t) {
                if (t) _total += t;
            });
            //
            // Finalize
            //
            // update connectedness
            _this.connectedness = connectedness;
            var populationMultiplier = 1 + TrafficDensity.MAX_POPULATION_DENSITY_SCALE_MULTIPLIER * Math.min(1, _this.city.stats.population / TrafficDensity.POPULATION_SCALE_DENSITY_CAP);
            _this.lastUpdatePop = _this.city.stats.population;
            // reduce: airport
            var totalServedByAirport = TrafficDensity.AIRPORT_REDUCE_PER_CITIZENS * _this.city.structureCache.getAirports().length;
            var airportReduction = TrafficDensity.AIRPORT_REDUCE_AMT * Math.min(1, totalServedByAirport / _this.city.stats.population);
            // reduce: drone
            var droneReduction = _this.city.structureCache.hasDroneDepot() ? TrafficDensity.DRONE_TRAFFIC_REDUCE : 0;
            // reduce: final
            var reductionPerTile = airportReduction + droneReduction;
            // Reduce density and also sum for average density
            var totalDensity = 0;
            var totalCount = 0;
            var isAPlainsNeighbor = _this.city.stats.isNeighbor && _this.city.stats.regionType === Region.REGION_TYPES.PLAINS;
            Utils.copyArrVals(_this.trafficDensity, _this.withoutTransitDensity);
            var totalDensityBeforeTransit = 0;
            _this.reduceTrafficNearSkyrailStations(_this.trafficDensity);
            // loop over each road tile
            var _tracked = _this.city.grids.roadGrid.getTrackedTilesOrError();
            var t;
            var _keys = Object.keys(_tracked);
            for (var _k = 0; _k < _keys.length; _k++) {
                t = _tracked[_keys[_k]];
                if (!t) continue;
                //
                // normalize traffic density and apply global dampening:
                // - from high road coverage
                // - from airports
                //
                var r = t.row;
                var c = t.col;
                _this.applyReductionsToTrafficArr(_this.trafficDensity, isAPlainsNeighbor, r, c, populationMultiplier, reductionPerTile);
                _this.applyReductionsToTrafficArr(_this.withoutTransitDensity, isAPlainsNeighbor, r, c, populationMultiplier, reductionPerTile);
                //
                // Apply individual road tile congestion reduction (includes busses)
                //
                var congestionReduction = t.congestionReduction();
                _this.trafficDensity[r][c] = Math.max(0, _this.trafficDensity[r][c] - congestionReduction);
                var congestionReductionWOBusses = congestionReduction;
                if (_this.city.busStopLayer.coverageGrid[r][c]) {
                    congestionReductionWOBusses -= BusStopLayer.TRAFFIC_REDUCTION_BUS;
                }
                _this.withoutTransitDensity[r][c] = Math.max(0, _this.withoutTransitDensity[r][c] - congestionReductionWOBusses);
                totalDensity += _this.trafficDensity[r][c] || 0;
                totalDensityBeforeTransit += _this.withoutTransitDensity[r][c] || 0;
                totalCount += 1;
            }
            if (totalCount === 0) {
                _this.averageDensity = 0;
                _this.transitDensityImprovement = 0;
            } else {
                var transitDiffMult = Difficulty.getTrafficDensityMult(_this.city);
                _this.averageDensity = Math.min(1, totalDensity * transitDiffMult / totalCount);
                var averageDensityWithoutTransit = Math.min(1, totalDensityBeforeTransit * transitDiffMult / totalCount);
                _this.transitDensityImprovement = Math.max(0, averageDensityWithoutTransit - _this.averageDensity);
                if (_this.city.traffic.areHoverCarsUnlocked()) {
                    _this.averageDensity = Math.max(0, _this.averageDensity - 0.5);
                }
                if (_this.city.isPolicyActive(Policy.CODES.ROAD_MAINTENANCE)) {
                    _this.averageDensity = Math.max(0, _this.averageDensity - Policy.CONSTS.ROAD_MAINTENANCE_IMPROVEMENT);
                }
                if (_this.city.isPolicyActive(Policy.CODES.CYCLING_INCENTIVE)) {
                    _this.averageDensity = Math.max(0, _this.averageDensity - Policy.CONSTS.CYCLING_INCENTIVE_TRAFFIC_IMPROVE);
                }
            }
            _this.city.traffic.flushCachedTrafficDensity();
            // groups to be reset into pool
            for (var i = 0; i < groups.length; i++) {
                _this.groupPool.free(groups[i]);
            }
            // done
            if (cb) {
                cb();
            }
        });
        var _a, _b, _c;
    };
    TrafficDensity.prototype.applyReductionsToTrafficArr = function (trafficDensityArr, isAPlainsNeighbor, r, c, populationMultiplier, reductionPerTile) {
        var val = trafficDensityArr[r][c];
        var d = Math.min(1, (val || 0) * TrafficDensity.DENSITY_MULTIPLIER);
        // coverage
        var variableFromCoverage = d * TrafficDensity.MAX_DENSITY_REDUCTION_BY_COVERAGE * (1 - this.roadCoverage[r][c]);
        trafficDensityArr[r][c] = d * (1 - TrafficDensity.MAX_DENSITY_REDUCTION_BY_COVERAGE) + variableFromCoverage;
        // pop
        trafficDensityArr[r][c] *= populationMultiplier;
        trafficDensityArr[r][c] = Math.min(TrafficDensity.MAX_TILE_DENSITY_BEFORE_CONGESTION_REDUCE, trafficDensityArr[r][c]);
        // global reductions
        trafficDensityArr[r][c] -= reductionPerTile;
        if (isAPlainsNeighbor) {
            trafficDensityArr[r][c] = Math.max(0, trafficDensityArr[r][c] - RegionBoosts.PLAINS_TRAFFIC_BOOST);
        }
    };
    // needs to happen AFTER sky rail traffic has been updated
    TrafficDensity.prototype.reduceTrafficNearSkyrailStations = function (trafficDensity) {
        var _this = this;
        var stations = this.city.skyRailTraffic.getStationsConnectedToOthers();
        var reduction = TrafficDensity.SKYRAIL_REDUCTION_AROUND_SPAWN_EACH_STATION * stations.length;
        var multReduction = 1;
        if (Policy.isPolicyActive(this.city, Policy.CODES.SKYRAIL_SPEED)) {
            reduction = reduction + Policy.CONSTS.SKYRAIL_SPEED_IMPROVE_REDUCE;
            multReduction = Policy.CONSTS.SKYRAIL_SPEED_IMPROVE_REDUCE_MULT_ALT;
        }
        var radius = TrafficDensity.SKYRAIL_REDUCTION_STATION_RADIUS;
        if (this.city.isPolicyActive(Policy.CODES.SKYRAIL_REDUCED_TICKETS)) {
            radius = Math.round(radius * Policy.CONSTS.SKYRAIL_REDUCED_TICKETS_RANGE_MULT);
        } else if (this.city.isPolicyActive(Policy.CODES.SKYRAIL_SPEED)) {
            radius += Policy.CONSTS.SKYRAIL_REDUCED_TICKETS_RANGE_MULT_1;
        }
        stations.forEach(function (stationTile) {
            Utils.forAllOnionLayers(_this.city, stationTile.row, stationTile.col, radius, function (r, c) {
                trafficDensity[r][c] = Math.min(Math.max(0, trafficDensity[r][c] - reduction), Math.max(0, trafficDensity[r][c] * multReduction));
            });
        });
    };
    /** faster calculation on top of slow base calculation */
    TrafficDensity.prototype.applyTrafficDensitySideEffects = function () {
        // additional checks can go here, maybe for side effects from other components
    };
    /**
     * Grid tiles update function
     * Update grid to match current traffic density
     */
    TrafficDensity.prototype.ensureTrafficDensityGridTilesUpdated = function () {
        var _this = this;
        if (!this.requiresTrafficGridUpdate || this.city.headlessMode) {
            return;
        }
        var whiteTilePool = this.city.whiteTilePool;
        var curTile, density;
        Utils.foreach2D(this.city.grids.trafficDensityGrid.tiles, function (trafficDensityTile, row, col) {
            curTile = _this.city.grids.trafficDensityGrid.tiles[row][col];
            density = _this.trafficDensity[row][col];
            if (density || _this.city.isRoadTile(row, col)) {
                density = density || 0;
                if (!curTile) {
                    curTile = whiteTilePool.allocate();
                    _this.city.grids.trafficDensityGrid.setTile(row, col, curTile);
                }
                curTile.visible = true;
                var tintIndex = Math.min(Math.floor(density * TrafficDensity.TRAFFIC_TINT_ORDERED.length), TrafficDensity.TRAFFIC_TINT_ORDERED.length - 1);
                curTile.tint = TrafficDensity.TRAFFIC_TINT_ORDERED[tintIndex];
            } else if (curTile) {
                whiteTilePool.free(curTile);
                _this.city.grids.trafficDensityGrid.unsetTile(row, col);
            }
        });
        if (this.city.grids.trafficDensityGrid.visible) {
            this.city.smartUpdateNext();
        }
        this.requiresTrafficGridUpdate = false;
    };
    //
    // Helpers
    //
    TrafficDensity.prototype.addTrafficDensity = function (path, densityGraph, increase) {
        var _this = this;
        // round it:
        path.trafficTiles.forEach(function (index) {
            var _a = Utils.toRowColReuse(index, _this.city.size),
                row = _a[0],
                col = _a[1];
            if (!_this.city.isRoadTile(row, col)) return;
            densityGraph[row][col] = densityGraph[row][col] || 0;
            densityGraph[row][col] += increase;
        });
        // Also apply path to all touching road tiles around grid
        var traversed = {};
        var queue = [];
        var startTile = path.trafficTiles[0];
        var _a = Utils.toRowColReuse(startTile, this.city.size),
            originalStartRow = _a[0],
            originalStartCol = _a[1];
        if (!startTile) return;
        queue.push(startTile);
        while (queue.length > 0) {
            var i = queue.shift();
            var _b = Utils.toRowColReuse(i, this.city.size),
                row = _b[0],
                col = _b[1];
            var indexKey = Utils.toIndexKey(row, col, this.city.size);
            if (traversed[indexKey] || row === startTile[0] && col === startTile[1]) {
                continue;
            }
            if (row !== originalStartRow || col !== originalStartCol) {
                densityGraph[row][col] = densityGraph[row][col] || 0;
                densityGraph[row][col] += increase;
            }
            traversed[indexKey] = 1;
            Utils.mapTouchingTiles(row, col, this.city.size, function (childRow, childCol) {
                if (path.leftGroup.touchingTrafficTileIndexesHash[Utils.toIndexKey(childRow, childCol, _this.city.size)]) {
                    queue.push([childRow, childCol]);
                }
            });
        }
    };
    // The longer the suboptimal, the bigger (more dense) the optimal path
    // if even length, should return 0.5
    TrafficDensity.getOptimalMultiplier = function (optimalPathLength, subOptimalPathLength) {
        return 1 - TrafficDensity.getSubOptimalMultiplier(optimalPathLength, subOptimalPathLength);
    };
    // If even, should return 0.5
    TrafficDensity.getSubOptimalMultiplier = function (optimalPathLength, subOptimalPathLength) {
        if (subOptimalPathLength <= optimalPathLength) {
            return 0.5;
        }
        var result = 0.5 - Math.log(1.4) * 0.3;
        return Math.round(result * 100) / 100;
    };
    TrafficDensity.prototype.determineGroups = function (asyncCallback) {
        var _this = this;
        if (asyncCallback === void 0) {
            asyncCallback = null;
        }
        if (!this._reuseGroupsArray) {
            this._reuseGroupsArray = Utils.initialize2DArray(this.city.size, this.city.size, 0);
        } else {
            Utils.setAll2D(this._reuseGroupsArray, 0);
        }
        // For each tile, try to floodfill and determine group
        var grouped = this._reuseGroupsArray;
        var groups = [];
        var _tracked = this.city.grids.zoneGrid.getTrackedTilesOrError();
        var tile;
        var _keys = Object.keys(_tracked);
        var asyncDispatched = 0;
        var groupAsyncCount = 0;
        var loopDone = false;
        var groupAsyncCb = function groupAsyncCb(noCounter) {
            if (!noCounter) {
                groupAsyncCount += 1;
            }
            if (loopDone && groupAsyncCount === asyncDispatched) {
                // determine touching traffic tiles
                groups.forEach(function (group) {
                    _this._initializeTouchingTrafficTiles(group);
                });
                // determine paths to other groups
                _this._initializeConnectedGroups(groups, asyncCallback);
            }
        };
        for (var _k = 0; _k < _keys.length; _k++) {
            tile = _tracked[_keys[_k]];
            if (_k === _keys.length - 1) {
                loopDone = true;
            }
            if (!tile || grouped[tile.row][tile.col] || !tile.createsTraffic()) {
                groupAsyncCb(true);
                continue;
            }
            var group = this.groupPool.allocate();
            group.tileType = tile.type;
            groups.push(group);
            asyncDispatched += 1;
            this._addToGroupAsync(group, tile.row, tile.col, grouped, groupAsyncCb);
        }
        // if no keys, finish right away
        if (_keys.length === 0) {
            loopDone = true;
            groupAsyncCb(true);
        }
    };
    TrafficDensity.prototype._addToGroupAsync = function (group, row, col, groupedGrid, cb) {
        var unProcessed = [];
        this._addToGroup(group, row, col, groupedGrid, 0, unProcessed);
        if (unProcessed.length > 0) {
            var calledBack_1 = 0;
            for (var i = 0; i < unProcessed.length; i++) {
                var row_1 = unProcessed[i][0];
                var col_1 = unProcessed[i][1];
                this._addToGroupAsync(group, row_1, col_1, groupedGrid, function () {
                    calledBack_1 += 1;
                    if (calledBack_1 === unProcessed.length) {
                        cb();
                    }
                });
            }
        } else {
            cb();
        }
    };
    /** Returns whether group was successfully processed */
    TrafficDensity.prototype._addToGroup = function (group, row, col, groupedGrid, curCount, unprocessed) {
        var _this = this;
        if (curCount > TrafficDensity.BATCH_GROUP_CALC_SIZE) {
            unprocessed.push([row, col]);
            return;
        }
        if (groupedGrid[row][col]) {
            return;
        }
        var tile = this.city.grids.zoneGrid.tiles[row][col];
        if (!tile || tile.type !== group.tileType) {
            return;
        }
        group.pushTile(tile);
        groupedGrid[row][col] = 1;
        Utils.mapTouchingTiles(row, col, this.city.size, function (nRow, nCol) {
            _this._addToGroup(group, nRow, nCol, groupedGrid, curCount + 1, unprocessed);
        });
    };
    TrafficDensity.prototype._initializeTouchingTrafficTiles = function (group) {
        var _this = this;
        var added = {};
        var trafficTiles = [];
        var s = this.city.size;
        for (var i = 0; i < group.tiles.length; i++) {
            var tile = group.tiles[i];
            Utils.mapTouchingTiles(tile.row, tile.col, s, function (nRow, nCol) {
                var k = Utils.toIndexKey(nRow, nCol, s);
                if (added[k]) return;
                if (Utils.isValidIndex(nRow, nCol, s) && _this._isTrafficPath(nRow, nCol)) {
                    added[k] = true;
                    trafficTiles.push(k);
                }
            });
        }
        group.setTouchingTrafficIndexes(trafficTiles, this.city.size);
        trafficTiles.forEach(function (tileIndexKey) {
            if (_this._isPotentialPathConnector(Utils.toRowColReuse(tileIndexKey, _this.city.size), group)) {
                group.pathConnectors[tileIndexKey] = 1;
            }
        });
    };
    /** check if a traffic tile index touches more groups than just its own */
    TrafficDensity.prototype._isPotentialPathConnector = function (trafficTileIndex, ownGroup) {
        var _this = this;
        var potential = false;
        Utils.mapTouchingTiles(trafficTileIndex[0], trafficTileIndex[1], this.city.size, function (row, col) {
            if (potential) return; // no need to do more checks
            // 1. touches other group
            if (_this.city.grids.zoneGrid.tiles[row][col] && !ownGroup.tilesByHash[Utils.toIndexKey(row, col, _this.city.size)]) {
                potential = true;
                return;
            }
            // 2. or touches tile that is not connected to self
            if (!ownGroup.touchingTrafficTileIndexesHash[Utils.toIndexKey(row, col, _this.city.size)]) {
                potential = true;
                return;
            }
        });
        return potential;
    };
    TrafficDensity.prototype._isTrafficPath = function (row, col) {
        return this.city.grids.roadGrid.tiles[row][col];
    };
    // 2. pt1 - determine traffic tiles touching tiles (roadgrid and skyrailgrid)
    TrafficDensity.prototype._initializeConnectedGroups = function (groups, asyncCallback) {
        var _this = this;
        if (asyncCallback === void 0) {
            asyncCallback = null;
        }
        var indexToGroup = this.indexToGroup;
        this.indexToGroup = Utils.setAll2D(this.indexToGroup, null);
        groups.forEach(function (group) {
            group.tiles.forEach(function (t) {
                indexToGroup[t.row][t.col] = group;
            });
        });
        // Async operation
        if (asyncCallback) {
            var groupsLength_1 = groups.length;
            var doneCount_1 = 0;
            if (!groupsLength_1) {
                asyncCallback(groups);
            }
            groups.forEach(function (group, i) {
                setTimeout(function () {
                    if (!_this.city.alive || !_this.city.game) return;
                    if (group) {
                        group.paths.length = 0;
                        _this._BFSGroupToOtherGroups(group, indexToGroup, group.paths);
                    }
                    doneCount_1 += 1;
                    // Completion
                    if (doneCount_1 === groupsLength_1) {
                        groups.forEach(function (group) {
                            if (group) {
                                group.sortPaths();
                            }
                        });
                        asyncCallback(groups, indexToGroup);
                    }
                }, i * TrafficDensity.STAGGER_CALCULATION_DELAY);
            });
        }
        /// Synchronous operation
        else {
                groups.forEach(function (group) {
                    group.paths.length = 0;
                    _this._BFSGroupToOtherGroups(group, indexToGroup, group.paths);
                });
                groups.forEach(function (group) {
                    group.sortPaths();
                });
            }
    };
    // Updates the paths inside groups
    // Find connected groups using BFS
    // stop if we've satisfied minmum requirements
    // Uses tile type to figure out which to bfs with
    TrafficDensity.prototype._BFSGroupToOtherGroups = function (group, _indexToGroupCache, paths) {
        if (!group.touchingTrafficTileIndexes.length) {
            return [];
        }
        var maxDesiredCount = group.tiles.length; // only need up to this number
        var targetTileTypes = [];
        if (group.tileType === Tile.Type.Residential) {
            targetTileTypes = [Tile.Type.Commercial, Tile.Type.Industrial];
        } else if (group.tileType === Tile.Type.Commercial) {
            targetTileTypes = [Tile.Type.Industrial];
        }
        if (targetTileTypes.length === 0) {
            return [];
        }
        var reachedGroupTypeCountDown = {};
        targetTileTypes.forEach(function (tileType) {
            reachedGroupTypeCountDown[tileType] = maxDesiredCount;
        });
        var size = this.city.size;
        var traversed = {};
        var endTrafficTileToGraph = {}; // RxC -> [Group] to ensure we don't create multiple paths to same group for same source
        // e.g. if group "wraps" around a common road tile.
        // but we do want the road tile to be eligible for multiple "wrapped" zone types
        var potentialConnectors = group.getPotentialConnectingTrafficIndexKeys();
        var pathsParents = {}; //maps child RxC to its parent RxC
        var queue = [];
        var numChecked = 0;
        for (var i = 0; i < potentialConnectors.length; i++) {
            queue.push(potentialConnectors[i]);
        }
        var _loop_1 = function _loop_1() {
            // if all countdown is 0, break
            var hasCountdown = false;
            var hasNonZeroCountdown = false;
            Object.keys(reachedGroupTypeCountDown).forEach(function (tileType) {
                hasCountdown = true;
                if (reachedGroupTypeCountDown[tileType] > 0) {
                    hasNonZeroCountdown = true;
                }
            });
            if (hasCountdown && !hasNonZeroCountdown && numChecked > TrafficDensity.MIN_CHECK_BEFORE_STOP_SEEKING_NEW_PATHS) {
                return "break";
            }
            var currentIndex = queue.shift();
            var _a = Utils.toRowColReuse(currentIndex, size),
                curRow = _a[0],
                curCol = _a[1];
            // check if reached end goal (zone tile)
            // see if we should push it to result set
            if (this_1.city.grids.zoneGrid.tiles[curRow][curCol] && this_1.city.grids.zoneGrid.tiles[curRow][curCol].createsTraffic()) {
                var k = pathsParents[currentIndex]; // parents are final tile before reaching end tile
                var endGroup = _indexToGroupCache[curRow][curCol];
                if (endGroup && targetTileTypes.indexOf(endGroup.tileType) !== -1 && (!endTrafficTileToGraph[k] || endTrafficTileToGraph[k].indexOf(endGroup) === -1) &&
                // ^ ensures not already used to match same right graph again
                endGroup.pathConnectors[k]) {
                    // need to know which group is here tho
                    // tracks which group(s) the end tile has tracked already, because it can touch multiple
                    endTrafficTileToGraph[k] = endTrafficTileToGraph[k] || [];
                    endTrafficTileToGraph[k].push(endGroup);
                    if (reachedGroupTypeCountDown.hasOwnProperty(endGroup.tileType)) {
                        reachedGroupTypeCountDown[endGroup.tileType] -= endGroup.tiles.length;
                    }
                    paths.push(new TrafficDensity.Path(group, endGroup, this_1._buildCompletePath(curRow, curCol, pathsParents)));
                }
                return "continue";
            }
            // check if unuseful tile to kill
            var indexKey = Utils.toIndexKey(curRow, curCol, size);
            if (traversed[indexKey] || !this_1._isTrafficPath(curRow, curCol)) {
                return "continue";
            }
            // push children to check
            traversed[indexKey] = 1;
            Utils.mapTouchingTiles(curRow, curCol, size, function (childRow, childCol) {
                var kChild = Utils.toIndexKey(childRow, childCol, size);
                if (traversed[kChild] ||
                // encounter another connector
                group.pathConnectors[kChild]) {
                    return;
                }
                pathsParents[kChild] = Utils.toIndexKey(curRow, curCol, size);
                queue.push(kChild);
            });
            numChecked += 1;
        };
        var this_1 = this;
        // BFS START
        while (queue.length > 0) {
            var state_1 = _loop_1();
            if (state_1 === "break") break;
        }
        return paths;
    };
    TrafficDensity.prototype._buildCompletePath = function (excludedFinalRow, excludedFinalCol, pathsParents) {
        if (excludedFinalRow === void 0) {
            excludedFinalRow = null;
        }
        if (excludedFinalCol === void 0) {
            excludedFinalCol = null;
        }
        var checkKey = Utils.toIndexKey(excludedFinalRow, excludedFinalCol, this.city.size);
        var built = {};
        var path = [];
        while (checkKey !== null) {
            if (pathsParents[checkKey]) {
                var pKey = pathsParents[checkKey];
                path.push(+pKey);
                // error check
                if (built[pKey]) {
                    throw new Error("circular path detected - already checked " + pKey);
                }
                built[pKey] = 1;
                checkKey = pKey;
            } else {
                checkKey = null;
            }
        }
        Utils.reverseInPlace(path);
        return path;
    };
    //
    // Connectedness/Access get
    //
    TrafficDensity.prototype.residentialToCommercialAccess = function () {
        return this._calculateConnectedAccess(Tile.Type.Residential, Tile.Type.Commercial);
    };
    TrafficDensity.prototype.residentialToIndustrialAccess = function () {
        return this._calculateConnectedAccess(Tile.Type.Residential, Tile.Type.Industrial);
    };
    TrafficDensity.prototype.commercialToIndustrialAccess = function () {
        return this._calculateConnectedAccess(Tile.Type.Commercial, Tile.Type.Industrial);
    };
    TrafficDensity.prototype.avgAccess = function () {
        if (this.city.traffic.areHoverCarsUnlocked()) {
            return 1;
        }
        if (!this.connectedness) {
            return null;
        }
        var total = 0;
        var valuesTotal = [this.residentialToCommercialAccess(), this.residentialToIndustrialAccess(), this.commercialToIndustrialAccess()].reduce(function (a, v) {
            if (v === null) {
                return a;
            } else {
                total += 1;
                return v + a;
            }
        }, 0);
        if (total === 0) {
            return null;
        } else {
            var val = valuesTotal / total;
            if (this.city.stats.isNeighbor && this.city.stats.regionType === Region.REGION_TYPES.PLAINS) {
                val += RegionBoosts.PLAINS_TRAFFIC_BOOST;
            }
            return Math.min(1, val);
        }
    };
    TrafficDensity.prototype._calculateConnectedAccess = function (startType, endType) {
        if (!this.connectedness) {
            return null;
        }
        var desired = 0;
        var accessed = 0;
        this.connectedness[startType][endType].forEach(function (tuple) {
            desired += tuple[0];
            accessed += tuple[1];
        });
        if (desired === 0) {
            return null;
        }
        return Math.min(1, accessed / desired);
    };
    // Debugging
    /** represent this group as a 2d array of ints (for tile type */
    TrafficDensity.prototype.debugGroupsTo2DArray = function (groups) {
        var grid = Utils.initialize2DArray(this.city.size, this.city.size);
        groups.forEach(function (group) {
            group.tiles.forEach(function (t) {
                grid[t.row][t.col] = t.type;
            });
        });
        return grid;
    };
    // balance related
    TrafficDensity.SKYRAIL_REDUCTION = 0.5; //  e.g. player can reduce traffic by sending skyrail to link to a single group of size 1, but its ok
    // update - i'm not really sure how SKYRAIL_REDUCTION works anymore
    // sky rail reduces traffic near stations. the more linked stations, the more each station reduces traffic
    TrafficDensity.SKYRAIL_REDUCTION_AROUND_SPAWN_EACH_STATION = 0.35;
    TrafficDensity.SKYRAIL_REDUCTION_STATION_RADIUS = 5;
    TrafficDensity.MAX_TILE_DENSITY_BEFORE_CONGESTION_REDUCE = 1.05; // if too high, we don't see enough impact from buildings..
    TrafficDensity.DENSITY_MULTIPLIER = 0.1; // higher = more dense.
    // 0.1 tiles means it takes 0.1 tiles trying to squeeze through a road to reach 100%
    // left and right both add, so density is double applied
    TrafficDensity.MAX_ROAD_REQUIRED_NEARBY_FOR_FULL_COVERAGE = 30; // higher = each road tile is less effective at adding coverage
    TrafficDensity.MAX_DENSITY_REDUCTION_BY_COVERAGE = 0.8;
    TrafficDensity.POPULATION_SCALE_DENSITY_CAP = 10 * 1000; // after this number, traffic no longer scales in difficulty
    TrafficDensity.MAX_POPULATION_DENSITY_SCALE_MULTIPLIER = 5; // traffic is this X bad at max cap
    TrafficDensity.AIRPORT_REDUCE_AMT = 0.15;
    TrafficDensity.AIRPORT_REDUCE_PER_CITIZENS = 10000;
    TrafficDensity.PARKING_GARAGE_REDUCE_PER_TILE = 0.35;
    TrafficDensity.PARKING_GARAGE_RANGE = 8;
    TrafficDensity.HIGHWAY_INTERSECTION_REDUCE_RANGE = 6;
    TrafficDensity.HIGHWAY_INTERSECTION_REDUCE = 0.2;
    TrafficDensity.DENSITY_GROUP_SIZE_WEIGHT = 0.6; // distance vs group size weighting
    TrafficDensity.TRAFFIC_TINT = 0xee0000;
    TrafficDensity.TRAFFIC_TINT_VERY_BAD = 0xf56d51;
    TrafficDensity.TRAFFIC_TINT_BAD = 0xf89c72;
    TrafficDensity.TRAFFIC_TINT_OKAY = 0xfbc98e;
    TrafficDensity.TRAFFIC_TINT_GOOD = 0xe6f076;
    TrafficDensity.TRAFFIC_TINT_VERY_GOOD = 0xa9f064;
    TrafficDensity.TRAFFIC_TINT_ORDERED = [TrafficDensity.TRAFFIC_TINT_VERY_GOOD, TrafficDensity.TRAFFIC_TINT_GOOD, TrafficDensity.TRAFFIC_TINT_OKAY, TrafficDensity.TRAFFIC_TINT_BAD, TrafficDensity.TRAFFIC_TINT_VERY_BAD];
    TrafficDensity.STAGGER_CALCULATION_DELAY = 20;
    TrafficDensity.MAX_PATHS_TRAVERSE = 3;
    TrafficDensity.MIN_CHECK_BEFORE_STOP_SEEKING_NEW_PATHS = 100; // if all target group size is already satisfied, stop seeking new paths after this many BFS steps
    TrafficDensity.DRONE_TRAFFIC_REDUCE = 0.15;
    TrafficDensity.BATCH_GROUP_CALC_SIZE = 500;
    return TrafficDensity;
}();
var TrafficGroupPool = /** @class */function (_super) {
    __extends(TrafficGroupPool, _super);
    function TrafficGroupPool(city) {
        var _this = _super.call(this) || this;
        _this.city = city;
        _this.game = city.game;
        return _this;
    }
    TrafficGroupPool.prototype.allocate = function () {
        return this._freeEntities.length > 0 ? this._freeEntities.shift() : this.createEntity();
    };
    TrafficGroupPool.prototype.free = function (entity) {
        if (!entity) {
            throw new MissingArgsError();
        }
        if (entity.reset) {
            entity.reset();
        }
        this._freeEntities.push(entity);
    };
    TrafficGroupPool.prototype.createEntity = function () {
        return new TrafficDensity.Group(null);
    };
    return TrafficGroupPool;
}(EntityPool);
(function (TrafficDensity) {
    var groupId = 0;
    var Group = /** @class */function () {
        function Group(tileType) {
            this.tiles = [];
            this.tilesByHash = {};
            this.tileType = null;
            this.touchingTrafficTileIndexes = []; // array of [ROW,COL] tuples
            this.touchingTrafficTileIndexesHash = {};
            this.pathConnectors = {}; // index key ROW COL representing tiles that can be used to connect path
            this.paths = [];
            this.groupToPaths = {}; // mapping of group ID to list of most optimal paths to get there
            this.id = groupId;
            this.tileType = tileType;
            groupId += 1;
        }
        Group.prototype.reset = function () {
            this.tiles.length = 0;
            Utils.resetObject(this.tilesByHash);
            this.touchingTrafficTileIndexes.length = 0;
            Utils.resetObject(this.touchingTrafficTileIndexesHash);
            Utils.resetObject(this.pathConnectors);
            this.paths.length = 0;
            Utils.resetObject(this.groupToPaths);
        };
        Group.prototype.pushTile = function (tile) {
            this.tiles.push(tile);
            this.tilesByHash[Utils.toIndexKey(tile.row, tile.col, tile.city.size)] = 1;
        };
        Group.prototype.setTouchingTrafficIndexes = function (indexes, citySize) {
            var _this = this;
            this.touchingTrafficTileIndexes = indexes;
            indexes.forEach(function (i) {
                _this.touchingTrafficTileIndexesHash[Utils.toIndexKey(i[0], i[1], citySize)] = 1;
            });
        };
        Group.prototype.getPotentialConnectingTrafficIndexKeys = function () {
            return Object.keys(this.pathConnectors).map(function (c) {
                return +c;
            });
        };
        Group.prototype.sortPaths = function () {
            var _this = this;
            this.paths.sort(function (a, b) {
                if (a.trafficTiles.length < b.trafficTiles.length) {
                    return -1;
                } else if (a.trafficTiles.length > b.trafficTiles.length) {
                    return 1;
                } else {
                    return 0;
                }
            });
            this.paths.forEach(function (path) {
                var rightG = path.rightGroup;
                _this.groupToPaths[rightG.id] = _this.groupToPaths[rightG.id] || [];
                _this.groupToPaths[rightG.id].push(path);
            });
        };
        return Group;
    }();
    TrafficDensity.Group = Group;
    var Path = /** @class */function () {
        function Path(leftGroup, rightGroup, trafficTiles) {
            if (!leftGroup || !rightGroup || !trafficTiles) {
                throw new Error("Missing args " + leftGroup + " " + rightGroup + " " + trafficTiles);
            }
            this.leftGroup = leftGroup;
            this.rightGroup = rightGroup;
            this.trafficTiles = trafficTiles;
        }
        return Path;
    }();
    TrafficDensity.Path = Path;
})(TrafficDensity || (TrafficDensity = {}));
var TownHallHelper = /** @class */function () {
    function TownHallHelper(city) {
        this.city = city;
    }
    TownHallHelper.prototype.getHTML = function () {
        var city = this.city;
        if (!city) return "";
        var currentFrame = city.citySaveHelper.getGlobalSetting(TownHallHelper.GLOB_SETTING_TH_FRAME);
        var html = "";
        var unlocked = city.grids.structureGrid.townHallHelper.getUnlockedSkinsObjSet();
        for (var i = 0; i < TownHallHelper.SKINS.length; i++) {
            var skin = TownHallHelper.SKINS[i];
            var cls = void 0;
            var isUnlocked = unlocked[skin.frame] || skin.frame === "th-0";
            if (city.isSandbox) {
                isUnlocked = TownHallHelper.REWARD_BY_FRAME[skin.frame] || skin.frame === "th-0";
            }
            if (isUnlocked) {
                cls = "th-skin srcwwwimgatlasdeferred" + (skin.frame.substr(0, 2) + skin.frame.substr(3)) + "png";
            } else {
                cls = "th-skin locked";
            }
            if (currentFrame && currentFrame === skin.frame || !currentFrame && skin.frame === "th-0") {
                cls += " active";
            }
            if (!Global.IS_DELUXE && skin.frame !== "th-0" && skin.frame !== "th-11") {
                // free version, random rewards can't be unlocked
                cls += " th-full";
                html += "<div class=\"" + cls + "\"><span class=\"skin-name locked-th-sp\"></span><img src=\"img/fullversion.png\" class=\"locked-th fv-locked-th\"></div>";
            } else if (isUnlocked) {
                html += "<div class=\"" + cls + "\" data-frame=\"" + skin.frame + "\"><span class=\"skin-name\"></span></div>";
            } else {
                html += "<div class=\"" + cls + "\"><span class=\"skin-name locked-th-sp\"></span><img src=\"img/locked.png\" class=\"locked-th\"></div>";
            }
        }
        return html;
    };
    // Interaction with setCustomSkin is a bit confusing, try not to change much
    TownHallHelper.prototype.syncCustomSkin = function () {
        this.checkLiveSkin();
        // ensure skin exists or does not exist
        var th = this.getTownHall();
        if (!th || !this.chosenFrame) {
            Utils.destroyIfAlive(this.skinMask);
            return;
        }
        if (!this.skinMask) {
            this.setCustomSkin(this.chosenFrame);
        } else {
            this.syncCustomSkinPosition();
        }
    };
    TownHallHelper.prototype.syncCustomSkinPosition = function () {
        // position + scale
        this.skinMask.scale.setTo(1, 1);
        this.skinMask.x = Tile.TILE_WIDTH * -1.16;
        this.skinMask.y = Tile.TILE_WIDTH * -1.43;
        this.checkAddShines();
    };
    TownHallHelper.prototype.checkAddShines = function () {
        var th = this.getTownHall();
        if (!th) return;
        if (!th.structureGroup || !th.structureGroup.upperMaskSprite) {
            return;
        }
        if (this.chosenFrame !== "th-11") {
            // clear shines
            for (var i = 0; i < th.structureGroup.effects.length; i++) {
                if (th.structureGroup.effects[i] instanceof ShineDeferred) {
                    th.structureGroup.effects[i].destroy();
                }
            }
            return;
        }
        // add shines
        var shines = [];
        for (var i = 0; i < 2; i++) {
            var s = new ShineDeferred(this.city, th.structureGroup.upperMaskSprite, i * 750);
            s.x = Tile.TILE_WIDTH * -0.15;
            s.y = Tile.TILE_WIDTH * 0.1;
            shines.push(s);
        }
        Utils.scaleToWidth(shines[0], Tile.TILE_WIDTH * 0.4);
        Utils.scaleToWidth(shines[1], Tile.TILE_WIDTH * 0.55);
        shines[1].x = Tile.TILE_WIDTH * 0.85;
        shines[1].y = Tile.TILE_WIDTH * 0.55;
        for (var j = 0; j < 2; j++) {
            th.structureGroup.effects.push(shines[j]);
        }
    };
    TownHallHelper.prototype.getUnlockedSkinsObjSet = function () {
        return this.city.citySaveHelper.getGlobalSetting(TownHallHelper.GLOB_SETTING_TH_UNLOCKS, {});
    };
    TownHallHelper.prototype.saveUnlockSkin = function (frame) {
        var obj = this.getUnlockedSkinsObjSet();
        obj[frame] = 1;
        this.city.citySaveHelper.setGlobalSetting(TownHallHelper.GLOB_SETTING_TH_UNLOCKS, obj);
        return obj;
    };
    TownHallHelper.prototype.getRewardUnlockableSkinsRemaining = function () {
        var skins = [];
        var unlocked = this.getUnlockedSkinsObjSet();
        for (var i = 0; i < TownHallHelper.ALL_REWARD_UNLOCKABLE.length; i++) {
            var k = TownHallHelper.ALL_REWARD_UNLOCKABLE[i];
            if (!unlocked[k]) {
                skins.push(k);
            }
        }
        return skins;
    };
    TownHallHelper.prototype.getRandomUnlockableSkinReward = function () {
        var allSkinsRemaining = this.getRewardUnlockableSkinsRemaining();
        if (!allSkinsRemaining.length) return null;
        var frame = Utils.randomChoice(allSkinsRemaining);
        var obj = TownHallHelper.SKINS.filter(function (t) {
            return t.frame === frame;
        })[0];
        if (!obj) return null;
        return {
            frame: frame, img: obj.rewardThumb, name: obj.name
        };
    };
    TownHallHelper.prototype.setCustomSkin = function (frame) {
        var _this = this;
        this.checkLiveSkin();
        if (frame === "th-0") {
            this.chosenFrame = null;
            Utils.destroyIfAlive(this.skinMask);
        }
        this.chosenFrame = frame;
        this.city.citySaveHelper.setGlobalSetting(TownHallHelper.GLOB_SETTING_TH_FRAME, frame);
        var th = this.getTownHall();
        if (!th) {
            return;
        }
        if (frame === "th-0") {
            return;
        }
        var frameName = Utils.atlasFrame("deferred", frame);
        if (this.skinMask && this.skinMask.frameName === frameName) {
            return;
        }
        if (frame && !this.city.headlessMode) {
            this.ensureAtlasLoaded(function () {
                if (!_this.city.game) {
                    return;
                }
                if (!_this.skinMask) {
                    _this.skinMask = new Phaser.Sprite(_this.city.game, 0, 0, "atlas-deferred", frameName);
                    if (th && th.structureGroup && th.structureGroup.upperMaskSprite) {
                        th.structureGroup.upperMaskSprite.addChild(_this.skinMask);
                    }
                }
                _this.skinMask.frameName = frameName;
                Utils.fadeIn(_this.city.game, _this.skinMask, 150);
                _this.syncCustomSkinPosition();
            });
        } else {
            if (this.skinMask) {
                this.skinMask.destroy();
            }
        }
    };
    TownHallHelper.prototype.getTownHall = function () {
        return this.city.structureCache.getTownHalls()[0];
    };
    TownHallHelper.prototype.ensureAtlasLoaded = function (cb) {
        LoadHelper.ensureDeferredLoaded(this.city.game, cb);
    };
    TownHallHelper.prototype.checkLiveSkin = function () {
        if (this.skinMask && !this.skinMask.alive) {
            this.skinMask = null;
        }
    };
    TownHallHelper.GLOB_SETTING_TH_FRAME = "thframe";
    TownHallHelper.GLOB_SETTING_TH_UNLOCKS = "thunlocks";
    // the values here dont' matter at all, just truthy, but helps to track count lol
    TownHallHelper.UNLOCK_RANDOM_LEVELS = {
        25: 1,
        33: 2,
        43: 3,
        53: 4,
        65: 5,
        68: 6,
        71: 7,
        75: 8,
        78: 9,
        81: 10,
        95: 11
    };
    TownHallHelper.HIGHEST_RANDOM_UNLOCK_LV = Math.max.apply(null, Object.keys(TownHallHelper.UNLOCK_RANDOM_LEVELS).map(function (a) {
        return +a;
    }));
    // tbh rewardThumb only exists so I don't forget create the thumb when adding new skins
    TownHallHelper.ALL_REWARD_UNLOCKABLE = ["th-1", "th-2", "th-3", "th-4", "th-5", "th-6", "th-7", "th-8", "th-9", "th-10", "th-11"];
    TownHallHelper.REWARD_BY_FRAME = function () {
        var res = {};
        TownHallHelper.ALL_REWARD_UNLOCKABLE.forEach(function (c) {
            res[c] = 1;
        });
        return res;
    }();
    TownHallHelper.SKINS = [{
        "frame": "th-0",
        "name": "Plain",
        "rewardThumb": "img/th-skins/th-0.png"
    }, {
        "frame": "th-1",
        "name": "Ice",
        "rewardThumb": "img/th-skins/th-1.png"
    }, {
        "frame": "th-2",
        "name": "Autumn",
        "rewardThumb": "img/th-skins/th-2.png"
    }, {
        "frame": "th-3",
        "name": "Cherry",
        "rewardThumb": "img/th-skins/th-3.png"
    }, {
        "frame": "th-4",
        "name": "Royal",
        "rewardThumb": "img/th-skins/th-4.png"
    }, {
        "frame": "th-6",
        "name": "All Black",
        "rewardThumb": "img/th-skins/th-6.png"
    }, {
        "frame": "th-5",
        "name": "Fancy",
        "rewardThumb": "img/th-skins/th-5.png"
    }, {
        "frame": "th-10",
        "name": "Retro Party",
        "rewardThumb": "img/th-skins/th-10.png"
    }, {
        "frame": "th-7",
        "name": "Red White Blue",
        "rewardThumb": "img/th-skins/th-7.png"
    }, {
        "frame": "th-8",
        "name": "Maple Leaf",
        "rewardThumb": "img/th-skins/th-8.png"
    }, {
        "frame": "th-9",
        "name": "Red Dragon",
        "rewardThumb": "img/th-skins/th-9.png"
    }, {
        "frame": "th-11",
        "name": "Gold Mansion",
        "rewardThumb": "img/th-skins/th-11.png"
    }];
    return TownHallHelper;
}();
var CitySpecialUnlocks = /** @class */function () {
    function CitySpecialUnlocks(city) {
        this.lastUnlocked = {};
        this.city = city;
        this.lastUnlocked = this.getCurrentUnlocks();
    }
    // Update and return new unlocks names
    CitySpecialUnlocks.prototype.checkNewUnlocks = function () {
        var unlockNames = [];
        var newUnlocks = this.getCurrentUnlocks();
        var newKeys = Object.keys(newUnlocks);
        for (var i = 0; i < newKeys.length; i++) {
            if (!this.lastUnlocked[newKeys[i]]) {
                unlockNames.push(STRUCTURE_BY_SHEET[newKeys[i]].name);
                this.lastUnlocked[newKeys[i]] = 1;
            }
        }
        return unlockNames;
    };
    CitySpecialUnlocks.prototype.getCurrentUnlocks = function () {
        var _this = this;
        var unlocks = {};
        Object.keys(CitySpecialUnlocks.ACHIEVEMENT_UNLOCK_SHEETS).forEach(function (k) {
            if (!STRUCTURE_BY_SHEET[k].extraRequirement || STRUCTURE_BY_SHEET[k].extraRequirement(_this.city)) {
                unlocks[k] = 1;
            }
        });
        return unlocks;
    };
    CitySpecialUnlocks.isNewUnlockMansion = function (city) {
        return (
            // isn't already unlocked
            !city.citySaveHelper.getUserSetting(CitySpecialUnlocks.GLOB_MANSION_KEY, false) &&
            // level
            city.stats.level >= CitySpecialUnlocks.MANSION_LV_REQ &&
            // difficulty
            Difficulty.getDifficulty(city) === Difficulty.DIFFICULTY.EXPERT &&
            // population
            city.stats.population >= CitySpecialUnlocks.MANSION_REQ_POP
        );
    };
    CitySpecialUnlocks.isNewUnlockHeadBank = function (city) {
        return (
            // isn't already unlocked
            !city.citySaveHelper.getUserSetting(CitySpecialUnlocks.GLOB_HEADBANK_KEY, false) &&
            // level
            city.stats.level >= CitySpecialUnlocks.HEAD_BANK_LV_REQ &&
            // cash
            city.stats.money >= CitySpecialUnlocks.HEAD_BANK_CASH_REQ
        );
    };
    CitySpecialUnlocks.isNewUnlockHovercar = function (city) {
        return (
            // isn't already unlocked
            !city.citySaveHelper.getUserSetting(CitySpecialUnlocks.GLOB_HOVERCAR_KEY, false) &&
            // level
            city.stats.level >= CitySpecialUnlocks.HOVERCAR_LV_REQ &&
            // difficulty
            Difficulty.getDifficulty(city) === Difficulty.DIFFICULTY.EXPERT &&
            // population
            city.stats.population >= CitySpecialUnlocks.HOVERCAR_REQ_POP
        );
    };
    CitySpecialUnlocks.applyUnlockMansion = function (city) {
        city.citySaveHelper.setUserSetting(CitySpecialUnlocks.GLOB_MANSION_KEY, true, false);
    };
    CitySpecialUnlocks.applyUnlockHeadBank = function (city) {
        city.citySaveHelper.setUserSetting(CitySpecialUnlocks.GLOB_HEADBANK_KEY, true, false);
    };
    CitySpecialUnlocks.applyUnlockHoverCar = function (city) {
        city.citySaveHelper.setUserSetting(CitySpecialUnlocks.GLOB_HOVERCAR_KEY, true, false);
    };
    CitySpecialUnlocks.checkSpecialBuildingUnlocks = function (city) {
        var ret = false;
        if (CitySpecialUnlocks.isNewUnlockMansion(city)) {
            CitySpecialUnlocks.applyUnlockMansion(city);
            ret = true;
        }
        if (CitySpecialUnlocks.isNewUnlockHeadBank(city)) {
            CitySpecialUnlocks.applyUnlockHeadBank(city);
            ret = true;
        }
        if (CitySpecialUnlocks.isNewUnlockHovercar(city)) {
            CitySpecialUnlocks.applyUnlockHoverCar(city);
            ret = true;
        }
        return ret;
    };
    CitySpecialUnlocks.prototype.checkUnlocksAndMsgs = function () {
        var city = this.city;
        if (CitySpecialUnlocks.checkSpecialBuildingUnlocks(city)) {
            city.gameplayUI.pocketCity.storage.saveUserSettings();
        }
        var newUnlocks = this.checkNewUnlocks();
        if (newUnlocks.length) {
            city.cityLevel.setUnlockMsgForBuildingNames(newUnlocks);
        }
    };
    CitySpecialUnlocks.GLOB_MANSION_KEY = "mansionunlock";
    CitySpecialUnlocks.GLOB_HEADBANK_KEY = "headbankunlock";
    CitySpecialUnlocks.GLOB_HOVERCAR_KEY = "hovercarunlock";
    CitySpecialUnlocks.MANSION_LV_REQ = 110;
    CitySpecialUnlocks.MANSION_REQ_POP = 40000;
    CitySpecialUnlocks.HEAD_BANK_LV_REQ = 115;
    CitySpecialUnlocks.HEAD_BANK_CASH_REQ = 5 * 1000 * 1000; // 5 mill
    CitySpecialUnlocks.HEAD_BANK_INCREASE_MAX_CASH = 10 * 1000 * 1000; // 10 mill
    CitySpecialUnlocks.HOVERCAR_LV_REQ = 120;
    CitySpecialUnlocks.HOVERCAR_REQ_POP = 45000;
    CitySpecialUnlocks.ACHIEVEMENT_UNLOCK_SHEETS = {
        "mansion": 1,
        "hovercarfactory": 1,
        "headbank": 1,
        "duck": 1,
        "dj": 1
    };
    return CitySpecialUnlocks;
}();
//
// Don't change the "sheet" keys - they are actually used as identifiers
//
// These become StructureTile.structureGroup.building
// Pollution is calculated as a square, so long buildings with pollution won't have correct pollution grid
// Thumbs are autogenerated by running node build_atlas.js
//
// For buildings not in 'special' atlas, explicitly pass like:
//    'atlas-folder': "structures/special2",
//    'atlas-texture': "atlas-special2"
// New tab elem must be added to index.html in modal with id that matches this
var STRUCTURE_TAB_IDS;
(function (STRUCTURE_TAB_IDS) {
    STRUCTURE_TAB_IDS["RESOURCES_WATER"] = "resources-water-content";
    STRUCTURE_TAB_IDS["RESOURCES_POWER"] = "resources-power-content";
    STRUCTURE_TAB_IDS["SERVICES_EXPORTS"] = "services-exports-content";
    STRUCTURE_TAB_IDS["SERVICES_INSTITUTIONS"] = "services-institutions-content";
    STRUCTURE_TAB_IDS["PUBLIC_SERVICES"] = "services-emergency-content";
    STRUCTURE_TAB_IDS["RECREATION"] = "services-recreation-content";
    STRUCTURE_TAB_IDS["ENTERTAINMENT"] = "services-entertainment-content";
    STRUCTURE_TAB_IDS["TRANSIT"] = "services-transit-content";
    STRUCTURE_TAB_IDS["UNIQUE"] = "other-unique-content";
    STRUCTURE_TAB_IDS["COSMETIC"] = "other-cosmetic-content";
})(STRUCTURE_TAB_IDS || (STRUCTURE_TAB_IDS = {}));
var TAB_GROUPING_TITLES = (_a = {}, _a[STRUCTURE_TAB_IDS.RESOURCES_WATER] = "용수", _a[STRUCTURE_TAB_IDS.RESOURCES_POWER] = "전력", _a[STRUCTURE_TAB_IDS.RECREATION] = "야외", _a[STRUCTURE_TAB_IDS.ENTERTAINMENT] = "엔터테인먼트", _a[STRUCTURE_TAB_IDS.PUBLIC_SERVICES] = "안전", _a[STRUCTURE_TAB_IDS.SERVICES_EXPORTS] = "상품", _a[STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS] = "협회", _a[STRUCTURE_TAB_IDS.TRANSIT] = "교통", _a[STRUCTURE_TAB_IDS.UNIQUE] = "특수", _a[STRUCTURE_TAB_IDS.COSMETIC] = "랜드마크", _a);
Object.keys(STRUCTURE_TAB_IDS).forEach(function (e) {
    if (TAB_GROUPING_TITLES.hasOwnProperty(e)) {
        throw new Error("Grouping name not defined for " + e);
    }
});
var STRUCTURE_SHEETS;
(function (STRUCTURE_SHEETS) {
    STRUCTURE_SHEETS["WATER_TOWER"] = "watertower";
    STRUCTURE_SHEETS["WATER_STATION"] = "waterstation";
    STRUCTURE_SHEETS["POWER_PLANT_SM"] = "powerplantsmall";
    STRUCTURE_SHEETS["POWER_PLANT_LG"] = "powerplant";
    STRUCTURE_SHEETS["POWER_PLANT_SOLAR"] = "powerplantsolar";
    STRUCTURE_SHEETS["POWER_PLANT_NUCLEAR"] = "nuclear";
    // Import / Export
    STRUCTURE_SHEETS["DOCK_SHIPPING"] = "dockcargo";
    STRUCTURE_SHEETS["FARM"] = "farm";
    STRUCTURE_SHEETS["ANIMAL_PASTURE"] = "animalpasture";
    STRUCTURE_SHEETS["STEELMILL"] = "steelmill";
    STRUCTURE_SHEETS["SAWMILL"] = "sawmill";
    STRUCTURE_SHEETS["MINE"] = "mine";
    STRUCTURE_SHEETS["HOSPITAL"] = "hospital";
    STRUCTURE_SHEETS["POLICE"] = "police";
    STRUCTURE_SHEETS["POLICE_LV2"] = "policelv2";
    STRUCTURE_SHEETS["FIRE_STATION"] = "firestation";
    STRUCTURE_SHEETS["FIRE_STATION_LV2"] = "firestationlv2";
    STRUCTURE_SHEETS["SCHOOL"] = "school";
    STRUCTURE_SHEETS["UNIVERISTY"] = "university";
    // leisure
    STRUCTURE_SHEETS["PARK_SM"] = "park1";
    STRUCTURE_SHEETS["PARK_LG"] = "largepark";
    STRUCTURE_SHEETS["CAMPGROUND"] = "campground";
    STRUCTURE_SHEETS["FERRIS_WHEEL"] = "ferriswheel";
    STRUCTURE_SHEETS["ART_GALLERY"] = "artgallery";
    STRUCTURE_SHEETS["STADIUM"] = "stadium";
    STRUCTURE_SHEETS["MOVIE_THEATRE"] = "cinema";
    STRUCTURE_SHEETS["BEACH_SM"] = "beach";
    STRUCTURE_SHEETS["BEACH_SM2"] = "beach2";
    STRUCTURE_SHEETS["TREES_1"] = "trees1";
    STRUCTURE_SHEETS["AQUARIUM"] = "aquarium";
    STRUCTURE_SHEETS["ARCADE"] = "arcade";
    STRUCTURE_SHEETS["REC_DOCK"] = "marina";
    STRUCTURE_SHEETS["SKI_RESORT"] = "skiresort";
    STRUCTURE_SHEETS["ZOO"] = "zoo";
    STRUCTURE_SHEETS["ZOO_2"] = "zoo2";
    STRUCTURE_SHEETS["ZOO_3"] = "zoo3";
    STRUCTURE_SHEETS["TOWN_HALL"] = "townhall";
    STRUCTURE_SHEETS["BANK"] = "bank";
    STRUCTURE_SHEETS["BANK_LV2"] = "banklv2";
    STRUCTURE_SHEETS["BANK_LV3"] = "banklv3";
    STRUCTURE_SHEETS["DYNAMITE"] = "dynamite";
    STRUCTURE_SHEETS["PLANT_CHOW"] = "plantchow";
    STRUCTURE_SHEETS["STATUE_COURAGE"] = "statuecourage";
    STRUCTURE_SHEETS["CASTLE"] = "castle";
    // Transportation
    STRUCTURE_SHEETS["RAIL_STATION"] = "skyrailstation";
    STRUCTURE_SHEETS["BUS_STOP"] = "busstop";
    STRUCTURE_SHEETS["BUS_DEPOT"] = "busdepot";
    STRUCTURE_SHEETS["PARKING_GARAGE"] = "parking";
    STRUCTURE_SHEETS["AIRPORT"] = "airport";
    STRUCTURE_SHEETS["LAB"] = "lab";
    STRUCTURE_SHEETS["DRONE_CORP"] = "dronecorp";
    STRUCTURE_SHEETS["ROCKET_STATION"] = "rocketstation";
    STRUCTURE_SHEETS["DJ"] = "dj";
    STRUCTURE_SHEETS["DUCK"] = "duck";
    STRUCTURE_SHEETS["MANUFACTURING"] = "manufacturing";
    STRUCTURE_SHEETS["SUPPLY"] = "supply";
    STRUCTURE_SHEETS["RECYCLING"] = "recycling";
    // Rewards
    STRUCTURE_SHEETS["MANSION"] = "mansion";
    STRUCTURE_SHEETS["HOVERCARFACTORY"] = "hovercarfactory";
    STRUCTURE_SHEETS["HEADBANK"] = "headbank";
    // landmarks
    STRUCTURE_SHEETS["PN_TOWER"] = "pntower";
    STRUCTURE_SHEETS["LATTICE_TOWER"] = "latticetower";
    STRUCTURE_SHEETS["PYRAMID"] = "pyramid";
    STRUCTURE_SHEETS["TEMPLE_ASIA"] = "temple";
    STRUCTURE_SHEETS["TEMPLE_AZTEC"] = "aztec";
    STRUCTURE_SHEETS["OBELISK"] = "obelisk";
})(STRUCTURE_SHEETS || (STRUCTURE_SHEETS = {}));
var STRUCTURE_SHEET_ALIAS = (_b = {}, _b[STRUCTURE_SHEETS.ZOO_2] = STRUCTURE_SHEETS.ZOO, _b[STRUCTURE_SHEETS.ZOO_3] = STRUCTURE_SHEETS.ZOO, _b);
// Various ways of getting data for structures
var STRUCTURE_POLLUTION = {}; // range of pollution
var STRUCTURE_POLLUTION_BASE_MULT = {}; // "heaviness of pollution"
var STRUCTURE_DESCRIPTIONS = {};
var STRUCTURE_DESCRIPTIONS_FNS = {};
var STRUCTURE_CSS_CLASS = {};
var STRUCTURE_THUMB_PATH = {};
var STRUCTURE_NAMES = {};
var STRUCTURES_DO_NOT_NEED_WATER = {};
var STRUCTURES_DO_NOT_NEED_POWER = {};
var STRUCTURES_DO_NOT_NEED_ROAD = {};
var STRUCTURES_ONLY_BULLDOZE_BY_SHEET = {};
var STRUCTURES_MAX_BUILD_BY_ID = {};
var STRUCTURE_FROM_CHEST_BY_ID = {};
var POST_STRUCTURE_RESIZE = {};
var NO_DESTROY_UNDERNEATH = {};
var RECTANGLE_INPUT_STRUCT = {};
var EXTRA_HEIGHT_MULT = {};
var ANCHOR_STRUCT_OVERRIDE = {
    "src/www/img-atlas/structures/special3/obelisk.png": 0.728,
    "src/www/img-atlas/structures/special3-mask/obelisk-mask.png": 0.87,
    "src/www/img-atlas/structures/special3/banklv3.png": 0.736,
    "src/www/img-atlas/structures/special3-mask/banklv3-mask.png": 0.854,
    "src/www/img-atlas/structures/special4/headbank.png": 0.751,
    "src/www/img-atlas/structures/special4-mask/headbank-mask.png": 0.882
};
var STRUCTURE_EXTRA_BUILDABLE_CONDITION = {};
var STRUCTURE_EXTRA_TEXT_COND = {};
// resource values lookup store
var STRUCTURE_VALUES = {}; // unique internal value used, effect depends on strcture type
var STRUCTURE_VALUES_FN = {}; // non-static values
var STRUCTURE_EFFECT_TYPES = {}; // sheet to type, city metric enum for builds e.g. ENVIRONMENT, RECREATION, etc..
var StructureDefinitions = [];
var STRUCTURE_BY_ID = {};
var STRUCTURE_BY_SHEET = {};
var STRUCTURE_BY_EFFECT_TYPE = {};
var STRUCTURES_BY_MIN_LEVEL = {};
var STRUCTURE_SHEETS_BY_TYPE = {};
var IS_UPGRADE = {};
var SHEET_ALLOW_MOVE = {};
var getStructureValue = function getStructureValue(sheet, city, i) {
    if (STRUCTURE_VALUES_FN[sheet]) {
        return STRUCTURE_VALUES_FN[sheet](city, i);
    } else {
        return STRUCTURE_VALUES[sheet];
    }
};
var noOpApplyFn = {
    applyFn: function applyFn(c) {
        return c;
    },
    totalMetricEffect: 0,
    recommendedCost: 0
};
var Structures;
(function (Structures) {
    Structures.numberOfStructuresUnlockedByEffectType = function (city, type) {
        var structs = STRUCTURE_BY_EFFECT_TYPE[type] || [];
        var count = 0;
        structs.forEach(function (def) {
            var s = STRUCTURE_BY_SHEET[def.sheet];
            if (s.minLevel <= city.stats.level && !STRUCTURE_FROM_CHEST_BY_ID[def.id]) {
                count += 1;
            }
        });
        return count;
    };
    // determines whether level lock should be shown
    // - building might still be disabled even if level reached
    // - chest buildings should be hidden until requirement met
    Structures.isBuildingUnlocked = function (city, id) {
        var s = STRUCTURE_BY_ID[id];
        var passesLevelReq = !s.minLevel || city.getLevelWithCentral() >= s.minLevel;
        if (city.isSandbox) {
            passesLevelReq = true;
        }
        if (!passesLevelReq) return false;
        if (s.isFromChest) {
            return !s.extraRequirement || s.extraRequirement(city);
        } else {
            return true;
        }
    };
    Structures.getUpgardeToDef = function (city, id) {
        return STRUCTURE_BY_ID[id].upgradeTo ? STRUCTURE_BY_ID[STRUCTURE_BY_ID[id].upgradeTo] : null;
    };
    Structures.hasMaxBuildableRestriction = function (structureId) {
        return STRUCTURES_MAX_BUILD_BY_ID.hasOwnProperty(structureId);
    };
    // Returns number of structures buildable. -1 means any
    Structures.numBuildableAtLevel = function (structureId, level) {
        if (!STRUCTURES_MAX_BUILD_BY_ID[structureId]) return -1;
        var maxLv = -1;
        var numBuildable = 0;
        STRUCTURES_MAX_BUILD_BY_ID[structureId].forEach(function (t) {
            if (t[0] <= level) {
                maxLv = t[0];
                numBuildable = t[1];
            }
        });
        return numBuildable;
    };
    // Returns at which next level the structure's max build will increase. -1 if no more levels to increase cap by.
    Structures.nextBuildableLevel = function (structureId, level) {
        if (!STRUCTURES_MAX_BUILD_BY_ID[structureId]) return -1;
        var nextBuildableLevel = -1;
        var foundNextLevel = false;
        STRUCTURES_MAX_BUILD_BY_ID[structureId].forEach(function (t) {
            if (foundNextLevel) return;
            if (t[0] > level) {
                foundNextLevel = true;
                nextBuildableLevel = t[0];
            }
        });
        return nextBuildableLevel;
    };
})(Structures || (Structures = {}));
// Constants
var _waterTowerPumpDistance = 50;
var _waterStationPumpDistance = 150;
var _powerPlantSmBuildingAmt = 50;
var _powerPlantBigBuildingAmt = _powerPlantSmBuildingAmt * 5;
var _maxIdTracked = 0;
var _trackedIds = {};
// Ensures that the structure has all required side effect values defined
// Don't just shove things into defintionObj, because it gets serialized in Save data
// Cost uses recommended in metric if not passed in definition
// definitionObj is an extended Building
function registerStructure(definition, stats) {
    var defintionObj = {
        tab: definition.tab,
        id: definition.id,
        "atlas-texture": definition["atlas-texture"] || "atlas-special",
        "atlas-folder": definition["atlas-folder"] || "structures/special",
        sheet: definition.sheet,
        type: definition.type || definition.sheet,
        name: definition.name,
        minLevel: definition.minLevel,
        sizeCol: definition.sizeCol,
        sizeRow: definition.sizeRow,
        cost: definition.hasOwnProperty("cost") ? definition.cost : definition.metricEffect.recommendedCost,
        metricEffect: definition.metricEffect,
        extraDom: definition.extraDom,
        isFromChest: definition.isFromChest ? true : false
    };
    if (_trackedIds[definition.id]) {
        console.error("ID already registered:", definition);
    }
    _trackedIds[definition.id] = 1;
    _maxIdTracked = Math.max(_maxIdTracked, definition.id);
    if (definition.upgradeTo) {
        defintionObj.upgradeTo = definition.upgradeTo;
        IS_UPGRADE[defintionObj.upgradeTo] = 1;
    }
    if (definition.extraRequirement) {
        defintionObj.extraRequirement = definition.extraRequirement;
    }
    if (definition.extraRequirementDef) {
        defintionObj.extraRequirementDef = definition.extraRequirementDef;
    }
    if (definition.maxBuild) {
        STRUCTURES_MAX_BUILD_BY_ID[definition.id] = definition.maxBuild;
    }
    if (definition.canBuild) {
        defintionObj.canBuild = definition.canBuild;
    }
    if (definition.invalidBuildReason) {
        defintionObj.invalidBuildReason = definition.invalidBuildReason;
    }
    if (definition.isFromChest) {
        STRUCTURE_FROM_CHEST_BY_ID[definition.id] = defintionObj;
    }
    if (definition.onCommit) {
        defintionObj.onCommit = definition.onCommit;
    }
    stats.effectType = stats.effectType != null ? stats.effectType : CityMetrics.STRUCTURE_EFFECT_TYPE.NONE;
    if (!stats) throw new Error("missing");
    var sheet = defintionObj.sheet;
    if (definition.onlyBulldoze) {
        STRUCTURES_ONLY_BULLDOZE_BY_SHEET[sheet] = 1;
    }
    if (!definition.disableMove) {
        SHEET_ALLOW_MOVE[sheet] = 1;
    }
    // validation
    if (!defintionObj.id) {
        throw new Error("NO ID! " + defintionObj);
    }
    if (isNaN(parseInt(String(defintionObj.id)))) {
        throw new Error("id needs to be integer");
    }
    if (!defintionObj.name) {
        throw new Error("no name in " + defintionObj);
    }
    if (STRUCTURE_BY_ID[defintionObj.id]) {
        throw new Error("USED ID already! " + defintionObj.id);
    }
    STRUCTURE_BY_ID[defintionObj.id] = defintionObj;
    STRUCTURE_BY_SHEET[sheet] = defintionObj;
    if (definition.ignoreWater) {
        STRUCTURES_DO_NOT_NEED_WATER[sheet] = true;
    }
    if (definition.ignorePower) {
        STRUCTURES_DO_NOT_NEED_POWER[sheet] = true;
    }
    if (definition.ignoreRoad) {
        STRUCTURES_DO_NOT_NEED_ROAD[sheet] = true;
    }
    if (!stats.hasOwnProperty("effectType")) {
        throw new Error("must define `effectType`!");
    }
    if (!stats.hasOwnProperty("definition")) {
        throw new Error("Definition required!");
    }
    if (definition.type) {
        STRUCTURE_SHEETS_BY_TYPE[definition.type] = STRUCTURE_SHEETS_BY_TYPE[definition.type] || [];
        STRUCTURE_SHEETS_BY_TYPE[definition.type].push(sheet);
    }
    if (defintionObj.minLevel) {
        STRUCTURES_BY_MIN_LEVEL[defintionObj.minLevel] = STRUCTURES_BY_MIN_LEVEL[defintionObj.minLevel] || [];
        STRUCTURES_BY_MIN_LEVEL[defintionObj.minLevel].push(defintionObj);
        if (defintionObj.minLevel !== 0 && STRUCTURES_BY_MIN_LEVEL[defintionObj.minLevel].length > 3) {
            throw new Error("More than 3 structures are unlocked at level " + defintionObj.minLevel + ". Only 3 can be shown in reward screen, so keep it at three max... Please adjust minLevel as needed." + JSON.stringify(STRUCTURES_BY_MIN_LEVEL[defintionObj.minLevel]));
        }
    }
    // Set convenience maps
    STRUCTURE_CSS_CLASS[sheet] = StructureHelpers.cssClassName(defintionObj["atlas-folder"], sheet);
    STRUCTURE_THUMB_PATH[sheet] = "img/special-thumbs/" + sheet + ".png";
    if (STRUCTURE_SHEET_ALIAS[sheet]) {
        STRUCTURE_THUMB_PATH[sheet] = "img/special-thumbs/" + STRUCTURE_SHEET_ALIAS[sheet] + ".png";
    }
    STRUCTURE_DESCRIPTIONS[sheet] = stats.definition;
    if (defintionObj.upgradeTo) {
        STRUCTURE_DESCRIPTIONS[sheet] += " 업그레이드 가능합니다.";
    }
    STRUCTURE_NAMES[sheet] = defintionObj.name;
    STRUCTURE_EFFECT_TYPES[sheet] = stats.effectType;
    STRUCTURE_BY_EFFECT_TYPE[stats.effectType] = STRUCTURE_BY_EFFECT_TYPE[stats.effectType] || [];
    STRUCTURE_BY_EFFECT_TYPE[stats.effectType].push(defintionObj);
    /// optional values
    if (stats.hasOwnProperty("pollution")) {
        STRUCTURE_POLLUTION[sheet] = stats.pollution;
    }
    if (stats.hasOwnProperty("pollutionBaseMult")) {
        STRUCTURE_POLLUTION_BASE_MULT[sheet] = stats.pollutionBaseMult;
    }
    if (stats.hasOwnProperty("effectValue")) {
        STRUCTURE_VALUES[sheet] = stats.effectValue;
    }
    if (stats.hasOwnProperty("effectFunction")) {
        STRUCTURE_VALUES_FN[sheet] = stats.effectFunction;
    }
    StructureDefinitions.push(defintionObj);
    return defintionObj;
}
/** Takes care of creating the applyFn side effect function for metric calculation */
function createMetricEffect(attributeEffects, additionalCostUnits) {
    var totalMetricCost = attributeEffects.reduce(function (acc, tup) {
        var costVal = tup[2] !== null ? tup[2] : tup[1];
        return acc + costVal;
    }, 0);
    if (additionalCostUnits) {
        totalMetricCost += additionalCostUnits;
    }
    var totalMetricEffect = attributeEffects.reduce(function (acc, tup) {
        return acc + tup[1];
    }, 0);
    return {
        applyFn: function applyFn(cityMetricCalculation, t, multiplier) {
            attributeEffects.forEach(function (t) {
                var key = t[0],
                    val = t[1];
                val *= multiplier;
                cityMetricCalculation[key] += val;
            });
            return cityMetricCalculation;
        },
        totalMetricEffect: totalMetricEffect,
        recommendedCost: Global.GENERAL_COST_PER_METRIC_INCREASE * totalMetricCost
    };
}
function createBankEffect(bankMaxCashImprove) {
    return {
        applyFn: function applyFn(cityMetricCalculation, t, multiplier) {
            cityMetricCalculation["maxCash"] += bankMaxCashImprove * PolicyEffects.getMaxCashMultPerBank(t.city);
            return cityMetricCalculation;
        },
        totalMetricEffect: 1,
        recommendedCost: Global.GENERAL_COST_PER_METRIC_INCREASE
    };
}
var StructureHelpers;
(function (StructureHelpers) {
    function cssClassName(folder, sheet) {
        return Utils.atlasFrame(folder, sheet).replace(/\//g, "").replace(/-/g, "").replace(/\./g, "");
    }
    StructureHelpers.cssClassName = cssClassName;
    // pre-made canBuild checkers
    function _mkCanBuildNearWaterCheck(dimSize, withEdge, mustReachMapEdge) {
        if (withEdge === void 0) {
            withEdge = false;
        }
        if (mustReachMapEdge === void 0) {
            mustReachMapEdge = false;
        }
        return function (defaultBuildPassed, city, row, col) {
            return Boolean(defaultBuildPassed && city.grids.terrainGrid.areaInsideIsBuildableLand({
                row: row, col: col
            }, dimSize) && city.grids.terrainGrid.areaTouchesWater({
                row: row, col: col
            }, dimSize, withEdge, mustReachMapEdge));
        };
    }
    StructureHelpers._mkCanBuildNearWaterCheck = _mkCanBuildNearWaterCheck;
    function _mkInvalidWaterBuildReason(dimSize, mustReachEdge) {
        if (mustReachEdge === void 0) {
            mustReachEdge = false;
        }
        return function (defaultBuildPassed, city, row, col) {
            if (defaultBuildPassed && !city.grids.terrainGrid.areaTouchesWater({
                row: row, col: col
            }, dimSize, false, mustReachEdge)) {
                if (mustReachEdge) {
                    if (city.grids.terrainGrid.areaTouchesWater({ row: row, col: col }, dimSize)) {
                        // Touches water but not water that reaches edge of map
                        return "지도 가장자리까지 용수를 공급해야 합니다";
                    } else {
                        return "용수 시설 근처에 배치해야 합니다";
                    }
                } else {
                    return "용수 시설 근처에 배치해야 합니다";
                }
            }
            return null;
        };
    }
    StructureHelpers._mkInvalidWaterBuildReason = _mkInvalidWaterBuildReason;
    function _canBuildBeach(defaultBuildPassed, city, row, col) {
        return Boolean(defaultBuildPassed && city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 1) && city.grids.terrainGrid.isSandAtIndex(row, col) && city.grids.terrainGrid.areaTouchesWater({
            row: row, col: col
        }, 1, true));
    }
    StructureHelpers._canBuildBeach = _canBuildBeach;
    function _invalidBuildReasonBeach(defaultBuildPassed, city, row, col) {
        var buildableArea = city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 1);
        if (buildableArea) {
            if (buildableArea && !city.grids.terrainGrid.areaTouchesWater({
                row: row, col: col
            }, 1)) {
                return "용수 시설 근처에 배치해야 합니다";
            }
            if (buildableArea && !city.grids.terrainGrid.isSandAtIndex(row, col)) {
                return "모래 위에 배치해야 합니다";
            }
        }
        return null;
    }
    StructureHelpers._invalidBuildReasonBeach = _invalidBuildReasonBeach;
})(StructureHelpers || (StructureHelpers = {}));
//
// Resources
//
registerStructure({
    tab: STRUCTURE_TAB_IDS.RESOURCES_WATER,
    id: 1,
    "atlas-folder": "structures/special",
    sheet: STRUCTURE_SHEETS.WATER_TOWER,
    type: "water",
    name: "급수탑",
    minLevel: 0,
    sizeCol: 1,
    sizeRow: 1,
    cost: Global.COSTS.WATER_TOWER,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: noOpApplyFn,
    extraDom: {
        class: "inner-service-water-tower",
        afterTitle: '<img class="sr-s-icon" src="img/icon-droplet.png"/>',
        extraElem: '<div id="water-station-hand" class="hand"><img class="hand-img" src="img/hand.png"/></div>'
    }
}, {
    "pollution": 2,
    "pollutionBaseMult": 2,
    "effectValue": _waterTowerPumpDistance,
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE,
    "definition": "연결된 도로의 근처 구역까지 용수를 공급합니다. {0} 거리까지 펌핑합니다.".formatUnicorn(_waterTowerPumpDistance)
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.RESOURCES_WATER,
    id: 2,
    "atlas-folder": "structures/special",
    sheet: STRUCTURE_SHEETS.WATER_STATION,
    type: "water",
    name: "용수 펌프 스테이션",
    minLevel: 24,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.WATER_STATION,
    ignoreWater: true,
    ignorePower: true,
    canBuild: StructureHelpers._mkCanBuildNearWaterCheck(2),
    invalidBuildReason: StructureHelpers._mkInvalidWaterBuildReason(2),
    metricEffect: noOpApplyFn,
    extraDom: {
        afterTitle: '<img class="sr-s-icon" src="img/icon-droplet.png"/><img class="sr-s-icon" src="img/icon-droplet.png"/>'
    }
}, {
    "pollution": 3,
    "pollutionBaseMult": 2,
    "effectValue": _waterStationPumpDistance,
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE,
    "definition": "용수 시설 근처에 배치해야 합니디. 연결된 도로의 근처 구역까지 용수를 공급합니다. {0} 거리까지 펌핑합니다.".formatUnicorn(_waterStationPumpDistance)
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.RESOURCES_POWER,
    id: 3,
    "atlas-folder": "structures/special",
    sheet: STRUCTURE_SHEETS.POWER_PLANT_SM,
    type: "power",
    name: "전력 발전소",
    minLevel: 0,
    sizeCol: 1,
    sizeRow: 1,
    cost: Global.COSTS.POWER_PLANT_SMALL,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: noOpApplyFn,
    extraDom: {
        class: "inner-service-power-plant",
        afterTitle: '<img class="sr-s-icon" src="img/icon-power.png"/>',
        extraElem: '<div id="power-plant-hand" class="hand"><img class="hand-img" src="img/hand.png"/></div>'
    }
}, {
    "pollution": 2,
    "pollutionBaseMult": 2,
    "effectValue": _powerPlantSmBuildingAmt,
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE,
    "definition": "{0} 건물에 전원을 공급합니다.".formatUnicorn(_powerPlantSmBuildingAmt)
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.RESOURCES_POWER,
    id: 4,
    sheet: STRUCTURE_SHEETS.POWER_PLANT_LG,
    type: "power",
    name: "대형 전력 발전소",
    minLevel: 12,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.POWER_PLANT,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: noOpApplyFn,
    extraDom: {
        afterTitle: '<img class="sr-s-icon" src="img/icon-power.png"/><img class="sr-s-icon" src="img/icon-power.png"/>'
    }
}, {
    "pollution": 3,
    "pollutionBaseMult": 3,
    "effectValue": _powerPlantBigBuildingAmt,
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE,
    "definition": "{0} 건물에 전원을 공급합니다.".formatUnicorn(_powerPlantBigBuildingAmt)
});
var SOLAR_POWER_AMT = _powerPlantBigBuildingAmt * 1.5;
registerStructure({
    tab: STRUCTURE_TAB_IDS.RESOURCES_POWER,
    id: 16,
    sheet: STRUCTURE_SHEETS.POWER_PLANT_SOLAR,
    type: "power",
    name: "태양열 발전소",
    minLevel: 35,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.POWER_PLANT_SOLAR,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: noOpApplyFn,
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return Boolean(defaultBuildPassed && city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 2) && city.grids.terrainGrid.areaInsideIsSand({
            row: row, col: col
        }, 2));
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        if (defaultBuildPassed) {
            return "사막 위에 배치해야 합니다";
        }
        return null;
    },
    extraDom: {
        afterTitle: '<img class="sr-s-icon" src="img/icon-power.png"/><img class="sr-s-icon" src="img/icon-power.png"/>'
    }
}, {
    "effectFunction": function effectFunction(city, index) {
        return SOLAR_POWER_AMT;
    },
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE,
    "definition": "{0} 건물에 전원을 공급합니다. 청정 에너지. 사막 위에 배치해야 합니다.".formatUnicorn(SOLAR_POWER_AMT)
});
var _nuclearBuildingAmt = _powerPlantSmBuildingAmt * 50;
registerStructure({
    tab: STRUCTURE_TAB_IDS.RESOURCES_POWER,
    id: 69,
    sheet: STRUCTURE_SHEETS.POWER_PLANT_NUCLEAR,
    type: "power",
    name: "원자력 발전소",
    'atlas-folder': "structures/special4",
    'atlas-texture': "atlas-special4",
    minLevel: 90,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.POWER_PLANT_NUCLEAR,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: noOpApplyFn,
    extraDom: {
        afterTitle: '<img class="sr-s-icon" src="img/icon-power.png"/><img class="sr-s-icon" src="img/icon-power.png"/><img class="sr-s-icon" src="img/icon-power.png"/><img class="sr-s-icon" src="img/icon-power.png"/>'
    }
}, {
    "pollution": 3,
    "pollutionBaseMult": 3,
    "effectValue": _nuclearBuildingAmt,
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RESOURCE,
    "definition": "{0} 건물에 전원을 공급합니다.".formatUnicorn(_nuclearBuildingAmt)
});
// Exports
var UNLOCK_MINE_LV = 40; // strategically both mine unlock and additional dock level
var SHIPPING_DOCK_ID = 23;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_EXPORTS,
    id: SHIPPING_DOCK_ID,
    sheet: STRUCTURE_SHEETS.DOCK_SHIPPING,
    name: "해운 부두",
    minLevel: Balance.ENABLE_EXPORTS_LV,
    sizeCol: 2,
    sizeRow: 2,
    canBuild: StructureHelpers._mkCanBuildNearWaterCheck(2, false, true),
    invalidBuildReason: StructureHelpers._mkInvalidWaterBuildReason(2, true),
    metricEffect: createMetricEffect([["maxExportPerSec", Balance.BASE_EXPORT_PER_BUILDING, 3]], 20),
    maxBuild: [[0, 1], [30, 2], [UNLOCK_MINE_LV, 3], [55, 4], [70, 5], [99, 6]]
}, {
    "definition": "최대 수출량을 증가시킵니다. 지도 가장자리까지 연장하여 용수 공급 시설 근처에 건설해야 합니다."
});
// Import / export goods
var FARM_ID = 24;
var FARM_UNLOCK_LEVEL = 15;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_EXPORTS,
    id: FARM_ID,
    sheet: STRUCTURE_SHEETS.FARM,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    name: "농장",
    minLevel: FARM_UNLOCK_LEVEL,
    sizeCol: 2,
    sizeRow: 2,
    // can't use _mkCanBuildNearWaterCheck because sand is required too
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return Boolean(defaultBuildPassed && city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 2) && city.grids.terrainGrid.isSoilAtIndex(row, col, 2));
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        var buildableArea = city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 2);
        if (buildableArea) {
            if (buildableArea && !city.grids.terrainGrid.isSoilAtIndex(row, col, 2)) {
                return "토양 옆에 배치해야 합니다";
            }
        }
        return null;
    },
    metricEffect: createMetricEffect([["exportsFood", Balance.BASE_EXPORT_FOOD_UNIT, 10]])
}, {
    "definition": "식품 수입을 감소시키고 수출을 증가시킵니다. 토양 위에 배치해야 합니다."
});
// Add-on animal field
var ANIMAL_PASTURE_ID = 53;
var ANIMAL_PASTURE_LEVEL = 45;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_EXPORTS,
    id: ANIMAL_PASTURE_ID,
    sheet: STRUCTURE_SHEETS.ANIMAL_PASTURE,
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    name: "동물 목장",
    minLevel: ANIMAL_PASTURE_LEVEL,
    onlyBulldoze: true,
    ignoreWater: true,
    ignorePower: true,
    ignoreRoad: true,
    sizeCol: 2,
    sizeRow: 2,
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return Boolean(defaultBuildPassed && city.grids.zoneGrid.isTouchingSheet(row, col, STRUCTURE_SHEETS.FARM));
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        if (!city.grids.zoneGrid.isTouchingSheet(row, col, STRUCTURE_SHEETS.FARM)) {
            return "농장 옆에 배치해야 합니다";
        }
        return null;
    },
    metricEffect: createMetricEffect([["exportsFood", Balance.BASE_EXPORT_FOOD_UNIT * Balance.ANIMAL_PASTURE_MULTIPLIER, 25]])
}, {
    "definition": "식량 생산을 늘리려면 농장에 연결하세요. 농장 옆에 건설해야 합니다."
});
var MINE_ID = 29;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_EXPORTS,
    id: MINE_ID,
    sheet: STRUCTURE_SHEETS.MINE,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    name: "광산",
    minLevel: UNLOCK_MINE_LV,
    sizeCol: 2,
    sizeRow: 2,
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return Boolean(defaultBuildPassed && city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 1) && city.grids.terrainGrid.areaTouchesMountain({ row: row, col: col }, 2));
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        var buildableArea = city.grids.terrainGrid.areaInsideIsBuildableLand({
            row: row, col: col
        }, 1);
        if (buildableArea && !city.grids.terrainGrid.areaTouchesMountain({ row: row, col: col }, 2)) {
            return "산 옆에 배치해야 합니다";
        }
        return null;
    },
    metricEffect: createMetricEffect([["exportsNatural", Balance.BASE_EXPORT_NATURAL_UNIT, 15]])
}, {
    "definition": "천연 자원 수출을 증가시킵니다. 산 옆에 배치해야 합니다."
});
var SAWMILL_ID = 25;
var UNLOCK_SAWMILL_LV = 25;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_EXPORTS,
    id: SAWMILL_ID,
    sheet: STRUCTURE_SHEETS.SAWMILL,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    name: "제재소",
    minLevel: UNLOCK_SAWMILL_LV,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: {
        applyFn: function applyFn(cityMetricCalculation, t) {
            cityMetricCalculation["exportsNatural"] += Balance.BASE_EXPORT_PER_TREE * _treesNear(t.city, t.row, t.col, 2, 1);
            return cityMetricCalculation;
        },
        totalMetricEffect: 10,
        recommendedCost: Global.GENERAL_COST_PER_METRIC_INCREASE * 15
    }
}, {
    "definition": "천연 자원 수출을 증가시킵니다. 천연 나무 옆에 배치할 때 효과가 발생합니다."
});
function _treesNear(city, row, col, structureSize, radius) {
    if (structureSize === void 0) {
        structureSize = 2;
    }
    if (radius === void 0) {
        radius = 1;
    }
    var treeCount = 0;
    var terrainGrid = city.grids.terrainGrid;
    Utils.forRadiusAroundStructure(row, col, structureSize, radius, city.size, function (r, c) {
        if (terrainGrid.isTreeAtIndex(r, c)) {
            treeCount += 1;
        }
    });
    return treeCount;
}
var STEELMILL_ID = 30;
var UNLOCK_STEELMILL_LV = 21;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_EXPORTS,
    id: STEELMILL_ID,
    sheet: STRUCTURE_SHEETS.STEELMILL,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    name: "제철소",
    minLevel: UNLOCK_STEELMILL_LV,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["exportsMaterial", Balance.BASE_MATERIAL_UNIT, 15]], 8)
}, {
    "pollution": 3,
    "pollutionBaseMult": 4,
    "definition": "자재 수입을 줄이고 수출을 늘립니다. 산업 구역 비용을 줄입니다."
});
//
// Public Services
//
var POLICE_LV_1_ID = 6;
var POLICE_LV_2_ID = 15;
// Lv 1
registerStructure({
    tab: STRUCTURE_TAB_IDS.PUBLIC_SERVICES,
    id: POLICE_LV_1_ID,
    sheet: STRUCTURE_SHEETS.POLICE,
    type: "police",
    name: "경찰서",
    minLevel: Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalPoliceSafety", 1, null]]),
    cost: Global.COSTS.POLICE,
    upgradeTo: POLICE_LV_2_ID
}, {
    "definition": "범죄 안전을 향상시킵니다. 응답 장치를 발송합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.POLICE
});
var UNLOCK_POLICE_LV2 = Balance.CRIME_ENABLE_AND_UNLOCK_POLICE_LV + 18;
registerStructure({
    tab: null,
    id: POLICE_LV_2_ID,
    sheet: STRUCTURE_SHEETS.POLICE_LV2,
    type: "police",
    name: "경찰서 레벨 2",
    minLevel: UNLOCK_POLICE_LV2,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalPoliceSafety", 2, null]]),
    cost: Global.COSTS.POLICE_LV2_UPGRADE
}, {
    "definition": "범죄 안전을 크게 향상시킵니다. 향상된 응답 장치를 발송합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.POLICE
});
var FIRE_STATION_LV_1_ID = 7;
var FIRE_STATION_LV_2_ID = 17;
registerStructure({
    tab: STRUCTURE_TAB_IDS.PUBLIC_SERVICES,
    id: FIRE_STATION_LV_1_ID,
    sheet: STRUCTURE_SHEETS.FIRE_STATION,
    type: "fire",
    name: "소방서",
    minLevel: Balance.FIRE_ENABLE_AND_UNLOCK_FIRE_STATION_LV,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalFireSafety", 1, null]]),
    cost: Global.COSTS.FIRE_STATION,
    upgradeTo: FIRE_STATION_LV_2_ID
}, {
    "definition": "화재 안전을 향상시킵니다. 응답 장치를 발송합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.FIRE
});
var UNLOCK_FIRE_DEPT_LV_2 = Balance.FIRE_ENABLE_AND_UNLOCK_FIRE_STATION_LV + 26;
registerStructure({
    tab: null,
    id: FIRE_STATION_LV_2_ID,
    sheet: STRUCTURE_SHEETS.FIRE_STATION_LV2,
    type: "fire",
    name: "소방서 레벨 2",
    minLevel: UNLOCK_FIRE_DEPT_LV_2,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalFireSafety", 2, null]]),
    cost: Global.COSTS.FIRE_STATION_LV2_UPGRADE
}, {
    "definition": "화재 안전을 크게 향상시킵니다. 향상된 응답 장치를 발송합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.FIRE
});
var UNLOCK_HOSPITAL_LV = 11;
registerStructure({
    tab: STRUCTURE_TAB_IDS.PUBLIC_SERVICES,
    id: 5,
    sheet: STRUCTURE_SHEETS.HOSPITAL,
    type: "hospital",
    name: "병원",
    minLevel: UNLOCK_HOSPITAL_LV,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.HOSPITAL,
    metricEffect: createMetricEffect([["totalHealthSafety", 1, null]])
}, {
    "definition": "보건 안전을 향상시킵니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.HOSPITAL
});
// School
var SCHOOL_MIN_LEVEL = 31;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: 41,
    sheet: STRUCTURE_SHEETS.SCHOOL,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    type: "education",
    name: "학교",
    minLevel: SCHOOL_MIN_LEVEL,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: noOpApplyFn,
    cost: Global.COSTS.SCHOOL
}, {
    "definition": "급여를 인상하여 시민 {0}명을 교육합니다.".formatUnicorn(Utils.numberWithCommas(CityEducation.SCHOOL_EDUCATES_NUM_CITIZENS))
});
// University
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: 42,
    sheet: STRUCTURE_SHEETS.UNIVERISTY,
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    type: "education",
    name: "대학",
    minLevel: 35,
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: noOpApplyFn,
    extraRequirementDef: "필수: 학교",
    extraRequirement: function extraRequirement(city) {
        return city.isInfiniteMoney() || Boolean(city.structureCache.getSchools(true).length);
    },
    cost: Global.COSTS.UNIVERSITY
}, {
    "definition": "급여를 인상하여 학교 졸업생 {0}명을 교육합니다. 학교가 필요합니다.".formatUnicorn(Utils.numberWithCommas(CityEducation.UNI_EDUCATES_NUM_CITIZENS))
});
// Research Lab
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: 45,
    sheet: STRUCTURE_SHEETS.LAB,
    minLevel: 58,
    name: "연구소",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.LAB,
    metricEffect: noOpApplyFn,
    maxBuild: [[0, 1]],
    extraRequirementDef: "필수: 대학",
    extraRequirement: function extraRequirement(city) {
        return city.isInfiniteMoney() || Boolean(city.structureCache.getUniversities().length);
    }
}, {
    "definition": "특수 기술 구조를 잠금 해제합니다. 대학이 필요합니다."
});
// Drone Corp
var DRONE_MIN_EDUCATION = 0.9;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: 49,
    sheet: STRUCTURE_SHEETS.DRONE_CORP,
    minLevel: 76,
    name: "드론 차고",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.LAB,
    metricEffect: noOpApplyFn,
    maxBuild: [[0, 1]],
    extraRequirementDef: "필수: 연구소, " + DRONE_MIN_EDUCATION * 100 + "% 교육 (대학)",
    extraRequirement: function extraRequirement(city) {
        var _a = CityEducation.percentPrimarySecondaryEducated(city),
            primarySecondaryEducation = _a[0],
            postSecondaryEducation = _a[1];
        return city.isInfiniteMoney() || Boolean(city.structureCache.getTechLabs().length) && postSecondaryEducation >= DRONE_MIN_EDUCATION;
    }
}, {
    "definition": "교통 및 상업 수입을 향상시킵니다. 연구소 및 고등 교육이 필요합니다."
});
// Manufacturing
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: 50,
    sheet: STRUCTURE_SHEETS.MANUFACTURING,
    minLevel: 62,
    name: "제조 연구소",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.LAB,
    metricEffect: noOpApplyFn,
    maxBuild: [[0, 1]],
    extraRequirementDef: "필수: 연구소",
    extraRequirement: function extraRequirement(city) {
        return city.isInfiniteMoney() || Boolean(city.structureCache.getTechLabs().length);
    }
}, {
    "definition": "모든 건설 속도가 150% 빨라집니다. 연구소가 필요합니다."
});
// Upkeep Building Supply
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: 63,
    sheet: STRUCTURE_SHEETS.SUPPLY,
    minLevel: 39,
    name: "철물점",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.SUPPLY,
    metricEffect: noOpApplyFn
}, {
    "definition": "Reduces Zone Upkeep up to {0} zones away.".formatUnicorn(SupplyUpkeepHelper.RADIUS)
});
// Rocket Station
var ROCKET_STATION_ID = 54;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: ROCKET_STATION_ID,
    sheet: STRUCTURE_SHEETS.ROCKET_STATION,
    minLevel: 99,
    name: "로켓 정거장",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.ROCKET_STATION,
    metricEffect: noOpApplyFn,
    extraRequirementDef: "필수: 연구소",
    extraRequirement: function extraRequirement(city) {
        return city.isInfiniteMoney() || Boolean(city.structureCache.getTechLabs().length);
    }
}, {
    "definition": "로켓을 우주로 보내보세요. 로켓 발사 이벤트를 활성화합니다."
});
// Dj Station
var DJ_ID = 57;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: DJ_ID,
    sheet: STRUCTURE_SHEETS.DJ,
    minLevel: 100,
    name: "파티 DJ",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 1,
    sizeRow: 1,
    ignoreWater: true,
    ignorePower: true,
    ignoreRoad: true,
    cost: Global.BASE_SPECIAL_COST,
    metricEffect: noOpApplyFn,
    extraRequirementDef: "어려움 난이도에서 레벨 {0}에 도달하면 잠금 해제됩니다.".formatUnicorn(100),
    extraRequirement: function extraRequirement(city) {
        return city.citySaveHelper.getGlobalSetting(Difficulty.HARD_MODE_FINISH_KEY, false) || city.citySaveHelper.getGlobalSetting(Difficulty.EXPERT_MODE_FINISH_KEY, false) || city.pocketCity.maxDiffLvReached[Difficulty.DIFFICULTY.HARD] >= 100 || city.pocketCity.maxDiffLvReached[Difficulty.DIFFICULTY.EXPERT] >= 100;
    }
}, {
    "definition": "재미를 위한 디제잉!"
});
// Rubber ducky Station
var DUCK_ID = 58;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: DUCK_ID,
    sheet: STRUCTURE_SHEETS.DUCK,
    minLevel: 100,
    name: "자이언트 덕키",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.BASE_SPECIAL_COST * 2,
    metricEffect: noOpApplyFn,
    ignoreWater: true,
    ignorePower: true,
    ignoreRoad: true,
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return city.grids.terrainGrid.areaInsideIsWater({
            row: row, col: col
        }, 2);
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        return "물 위에 배치해야 합니다";
    },
    extraRequirementDef: "전문가 난이도에서 레벨 {0}에 도달하면 잠금 해제됩니다.".formatUnicorn(100),
    extraRequirement: function extraRequirement(city) {
        return city.citySaveHelper.getGlobalSetting(Difficulty.EXPERT_MODE_FINISH_KEY, false) || city.pocketCity.maxDiffLvReached[Difficulty.DIFFICULTY.EXPERT] >= 100;
    }
}, {
    "definition": "재미를 위한 디제잉!"
});
//
// Recreation
//
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: 9,
    sheet: STRUCTURE_SHEETS.PARK_SM,
    type: "park1",
    name: "소형 공원",
    minLevel: 2,
    sizeCol: 1,
    sizeRow: 1,
    ignoreWater: true,
    ignorePower: true,
    onlyBulldoze: true,
    metricEffect: createMetricEffect([["totalRecreation", 1, null], ["totalEnvironment", 1, null]])
}, {
    "definition": "레크리에이션을 제공하고 환경을 개선합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION,
    "pollution": 1,
    "pollutionBaseMult": -Balance.POLLUTION_REDUCTION_STRUCT_BASE_MULT
});
var _THEATRE_REC_AMT = 3;
registerStructure({
    tab: STRUCTURE_TAB_IDS.ENTERTAINMENT,
    id: 14,
    sheet: STRUCTURE_SHEETS.MOVIE_THEATRE,
    minLevel: 2,
    name: "영화관",
    sizeCol: 1,
    sizeRow: 1,
    metricEffect: createMetricEffect([["totalRecreation", _THEATRE_REC_AMT, null], ["commerce", CityMetrics.getCommercialTileIncome(1), 1]])
}, {
    "definition": "레크리에이션과 수입을 제공합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: 31,
    sheet: STRUCTURE_SHEETS.PARK_LG,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    type: "park1",
    name: "대형 공원",
    minLevel: 15,
    sizeCol: 2,
    sizeRow: 2,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: createMetricEffect([["totalRecreation", 5, null], ["totalEnvironment", 1, null]])
}, {
    "definition": "레크리에이션을 제공하고 환경을 개선합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION,
    "pollution": 2,
    "pollutionBaseMult": -Balance.POLLUTION_REDUCTION_STRUCT_BASE_MULT
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.ENTERTAINMENT,
    id: 34,
    sheet: STRUCTURE_SHEETS.ART_GALLERY,
    minLevel: 8,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    name: "미술관",
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalRecreation", 5, null], ["commerce", CityMetrics.getCommercialTileIncome(1), 1]])
}, {
    "definition": "레크리에이션과 수입을 제공합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.ENTERTAINMENT,
    id: 35,
    sheet: STRUCTURE_SHEETS.STADIUM,
    minLevel: 60,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    name: "경기장",
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalRecreation", 10, null]], 10)
}, {
    "definition": "레크리에이션을 제공합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.ENTERTAINMENT,
    id: 13,
    sheet: STRUCTURE_SHEETS.FERRIS_WHEEL,
    minLevel: 31,
    type: "ferriswheel",
    name: "관람차",
    sizeCol: 2,
    sizeRow: 1,
    ignoreWater: true,
    metricEffect: createMetricEffect([["totalRecreation", 8, null]], 2)
}, {
    "definition": "레크리에이션을 제공합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.ENTERTAINMENT,
    id: 39,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    sheet: STRUCTURE_SHEETS.AQUARIUM,
    minLevel: 8,
    type: STRUCTURE_SHEETS.AQUARIUM,
    name: "수족관",
    sizeCol: 1,
    sizeRow: 2,
    ignoreWater: true,
    metricEffect: createMetricEffect([["totalRecreation", 8, null]])
}, {
    "definition": "레크리에이션을 제공합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
// Arcade
registerStructure({
    tab: STRUCTURE_TAB_IDS.ENTERTAINMENT,
    id: 52,
    sheet: STRUCTURE_SHEETS.ARCADE,
    minLevel: 80,
    name: "VR 아케이드",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalRecreation", 20, null]], 15),
    extraRequirementDef: "필수: 연구소",
    extraRequirement: function extraRequirement(city) {
        return city.isInfiniteMoney() || Boolean(city.structureCache.getTechLabs().length);
    }
}, {
    "definition": "레크리에이션을 제공합니다. 연구소가 필요합니다."
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: 12,
    sheet: STRUCTURE_SHEETS.CAMPGROUND,
    minLevel: 41,
    type: "campground",
    name: "캠프장",
    sizeCol: 2,
    sizeRow: 2,
    onlyBulldoze: true,
    ignoreWater: true,
    ignorePower: true,
    metricEffect: {
        applyFn: function applyFn(cityMetricCalculation, t, multiplier) {
            var natureBonusMult = 1;
            // check if touching no zones
            var isTouchingZone = false;
            Utils.forAllOnionLayers(t.city, t.row, t.col, 4, function (r, c) {
                isTouchingZone = isTouchingZone || t.city.grids.zoneGrid.hasTile(r, c) && t.city.grids.zoneGrid.tiles[r][c] != t && t.city.grids.zoneGrid.tiles[r][c]._master != t;
            });
            if (!isTouchingZone) {
                natureBonusMult += 0.5;
            }
            // check if near interesting terrain
            var isNearInterestingTerrain = false;
            Utils.forAllOnionLayers(t.city, t.row, t.col, 2, function (r, c) {
                isNearInterestingTerrain = isNearInterestingTerrain || t.city.grids.terrainGrid.isWaterAtIndex(r, c) || t.city.grids.terrainGrid.isMountain(r, c) || t.city.grids.terrainGrid.isTreeAtIndex(r, c);
            });
            if (isNearInterestingTerrain) {
                natureBonusMult += 0.5;
            }
            var attributeEffects = [["totalRecreation", 3 * natureBonusMult * multiplier, null], ["totalEnvironment", 2 * natureBonusMult, null], ["attractiveness", 1 * natureBonusMult * multiplier, null]];
            attributeEffects.forEach(function (t) {
                var key = t[0],
                    val = t[1];
                cityMetricCalculation[key] += val;
            });
            return cityMetricCalculation;
        },
        totalMetricEffect: 5,
        recommendedCost: Global.GENERAL_COST_PER_METRIC_INCREASE * (4 + 2)
    }
}, {
    "definition": "레크리에이션을 제공합니다. 환경을 향상시킵니다. 도시에서 멀리 떨어진 자연 근처에서 더 효과적입니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION,
    "pollution": 2,
    "pollutionBaseMult": -Balance.POLLUTION_REDUCTION_STRUCT_BASE_MULT
});
var TREES_1_ID = 32;
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: TREES_1_ID,
    sheet: STRUCTURE_SHEETS.TREES_1,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    type: "trees",
    name: "나무",
    minLevel: 5,
    sizeCol: 1,
    sizeRow: 1,
    onlyBulldoze: true,
    ignoreWater: true,
    ignorePower: true,
    ignoreRoad: true,
    disableMove: true,
    metricEffect: createMetricEffect([["totalEnvironment", 0.5, null]])
}, {
    "definition": "환경을 향상시킵니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.ENVIRONMENT,
    "pollution": 2,
    "pollutionBaseMult": -Balance.POLLUTION_REDUCTION_STRUCT_BASE_MULT
});
RECTANGLE_INPUT_STRUCT[STRUCTURE_SHEETS.TREES_1] = true;
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: 21,
    sheet: STRUCTURE_SHEETS.BEACH_SM,
    type: "beach",
    name: "작은 해변",
    minLevel: 4,
    sizeCol: 1,
    sizeRow: 1,
    onlyBulldoze: true,
    ignoreWater: true,
    ignorePower: true,
    // can't use _mkCanBuildNearWaterCheck because sand is required too
    canBuild: StructureHelpers._canBuildBeach,
    invalidBuildReason: StructureHelpers._invalidBuildReasonBeach,
    metricEffect: createMetricEffect([["totalRecreation", 3, null]])
}, {
    "definition": "레크리에이션을 제공합니다. 바다 옆 모래 위에 배치해야 합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: 44,
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sheet: STRUCTURE_SHEETS.BEACH_SM2,
    type: "beach",
    name: "소형 비치 리조트",
    minLevel: 40,
    sizeCol: 1,
    sizeRow: 1,
    ignoreWater: true,
    ignorePower: true,
    // can't use _mkCanBuildNearWaterCheck because sand is required too
    canBuild: StructureHelpers._canBuildBeach,
    invalidBuildReason: StructureHelpers._invalidBuildReasonBeach,
    metricEffect: createMetricEffect([["totalRecreation", 5, null]])
}, {
    "definition": "레크리에이션을 제공합니다. 바다 옆 모래 위에 배치해야 합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
var MARINA_ID = 47;
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: MARINA_ID,
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sheet: STRUCTURE_SHEETS.REC_DOCK,
    name: "마리나",
    type: "waterstructure",
    minLevel: 55,
    sizeCol: 2,
    sizeRow: 2,
    ignoreWater: true,
    ignorePower: true,
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return city.grids.terrainGrid.areaInsideIsWater({
            row: row, col: col
        }, 2);
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        return "물 위에 배치해야 합니다";
    },
    metricEffect: createMetricEffect([["totalRecreation", 8, null]], 8)
}, {
    "definition": "레크리에이션을 제공합니다. 물 위에 배치해야 합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
// Zoo
var ZOO_IDS = {
    ZOO_1: 60,
    ZOO_2: 61,
    ZOO_3: 62
};
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: ZOO_IDS.ZOO_1,
    sheet: STRUCTURE_SHEETS.ZOO,
    minLevel: 84,
    name: "동물원",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalRecreation", 20, null]], 20),
    upgradeTo: ZOO_IDS.ZOO_2
}, {
    "definition": "레크리에이션을 제공합니다."
});
registerStructure({
    tab: null,
    id: ZOO_IDS.ZOO_2,
    sheet: STRUCTURE_SHEETS.ZOO_2,
    minLevel: 85,
    name: "동물원 레벨 2",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalRecreation", 30, null]], 40),
    upgradeTo: ZOO_IDS.ZOO_3
}, {
    "definition": "레크리에이션을 제공합니다."
});
registerStructure({
    tab: null,
    id: ZOO_IDS.ZOO_3,
    sheet: STRUCTURE_SHEETS.ZOO_3,
    minLevel: 86,
    name: "동물원 레벨 3",
    'atlas-folder': "structures/special3",
    'atlas-texture': "atlas-special3",
    sizeCol: 2,
    sizeRow: 2,
    metricEffect: createMetricEffect([["totalRecreation", 40, null]], 50)
}, {
    "definition": "레크리에이션을 제공합니다."
});
var SKIRESORT_ID = 64;
registerStructure({
    tab: STRUCTURE_TAB_IDS.RECREATION,
    id: SKIRESORT_ID,
    'atlas-folder': "structures/special2",
    'atlas-texture': "atlas-special2",
    sheet: STRUCTURE_SHEETS.SKI_RESORT,
    name: "스키 리조트",
    type: "mountainstructure",
    minLevel: 92,
    sizeCol: 2,
    sizeRow: 2,
    canBuild: function canBuild(defaultBuildPassed, city, row, col) {
        return city.grids.terrainGrid.isBaseOf2xMountain({
            row: row, col: col
        });
    },
    invalidBuildReason: function invalidBuildReason(defaultBuildPassed, city, row, col) {
        return "중간 크기의 산에 배치해야 합니다";
    },
    metricEffect: createMetricEffect([["totalRecreation", 30, null]], 35)
}, {
    "definition": "레크리에이션을 제공합니다. 중간 크기의 산에 배치해야 합니다.",
    "effectType": CityMetrics.STRUCTURE_EFFECT_TYPE.RECREATION
});
//
// Rewards
//
var MANSION_ID = 65;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: MANSION_ID,
    sheet: STRUCTURE_SHEETS.MANSION,
    'atlas-folder': "structures/special4",
    'atlas-texture': "atlas-special4",
    type: "mansion",
    name: "시장 저택",
    maxBuild: [[0, 1]],
    minLevel: CitySpecialUnlocks.MANSION_LV_REQ,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.MANSION,
    metricEffect: noOpApplyFn,
    extraRequirementDef: "인구 {1}명 및 전문가 난이도에서 레벨 {0}에 도달하면 잠금 해제됩니다.".formatUnicorn(CitySpecialUnlocks.MANSION_LV_REQ, Utils.numberWithCommas(CitySpecialUnlocks.MANSION_REQ_POP)),
    extraRequirement: function extraRequirement(city) {
        return city.citySaveHelper.getUserSetting(CitySpecialUnlocks.GLOB_MANSION_KEY, false);
    }
}, {
    "definition": "저택 근처에 사는 시민의 행복을 높이세요."
});
var HOVERCAR_FACTORY_ID = 66;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: HOVERCAR_FACTORY_ID,
    sheet: STRUCTURE_SHEETS.HOVERCARFACTORY,
    'atlas-folder': "structures/special4",
    'atlas-texture': "atlas-special4",
    type: "hovercarfactory",
    name: "호버카 공장",
    maxBuild: [[0, 1]],
    minLevel: CitySpecialUnlocks.HOVERCAR_LV_REQ,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.HOVERCARFACTORY,
    metricEffect: noOpApplyFn,
    extraRequirementDef: "인구 {1}명 및 전문가 난이도에서 레벨 {0}에 도달하면 잠금 해제됩니다.".formatUnicorn(CitySpecialUnlocks.HOVERCAR_LV_REQ, Utils.numberWithCommas(CitySpecialUnlocks.HOVERCAR_REQ_POP)),
    extraRequirement: function extraRequirement(city) {
        return city.citySaveHelper.getUserSetting(CitySpecialUnlocks.GLOB_HOVERCAR_KEY, false);
    }
}, {
    "definition": "모든 정체를 50% 줄입니다. 접근성을 100%로 증가시킵니다."
});
var HEAD_BANK_ID = 67;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: HEAD_BANK_ID,
    sheet: STRUCTURE_SHEETS.HEADBANK,
    'atlas-folder': "structures/special4",
    'atlas-texture': "atlas-special4",
    type: "headbank",
    name: "은행탑",
    minLevel: CitySpecialUnlocks.HEAD_BANK_LV_REQ,
    sizeCol: 1,
    sizeRow: 1,
    cost: Global.COSTS.HEAD_BANK,
    metricEffect: createBankEffect(CitySpecialUnlocks.HEAD_BANK_INCREASE_MAX_CASH),
    extraRequirementDef: "모든 난이도에서 은행 자금 {1}(을)를 이용하여 레벨 {0}에 도달 후 잠금 해제됩니다.".formatUnicorn(CitySpecialUnlocks.HEAD_BANK_LV_REQ, Utils.moneyFormat(CitySpecialUnlocks.HEAD_BANK_CASH_REQ)),
    extraRequirement: function extraRequirement(city) {
        return city.citySaveHelper.getUserSetting(CitySpecialUnlocks.GLOB_HEADBANK_KEY, false);
    }
}, {
    "definition": "최대 현금을 {0} 증가시킵니다.".formatUnicorn(Utils.moneyFormat(CitySpecialUnlocks.HEAD_BANK_INCREASE_MAX_CASH))
});
STRUCTURE_DESCRIPTIONS_FNS[STRUCTURE_SHEETS.HEADBANK] = function (city) {
    return "최대 현금을 {0} 증가시킵니다".formatUnicorn(Utils.moneyFormat(CitySpecialUnlocks.HEAD_BANK_INCREASE_MAX_CASH * PolicyEffects.getMaxCashMultPerBank(city), true) + ".");
};
var RECYCLING_PLANT_ID = 68;
var RECYCLING_PLANT_LV = 70;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: RECYCLING_PLANT_ID,
    sheet: STRUCTURE_SHEETS.RECYCLING,
    'atlas-folder': "structures/special4",
    'atlas-texture': "atlas-special4",
    type: "recycling",
    name: "재활용품 처리장",
    minLevel: RECYCLING_PLANT_LV,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.RECYCLING,
    metricEffect: noOpApplyFn
}, {
    "definition": "최대 {0} 구역까지 오염을 줄입니다.".formatUnicorn(RecyclingHelper.RADIUS)
});
//
// Services
//
var TOWNHALL_ID = 8;
registerStructure({
    tab: STRUCTURE_TAB_IDS.UNIQUE,
    id: TOWNHALL_ID,
    sheet: STRUCTURE_SHEETS.TOWN_HALL,
    type: "townhall",
    name: "시청",
    maxBuild: [[0, 1]],
    minLevel: 0,
    sizeCol: 2,
    sizeRow: 2,
    cost: Global.COSTS.TOWN_HALL,
    ignoreWater: true,
    ignorePower: true,
    ignoreRoad: true,
    metricEffect: noOpApplyFn
}, {
    "definition": "도시의 출발점이 됩니다. 도시가 수입을 얻도록 운영합니다."
});
// BANK
var BANK_LV_1_ID = 10;
var BANK_LV_2_ID = 22;
var BANK_LV_3_ID = 59;
registerStructure({
    tab: STRUCTURE_TAB_IDS.SERVICES_INSTITUTIONS,
    id: BANK_LV_1_ID,
    sheet: STRUCTURE_SHEETS.BANK,
    type: "bank",
    name: "은행",
    minLevel: 4,
    sizeCol: 1,
    sizeRow: 1,
    cost: Global.COSTS.BANK,
    upgradeTo: BANK_LV_2_ID,
    metricEffect: createBankEffect(Global.CASH_INCREASE_PER_BANK)
}, {
    "definition": "최대 현금을 {0} 늘립니다.".formatUnicorn(Utils.moneyFormat(Global.CASH_INCREASE_PER_BANK))
});
STRUCTURE_DESCRIPTIONS_FNS[STRUCTURE_SHEETS.BANK] = function (city) {
    return "최대 현금을 {0} 늘립니다. 업그레이드 가능합니다.".formatUnicorn(Utils.moneyFormat(Global.CASH_INCREASE_PER_BANK * PolicyEffects.getMaxCashMultPerBank(city), true));
};
var bankLv2Cost = Utils.roundFixed(Balance.BANK_UPGRADE_EFFECT_MULT * Global.COSTS.BANK * 0.5, 1000);
registerStructure({
    tab: null,
    id: BANK_LV_2_ID,
    sheet: STRUCTURE_SHEETS.BANK_LV2,
    type: "banklv2",
    name: "은행 레벨 2",
    minLevel: 19,
    sizeCol: 1,
    sizeRow: 1,
    cost: bankLv2Cost,
    upgradeTo: BANK_LV_3_ID,
    metricEffect: createBankEffect(Global.CASH_INCREASE_PER_BANK * Balanc