// Hide all elements - headless mode
if (Global.DEBUG_HIDE_ALL){
    $('body').css("opacity","0.02");
    console.log("DEBUG_HIDE_ALL enabled");
    document.title = "localhost";
}
var _buildNum = window.BUILD_NUMBER || "unknown build";

// Show error on white screen
window.oldOnError = window.onerror;
window.onerror = function(errorMsg, url, lineNumber, columnNo, errorObj) {

    if (Global.IGNORE_ALL_ERRORS){
        console.warn("IGNORING ERROR");
        console.log(errorMsg);
        return;
    }
    var err = new Error();

    // code to run when error has occured on page
    GameplayUI.showErrorScreen(errorMsg+"<br/>"+url+"<br/>"+lineNumber+"<br/>"+err.stack+"<br/>"+errorObj.stack);

    // upload error to AWS logs
    if (window['isProd']) {
        Cloud.uploadError(_buildNum + errorMsg + ' ' + url + ' ' + lineNumber + ' ' + err.stack + ' ' + errorObj.stack);
    }

    // stop game in bg
    if (window['pocketCityGame'] && window['pocketCityGame'].game){
        window['pocketCityGame'].game.paused = true;
    }
};

if (window['isProd']){
    console.log = function(){
        // do nothing with console.log
    };

    // overwrite console output, upload error to AWS logs
    console.errorOld = console.error;
    console.error = function(){
        var msg = "";
        for (var i = 0; i < arguments.length; i++){
            msg += arguments[i] + " ";
        }
        Cloud.uploadError(_buildNum +' error.log ' + msg);
        console.errorOld.apply(this, arguments);
    };
    console.warnOld = console.warn;

    var warnBatch = [];
    var flushWarnBatch = function(){
        if (warnBatch.length){
            var finalMsg = warnBatch.join(" \n");
            Cloud.uploadError(_buildNum +'error.warn ' + finalMsg);
            warnBatch = [];
        }
    };
    console.warn = function(){
        var msg = "";
        for (var i = 0; i < arguments.length; i++){
            msg += arguments[i] + " ";
        }
        warnBatch.push(msg);
        setTimeout(function(){
            flushWarnBatch();
        }, 1000);
        console.warnOld.apply(this, arguments);
    };
}


// MAIN:
setTimeout(function(){
    $('.splash').addClass("animin-in");
    setTimeout(function(){
        GameplayUI.updateLoadingProgress(0.1);
    }, 100);
}, 0);

GameplayUI.initializeDOMSelectors();
GameplayUI.initializeDomStyles();
initServicesDOM();

// Hammer
var hammer = new Hammer.Manager(document.body, {
    recognizers: [
        [Hammer.Swipe, {
            direction: Hammer.DIRECTION_HORIZONTAL
        }]
    ]
});

// Phaser game
var pocketCityGame = new PocketCity(hammer);
