// For a spawn, return the 2d number grid representing the power needed to be added
// to each index
function calculatePowerAdd(gridSize, spawnQuads, buildingCompleteAndRequiresPower, isOnRoadConductorGrid) {
    var outputPowerAdd = initialize2DArray(gridSize);
    spawnQuads.forEach(function (spawn) {
        var spawnRow = spawn[0], spawnCol = spawn[1], dimSize = spawn[2], spawnTotalPowerBuildings = spawn[3], isSameAsSpawn = spawn[4];
        var _a = countSpawnAffectBuildings(spawnRow, spawnCol, isSameAsSpawn), spawnAffectedBuildingsCount = _a[0], coveredRoadTiles = _a[1];
        var powerPerTile = Math.min(99, spawnTotalPowerBuildings / spawnAffectedBuildingsCount);
        var trackAddedPower = [];
        coveredRoadTiles.forEach(function (i) {
            _addPower(i[0], i[1], powerPerTile, outputPowerAdd, trackAddedPower);
        });
        forBorderAroundDim({ row: spawnRow, col: spawnCol }, dimSize, true, function (r, c) {
            _addAndTrack(r, c, powerPerTile, outputPowerAdd, trackAddedPower);
        });
    });
    // HELPERS
    function _addPower(row, col, power, powerLevelArr, trackPowerAdded) {
        if (!isValidIndex(row, col)) {
            return;
        }
        var OFFROAD_RADIUS = 2; // 2 used to come from ResourceOnRoadGrid.OFF_ROAD_RADIUS
        for (var i = 0; i < OFFROAD_RADIUS; i++) {
            var rowOffset = i + 1;
            for (var j = 0; j < OFFROAD_RADIUS; j++) {
                var colOffset = j + 1;
                _addAndTrack(row + rowOffset, col, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row - rowOffset, col, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row, col + colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row, col - colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row + rowOffset, col + colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row - rowOffset, col - colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row + rowOffset, col - colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row - rowOffset, col + colOffset, power, powerLevelArr, trackPowerAdded);
            }
        }
    }
    function _addAndTrack(row, col, power, powerLevelArr, trackPowerAdded) {
        if (!isValidIndex(row, col)) {
            return;
        }
        var i = toIndexKey(row, col);
        if (!trackPowerAdded[i] && isValidIndex(row, col)) {
            powerLevelArr[row][col] = powerLevelArr[row][col] + power;
            trackPowerAdded[i] = 1;
        }
    }
    // Count the number of buildings the spawn affects
    // Also return all the building tiles that the spawn floodfilled to be used by subsequent floodfill
    function countSpawnAffectBuildings(spawnRow, spawnCol, isSameAsSpawn) {
        var totalTouchingBuildings = 0;
        var floodFilled = initialize2DArray(gridSize);
        var checkedBuilding = initialize2DArray(gridSize);
        var q = [];
        var coveredRoads = [];
        q.push([spawnRow, spawnCol]);
        while (q.length > 0) {
            var index = q.shift(); // get first element
            var row = index[0], col = index[1];
            if (!floodFilled[row][col]) {
                floodFilled[row][col] = 1;
                if (!isSameAsSpawn[toIndexKey(row, col)]) {
                    totalTouchingBuildings += _countTouchingBuildingsBeside(row, col);
                }
                _countIfValid(q, row + 1, col, floodFilled);
                _countIfValid(q, row - 1, col, floodFilled);
                _countIfValid(q, row, col + 1, floodFilled);
                _countIfValid(q, row, col - 1, floodFilled);
            }
        }
        q = null;
        function _countTouchingBuildingsBeside(row, col) {
            var count = 0;
            count += _countIfCompletedBuildingTile(row + 1, col);
            count += _countIfCompletedBuildingTile(row - 1, col);
            count += _countIfCompletedBuildingTile(row, col + 1);
            count += _countIfCompletedBuildingTile(row, col - 1);
            count += _countIfCompletedBuildingTile(row + 1, col + 1);
            count += _countIfCompletedBuildingTile(row - 1, col - 1);
            count += _countIfCompletedBuildingTile(row + 1, col - 1);
            count += _countIfCompletedBuildingTile(row - 1, col + 1);
            function _countIfCompletedBuildingTile(row, col) {
                if (!isValidIndex(row, col)) {
                    return 0;
                }
                // don't double count
                if (checkedBuilding[row][col]) {
                    return 0;
                }
                checkedBuilding[row][col] = 1;
                if (buildingCompleteAndRequiresPower[toIndexKey(row, col)]) {
                    return 1;
                }
                else {
                    return 0;
                }
            }
            return count;
        }
        function _countIfValid(q, row, col, floodFilled) {
            if (!isValidIndex(row, col) || floodFilled[row][col])
                return false;
            var isPartOfStructureTile = isSameAsSpawn[toIndexKey(row, col)];
            var isOnRoadConductor = isOnRoadConductorGrid[toIndexKey(row, col)];
            if (isOnRoadConductor) {
                coveredRoads.push([row, col]);
            }
            if (isOnRoadConductor || isPartOfStructureTile) {
                q.push([row, col]);
            }
        }
        return [totalTouchingBuildings, coveredRoads];
    }
    function toIndexKey(r, c) {
        return r * gridSize + c;
    }
    function initialize2DArray(size) {
        var arr = [];
        var i, j;
        for (i = 0; i < size; i++) {
            arr[i] = [];
            for (j = 0; j < size; j++) {
                arr[i][j] = 0;
            }
        }
        return arr;
    }
    function isValidIndex(row, col) {
        return typeof row !== 'undefined' && typeof col !== 'undefined' &&
            row !== null && col !== null &&
            row >= 0 && row < gridSize && col >= 0 && col < gridSize;
    }
    function forBorderAroundDim(baseIndex, dimSize, withCorner, cb) {
        if (withCorner === void 0) { withCorner = false; }
        forBorder({
            row: baseIndex.row - (dimSize),
            col: baseIndex.col - (dimSize)
        }, {
            row: baseIndex.row + 1,
            col: baseIndex.col + 1
        }, cb, withCorner);
    }
    function forBorder(startIndex, endIndex, fn, includeCorners) {
        if (includeCorners === void 0) { includeCorners = true; }
        var tlR = Math.min(startIndex.row, endIndex.row);
        var tlC = Math.min(startIndex.col, endIndex.col);
        var trC = Math.max(startIndex.col, endIndex.col);
        var blR = Math.max(startIndex.row, endIndex.row);
        var col, row;
        // left to right
        for (col = tlC; col <= trC; col++) {
            if (!includeCorners && (col === tlC ||
                col === trC)) {
                continue;
            }
            fn(tlR, col);
            if (tlR !== blR) {
                fn(blR, col);
            }
        }
        // top to bottom
        if (tlR + 1 <= blR - 1) {
            for (row = tlR + 1; row <= blR - 1; row++) {
                fn(row, tlC);
                if (tlC !== trC) {
                    fn(row, trC);
                }
            }
        }
    }
    // response
    return outputPowerAdd;
}
// Input grids required:
// buildingCompleteAndRequiresPower
// isOnRoadConductorGrid
onmessage = function (e) {
    var serializedPayload = e.data;
    var payload = JSON.parse(serializedPayload);
    // vars
    var addBool = calculatePowerAdd(payload.gridSize, payload.spawnQuads, payload.buildingCompleteAndRequiresPowerStr, payload.isOnRoadConductorGridStr);
    postMessage(JSON.stringify(addBool));
};
