// Make TS happy
declare function postMessage(msg);

// For a spawn, return the 2d number grid representing the power needed to be added
// to each index
function calculatePowerAdd(
    gridSize: number,
    spawnQuads:[number,number,number,number,object][],
    buildingCompleteAndRequiresPower: {[indexKey:string]:number},
    isOnRoadConductorGrid: {[indexKey:string]:number}){

    let outputPowerAdd = initialize2DArray(gridSize);

    spawnQuads.forEach((spawn) => {
        let [
            spawnRow, spawnCol, dimSize,
            spawnTotalPowerBuildings, isSameAsSpawn
        ] = spawn;

        const [spawnAffectedBuildingsCount, coveredRoadTiles] = countSpawnAffectBuildings(spawnRow, spawnCol, isSameAsSpawn);
        const powerPerTile = Math.min(99, spawnTotalPowerBuildings/spawnAffectedBuildingsCount);
        const trackAddedPower = [];
        coveredRoadTiles.forEach(i => {
            _addPower(i[0],i[1], powerPerTile, outputPowerAdd, trackAddedPower);
        });

        forBorderAroundDim({row:spawnRow, col:spawnCol}, dimSize, true, (r,c) => {
            _addAndTrack(r, c, powerPerTile, outputPowerAdd, trackAddedPower);
        });
    });


    // HELPERS

    function _addPower(row, col, power, powerLevelArr, trackPowerAdded:number[]) {
        if (!isValidIndex(row, col)) {
            return;
        }
        let OFFROAD_RADIUS = 2; // 2 used to come from ResourceOnRoadGrid.OFF_ROAD_RADIUS
        for (let i = 0; i < OFFROAD_RADIUS; i++) {
            const rowOffset = i + 1;
            for (let j = 0; j < OFFROAD_RADIUS; j++) {
                const colOffset = j + 1;
                _addAndTrack(row + rowOffset, col, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row - rowOffset, col, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row, col + colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row, col - colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row + rowOffset, col + colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row - rowOffset, col - colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row + rowOffset, col - colOffset, power, powerLevelArr, trackPowerAdded);
                _addAndTrack(row - rowOffset, col + colOffset, power, powerLevelArr, trackPowerAdded);
            }
        }
    }

    function _addAndTrack(row, col, power, powerLevelArr, trackPowerAdded:number[]){
        if (!isValidIndex(row, col)) {
            return;
        }
        let i = toIndexKey(row, col);
        if (!trackPowerAdded[i] && isValidIndex(row, col)) {
            powerLevelArr[row][col] = powerLevelArr[row][col] + power;
            trackPowerAdded[i] = 1;
        }
    }

    // Count the number of buildings the spawn affects
    // Also return all the building tiles that the spawn floodfilled to be used by subsequent floodfill
    function countSpawnAffectBuildings(spawnRow, spawnCol, isSameAsSpawn):[number, [number, number][]]{
        let totalTouchingBuildings = 0;
        const floodFilled = initialize2DArray(gridSize);
        const checkedBuilding = initialize2DArray(gridSize);
        let q:[number,number][] = [];
        let coveredRoads:[number,number][] = [];
        q.push([spawnRow, spawnCol]);
        while (q.length > 0) {
            const index = q.shift(); // get first element
            const [row, col] = index;
            if (!floodFilled[row][col]){
                floodFilled[row][col] = 1;
                if (!isSameAsSpawn[toIndexKey(row, col)]) {
                    totalTouchingBuildings += _countTouchingBuildingsBeside(row, col);
                }
                _countIfValid(q, row + 1, col, floodFilled);
                _countIfValid(q, row - 1, col, floodFilled);
                _countIfValid(q, row, col + 1, floodFilled);
                _countIfValid(q, row, col - 1, floodFilled);
            }
        }
        q = null;
        function _countTouchingBuildingsBeside(row, col){
            let count = 0;
            count += _countIfCompletedBuildingTile(row + 1, col);
            count += _countIfCompletedBuildingTile(row - 1, col);
            count += _countIfCompletedBuildingTile(row, col + 1);
            count += _countIfCompletedBuildingTile(row, col - 1);
            count += _countIfCompletedBuildingTile(row + 1, col + 1);
            count += _countIfCompletedBuildingTile(row - 1, col - 1);
            count += _countIfCompletedBuildingTile(row + 1, col - 1);
            count += _countIfCompletedBuildingTile(row - 1, col + 1);
            function _countIfCompletedBuildingTile(row, col){
                if (!isValidIndex(row, col)){
                    return 0;
                }
                // don't double count
                if (checkedBuilding[row][col]){
                    return 0;
                }
                checkedBuilding[row][col] = 1;
                if(buildingCompleteAndRequiresPower[toIndexKey(row, col)]){
                    return 1;
                } else {
                    return 0;
                }
            }
            return count;
        }

        function _countIfValid(q:[number,number][], row, col, floodFilled) {
            if (!isValidIndex(row, col) || floodFilled[row][col]) return false;
            const isPartOfStructureTile = isSameAsSpawn[toIndexKey(row, col)];
            const isOnRoadConductor = isOnRoadConductorGrid[toIndexKey(row, col)];
            if (isOnRoadConductor){
                coveredRoads.push([row,col]);
            }
            if (isOnRoadConductor || isPartOfStructureTile) {
                q.push([row,col]);
            }
        }
        return [totalTouchingBuildings, coveredRoads];
    }

    function toIndexKey(r:number, c:number){
        return r * gridSize + c;
    }

    function initialize2DArray(size){
        let arr = [];
        let i, j;
        for (i = 0; i < size; i++) {
            arr[i] = [];
            for (j = 0; j < size; j++) {
                arr[i][j] = 0;
            }
        }
        return arr;
    }

    function isValidIndex(row, col){
        return typeof row !== 'undefined' && typeof col !== 'undefined' &&
            row !== null && col !== null &&
            row >= 0 && row < gridSize && col >= 0 && col < gridSize;
    }

    function forBorderAroundDim(baseIndex, dimSize:number, withCorner=false, cb:(row, col) => any){
        forBorder({
            row: baseIndex.row-(dimSize), // one extra -
            col: baseIndex.col-(dimSize)
        }, {
            row: baseIndex.row+1, // one extra + for lower
            col: baseIndex.col+1
        }, cb, withCorner);
    }
    function forBorder(startIndex, endIndex, fn:(r:number,c:number) => any, includeCorners=true){
        let tlR = Math.min(startIndex.row, endIndex.row);
        let tlC = Math.min(startIndex.col, endIndex.col);
        let trC = Math.max(startIndex.col, endIndex.col);
        let blR = Math.max(startIndex.row, endIndex.row);

        let col, row;

        // left to right
        for (col = tlC; col<=trC; col++){
            if (!includeCorners && (
                    col === tlC||
                    col === trC)){
                continue;
            }
            fn(tlR, col);
            if (tlR !== blR) {
                fn(blR, col);
            }
        }

        // top to bottom
        if (tlR + 1 <= blR - 1) {
            for (row = tlR + 1; row <= blR - 1; row++) {
                fn(row, tlC);
                if (tlC !== trC) {
                    fn(row, trC);
                }
            }
        }
    }

    // response
    return outputPowerAdd;
}


// Input grids required:
// buildingCompleteAndRequiresPower
// isOnRoadConductorGrid

onmessage = function(e) {
    let serializedPayload = e.data;
    let payload = JSON.parse(serializedPayload);

    // vars
    let addBool = calculatePowerAdd(
        payload.gridSize,
        payload.spawnQuads,
        payload.buildingCompleteAndRequiresPowerStr,
        payload.isOnRoadConductorGridStr);
    postMessage(JSON.stringify(addBool));
};
