// Main
function compressSaveCity(saveFileStr) {
    // CONSTANTS - must not change, copied from GridSerializer
    var COMPRESS = {
        REPLACE_ME: '"",',
        REPLACE_WITH_PREFIX: '^',
        REPLACE_WITH_SUFFIX: '~'
    };
    var REPLACE_ME = COMPRESS.REPLACE_ME;
    var REPLACE_WITH_PREFIX = COMPRESS.REPLACE_WITH_PREFIX;
    var REPLACE_WITH_SUFFIX = COMPRESS.REPLACE_WITH_SUFFIX;
    var tokenLength = REPLACE_ME.length;
    var outputStr = "";
    var anchor = 0;
    var prevAnchor = 0;
    var skippedLength = 0;
    var isStartOfToken = false;
    var subTokenIndex = 0;
    var numConsecutiveTokens = 0;
    while (anchor < saveFileStr.length) {
        var sub = saveFileStr.substr(anchor, tokenLength);
        isStartOfToken = sub === REPLACE_ME;
        if (isStartOfToken) {
            // found replaceable token
            // put non-replaceable substring into output str
            if (skippedLength > 0) {
                outputStr += saveFileStr.substr(prevAnchor, skippedLength);
                skippedLength = 0;
            }
            // see how many consecutive tokens there are
            numConsecutiveTokens = 1;
            subTokenIndex = tokenLength;
            while (saveFileStr.substr(anchor + subTokenIndex, tokenLength) === REPLACE_ME) {
                numConsecutiveTokens += 1;
                subTokenIndex += tokenLength;
            }
            anchor += numConsecutiveTokens * tokenLength;
            prevAnchor = anchor;
            // append replaced token in output str
            outputStr += (REPLACE_WITH_PREFIX + numConsecutiveTokens + REPLACE_WITH_SUFFIX);
        }
        else {
            skippedLength += 1;
            anchor += 1;
        }
    }
    if (skippedLength > 0) {
        outputStr += saveFileStr.substr(prevAnchor, skippedLength);
    }
    return outputStr;
}
onmessage = function (e) {
    var uncompressedSaveStr = e.data;
    var compressed = compressSaveCity(uncompressedSaveStr);
    postMessage(compressed);
};
