// Make TS happy
declare function postMessage(msg);

// Main
function compressSaveCity(saveFileStr:string){
    // CONSTANTS - must not change, copied from GridSerializer
    const COMPRESS = {
        REPLACE_ME: '"",',
        REPLACE_WITH_PREFIX: '^',
        REPLACE_WITH_SUFFIX: '~',
    };

    const REPLACE_ME = COMPRESS.REPLACE_ME;
    const REPLACE_WITH_PREFIX = COMPRESS.REPLACE_WITH_PREFIX;
    const REPLACE_WITH_SUFFIX = COMPRESS.REPLACE_WITH_SUFFIX;
    const tokenLength = REPLACE_ME.length;

    let outputStr = "";

    let anchor = 0;
    let prevAnchor = 0;
    let skippedLength = 0;
    let isStartOfToken = false;
    let subTokenIndex = 0;
    let numConsecutiveTokens = 0;

    while(anchor < saveFileStr.length){
        let sub = saveFileStr.substr(anchor, tokenLength);
        isStartOfToken = sub === REPLACE_ME;
        if (isStartOfToken){
            // found replaceable token
            // put non-replaceable substring into output str
            if (skippedLength > 0){
                outputStr += saveFileStr.substr(prevAnchor, skippedLength);
                skippedLength = 0;
            }

            // see how many consecutive tokens there are
            numConsecutiveTokens = 1;
            subTokenIndex = tokenLength;
            while(saveFileStr.substr(anchor+subTokenIndex,tokenLength) === REPLACE_ME){
                numConsecutiveTokens += 1;
                subTokenIndex += tokenLength;
            }
            anchor += numConsecutiveTokens * tokenLength;
            prevAnchor = anchor;

            // append replaced token in output str
            outputStr += (REPLACE_WITH_PREFIX + numConsecutiveTokens + REPLACE_WITH_SUFFIX)
        } else {
            skippedLength += 1;
            anchor += 1;
        }
    }
    if (skippedLength > 0){
        outputStr += saveFileStr.substr(prevAnchor, skippedLength);
    }
    return outputStr;
}

onmessage = function(e) {
    let uncompressedSaveStr = e.data;
    let compressed = compressSaveCity(uncompressedSaveStr);
    postMessage(compressed);
};