// Main
function decompressSaveCity(compressedSave) {
    // CONSTANTS - must not change, copied from GridSerializer
    var COMPRESS = {
        REPLACE_ME: '"",',
        REPLACE_WITH_PREFIX: '^',
        REPLACE_WITH_SUFFIX: '~'
    };
    var REPLACE_ME = COMPRESS.REPLACE_ME;
    var REPLACE_WITH_PREFIX = COMPRESS.REPLACE_WITH_PREFIX;
    var REPLACE_WITH_SUFFIX = COMPRESS.REPLACE_WITH_SUFFIX;
    var anchor = 0;
    var prevAnchor = 0;
    var nonCompressedLen = 0;
    var output = "";
    var endIndex = 0;
    var numberConsec = 0;
    var decompressed = "";
    var _max = compressedSave.length;
    while (anchor < _max) {
        if (compressedSave[anchor] == REPLACE_WITH_PREFIX) {
            // add non-compressed string to output
            output += compressedSave.substr(prevAnchor, nonCompressedLen);
            nonCompressedLen = 0;
            // find substr end index
            endIndex = anchor + 1;
            while (compressedSave[endIndex] !== REPLACE_WITH_SUFFIX && endIndex < _max) {
                endIndex += 1;
            }
            numberConsec = +(compressedSave.substr(anchor + 1, endIndex - anchor - 1));
            decompressed = "";
            while (numberConsec) {
                numberConsec -= 1;
                decompressed += REPLACE_ME;
            }
            output += decompressed;
            // update pointers
            anchor = endIndex + 1;
            prevAnchor = anchor;
        }
        else {
            nonCompressedLen += 1;
            anchor += 1;
        }
    }
    if (nonCompressedLen) {
        output += compressedSave.substr(prevAnchor, nonCompressedLen);
    }
    return output;
}
onmessage = function (e) {
    var compressedSaveStr = e.data;
    var decompressed = decompressSaveCity(compressedSaveStr);
    postMessage(decompressed);
};
