// Make TS happy
declare function postMessage(msg);

// Main
function decompressSaveCity(compressedSave:string){
    // CONSTANTS - must not change, copied from GridSerializer
    const COMPRESS = {
        REPLACE_ME: '"",',
        REPLACE_WITH_PREFIX: '^',
        REPLACE_WITH_SUFFIX: '~',
    };

    const REPLACE_ME = COMPRESS.REPLACE_ME;
    const REPLACE_WITH_PREFIX = COMPRESS.REPLACE_WITH_PREFIX;
    const REPLACE_WITH_SUFFIX = COMPRESS.REPLACE_WITH_SUFFIX;

    let anchor = 0;
    let prevAnchor = 0;
    let nonCompressedLen = 0;
    let output = "";
    let endIndex = 0;
    let numberConsec = 0;
    let decompressed = "";
    let _max = compressedSave.length;
    while(anchor < _max){
        if (compressedSave[anchor] == REPLACE_WITH_PREFIX){
            // add non-compressed string to output
            output += compressedSave.substr(prevAnchor, nonCompressedLen);
            nonCompressedLen = 0;
            // find substr end index
            endIndex = anchor + 1;
            while(compressedSave[endIndex] !== REPLACE_WITH_SUFFIX && endIndex < _max){
                endIndex += 1;
            }
            numberConsec = +(compressedSave.substr(anchor + 1, endIndex - anchor - 1));
            decompressed = "";
            while(numberConsec){
                numberConsec -= 1;
                decompressed += REPLACE_ME;
            }

            output += decompressed;

            // update pointers
            anchor = endIndex + 1;
            prevAnchor = anchor;

        } else {
            nonCompressedLen += 1;
            anchor += 1;
        }
    }
    if (nonCompressedLen){
        output += compressedSave.substr(prevAnchor, nonCompressedLen);
    }
    return output;
}

onmessage = function(e) {
    let compressedSaveStr = e.data;
    let decompressed = decompressSaveCity(compressedSaveStr);
    postMessage(decompressed);
};