package ks.cm.antivirus.defend;


interface IDefendServiceRaw {

	//启动防御，调用者只能为 com.ijinshan.duba 
    boolean     Start(/*IN*/ String strClientAPKName);
    
    //关闭防御，调用者只能为 com.ijinshan.duba
    boolean     Stop(/*IN*/ String strClientAPKName);
    
    byte[]    handleNativeServiceClient(in byte[] req);
    //查询防御状态，调用者只能为 com.ijinshan.duba
    //	如果返回 1	防御正在运行
    //	如果返回0	防御被停止
    //	如果返回-1	调用者无效
    int         QueryDefendState(/*IN*/ String strClientAPKName);
    
    //恶意应用规则管理
    boolean     PushDefendRule(/*IN*/ String strPkgName, /*IN*/ String strAPKSign, /*IN*/ String rule);
    
    boolean		IsApkInAdwareRule(/*IN*/ String strPkgName);
    //////////////////
    // 检查服务是否存在
    String		CheckAlive();
    
    //////////////////
    // 通知服务有新的任务栏通知出现
	List<String> AdGetNotifyInfo( /*IN*/ String strAPKName,  /*IN*/ int nId);
	
	// 广告的接口
	void		AdClearPopCount();
	
	
	/// 检查是否需要完全重新扫描广告
	boolean CheckNeedReScanAdware();
	
	/// 设置已经进行了广告的完全扫描 
	void SetAdwareFullScan(boolean bNeed);
	
	/// 主进程升级库完成后的通知
	void NotifyUpdateDataFinish();
    
    /// 被结束进程通知
    /// 返回1 允许被结束
    /// 返回0 不允许被结束
    int	TerminateNotify(String pkgname, int clientPid);
    
	
	boolean IsUrlProtectOpen(String pkgName);
	
	//接收到跨域弹框认证攻击
	void UrlProtectAuthLoginHack(String pkgName, String url, String urlHost, String authHost);
	
	// 用户是否打开拦截钓鱼url
	void SetBlockFishUrl(boolean isBlock);
	
	// 用户是否打开隱私痕跡清理
	void SetBlockRiskyUrl(boolean isBlock);
	
	//通知防御更新全局缓存
	void NotifyRuleChanged(String pkgName);
	
	/************************************************ 通知启动计划任务 ******************************************/
	void notifyStartScheduledTask(byte byScheduledTask);
	
	///< 通知app语言更新
	void notifyAppLauguageChange();
	
	///< copy so
	///< @return -1:加载系统默认路径 1:加载mSystemLibPath路径 2:加载自拷贝路径
	int syncSoFiles(String strLibName, in List<String> listDepenceLibNames, boolean bForceExtract);
}
