// IInteractiveTaskBinder.aidl
package ks.cm.antivirus.defend.onetime.interactivetask;

import ks.cm.antivirus.scan.appupgradehole.AppDownloadInfoBean;
import ks.cm.antivirus.defend.onetime.interactivetask.IVerifyApkTaskCallback;
import ks.cm.antivirus.remotedata.IVirusDataVersion;
import ks.cm.antivirus.remotedata.IVirusUpdateCallBack;
import ks.cm.antivirus.defend.onetime.interactivetask.IDownloadCloudConfigCallback;

interface IInteractiveTaskBinder {

    void verifyLocalApk(in AppDownloadInfoBean downloadInfo, boolean checkSignature, IVerifyApkTaskCallback callback);

    /************************************************* 病毒库更新 **********************************************/
    void registerUpdateCall(IVirusDataVersion updateVersion);
    void notifyUpdate();

    void virusDatabaseCheck(IVirusUpdateCallBack virusUpdateCallBack);//手动更新病毒库
    void virusDatabaseUpdate();
    void virusDataCheckCancel();
    void virusDataUpdateCancel();
    void virusCancel();

    /************************************************* 下拉云端配置 **********************************************/
    void startDownloadCloudCfg(boolean force, IDownloadCloudConfigCallback callback);

}
