// INotificationDataProvider.aidl
package ks.cm.antivirus.notification.intercept.backgroundservice;

import ks.cm.antivirus.notification.intercept.bean.NotificationBoxGroupBean;
import ks.cm.antivirus.notification.intercept.backgroundservice.IDataChangedCallback;

interface INotificationDataProvider {

    void setDataChangedCallback(IDataChangedCallback call);

    void removeDataChangedCallback();

    List<NotificationBoxGroupBean> getAllNotificationGroupBeanList();

    int getNotificationInterceptCounts();

    int getSmsInterceptCounts();

    List<NotificationBoxGroupBean> getNotificationBoxData();

    boolean deleteGroupNotifications(String pkgName);

    void deleteAllRubbishSmsNotifications();

    boolean isRubbishSmsNotificationsEmpty();

    boolean deleteSingleNotification(String pkgName, int notifyId, boolean isSendBroadCast);

    void clearAllNotifications();

    boolean isCacheDataHaveScreenShotNotify();
}
