package ks.cm.antivirus.remotedata;

import ks.cm.antivirus.remotedata.ApkData;
import ks.cm.antivirus.remotedata.IVirusDataVersion;
import ks.cm.antivirus.remotedata.IRemoteControlBinder;
import ks.cm.antivirus.neweng.IApkResult;
import ks.cm.antivirus.neweng.service.ILoadExtCallBack;
import ks.cm.antivirus.remotedata.IVirusUpdateCallBack;
import ks.cm.antivirus.neweng.IApkResult;
import ks.cm.antivirus.scan.appupgradehole.AppUpgradeHoleBean;
import ks.cm.antivirus.scan.appupgradehole.AppDownloadInfoBean;

interface IRemoteDataBinder {

	void 			SetCtrlBinder(IRemoteControlBinder ctrlBinder); 
	
    /************************************************* 公共部分 ***********************************************/
	
	ApkData 		QueryApkData(String pkgName);							/// 查询单个apk的数据
	List<ApkData> 	GetApkDataList();										/// 获取apk所有需要数据列表
	void 			LoadExtAsy(String pkgName,String signMd5,in ILoadExtCallBack callback,int tags);
	
    /************************************************* 广告部分 ***********************************************/
	
	boolean 		IsAdMonitorOn();   										/// 广告监控开关是否打开
	void 			SetAdMonitorOn(boolean bMonitor);   					/// 设置广告监控开关
	boolean 		CheckNeedReScanAdware();         						/// 查询是否需要重扫逻辑
	void 			SetAdwareFullScan(boolean bNeed);						/// 设置已经进行了广告的完全扫描 
	boolean 		AddAdwareRule(String pkgName);							/// 禁用某个app广告
	boolean 		DeleteAdwareRule(String pkgName);						/// 取消禁用某个app广告
	boolean 		IsApkInAdwareRule(String pkgName);						/// 查询某个app是否被禁用广告
	
	/************************************************* 病毒部分 ***********************************************/
	
	String 			GetMaliciousRule(String pkgName);						/// 获取病毒规则内容
	boolean     	PushDefendRule(String pkgName,String sign,String rule);	/// 加入病毒规则
	boolean	    	EnableMaliciousRule( String pkgName,  String sign);		/// 启用病毒规则
	boolean	    	DisableMaliciousRule( String pkgName,  String sign);	/// 禁用病毒规则
    boolean     	DeleteMaliciousRule( String pkgName,  String sign);		/// 删除病毒禁用规则
    boolean     	IsMaliciousRuleEnabled( String pkgName,  String sign);	/// 查询病毒规则是否可用
    String[]		GetAllMaliciousAPKs();									/// 获取所有病毒apk
    
	/************************************************* 隐私部分 ***********************************************/
	
	String      	GetPrivacyRule(String pkgName);							/// 获取隐私规则内容
	boolean     	PushPrivacyRule(String pkgName,String sign,String rule);/// 加入隐私拦截规则
    boolean     	DeletePrivacyRule( String pkgName,  String sign);		/// 删除隐私拦截规则
    boolean     	IsPrivacyRuleEnabled( String pkgName,  String sign);	/// 查询隐私规则是否可用

    
	void removeDefendRuleData(in String pkgName); 
	/************************************************* 病毒库更新 **********************************************/
//	void registerUpdateCall(IVirusDataVersion updateVersion);
//	void notifyUpdate();
//
//	void virusDatabaseCheck(IVirusUpdateCallBack virusUpdateCallBack);//手动更新病毒库
//	void virusDataCheckCancel();
//	void virusDatabaseUpdate();
//	void virusDataUpdateCancel();
//	void virusCancel();
	
	/************************************************* 上传灰样本 **********************************************/
	void reportUnknowAppWithList(boolean isCancel, in List<IApkResult> unknownList, in List<String> ticketList);
	
	/************************************************* GCM注册 **********************************************/
	void gcmRegist();
	void gcmUnRegist();
	void gcmSwitchEmail(String newEmail);
	void gcmSwithcCancel();
	void lockScreen(String phone);
	void unLockScreen();
	//以下是获取云端文案接口
	String getCloudCfgStringValue(String key, String subKey, String defValue);

	/************************************************* APP 漏洞 **********************************************/
	void startDownloadApp(in AppDownloadInfoBean downloadInfo);         // 下载升级修复APP漏洞
	List<AppDownloadInfoBean> getDownloadAppList();                     // 获取修复漏洞下载的所有下载任务
	List<AppUpgradeHoleBean> getAppUpgradeHoleAppList();                // 获取有APP漏洞的应用列表

    /**
     * @return whether install start
     */
    boolean installPreDownloadedApk(in AppDownloadInfoBean downloadInfo);

}
