
const _globalData = {
    nativeData: options ? options.nativeData : ''
};


service.register(options.serviceName, {

    /**
     * JS Service lifecycle. JS Service `create` will before then each instance lifecycle `create`. The return param `instance` is Weex protected param. This object will return to instance global. Other params will in the `service` at instance.
     *
     * @param  {String} id  instance id
     * @param  {Object} env device environment
     * @return {Object}
     */
    create: function (id, env, config) {
        //用户打开页面数记录
        var today = parseInt((new Date().getTime()+8*3600*1000)/(24*3600*1000));
        _globalData["active_open_page_" + today] = (_globalData["active_open_page_" + today]||0) + 1;

        return {
            instance: {
                globalData: {
                    set (key, value) {
                        if (value != null) {
                            if (env.platform === 'Web') {
                                window.localStorage.setItem(key, JSON.stringify(value));
                            } else {
                                _globalData[key] = value;
                            }
                        }
                    },

                    get (key) {
                        if (env.platform === 'Web') {
                            var _tmpValue = window.localStorage.getItem(key);   //用let在ios9上报错，不知道为什么，改成var
                            if (_tmpValue) {
                                _tmpValue = JSON.parse(_tmpValue);
                            }
                            return _tmpValue;
                        } else {
                            return _globalData[key];
                        }
                    }
                },
                helper: {},
                parts: {}
            },
        }
    },
    /**
     * JS Service lifecycle. JS Service `refresh` will before then each instance lifecycle `refresh`. If you want to reset variable or something on instance refresh.
     *
     * @param  {String} id  instance id
     * @param  {Object} env device environment
     */
    refresh: function (id, env, config) {
    },
    /**
     * JS Service lifecycle. JS Service `destroy` will before then each instance lifecycle `destroy`. You can deleted variable here. If you doesn't detete variable define in JS Service. The variable will always in the js runtime. It's would be memory leak risk.
     *
     * @param  {String} id  instance id
     * @param  {Object} env device environment
     * @return {Object}
     */
    destroy: function (id, env) {
    }
});