//保存页面初始化数据
var DIY_INFO;

//页面初始化(原生来调用)
function pageInit() {
	//获取初始化数据
	DIY_INFO = JSON.parse($('#page_data').val());
	//1.根据info里面的data_order按顺序来请求数据，并且渲染界面
	//2.code example:
	var params = {};
    $.each( DIY_INFO.data_order[0] , function( k , v ){
          var newParam = DIY_INFO.data[v];
          params[v] = newParam;
    });
    //请求数据
    SmartCity.pageGetData(JSON.stringify(params),function(ret) {

	    pageRander(ret,true);

          //判断有没有第二批的数据
          if (DIY_INFO.data_order[1]) {
	          var qparams = {};
	          $.each( DIY_INFO.data_order[1] , function( kk , vv ) {
	                 var qnewParam = DIY_INFO.data[vv];
	                 if(qnewParam['api_depend'].length > 0){
	                 	 //获取被依赖的动态值
		                 var field = $('#block_' + qnewParam['api_depend']['index'] + ' .block-column-dynamic:eq(0)').attr('dynamic_value');
		                 var fieldObj = pageProcessParams(field);
		                 $.each (qnewParam['api_depend']['field'],function(_kk,_vv) {
		                	 if (fieldObj.hasOwnProperty(_vv)) {
		                		 qnewParam['api_params'][_kk] = fieldObj[_vv];
		                	 }
		                 });
	                 }
	                 qparams[vv] = qnewParam;
	          });
	          //开始请求数据
	          SmartCity.pageGetData(JSON.stringify(qparams),function(re) {
                     pageRander(re,true);
              });
          }

	});
    //渲染好数据之后通知原生表明界面已经渲染好了
    SmartCity.pageFinishWebviewRander();
}

//将数据保存到本地
function setLocalStorage( datasource , data ){
	window.localStorage.setItem( datasource , data );
}

//清除数据
function removeLocalStorage()
{
    window.localStorage.clear();
}
//获取图片地址，并传递给loadImageResources
function getPicSrc() {
	$('img').map(function( k , v ) {
            var _this = this;
            var src = $(this).attr('_src'),
		    width = $(this).attr('_width'),
		    height = $(this).attr('_height');
            var newsrc = getPicUrl( src , width , height );
		   	SmartCity.loadImageResources( newsrc , function( backsrc ) {
	                  //如果是安卓需要转成JSON对象
	                  var imgvalue =backsrc['imageUrl'];
	                  if( src != imgvalue ){
	                        $(_this).attr({'src':imgvalue,'_src' :imgvalue });
	                  }
		      })
	})
}

//图片处理
function getPicUrl( file , width, height ) {
	var src;
	if( file.indexOf('{$hgPicSizeStart}') > 0){
		file = file.replace('{$hgPicSizeStart}', '' );
		file = file.replace('{$hgPicSizeEnd}', '' );
		file = file.replace('{$hgPicSizeWidth}', width );
		file = file.replace('{$hgPicSizeHeight}', height  );
		src = file;
	}else{
        src = file;
    }
	return src;
}

//渲染界面的公共方法
function pageRander(ret , bool ) {
	//拿到数据之后开始渲染数据(渲染数据分类2种类型 1:替换 2:追加)此处由于是初始化，所以选择的是替换
	$.each( ret , function( key , value ) {
           var zz = JSON.stringify(value);
           var md5ret = $.md5(zz);
  	     	var getsource = JSON.parse(window.localStorage.getItem( 'datasource_' + key ) );
  	    	if( md5ret != getsource ){
       
  		    //渲染界面
		    	var dom = $('#block_' + key );
            	var tpl = dom.attr('_tpl');
            	var dataTpl = template.compile( tpl );
            	var dataHtml = dataTpl( value );
            	//此处根据is_load_more 判断是替换还是追加
            	if( bool ){
               		dom.html(dataHtml);
            	}else{
               		if( DIY_INFO.data[key]['is_load_more'] == 1 ) {
                    		dom.append(dataHtml);
               		}else{
                    		dom.html(dataHtml);
               		}
            	}
		    	setLocalStorage( 'datasource_' + key , JSON.stringify(md5ret) );
  	    	}
	});
    	swiper();
    	getPicSrc();
}

//加载更多数据
function pageLoadMoreData() {
	//1.当用户选择某个区块上拉或者下拉加载某个区块(组件)的时候，客户端调用此方法通知前端可以加载更多的数据，此时客户端本身会显示加载中...的动画效果
	//2.前端接受到此通知之后，根据区块索引(block_index)找到对应的区块，并且计算出加载更多数据时需要的offset和count值
	//3.计算出参数值之后，前端调用客户端统一的请求数据接口(SmartCity.pageGetData)，并且携带参数过去，类似:{'index':'8','params':{'offset':6,'count': 8}}
	//4.客户端接收到参数值之后，拿到区块索引值(index)可以获取到该区块的相关的信息，包括接口地址信息，然后将接口参数(params)的值遍历之后加到请求的接口地址后面
	//5.客户端请求接口地址之后，获取到了数据之后，将数据即时返回给前端
	//6.前端接收到数据之后，对本区块进行界面的数据累加渲染，渲染完成之后调用客户端的方法通知客户端已经完成渲染(SmartCity.finishLoadMoreData)
	//7.客户端接收到通知之后，就会隐藏掉【加载中...】的动画效果。至此，列表加载数据的过程完毕。
	var len = $('.diy_block_item').length;
	var item = $('.diy_block_item:last');
	var index = item.attr('block_index');      //block_index需要后台添加字段
	var param = DIY_INFO.data[index];
	if(param['api_depend'].length > 0) {
		var field = $('#block_' + param['api_depend']['index'] + ' .block-column-dynamic:eq(0)').attr('dynamic_value');
		var fieldObj = pageProcessParams(field);
        $.each (param['api_depend']['field'],function(_kk,_vv) {
	       	 if (fieldObj.hasOwnProperty(_vv)) {
	       		 param['api_params'][_kk] = fieldObj[_vv];
	       	 }
        });
	}
	param['api_params']['offset'] = item.length;
	if( !param['api_params']['count'] ) {
		param['api_params']['count'] = 10;
	}
    var newParam = {};
    newParam[index] = param;
    SmartCity.pageGetData(JSON.stringify(newParam),function(ret) {
          //渲染好了之后判断是追加元素还是替换元素
          var tip = "";
          if( ret ){
                pageRander(ret , false);
          }else{
                tip = '没有更多数据～';
          }
          SmartCity.finishLoadMoreData(tip);
    });
}

//局部重新加载
function pageLocalReLoadData(block_index,param_value) {
	//获取依赖关系
	if( DIY_INFO.depend[block_index] ) {
		var params = {};
		$.each( DIY_INFO.depend[block_index] , function( k , v ) {
			var newParam = DIY_INFO.data[v];
			if(newParam['api_depend'].length > 0) {
				var fieldObj = pageProcessParams(param_value);
		        $.each (newParam['api_depend']['field'],function(_kk,_vv) {
			       	 if (fieldObj.hasOwnProperty(_vv)) {
			       		newParam['api_params'][_kk] = fieldObj[_vv];
			       	 }
		        });
			}
			params[v] = newParam;
		})
		//请求数据
		SmartCity.pageGetData(JSON.stringify(params),function(ret) {
			//替换原有元素
			pageRander(ret,true);
		});
	}
}

//检测设备
function pageCheckClient() {
    var u = navigator.userAgent;
    var isAndroid = u.indexOf('Android') > -1 || u.indexOf('android') > -1 ;
    return isAndroid;
}

//处理参数值
function pageProcessParams(paramStr) {
	var paramArr = new Array();
	var paramObj = {};
	paramArr = paramStr.split(";");//分割成数组
	for (i=0;i<paramArr.length ;i++ ) {
		var m = paramArr[i].split(":");
		if (m.length == 2) {
			paramObj[m[0]] = m[1];
		}
	}
	return paramObj;
}

//轮转效果
function swiper(){
	var swiperDom = $("body").find("div.swiper-container");
	if( swiperDom ){
        var mySwiper = new Swiper('.swiper-container', {
             pagination: '.swiper-pagination',
             paginationClickable: true,
             slidesPerView: 'auto',
             spaceBetween: 0,
        });
	}
}
