angular.module('newsPage',[]).controller('newsCtr' , [ '$rootScope' , '$scope' , '$sce' ,  function( $rootScope , $scope , $sce ){
    var vm = $scope.vm = {};
    angular.extend( vm , {
        init : function(){
            vm.newsInfo = window.newsInfo;
            if( vm.newsInfo.detail.keywords ){
                   vm.newsInfo.detail.keywords = vm.newsInfo.detail.keywords.split(',');
            }
                   
            vm.getUserInfo();
            vm.getPraiseInfo();
            vm.getDiggInfo();
            vm.getRelateNews();
            vm.getCommentList();
            vm.getSubsInfo();
                   vm.getAdInfo();
        },
          
        /*获取用户信息*/
        getUserInfo : function(){
            SmartCity.getUserInfo( function( res ){
                vm.userInfo = res;
                $scope.$apply();
            });
        },

        /*获取订阅号信息*/
        getSubscriptionList : function(status){
            SmartCity.goSubscription( status , function( res ){
                vm.subsInfo.is_subscribe = res;
                $scope.$apply();
            });
        },
                   
        /*获取点赞信息*/
        getPraiseInfo : function(){
            vm.praiseYidian = false;
            SmartCity.getPraiseInfo(function( res ){
                vm.praiseInfo = res;
                if( vm.praiseInfo.person_info.length && vm.userInfo.userInfo.userid ){
                    angular.forEach(vm.praiseInfo.person_info , function( v , k ){
                        if( v.avatar && v.avatar.host ){
                            v.picurl = v.avatar.host + v.avatar.dir + '50x50/' + v.avatar.filepath + v.avatar.filename;
                        }
                    });
                }
                $scope.$apply();
            });
        },
                   
        /*获取顶踩信息*/
        getDiggInfo : function(){
            SmartCity.getDiggInfo(function( res ){
                vm.diggInfo = res;
                vm.diggInfo.up = vm.diggInfo.up ? parseInt(vm.diggInfo.up) : 0;
                vm.diggInfo.down = vm.diggInfo.down ? parseInt(vm.diggInfo.down) : 0;
                vm.diggInfo.upwidth = (parseInt(vm.diggInfo.up)/(parseInt(vm.diggInfo.up) + parseInt(vm.diggInfo.down)))*100 + '%';
                $scope.$apply();
            });
        },
             
        /*获取相关新闻*/
        getRelateNews : function(){
            SmartCity.getRelateNews(function( res ){
                vm.relateNews = res;
                angular.forEach(vm.relateNews , function( v , k ){
                    var dateStr = v.publish_time;
                    var time = Date.parse(dateStr.replace(/-/gi,"/"));
                    v.publish_time_format = vm.getDateDiff(time);
                    if( v.indexpic && v.indexpic.host ){
                        v.picurl = v.indexpic.host + v.indexpic.dir + '124x82/' + v.indexpic.filepath + v.indexpic.filename;
                    }
                });
                $scope.$apply();
            });
        },

        /*把时间转化成一天前，一个月前等等*/
        getDateDiff : function( time ){
            var minute = 1000 * 60;
            var hour = minute * 60;
            var day = hour * 24;
            var halfamonth = day * 15;
            var month = day * 30;
            var now = new Date().getTime();
            var diffValue = now - time;
            if(diffValue < 0){
            //若日期不符则弹出窗口告之
                alert("结束日期不能小于开始日期！");
            }
            var monthC =diffValue/month;
            var weekC =diffValue/(7*day); 
            var dayC =diffValue/day;  
            var hourC =diffValue/hour;
            var minC =diffValue/minute;
            if(monthC>=1){
                result = parseInt(monthC) + "个月前";
            }
            else if(weekC>=1){
                result = parseInt(weekC) + "周前";
            }
            else if(dayC>=1){
                result = parseInt(dayC) +"天前";
            }
            else if(hourC>=1){
                result = parseInt(hourC) +"个小时前";
            }
            else if(minC>=1){
                result = parseInt(minC) +"分钟前";
            }else{
                result = "刚刚";
            }
            return result;
        },
          
        /*获取评论列表*/
        getCommentList : function(){
            SmartCity.getCommentList(function( res ){
                vm.commentList = res;
                angular.forEach(vm.commentList , function( v , k ){
                    var dateStr = v.pub_time;
                    var time = Date.parse(dateStr.replace(/-/gi,"/"));
                    v.pub_time_format = vm.getDateDiff(time);
                    if(v.member_info.avatar && v.member_info.avatar.host){
                        v.member_info.picurl = v.member_info.avatar.host + (v.member_info.avatar.dir || '' ) + (v.member_info.avatar.filepath || '') + v.member_info.avatar.filename;
                    }
                });
                $scope.$apply();
            });
        },
       getMoreComment : function(){
             SmartCity.getMoreComment();
       },

        getSubsInfo : function(){
             SmartCity.getSubsInfo(function( res ){
                vm.subsInfo = res;
                 if( vm.subsInfo.indexpic && vm.subsInfo.indexpic.host ){
                    vm.subsInfo.picurl = vm.subsInfo.indexpic.host + vm.subsInfo.indexpic.dir + '110x110/' + vm.subsInfo.indexpic.filepath + vm.subsInfo.indexpic.filename;
                }
                $scope.$apply();
            });
        },
            
        /*分享*/
        share : function( type ){
            SmartCity.shareTo( type );
        },
                   
        /*关键字搜索*/
        keyWordSearch : function( keyword ){
            SmartCity.linkTo({keyword : keyword});
        },
                   
        /*订阅号跳详情*/
       getSubsciptDetail : function( id ){
            SmartCity.linkTo({subDetailId : id});
       },
        
        /*评论点赞*/
        commentZan : function( index ){
            var param = {
                   module_id : vm.commentList[index].mod_uniqueid,
                   bundle_id : vm.commentList[index].app_uniqueid,
                   id : vm.commentList[index].id,
                   content_id : vm.commentList[index].contentid,
                   cmid : vm.commentList[index].cmid
            };
            SmartCity.commentZan( param , function( res ){
                if( !res.ErrorCode ){
                    vm.commentList[index]['yizan'] = true;
                    vm.commentList[index]['useful'] = vm.commentList[index]['useful'] ? parseInt( vm.commentList[index]['useful'] ) : 0;
                    vm.commentList[index]['useful'] = vm.commentList[index]['useful'] + 1;
                }
                $scope.$apply();
            });
        },
                                                                     
        /*评论回复*/
        commentReply : function( index ){
             var param = {
                   id : vm.commentList[index].id,
                   member_id : vm.commentList[index].member_id,
                   username : vm.commentList[index].username,
                   column_id : vm.commentList[index].column_id,
                   contentid : vm.commentList[index].contentid,
                   app_uniqueid : vm.commentList[index].app_uniqueid,
                   mod_uniqueid : vm.commentList[index].mod_uniqueid,
                   content : vm.commentList[index].content
             };
             SmartCity.commentReply( param );
        },
                                                                     
        /*文稿点赞*/
        newsZan : function(){
            SmartCity.newsZan(function( res ){
                if( res.praise_num ){
                    vm.praiseInfo.yizan = true;
                    vm.praiseInfo.person_num = parseInt( vm.praiseInfo.person_num ) + 1;
                    vm.praiseInfo.person_info.push({
                        picurl : vm.userInfo.userInfo.picurl
                    })
                }
                $scope.$apply();
            });
        },
                                                                     
        digg : function( type ){
            SmartCity.digg( type , function( res ){
                if( res.mark_name ){
                    vm.diggInfo.mark_name = res.mark_name;
                    if( type == 'ding' ){
                        vm.diggInfo.up = parseInt( vm.diggInfo.up ? vm.diggInfo.up : 0 ) + 1;
                    }else{
                        vm.diggInfo.down = parseInt( vm.diggInfo.down ? vm.diggInfo.down : 0 ) + 1;
                    }
                    vm.diggInfo.upwidth = (parseInt(vm.diggInfo.up)/(parseInt(vm.diggInfo.up) + parseInt(vm.diggInfo.down)))*100 + '%';       
                }
                $scope.$apply();
            });
        },
                                                                     
        /*广告跳转*/
        adLink : function( link ){
            SmartCity.linkTo( link );
        },
                                                                     
        /*相关新闻跳转*/
        getLink : function( outlink , module_id , id, content_fromid ){
            var param = {
                   outlink : outlink,
                   module_id : module_id,
                   id : id,
                   content_fromid : content_fromid
            };
            SmartCity.linkTo( param );
        },
                   
       /** 获取广告信息 */
       getAdInfo : function() {
             SmartCity.getNewsDetailCDSPAd(function(res){
                    vm.adInfo = res;
             })
       }
                                                                     
    });
    vm.init();
}]);
