var app = new Vue({
    el:"#app",
    data:{
        newsInfo:{},
        is_subscribe:0,
        related_list:[],
        comment_list:[],
        comment_count:20,
        comment_page:1,
        hasZan:false,
        showMessage:false,
        showReply:true,
        replyShow:[],
        replyCount:5,
        praiseInfo:0,
        praiseNum:0,
        message:'',
        hasData:false,
        ifVoice:false,
    },
    mounted:function() {
        var _this = this;
        // new VConsole();
        _this._initUserInfo();
        _this._initPage();
        _this._initComment();
        _this._initRelated();
        _this._getPraiseInfo();
        _this._getSubsInfo();
        _this._initNightMode();
        // _this._initImgWidth();
    },
    methods:{
        // 关键字跳转
        goToKeywordLink(keywords) {
            SmartCity.linkTo(`search?search_text=${keywords}`)
        },
        // 打赏功能
        goReward:function() {
            SmartCity.goToReward();
        },
        // 获取更多评论
        getMoreComments:function() {
            SmartCity.getMoreComment();
        },
        // 跳转到订阅号
        toSubscribe:function(id) {
            var _this = this;
            if (_this.newsInfo.subscribe && _this.newsInfo.subscribe.site_id) {
                SmartCity.getSubsInfoOfPlus(_this.newsInfo.subscribe.site_id)
            }else{
                SmartCity.getSubsInfoOfPlus()
            }
        },
        // 订阅和取消订阅
        handleSubscribe:function(status){
            var _this = this;
            SmartCity.goSubscriptionOfPlus(status,function(res){
                _this.newsInfo.subscribe.is_subscribe = res;
            })
        },
        // 文章点赞
        newsZan:function(status) {
            var _this = this;
            if (_this.praiseInfo == 1) {
                _this.praiseInfo = 0;
                _this.praiseNum--;
            }else{
                _this.praiseInfo = 1;
                _this.praiseNum++;
            }
            var param = {
                status: status,
                praise_count: _this.praiseNum
            }
            SmartCity.goPraise(param);
        },
        // 相关新闻跳转
        getLink:function(outlink,module_id,id,content_formid,channelTag,from){
            var param = {
                outlink:outlink,
                module_id:module_id,
                id:id,
                content_formid:content_formid,
                channelTag:channelTag ? channelTag : '',
                from:from ? from : ''
            }
            SmartCity.linkTo(param)
        },
        // 评论回复操作
        handleComment:function(index) {
            var _this = this;
            var param = {
                id : _this.comment_list[index].id,
                member_id : _this.comment_list[index].member_id,
                username : _this.comment_list[index].username,
                column_id : _this.comment_list[index].column_id,
                contentid : _this.comment_list[index].contentid,
                app_uniqueid : _this.comment_list[index].app_uniqueid,
                mod_uniqueid : _this.comment_list[index].mod_uniqueid,
                content : _this.comment_list[index].content
            }
            SmartCity.commentReply(param)
        },
        // 评论点赞操作
        handleZan:function(index) {
            var _this = this;
            if(_this.comment_list[index].yizan == 0) {
                _this.comment_list[index].yizan = 1;
                _this.comment_list[index].useful++;
            }else{
                _this.comment_list[index].yizan = 0;
                _this.comment_list[index].useful--;
            }
            var param = {
                module_id : _this.comment_list[index].mod_uniqueid,
                bundle_id : _this.comment_list[index].app_uniqueid,
                id : _this.comment_list[index].id,
                content_id : _this.comment_list[index].contentid,
                cmid : _this.comment_list[index].cmid
            }
            SmartCity.commentZan(param)
        },
        // mask处理
        showMask:function(message) {
            var _this = this;
            this.message = message;
            this.showMessage = true;
            setTimeout(function() {
                _this.showMessage = false;
            },1000)
        },
        // 当数值超过1万时转换
        _numOpt:function(num) {
            if (Number(num) > 10000) {
                return (num/10000).toFixed(1) + 'w'
            }else{
                return num
            }
        },
        // 时间转换
        _getDateDiff : function( time ){
            var minute = 1000 * 60;
            var hour = minute * 60;
            var day = hour * 24;
            var halfamonth = day * 15;
            var month = day * 30;
            var now = new Date().getTime();
            var diffValue = now - time;
            if(diffValue < 0){
            //若日期不符则弹出窗口告之
                alert("结束日期不能小于开始日期！");
            }
            var monthC =diffValue/month;
            var weekC =diffValue/(7*day); 
            var dayC =diffValue/day;  
            var hourC =diffValue/hour;
            var minC =diffValue/minute;
            if(monthC>=1){
                result = parseInt(monthC) + "个月前";
            }
            else if(weekC>=1){
                result = parseInt(weekC) + "周前";
            }
            else if(dayC>=1){
                result = parseInt(dayC) +"天前";
            }
            else if(hourC>=1){
                result = parseInt(hourC) +"个小时前";
            }
            else if(minC>=1){
                result = parseInt(minC) +"分钟前";
            }else{
                result = "刚刚";
            }
            return result;
        },
        // 时间戳转换为时间
        _timeTrans:function(timestamp) {
            function trans(date) {
                if (date.toString().length == 1) {
                    return '0' + date
                }else{
                    return date
                }
            }
            if ( timestamp ) {
                var date = new Date(timestamp * 1000);//时间戳为10位需*1000，时间戳为13位的话不需乘1000
                Y = date.getFullYear() + '-';
                M = trans(date.getMonth()+1) + '-';
                D = trans(date.getDate()) + ' ';
                h = trans(date.getHours()) + ':';
                m = date.getMinutes();
                return Y + M + D + h + trans(m);
            }
        },
        // 获取订阅信息
        _getSubsInfo:function() {
            var _this = this;
            SmartCity.getSubsInfo(function(res) {
                if (res.ErrorText) {
                    return 
                }
                _this.is_subscribe = res;
            })
        },
        // 获取点赞信息
        _getPraiseInfo:function(){
            var _this = this;
            SmartCity.getMyPraise(function(res){
                _this.praiseInfo = res.status;
                _this.praiseNum = res.praise_count;
            })
        },
        // 相关推荐接口
        _initRelated:function() {
            var _this = this;
            SmartCity.getRelateNews(function(res){
                // console.log(res,'res1')
                if (res.ErrorText) {
                    return
                }
                res.forEach(function(item) {
                    item.publish_time = _this._getDateDiff(item.publish_time * 1000);
                })
                _this.related_list = res.slice(0,10);
                if (_this.newsInfo && !_this.newsInfo.iswangyi) {
                    _this.related_list.forEach(function(item) {
                        item.cssid = 2;
                    })
                }
            })
        },
        // 评论列表接口
        _initComment:function() {
            var _this = this;
            SmartCity.getCommentList(function(res){
                console.log(res,'comment')
                if (res.ErrorText) {
                    return
                }
                _this.comment_list = res;
            })
        },
        // 获取用户信息
        _initUserInfo:function(){
            var _this = this;
            SmartCity.getUserInfo(function(res){
                if (res.userInfo) {
                    _this.userInfo = res.userInfo;
                    _this.hasLogin = true;
                }
            //    console.log(_this.userInfo,'userInfo')
            })
        },
        // 是否夜间模式
        _initNightMode:function() {
            var _this = this;
            SmartCity.getNightStatus(function(res){
                if (res == 1) {
                    changeStyle("nightStyle");
                }
            })
        },
        // 初始化图片宽度
        // _initImgWidth:function(){
        //     $(".content img").each(function(index,item) {
        //         if (!$(item).hasClass('ximg') && !$(item).parent().hasClass('voice-box-img')){
        //             $(item).css({"max-width":'100% !important','height':'unset !important'})
        //         }
        //     })
        // },
        // 给图片加放大功能
        _showBigImage:function(e) {
            var e = e|| window.event;
            e.preventDefault();
            if (!this.newsInfo.iswangyi) {
                return
            }
            var target = e.target;
            if (target.tagName === "IMG" && target.className.indexOf('livmedia') == -1 && target.className.indexOf('ximg') == -1 && target.className.indexOf('play') == -1 && target.className.indexOf('medias-img') == -1 && target.parentElement.className.indexOf('voice-box-img') == -1) {
                SmartCity.showBigImage(target.src)
            }
            if (target.tagName === 'A') {
                window.location.href = target.getAttribute('href');
            }
        },
        // 正文接口
        _initPage:function() {
            var _this = this;
            if (window.newsInfo && window.newsInfo.detail) {
                _this.newsInfo = window.newsInfo.detail;
                _this.hasData = true;
            }else{
                return
            }
            console.log(_this.newsInfo,'newsInfo');
            if(_this.newsInfo.keywords) {
                _this.newsInfo.keywords = _this.newsInfo.keywords.split(',');
            }
            if(_this.newsInfo.iswangyi){
                // 获取有料点击数
                SmartCity.getClickNum(function(res){
                    if(res > 0){
                        _this.newsInfo['click_num'] = res
                    }
                })
            }
        },
        // 语音播报
        playVoice(){
            this.ifVoice = !this.ifVoice
            if(this.ifVoice){
                // 播放语音
                SmartCity.readNewsContent('0')
            }else{
                // 暂停语音
                SmartCity.readNewsContent('1')
            }
        },
    }
})
