#!/bin/sh
function printScriptDesc() {
	echo 该脚本的作用是 -- 打当前工程最新版本号的预埋包
    echo "说明:\n\t1.将该脚本拖拽到待打包工程的src目录下\n\t2.执行该脚本\n\t3.第一次执行该脚本的时候可能会要求安装jq，时间稍长，之后秒打\n\t4.cookie可能会过期，两天后该脚本可能会失效，这个问题待修复\n"
    originPath=${PWD}
}
function getBid() {
	source pubconfig
    echo "你要打哪个平台的预埋包：\n\t1.iOS\n\t2.Android"
	read selected_platform
    if [[ $selected_platform == 1 ]]; then
		BID=$IOSBID 
	elif [[ $selected_platform == 2 ]]; then
		BID=$ANDROIDBID
	else
		echo 输入错误
		getBid
	fi
}
function checkJqInstalled() {
    echo 处理数据需要使用第三方工具jq，正在检测是否已安装jq...
    jq
    if [[ $? == 127 ]]; then
        echo 未安装jq
        installJq
    else
        echo 已安装jq
    fi
}
function installJq() {
    echo 正在安装jq
    brew install jq
    echo 已安装jq
}
function getData() {
    echo 正在获取数据...
    curl --cookie "Hm_lvt_96a25bfd79bc4377847ba1e9d5dfbe8a=1547807415; _ga=GA1.2.887987138.1547807619; _gid=GA1.2.1242447863.1548642279; feploginid=8nC2J32o6cV7Q7rXerpsr5yVnZAUoVpE; feploginid.sig=aS1NVEY6Gq_n2USZlhBhxJ-MI68; io=KJqFw0qv0zpoX-tMACWA" "https://fep.wemomo.com/api/v1/fep/project/getProjectVersions?publishEnv=1&bid=$BID" > data
    zipUrl=`jq '.data[0].list[0].defaultZipUrl' data | sed 's/\"//g'`
    zipVersion=`jq '.data[0].list[0].versionStr' data | sed 's/\"//g'`
    echo zipUrl
    filename=${BID}-${zipVersion}.zip
    rm data #删除data
    echo 数据获取完毕，zip的下载地址是：--${zipUrl}\n压缩文件的名称为：${filename}
}
function download() {
    echo 开始下载字节码文件...
    cd ~/Downloads
    echo $zipUrl
    curl -O $zipUrl
    echo 字节码文件已经下载完毕
    cd -
}
function processingZip() {
    cd ~/Downloads
    echo 开始解压下载的压缩文件...
    unzip -o ${filename} -d ${BID}-${zipVersion}/
    echo 解压完毕
    echo 删除下载的压缩文件
    rm -rf ${filename}
    echo 开始制作预埋包
    targetFilePath=`find ${BID}-${zipVersion} -name sources`
    cd ${targetFilePath}
    read -p "给这个预埋包起一个名字：" pre_build_name
    zip -r ~/Downloads/${pre_build_name}.zip .
    echo 制作完成
    echo 删除无用文件
    echo ${BID}-${zipVersion}
    rm -rf ~/Downloads/${BID}-${zipVersion}
    cd $originPath
    echo 删除完毕
    open -R ~/Downloads/${pre_build_name}.zip
}
printScriptDesc
getBid
checkJqInstalled
getData
download
processingZip
