local DescriptionTopicCell = {}
DescriptionTopicCell.baseView = nil
DescriptionTopicCell.container = nil
DescriptionTopicCell.icon = nil
DescriptionTopicCell.desLb = nil
DescriptionTopicCell.img = nil
DescriptionTopicCell.item = nil
function DescriptionTopicCell:new()
    local obj = {}
    setmetatable(obj,self)
    self.__index = self
    return obj
end
function DescriptionTopicCell:init(cell)
    self.baseView = View()
    self.baseView:width(MeasurementType.MATCH_PARENT):height(88):marginLeft(15):marginRight(15)
    cell.contentView:addView(self.baseView)
    self:setupUI()
end
function DescriptionTopicCell:setupUI()
    self.container = View()
    self.container:width(MeasurementType.MATCH_PARENT):height(68)
    self.container:setGravity(Gravity.BOTTOM)
    self.container:borderColor(Color(197,162,92,0.37))
    self.container:borderWidth(1)
    self.container:cornerRadius(2)
    self.baseView:addView(self.container)
    self.icon = ImageView()
    self.icon:width(24):height(37.5):marginLeft(15)
    self.icon:image('https://s.momocdn.com/w/u/others/2019/01/19/1547890442156-Topic_Description_Flag.png')
    self.container:addView(self.icon)
    self.desLb = Label()
    self.desLb:marginLeft(55):marginRight(35):marginTop(14):marginBottom(14)
    self.desLb:lines(2)
    self.desLb:fontSize(14)
    self.desLb:setLineSpacing(8)
    self.desLb:textColor(Color():hex(0xaaaaaa))
    self.container:addView(self.desLb)
    self.img = ImageView()
    self.img:lazyLoad(false)
    self.img:setGravity(Gravity.RIGHT + Gravity.BOTTOM)
    self.img:marginRight(15):marginBottom(19):width(14):height(10)
    self.img:image('http://s.momocdn.com/w/u/others/2019/01/30/1548817001409-float_symbol.png')
    self.container:addView(self.img)
end
function DescriptionTopicCell:updateData(item)
    if not item then
        return
    end
    self.item = item
    local des = item:get('des')
    if not emptyString(des) then
        self.desLb:text(des)
    end
end
function emptyString(aString)
    return (not aString) or (#aString == 0)
end
return DescriptionTopicCell
