local HeaderTopicCell = {}
HeaderTopicCell.baseView = nil
HeaderTopicCell.header = nil
function HeaderTopicCell:new()
    local obj = {}
    setmetatable(obj,self)
    self.__index = self
    return obj
end
function HeaderTopicCell:init(cell)
    self.baseView = View()
    self.baseView:width(MeasurementType.MATCH_PARENT):height(150):marginLeft(15):marginRight(15)
    cell.contentView:addView(self.baseView)
    self:setupUI()
end
function HeaderTopicCell:setupUI()
    self.header = ImageView()
    self.header:contentMode(ContentMode.SCALE_ASPECT_FILL)
    self.header:lazyLoad(false)
    self.header:width(MeasurementType.MATCH_PARENT):height(MeasurementType.MATCH_PARENT)
    self.header:cornerRadius(2)
    self.baseView:addView(self.header)
end
function HeaderTopicCell:updateData(item)
    if not item then
        return
    end
    self.item = item
    local url = item:get('url')
    if not emptyString(url) then
        self.header:image(url)
    end
end
function emptyString(aString)
    return (not aString) or (#aString == 0)
end
return HeaderTopicCell
