local NormalTopicCell = {}
NormalTopicCell.baseView = nil
NormalTopicCell.icon = nil
NormalTopicCell.shadow = nil
NormalTopicCell.v_ctn = nil
NormalTopicCell.titleLb = nil
NormalTopicCell.descriptionLb = nil
NormalTopicCell.h_ctn = nil
NormalTopicCell.authorLb = nil
NormalTopicCell.addBtn = nil
NormalTopicCell.addBtnAction = nil
NormalTopicCell.item = nil
function NormalTopicCell:new()
    local obj = {}
    setmetatable(obj,self)
    self.__index = self
    return obj
end
function NormalTopicCell:init(cell)
    self.baseView = View()
    self.baseView:width(MeasurementType.MATCH_PARENT):height(138):marginLeft(15):marginRight(15)
    cell.contentView:addView(self.baseView)
    self:setupUI()
end
function NormalTopicCell:setupUI()
    self.icon = ImageView()
    self.icon:width(90):height(118):marginTop(20)
    self.icon:contentMode(ContentMode.SCALE_ASPECT_FILL)
    self.icon:lazyLoad(false)
    self.icon:cornerRadius(2)
    self.baseView:addView(self.icon)
    self.shadow = View()
    self.shadow:setGradientColor(Color():hex(0x6c6c6c),Color(58,58,58,0),false)
    self.shadow:width(4):height(118):marginTop(20)
    self.shadow:alpha(0.2)
    self.baseView:addView(self.shadow)
    self.v_ctn = LinearLayout(LinearType.VERTICAL)
    self.v_ctn:width(MeasurementType.MATCH_PARENT):height(118):marginLeft(104):marginTop(20)
    self.baseView:addView(self.v_ctn)
    self.titleLb = Label()
    self.titleLb:marginTop(3.5)
    self.titleLb:fontSize(16)
    self.titleLb:textColor(Color():hex(0x323333))
    self.v_ctn:addView(self.titleLb)
    self.descriptionLb = Label()
    self.descriptionLb:marginTop(4)
    self.descriptionLb:setLineSpacing(8)
    self.descriptionLb:lines(2)
    self.descriptionLb:fontSize(13)
    self.descriptionLb:textColor(Color():hex(0xaaaaaa))
    self.v_ctn:addView(self.descriptionLb)
    self.h_ctn = View()
    self.h_ctn:width(MeasurementType.MATCH_PARENT):height(25):marginTop(21)
    self.v_ctn:addView(self.h_ctn)
    self.authorLb = Label()
    self.authorLb:fontSize(12)
    self.authorLb:textColor(Color():hex(0x575757)):marginRight(83)
    self.authorLb:setGravity(Gravity.CENTER_VERTICAL)
    self.h_ctn:addView(self.authorLb)
    self.addBtn = Label()
    self.addBtn:fontSize(12)
    self.addBtn:textColor(Color():hex(MRPattern:themeTextColor()))
    self.addBtn:width(73):height(25):marginRight(7)
    self.addBtn:setGravity(Gravity.RIGHT)
    self.addBtn:borderWidth(1)
    self.addBtn:borderColor(Color():hex(MRPattern:themeTextColor()))
    self.addBtn:text('加入书架')
    self.addBtn:cornerRadius(12.5)
    self.addBtn:textAlign(TextAlign.CENTER)
    self.addBtn:onClick(function ()
        if self.addBtnAction then
            self.addBtnAction(self.item,self)
        end
    end)
    self.h_ctn:addView(self.addBtn)
end
function NormalTopicCell:updateData(item)
    if not item then
        return
    end
    self.item = item
    local title = item:get('book_name')
    if not emptyString(title) then
        self.titleLb:text(title)
    end
    local des = item:get('book_desc')
    if not emptyString(des) then
        self.descriptionLb:text(des)
    end
    local author = item:get('author')
    if not emptyString(author) then
        self.authorLb:text('作者：'..author)
    end
    local url = item:get('cover_pic')
    if not emptyString(url) then
        self.icon:image(url)
    end
    local add = item:get('is_cart')
    if add then
        self.addBtn:text('开始阅读')
    else
        self.addBtn:text('加入书架')
    end
end
function NormalTopicCell:setAdded()
    self.addBtn:text('开始阅读')
    self.item:put('is_cart',true)
end
function emptyString(aString)
    return (not aString) or (#aString == 0)
end
return NormalTopicCell
