TYPE_CELL = {
    HEADER = 'TYPE_CELL_HEADER',
    DESCRIPTION = 'TYPE_CELL_DESCRIPTION',
    NORMAL = 'TYPE_CELL_NORMAL',
    BADNET = 'TYPE_CELL_BAD_NET',
    OFFLINE = 'TYPE_CELL_OFFLINE',
}
local TopicAdapter = {}
TopicAdapter.adapter = nil
TopicAdapter.dataSource = nil
TopicAdapter.header = ''
TopicAdapter.description = ''
TopicAdapter.cellAction = nil
TopicAdapter.addAction = nil
TopicAdapter.badNet = false
TopicAdapter.tabV_h = 0
TopicAdapter.badNetAction = nil
TopicAdapter.offline = false
TopicAdapter.fixNum = 0
function TopicAdapter:new()
    local obj = {}
    setmetatable(obj,self)
    self.__index = self
    return obj
end
function TopicAdapter:init()
    self:initAdapter()
end
function TopicAdapter:initAdapter()
    local adapter = TableViewAutoFitAdapter()
    adapter:reuseId(function (section,row)
        if self.badNet then
            return TYPE_CELL.BADNET
        end
        if self.offline then
            return TYPE_CELL.OFFLINE
        end
        if row > 2 then
             return TYPE_CELL.NORMAL
        end
        local item = self.dataSource:get(row)
        if item:get('is_header') then
            return TYPE_CELL.HEADER
        end
        if item:get('is_description') then
            return TYPE_CELL.DESCRIPTION
        end
        return TYPE_CELL.NORMAL
    end)
    adapter:rowCount(function(section)
        if self.badNet then
            return 1
        end
        if self.offline then
            return 1
        end
        if not self.dataSource then
            return 0
        end
        return self.dataSource:size()
    end)
    adapter:initCellByReuseId(TYPE_CELL.NORMAL,function (cell)
        local NormalTopicCell = require('NormalTopicCell')
        local nC = NormalTopicCell:new()
        nC:init(cell)
        cell.currentCell = nC
    end)
    adapter:initCellByReuseId(TYPE_CELL.DESCRIPTION,function (cell)
        local DescriptionTopicCell = require('DescriptionTopicCell')
        local dC = DescriptionTopicCell:new()
        dC:init(cell)
        cell.currentCell = dC
    end)
    adapter:initCellByReuseId(TYPE_CELL.HEADER,function (cell)
        local HeaderTopicCell = require('HeaderTopicCell')
        local hC = HeaderTopicCell:new()
        hC:init(cell)
        cell.currentCell = hC
    end)
    adapter:initCellByReuseId(TYPE_CELL.BADNET,function (cell)
        local BadNetCell = require('NoNetCell')
        BadNetCell:onCreate(cell,self.tabV_h)
    end)
    adapter:initCellByReuseId(TYPE_CELL.OFFLINE,function (cell)
        local OfflineCell = require('OfflineCell')
        OfflineCell:onCreate(cell,self.tabV_h)
    end)
    adapter:fillCellDataByReuseId(TYPE_CELL.NORMAL,function (cell,section,row)
        local item = self.dataSource:get(row)
        local c = cell.currentCell
        c.addBtnAction = function(item,cell)
            if self.addAction then
                self.addAction(item,cell,row - self.fixNum)
            end
        end
        c:updateData(item)
    end)
    adapter:fillCellDataByReuseId(TYPE_CELL.DESCRIPTION,function (cell,section,row)
        local item = self.dataSource:get(row)
        local c = cell.currentCell
        c:updateData(item)
    end)
    adapter:fillCellDataByReuseId(TYPE_CELL.HEADER,function (cell,section,row)
        local item = self.dataSource:get(row)
        local c = cell.currentCell
        c:updateData(item)
    end)
    adapter:selectedRowByReuseId(TYPE_CELL.NORMAL,function (cell,section,row)
        local item = self.dataSource:get(row)
        if item and self.cellAction then
            self.cellAction(item)
        end
    end)
    adapter:selectedRowByReuseId(TYPE_CELL.BADNET,function (cell,section,row)
        if self.badNet and self.badNetAction then
            self.badNetAction(cell,section,row,TYPE_CELL.BADNET)
        end
    end)
    self.adapter = adapter
end
function emptyString(aString)
    return (not aString) or (#aString == 0)
end
return TopicAdapter
