view_life_ctn = {}
local extraInfo = window:getExtra()
local topic_id = '13'
if extraInfo then
    topic_id = extraInfo:get('topic_id') or '1'
end
local s_w = window:width()
local s_h = window:height()
local current_page = 1
local requesting = false
local marginTop = MRSystemUtils:getActionBarHeight()
local tabV = TableView()
tabV:width(MeasurementType.MATCH_PARENT):height(MeasurementType.MATCH_PARENT):marginTop(marginTop)
tabV:setRefreshingCallback(function ()
    refresh()
end)
tabV:setLoadingCallback(function ()
    loadData()
end)
view_life_ctn.tabV = tabV
window:addView(tabV)
window:viewAppear(function ()
    MRSystemUtils:saveSPValues('key_last_page','topic')
end)
local Adapter = require('TopicAdapter')
local adapter = Adapter:new()
adapter:init()
adapter.tabV_h = s_h
adapter.cellAction = function(item)
    local book_id = item:get('book_id')
    if not emptyString(book_id) then
        gotoNextPageWithType('goto://BookDetail_Page_Protocol?book_id='..book_id..'&translucent=1')
    end
end
adapter.addAction = function(item,cell,row)
    debug_n('current_row = ',row)
    local book_id = item:get('book_id')
    if not emptyString(book_id) then
        local add = item:get('is_cart')
        if add then
            local params = Map()
            params:put('topic_id',topic_id)
            params:put('id',book_id)
            Log('navitopicContent',params)
            gotoNextPageWithType('goto://Reader_Page_Protocol?book_id='..book_id..'&sourceCtrl=topic&position='..tostring(row))
        else
            addBookShelf(book_id,function (success,res,error)
                if success then
                    local em = res:get('em')
                    Toast((res:get('em') or '添加成功'),1)
                    cell:setAdded()
                    local params = Map()
                    params:put('topic_id',topic_id)
                    params:put('id',book_id)
                    Log('navitopicShelf',params)
                    postNotice('NOTIFICATION_SHELF_NEED_REFRESH')
                else
                    Toast((error:get('errorMsg') or '网络错误'),1)
                end
            end)
        end
    end
end
adapter.badNetAction = function()
    refresh()
end
tabV:adapter(adapter.adapter)
view_life_ctn.adapter = adapter
local dataSource = Array()
view_life_ctn.dataSource = dataSource
adapter.dataSource = dataSource
function loadPage(page,refresh)
    if requesting then
        return
    end
    requesting = true
    local params = Map()
    params:put('topic_id',topic_id)
    params:put('page',page)
    Http():get('/book/topic',params,function (success,res,error)
        debug_i('res = ',res)
        debug_e('error = ',error)
        requesting = false
        if refresh then
            tabV:stopRefreshing()
        else
            tabV:stopLoading()
        end
        local has_data = (dataSource:size() ~= 0)
        if not success then
            Toast((error:get('errorMsg') or '网络错误'),1)
            if not has_data then
                dataSource:removeAll()
                currentPage = 1
                adapter.badNet = true
                tabV:loadEnable(false)
                tabV:refreshEnable(false)
                tabV:reloadData()
            end
            return
        end
        local data = res:get('data')
        if not data then
            Toast((error:get('errorMsg') or '网络错误'),1)
            if not has_data then
                dataSource:removeAll()
                currentPage = 1
                adapter.badNet = true
                tabV:loadEnable(false)
                tabV:refreshEnable(false)
                tabV:reloadData()
            end
            return
        end
        adapter.badNet = false
        local loadEnable = false
        if refresh then
            dataSource:removeAll()
            local topic = data:get('topic')
            debug_i('topci = ',topic)
            if topic then
                local status = topic:get('topic_status')
                if tostring(status) ~= '1' then
                    adapter.offline = true
                    tabV:loadEnable(false)
                    tabV:refreshEnable(false)
                    tabV:reloadData()
                    return
                end
                adapter.offline = false
                loadEnable = true
                local topic_pic = topic:get('topic_pic')
                debug_i('topic_url',topic_pic)
                if not emptyString(topic_pic) then
                    local header = Map()
                    header:put('is_header',true)
                    header:put('url',topic_pic)
                    dataSource:add(header)
                end
                local editor_recommend = topic:get('editor_recommend')
                if not emptyString(editor_recommend) then
                    local des = Map()
                    des:put('is_description',true)
                    des:put('des',editor_recommend)
                    dataSource:add(des)
                end
            end
            adapter.fixNum = dataSource:size()
        end
        local book_data = data:get('book_data')
        debug_i('book_data = ',book_data)
        if book_data then
            loadEnable = book_data:get('has_more') or false
            if loadEnable then
                current_page = current_page + 1
            end
            local data = book_data:get('data')
            if data then
                dataSource:addAll(data)
            end
        else
            loadEnable = false
        end
        tabV:loadEnable(true)
        if loadEnable then
            tabV:resetLoading()
        else
            tabV:noMoreData()
        end
        tabV:refreshEnable(true)
        tabV:reloadData()
    end)
end
function addBookShelf(book_id,completion)
    local params = Map()
    params:put('book_id',book_id)
    Http():post('/book/cart/add',params,function (success,res,error)
        if completion then
            completion(success,res,error)
        end
    end)
end
function emptyString(aString)
    return (not aString) or (#aString == 0)
end
function refresh ()
    current_page = 1
    loadPage(current_page,true)
end
function loadData()
    loadPage(current_page,false)
end
function postNotice(name)
    local params = Map()
    params:put('l_evn',Locales.LUA)
    params:put('dst_l_evn',MBit:bor(Locales.NATIVE,Locales.LUA))
    GlobalEvent:postEvent(name,params)
end
function Log(event,params)
    if not params then
        params = Map()
    end
    params:put('event',event)
    MRLogTool:log(params)
end
tabV:startRefreshing()
function gotoNextPageWithType(gotoString)
    local traceKey = 'source_topic_page'
    local currentTraceMap = Map()
    currentTraceMap:put('source', traceKey)
    local traceJSON = createTraceMapJSON(currentTraceMap)
    gotoString = gotoString..'&trace='..traceJSON
    Navigator:gotoPage(gotoString)
end
function getPreviousTraceList()
    local traceJson = window:getExtra():get'trace' or ''
    local traceMap = StringUtil:jsonToMap(traceJson)
    debug_n('extra = ',window:getExtra())
    debug_n('json = ',traceJson)
    debug_n('map = ',traceMap)
    if not TypeUtils:isMap(traceMap) or traceMap:size() == 0 then
        return Array();
    end
    local traceList = traceMap:get'traceList'
    if not TypeUtils:isArray(traceList) or traceList:size() == 0 then
        return Array();
    end
    return Array():addAll(traceList); --copy一个新的
end
function createTraceMapJSON(currentTraceMap)
    local traceList = getPreviousTraceList()
    traceList:add(currentTraceMap)
    local traceMap = Map()
    traceMap:put('traceList', traceList)
    local traceJSON = StringUtil:mapToJSON(traceMap)
    return traceJSON
end
function debug_n(...)
    print(...)
end
function debug_i(...)
    print(...)
end
function debug_w(...)
    print(...)
end
function debug_e(...)
    print(...)
end
