DebugLoggerFilter = {
    Ignore = 0,
    Normal = 1 ,
    Info = 2,
    Warning = 4,
    Error = 8,
    All = 15
}
local DebugLogger_luaCore = {}
DebugLogger_luaCore.windowCtn = nil
DebugLogger_luaCore.listCtn = nil
DebugLogger_luaCore.searchCtn = nil
DebugLogger_luaCore.searchTxtCtn = nil
DebugLogger_luaCore.searchTxt = nil
DebugLogger_luaCore.resultCntLb = nil
DebugLogger_luaCore.preBtn = nil
DebugLogger_luaCore.nextBtn = nil
DebugLogger_luaCore.searchBtn = nil
DebugLogger_luaCore.searchResult = {}
DebugLogger_luaCore.listView = nil
DebugLogger_luaCore.adapter = nil
DebugLogger_luaCore.btnContainer = nil
DebugLogger_luaCore.logLevelCtn = nil
DebugLogger_luaCore.openBtn = nil
DebugLogger_luaCore.listBtn = nil
DebugLogger_luaCore.clearBtn = nil
DebugLogger_luaCore.logLevelBtn = nil
DebugLogger_luaCore.normalLvBtn = nil
DebugLogger_luaCore.infoLvBtn = nil
DebugLogger_luaCore.warningLvBtn = nil
DebugLogger_luaCore.errorLvBtn = nil
DebugLogger_luaCore.needReload = false
DebugLogger_luaCore.menuOpened = false
DebugLogger_luaCore.listShowing = false
DebugLogger_luaCore.levelShowing = false
DebugLogger_luaCore.logLevel = DebugLoggerFilter.All
DebugLogger_luaCore.oriLogLevel = DebugLoggerFilter.All
local btn_w = 44
local btn_m = 3
local nor_m = 5
function DebugLogger_luaCore:showInWindow(window)
    return self:new():initWithWindow(window)
end
function DebugLogger_luaCore:debug_n(str)
    self:debug_type(str,DebugLoggerFilter.Normal)
end
function DebugLogger_luaCore:debug_i(str)
    self:debug_type(str,DebugLoggerFilter.Info)
end
function DebugLogger_luaCore:debug_w(str)
    self:debug_type(str,DebugLoggerFilter.Warning)
end
function DebugLogger_luaCore:debug_e(str)
    self:debug_type(str,DebugLoggerFilter.Error)
end
function DebugLogger_luaCore:new()
    local obj = {}
    setmetatable(obj,self)
    self.__index = self
    return obj
end
function DebugLogger_luaCore:initWithWindow(window)
    self:setupUI(window)
    window:sizeChanged(function (x,y)
        window:layoutIfNeeded()
    end)
    return self
end
function DebugLogger_luaCore:setupUI(window)
    local status_h = System:iOS() and window:statusBarHeight() or 0
    local nav_h = window:navBarHeight() or 0
    local home_h = window:homeBarHeight() or 0
    local tab_h = window:tabBarHeight() or 0
    self.listCtn = LinearLayout(LinearType.VERTICAL)
    self.listCtn:width(MeasurementType.MATCH_PARENT):height(MeasurementType.MATCH_PARENT):marginTop(nav_h + status_h):marginBottom(tab_h + home_h)
    self.listCtn:bgColor(Color(0,0,0,0.7))
    self.listCtn:alpha(0)
    self.listCtn:hidden(true)
    window:addView(self.listCtn)
    self.btnContainer = LinearLayout(LinearType.HORIZONTAL)
    self.btnContainer:bgColor(Color(0,0,0,1))
    self.btnContainer:setGravity(Gravity.BOTTOM)
    self.btnContainer:width(MeasurementType.WRAP_CONTENT):height(MeasurementType.WRAP_CONTENT)
    self.btnContainer:marginBottom(30 + tab_h + home_h):marginLeft(5)
    self.btnContainer:cornerRadius(btn_w * 0.5 + btn_m)
    window:addView(self.btnContainer)
    self.logLevelCtn = LinearLayout(LinearType.VERTICAL)
    self.logLevelCtn:setGravity(Gravity.BOTTOM)
    self.logLevelCtn:width(MeasurementType.WRAP_CONTENT):height(MeasurementType.WRAP_CONTENT):marginLeft(120):marginBottom(30 + tab_h + home_h + btn_w + btn_m * 3)
    self.logLevelCtn:cornerRadius(5)
    self.logLevelCtn:bgColor(Color(255,255,255,1))
    self.logLevelCtn:borderWidth(1)
    self.logLevelCtn:borderColor(Color(0,0,0,1))
    self.logLevelCtn:hidden(true)
    window:addView(self.logLevelCtn)
    self.searchCtn = LinearLayout(LinearType.HORIZONTAL)
    self.searchCtn:width(MeasurementType.MATCH_PARENT):height(MeasurementType.WRAP_CONTENT)
    self.listCtn:addView(self.searchCtn)
    self.searchCtn:bgColor(Color():hex(0xdedede))
    local search_h = 30
    self.searchTxtCtn = LinearLayout(LinearType.HORIZONTAL)
    self.searchTxtCtn:width(MeasurementType.MATCH_PARENT):height(MeasurementType.WRAP_CONTENT):marginLeft(nor_m):marginRight(nor_m):marginTop(nor_m):marginBottom(nor_m)
    self.searchTxtCtn:cornerRadius(search_h * 0.5)
    self.searchTxtCtn:bgColor(Color(255,255,255,1))
    self.searchCtn:addView(self.searchTxtCtn)
    self.searchTxt = EditTextView()
    self.searchTxt:width(MeasurementType.MATCH_PARENT):height(20):marginLeft(10):marginRight(10):marginTop(nor_m):marginBottom(nor_m):setGravity(Gravity.CENTER_VERTICAL)
    self.searchTxtCtn:addView(self.searchTxt)
    self.resultCntLb = Label()
    self.resultCntLb:width(MeasurementType.WRAP_CONTENT):height(20):marginRight(10):setGravity(Gravity.CENTER_VERTICAL):priority(1)
    self.searchTxtCtn:addView(self.resultCntLb)
    self.resultCntLb:textColor(Color():hex(0xdedede))
    self.preBtn = Label()
    self.preBtn:textAlign(TextAlign.CENTER)
    self.preBtn:width(40):height(20 + nor_m * 2):marginTop(nor_m):marginBottom(nor_m):priority(1)
    self.preBtn:text('<')
    self.preBtn:bgColor(Color(255,255,255,1))
    self.preBtn:setCornerRadiusWithDirection(10 + nor_m,RectCorner.TOP_LEFT + RectCorner.BOTTOM_LEFT)
    self.preBtn:borderWidth(1)
    self.preBtn:borderColor(Color(0,0,0,1))
    self.searchCtn:addView(self.preBtn)
    self.preBtn:onClick(function()
        self:preBtnAction()
    end)
    self.nextBtn = Label()
    self.nextBtn:textAlign(TextAlign.CENTER)
    self.nextBtn:width(40):height(20 + nor_m * 2):marginRight(nor_m):marginTop(nor_m):marginBottom(nor_m):priority(1)
    self.nextBtn:text('>')
    self.nextBtn:bgColor(Color(255,255,255,1))
    self.nextBtn:setCornerRadiusWithDirection(10 + nor_m,RectCorner.TOP_RIGHT + RectCorner.BOTTOM_RIGHT)
    self.nextBtn:borderWidth(1)
    self.nextBtn:borderColor(Color(0,0,0,1))
    self.searchCtn:addView(self.nextBtn)
    self.nextBtn:onClick(function ()
        self:nextBtnAction()
    end)
    self.searchBtn = Label()
    self.searchBtn:textAlign(TextAlign.CENTER)
    self.searchBtn:width(40):height(20 + nor_m * 2):marginRight(nor_m):marginTop(nor_m):marginBottom(nor_m):priority(1)
    self.searchBtn:text('搜索')
    self.searchBtn:bgColor(Color(255,255,255,1))
    self.searchBtn:cornerRadius(10 + nor_m)
    self.searchBtn:borderWidth(1)
    self.searchBtn:borderColor(Color(0,0,0,1))
    self.searchCtn:addView(self.searchBtn)
    self.searchBtn:onClick(function ()
        self:searchAction()
    end)
    local Adapter = require('lua_pods.DebugLogger.DebugLogger_luaCore_adapter')
    self.adapter = Adapter:new()
    self.adapter:init()
    self.adapter.datasource = {}
    self.listView = TableView(false,false)
    self.listView:width(MeasurementType.MATCH_PARENT):height(MeasurementType.MATCH_PARENT)
    self.listView:adapter(self.adapter.adapter)
    self.listCtn:addView(self.listView)
    self.openBtn = ImageView()
    self.openBtn = normalBtn('https://s.momocdn.com/w/u/others/2019/02/21/1550755315840-open.png')
    self.openBtn:marginLeft(btn_m)
    self.btnContainer:addView(self.openBtn)
    self.openBtn:onClick(function ()
        self:changeMenuStatus(not self.menuOpened)
    end)
    self.listBtn = normalBtn('https://s.momocdn.com/w/u/others/2019/03/15/1552629720236-invisible.png')
    self.listBtn:onClick(function ()
        self:changeListStatus(not self.listShowing)
    end)
    self.clearBtn = normalBtn('https://s.momocdn.com/w/u/others/2019/03/16/1552736721827-clear.png')
    self.clearBtn:onClick(function ()
        self.searchTxt:text('')
        if #self.adapter:dataSource() > 0 then
            self:resetSearch()
            self.adapter.filteredDatasource = {}
            self.adapter.datasource = {}
            self:handleNeedReload()
        end
    end)
    self.logLevelBtn = normalBtn('https://s.momocdn.com/w/u/others/2019/03/20/1553068200289-log.png')
    self.logLevelBtn:onClick(function ()
        self:logLevelBtnAction(not self.levelShowing)
    end)
end
function DebugLogger_luaCore:changeMenuStatus(open)
    self.menuOpened = open
    if open then
        self.btnContainer:addView(self.listBtn)
        self.btnContainer:addView(self.clearBtn)
        self.btnContainer:addView(self.logLevelBtn)
        self.openBtn:image('https://s.momocdn.com/w/u/others/2019/02/21/1550756308100-stop.png')
    else
        self.listBtn:removeFromSuper()
        self.clearBtn:removeFromSuper()
        self.logLevelBtn:removeFromSuper()
        self.openBtn:image('https://s.momocdn.com/w/u/others/2019/02/21/1550755315840-open.png')
    end
end
function DebugLogger_luaCore:changeListStatus(show)
    self.listShowing = show
    if show then
        self.listBtn:image('https://s.momocdn.com/w/u/others/2019/03/15/1552629991424-visible.png')
        local showAni = Animation()
        showAni:setAlpha(0,1)
        showAni:setAutoBack(false)
        showAni:setStartCallback(function ()
            self.listCtn:hidden(false)
        end)
        showAni:setEndCallback(function ()
            self.listCtn:alpha(1)
        end)
        showAni:start(self.listCtn)
        if self.needReload then
            self.needReload = false
            self.listView:reloadData()
            if #self.adapter:dataSource() > 0 then
                self.listView:scrollToCell(#self.adapter:dataSource(),1,false)
            end
        end
    else
        self.listBtn:image('https://s.momocdn.com/w/u/others/2019/03/15/1552629720236-invisible.png')
        local hideAni = Animation()
        hideAni:setAlpha(1,0)
        hideAni:setAutoBack(false)
        hideAni:setEndCallback(function()
            self.listCtn:alpha(0)
            self.listCtn:hidden(true)
        end)
        hideAni:start(self.listCtn)
    end
end
function DebugLogger_luaCore:logLevelBtnAction(show)
    self.levelShowing = show
    if show then
        self.logLevelBtn:image('https://s.momocdn.com/w/u/others/2019/03/20/1553068395522-close.png')
        if not self.normalLvBtn then
            self.normalLvBtn = self:normalLevelBtn('Normal',DebugLoggerFilter.Normal)
        end
        if not self.infoLvBtn then
            self.infoLvBtn = self:normalLevelBtn('Info',DebugLoggerFilter.Info)
        end
        if not self.warningLvBtn then
            self.warningLvBtn = self:normalLevelBtn('Warning',DebugLoggerFilter.Warning)
        end
        if not self.errorLvBtn then
            self.errorLvBtn = self:normalLevelBtn('Error',DebugLoggerFilter.Error)
            self.errorLvBtn.baseView:marginBottom(btn_m)
        end
        self.logLevelCtn:addView(self.normalLvBtn.baseView)
        self.logLevelCtn:addView(self.infoLvBtn.baseView)
        self.logLevelCtn:addView(self.warningLvBtn.baseView)
        self.logLevelCtn:addView(self.errorLvBtn.baseView)
        self.logLevelCtn:hidden(false)
    else
        self.logLevelBtn:image('https://s.momocdn.com/w/u/others/2019/03/20/1553068200289-log.png')
        self:handleFilter()
        self.logLevelCtn:hidden(true)
        self.normalLvBtn.baseView:removeFromSuper()
        self.infoLvBtn.baseView:removeFromSuper()
        self.warningLvBtn.baseView:removeFromSuper()
        self.errorLvBtn.baseView:removeFromSuper()
    end
end
function DebugLogger_luaCore:searchAction()
    self.adapter:changeHighlightIndex(0)
    if emptyString(self.searchTxt:text()) then
        self.listView:reloadData()
        self.resultCntLb:text('')
        return
    end
    self.adapter:changeHighlightIndex(0)
    ret = searchArr(self.adapter:dataSource(),function (obj,idx)
        local log = obj['log']
        return string.find(log,self.searchTxt:text())
    end)
    self.adapter.highlighted = ret
    self.resultCntLb:text(tostring(#ret))
    if #ret > 0 then
        self:showHighlight(1)
    else
        self.listView:reloadData()
    end
end
function DebugLogger_luaCore:preBtnAction()
    if self.adapter.currentHighlightedIdx == 0 then
        return
    end
    local idx = self.adapter.currentHighlightedIdx
    idx = idx - 1
    if idx < 1 then
        idx = #self.adapter.highlighted
    end
    self:showHighlight(idx)
end
function DebugLogger_luaCore:nextBtnAction()
    if self.adapter.currentHighlightedIdx == 0 then
        return
    end
    local idx = self.adapter.currentHighlightedIdx
    idx = idx + 1
    if idx > #self.adapter.highlighted then
        idx = 1
    end
    self:showHighlight(idx)
end
function DebugLogger_luaCore:resetSearch()
    self.adapter:changeHighlightIndex(0)
    self.resultCntLb:text('')
    self.searchTxt:text('')
end
function DebugLogger_luaCore:showHighlight(idx)
    self.adapter:changeHighlightIndex(idx)
    if self.adapter.currentHighlighted > 0 then
        self.listView:scrollToCell(self.adapter.currentHighlighted,1,true)
    end
    self.listView:reloadData()
end
function DebugLogger_luaCore:handleFilter()
    if self.oriLogLevel ~= self.logLevel then
        self:resetSearch()
        self.oriLogLevel = self.logLevel
        if self.logLevel == DebugLoggerFilter.All then
            self.adapter.filterMode = false
            self.adapter.filteredDatasource = {}
        else
            self.adapter.filterMode = true
            self.adapter.filteredDatasource = filterArr(self.adapter.datasource,function (obj,idx)
                local type = obj['type']
                return bitAnd(self.logLevel,type)
            end)
        end
        self.listView:reloadData()
    end
end
function DebugLogger_luaCore:debug_type(str,type)
    if emptyString(str) then
        return
    end
    print(str)
    local msg = {}
    msg['type'] = type
    msg['log'] = str
    table.insert(self.adapter.datasource, msg)
    if self.adapter.filterMode and bitAnd(self.logLevel,type) then
        table.insert(self.adapter.filteredDatasource, msg)
    end
    self:handleNeedReload()
end
function DebugLogger_luaCore:handleNeedReload ()
    if not self.listShowing then
        self.needReload = true
    else
        self.listView:reloadData()
        if #self.adapter:dataSource() > 0 then
            self.listView:scrollToCell(#self.adapter:dataSource(),1,true)
        end
    end
end
function emptyString(aString)
    return (not aString) or (#aString == 0)
end
function bitAnd(a,b)
    if b == 0 then
        return false
    end
    local res = math.floor(a / b)
    if (res % 2) == 1 then
        return true
    else
        return false
    end
end
function normalBtn(img)
    local btn = ImageView()
    btn:width(btn_w):height(btn_w)
    btn:marginTop(btn_m):marginRight(btn_m):marginBottom(btn_m)
    btn:image(img)
    return btn
end
function DebugLogger_luaCore:normalLevelBtn(title,level)
    local Checkbox = require('lua_pods.DebugLogger.DebugLogger_luaCore_checkCell')
    local box = Checkbox:new()
    box:initWithTitle(title)
    box.baseView:marginLeft(btn_m):marginTop(btn_m):marginRight(btn_m)
    if bitAnd(self.logLevel,level) then
        box:setSelected(true)
    end
    box.clickCallback = function(selected)
        box:setSelected(not selected)
        if selected then
            self.logLevel = self.logLevel - level
        else
            self.logLevel = self.logLevel + level
        end
    end
    return box
end
function enumerateArr(arr,callback)
    if not callback or not #arr then
        return
    end
    for i,v in ipairs(arr) do
        if callback(v,i) then
            break
        end
    end
end
function filterArr(arr,condition)
    local ret = {}
    if not condition or not #arr then
        enumerateArr(arr,function (obj,idx)
            table.insert(ret,obj)
        end)
        return ret
    end
    enumerateArr(arr,function (obj,index)
        if condition(obj,index) then
            table.insert(ret,obj)
        end
    end)
    return ret
end
function searchArr(arr,condition)
    local ret = {}
    if not condition or not #arr then
        enumerateArr(arr,function (obj,idx)
            table.insert(ret,idx)
        end)
        return ret
    end
    enumerateArr(arr,function (obj,idx)
        if condition(obj,idx) then
            table.insert(ret,idx)
        end
    end)
    return ret
end
function arr2dic(arr)
    local ret = {}
    if not #arr then
        return ret
    end
    enumerateArr(arr,function (obj,idx)
        ret[tostring(obj)] = obj
    end)
    return ret
end
function printArr(arr)
    enumerateArr(arr,function (v,i)
        print(i,'--',v)
    end)
end
function printDic(arr)
    for k,v in pairs(arr) do
        print(k,'--',v)
    end
end
return DebugLogger_luaCore
