local DebugLogger_luaCore_Cell = {}
DebugLogger_luaCore_Cell.baseView = nil
DebugLogger_luaCore_Cell.logLb = nil
function DebugLogger_luaCore_Cell:new ()
    local objc = {}
    setmetatable(objc,self)
    self.__index = self
    return objc
end
function DebugLogger_luaCore_Cell:init(cell)
    self.baseView = View()
    self.baseView:width(MeasurementType.MATCH_PARENT):height(MeasurementType.WRAP_CONTENT)
    cell.contentView:addView(self.baseView)
    local margin = 5
    self.logLb = Label()
    self.logLb:width(MeasurementType.WRAP_CONTENT):height(MeasurementType.WRAP_CONTENT)
    self.logLb:marginTop(margin):marginLeft(margin * 2):marginBottom(margin):marginRight(margin * 2)
    self.logLb:lines(0)
    self.logLb:textColor(Color():hex(0xf0f0f0))
    self.baseView:addView(self.logLb)
end
function DebugLogger_luaCore_Cell:updateData(data,highlight)
    local log = data['log']
    self.logLb:text(log)
    local type = data['type']
    if type == DebugLoggerFilter.Error then
        self.logLb:textColor(Color():hex(0xff0000))
    elseif type == DebugLoggerFilter.Info then
        self.logLb:textColor(Color():hex(0x00ff00))
    elseif type == DebugLoggerFilter.Warning then
        self.logLb:textColor(Color():hex(0xffff00))
    else
        self.logLb:textColor(Color():hex(0xf0f0f0))
    end
    if highlight then
        self.baseView:bgColor(Color(255,255,0,0.7))
    else
        self.baseView:bgColor(Color(0,0,0,0))
    end
end
function printT(dic)
    for k,v in pairs(dic) do
        print(k,v)
    end
end
return DebugLogger_luaCore_Cell
