local TYPE_CELL = {
    NORMAL = 'TYPE_CELL_NORMAL',
}
local DebugLogger_luaCore_adapter = {}
DebugLogger_luaCore_adapter.adapter = nil
DebugLogger_luaCore_adapter.datasource = {}
DebugLogger_luaCore_adapter.filteredDatasource = {}
DebugLogger_luaCore_adapter.highlighted = {}
DebugLogger_luaCore_adapter.currentHighlighted = 0
DebugLogger_luaCore_adapter.currentHighlightedIdx = 0
DebugLogger_luaCore_adapter.filterMode = false
function DebugLogger_luaCore_adapter:new()
    local objc = {}
    setmetatable(objc,self)
    self.__index = self
    return objc
end
function DebugLogger_luaCore_adapter:init()
    self:initAdapter()
end
function DebugLogger_luaCore_adapter:initAdapter()
    self.adapter = TableViewAutoFitAdapter()
    self.adapter:sectionCount(function()
        return 1
    end)
    self.adapter:rowCount(function(section)
        if not self:dataSource() then
            return 0
        end
        return #self:dataSource()
    end)
    self.adapter:reuseId(function (section,row)
        return TYPE_CELL.NORMAL
    end)
    self.adapter:initCellByReuseId(TYPE_CELL.NORMAL,function (cell)
        local LogCell = require('lua_pods.DebugLogger.DebugLogger_luaCore_Cell')
        local lC = LogCell:new()
        lC:init(cell)
        cell.currentCell = lC
        cell.contentView:bgColor(Color(0,0,0,0))
    end)
    self.adapter:fillCellDataByReuseId(TYPE_CELL.NORMAL,function (cell,section,row)
        local data = self:dataSource()[row]
        cell.currentCell:updateData(data,row == self.currentHighlighted)
    end)
end
function DebugLogger_luaCore_adapter:dataSource()
    if self.filterMode then
        return self.filteredDatasource
    end
    return self.datasource
end
function DebugLogger_luaCore_adapter:changeHighlightIndex(index)
    if self.currentHighlightedIdx ~= index then
        self.currentHighlightedIdx = index
        if index == 0 then
            self.highlighted = {}
            self.currentHighlighted = 0
        else
            self.currentHighlighted = self.highlighted[index]
        end
    end
end
return DebugLogger_luaCore_adapter
