local DebugLogger_luaCore_checkCell = {}
DebugLogger_luaCore_checkCell.baseView = nil
DebugLogger_luaCore_checkCell.icon = nil
DebugLogger_luaCore_checkCell.title = nil
DebugLogger_luaCore_checkCell.selected = false
DebugLogger_luaCore_checkCell.clickCallback = nil
function DebugLogger_luaCore_checkCell:new()
    local obj = {}
    setmetatable(obj,self)
    self.__index = self
    return obj
end
function DebugLogger_luaCore_checkCell:initWithTitle(title)
    self.baseView = LinearLayout(LinearType.HORIZONTAL)
    self.baseView:width(MeasurementType.WRAP_CONTENT):height(30)
    self.baseView:onClick(function ()
        if self.clickCallback then
            self.clickCallback(self.selected)
        end
    end)
    self.icon = ImageView()
    self.icon:width(30):height(30)
    self.icon:cornerRadius(5)
    self.icon:borderWidth(1)
    self.icon:borderColor(Color(0,0,0,1))
    self.baseView:addView(self.icon)
    self.title = Label()
    self.title:width(MeasurementType.WRAP_CONTENT):height(MeasurementType.WRAP_CONTENT):marginLeft(10):setGravity(Gravity.CENTER_VERTICAL)
    self.title:text(title)
    self.baseView:addView(self.title)
end
function DebugLogger_luaCore_checkCell:setSelected(sel)
    if self.selected ~= sel then
        self.selected = sel
        if sel then
            self.icon:image('https://s.momocdn.com/w/u/others/2019/03/20/1553064418623-check.png')
        else
            self.icon:image('')
        end
    end
end
return DebugLogger_luaCore_checkCell
