cordova.define("EvkNativeApp.EvkNativeApp", function(require, exports, module) {
var exec = require('cordova/exec');

/**
 * 检测是否安装某app
 * @param {String} pkgName 检测的包名
 * @param {Function} success 成功回调
 * @param {Function} error 失败毁掉
 */
exports.check = function (pkgName, success, error) {
  exec(success, error, 'EvkNativeApp', 'check', [pkgName]);
};

/**
 * 打开某app
 * @param {String} pkgName 需要打开的app包名
 * @param {String} uri  应用商店连接
 * @param {Function} success 成功回调
 * @param {Function} error 失败毁掉
 */
exports.start = function (pkgName, uri, success, error) {
  exec(success, error, 'EvkNativeApp', 'start', [pkgName, uri]);
};

/**
 * 打开系统浏览器
 * @param url 地址
 * @param {Function} success 成功回调
 * @param {Function} error 失败毁掉
 */
exports.browser = function (url, success, error) {
  exec(success, error, 'EvkNativeApp', 'browser', [url]);
};

});
