cordova.define("SeiyaSdk.SeiyaSdk", function(require, exports, module) {
var exec = require('cordova/exec');


/*
  eagleToken = {
    suc: string
    userID: string
    sdkUserID: string
    username: string
    sdkUsername: string
    token: string
    extension: string
  }
*/


/*
  orderResult = {
    order: string // 
    state: string // 状态
    msg: string   // 信息
    extension: string // 附加参数
  }
*/

/* document回调 */

// // 登录成功, e: eagleToken
// document.addEventListener("onLoginResult", function (e) {
//     console.log("==============onLoginResult" + e);
// }, false)


// // 登录失败, e: string = "登录失败"
// document.addEventListener("onLoginFail", function (e) {
//     console.log("==============onLoginFail" + e);
// }, false)


// // 切换账号, e: eagleToken
// document.addEventListener("onSwitchAccount", function (e) {
//     console.log("==============onSwitchAccount" + e);
// }, false)

// // 支付结果, e: orderResult
// document.addEventListener("onPayResult", function (e) {
//     console.log("==============onPayResult" + e);
// }, false)



/*  初始化接口
 *  isRelease: bool 是否商业化
 *  appId: string
 *  extParams: object 额外参数
 */
exports.init = function (isRelease, appId, extParams, success, error) {
  exec(success, error, 'SeiyaSdk', 'init', [isRelease, appId, extParams]);
};

/*  iOS初始化接口
 *  gameID: string          唤境游戏ID
 *  eagleAppID: string      老鹰APPID 
 *  eagleAppKey: string     老鹰APPKey
 *  eagleChannelID: string  老鹰渠道ID
 *  isSilence：number        1 静默登录    0 普遍弹窗               
 */
exports.iosInit = function (gameID, eagleAppID, eagleAppKey, eagleChannelID, isSilence, success, error) {
  exec(success, error, 'SeiyaSdk', 'iosInit', [gameID, eagleAppID, eagleAppKey, eagleChannelID, isSilence]);
}

/*  启动登录 */
exports.login = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'login', []);
};


/* 发起支付
 * param: JsonObject
 * {  
      buyNum: int           //购买数量 固定为1
      coinNum: int          //玩家身上拥有的游戏币数量，若无，传0
      extension: string     // //扩展参数,可用Json形式传递额外的参数 若无，传""
      price: int            //充值金额
      productId: string     //充值商品ID
      productName: string   //商品名称
      productDesc:string    //商品描述
      gameName: string      //游戏名称
      roleId: string        //角色id 若无，传""
      roleLevel: int        //角色等级
      roleName: string      // 角色名称 若无，传""
      serverId: string      //角色所在服务器id 若无，传""
      serverName: string    //角色所在服务器名称 若无，传""
      vip: string           //vip等级 ,若无，传“1”
      gameOrderID: string   //cp订单id
      payNotifyUrl: string  //支付回调地址， 若无，传""
      ratio: int            //兑换比例  若无，传1
   }

  success: string // 成功回调描述
  error: string   // 失败描述

 */
exports.pay = function (params, success, error) {
  exec(success, error, 'SeiyaSdk', 'pay', [params])
}

/*
 *  提交游戏数据
 *  param: JsonObject 
    {
       dataType: int            //上报类型
       roleID: string           //角色ID，如无，传""
       roleName: string         //角色名称，如无，传""
       roleLevel: string        //角色等级，如无，传""
       serverID: int            //角色所在服务器ID，如无，传0
       serverName: string       //角色所在服务器名称，如无，传""
       moneyNum: int            //角色身上拥有的游戏币数量
       roleCreateTime: long     //13位时间戳 毫秒
       roleLevelUpTime: long    //13位时间戳 毫秒
       vip: string              //VIP等级 ,如无，传"0"
       roleGender: int          // 0:男，1：女
       partyID: string          //帮会，公会ID 如无，传"0"
       partyMasterID: string    //帮会，公会会长ID 如无，传"0"
       partyName: string        //帮会，公会名称 如无，传"无"
       partyMasterName: string  //帮会，公会会长名称 如无，传"无"
    }
    dataType枚举：{
      int TYPE_SELECT_SERVER = 1; //选择服务器
      int TYPE_CREATE_ROLE = 2;   //创建角色
      int TYPE_ENTER_GAME = 3;    //进入游戏
      int TYPE_LEVEL_UP = 4;      //升级
      int TYPE_EXIT_GAME = 5;     //退出游戏
      int TYPE_ENTER_COPY = 6;    //进副本
      int TYPE_EXIT_COPY = 7;     //退出副本
      int TYPE_VIP_LEVELUP = 8;   //vip等级提升
    }
    success 和 error 可不实现
 */
exports.submitData = function (params, success, error) {
  exec(success, error, 'SeiyaSdk', 'submitData', [params])
}

/*  退出账号 */
exports.logout = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'logout', []);
};

/*  退出游戏 */
exports.gameExit = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'gameExit', []);
};

/*  切换账号 */
exports.switchAccount = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'switchAccount', []);
};

/*  广告初始化 */
exports.initAd = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'initAd', []);
};

/*  显示banner广告 */
exports.showBannerAd = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'showBannerAd', []);
};

/*  隐藏banner广告 */
exports.hideBannerAd = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'hideBannerAd', []);
};

/*  加载并显示视频广告 */
exports.showVideoAd = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'showVideoAd', []);
};

/*  显示插屏广告 */
exports.showInterstitialAd = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'showInterstitialAd', []);
};

/*  获取当前渠道ID */
exports.getChannelId = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'getChannelId', []);
};
/** 加载视频广告 */
exports.loadVideoAD = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'loadVideoAD', []);
}
/** 显示视频广告 */
exports.playVideoAD = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'playVideoAD', []);
}

exports.facebookShare = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'facebookShare', []);
}

exports.openMarketing = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'openMarketing', []);
}

exports.trackEvent = function (success, error) {
  exec(success, error, 'SeiyaSdk', 'trackEvent', []);
}


// 广告打点回调 

// 数据结构：{type: ADTrackType, data: JsonObject}

//type取值范围
// enum ADTrackType {
//         adLoad,
//         adReady,
//         adShow,
//         adFailed,
//         adClicked,
//         adClosed,
//         playStarted,
//         playCompleted,
//         playError;

// data 数据结构
// data: {"spaceid":"","pid":"", "type":"", "aid":"aid"}

/* 用法 */
/* document.addEventListener('onAdTrackResult', function (e) {
    if (typeof e.originalEvent !== 'undefined') e = e.originalEvent;
    var obj = e.detail || e.data || e;

    if (obj.type === "adLoad") {

    } else if (data.type === "adShow") {

    }
  });
*/
});
