#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 resolution;

vec4 
blur(vec2 p)
{
    vec2 unit = 1.0 / resolution.xy;

    vec3 weights[3];
    weights[0] = vec3(0.0625, 0.125, 0.0625);
    weights[1] = vec3(0.125, 0.25, 0.125);
    weights[2] = vec3(0.0625, 0.125, 0.0625);
    vec4 col = vec4(0);
        
    for(int x = -1; x <= 1; x++)
    {
        for(int y = -1; y <= 1; y++)
        {
            col += texture2D(CC_Texture0, p + vec2(float(x) * unit.x, float(y) * unit.y)) * weights[x + 1][y + 1];
        }        
    }
    return col;
}

void 
main( )
{
    vec4 col = blur(v_texCoord); //* v_fragmentColor.rgb;
    gl_FragColor = vec4(col) * v_fragmentColor;
}
