#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 resolution;

vec4 
blur(vec2 p)
{
    vec2 unit = 1.0 / resolution.xy;

    float weight1[5];
    weight1[0] = 1.0/256.0;
    weight1[1] = 4.0/256.0;
    weight1[2] = 6.0/256.0;
    weight1[3] = 4.0/256.0;
    weight1[4] = 1.0/256.0;

    float weight2[5];
    weight2[0] = 4.0/256.0;
    weight2[1] = 16.0/256.0;
    weight2[2] = 24.0/256.0;
    weight2[3] = 16.0/256.0;
    weight2[4] = 4.0/256.0;

    float weight3[5];
    weight3[0] = 6.0/256.0;
    weight3[1] = 24.0/256.0;
    weight3[2] = 36.0/256.0;
    weight3[3] = 24.0/256.0;
    weight3[4] = 6.0/256.0;

   vec4 col = vec4(0);
        
    for(int x = -2; x <= 2; x++)
    {
        for(int y = -2; y <= 2; y++)
        {
            float weight = 0.0;
            if (x == -2 || x == 2)
            {
                weight = weight1[y + 2];
            }
            else if (x == -1 || x == 1)
            {
                weight = weight2[y + 2];
            }
            else
            {
                weight = weight3[y + 2];
            }
            col += texture2D(CC_Texture0, p + vec2(float(x) * unit.x, float(y) * unit.y)) * weight;
        }        
    }
    return col;
}

void 
main( )
{
    vec4 col = blur(v_texCoord); //* v_fragmentColor.rgb;
    gl_FragColor = vec4(col) * v_fragmentColor;
}
