#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform float u_ctime;
uniform float u_threshold;
uniform float u_weight;
uniform int u_radius;
uniform vec4  u_glowColor;
uniform vec2  u_resolution;

void
main()
{
    vec2 unit = 1.0 / u_resolution.xy;
    
    vec4 accum = vec4(0.0);
    float radius = float(u_radius);
    
    vec4 orgColor = texture2D(CC_Texture0, v_texCoord);
    
    for (int x = -1 * u_radius; x <= u_radius; x += 1)
    {
        for (int y = -1 * u_radius; y <= u_radius; y+= 1)
        {
            // 自分の座標はすでに取ってる
            if (x == 0 && y == 0)
            {
                continue;
            }
            vec4 texColor = texture2D(CC_Texture0, vec2(v_texCoord.x + unit.x * float(x), v_texCoord.y + unit.y * float(y)));
            vec4 tmp = texColor / (radius * radius - 1.0);
            tmp.a *= u_weight;
            accum += tmp;
        }
    }
//    accum.rgb = u_glowColor.rgb * u_glowColor.a * accum.a ;
    accum.rgb = u_glowColor.rgb * accum.a ;
    float opacity = (1.0 - orgColor.a) * (u_ctime / u_threshold);

    orgColor = (accum * opacity) + (orgColor * orgColor.a);
    
    gl_FragColor = v_fragmentColor * orgColor;
}
